<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/gkebackup/v1/restore.proto

namespace Google\Cloud\GkeBackup\V1\RestoreConfig;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * A transformation rule to be applied against Kubernetes resources as they
 * are selected for restoration from a Backup. A rule contains both filtering
 * logic (which resources are subject to substitution) and substitution logic.
 *
 * Generated from protobuf message <code>google.cloud.gkebackup.v1.RestoreConfig.SubstitutionRule</code>
 */
class SubstitutionRule extends \Google\Protobuf\Internal\Message
{
    /**
     * Optional. (Filtering parameter) Any resource subject to substitution must
     * be contained within one of the listed Kubernetes Namespace in the Backup.
     * If this field is not provided, no namespace filtering will be performed
     * (all resources in all Namespaces, including all cluster-scoped resources,
     * will be candidates for substitution).
     * To mix cluster-scoped and namespaced resources in the same rule, use an
     * empty string ("") as one of the target namespaces.
     *
     * Generated from protobuf field <code>repeated string target_namespaces = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $target_namespaces;
    /**
     * Optional. (Filtering parameter) Any resource subject to substitution must
     * belong to one of the listed "types". If this field is not provided, no
     * type filtering will be performed (all resources of all types matching
     * previous filtering parameters will be candidates for substitution).
     *
     * Generated from protobuf field <code>repeated .google.cloud.gkebackup.v1.RestoreConfig.GroupKind target_group_kinds = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $target_group_kinds;
    /**
     * Required. This is a [JSONPath]
     * (https://kubernetes.io/docs/reference/kubectl/jsonpath/)
     * expression that matches specific fields of candidate
     * resources and it operates as both a filtering parameter (resources that
     * are not matched with this expression will not be candidates for
     * substitution) as well as a field identifier (identifies exactly which
     * fields out of the candidate resources will be modified).
     *
     * Generated from protobuf field <code>string target_json_path = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $target_json_path = '';
    /**
     * Optional. (Filtering parameter) This is a [regular expression]
     * (https://en.wikipedia.org/wiki/Regular_expression)
     * that is compared against the fields matched by the target_json_path
     * expression (and must also have passed the previous filters).
     * Substitution will not be performed against fields whose
     * value does not match this expression. If this field is NOT specified,
     * then ALL fields matched by the target_json_path expression will undergo
     * substitution. Note that an empty (e.g., "", rather than unspecified)
     * value for this field will only match empty fields.
     *
     * Generated from protobuf field <code>string original_value_pattern = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $original_value_pattern = '';
    /**
     * Optional. This is the new value to set for any fields that pass the
     * filtering and selection criteria. To remove a value from a Kubernetes
     * resource, either leave this field unspecified, or set it to the empty
     * string ("").
     *
     * Generated from protobuf field <code>string new_value = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $new_value = '';

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $target_namespaces
     *           Optional. (Filtering parameter) Any resource subject to substitution must
     *           be contained within one of the listed Kubernetes Namespace in the Backup.
     *           If this field is not provided, no namespace filtering will be performed
     *           (all resources in all Namespaces, including all cluster-scoped resources,
     *           will be candidates for substitution).
     *           To mix cluster-scoped and namespaced resources in the same rule, use an
     *           empty string ("") as one of the target namespaces.
     *     @type array<\Google\Cloud\GkeBackup\V1\RestoreConfig\GroupKind>|\Google\Protobuf\Internal\RepeatedField $target_group_kinds
     *           Optional. (Filtering parameter) Any resource subject to substitution must
     *           belong to one of the listed "types". If this field is not provided, no
     *           type filtering will be performed (all resources of all types matching
     *           previous filtering parameters will be candidates for substitution).
     *     @type string $target_json_path
     *           Required. This is a [JSONPath]
     *           (https://kubernetes.io/docs/reference/kubectl/jsonpath/)
     *           expression that matches specific fields of candidate
     *           resources and it operates as both a filtering parameter (resources that
     *           are not matched with this expression will not be candidates for
     *           substitution) as well as a field identifier (identifies exactly which
     *           fields out of the candidate resources will be modified).
     *     @type string $original_value_pattern
     *           Optional. (Filtering parameter) This is a [regular expression]
     *           (https://en.wikipedia.org/wiki/Regular_expression)
     *           that is compared against the fields matched by the target_json_path
     *           expression (and must also have passed the previous filters).
     *           Substitution will not be performed against fields whose
     *           value does not match this expression. If this field is NOT specified,
     *           then ALL fields matched by the target_json_path expression will undergo
     *           substitution. Note that an empty (e.g., "", rather than unspecified)
     *           value for this field will only match empty fields.
     *     @type string $new_value
     *           Optional. This is the new value to set for any fields that pass the
     *           filtering and selection criteria. To remove a value from a Kubernetes
     *           resource, either leave this field unspecified, or set it to the empty
     *           string ("").
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Gkebackup\V1\Restore::initOnce();
        parent::__construct($data);
    }

    /**
     * Optional. (Filtering parameter) Any resource subject to substitution must
     * be contained within one of the listed Kubernetes Namespace in the Backup.
     * If this field is not provided, no namespace filtering will be performed
     * (all resources in all Namespaces, including all cluster-scoped resources,
     * will be candidates for substitution).
     * To mix cluster-scoped and namespaced resources in the same rule, use an
     * empty string ("") as one of the target namespaces.
     *
     * Generated from protobuf field <code>repeated string target_namespaces = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getTargetNamespaces()
    {
        return $this->target_namespaces;
    }

    /**
     * Optional. (Filtering parameter) Any resource subject to substitution must
     * be contained within one of the listed Kubernetes Namespace in the Backup.
     * If this field is not provided, no namespace filtering will be performed
     * (all resources in all Namespaces, including all cluster-scoped resources,
     * will be candidates for substitution).
     * To mix cluster-scoped and namespaced resources in the same rule, use an
     * empty string ("") as one of the target namespaces.
     *
     * Generated from protobuf field <code>repeated string target_namespaces = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setTargetNamespaces($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->target_namespaces = $arr;

        return $this;
    }

    /**
     * Optional. (Filtering parameter) Any resource subject to substitution must
     * belong to one of the listed "types". If this field is not provided, no
     * type filtering will be performed (all resources of all types matching
     * previous filtering parameters will be candidates for substitution).
     *
     * Generated from protobuf field <code>repeated .google.cloud.gkebackup.v1.RestoreConfig.GroupKind target_group_kinds = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getTargetGroupKinds()
    {
        return $this->target_group_kinds;
    }

    /**
     * Optional. (Filtering parameter) Any resource subject to substitution must
     * belong to one of the listed "types". If this field is not provided, no
     * type filtering will be performed (all resources of all types matching
     * previous filtering parameters will be candidates for substitution).
     *
     * Generated from protobuf field <code>repeated .google.cloud.gkebackup.v1.RestoreConfig.GroupKind target_group_kinds = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array<\Google\Cloud\GkeBackup\V1\RestoreConfig\GroupKind>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setTargetGroupKinds($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\GkeBackup\V1\RestoreConfig\GroupKind::class);
        $this->target_group_kinds = $arr;

        return $this;
    }

    /**
     * Required. This is a [JSONPath]
     * (https://kubernetes.io/docs/reference/kubectl/jsonpath/)
     * expression that matches specific fields of candidate
     * resources and it operates as both a filtering parameter (resources that
     * are not matched with this expression will not be candidates for
     * substitution) as well as a field identifier (identifies exactly which
     * fields out of the candidate resources will be modified).
     *
     * Generated from protobuf field <code>string target_json_path = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getTargetJsonPath()
    {
        return $this->target_json_path;
    }

    /**
     * Required. This is a [JSONPath]
     * (https://kubernetes.io/docs/reference/kubectl/jsonpath/)
     * expression that matches specific fields of candidate
     * resources and it operates as both a filtering parameter (resources that
     * are not matched with this expression will not be candidates for
     * substitution) as well as a field identifier (identifies exactly which
     * fields out of the candidate resources will be modified).
     *
     * Generated from protobuf field <code>string target_json_path = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setTargetJsonPath($var)
    {
        GPBUtil::checkString($var, True);
        $this->target_json_path = $var;

        return $this;
    }

    /**
     * Optional. (Filtering parameter) This is a [regular expression]
     * (https://en.wikipedia.org/wiki/Regular_expression)
     * that is compared against the fields matched by the target_json_path
     * expression (and must also have passed the previous filters).
     * Substitution will not be performed against fields whose
     * value does not match this expression. If this field is NOT specified,
     * then ALL fields matched by the target_json_path expression will undergo
     * substitution. Note that an empty (e.g., "", rather than unspecified)
     * value for this field will only match empty fields.
     *
     * Generated from protobuf field <code>string original_value_pattern = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getOriginalValuePattern()
    {
        return $this->original_value_pattern;
    }

    /**
     * Optional. (Filtering parameter) This is a [regular expression]
     * (https://en.wikipedia.org/wiki/Regular_expression)
     * that is compared against the fields matched by the target_json_path
     * expression (and must also have passed the previous filters).
     * Substitution will not be performed against fields whose
     * value does not match this expression. If this field is NOT specified,
     * then ALL fields matched by the target_json_path expression will undergo
     * substitution. Note that an empty (e.g., "", rather than unspecified)
     * value for this field will only match empty fields.
     *
     * Generated from protobuf field <code>string original_value_pattern = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setOriginalValuePattern($var)
    {
        GPBUtil::checkString($var, True);
        $this->original_value_pattern = $var;

        return $this;
    }

    /**
     * Optional. This is the new value to set for any fields that pass the
     * filtering and selection criteria. To remove a value from a Kubernetes
     * resource, either leave this field unspecified, or set it to the empty
     * string ("").
     *
     * Generated from protobuf field <code>string new_value = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getNewValue()
    {
        return $this->new_value;
    }

    /**
     * Optional. This is the new value to set for any fields that pass the
     * filtering and selection criteria. To remove a value from a Kubernetes
     * resource, either leave this field unspecified, or set it to the empty
     * string ("").
     *
     * Generated from protobuf field <code>string new_value = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setNewValue($var)
    {
        GPBUtil::checkString($var, True);
        $this->new_value = $var;

        return $this;
    }

}


