<?php
/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/eventarc/v1/eventarc.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\Eventarc\V1\Client;

use Google\ApiCore\ApiException;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\OperationResponse;
use Google\ApiCore\PagedListResponse;
use Google\ApiCore\ResourceHelperTrait;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\Eventarc\V1\Channel;
use Google\Cloud\Eventarc\V1\ChannelConnection;
use Google\Cloud\Eventarc\V1\CreateChannelConnectionRequest;
use Google\Cloud\Eventarc\V1\CreateChannelRequest;
use Google\Cloud\Eventarc\V1\CreateEnrollmentRequest;
use Google\Cloud\Eventarc\V1\CreateGoogleApiSourceRequest;
use Google\Cloud\Eventarc\V1\CreateMessageBusRequest;
use Google\Cloud\Eventarc\V1\CreatePipelineRequest;
use Google\Cloud\Eventarc\V1\CreateTriggerRequest;
use Google\Cloud\Eventarc\V1\DeleteChannelConnectionRequest;
use Google\Cloud\Eventarc\V1\DeleteChannelRequest;
use Google\Cloud\Eventarc\V1\DeleteEnrollmentRequest;
use Google\Cloud\Eventarc\V1\DeleteGoogleApiSourceRequest;
use Google\Cloud\Eventarc\V1\DeleteMessageBusRequest;
use Google\Cloud\Eventarc\V1\DeletePipelineRequest;
use Google\Cloud\Eventarc\V1\DeleteTriggerRequest;
use Google\Cloud\Eventarc\V1\Enrollment;
use Google\Cloud\Eventarc\V1\GetChannelConnectionRequest;
use Google\Cloud\Eventarc\V1\GetChannelRequest;
use Google\Cloud\Eventarc\V1\GetEnrollmentRequest;
use Google\Cloud\Eventarc\V1\GetGoogleApiSourceRequest;
use Google\Cloud\Eventarc\V1\GetGoogleChannelConfigRequest;
use Google\Cloud\Eventarc\V1\GetMessageBusRequest;
use Google\Cloud\Eventarc\V1\GetPipelineRequest;
use Google\Cloud\Eventarc\V1\GetProviderRequest;
use Google\Cloud\Eventarc\V1\GetTriggerRequest;
use Google\Cloud\Eventarc\V1\GoogleApiSource;
use Google\Cloud\Eventarc\V1\GoogleChannelConfig;
use Google\Cloud\Eventarc\V1\ListChannelConnectionsRequest;
use Google\Cloud\Eventarc\V1\ListChannelsRequest;
use Google\Cloud\Eventarc\V1\ListEnrollmentsRequest;
use Google\Cloud\Eventarc\V1\ListGoogleApiSourcesRequest;
use Google\Cloud\Eventarc\V1\ListMessageBusEnrollmentsRequest;
use Google\Cloud\Eventarc\V1\ListMessageBusesRequest;
use Google\Cloud\Eventarc\V1\ListPipelinesRequest;
use Google\Cloud\Eventarc\V1\ListProvidersRequest;
use Google\Cloud\Eventarc\V1\ListTriggersRequest;
use Google\Cloud\Eventarc\V1\MessageBus;
use Google\Cloud\Eventarc\V1\Pipeline;
use Google\Cloud\Eventarc\V1\Provider;
use Google\Cloud\Eventarc\V1\Trigger;
use Google\Cloud\Eventarc\V1\UpdateChannelRequest;
use Google\Cloud\Eventarc\V1\UpdateEnrollmentRequest;
use Google\Cloud\Eventarc\V1\UpdateGoogleApiSourceRequest;
use Google\Cloud\Eventarc\V1\UpdateGoogleChannelConfigRequest;
use Google\Cloud\Eventarc\V1\UpdateMessageBusRequest;
use Google\Cloud\Eventarc\V1\UpdatePipelineRequest;
use Google\Cloud\Eventarc\V1\UpdateTriggerRequest;
use Google\Cloud\Iam\V1\GetIamPolicyRequest;
use Google\Cloud\Iam\V1\Policy;
use Google\Cloud\Iam\V1\SetIamPolicyRequest;
use Google\Cloud\Iam\V1\TestIamPermissionsRequest;
use Google\Cloud\Iam\V1\TestIamPermissionsResponse;
use Google\Cloud\Location\GetLocationRequest;
use Google\Cloud\Location\ListLocationsRequest;
use Google\Cloud\Location\Location;
use Google\LongRunning\Client\OperationsClient;
use Google\LongRunning\Operation;
use GuzzleHttp\Promise\PromiseInterface;

/**
 * Service Description: Eventarc allows users to subscribe to various events that are provided by
 * Google Cloud services and forward them to supported destinations.
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods.
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 *
 * @method PromiseInterface createChannelAsync(CreateChannelRequest $request, array $optionalArgs = [])
 * @method PromiseInterface createChannelConnectionAsync(CreateChannelConnectionRequest $request, array $optionalArgs = [])
 * @method PromiseInterface createEnrollmentAsync(CreateEnrollmentRequest $request, array $optionalArgs = [])
 * @method PromiseInterface createGoogleApiSourceAsync(CreateGoogleApiSourceRequest $request, array $optionalArgs = [])
 * @method PromiseInterface createMessageBusAsync(CreateMessageBusRequest $request, array $optionalArgs = [])
 * @method PromiseInterface createPipelineAsync(CreatePipelineRequest $request, array $optionalArgs = [])
 * @method PromiseInterface createTriggerAsync(CreateTriggerRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deleteChannelAsync(DeleteChannelRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deleteChannelConnectionAsync(DeleteChannelConnectionRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deleteEnrollmentAsync(DeleteEnrollmentRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deleteGoogleApiSourceAsync(DeleteGoogleApiSourceRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deleteMessageBusAsync(DeleteMessageBusRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deletePipelineAsync(DeletePipelineRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deleteTriggerAsync(DeleteTriggerRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getChannelAsync(GetChannelRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getChannelConnectionAsync(GetChannelConnectionRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getEnrollmentAsync(GetEnrollmentRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getGoogleApiSourceAsync(GetGoogleApiSourceRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getGoogleChannelConfigAsync(GetGoogleChannelConfigRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getMessageBusAsync(GetMessageBusRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getPipelineAsync(GetPipelineRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getProviderAsync(GetProviderRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getTriggerAsync(GetTriggerRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listChannelConnectionsAsync(ListChannelConnectionsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listChannelsAsync(ListChannelsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listEnrollmentsAsync(ListEnrollmentsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listGoogleApiSourcesAsync(ListGoogleApiSourcesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listMessageBusEnrollmentsAsync(ListMessageBusEnrollmentsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listMessageBusesAsync(ListMessageBusesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listPipelinesAsync(ListPipelinesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listProvidersAsync(ListProvidersRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listTriggersAsync(ListTriggersRequest $request, array $optionalArgs = [])
 * @method PromiseInterface updateChannelAsync(UpdateChannelRequest $request, array $optionalArgs = [])
 * @method PromiseInterface updateEnrollmentAsync(UpdateEnrollmentRequest $request, array $optionalArgs = [])
 * @method PromiseInterface updateGoogleApiSourceAsync(UpdateGoogleApiSourceRequest $request, array $optionalArgs = [])
 * @method PromiseInterface updateGoogleChannelConfigAsync(UpdateGoogleChannelConfigRequest $request, array $optionalArgs = [])
 * @method PromiseInterface updateMessageBusAsync(UpdateMessageBusRequest $request, array $optionalArgs = [])
 * @method PromiseInterface updatePipelineAsync(UpdatePipelineRequest $request, array $optionalArgs = [])
 * @method PromiseInterface updateTriggerAsync(UpdateTriggerRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getLocationAsync(GetLocationRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listLocationsAsync(ListLocationsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getIamPolicyAsync(GetIamPolicyRequest $request, array $optionalArgs = [])
 * @method PromiseInterface setIamPolicyAsync(SetIamPolicyRequest $request, array $optionalArgs = [])
 * @method PromiseInterface testIamPermissionsAsync(TestIamPermissionsRequest $request, array $optionalArgs = [])
 */
final class EventarcClient
{
    use GapicClientTrait;
    use ResourceHelperTrait;

    /** The name of the service. */
    private const SERVICE_NAME = 'google.cloud.eventarc.v1.Eventarc';

    /**
     * The default address of the service.
     *
     * @deprecated SERVICE_ADDRESS_TEMPLATE should be used instead.
     */
    private const SERVICE_ADDRESS = 'eventarc.googleapis.com';

    /** The address template of the service. */
    private const SERVICE_ADDRESS_TEMPLATE = 'eventarc.UNIVERSE_DOMAIN';

    /** The default port of the service. */
    private const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    private const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = ['https://www.googleapis.com/auth/cloud-platform'];

    private $operationsClient;

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' => self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' => __DIR__ . '/../resources/eventarc_client_config.json',
            'descriptorsConfigPath' => __DIR__ . '/../resources/eventarc_descriptor_config.php',
            'gcpApiConfigPath' => __DIR__ . '/../resources/eventarc_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' => __DIR__ . '/../resources/eventarc_rest_client_config.php',
                ],
            ],
        ];
    }

    /**
     * Return an OperationsClient object with the same endpoint as $this.
     *
     * @return OperationsClient
     */
    public function getOperationsClient()
    {
        return $this->operationsClient;
    }

    /**
     * Resume an existing long running operation that was previously started by a long
     * running API method. If $methodName is not provided, or does not match a long
     * running API method, then the operation can still be resumed, but the
     * OperationResponse object will not deserialize the final response.
     *
     * @param string $operationName The name of the long running operation
     * @param string $methodName    The name of the method used to start the operation
     *
     * @return OperationResponse
     */
    public function resumeOperation($operationName, $methodName = null)
    {
        $options = isset($this->descriptors[$methodName]['longRunning'])
            ? $this->descriptors[$methodName]['longRunning']
            : [];
        $operation = new OperationResponse($operationName, $this->getOperationsClient(), $options);
        $operation->reload();
        return $operation;
    }

    /**
     * Create the default operation client for the service.
     *
     * @param array $options ClientOptions for the client.
     *
     * @return OperationsClient
     */
    private function createOperationsClient(array $options)
    {
        // Unset client-specific configuration options
        unset($options['serviceName'], $options['clientConfig'], $options['descriptorsConfigPath']);

        if (isset($options['operationsClient'])) {
            return $options['operationsClient'];
        }

        return new OperationsClient($options);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a channel
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $channel
     *
     * @return string The formatted channel resource.
     */
    public static function channelName(string $project, string $location, string $channel): string
    {
        return self::getPathTemplate('channel')->render([
            'project' => $project,
            'location' => $location,
            'channel' => $channel,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * channel_connection resource.
     *
     * @param string $project
     * @param string $location
     * @param string $channelConnection
     *
     * @return string The formatted channel_connection resource.
     */
    public static function channelConnectionName(string $project, string $location, string $channelConnection): string
    {
        return self::getPathTemplate('channelConnection')->render([
            'project' => $project,
            'location' => $location,
            'channel_connection' => $channelConnection,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * cloud_function resource.
     *
     * @param string $project
     * @param string $location
     * @param string $function
     *
     * @return string The formatted cloud_function resource.
     */
    public static function cloudFunctionName(string $project, string $location, string $function): string
    {
        return self::getPathTemplate('cloudFunction')->render([
            'project' => $project,
            'location' => $location,
            'function' => $function,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a crypto_key
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $keyRing
     * @param string $cryptoKey
     *
     * @return string The formatted crypto_key resource.
     */
    public static function cryptoKeyName(string $project, string $location, string $keyRing, string $cryptoKey): string
    {
        return self::getPathTemplate('cryptoKey')->render([
            'project' => $project,
            'location' => $location,
            'key_ring' => $keyRing,
            'crypto_key' => $cryptoKey,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a enrollment
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $enrollment
     *
     * @return string The formatted enrollment resource.
     */
    public static function enrollmentName(string $project, string $location, string $enrollment): string
    {
        return self::getPathTemplate('enrollment')->render([
            'project' => $project,
            'location' => $location,
            'enrollment' => $enrollment,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * google_api_source resource.
     *
     * @param string $project
     * @param string $location
     * @param string $googleApiSource
     *
     * @return string The formatted google_api_source resource.
     */
    public static function googleApiSourceName(string $project, string $location, string $googleApiSource): string
    {
        return self::getPathTemplate('googleApiSource')->render([
            'project' => $project,
            'location' => $location,
            'google_api_source' => $googleApiSource,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * google_channel_config resource.
     *
     * @param string $project
     * @param string $location
     *
     * @return string The formatted google_channel_config resource.
     */
    public static function googleChannelConfigName(string $project, string $location): string
    {
        return self::getPathTemplate('googleChannelConfig')->render([
            'project' => $project,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a location
     * resource.
     *
     * @param string $project
     * @param string $location
     *
     * @return string The formatted location resource.
     */
    public static function locationName(string $project, string $location): string
    {
        return self::getPathTemplate('location')->render([
            'project' => $project,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a message_bus
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $messageBus
     *
     * @return string The formatted message_bus resource.
     */
    public static function messageBusName(string $project, string $location, string $messageBus): string
    {
        return self::getPathTemplate('messageBus')->render([
            'project' => $project,
            'location' => $location,
            'message_bus' => $messageBus,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * network_attachment resource.
     *
     * @param string $project
     * @param string $region
     * @param string $networkattachment
     *
     * @return string The formatted network_attachment resource.
     */
    public static function networkAttachmentName(string $project, string $region, string $networkattachment): string
    {
        return self::getPathTemplate('networkAttachment')->render([
            'project' => $project,
            'region' => $region,
            'networkattachment' => $networkattachment,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a pipeline
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $pipeline
     *
     * @return string The formatted pipeline resource.
     */
    public static function pipelineName(string $project, string $location, string $pipeline): string
    {
        return self::getPathTemplate('pipeline')->render([
            'project' => $project,
            'location' => $location,
            'pipeline' => $pipeline,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a provider
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $provider
     *
     * @return string The formatted provider resource.
     */
    public static function providerName(string $project, string $location, string $provider): string
    {
        return self::getPathTemplate('provider')->render([
            'project' => $project,
            'location' => $location,
            'provider' => $provider,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * service_account resource.
     *
     * @param string $project
     * @param string $serviceAccount
     *
     * @return string The formatted service_account resource.
     */
    public static function serviceAccountName(string $project, string $serviceAccount): string
    {
        return self::getPathTemplate('serviceAccount')->render([
            'project' => $project,
            'service_account' => $serviceAccount,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a topic
     * resource.
     *
     * @param string $project
     * @param string $topic
     *
     * @return string The formatted topic resource.
     */
    public static function topicName(string $project, string $topic): string
    {
        return self::getPathTemplate('topic')->render([
            'project' => $project,
            'topic' => $topic,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a trigger
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $trigger
     *
     * @return string The formatted trigger resource.
     */
    public static function triggerName(string $project, string $location, string $trigger): string
    {
        return self::getPathTemplate('trigger')->render([
            'project' => $project,
            'location' => $location,
            'trigger' => $trigger,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a workflow
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $workflow
     *
     * @return string The formatted workflow resource.
     */
    public static function workflowName(string $project, string $location, string $workflow): string
    {
        return self::getPathTemplate('workflow')->render([
            'project' => $project,
            'location' => $location,
            'workflow' => $workflow,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - channel: projects/{project}/locations/{location}/channels/{channel}
     * - channelConnection: projects/{project}/locations/{location}/channelConnections/{channel_connection}
     * - cloudFunction: projects/{project}/locations/{location}/functions/{function}
     * - cryptoKey: projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}
     * - enrollment: projects/{project}/locations/{location}/enrollments/{enrollment}
     * - googleApiSource: projects/{project}/locations/{location}/googleApiSources/{google_api_source}
     * - googleChannelConfig: projects/{project}/locations/{location}/googleChannelConfig
     * - location: projects/{project}/locations/{location}
     * - messageBus: projects/{project}/locations/{location}/messageBuses/{message_bus}
     * - networkAttachment: projects/{project}/regions/{region}/networkAttachments/{networkattachment}
     * - pipeline: projects/{project}/locations/{location}/pipelines/{pipeline}
     * - provider: projects/{project}/locations/{location}/providers/{provider}
     * - serviceAccount: projects/{project}/serviceAccounts/{service_account}
     * - topic: projects/{project}/topics/{topic}
     * - trigger: projects/{project}/locations/{location}/triggers/{trigger}
     * - workflow: projects/{project}/locations/{location}/workflows/{workflow}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string $formattedName The formatted name string
     * @param string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName(string $formattedName, string $template = null): array
    {
        return self::parseFormattedName($formattedName, $template);
    }

    /**
     * Constructor.
     *
     * @param array $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'eventarc.googleapis.com:443'.
     *     @type string|array|FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           The credentials to be used by the client to authorize API calls. This option
     *           accepts either a path to a credentials file, or a decoded credentials file as a
     *           PHP array.
     *           *Advanced usage*: In addition, this option can also accept a pre-constructed
     *           {@see \Google\Auth\FetchAuthTokenInterface} object or
     *           {@see \Google\ApiCore\CredentialsWrapper} object. Note that when one of these
     *           objects are provided, any settings in $credentialsConfig will be ignored.
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
        $this->operationsClient = $this->createOperationsClient($clientOptions);
    }

    /** Handles execution of the async variants for each documented method. */
    public function __call($method, $args)
    {
        if (substr($method, -5) !== 'Async') {
            trigger_error('Call to undefined method ' . __CLASS__ . "::$method()", E_USER_ERROR);
        }

        array_unshift($args, substr($method, 0, -5));
        return call_user_func_array([$this, 'startAsyncCall'], $args);
    }

    /**
     * Create a new channel in a particular project and location.
     *
     * The async variant is {@see EventarcClient::createChannelAsync()} .
     *
     * @example samples/V1/EventarcClient/create_channel.php
     *
     * @param CreateChannelRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createChannel(CreateChannelRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreateChannel', $request, $callOptions)->wait();
    }

    /**
     * Create a new ChannelConnection in a particular project and location.
     *
     * The async variant is {@see EventarcClient::createChannelConnectionAsync()} .
     *
     * @example samples/V1/EventarcClient/create_channel_connection.php
     *
     * @param CreateChannelConnectionRequest $request     A request to house fields associated with the call.
     * @param array                          $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createChannelConnection(
        CreateChannelConnectionRequest $request,
        array $callOptions = []
    ): OperationResponse {
        return $this->startApiCall('CreateChannelConnection', $request, $callOptions)->wait();
    }

    /**
     * Create a new Enrollment in a particular project and location.
     *
     * The async variant is {@see EventarcClient::createEnrollmentAsync()} .
     *
     * @example samples/V1/EventarcClient/create_enrollment.php
     *
     * @param CreateEnrollmentRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createEnrollment(CreateEnrollmentRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreateEnrollment', $request, $callOptions)->wait();
    }

    /**
     * Create a new GoogleApiSource in a particular project and location.
     *
     * The async variant is {@see EventarcClient::createGoogleApiSourceAsync()} .
     *
     * @example samples/V1/EventarcClient/create_google_api_source.php
     *
     * @param CreateGoogleApiSourceRequest $request     A request to house fields associated with the call.
     * @param array                        $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createGoogleApiSource(
        CreateGoogleApiSourceRequest $request,
        array $callOptions = []
    ): OperationResponse {
        return $this->startApiCall('CreateGoogleApiSource', $request, $callOptions)->wait();
    }

    /**
     * Create a new MessageBus in a particular project and location.
     *
     * The async variant is {@see EventarcClient::createMessageBusAsync()} .
     *
     * @example samples/V1/EventarcClient/create_message_bus.php
     *
     * @param CreateMessageBusRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createMessageBus(CreateMessageBusRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreateMessageBus', $request, $callOptions)->wait();
    }

    /**
     * Create a new Pipeline in a particular project and location.
     *
     * The async variant is {@see EventarcClient::createPipelineAsync()} .
     *
     * @example samples/V1/EventarcClient/create_pipeline.php
     *
     * @param CreatePipelineRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createPipeline(CreatePipelineRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreatePipeline', $request, $callOptions)->wait();
    }

    /**
     * Create a new trigger in a particular project and location.
     *
     * The async variant is {@see EventarcClient::createTriggerAsync()} .
     *
     * @example samples/V1/EventarcClient/create_trigger.php
     *
     * @param CreateTriggerRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createTrigger(CreateTriggerRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreateTrigger', $request, $callOptions)->wait();
    }

    /**
     * Delete a single channel.
     *
     * The async variant is {@see EventarcClient::deleteChannelAsync()} .
     *
     * @example samples/V1/EventarcClient/delete_channel.php
     *
     * @param DeleteChannelRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteChannel(DeleteChannelRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeleteChannel', $request, $callOptions)->wait();
    }

    /**
     * Delete a single ChannelConnection.
     *
     * The async variant is {@see EventarcClient::deleteChannelConnectionAsync()} .
     *
     * @example samples/V1/EventarcClient/delete_channel_connection.php
     *
     * @param DeleteChannelConnectionRequest $request     A request to house fields associated with the call.
     * @param array                          $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteChannelConnection(
        DeleteChannelConnectionRequest $request,
        array $callOptions = []
    ): OperationResponse {
        return $this->startApiCall('DeleteChannelConnection', $request, $callOptions)->wait();
    }

    /**
     * Delete a single Enrollment.
     *
     * The async variant is {@see EventarcClient::deleteEnrollmentAsync()} .
     *
     * @example samples/V1/EventarcClient/delete_enrollment.php
     *
     * @param DeleteEnrollmentRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteEnrollment(DeleteEnrollmentRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeleteEnrollment', $request, $callOptions)->wait();
    }

    /**
     * Delete a single GoogleApiSource.
     *
     * The async variant is {@see EventarcClient::deleteGoogleApiSourceAsync()} .
     *
     * @example samples/V1/EventarcClient/delete_google_api_source.php
     *
     * @param DeleteGoogleApiSourceRequest $request     A request to house fields associated with the call.
     * @param array                        $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteGoogleApiSource(
        DeleteGoogleApiSourceRequest $request,
        array $callOptions = []
    ): OperationResponse {
        return $this->startApiCall('DeleteGoogleApiSource', $request, $callOptions)->wait();
    }

    /**
     * Delete a single message bus.
     *
     * The async variant is {@see EventarcClient::deleteMessageBusAsync()} .
     *
     * @example samples/V1/EventarcClient/delete_message_bus.php
     *
     * @param DeleteMessageBusRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteMessageBus(DeleteMessageBusRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeleteMessageBus', $request, $callOptions)->wait();
    }

    /**
     * Delete a single pipeline.
     *
     * The async variant is {@see EventarcClient::deletePipelineAsync()} .
     *
     * @example samples/V1/EventarcClient/delete_pipeline.php
     *
     * @param DeletePipelineRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deletePipeline(DeletePipelineRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeletePipeline', $request, $callOptions)->wait();
    }

    /**
     * Delete a single trigger.
     *
     * The async variant is {@see EventarcClient::deleteTriggerAsync()} .
     *
     * @example samples/V1/EventarcClient/delete_trigger.php
     *
     * @param DeleteTriggerRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteTrigger(DeleteTriggerRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeleteTrigger', $request, $callOptions)->wait();
    }

    /**
     * Get a single Channel.
     *
     * The async variant is {@see EventarcClient::getChannelAsync()} .
     *
     * @example samples/V1/EventarcClient/get_channel.php
     *
     * @param GetChannelRequest $request     A request to house fields associated with the call.
     * @param array             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Channel
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getChannel(GetChannelRequest $request, array $callOptions = []): Channel
    {
        return $this->startApiCall('GetChannel', $request, $callOptions)->wait();
    }

    /**
     * Get a single ChannelConnection.
     *
     * The async variant is {@see EventarcClient::getChannelConnectionAsync()} .
     *
     * @example samples/V1/EventarcClient/get_channel_connection.php
     *
     * @param GetChannelConnectionRequest $request     A request to house fields associated with the call.
     * @param array                       $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return ChannelConnection
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getChannelConnection(
        GetChannelConnectionRequest $request,
        array $callOptions = []
    ): ChannelConnection {
        return $this->startApiCall('GetChannelConnection', $request, $callOptions)->wait();
    }

    /**
     * Get a single Enrollment.
     *
     * The async variant is {@see EventarcClient::getEnrollmentAsync()} .
     *
     * @example samples/V1/EventarcClient/get_enrollment.php
     *
     * @param GetEnrollmentRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Enrollment
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getEnrollment(GetEnrollmentRequest $request, array $callOptions = []): Enrollment
    {
        return $this->startApiCall('GetEnrollment', $request, $callOptions)->wait();
    }

    /**
     * Get a single GoogleApiSource.
     *
     * The async variant is {@see EventarcClient::getGoogleApiSourceAsync()} .
     *
     * @example samples/V1/EventarcClient/get_google_api_source.php
     *
     * @param GetGoogleApiSourceRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return GoogleApiSource
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getGoogleApiSource(GetGoogleApiSourceRequest $request, array $callOptions = []): GoogleApiSource
    {
        return $this->startApiCall('GetGoogleApiSource', $request, $callOptions)->wait();
    }

    /**
     * Get a GoogleChannelConfig
     *
     * The async variant is {@see EventarcClient::getGoogleChannelConfigAsync()} .
     *
     * @example samples/V1/EventarcClient/get_google_channel_config.php
     *
     * @param GetGoogleChannelConfigRequest $request     A request to house fields associated with the call.
     * @param array                         $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return GoogleChannelConfig
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getGoogleChannelConfig(
        GetGoogleChannelConfigRequest $request,
        array $callOptions = []
    ): GoogleChannelConfig {
        return $this->startApiCall('GetGoogleChannelConfig', $request, $callOptions)->wait();
    }

    /**
     * Get a single MessageBus.
     *
     * The async variant is {@see EventarcClient::getMessageBusAsync()} .
     *
     * @example samples/V1/EventarcClient/get_message_bus.php
     *
     * @param GetMessageBusRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return MessageBus
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getMessageBus(GetMessageBusRequest $request, array $callOptions = []): MessageBus
    {
        return $this->startApiCall('GetMessageBus', $request, $callOptions)->wait();
    }

    /**
     * Get a single Pipeline.
     *
     * The async variant is {@see EventarcClient::getPipelineAsync()} .
     *
     * @example samples/V1/EventarcClient/get_pipeline.php
     *
     * @param GetPipelineRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Pipeline
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getPipeline(GetPipelineRequest $request, array $callOptions = []): Pipeline
    {
        return $this->startApiCall('GetPipeline', $request, $callOptions)->wait();
    }

    /**
     * Get a single Provider.
     *
     * The async variant is {@see EventarcClient::getProviderAsync()} .
     *
     * @example samples/V1/EventarcClient/get_provider.php
     *
     * @param GetProviderRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Provider
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getProvider(GetProviderRequest $request, array $callOptions = []): Provider
    {
        return $this->startApiCall('GetProvider', $request, $callOptions)->wait();
    }

    /**
     * Get a single trigger.
     *
     * The async variant is {@see EventarcClient::getTriggerAsync()} .
     *
     * @example samples/V1/EventarcClient/get_trigger.php
     *
     * @param GetTriggerRequest $request     A request to house fields associated with the call.
     * @param array             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Trigger
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getTrigger(GetTriggerRequest $request, array $callOptions = []): Trigger
    {
        return $this->startApiCall('GetTrigger', $request, $callOptions)->wait();
    }

    /**
     * List channel connections.
     *
     * The async variant is {@see EventarcClient::listChannelConnectionsAsync()} .
     *
     * @example samples/V1/EventarcClient/list_channel_connections.php
     *
     * @param ListChannelConnectionsRequest $request     A request to house fields associated with the call.
     * @param array                         $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listChannelConnections(
        ListChannelConnectionsRequest $request,
        array $callOptions = []
    ): PagedListResponse {
        return $this->startApiCall('ListChannelConnections', $request, $callOptions);
    }

    /**
     * List channels.
     *
     * The async variant is {@see EventarcClient::listChannelsAsync()} .
     *
     * @example samples/V1/EventarcClient/list_channels.php
     *
     * @param ListChannelsRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listChannels(ListChannelsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListChannels', $request, $callOptions);
    }

    /**
     * List Enrollments.
     *
     * The async variant is {@see EventarcClient::listEnrollmentsAsync()} .
     *
     * @example samples/V1/EventarcClient/list_enrollments.php
     *
     * @param ListEnrollmentsRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listEnrollments(ListEnrollmentsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListEnrollments', $request, $callOptions);
    }

    /**
     * List GoogleApiSources.
     *
     * The async variant is {@see EventarcClient::listGoogleApiSourcesAsync()} .
     *
     * @example samples/V1/EventarcClient/list_google_api_sources.php
     *
     * @param ListGoogleApiSourcesRequest $request     A request to house fields associated with the call.
     * @param array                       $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listGoogleApiSources(
        ListGoogleApiSourcesRequest $request,
        array $callOptions = []
    ): PagedListResponse {
        return $this->startApiCall('ListGoogleApiSources', $request, $callOptions);
    }

    /**
     * List message bus enrollments.
     *
     * The async variant is {@see EventarcClient::listMessageBusEnrollmentsAsync()} .
     *
     * @example samples/V1/EventarcClient/list_message_bus_enrollments.php
     *
     * @param ListMessageBusEnrollmentsRequest $request     A request to house fields associated with the call.
     * @param array                            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listMessageBusEnrollments(
        ListMessageBusEnrollmentsRequest $request,
        array $callOptions = []
    ): PagedListResponse {
        return $this->startApiCall('ListMessageBusEnrollments', $request, $callOptions);
    }

    /**
     * List message buses.
     *
     * The async variant is {@see EventarcClient::listMessageBusesAsync()} .
     *
     * @example samples/V1/EventarcClient/list_message_buses.php
     *
     * @param ListMessageBusesRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listMessageBuses(ListMessageBusesRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListMessageBuses', $request, $callOptions);
    }

    /**
     * List pipelines.
     *
     * The async variant is {@see EventarcClient::listPipelinesAsync()} .
     *
     * @example samples/V1/EventarcClient/list_pipelines.php
     *
     * @param ListPipelinesRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listPipelines(ListPipelinesRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListPipelines', $request, $callOptions);
    }

    /**
     * List providers.
     *
     * The async variant is {@see EventarcClient::listProvidersAsync()} .
     *
     * @example samples/V1/EventarcClient/list_providers.php
     *
     * @param ListProvidersRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listProviders(ListProvidersRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListProviders', $request, $callOptions);
    }

    /**
     * List triggers.
     *
     * The async variant is {@see EventarcClient::listTriggersAsync()} .
     *
     * @example samples/V1/EventarcClient/list_triggers.php
     *
     * @param ListTriggersRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listTriggers(ListTriggersRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListTriggers', $request, $callOptions);
    }

    /**
     * Update a single channel.
     *
     * The async variant is {@see EventarcClient::updateChannelAsync()} .
     *
     * @example samples/V1/EventarcClient/update_channel.php
     *
     * @param UpdateChannelRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateChannel(UpdateChannelRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('UpdateChannel', $request, $callOptions)->wait();
    }

    /**
     * Update a single Enrollment.
     *
     * The async variant is {@see EventarcClient::updateEnrollmentAsync()} .
     *
     * @example samples/V1/EventarcClient/update_enrollment.php
     *
     * @param UpdateEnrollmentRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateEnrollment(UpdateEnrollmentRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('UpdateEnrollment', $request, $callOptions)->wait();
    }

    /**
     * Update a single GoogleApiSource.
     *
     * The async variant is {@see EventarcClient::updateGoogleApiSourceAsync()} .
     *
     * @example samples/V1/EventarcClient/update_google_api_source.php
     *
     * @param UpdateGoogleApiSourceRequest $request     A request to house fields associated with the call.
     * @param array                        $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateGoogleApiSource(
        UpdateGoogleApiSourceRequest $request,
        array $callOptions = []
    ): OperationResponse {
        return $this->startApiCall('UpdateGoogleApiSource', $request, $callOptions)->wait();
    }

    /**
     * Update a single GoogleChannelConfig
     *
     * The async variant is {@see EventarcClient::updateGoogleChannelConfigAsync()} .
     *
     * @example samples/V1/EventarcClient/update_google_channel_config.php
     *
     * @param UpdateGoogleChannelConfigRequest $request     A request to house fields associated with the call.
     * @param array                            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return GoogleChannelConfig
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateGoogleChannelConfig(
        UpdateGoogleChannelConfigRequest $request,
        array $callOptions = []
    ): GoogleChannelConfig {
        return $this->startApiCall('UpdateGoogleChannelConfig', $request, $callOptions)->wait();
    }

    /**
     * Update a single message bus.
     *
     * The async variant is {@see EventarcClient::updateMessageBusAsync()} .
     *
     * @example samples/V1/EventarcClient/update_message_bus.php
     *
     * @param UpdateMessageBusRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateMessageBus(UpdateMessageBusRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('UpdateMessageBus', $request, $callOptions)->wait();
    }

    /**
     * Update a single pipeline.
     *
     * The async variant is {@see EventarcClient::updatePipelineAsync()} .
     *
     * @example samples/V1/EventarcClient/update_pipeline.php
     *
     * @param UpdatePipelineRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updatePipeline(UpdatePipelineRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('UpdatePipeline', $request, $callOptions)->wait();
    }

    /**
     * Update a single trigger.
     *
     * The async variant is {@see EventarcClient::updateTriggerAsync()} .
     *
     * @example samples/V1/EventarcClient/update_trigger.php
     *
     * @param UpdateTriggerRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateTrigger(UpdateTriggerRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('UpdateTrigger', $request, $callOptions)->wait();
    }

    /**
     * Gets information about a location.
     *
     * The async variant is {@see EventarcClient::getLocationAsync()} .
     *
     * @example samples/V1/EventarcClient/get_location.php
     *
     * @param GetLocationRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Location
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getLocation(GetLocationRequest $request, array $callOptions = []): Location
    {
        return $this->startApiCall('GetLocation', $request, $callOptions)->wait();
    }

    /**
     * Lists information about the supported locations for this service.
     *
     * The async variant is {@see EventarcClient::listLocationsAsync()} .
     *
     * @example samples/V1/EventarcClient/list_locations.php
     *
     * @param ListLocationsRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listLocations(ListLocationsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListLocations', $request, $callOptions);
    }

    /**
     * Gets the access control policy for a resource. Returns an empty policy
    if the resource exists and does not have a policy set.
     *
     * The async variant is {@see EventarcClient::getIamPolicyAsync()} .
     *
     * @example samples/V1/EventarcClient/get_iam_policy.php
     *
     * @param GetIamPolicyRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Policy
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getIamPolicy(GetIamPolicyRequest $request, array $callOptions = []): Policy
    {
        return $this->startApiCall('GetIamPolicy', $request, $callOptions)->wait();
    }

    /**
     * Sets the access control policy on the specified resource. Replaces
    any existing policy.

    Can return `NOT_FOUND`, `INVALID_ARGUMENT`, and `PERMISSION_DENIED`
    errors.
     *
     * The async variant is {@see EventarcClient::setIamPolicyAsync()} .
     *
     * @example samples/V1/EventarcClient/set_iam_policy.php
     *
     * @param SetIamPolicyRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Policy
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function setIamPolicy(SetIamPolicyRequest $request, array $callOptions = []): Policy
    {
        return $this->startApiCall('SetIamPolicy', $request, $callOptions)->wait();
    }

    /**
     * Returns permissions that a caller has on the specified resource. If the
    resource does not exist, this will return an empty set of
    permissions, not a `NOT_FOUND` error.

    Note: This operation is designed to be used for building
    permission-aware UIs and command-line tools, not for authorization
    checking. This operation may "fail open" without warning.
     *
     * The async variant is {@see EventarcClient::testIamPermissionsAsync()} .
     *
     * @example samples/V1/EventarcClient/test_iam_permissions.php
     *
     * @param TestIamPermissionsRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return TestIamPermissionsResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function testIamPermissions(
        TestIamPermissionsRequest $request,
        array $callOptions = []
    ): TestIamPermissionsResponse {
        return $this->startApiCall('TestIamPermissions', $request, $callOptions)->wait();
    }
}
