<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/privacy/dlp/v2/dlp.proto

namespace Google\Cloud\Dlp\V2;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Details about a single transformation. This object contains a description of
 * the transformation, information about whether the transformation was
 * successfully applied, and the precise location where the transformation
 * occurred. These details are stored in a user-specified BigQuery table.
 *
 * Generated from protobuf message <code>google.privacy.dlp.v2.TransformationDetails</code>
 */
class TransformationDetails extends \Google\Protobuf\Internal\Message
{
    /**
     * The name of the job that completed the transformation.
     *
     * Generated from protobuf field <code>string resource_name = 1;</code>
     */
    protected $resource_name = '';
    /**
     * The top level name of the container where the transformation is located
     * (this will be the source file name or table name).
     *
     * Generated from protobuf field <code>string container_name = 2;</code>
     */
    protected $container_name = '';
    /**
     * Description of transformation. This would only contain more than one
     * element if there were multiple matching transformations and which one to
     * apply was ambiguous. Not set for states that contain no transformation,
     * currently only state that contains no transformation is
     * TransformationResultStateType.METADATA_UNRETRIEVABLE.
     *
     * Generated from protobuf field <code>repeated .google.privacy.dlp.v2.TransformationDescription transformation = 3;</code>
     */
    private $transformation;
    /**
     * Status of the transformation, if transformation was not successful, this
     * will specify what caused it to fail, otherwise it will show that the
     * transformation was successful.
     *
     * Generated from protobuf field <code>.google.privacy.dlp.v2.TransformationResultStatus status_details = 4;</code>
     */
    protected $status_details = null;
    /**
     * The number of bytes that were transformed. If transformation was
     * unsuccessful or did not take place because there was no content to
     * transform, this will be zero.
     *
     * Generated from protobuf field <code>int64 transformed_bytes = 5;</code>
     */
    protected $transformed_bytes = 0;
    /**
     * The precise location of the transformed content in the original container.
     *
     * Generated from protobuf field <code>.google.privacy.dlp.v2.TransformationLocation transformation_location = 6;</code>
     */
    protected $transformation_location = null;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $resource_name
     *           The name of the job that completed the transformation.
     *     @type string $container_name
     *           The top level name of the container where the transformation is located
     *           (this will be the source file name or table name).
     *     @type array<\Google\Cloud\Dlp\V2\TransformationDescription>|\Google\Protobuf\Internal\RepeatedField $transformation
     *           Description of transformation. This would only contain more than one
     *           element if there were multiple matching transformations and which one to
     *           apply was ambiguous. Not set for states that contain no transformation,
     *           currently only state that contains no transformation is
     *           TransformationResultStateType.METADATA_UNRETRIEVABLE.
     *     @type \Google\Cloud\Dlp\V2\TransformationResultStatus $status_details
     *           Status of the transformation, if transformation was not successful, this
     *           will specify what caused it to fail, otherwise it will show that the
     *           transformation was successful.
     *     @type int|string $transformed_bytes
     *           The number of bytes that were transformed. If transformation was
     *           unsuccessful or did not take place because there was no content to
     *           transform, this will be zero.
     *     @type \Google\Cloud\Dlp\V2\TransformationLocation $transformation_location
     *           The precise location of the transformed content in the original container.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Privacy\Dlp\V2\Dlp::initOnce();
        parent::__construct($data);
    }

    /**
     * The name of the job that completed the transformation.
     *
     * Generated from protobuf field <code>string resource_name = 1;</code>
     * @return string
     */
    public function getResourceName()
    {
        return $this->resource_name;
    }

    /**
     * The name of the job that completed the transformation.
     *
     * Generated from protobuf field <code>string resource_name = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setResourceName($var)
    {
        GPBUtil::checkString($var, True);
        $this->resource_name = $var;

        return $this;
    }

    /**
     * The top level name of the container where the transformation is located
     * (this will be the source file name or table name).
     *
     * Generated from protobuf field <code>string container_name = 2;</code>
     * @return string
     */
    public function getContainerName()
    {
        return $this->container_name;
    }

    /**
     * The top level name of the container where the transformation is located
     * (this will be the source file name or table name).
     *
     * Generated from protobuf field <code>string container_name = 2;</code>
     * @param string $var
     * @return $this
     */
    public function setContainerName($var)
    {
        GPBUtil::checkString($var, True);
        $this->container_name = $var;

        return $this;
    }

    /**
     * Description of transformation. This would only contain more than one
     * element if there were multiple matching transformations and which one to
     * apply was ambiguous. Not set for states that contain no transformation,
     * currently only state that contains no transformation is
     * TransformationResultStateType.METADATA_UNRETRIEVABLE.
     *
     * Generated from protobuf field <code>repeated .google.privacy.dlp.v2.TransformationDescription transformation = 3;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getTransformation()
    {
        return $this->transformation;
    }

    /**
     * Description of transformation. This would only contain more than one
     * element if there were multiple matching transformations and which one to
     * apply was ambiguous. Not set for states that contain no transformation,
     * currently only state that contains no transformation is
     * TransformationResultStateType.METADATA_UNRETRIEVABLE.
     *
     * Generated from protobuf field <code>repeated .google.privacy.dlp.v2.TransformationDescription transformation = 3;</code>
     * @param array<\Google\Cloud\Dlp\V2\TransformationDescription>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setTransformation($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Dlp\V2\TransformationDescription::class);
        $this->transformation = $arr;

        return $this;
    }

    /**
     * Status of the transformation, if transformation was not successful, this
     * will specify what caused it to fail, otherwise it will show that the
     * transformation was successful.
     *
     * Generated from protobuf field <code>.google.privacy.dlp.v2.TransformationResultStatus status_details = 4;</code>
     * @return \Google\Cloud\Dlp\V2\TransformationResultStatus|null
     */
    public function getStatusDetails()
    {
        return $this->status_details;
    }

    public function hasStatusDetails()
    {
        return isset($this->status_details);
    }

    public function clearStatusDetails()
    {
        unset($this->status_details);
    }

    /**
     * Status of the transformation, if transformation was not successful, this
     * will specify what caused it to fail, otherwise it will show that the
     * transformation was successful.
     *
     * Generated from protobuf field <code>.google.privacy.dlp.v2.TransformationResultStatus status_details = 4;</code>
     * @param \Google\Cloud\Dlp\V2\TransformationResultStatus $var
     * @return $this
     */
    public function setStatusDetails($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Dlp\V2\TransformationResultStatus::class);
        $this->status_details = $var;

        return $this;
    }

    /**
     * The number of bytes that were transformed. If transformation was
     * unsuccessful or did not take place because there was no content to
     * transform, this will be zero.
     *
     * Generated from protobuf field <code>int64 transformed_bytes = 5;</code>
     * @return int|string
     */
    public function getTransformedBytes()
    {
        return $this->transformed_bytes;
    }

    /**
     * The number of bytes that were transformed. If transformation was
     * unsuccessful or did not take place because there was no content to
     * transform, this will be zero.
     *
     * Generated from protobuf field <code>int64 transformed_bytes = 5;</code>
     * @param int|string $var
     * @return $this
     */
    public function setTransformedBytes($var)
    {
        GPBUtil::checkInt64($var);
        $this->transformed_bytes = $var;

        return $this;
    }

    /**
     * The precise location of the transformed content in the original container.
     *
     * Generated from protobuf field <code>.google.privacy.dlp.v2.TransformationLocation transformation_location = 6;</code>
     * @return \Google\Cloud\Dlp\V2\TransformationLocation|null
     */
    public function getTransformationLocation()
    {
        return $this->transformation_location;
    }

    public function hasTransformationLocation()
    {
        return isset($this->transformation_location);
    }

    public function clearTransformationLocation()
    {
        unset($this->transformation_location);
    }

    /**
     * The precise location of the transformed content in the original container.
     *
     * Generated from protobuf field <code>.google.privacy.dlp.v2.TransformationLocation transformation_location = 6;</code>
     * @param \Google\Cloud\Dlp\V2\TransformationLocation $var
     * @return $this
     */
    public function setTransformationLocation($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Dlp\V2\TransformationLocation::class);
        $this->transformation_location = $var;

        return $this;
    }

}

