<?php
/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/dataproc/v1/autoscaling_policies.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\Dataproc\V1\Client;

use Google\ApiCore\ApiException;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\PagedListResponse;
use Google\ApiCore\ResourceHelperTrait;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\Dataproc\V1\AutoscalingPolicy;
use Google\Cloud\Dataproc\V1\CreateAutoscalingPolicyRequest;
use Google\Cloud\Dataproc\V1\DeleteAutoscalingPolicyRequest;
use Google\Cloud\Dataproc\V1\GetAutoscalingPolicyRequest;
use Google\Cloud\Dataproc\V1\ListAutoscalingPoliciesRequest;
use Google\Cloud\Dataproc\V1\UpdateAutoscalingPolicyRequest;
use Google\Cloud\Iam\V1\GetIamPolicyRequest;
use Google\Cloud\Iam\V1\Policy;
use Google\Cloud\Iam\V1\SetIamPolicyRequest;
use Google\Cloud\Iam\V1\TestIamPermissionsRequest;
use Google\Cloud\Iam\V1\TestIamPermissionsResponse;
use GuzzleHttp\Promise\PromiseInterface;

/**
 * Service Description: The API interface for managing autoscaling policies in the
 * Dataproc API.
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods.
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 *
 * @method PromiseInterface<AutoscalingPolicy> createAutoscalingPolicyAsync(CreateAutoscalingPolicyRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<void> deleteAutoscalingPolicyAsync(DeleteAutoscalingPolicyRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<AutoscalingPolicy> getAutoscalingPolicyAsync(GetAutoscalingPolicyRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listAutoscalingPoliciesAsync(ListAutoscalingPoliciesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<AutoscalingPolicy> updateAutoscalingPolicyAsync(UpdateAutoscalingPolicyRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Policy> getIamPolicyAsync(GetIamPolicyRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Policy> setIamPolicyAsync(SetIamPolicyRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<TestIamPermissionsResponse> testIamPermissionsAsync(TestIamPermissionsRequest $request, array $optionalArgs = [])
 */
final class AutoscalingPolicyServiceClient
{
    use GapicClientTrait;
    use ResourceHelperTrait;

    /** The name of the service. */
    private const SERVICE_NAME = 'google.cloud.dataproc.v1.AutoscalingPolicyService';

    /**
     * The default address of the service.
     *
     * @deprecated SERVICE_ADDRESS_TEMPLATE should be used instead.
     */
    private const SERVICE_ADDRESS = 'dataproc.googleapis.com';

    /** The address template of the service. */
    private const SERVICE_ADDRESS_TEMPLATE = 'dataproc.UNIVERSE_DOMAIN';

    /** The default port of the service. */
    private const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    private const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = ['https://www.googleapis.com/auth/cloud-platform'];

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' => self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' => __DIR__ . '/../resources/autoscaling_policy_service_client_config.json',
            'descriptorsConfigPath' => __DIR__ . '/../resources/autoscaling_policy_service_descriptor_config.php',
            'gcpApiConfigPath' => __DIR__ . '/../resources/autoscaling_policy_service_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' =>
                        __DIR__ . '/../resources/autoscaling_policy_service_rest_client_config.php',
                ],
            ],
        ];
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * autoscaling_policy resource.
     *
     * @param string $project
     * @param string $location
     * @param string $autoscalingPolicy
     *
     * @return string The formatted autoscaling_policy resource.
     */
    public static function autoscalingPolicyName(string $project, string $location, string $autoscalingPolicy): string
    {
        return self::getPathTemplate('autoscalingPolicy')->render([
            'project' => $project,
            'location' => $location,
            'autoscaling_policy' => $autoscalingPolicy,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a location
     * resource.
     *
     * @param string $project
     * @param string $location
     *
     * @return string The formatted location resource.
     */
    public static function locationName(string $project, string $location): string
    {
        return self::getPathTemplate('location')->render([
            'project' => $project,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_location_autoscaling_policy resource.
     *
     * @param string $project
     * @param string $location
     * @param string $autoscalingPolicy
     *
     * @return string The formatted project_location_autoscaling_policy resource.
     */
    public static function projectLocationAutoscalingPolicyName(
        string $project,
        string $location,
        string $autoscalingPolicy
    ): string {
        return self::getPathTemplate('projectLocationAutoscalingPolicy')->render([
            'project' => $project,
            'location' => $location,
            'autoscaling_policy' => $autoscalingPolicy,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_region_autoscaling_policy resource.
     *
     * @param string $project
     * @param string $region
     * @param string $autoscalingPolicy
     *
     * @return string The formatted project_region_autoscaling_policy resource.
     */
    public static function projectRegionAutoscalingPolicyName(
        string $project,
        string $region,
        string $autoscalingPolicy
    ): string {
        return self::getPathTemplate('projectRegionAutoscalingPolicy')->render([
            'project' => $project,
            'region' => $region,
            'autoscaling_policy' => $autoscalingPolicy,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a region
     * resource.
     *
     * @param string $project
     * @param string $region
     *
     * @return string The formatted region resource.
     */
    public static function regionName(string $project, string $region): string
    {
        return self::getPathTemplate('region')->render([
            'project' => $project,
            'region' => $region,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - autoscalingPolicy: projects/{project}/locations/{location}/autoscalingPolicies/{autoscaling_policy}
     * - location: projects/{project}/locations/{location}
     * - projectLocationAutoscalingPolicy: projects/{project}/locations/{location}/autoscalingPolicies/{autoscaling_policy}
     * - projectRegionAutoscalingPolicy: projects/{project}/regions/{region}/autoscalingPolicies/{autoscaling_policy}
     * - region: projects/{project}/regions/{region}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string $formattedName The formatted name string
     * @param string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName(string $formattedName, string $template = null): array
    {
        return self::parseFormattedName($formattedName, $template);
    }

    /**
     * Constructor.
     *
     * @param array $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'dataproc.googleapis.com:443'.
     *     @type string|array|FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           The credentials to be used by the client to authorize API calls. This option
     *           accepts either a path to a credentials file, or a decoded credentials file as a
     *           PHP array.
     *           *Advanced usage*: In addition, this option can also accept a pre-constructed
     *           {@see \Google\Auth\FetchAuthTokenInterface} object or
     *           {@see \Google\ApiCore\CredentialsWrapper} object. Note that when one of these
     *           objects are provided, any settings in $credentialsConfig will be ignored.
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
    }

    /** Handles execution of the async variants for each documented method. */
    public function __call($method, $args)
    {
        if (substr($method, -5) !== 'Async') {
            trigger_error('Call to undefined method ' . __CLASS__ . "::$method()", E_USER_ERROR);
        }

        array_unshift($args, substr($method, 0, -5));
        return call_user_func_array([$this, 'startAsyncCall'], $args);
    }

    /**
     * Creates new autoscaling policy.
     *
     * The async variant is
     * {@see AutoscalingPolicyServiceClient::createAutoscalingPolicyAsync()} .
     *
     * @example samples/V1/AutoscalingPolicyServiceClient/create_autoscaling_policy.php
     *
     * @param CreateAutoscalingPolicyRequest $request     A request to house fields associated with the call.
     * @param array                          $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return AutoscalingPolicy
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createAutoscalingPolicy(
        CreateAutoscalingPolicyRequest $request,
        array $callOptions = []
    ): AutoscalingPolicy {
        return $this->startApiCall('CreateAutoscalingPolicy', $request, $callOptions)->wait();
    }

    /**
     * Deletes an autoscaling policy. It is an error to delete an autoscaling
     * policy that is in use by one or more clusters.
     *
     * The async variant is
     * {@see AutoscalingPolicyServiceClient::deleteAutoscalingPolicyAsync()} .
     *
     * @example samples/V1/AutoscalingPolicyServiceClient/delete_autoscaling_policy.php
     *
     * @param DeleteAutoscalingPolicyRequest $request     A request to house fields associated with the call.
     * @param array                          $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteAutoscalingPolicy(DeleteAutoscalingPolicyRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('DeleteAutoscalingPolicy', $request, $callOptions)->wait();
    }

    /**
     * Retrieves autoscaling policy.
     *
     * The async variant is
     * {@see AutoscalingPolicyServiceClient::getAutoscalingPolicyAsync()} .
     *
     * @example samples/V1/AutoscalingPolicyServiceClient/get_autoscaling_policy.php
     *
     * @param GetAutoscalingPolicyRequest $request     A request to house fields associated with the call.
     * @param array                       $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return AutoscalingPolicy
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getAutoscalingPolicy(
        GetAutoscalingPolicyRequest $request,
        array $callOptions = []
    ): AutoscalingPolicy {
        return $this->startApiCall('GetAutoscalingPolicy', $request, $callOptions)->wait();
    }

    /**
     * Lists autoscaling policies in the project.
     *
     * The async variant is
     * {@see AutoscalingPolicyServiceClient::listAutoscalingPoliciesAsync()} .
     *
     * @example samples/V1/AutoscalingPolicyServiceClient/list_autoscaling_policies.php
     *
     * @param ListAutoscalingPoliciesRequest $request     A request to house fields associated with the call.
     * @param array                          $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listAutoscalingPolicies(
        ListAutoscalingPoliciesRequest $request,
        array $callOptions = []
    ): PagedListResponse {
        return $this->startApiCall('ListAutoscalingPolicies', $request, $callOptions);
    }

    /**
     * Updates (replaces) autoscaling policy.
     *
     * Disabled check for update_mask, because all updates will be full
     * replacements.
     *
     * The async variant is
     * {@see AutoscalingPolicyServiceClient::updateAutoscalingPolicyAsync()} .
     *
     * @example samples/V1/AutoscalingPolicyServiceClient/update_autoscaling_policy.php
     *
     * @param UpdateAutoscalingPolicyRequest $request     A request to house fields associated with the call.
     * @param array                          $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return AutoscalingPolicy
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateAutoscalingPolicy(
        UpdateAutoscalingPolicyRequest $request,
        array $callOptions = []
    ): AutoscalingPolicy {
        return $this->startApiCall('UpdateAutoscalingPolicy', $request, $callOptions)->wait();
    }

    /**
     * Gets the access control policy for a resource. Returns an empty policy
    if the resource exists and does not have a policy set.
     *
     * The async variant is {@see AutoscalingPolicyServiceClient::getIamPolicyAsync()}
     * .
     *
     * @example samples/V1/AutoscalingPolicyServiceClient/get_iam_policy.php
     *
     * @param GetIamPolicyRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Policy
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getIamPolicy(GetIamPolicyRequest $request, array $callOptions = []): Policy
    {
        return $this->startApiCall('GetIamPolicy', $request, $callOptions)->wait();
    }

    /**
     * Sets the access control policy on the specified resource. Replaces
    any existing policy.

    Can return `NOT_FOUND`, `INVALID_ARGUMENT`, and `PERMISSION_DENIED`
    errors.
     *
     * The async variant is {@see AutoscalingPolicyServiceClient::setIamPolicyAsync()}
     * .
     *
     * @example samples/V1/AutoscalingPolicyServiceClient/set_iam_policy.php
     *
     * @param SetIamPolicyRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Policy
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function setIamPolicy(SetIamPolicyRequest $request, array $callOptions = []): Policy
    {
        return $this->startApiCall('SetIamPolicy', $request, $callOptions)->wait();
    }

    /**
     * Returns permissions that a caller has on the specified resource. If the
    resource does not exist, this will return an empty set of
    permissions, not a `NOT_FOUND` error.

    Note: This operation is designed to be used for building
    permission-aware UIs and command-line tools, not for authorization
    checking. This operation may "fail open" without warning.
     *
     * The async variant is
     * {@see AutoscalingPolicyServiceClient::testIamPermissionsAsync()} .
     *
     * @example samples/V1/AutoscalingPolicyServiceClient/test_iam_permissions.php
     *
     * @param TestIamPermissionsRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return TestIamPermissionsResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function testIamPermissions(
        TestIamPermissionsRequest $request,
        array $callOptions = []
    ): TestIamPermissionsResponse {
        return $this->startApiCall('TestIamPermissions', $request, $callOptions)->wait();
    }
}
