<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/video/livestream/v1/resources.proto

namespace Google\Cloud\Video\LiveStream\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Input resource represents the endpoint from which the channel ingests
 * the input stream.
 *
 * Generated from protobuf message <code>google.cloud.video.livestream.v1.Input</code>
 */
class Input extends \Google\Protobuf\Internal\Message
{
    /**
     * The resource name of the input, in the form of:
     * `projects/{project}/locations/{location}/inputs/{inputId}`.
     *
     * Generated from protobuf field <code>string name = 1;</code>
     */
    protected $name = '';
    /**
     * Output only. The creation time.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $create_time = null;
    /**
     * Output only. The update time.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $update_time = null;
    /**
     * User-defined key/value metadata.
     *
     * Generated from protobuf field <code>map<string, string> labels = 4;</code>
     */
    private $labels;
    /**
     * Source type.
     *
     * Generated from protobuf field <code>.google.cloud.video.livestream.v1.Input.Type type = 5;</code>
     */
    protected $type = 0;
    /**
     * Tier defines the maximum input specification that is accepted by the
     * video pipeline. The billing is charged based on the tier specified here.
     * See [Pricing](https://cloud.google.com/livestream/pricing) for more detail.
     * The default is `HD`.
     *
     * Generated from protobuf field <code>.google.cloud.video.livestream.v1.Input.Tier tier = 14;</code>
     */
    protected $tier = 0;
    /**
     * Output only. URI to push the input stream to.
     * Its format depends on the input
     * [type][google.cloud.video.livestream.v1.Input.type], for example:
     * *  `RTMP_PUSH`: `rtmp://1.2.3.4/live/{STREAM-ID}`
     * *  `SRT_PUSH`: `srt://1.2.3.4:4201?streamid={STREAM-ID}`
     *
     * Generated from protobuf field <code>string uri = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $uri = '';
    /**
     * Preprocessing configurations.
     *
     * Generated from protobuf field <code>.google.cloud.video.livestream.v1.PreprocessingConfig preprocessing_config = 9;</code>
     */
    protected $preprocessing_config = null;
    /**
     * Security rule for access control.
     *
     * Generated from protobuf field <code>.google.cloud.video.livestream.v1.Input.SecurityRule security_rules = 12;</code>
     */
    protected $security_rules = null;
    /**
     * Output only. The information for the input stream. This field will be
     * present only when this input receives the input stream.
     *
     * Generated from protobuf field <code>.google.cloud.video.livestream.v1.InputStreamProperty input_stream_property = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $input_stream_property = null;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           The resource name of the input, in the form of:
     *           `projects/{project}/locations/{location}/inputs/{inputId}`.
     *     @type \Google\Protobuf\Timestamp $create_time
     *           Output only. The creation time.
     *     @type \Google\Protobuf\Timestamp $update_time
     *           Output only. The update time.
     *     @type array|\Google\Protobuf\Internal\MapField $labels
     *           User-defined key/value metadata.
     *     @type int $type
     *           Source type.
     *     @type int $tier
     *           Tier defines the maximum input specification that is accepted by the
     *           video pipeline. The billing is charged based on the tier specified here.
     *           See [Pricing](https://cloud.google.com/livestream/pricing) for more detail.
     *           The default is `HD`.
     *     @type string $uri
     *           Output only. URI to push the input stream to.
     *           Its format depends on the input
     *           [type][google.cloud.video.livestream.v1.Input.type], for example:
     *           *  `RTMP_PUSH`: `rtmp://1.2.3.4/live/{STREAM-ID}`
     *           *  `SRT_PUSH`: `srt://1.2.3.4:4201?streamid={STREAM-ID}`
     *     @type \Google\Cloud\Video\LiveStream\V1\PreprocessingConfig $preprocessing_config
     *           Preprocessing configurations.
     *     @type \Google\Cloud\Video\LiveStream\V1\Input\SecurityRule $security_rules
     *           Security rule for access control.
     *     @type \Google\Cloud\Video\LiveStream\V1\InputStreamProperty $input_stream_property
     *           Output only. The information for the input stream. This field will be
     *           present only when this input receives the input stream.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Video\Livestream\V1\Resources::initOnce();
        parent::__construct($data);
    }

    /**
     * The resource name of the input, in the form of:
     * `projects/{project}/locations/{location}/inputs/{inputId}`.
     *
     * Generated from protobuf field <code>string name = 1;</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * The resource name of the input, in the form of:
     * `projects/{project}/locations/{location}/inputs/{inputId}`.
     *
     * Generated from protobuf field <code>string name = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Output only. The creation time.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getCreateTime()
    {
        return $this->create_time;
    }

    public function hasCreateTime()
    {
        return isset($this->create_time);
    }

    public function clearCreateTime()
    {
        unset($this->create_time);
    }

    /**
     * Output only. The creation time.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setCreateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->create_time = $var;

        return $this;
    }

    /**
     * Output only. The update time.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getUpdateTime()
    {
        return $this->update_time;
    }

    public function hasUpdateTime()
    {
        return isset($this->update_time);
    }

    public function clearUpdateTime()
    {
        unset($this->update_time);
    }

    /**
     * Output only. The update time.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setUpdateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->update_time = $var;

        return $this;
    }

    /**
     * User-defined key/value metadata.
     *
     * Generated from protobuf field <code>map<string, string> labels = 4;</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getLabels()
    {
        return $this->labels;
    }

    /**
     * User-defined key/value metadata.
     *
     * Generated from protobuf field <code>map<string, string> labels = 4;</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setLabels($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::STRING);
        $this->labels = $arr;

        return $this;
    }

    /**
     * Source type.
     *
     * Generated from protobuf field <code>.google.cloud.video.livestream.v1.Input.Type type = 5;</code>
     * @return int
     */
    public function getType()
    {
        return $this->type;
    }

    /**
     * Source type.
     *
     * Generated from protobuf field <code>.google.cloud.video.livestream.v1.Input.Type type = 5;</code>
     * @param int $var
     * @return $this
     */
    public function setType($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Video\LiveStream\V1\Input\Type::class);
        $this->type = $var;

        return $this;
    }

    /**
     * Tier defines the maximum input specification that is accepted by the
     * video pipeline. The billing is charged based on the tier specified here.
     * See [Pricing](https://cloud.google.com/livestream/pricing) for more detail.
     * The default is `HD`.
     *
     * Generated from protobuf field <code>.google.cloud.video.livestream.v1.Input.Tier tier = 14;</code>
     * @return int
     */
    public function getTier()
    {
        return $this->tier;
    }

    /**
     * Tier defines the maximum input specification that is accepted by the
     * video pipeline. The billing is charged based on the tier specified here.
     * See [Pricing](https://cloud.google.com/livestream/pricing) for more detail.
     * The default is `HD`.
     *
     * Generated from protobuf field <code>.google.cloud.video.livestream.v1.Input.Tier tier = 14;</code>
     * @param int $var
     * @return $this
     */
    public function setTier($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Video\LiveStream\V1\Input\Tier::class);
        $this->tier = $var;

        return $this;
    }

    /**
     * Output only. URI to push the input stream to.
     * Its format depends on the input
     * [type][google.cloud.video.livestream.v1.Input.type], for example:
     * *  `RTMP_PUSH`: `rtmp://1.2.3.4/live/{STREAM-ID}`
     * *  `SRT_PUSH`: `srt://1.2.3.4:4201?streamid={STREAM-ID}`
     *
     * Generated from protobuf field <code>string uri = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getUri()
    {
        return $this->uri;
    }

    /**
     * Output only. URI to push the input stream to.
     * Its format depends on the input
     * [type][google.cloud.video.livestream.v1.Input.type], for example:
     * *  `RTMP_PUSH`: `rtmp://1.2.3.4/live/{STREAM-ID}`
     * *  `SRT_PUSH`: `srt://1.2.3.4:4201?streamid={STREAM-ID}`
     *
     * Generated from protobuf field <code>string uri = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setUri($var)
    {
        GPBUtil::checkString($var, True);
        $this->uri = $var;

        return $this;
    }

    /**
     * Preprocessing configurations.
     *
     * Generated from protobuf field <code>.google.cloud.video.livestream.v1.PreprocessingConfig preprocessing_config = 9;</code>
     * @return \Google\Cloud\Video\LiveStream\V1\PreprocessingConfig|null
     */
    public function getPreprocessingConfig()
    {
        return $this->preprocessing_config;
    }

    public function hasPreprocessingConfig()
    {
        return isset($this->preprocessing_config);
    }

    public function clearPreprocessingConfig()
    {
        unset($this->preprocessing_config);
    }

    /**
     * Preprocessing configurations.
     *
     * Generated from protobuf field <code>.google.cloud.video.livestream.v1.PreprocessingConfig preprocessing_config = 9;</code>
     * @param \Google\Cloud\Video\LiveStream\V1\PreprocessingConfig $var
     * @return $this
     */
    public function setPreprocessingConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Video\LiveStream\V1\PreprocessingConfig::class);
        $this->preprocessing_config = $var;

        return $this;
    }

    /**
     * Security rule for access control.
     *
     * Generated from protobuf field <code>.google.cloud.video.livestream.v1.Input.SecurityRule security_rules = 12;</code>
     * @return \Google\Cloud\Video\LiveStream\V1\Input\SecurityRule|null
     */
    public function getSecurityRules()
    {
        return $this->security_rules;
    }

    public function hasSecurityRules()
    {
        return isset($this->security_rules);
    }

    public function clearSecurityRules()
    {
        unset($this->security_rules);
    }

    /**
     * Security rule for access control.
     *
     * Generated from protobuf field <code>.google.cloud.video.livestream.v1.Input.SecurityRule security_rules = 12;</code>
     * @param \Google\Cloud\Video\LiveStream\V1\Input\SecurityRule $var
     * @return $this
     */
    public function setSecurityRules($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Video\LiveStream\V1\Input\SecurityRule::class);
        $this->security_rules = $var;

        return $this;
    }

    /**
     * Output only. The information for the input stream. This field will be
     * present only when this input receives the input stream.
     *
     * Generated from protobuf field <code>.google.cloud.video.livestream.v1.InputStreamProperty input_stream_property = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Cloud\Video\LiveStream\V1\InputStreamProperty|null
     */
    public function getInputStreamProperty()
    {
        return $this->input_stream_property;
    }

    public function hasInputStreamProperty()
    {
        return isset($this->input_stream_property);
    }

    public function clearInputStreamProperty()
    {
        unset($this->input_stream_property);
    }

    /**
     * Output only. The information for the input stream. This field will be
     * present only when this input receives the input stream.
     *
     * Generated from protobuf field <code>.google.cloud.video.livestream.v1.InputStreamProperty input_stream_property = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Cloud\Video\LiveStream\V1\InputStreamProperty $var
     * @return $this
     */
    public function setInputStreamProperty($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Video\LiveStream\V1\InputStreamProperty::class);
        $this->input_stream_property = $var;

        return $this;
    }

}

