<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/spanner/admin/database/v1/backup_schedule.proto

namespace Google\Cloud\Spanner\Admin\Database\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * CrontabSpec can be used to specify the version time and frequency at
 * which the backup should be created.
 *
 * Generated from protobuf message <code>google.spanner.admin.database.v1.CrontabSpec</code>
 */
class CrontabSpec extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. Textual representation of the crontab. User can customize the
     * backup frequency and the backup version time using the cron
     * expression. The version time must be in UTC timzeone.
     * The backup will contain an externally consistent copy of the
     * database at the version time. Allowed frequencies are 12 hour, 1 day,
     * 1 week and 1 month. Examples of valid cron specifications:
     *   * `0 2/12 * * * ` : every 12 hours at (2, 14) hours past midnight in UTC.
     *   * `0 2,14 * * * ` : every 12 hours at (2,14) hours past midnight in UTC.
     *   * `0 2 * * * `    : once a day at 2 past midnight in UTC.
     *   * `0 2 * * 0 `    : once a week every Sunday at 2 past midnight in UTC.
     *   * `0 2 8 * * `    : once a month on 8th day at 2 past midnight in UTC.
     *
     * Generated from protobuf field <code>string text = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    private $text = '';
    /**
     * Output only. The time zone of the times in `CrontabSpec.text`. Currently
     * only UTC is supported.
     *
     * Generated from protobuf field <code>string time_zone = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $time_zone = '';
    /**
     * Output only. Schedule backups will contain an externally consistent copy
     * of the database at the version time specified in
     * `schedule_spec.cron_spec`. However, Spanner may not initiate the creation
     * of the scheduled backups at that version time. Spanner will initiate
     * the creation of scheduled backups within the time window bounded by the
     * version_time specified in `schedule_spec.cron_spec` and version_time +
     * `creation_window`.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration creation_window = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $creation_window = null;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $text
     *           Required. Textual representation of the crontab. User can customize the
     *           backup frequency and the backup version time using the cron
     *           expression. The version time must be in UTC timzeone.
     *           The backup will contain an externally consistent copy of the
     *           database at the version time. Allowed frequencies are 12 hour, 1 day,
     *           1 week and 1 month. Examples of valid cron specifications:
     *             * `0 2/12 * * * ` : every 12 hours at (2, 14) hours past midnight in UTC.
     *             * `0 2,14 * * * ` : every 12 hours at (2,14) hours past midnight in UTC.
     *             * `0 2 * * * `    : once a day at 2 past midnight in UTC.
     *             * `0 2 * * 0 `    : once a week every Sunday at 2 past midnight in UTC.
     *             * `0 2 8 * * `    : once a month on 8th day at 2 past midnight in UTC.
     *     @type string $time_zone
     *           Output only. The time zone of the times in `CrontabSpec.text`. Currently
     *           only UTC is supported.
     *     @type \Google\Protobuf\Duration $creation_window
     *           Output only. Schedule backups will contain an externally consistent copy
     *           of the database at the version time specified in
     *           `schedule_spec.cron_spec`. However, Spanner may not initiate the creation
     *           of the scheduled backups at that version time. Spanner will initiate
     *           the creation of scheduled backups within the time window bounded by the
     *           version_time specified in `schedule_spec.cron_spec` and version_time +
     *           `creation_window`.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Spanner\Admin\Database\V1\BackupSchedule::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. Textual representation of the crontab. User can customize the
     * backup frequency and the backup version time using the cron
     * expression. The version time must be in UTC timzeone.
     * The backup will contain an externally consistent copy of the
     * database at the version time. Allowed frequencies are 12 hour, 1 day,
     * 1 week and 1 month. Examples of valid cron specifications:
     *   * `0 2/12 * * * ` : every 12 hours at (2, 14) hours past midnight in UTC.
     *   * `0 2,14 * * * ` : every 12 hours at (2,14) hours past midnight in UTC.
     *   * `0 2 * * * `    : once a day at 2 past midnight in UTC.
     *   * `0 2 * * 0 `    : once a week every Sunday at 2 past midnight in UTC.
     *   * `0 2 8 * * `    : once a month on 8th day at 2 past midnight in UTC.
     *
     * Generated from protobuf field <code>string text = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getText()
    {
        return $this->text;
    }

    /**
     * Required. Textual representation of the crontab. User can customize the
     * backup frequency and the backup version time using the cron
     * expression. The version time must be in UTC timzeone.
     * The backup will contain an externally consistent copy of the
     * database at the version time. Allowed frequencies are 12 hour, 1 day,
     * 1 week and 1 month. Examples of valid cron specifications:
     *   * `0 2/12 * * * ` : every 12 hours at (2, 14) hours past midnight in UTC.
     *   * `0 2,14 * * * ` : every 12 hours at (2,14) hours past midnight in UTC.
     *   * `0 2 * * * `    : once a day at 2 past midnight in UTC.
     *   * `0 2 * * 0 `    : once a week every Sunday at 2 past midnight in UTC.
     *   * `0 2 8 * * `    : once a month on 8th day at 2 past midnight in UTC.
     *
     * Generated from protobuf field <code>string text = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setText($var)
    {
        GPBUtil::checkString($var, True);
        $this->text = $var;

        return $this;
    }

    /**
     * Output only. The time zone of the times in `CrontabSpec.text`. Currently
     * only UTC is supported.
     *
     * Generated from protobuf field <code>string time_zone = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getTimeZone()
    {
        return $this->time_zone;
    }

    /**
     * Output only. The time zone of the times in `CrontabSpec.text`. Currently
     * only UTC is supported.
     *
     * Generated from protobuf field <code>string time_zone = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setTimeZone($var)
    {
        GPBUtil::checkString($var, True);
        $this->time_zone = $var;

        return $this;
    }

    /**
     * Output only. Schedule backups will contain an externally consistent copy
     * of the database at the version time specified in
     * `schedule_spec.cron_spec`. However, Spanner may not initiate the creation
     * of the scheduled backups at that version time. Spanner will initiate
     * the creation of scheduled backups within the time window bounded by the
     * version_time specified in `schedule_spec.cron_spec` and version_time +
     * `creation_window`.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration creation_window = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Duration|null
     */
    public function getCreationWindow()
    {
        return $this->creation_window;
    }

    public function hasCreationWindow()
    {
        return isset($this->creation_window);
    }

    public function clearCreationWindow()
    {
        unset($this->creation_window);
    }

    /**
     * Output only. Schedule backups will contain an externally consistent copy
     * of the database at the version time specified in
     * `schedule_spec.cron_spec`. However, Spanner may not initiate the creation
     * of the scheduled backups at that version time. Spanner will initiate
     * the creation of scheduled backups within the time window bounded by the
     * version_time specified in `schedule_spec.cron_spec` and version_time +
     * `creation_window`.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration creation_window = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Duration $var
     * @return $this
     */
    public function setCreationWindow($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Duration::class);
        $this->creation_window = $var;

        return $this;
    }

}

