<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/servicedirectory/v1beta1/endpoint.proto

namespace Google\Cloud\ServiceDirectory\V1beta1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * An individual endpoint that provides a
 * [service][google.cloud.servicedirectory.v1beta1.Service]. The service must
 * already exist to create an endpoint.
 *
 * Generated from protobuf message <code>google.cloud.servicedirectory.v1beta1.Endpoint</code>
 */
class Endpoint extends \Google\Protobuf\Internal\Message
{
    /**
     * Immutable. The resource name for the endpoint in the format
     * `projects/&#42;&#47;locations/&#42;&#47;namespaces/&#42;&#47;services/&#42;&#47;endpoints/&#42;`.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     */
    private $name = '';
    /**
     * Optional. An IPv4 or IPv6 address. Service Directory rejects bad addresses
     * like:
     * *   `8.8.8`
     * *   `8.8.8.8:53`
     * *   `test:bad:address`
     * *   `[::1]`
     * *   `[::1]:8080`
     * Limited to 45 characters.
     *
     * Generated from protobuf field <code>string address = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $address = '';
    /**
     * Optional. Service Directory rejects values outside of `[0, 65535]`.
     *
     * Generated from protobuf field <code>int32 port = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $port = 0;
    /**
     * Optional. Metadata for the endpoint. This data can be consumed by service
     * clients.
     * Restrictions:
     * *   The entire metadata dictionary may contain up to 512 characters,
     *     spread accoss all key-value pairs. Metadata that goes beyond this
     *     limit are rejected
     * *   Valid metadata keys have two segments: an optional prefix and name,
     *     separated by a slash (/). The name segment is required and must be 63
     *     characters or less, beginning and ending with an alphanumeric character
     *     ([a-z0-9A-Z]) with dashes (-), underscores (_), dots (.), and
     *     alphanumerics between. The prefix is optional. If specified, the prefix
     *     must be a DNS subdomain: a series of DNS labels separated by dots (.),
     *     not longer than 253 characters in total, followed by a slash (/).
     *     Metadata that fails to meet these requirements are rejected
     * Note: This field is equivalent to the `annotations` field in the v1 API.
     * They have the same syntax and read/write to the same location in Service
     * Directory.
     *
     * Generated from protobuf field <code>map<string, string> metadata = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $metadata;
    /**
     * Immutable. The Google Compute Engine network (VPC) of the endpoint in the
     * format `projects/<project number>/locations/global/networks/&#42;`.
     * The project must be specified by project number (project id is rejected).
     * Incorrectly formatted networks are rejected, but no other validation
     * is performed on this field (ex. network or project existence, reachability,
     * or permissions).
     *
     * Generated from protobuf field <code>string network = 5 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = {</code>
     */
    private $network = '';
    /**
     * Output only. The timestamp when the endpoint was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $create_time = null;
    /**
     * Output only. The timestamp when the endpoint was last updated.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $update_time = null;
    /**
     * Output only. A globally unique identifier (in UUID4 format) for this
     * endpoint.
     *
     * Generated from protobuf field <code>string uid = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $uid = '';

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           Immutable. The resource name for the endpoint in the format
     *           `projects/&#42;&#47;locations/&#42;&#47;namespaces/&#42;&#47;services/&#42;&#47;endpoints/&#42;`.
     *     @type string $address
     *           Optional. An IPv4 or IPv6 address. Service Directory rejects bad addresses
     *           like:
     *           *   `8.8.8`
     *           *   `8.8.8.8:53`
     *           *   `test:bad:address`
     *           *   `[::1]`
     *           *   `[::1]:8080`
     *           Limited to 45 characters.
     *     @type int $port
     *           Optional. Service Directory rejects values outside of `[0, 65535]`.
     *     @type array|\Google\Protobuf\Internal\MapField $metadata
     *           Optional. Metadata for the endpoint. This data can be consumed by service
     *           clients.
     *           Restrictions:
     *           *   The entire metadata dictionary may contain up to 512 characters,
     *               spread accoss all key-value pairs. Metadata that goes beyond this
     *               limit are rejected
     *           *   Valid metadata keys have two segments: an optional prefix and name,
     *               separated by a slash (/). The name segment is required and must be 63
     *               characters or less, beginning and ending with an alphanumeric character
     *               ([a-z0-9A-Z]) with dashes (-), underscores (_), dots (.), and
     *               alphanumerics between. The prefix is optional. If specified, the prefix
     *               must be a DNS subdomain: a series of DNS labels separated by dots (.),
     *               not longer than 253 characters in total, followed by a slash (/).
     *               Metadata that fails to meet these requirements are rejected
     *           Note: This field is equivalent to the `annotations` field in the v1 API.
     *           They have the same syntax and read/write to the same location in Service
     *           Directory.
     *     @type string $network
     *           Immutable. The Google Compute Engine network (VPC) of the endpoint in the
     *           format `projects/<project number>/locations/global/networks/&#42;`.
     *           The project must be specified by project number (project id is rejected).
     *           Incorrectly formatted networks are rejected, but no other validation
     *           is performed on this field (ex. network or project existence, reachability,
     *           or permissions).
     *     @type \Google\Protobuf\Timestamp $create_time
     *           Output only. The timestamp when the endpoint was created.
     *     @type \Google\Protobuf\Timestamp $update_time
     *           Output only. The timestamp when the endpoint was last updated.
     *     @type string $uid
     *           Output only. A globally unique identifier (in UUID4 format) for this
     *           endpoint.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Servicedirectory\V1Beta1\Endpoint::initOnce();
        parent::__construct($data);
    }

    /**
     * Immutable. The resource name for the endpoint in the format
     * `projects/&#42;&#47;locations/&#42;&#47;namespaces/&#42;&#47;services/&#42;&#47;endpoints/&#42;`.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Immutable. The resource name for the endpoint in the format
     * `projects/&#42;&#47;locations/&#42;&#47;namespaces/&#42;&#47;services/&#42;&#47;endpoints/&#42;`.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Optional. An IPv4 or IPv6 address. Service Directory rejects bad addresses
     * like:
     * *   `8.8.8`
     * *   `8.8.8.8:53`
     * *   `test:bad:address`
     * *   `[::1]`
     * *   `[::1]:8080`
     * Limited to 45 characters.
     *
     * Generated from protobuf field <code>string address = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getAddress()
    {
        return $this->address;
    }

    /**
     * Optional. An IPv4 or IPv6 address. Service Directory rejects bad addresses
     * like:
     * *   `8.8.8`
     * *   `8.8.8.8:53`
     * *   `test:bad:address`
     * *   `[::1]`
     * *   `[::1]:8080`
     * Limited to 45 characters.
     *
     * Generated from protobuf field <code>string address = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setAddress($var)
    {
        GPBUtil::checkString($var, True);
        $this->address = $var;

        return $this;
    }

    /**
     * Optional. Service Directory rejects values outside of `[0, 65535]`.
     *
     * Generated from protobuf field <code>int32 port = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return int
     */
    public function getPort()
    {
        return $this->port;
    }

    /**
     * Optional. Service Directory rejects values outside of `[0, 65535]`.
     *
     * Generated from protobuf field <code>int32 port = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param int $var
     * @return $this
     */
    public function setPort($var)
    {
        GPBUtil::checkInt32($var);
        $this->port = $var;

        return $this;
    }

    /**
     * Optional. Metadata for the endpoint. This data can be consumed by service
     * clients.
     * Restrictions:
     * *   The entire metadata dictionary may contain up to 512 characters,
     *     spread accoss all key-value pairs. Metadata that goes beyond this
     *     limit are rejected
     * *   Valid metadata keys have two segments: an optional prefix and name,
     *     separated by a slash (/). The name segment is required and must be 63
     *     characters or less, beginning and ending with an alphanumeric character
     *     ([a-z0-9A-Z]) with dashes (-), underscores (_), dots (.), and
     *     alphanumerics between. The prefix is optional. If specified, the prefix
     *     must be a DNS subdomain: a series of DNS labels separated by dots (.),
     *     not longer than 253 characters in total, followed by a slash (/).
     *     Metadata that fails to meet these requirements are rejected
     * Note: This field is equivalent to the `annotations` field in the v1 API.
     * They have the same syntax and read/write to the same location in Service
     * Directory.
     *
     * Generated from protobuf field <code>map<string, string> metadata = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getMetadata()
    {
        return $this->metadata;
    }

    /**
     * Optional. Metadata for the endpoint. This data can be consumed by service
     * clients.
     * Restrictions:
     * *   The entire metadata dictionary may contain up to 512 characters,
     *     spread accoss all key-value pairs. Metadata that goes beyond this
     *     limit are rejected
     * *   Valid metadata keys have two segments: an optional prefix and name,
     *     separated by a slash (/). The name segment is required and must be 63
     *     characters or less, beginning and ending with an alphanumeric character
     *     ([a-z0-9A-Z]) with dashes (-), underscores (_), dots (.), and
     *     alphanumerics between. The prefix is optional. If specified, the prefix
     *     must be a DNS subdomain: a series of DNS labels separated by dots (.),
     *     not longer than 253 characters in total, followed by a slash (/).
     *     Metadata that fails to meet these requirements are rejected
     * Note: This field is equivalent to the `annotations` field in the v1 API.
     * They have the same syntax and read/write to the same location in Service
     * Directory.
     *
     * Generated from protobuf field <code>map<string, string> metadata = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setMetadata($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::STRING);
        $this->metadata = $arr;

        return $this;
    }

    /**
     * Immutable. The Google Compute Engine network (VPC) of the endpoint in the
     * format `projects/<project number>/locations/global/networks/&#42;`.
     * The project must be specified by project number (project id is rejected).
     * Incorrectly formatted networks are rejected, but no other validation
     * is performed on this field (ex. network or project existence, reachability,
     * or permissions).
     *
     * Generated from protobuf field <code>string network = 5 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getNetwork()
    {
        return $this->network;
    }

    /**
     * Immutable. The Google Compute Engine network (VPC) of the endpoint in the
     * format `projects/<project number>/locations/global/networks/&#42;`.
     * The project must be specified by project number (project id is rejected).
     * Incorrectly formatted networks are rejected, but no other validation
     * is performed on this field (ex. network or project existence, reachability,
     * or permissions).
     *
     * Generated from protobuf field <code>string network = 5 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setNetwork($var)
    {
        GPBUtil::checkString($var, True);
        $this->network = $var;

        return $this;
    }

    /**
     * Output only. The timestamp when the endpoint was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getCreateTime()
    {
        return $this->create_time;
    }

    public function hasCreateTime()
    {
        return isset($this->create_time);
    }

    public function clearCreateTime()
    {
        unset($this->create_time);
    }

    /**
     * Output only. The timestamp when the endpoint was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setCreateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->create_time = $var;

        return $this;
    }

    /**
     * Output only. The timestamp when the endpoint was last updated.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getUpdateTime()
    {
        return $this->update_time;
    }

    public function hasUpdateTime()
    {
        return isset($this->update_time);
    }

    public function clearUpdateTime()
    {
        unset($this->update_time);
    }

    /**
     * Output only. The timestamp when the endpoint was last updated.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setUpdateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->update_time = $var;

        return $this;
    }

    /**
     * Output only. A globally unique identifier (in UUID4 format) for this
     * endpoint.
     *
     * Generated from protobuf field <code>string uid = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getUid()
    {
        return $this->uid;
    }

    /**
     * Output only. A globally unique identifier (in UUID4 format) for this
     * endpoint.
     *
     * Generated from protobuf field <code>string uid = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setUid($var)
    {
        GPBUtil::checkString($var, True);
        $this->uid = $var;

        return $this;
    }

}

