<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/securitycenter/v1/event_threat_detection_custom_module.proto

namespace Google\Cloud\SecurityCenter\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Represents an instance of an Event Threat Detection custom module,
 * including its full module name, display name, enablement state, and last
 * updated time. You can create a custom module at the organization, folder, or
 * project level. Custom modules that you create at the organization or folder
 * level are inherited by child folders and projects.
 *
 * Generated from protobuf message <code>google.cloud.securitycenter.v1.EventThreatDetectionCustomModule</code>
 */
class EventThreatDetectionCustomModule extends \Google\Protobuf\Internal\Message
{
    /**
     * Immutable. The resource name of the Event Threat Detection custom module.
     * Its format is:
     *   * `organizations/{organization}/eventThreatDetectionSettings/customModules/{module}`.
     *   * `folders/{folder}/eventThreatDetectionSettings/customModules/{module}`.
     *   * `projects/{project}/eventThreatDetectionSettings/customModules/{module}`.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     */
    private $name = '';
    /**
     * Config for the module. For the resident module, its config value is defined
     * at this level. For the inherited module, its config value is inherited from
     * the ancestor module.
     *
     * Generated from protobuf field <code>.google.protobuf.Struct config = 2;</code>
     */
    private $config = null;
    /**
     * Output only. The closest ancestor module that this module inherits the
     * enablement state from. The format is the same as the
     * EventThreatDetectionCustomModule resource name.
     *
     * Generated from protobuf field <code>string ancestor_module = 3 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     */
    private $ancestor_module = '';
    /**
     * The state of enablement for the module at the given level of the hierarchy.
     *
     * Generated from protobuf field <code>.google.cloud.securitycenter.v1.EventThreatDetectionCustomModule.EnablementState enablement_state = 4;</code>
     */
    private $enablement_state = 0;
    /**
     * Type for the module. e.g. CONFIGURABLE_BAD_IP.
     *
     * Generated from protobuf field <code>string type = 5;</code>
     */
    private $type = '';
    /**
     * The human readable name to be displayed for the module.
     *
     * Generated from protobuf field <code>string display_name = 6;</code>
     */
    private $display_name = '';
    /**
     * The description for the module.
     *
     * Generated from protobuf field <code>string description = 7;</code>
     */
    private $description = '';
    /**
     * Output only. The time the module was last updated.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $update_time = null;
    /**
     * Output only. The editor the module was last updated by.
     *
     * Generated from protobuf field <code>string last_editor = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $last_editor = '';

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           Immutable. The resource name of the Event Threat Detection custom module.
     *           Its format is:
     *             * `organizations/{organization}/eventThreatDetectionSettings/customModules/{module}`.
     *             * `folders/{folder}/eventThreatDetectionSettings/customModules/{module}`.
     *             * `projects/{project}/eventThreatDetectionSettings/customModules/{module}`.
     *     @type \Google\Protobuf\Struct $config
     *           Config for the module. For the resident module, its config value is defined
     *           at this level. For the inherited module, its config value is inherited from
     *           the ancestor module.
     *     @type string $ancestor_module
     *           Output only. The closest ancestor module that this module inherits the
     *           enablement state from. The format is the same as the
     *           EventThreatDetectionCustomModule resource name.
     *     @type int $enablement_state
     *           The state of enablement for the module at the given level of the hierarchy.
     *     @type string $type
     *           Type for the module. e.g. CONFIGURABLE_BAD_IP.
     *     @type string $display_name
     *           The human readable name to be displayed for the module.
     *     @type string $description
     *           The description for the module.
     *     @type \Google\Protobuf\Timestamp $update_time
     *           Output only. The time the module was last updated.
     *     @type string $last_editor
     *           Output only. The editor the module was last updated by.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Securitycenter\V1\EventThreatDetectionCustomModule::initOnce();
        parent::__construct($data);
    }

    /**
     * Immutable. The resource name of the Event Threat Detection custom module.
     * Its format is:
     *   * `organizations/{organization}/eventThreatDetectionSettings/customModules/{module}`.
     *   * `folders/{folder}/eventThreatDetectionSettings/customModules/{module}`.
     *   * `projects/{project}/eventThreatDetectionSettings/customModules/{module}`.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Immutable. The resource name of the Event Threat Detection custom module.
     * Its format is:
     *   * `organizations/{organization}/eventThreatDetectionSettings/customModules/{module}`.
     *   * `folders/{folder}/eventThreatDetectionSettings/customModules/{module}`.
     *   * `projects/{project}/eventThreatDetectionSettings/customModules/{module}`.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Config for the module. For the resident module, its config value is defined
     * at this level. For the inherited module, its config value is inherited from
     * the ancestor module.
     *
     * Generated from protobuf field <code>.google.protobuf.Struct config = 2;</code>
     * @return \Google\Protobuf\Struct|null
     */
    public function getConfig()
    {
        return $this->config;
    }

    public function hasConfig()
    {
        return isset($this->config);
    }

    public function clearConfig()
    {
        unset($this->config);
    }

    /**
     * Config for the module. For the resident module, its config value is defined
     * at this level. For the inherited module, its config value is inherited from
     * the ancestor module.
     *
     * Generated from protobuf field <code>.google.protobuf.Struct config = 2;</code>
     * @param \Google\Protobuf\Struct $var
     * @return $this
     */
    public function setConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Struct::class);
        $this->config = $var;

        return $this;
    }

    /**
     * Output only. The closest ancestor module that this module inherits the
     * enablement state from. The format is the same as the
     * EventThreatDetectionCustomModule resource name.
     *
     * Generated from protobuf field <code>string ancestor_module = 3 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getAncestorModule()
    {
        return $this->ancestor_module;
    }

    /**
     * Output only. The closest ancestor module that this module inherits the
     * enablement state from. The format is the same as the
     * EventThreatDetectionCustomModule resource name.
     *
     * Generated from protobuf field <code>string ancestor_module = 3 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setAncestorModule($var)
    {
        GPBUtil::checkString($var, True);
        $this->ancestor_module = $var;

        return $this;
    }

    /**
     * The state of enablement for the module at the given level of the hierarchy.
     *
     * Generated from protobuf field <code>.google.cloud.securitycenter.v1.EventThreatDetectionCustomModule.EnablementState enablement_state = 4;</code>
     * @return int
     */
    public function getEnablementState()
    {
        return $this->enablement_state;
    }

    /**
     * The state of enablement for the module at the given level of the hierarchy.
     *
     * Generated from protobuf field <code>.google.cloud.securitycenter.v1.EventThreatDetectionCustomModule.EnablementState enablement_state = 4;</code>
     * @param int $var
     * @return $this
     */
    public function setEnablementState($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\SecurityCenter\V1\EventThreatDetectionCustomModule\EnablementState::class);
        $this->enablement_state = $var;

        return $this;
    }

    /**
     * Type for the module. e.g. CONFIGURABLE_BAD_IP.
     *
     * Generated from protobuf field <code>string type = 5;</code>
     * @return string
     */
    public function getType()
    {
        return $this->type;
    }

    /**
     * Type for the module. e.g. CONFIGURABLE_BAD_IP.
     *
     * Generated from protobuf field <code>string type = 5;</code>
     * @param string $var
     * @return $this
     */
    public function setType($var)
    {
        GPBUtil::checkString($var, True);
        $this->type = $var;

        return $this;
    }

    /**
     * The human readable name to be displayed for the module.
     *
     * Generated from protobuf field <code>string display_name = 6;</code>
     * @return string
     */
    public function getDisplayName()
    {
        return $this->display_name;
    }

    /**
     * The human readable name to be displayed for the module.
     *
     * Generated from protobuf field <code>string display_name = 6;</code>
     * @param string $var
     * @return $this
     */
    public function setDisplayName($var)
    {
        GPBUtil::checkString($var, True);
        $this->display_name = $var;

        return $this;
    }

    /**
     * The description for the module.
     *
     * Generated from protobuf field <code>string description = 7;</code>
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * The description for the module.
     *
     * Generated from protobuf field <code>string description = 7;</code>
     * @param string $var
     * @return $this
     */
    public function setDescription($var)
    {
        GPBUtil::checkString($var, True);
        $this->description = $var;

        return $this;
    }

    /**
     * Output only. The time the module was last updated.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getUpdateTime()
    {
        return $this->update_time;
    }

    public function hasUpdateTime()
    {
        return isset($this->update_time);
    }

    public function clearUpdateTime()
    {
        unset($this->update_time);
    }

    /**
     * Output only. The time the module was last updated.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setUpdateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->update_time = $var;

        return $this;
    }

    /**
     * Output only. The editor the module was last updated by.
     *
     * Generated from protobuf field <code>string last_editor = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getLastEditor()
    {
        return $this->last_editor;
    }

    /**
     * Output only. The editor the module was last updated by.
     *
     * Generated from protobuf field <code>string last_editor = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setLastEditor($var)
    {
        GPBUtil::checkString($var, True);
        $this->last_editor = $var;

        return $this;
    }

}

