<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/privacy/dlp/v2/dlp.proto

namespace Google\Cloud\Dlp\V2;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Cloud SQL connection properties.
 *
 * Generated from protobuf message <code>google.privacy.dlp.v2.CloudSqlProperties</code>
 */
class CloudSqlProperties extends \Google\Protobuf\Internal\Message
{
    /**
     * Optional. Immutable. The Cloud SQL instance for which the connection is
     * defined. Only one connection per instance is allowed. This can only be set
     * at creation time, and cannot be updated.
     * It is an error to use a connection_name from different project or region
     * than the one that holds the connection.
     * For example, a Connection resource for Cloud SQL connection_name
     * `project-id:us-central1:sql-instance`
     * must be created under the parent
     * `projects/project-id/locations/us-central1`
     *
     * Generated from protobuf field <code>string connection_name = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $connection_name = '';
    /**
     * Required. DLP will limit its connections to max_connections.
     * Must be 2 or greater.
     *
     * Generated from protobuf field <code>int32 max_connections = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    private $max_connections = 0;
    /**
     * Required. The database engine used by the Cloud SQL instance that this
     * connection configures.
     *
     * Generated from protobuf field <code>.google.privacy.dlp.v2.CloudSqlProperties.DatabaseEngine database_engine = 7 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    private $database_engine = 0;
    protected $credential;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $connection_name
     *           Optional. Immutable. The Cloud SQL instance for which the connection is
     *           defined. Only one connection per instance is allowed. This can only be set
     *           at creation time, and cannot be updated.
     *           It is an error to use a connection_name from different project or region
     *           than the one that holds the connection.
     *           For example, a Connection resource for Cloud SQL connection_name
     *           `project-id:us-central1:sql-instance`
     *           must be created under the parent
     *           `projects/project-id/locations/us-central1`
     *     @type \Google\Cloud\Dlp\V2\SecretManagerCredential $username_password
     *           A username and password stored in Secret Manager.
     *     @type \Google\Cloud\Dlp\V2\CloudSqlIamCredential $cloud_sql_iam
     *           Built-in IAM authentication (must be configured in Cloud SQL).
     *     @type int $max_connections
     *           Required. DLP will limit its connections to max_connections.
     *           Must be 2 or greater.
     *     @type int $database_engine
     *           Required. The database engine used by the Cloud SQL instance that this
     *           connection configures.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Privacy\Dlp\V2\Dlp::initOnce();
        parent::__construct($data);
    }

    /**
     * Optional. Immutable. The Cloud SQL instance for which the connection is
     * defined. Only one connection per instance is allowed. This can only be set
     * at creation time, and cannot be updated.
     * It is an error to use a connection_name from different project or region
     * than the one that holds the connection.
     * For example, a Connection resource for Cloud SQL connection_name
     * `project-id:us-central1:sql-instance`
     * must be created under the parent
     * `projects/project-id/locations/us-central1`
     *
     * Generated from protobuf field <code>string connection_name = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getConnectionName()
    {
        return $this->connection_name;
    }

    /**
     * Optional. Immutable. The Cloud SQL instance for which the connection is
     * defined. Only one connection per instance is allowed. This can only be set
     * at creation time, and cannot be updated.
     * It is an error to use a connection_name from different project or region
     * than the one that holds the connection.
     * For example, a Connection resource for Cloud SQL connection_name
     * `project-id:us-central1:sql-instance`
     * must be created under the parent
     * `projects/project-id/locations/us-central1`
     *
     * Generated from protobuf field <code>string connection_name = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setConnectionName($var)
    {
        GPBUtil::checkString($var, True);
        $this->connection_name = $var;

        return $this;
    }

    /**
     * A username and password stored in Secret Manager.
     *
     * Generated from protobuf field <code>.google.privacy.dlp.v2.SecretManagerCredential username_password = 2;</code>
     * @return \Google\Cloud\Dlp\V2\SecretManagerCredential|null
     */
    public function getUsernamePassword()
    {
        return $this->readOneof(2);
    }

    public function hasUsernamePassword()
    {
        return $this->hasOneof(2);
    }

    /**
     * A username and password stored in Secret Manager.
     *
     * Generated from protobuf field <code>.google.privacy.dlp.v2.SecretManagerCredential username_password = 2;</code>
     * @param \Google\Cloud\Dlp\V2\SecretManagerCredential $var
     * @return $this
     */
    public function setUsernamePassword($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Dlp\V2\SecretManagerCredential::class);
        $this->writeOneof(2, $var);

        return $this;
    }

    /**
     * Built-in IAM authentication (must be configured in Cloud SQL).
     *
     * Generated from protobuf field <code>.google.privacy.dlp.v2.CloudSqlIamCredential cloud_sql_iam = 3;</code>
     * @return \Google\Cloud\Dlp\V2\CloudSqlIamCredential|null
     */
    public function getCloudSqlIam()
    {
        return $this->readOneof(3);
    }

    public function hasCloudSqlIam()
    {
        return $this->hasOneof(3);
    }

    /**
     * Built-in IAM authentication (must be configured in Cloud SQL).
     *
     * Generated from protobuf field <code>.google.privacy.dlp.v2.CloudSqlIamCredential cloud_sql_iam = 3;</code>
     * @param \Google\Cloud\Dlp\V2\CloudSqlIamCredential $var
     * @return $this
     */
    public function setCloudSqlIam($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Dlp\V2\CloudSqlIamCredential::class);
        $this->writeOneof(3, $var);

        return $this;
    }

    /**
     * Required. DLP will limit its connections to max_connections.
     * Must be 2 or greater.
     *
     * Generated from protobuf field <code>int32 max_connections = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return int
     */
    public function getMaxConnections()
    {
        return $this->max_connections;
    }

    /**
     * Required. DLP will limit its connections to max_connections.
     * Must be 2 or greater.
     *
     * Generated from protobuf field <code>int32 max_connections = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param int $var
     * @return $this
     */
    public function setMaxConnections($var)
    {
        GPBUtil::checkInt32($var);
        $this->max_connections = $var;

        return $this;
    }

    /**
     * Required. The database engine used by the Cloud SQL instance that this
     * connection configures.
     *
     * Generated from protobuf field <code>.google.privacy.dlp.v2.CloudSqlProperties.DatabaseEngine database_engine = 7 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return int
     */
    public function getDatabaseEngine()
    {
        return $this->database_engine;
    }

    /**
     * Required. The database engine used by the Cloud SQL instance that this
     * connection configures.
     *
     * Generated from protobuf field <code>.google.privacy.dlp.v2.CloudSqlProperties.DatabaseEngine database_engine = 7 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param int $var
     * @return $this
     */
    public function setDatabaseEngine($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Dlp\V2\CloudSqlProperties\DatabaseEngine::class);
        $this->database_engine = $var;

        return $this;
    }

    /**
     * @return string
     */
    public function getCredential()
    {
        return $this->whichOneof("credential");
    }

}

