<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/chat/v1/message.proto

namespace Google\Apps\Chat\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * A thread in a Google Chat space. For example usage, see
 * [Start or reply to a message
 * thread](https://developers.google.com/workspace/chat/create-messages#create-message-thread).
 * If you specify a thread when creating a message, you can set the
 * [`messageReplyOption`](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces.messages/create#messagereplyoption)
 * field to determine what happens if no matching thread is found.
 *
 * Generated from protobuf message <code>google.chat.v1.Thread</code>
 */
class Thread extends \Google\Protobuf\Internal\Message
{
    /**
     * Output only. Resource name of the thread.
     * Example: `spaces/{space}/threads/{thread}`
     *
     * Generated from protobuf field <code>string name = 1;</code>
     */
    protected $name = '';
    /**
     * Optional. Input for creating or updating a thread. Otherwise, output only.
     * ID for the thread. Supports up to 4000 characters.
     * This ID is unique to the Chat app that sets it. For example, if
     * multiple Chat apps create a message using the same thread key,
     * the messages are posted in different threads. To reply in a
     * thread created by a person or another Chat app, specify the thread `name`
     * field instead.
     *
     * Generated from protobuf field <code>string thread_key = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $thread_key = '';

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           Output only. Resource name of the thread.
     *           Example: `spaces/{space}/threads/{thread}`
     *     @type string $thread_key
     *           Optional. Input for creating or updating a thread. Otherwise, output only.
     *           ID for the thread. Supports up to 4000 characters.
     *           This ID is unique to the Chat app that sets it. For example, if
     *           multiple Chat apps create a message using the same thread key,
     *           the messages are posted in different threads. To reply in a
     *           thread created by a person or another Chat app, specify the thread `name`
     *           field instead.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Chat\V1\Message::initOnce();
        parent::__construct($data);
    }

    /**
     * Output only. Resource name of the thread.
     * Example: `spaces/{space}/threads/{thread}`
     *
     * Generated from protobuf field <code>string name = 1;</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Output only. Resource name of the thread.
     * Example: `spaces/{space}/threads/{thread}`
     *
     * Generated from protobuf field <code>string name = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Optional. Input for creating or updating a thread. Otherwise, output only.
     * ID for the thread. Supports up to 4000 characters.
     * This ID is unique to the Chat app that sets it. For example, if
     * multiple Chat apps create a message using the same thread key,
     * the messages are posted in different threads. To reply in a
     * thread created by a person or another Chat app, specify the thread `name`
     * field instead.
     *
     * Generated from protobuf field <code>string thread_key = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getThreadKey()
    {
        return $this->thread_key;
    }

    /**
     * Optional. Input for creating or updating a thread. Otherwise, output only.
     * ID for the thread. Supports up to 4000 characters.
     * This ID is unique to the Chat app that sets it. For example, if
     * multiple Chat apps create a message using the same thread key,
     * the messages are posted in different threads. To reply in a
     * thread created by a person or another Chat app, specify the thread `name`
     * field instead.
     *
     * Generated from protobuf field <code>string thread_key = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setThreadKey($var)
    {
        GPBUtil::checkString($var, True);
        $this->thread_key = $var;

        return $this;
    }

}

