<?php
/*
 * Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/devtools/cloudbuild/v1/cloudbuild.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\Build\V1\Gapic;

use Google\ApiCore\ApiException;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\LongRunning\OperationsClient;
use Google\ApiCore\OperationResponse;
use Google\ApiCore\PathTemplate;
use Google\ApiCore\RequestParamsHeaderDescriptor;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Api\HttpBody;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\Build\V1\ApprovalResult;
use Google\Cloud\Build\V1\ApproveBuildRequest;
use Google\Cloud\Build\V1\Build;
use Google\Cloud\Build\V1\BuildTrigger;
use Google\Cloud\Build\V1\CancelBuildRequest;
use Google\Cloud\Build\V1\CreateBuildRequest;
use Google\Cloud\Build\V1\CreateBuildTriggerRequest;
use Google\Cloud\Build\V1\CreateWorkerPoolRequest;
use Google\Cloud\Build\V1\DeleteBuildTriggerRequest;
use Google\Cloud\Build\V1\DeleteWorkerPoolRequest;
use Google\Cloud\Build\V1\GetBuildRequest;
use Google\Cloud\Build\V1\GetBuildTriggerRequest;
use Google\Cloud\Build\V1\GetWorkerPoolRequest;
use Google\Cloud\Build\V1\ListBuildTriggersRequest;
use Google\Cloud\Build\V1\ListBuildTriggersResponse;
use Google\Cloud\Build\V1\ListBuildsRequest;
use Google\Cloud\Build\V1\ListBuildsResponse;
use Google\Cloud\Build\V1\ListWorkerPoolsRequest;
use Google\Cloud\Build\V1\ListWorkerPoolsResponse;
use Google\Cloud\Build\V1\ReceiveTriggerWebhookRequest;
use Google\Cloud\Build\V1\ReceiveTriggerWebhookResponse;
use Google\Cloud\Build\V1\RepoSource;
use Google\Cloud\Build\V1\RetryBuildRequest;
use Google\Cloud\Build\V1\RunBuildTriggerRequest;
use Google\Cloud\Build\V1\UpdateBuildTriggerRequest;
use Google\Cloud\Build\V1\UpdateWorkerPoolRequest;
use Google\Cloud\Build\V1\WorkerPool;
use Google\LongRunning\Operation;
use Google\Protobuf\FieldMask;
use Google\Protobuf\GPBEmpty;

/**
 * Service Description: Creates and manages builds on Google Cloud Platform.
 *
 * The main concept used by this API is a `Build`, which describes the location
 * of the source to build, how to build the source, and where to store the
 * built artifacts, if any.
 *
 * A user can list previously-requested builds or get builds by their ID to
 * determine the status of the build.
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods. Sample code to get started:
 *
 * ```
 * $cloudBuildClient = new CloudBuildClient();
 * try {
 *     $name = 'name';
 *     $operationResponse = $cloudBuildClient->approveBuild($name);
 *     $operationResponse->pollUntilComplete();
 *     if ($operationResponse->operationSucceeded()) {
 *         $result = $operationResponse->getResult();
 *     // doSomethingWith($result)
 *     } else {
 *         $error = $operationResponse->getError();
 *         // handleError($error)
 *     }
 *     // Alternatively:
 *     // start the operation, keep the operation name, and resume later
 *     $operationResponse = $cloudBuildClient->approveBuild($name);
 *     $operationName = $operationResponse->getName();
 *     // ... do other work
 *     $newOperationResponse = $cloudBuildClient->resumeOperation($operationName, 'approveBuild');
 *     while (!$newOperationResponse->isDone()) {
 *         // ... do other work
 *         $newOperationResponse->reload();
 *     }
 *     if ($newOperationResponse->operationSucceeded()) {
 *         $result = $newOperationResponse->getResult();
 *     // doSomethingWith($result)
 *     } else {
 *         $error = $newOperationResponse->getError();
 *         // handleError($error)
 *     }
 * } finally {
 *     $cloudBuildClient->close();
 * }
 * ```
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 */
class CloudBuildGapicClient
{
    use GapicClientTrait;

    /** The name of the service. */
    const SERVICE_NAME = 'google.devtools.cloudbuild.v1.CloudBuild';

    /** The default address of the service. */
    const SERVICE_ADDRESS = 'cloudbuild.googleapis.com';

    /** The default port of the service. */
    const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = [
        'https://www.googleapis.com/auth/cloud-platform',
    ];

    private static $buildNameTemplate;

    private static $buildTriggerNameTemplate;

    private static $cryptoKeyNameTemplate;

    private static $locationNameTemplate;

    private static $networkNameTemplate;

    private static $projectNameTemplate;

    private static $projectBuildNameTemplate;

    private static $projectLocationBuildNameTemplate;

    private static $projectLocationTriggerNameTemplate;

    private static $projectTriggerNameTemplate;

    private static $secretVersionNameTemplate;

    private static $serviceAccountNameTemplate;

    private static $subscriptionNameTemplate;

    private static $topicNameTemplate;

    private static $workerPoolNameTemplate;

    private static $pathTemplateMap;

    private $operationsClient;

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' => self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' => __DIR__ . '/../resources/cloud_build_client_config.json',
            'descriptorsConfigPath' => __DIR__ . '/../resources/cloud_build_descriptor_config.php',
            'gcpApiConfigPath' => __DIR__ . '/../resources/cloud_build_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' => __DIR__ . '/../resources/cloud_build_rest_client_config.php',
                ],
            ],
        ];
    }

    private static function getBuildNameTemplate()
    {
        if (self::$buildNameTemplate == null) {
            self::$buildNameTemplate = new PathTemplate('projects/{project}/builds/{build}');
        }

        return self::$buildNameTemplate;
    }

    private static function getBuildTriggerNameTemplate()
    {
        if (self::$buildTriggerNameTemplate == null) {
            self::$buildTriggerNameTemplate = new PathTemplate('projects/{project}/triggers/{trigger}');
        }

        return self::$buildTriggerNameTemplate;
    }

    private static function getCryptoKeyNameTemplate()
    {
        if (self::$cryptoKeyNameTemplate == null) {
            self::$cryptoKeyNameTemplate = new PathTemplate('projects/{project}/locations/{location}/keyRings/{keyring}/cryptoKeys/{key}');
        }

        return self::$cryptoKeyNameTemplate;
    }

    private static function getLocationNameTemplate()
    {
        if (self::$locationNameTemplate == null) {
            self::$locationNameTemplate = new PathTemplate('projects/{project}/locations/{location}');
        }

        return self::$locationNameTemplate;
    }

    private static function getNetworkNameTemplate()
    {
        if (self::$networkNameTemplate == null) {
            self::$networkNameTemplate = new PathTemplate('projects/{project}/global/networks/{network}');
        }

        return self::$networkNameTemplate;
    }

    private static function getProjectNameTemplate()
    {
        if (self::$projectNameTemplate == null) {
            self::$projectNameTemplate = new PathTemplate('projects/{project}');
        }

        return self::$projectNameTemplate;
    }

    private static function getProjectBuildNameTemplate()
    {
        if (self::$projectBuildNameTemplate == null) {
            self::$projectBuildNameTemplate = new PathTemplate('projects/{project}/builds/{build}');
        }

        return self::$projectBuildNameTemplate;
    }

    private static function getProjectLocationBuildNameTemplate()
    {
        if (self::$projectLocationBuildNameTemplate == null) {
            self::$projectLocationBuildNameTemplate = new PathTemplate('projects/{project}/locations/{location}/builds/{build}');
        }

        return self::$projectLocationBuildNameTemplate;
    }

    private static function getProjectLocationTriggerNameTemplate()
    {
        if (self::$projectLocationTriggerNameTemplate == null) {
            self::$projectLocationTriggerNameTemplate = new PathTemplate('projects/{project}/locations/{location}/triggers/{trigger}');
        }

        return self::$projectLocationTriggerNameTemplate;
    }

    private static function getProjectTriggerNameTemplate()
    {
        if (self::$projectTriggerNameTemplate == null) {
            self::$projectTriggerNameTemplate = new PathTemplate('projects/{project}/triggers/{trigger}');
        }

        return self::$projectTriggerNameTemplate;
    }

    private static function getSecretVersionNameTemplate()
    {
        if (self::$secretVersionNameTemplate == null) {
            self::$secretVersionNameTemplate = new PathTemplate('projects/{project}/secrets/{secret}/versions/{version}');
        }

        return self::$secretVersionNameTemplate;
    }

    private static function getServiceAccountNameTemplate()
    {
        if (self::$serviceAccountNameTemplate == null) {
            self::$serviceAccountNameTemplate = new PathTemplate('projects/{project}/serviceAccounts/{service_account}');
        }

        return self::$serviceAccountNameTemplate;
    }

    private static function getSubscriptionNameTemplate()
    {
        if (self::$subscriptionNameTemplate == null) {
            self::$subscriptionNameTemplate = new PathTemplate('projects/{project}/subscriptions/{subscription}');
        }

        return self::$subscriptionNameTemplate;
    }

    private static function getTopicNameTemplate()
    {
        if (self::$topicNameTemplate == null) {
            self::$topicNameTemplate = new PathTemplate('projects/{project}/topics/{topic}');
        }

        return self::$topicNameTemplate;
    }

    private static function getWorkerPoolNameTemplate()
    {
        if (self::$workerPoolNameTemplate == null) {
            self::$workerPoolNameTemplate = new PathTemplate('projects/{project}/locations/{location}/workerPools/{worker_pool}');
        }

        return self::$workerPoolNameTemplate;
    }

    private static function getPathTemplateMap()
    {
        if (self::$pathTemplateMap == null) {
            self::$pathTemplateMap = [
                'build' => self::getBuildNameTemplate(),
                'buildTrigger' => self::getBuildTriggerNameTemplate(),
                'cryptoKey' => self::getCryptoKeyNameTemplate(),
                'location' => self::getLocationNameTemplate(),
                'network' => self::getNetworkNameTemplate(),
                'project' => self::getProjectNameTemplate(),
                'projectBuild' => self::getProjectBuildNameTemplate(),
                'projectLocationBuild' => self::getProjectLocationBuildNameTemplate(),
                'projectLocationTrigger' => self::getProjectLocationTriggerNameTemplate(),
                'projectTrigger' => self::getProjectTriggerNameTemplate(),
                'secretVersion' => self::getSecretVersionNameTemplate(),
                'serviceAccount' => self::getServiceAccountNameTemplate(),
                'subscription' => self::getSubscriptionNameTemplate(),
                'topic' => self::getTopicNameTemplate(),
                'workerPool' => self::getWorkerPoolNameTemplate(),
            ];
        }

        return self::$pathTemplateMap;
    }

    /**
     * Formats a string containing the fully-qualified path to represent a build
     * resource.
     *
     * @param string $project
     * @param string $build
     *
     * @return string The formatted build resource.
     */
    public static function buildName($project, $build)
    {
        return self::getBuildNameTemplate()->render([
            'project' => $project,
            'build' => $build,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * build_trigger resource.
     *
     * @param string $project
     * @param string $trigger
     *
     * @return string The formatted build_trigger resource.
     */
    public static function buildTriggerName($project, $trigger)
    {
        return self::getBuildTriggerNameTemplate()->render([
            'project' => $project,
            'trigger' => $trigger,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a crypto_key
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $keyring
     * @param string $key
     *
     * @return string The formatted crypto_key resource.
     */
    public static function cryptoKeyName($project, $location, $keyring, $key)
    {
        return self::getCryptoKeyNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'keyring' => $keyring,
            'key' => $key,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a location
     * resource.
     *
     * @param string $project
     * @param string $location
     *
     * @return string The formatted location resource.
     */
    public static function locationName($project, $location)
    {
        return self::getLocationNameTemplate()->render([
            'project' => $project,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a network
     * resource.
     *
     * @param string $project
     * @param string $network
     *
     * @return string The formatted network resource.
     */
    public static function networkName($project, $network)
    {
        return self::getNetworkNameTemplate()->render([
            'project' => $project,
            'network' => $network,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a project
     * resource.
     *
     * @param string $project
     *
     * @return string The formatted project resource.
     */
    public static function projectName($project)
    {
        return self::getProjectNameTemplate()->render([
            'project' => $project,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_build resource.
     *
     * @param string $project
     * @param string $build
     *
     * @return string The formatted project_build resource.
     */
    public static function projectBuildName($project, $build)
    {
        return self::getProjectBuildNameTemplate()->render([
            'project' => $project,
            'build' => $build,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_location_build resource.
     *
     * @param string $project
     * @param string $location
     * @param string $build
     *
     * @return string The formatted project_location_build resource.
     */
    public static function projectLocationBuildName($project, $location, $build)
    {
        return self::getProjectLocationBuildNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'build' => $build,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_location_trigger resource.
     *
     * @param string $project
     * @param string $location
     * @param string $trigger
     *
     * @return string The formatted project_location_trigger resource.
     */
    public static function projectLocationTriggerName($project, $location, $trigger)
    {
        return self::getProjectLocationTriggerNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'trigger' => $trigger,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_trigger resource.
     *
     * @param string $project
     * @param string $trigger
     *
     * @return string The formatted project_trigger resource.
     */
    public static function projectTriggerName($project, $trigger)
    {
        return self::getProjectTriggerNameTemplate()->render([
            'project' => $project,
            'trigger' => $trigger,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * secret_version resource.
     *
     * @param string $project
     * @param string $secret
     * @param string $version
     *
     * @return string The formatted secret_version resource.
     */
    public static function secretVersionName($project, $secret, $version)
    {
        return self::getSecretVersionNameTemplate()->render([
            'project' => $project,
            'secret' => $secret,
            'version' => $version,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * service_account resource.
     *
     * @param string $project
     * @param string $serviceAccount
     *
     * @return string The formatted service_account resource.
     */
    public static function serviceAccountName($project, $serviceAccount)
    {
        return self::getServiceAccountNameTemplate()->render([
            'project' => $project,
            'service_account' => $serviceAccount,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a subscription
     * resource.
     *
     * @param string $project
     * @param string $subscription
     *
     * @return string The formatted subscription resource.
     */
    public static function subscriptionName($project, $subscription)
    {
        return self::getSubscriptionNameTemplate()->render([
            'project' => $project,
            'subscription' => $subscription,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a topic
     * resource.
     *
     * @param string $project
     * @param string $topic
     *
     * @return string The formatted topic resource.
     */
    public static function topicName($project, $topic)
    {
        return self::getTopicNameTemplate()->render([
            'project' => $project,
            'topic' => $topic,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a worker_pool
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $workerPool
     *
     * @return string The formatted worker_pool resource.
     */
    public static function workerPoolName($project, $location, $workerPool)
    {
        return self::getWorkerPoolNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'worker_pool' => $workerPool,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - build: projects/{project}/builds/{build}
     * - buildTrigger: projects/{project}/triggers/{trigger}
     * - cryptoKey: projects/{project}/locations/{location}/keyRings/{keyring}/cryptoKeys/{key}
     * - location: projects/{project}/locations/{location}
     * - network: projects/{project}/global/networks/{network}
     * - project: projects/{project}
     * - projectBuild: projects/{project}/builds/{build}
     * - projectLocationBuild: projects/{project}/locations/{location}/builds/{build}
     * - projectLocationTrigger: projects/{project}/locations/{location}/triggers/{trigger}
     * - projectTrigger: projects/{project}/triggers/{trigger}
     * - secretVersion: projects/{project}/secrets/{secret}/versions/{version}
     * - serviceAccount: projects/{project}/serviceAccounts/{service_account}
     * - subscription: projects/{project}/subscriptions/{subscription}
     * - topic: projects/{project}/topics/{topic}
     * - workerPool: projects/{project}/locations/{location}/workerPools/{worker_pool}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string $formattedName The formatted name string
     * @param string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName($formattedName, $template = null)
    {
        $templateMap = self::getPathTemplateMap();
        if ($template) {
            if (!isset($templateMap[$template])) {
                throw new ValidationException("Template name $template does not exist");
            }

            return $templateMap[$template]->match($formattedName);
        }

        foreach ($templateMap as $templateName => $pathTemplate) {
            try {
                return $pathTemplate->match($formattedName);
            } catch (ValidationException $ex) {
                // Swallow the exception to continue trying other path templates
            }
        }

        throw new ValidationException("Input did not match any known format. Input: $formattedName");
    }

    /**
     * Return an OperationsClient object with the same endpoint as $this.
     *
     * @return OperationsClient
     */
    public function getOperationsClient()
    {
        return $this->operationsClient;
    }

    /**
     * Resume an existing long running operation that was previously started by a long
     * running API method. If $methodName is not provided, or does not match a long
     * running API method, then the operation can still be resumed, but the
     * OperationResponse object will not deserialize the final response.
     *
     * @param string $operationName The name of the long running operation
     * @param string $methodName    The name of the method used to start the operation
     *
     * @return OperationResponse
     */
    public function resumeOperation($operationName, $methodName = null)
    {
        $options = isset($this->descriptors[$methodName]['longRunning']) ? $this->descriptors[$methodName]['longRunning'] : [];
        $operation = new OperationResponse($operationName, $this->getOperationsClient(), $options);
        $operation->reload();
        return $operation;
    }

    /**
     * Constructor.
     *
     * @param array $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'cloudbuild.googleapis.com:443'.
     *     @type string|array|FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           The credentials to be used by the client to authorize API calls. This option
     *           accepts either a path to a credentials file, or a decoded credentials file as a
     *           PHP array.
     *           *Advanced usage*: In addition, this option can also accept a pre-constructed
     *           {@see \Google\Auth\FetchAuthTokenInterface} object or
     *           {@see \Google\ApiCore\CredentialsWrapper} object. Note that when one of these
     *           objects are provided, any settings in $credentialsConfig will be ignored.
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
        $this->operationsClient = $this->createOperationsClient($clientOptions);
    }

    /**
     * Approves or rejects a pending build.
     *
     * If approved, the returned LRO will be analogous to the LRO returned from
     * a CreateBuild call.
     *
     * If rejected, the returned LRO will be immediately done.
     *
     * Sample code:
     * ```
     * $cloudBuildClient = new CloudBuildClient();
     * try {
     *     $name = 'name';
     *     $operationResponse = $cloudBuildClient->approveBuild($name);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $cloudBuildClient->approveBuild($name);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $cloudBuildClient->resumeOperation($operationName, 'approveBuild');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $cloudBuildClient->close();
     * }
     * ```
     *
     * @param string $name         Required. Name of the target build.
     *                             For example: "projects/{$project_id}/builds/{$build_id}"
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type ApprovalResult $approvalResult
     *           Approval decision and metadata.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function approveBuild($name, array $optionalArgs = [])
    {
        $request = new ApproveBuildRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        if (isset($optionalArgs['approvalResult'])) {
            $request->setApprovalResult($optionalArgs['approvalResult']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('ApproveBuild', $optionalArgs, $request, $this->getOperationsClient())->wait();
    }

    /**
     * Cancels a build in progress.
     *
     * Sample code:
     * ```
     * $cloudBuildClient = new CloudBuildClient();
     * try {
     *     $projectId = 'project_id';
     *     $id = 'id';
     *     $response = $cloudBuildClient->cancelBuild($projectId, $id);
     * } finally {
     *     $cloudBuildClient->close();
     * }
     * ```
     *
     * @param string $projectId    Required. ID of the project.
     * @param string $id           Required. ID of the build.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $name
     *           The name of the `Build` to cancel.
     *           Format: `projects/{project}/locations/{location}/builds/{build}`
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Build\V1\Build
     *
     * @throws ApiException if the remote call fails
     */
    public function cancelBuild($projectId, $id, array $optionalArgs = [])
    {
        $request = new CancelBuildRequest();
        $requestParamHeaders = [];
        $request->setProjectId($projectId);
        $request->setId($id);
        $requestParamHeaders['project_id'] = $projectId;
        $requestParamHeaders['id'] = $id;
        if (isset($optionalArgs['name'])) {
            $request->setName($optionalArgs['name']);
            $requestParamHeaders['name'] = $optionalArgs['name'];
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('CancelBuild', Build::class, $optionalArgs, $request)->wait();
    }

    /**
     * Starts a build with the specified configuration.
     *
     * This method returns a long-running `Operation`, which includes the build
     * ID. Pass the build ID to `GetBuild` to determine the build status (such as
     * `SUCCESS` or `FAILURE`).
     *
     * Sample code:
     * ```
     * $cloudBuildClient = new CloudBuildClient();
     * try {
     *     $projectId = 'project_id';
     *     $build = new Build();
     *     $operationResponse = $cloudBuildClient->createBuild($projectId, $build);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $cloudBuildClient->createBuild($projectId, $build);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $cloudBuildClient->resumeOperation($operationName, 'createBuild');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $cloudBuildClient->close();
     * }
     * ```
     *
     * @param string $projectId    Required. ID of the project.
     * @param Build  $build        Required. Build resource to create.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $parent
     *           The parent resource where this build will be created.
     *           Format: `projects/{project}/locations/{location}`
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function createBuild($projectId, $build, array $optionalArgs = [])
    {
        $request = new CreateBuildRequest();
        $requestParamHeaders = [];
        $request->setProjectId($projectId);
        $request->setBuild($build);
        $requestParamHeaders['project_id'] = $projectId;
        if (isset($optionalArgs['parent'])) {
            $request->setParent($optionalArgs['parent']);
            $requestParamHeaders['parent'] = $optionalArgs['parent'];
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('CreateBuild', $optionalArgs, $request, $this->getOperationsClient())->wait();
    }

    /**
     * Creates a new `BuildTrigger`.
     *
     * This API is experimental.
     *
     * Sample code:
     * ```
     * $cloudBuildClient = new CloudBuildClient();
     * try {
     *     $projectId = 'project_id';
     *     $trigger = new BuildTrigger();
     *     $response = $cloudBuildClient->createBuildTrigger($projectId, $trigger);
     * } finally {
     *     $cloudBuildClient->close();
     * }
     * ```
     *
     * @param string       $projectId    Required. ID of the project for which to configure automatic builds.
     * @param BuildTrigger $trigger      Required. `BuildTrigger` to create.
     * @param array        $optionalArgs {
     *     Optional.
     *
     *     @type string $parent
     *           The parent resource where this trigger will be created.
     *           Format: `projects/{project}/locations/{location}`
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Build\V1\BuildTrigger
     *
     * @throws ApiException if the remote call fails
     */
    public function createBuildTrigger($projectId, $trigger, array $optionalArgs = [])
    {
        $request = new CreateBuildTriggerRequest();
        $requestParamHeaders = [];
        $request->setProjectId($projectId);
        $request->setTrigger($trigger);
        $requestParamHeaders['project_id'] = $projectId;
        if (isset($optionalArgs['parent'])) {
            $request->setParent($optionalArgs['parent']);
            $requestParamHeaders['parent'] = $optionalArgs['parent'];
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('CreateBuildTrigger', BuildTrigger::class, $optionalArgs, $request)->wait();
    }

    /**
     * Creates a `WorkerPool`.
     *
     * Sample code:
     * ```
     * $cloudBuildClient = new CloudBuildClient();
     * try {
     *     $formattedParent = $cloudBuildClient->locationName('[PROJECT]', '[LOCATION]');
     *     $workerPool = new WorkerPool();
     *     $workerPoolId = 'worker_pool_id';
     *     $operationResponse = $cloudBuildClient->createWorkerPool($formattedParent, $workerPool, $workerPoolId);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $cloudBuildClient->createWorkerPool($formattedParent, $workerPool, $workerPoolId);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $cloudBuildClient->resumeOperation($operationName, 'createWorkerPool');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $cloudBuildClient->close();
     * }
     * ```
     *
     * @param string     $parent       Required. The parent resource where this worker pool will be created.
     *                                 Format: `projects/{project}/locations/{location}`.
     * @param WorkerPool $workerPool   Required. `WorkerPool` resource to create.
     * @param string     $workerPoolId Required. Immutable. The ID to use for the `WorkerPool`, which will become
     *                                 the final component of the resource name.
     *
     *                                 This value should be 1-63 characters, and valid characters
     *                                 are /[a-z][0-9]-/.
     * @param array      $optionalArgs {
     *     Optional.
     *
     *     @type bool $validateOnly
     *           If set, validate the request and preview the response, but do not actually
     *           post it.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function createWorkerPool($parent, $workerPool, $workerPoolId, array $optionalArgs = [])
    {
        $request = new CreateWorkerPoolRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setWorkerPool($workerPool);
        $request->setWorkerPoolId($workerPoolId);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['validateOnly'])) {
            $request->setValidateOnly($optionalArgs['validateOnly']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('CreateWorkerPool', $optionalArgs, $request, $this->getOperationsClient())->wait();
    }

    /**
     * Deletes a `BuildTrigger` by its project ID and trigger ID.
     *
     * This API is experimental.
     *
     * Sample code:
     * ```
     * $cloudBuildClient = new CloudBuildClient();
     * try {
     *     $projectId = 'project_id';
     *     $triggerId = 'trigger_id';
     *     $cloudBuildClient->deleteBuildTrigger($projectId, $triggerId);
     * } finally {
     *     $cloudBuildClient->close();
     * }
     * ```
     *
     * @param string $projectId    Required. ID of the project that owns the trigger.
     * @param string $triggerId    Required. ID of the `BuildTrigger` to delete.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $name
     *           The name of the `Trigger` to delete.
     *           Format: `projects/{project}/locations/{location}/triggers/{trigger}`
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteBuildTrigger($projectId, $triggerId, array $optionalArgs = [])
    {
        $request = new DeleteBuildTriggerRequest();
        $requestParamHeaders = [];
        $request->setProjectId($projectId);
        $request->setTriggerId($triggerId);
        $requestParamHeaders['project_id'] = $projectId;
        $requestParamHeaders['trigger_id'] = $triggerId;
        if (isset($optionalArgs['name'])) {
            $request->setName($optionalArgs['name']);
            $requestParamHeaders['name'] = $optionalArgs['name'];
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('DeleteBuildTrigger', GPBEmpty::class, $optionalArgs, $request)->wait();
    }

    /**
     * Deletes a `WorkerPool`.
     *
     * Sample code:
     * ```
     * $cloudBuildClient = new CloudBuildClient();
     * try {
     *     $formattedName = $cloudBuildClient->workerPoolName('[PROJECT]', '[LOCATION]', '[WORKER_POOL]');
     *     $operationResponse = $cloudBuildClient->deleteWorkerPool($formattedName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $cloudBuildClient->deleteWorkerPool($formattedName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $cloudBuildClient->resumeOperation($operationName, 'deleteWorkerPool');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $cloudBuildClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the `WorkerPool` to delete.
     *                             Format:
     *                             `projects/{project}/locations/{location}/workerPools/{workerPool}`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $etag
     *           Optional. If this is provided, it must match the server's etag on the
     *           workerpool for the request to be processed.
     *     @type bool $allowMissing
     *           If set to true, and the `WorkerPool` is not found, the request will succeed
     *           but no action will be taken on the server.
     *     @type bool $validateOnly
     *           If set, validate the request and preview the response, but do not actually
     *           post it.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteWorkerPool($name, array $optionalArgs = [])
    {
        $request = new DeleteWorkerPoolRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        if (isset($optionalArgs['etag'])) {
            $request->setEtag($optionalArgs['etag']);
        }

        if (isset($optionalArgs['allowMissing'])) {
            $request->setAllowMissing($optionalArgs['allowMissing']);
        }

        if (isset($optionalArgs['validateOnly'])) {
            $request->setValidateOnly($optionalArgs['validateOnly']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('DeleteWorkerPool', $optionalArgs, $request, $this->getOperationsClient())->wait();
    }

    /**
     * Returns information about a previously requested build.
     *
     * The `Build` that is returned includes its status (such as `SUCCESS`,
     * `FAILURE`, or `WORKING`), and timing information.
     *
     * Sample code:
     * ```
     * $cloudBuildClient = new CloudBuildClient();
     * try {
     *     $projectId = 'project_id';
     *     $id = 'id';
     *     $response = $cloudBuildClient->getBuild($projectId, $id);
     * } finally {
     *     $cloudBuildClient->close();
     * }
     * ```
     *
     * @param string $projectId    Required. ID of the project.
     * @param string $id           Required. ID of the build.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $name
     *           The name of the `Build` to retrieve.
     *           Format: `projects/{project}/locations/{location}/builds/{build}`
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Build\V1\Build
     *
     * @throws ApiException if the remote call fails
     */
    public function getBuild($projectId, $id, array $optionalArgs = [])
    {
        $request = new GetBuildRequest();
        $requestParamHeaders = [];
        $request->setProjectId($projectId);
        $request->setId($id);
        $requestParamHeaders['project_id'] = $projectId;
        $requestParamHeaders['id'] = $id;
        if (isset($optionalArgs['name'])) {
            $request->setName($optionalArgs['name']);
            $requestParamHeaders['name'] = $optionalArgs['name'];
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('GetBuild', Build::class, $optionalArgs, $request)->wait();
    }

    /**
     * Returns information about a `BuildTrigger`.
     *
     * This API is experimental.
     *
     * Sample code:
     * ```
     * $cloudBuildClient = new CloudBuildClient();
     * try {
     *     $projectId = 'project_id';
     *     $triggerId = 'trigger_id';
     *     $response = $cloudBuildClient->getBuildTrigger($projectId, $triggerId);
     * } finally {
     *     $cloudBuildClient->close();
     * }
     * ```
     *
     * @param string $projectId    Required. ID of the project that owns the trigger.
     * @param string $triggerId    Required. Identifier (`id` or `name`) of the `BuildTrigger` to get.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $name
     *           The name of the `Trigger` to retrieve.
     *           Format: `projects/{project}/locations/{location}/triggers/{trigger}`
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Build\V1\BuildTrigger
     *
     * @throws ApiException if the remote call fails
     */
    public function getBuildTrigger($projectId, $triggerId, array $optionalArgs = [])
    {
        $request = new GetBuildTriggerRequest();
        $requestParamHeaders = [];
        $request->setProjectId($projectId);
        $request->setTriggerId($triggerId);
        $requestParamHeaders['project_id'] = $projectId;
        $requestParamHeaders['trigger_id'] = $triggerId;
        if (isset($optionalArgs['name'])) {
            $request->setName($optionalArgs['name']);
            $requestParamHeaders['name'] = $optionalArgs['name'];
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('GetBuildTrigger', BuildTrigger::class, $optionalArgs, $request)->wait();
    }

    /**
     * Returns details of a `WorkerPool`.
     *
     * Sample code:
     * ```
     * $cloudBuildClient = new CloudBuildClient();
     * try {
     *     $formattedName = $cloudBuildClient->workerPoolName('[PROJECT]', '[LOCATION]', '[WORKER_POOL]');
     *     $response = $cloudBuildClient->getWorkerPool($formattedName);
     * } finally {
     *     $cloudBuildClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the `WorkerPool` to retrieve.
     *                             Format: `projects/{project}/locations/{location}/workerPools/{workerPool}`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Build\V1\WorkerPool
     *
     * @throws ApiException if the remote call fails
     */
    public function getWorkerPool($name, array $optionalArgs = [])
    {
        $request = new GetWorkerPoolRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('GetWorkerPool', WorkerPool::class, $optionalArgs, $request)->wait();
    }

    /**
     * Lists existing `BuildTrigger`s.
     *
     * This API is experimental.
     *
     * Sample code:
     * ```
     * $cloudBuildClient = new CloudBuildClient();
     * try {
     *     $projectId = 'project_id';
     *     // Iterate over pages of elements
     *     $pagedResponse = $cloudBuildClient->listBuildTriggers($projectId);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $cloudBuildClient->listBuildTriggers($projectId);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $cloudBuildClient->close();
     * }
     * ```
     *
     * @param string $projectId    Required. ID of the project for which to list BuildTriggers.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $parent
     *           The parent of the collection of `Triggers`.
     *           Format: `projects/{project}/locations/{location}`
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listBuildTriggers($projectId, array $optionalArgs = [])
    {
        $request = new ListBuildTriggersRequest();
        $requestParamHeaders = [];
        $request->setProjectId($projectId);
        $requestParamHeaders['project_id'] = $projectId;
        if (isset($optionalArgs['parent'])) {
            $request->setParent($optionalArgs['parent']);
            $requestParamHeaders['parent'] = $optionalArgs['parent'];
        }

        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->getPagedListResponse('ListBuildTriggers', $optionalArgs, ListBuildTriggersResponse::class, $request);
    }

    /**
     * Lists previously requested builds.
     *
     * Previously requested builds may still be in-progress, or may have finished
     * successfully or unsuccessfully.
     *
     * Sample code:
     * ```
     * $cloudBuildClient = new CloudBuildClient();
     * try {
     *     $projectId = 'project_id';
     *     // Iterate over pages of elements
     *     $pagedResponse = $cloudBuildClient->listBuilds($projectId);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $cloudBuildClient->listBuilds($projectId);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $cloudBuildClient->close();
     * }
     * ```
     *
     * @param string $projectId    Required. ID of the project.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $parent
     *           The parent of the collection of `Builds`.
     *           Format: `projects/{project}/locations/{location}`
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type string $filter
     *           The raw filter text to constrain the results.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listBuilds($projectId, array $optionalArgs = [])
    {
        $request = new ListBuildsRequest();
        $requestParamHeaders = [];
        $request->setProjectId($projectId);
        $requestParamHeaders['project_id'] = $projectId;
        if (isset($optionalArgs['parent'])) {
            $request->setParent($optionalArgs['parent']);
            $requestParamHeaders['parent'] = $optionalArgs['parent'];
        }

        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->getPagedListResponse('ListBuilds', $optionalArgs, ListBuildsResponse::class, $request);
    }

    /**
     * Lists `WorkerPool`s.
     *
     * Sample code:
     * ```
     * $cloudBuildClient = new CloudBuildClient();
     * try {
     *     $formattedParent = $cloudBuildClient->locationName('[PROJECT]', '[LOCATION]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $cloudBuildClient->listWorkerPools($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $cloudBuildClient->listWorkerPools($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $cloudBuildClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The parent of the collection of `WorkerPools`.
     *                             Format: `projects/{project}/locations/{location}`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listWorkerPools($parent, array $optionalArgs = [])
    {
        $request = new ListWorkerPoolsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->getPagedListResponse('ListWorkerPools', $optionalArgs, ListWorkerPoolsResponse::class, $request);
    }

    /**
     * ReceiveTriggerWebhook [Experimental] is called when the API receives a
     * webhook request targeted at a specific trigger.
     *
     * Sample code:
     * ```
     * $cloudBuildClient = new CloudBuildClient();
     * try {
     *     $response = $cloudBuildClient->receiveTriggerWebhook();
     * } finally {
     *     $cloudBuildClient->close();
     * }
     * ```
     *
     * @param array $optionalArgs {
     *     Optional.
     *
     *     @type string $name
     *           The name of the `ReceiveTriggerWebhook` to retrieve.
     *           Format: `projects/{project}/locations/{location}/triggers/{trigger}`
     *     @type HttpBody $body
     *           HTTP request body.
     *     @type string $projectId
     *           Project in which the specified trigger lives
     *     @type string $trigger
     *           Name of the trigger to run the payload against
     *     @type string $secret
     *           Secret token used for authorization if an OAuth token isn't provided.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Build\V1\ReceiveTriggerWebhookResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function receiveTriggerWebhook(array $optionalArgs = [])
    {
        $request = new ReceiveTriggerWebhookRequest();
        $requestParamHeaders = [];
        if (isset($optionalArgs['name'])) {
            $request->setName($optionalArgs['name']);
            $requestParamHeaders['name'] = $optionalArgs['name'];
        }

        if (isset($optionalArgs['body'])) {
            $request->setBody($optionalArgs['body']);
        }

        if (isset($optionalArgs['projectId'])) {
            $request->setProjectId($optionalArgs['projectId']);
            $requestParamHeaders['project_id'] = $optionalArgs['projectId'];
        }

        if (isset($optionalArgs['trigger'])) {
            $request->setTrigger($optionalArgs['trigger']);
            $requestParamHeaders['trigger'] = $optionalArgs['trigger'];
        }

        if (isset($optionalArgs['secret'])) {
            $request->setSecret($optionalArgs['secret']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('ReceiveTriggerWebhook', ReceiveTriggerWebhookResponse::class, $optionalArgs, $request)->wait();
    }

    /**
     * Creates a new build based on the specified build.
     *
     * This method creates a new build using the original build request, which may
     * or may not result in an identical build.
     *
     * For triggered builds:
     *
     * * Triggered builds resolve to a precise revision; therefore a retry of a
     * triggered build will result in a build that uses the same revision.
     *
     * For non-triggered builds that specify `RepoSource`:
     *
     * * If the original build built from the tip of a branch, the retried build
     * will build from the tip of that branch, which may not be the same revision
     * as the original build.
     * * If the original build specified a commit sha or revision ID, the retried
     * build will use the identical source.
     *
     * For builds that specify `StorageSource`:
     *
     * * If the original build pulled source from Google Cloud Storage without
     * specifying the generation of the object, the new build will use the current
     * object, which may be different from the original build source.
     * * If the original build pulled source from Cloud Storage and specified the
     * generation of the object, the new build will attempt to use the same
     * object, which may or may not be available depending on the bucket's
     * lifecycle management settings.
     *
     * Sample code:
     * ```
     * $cloudBuildClient = new CloudBuildClient();
     * try {
     *     $projectId = 'project_id';
     *     $id = 'id';
     *     $operationResponse = $cloudBuildClient->retryBuild($projectId, $id);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $cloudBuildClient->retryBuild($projectId, $id);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $cloudBuildClient->resumeOperation($operationName, 'retryBuild');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $cloudBuildClient->close();
     * }
     * ```
     *
     * @param string $projectId    Required. ID of the project.
     * @param string $id           Required. Build ID of the original build.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $name
     *           The name of the `Build` to retry.
     *           Format: `projects/{project}/locations/{location}/builds/{build}`
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function retryBuild($projectId, $id, array $optionalArgs = [])
    {
        $request = new RetryBuildRequest();
        $requestParamHeaders = [];
        $request->setProjectId($projectId);
        $request->setId($id);
        $requestParamHeaders['project_id'] = $projectId;
        $requestParamHeaders['id'] = $id;
        if (isset($optionalArgs['name'])) {
            $request->setName($optionalArgs['name']);
            $requestParamHeaders['name'] = $optionalArgs['name'];
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('RetryBuild', $optionalArgs, $request, $this->getOperationsClient())->wait();
    }

    /**
     * Runs a `BuildTrigger` at a particular source revision.
     *
     * Sample code:
     * ```
     * $cloudBuildClient = new CloudBuildClient();
     * try {
     *     $projectId = 'project_id';
     *     $triggerId = 'trigger_id';
     *     $operationResponse = $cloudBuildClient->runBuildTrigger($projectId, $triggerId);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $cloudBuildClient->runBuildTrigger($projectId, $triggerId);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $cloudBuildClient->resumeOperation($operationName, 'runBuildTrigger');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $cloudBuildClient->close();
     * }
     * ```
     *
     * @param string $projectId    Required. ID of the project.
     * @param string $triggerId    Required. ID of the trigger.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $name
     *           The name of the `Trigger` to run.
     *           Format: `projects/{project}/locations/{location}/triggers/{trigger}`
     *     @type RepoSource $source
     *           Source to build against this trigger.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function runBuildTrigger($projectId, $triggerId, array $optionalArgs = [])
    {
        $request = new RunBuildTriggerRequest();
        $requestParamHeaders = [];
        $request->setProjectId($projectId);
        $request->setTriggerId($triggerId);
        $requestParamHeaders['project_id'] = $projectId;
        $requestParamHeaders['trigger_id'] = $triggerId;
        if (isset($optionalArgs['name'])) {
            $request->setName($optionalArgs['name']);
            $requestParamHeaders['name'] = $optionalArgs['name'];
        }

        if (isset($optionalArgs['source'])) {
            $request->setSource($optionalArgs['source']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('RunBuildTrigger', $optionalArgs, $request, $this->getOperationsClient())->wait();
    }

    /**
     * Updates a `BuildTrigger` by its project ID and trigger ID.
     *
     * This API is experimental.
     *
     * Sample code:
     * ```
     * $cloudBuildClient = new CloudBuildClient();
     * try {
     *     $projectId = 'project_id';
     *     $triggerId = 'trigger_id';
     *     $trigger = new BuildTrigger();
     *     $response = $cloudBuildClient->updateBuildTrigger($projectId, $triggerId, $trigger);
     * } finally {
     *     $cloudBuildClient->close();
     * }
     * ```
     *
     * @param string       $projectId    Required. ID of the project that owns the trigger.
     * @param string       $triggerId    Required. ID of the `BuildTrigger` to update.
     * @param BuildTrigger $trigger      Required. `BuildTrigger` to update.
     * @param array        $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Build\V1\BuildTrigger
     *
     * @throws ApiException if the remote call fails
     */
    public function updateBuildTrigger($projectId, $triggerId, $trigger, array $optionalArgs = [])
    {
        $request = new UpdateBuildTriggerRequest();
        $requestParamHeaders = [];
        $request->setProjectId($projectId);
        $request->setTriggerId($triggerId);
        $request->setTrigger($trigger);
        $requestParamHeaders['project_id'] = $projectId;
        $requestParamHeaders['trigger_id'] = $triggerId;
        $requestParamHeaders['trigger.resource_name'] = $trigger->getResourceName();
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('UpdateBuildTrigger', BuildTrigger::class, $optionalArgs, $request)->wait();
    }

    /**
     * Updates a `WorkerPool`.
     *
     * Sample code:
     * ```
     * $cloudBuildClient = new CloudBuildClient();
     * try {
     *     $workerPool = new WorkerPool();
     *     $operationResponse = $cloudBuildClient->updateWorkerPool($workerPool);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $cloudBuildClient->updateWorkerPool($workerPool);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $cloudBuildClient->resumeOperation($operationName, 'updateWorkerPool');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $cloudBuildClient->close();
     * }
     * ```
     *
     * @param WorkerPool $workerPool   Required. The `WorkerPool` to update.
     *
     *                                 The `name` field is used to identify the `WorkerPool` to update.
     *                                 Format: `projects/{project}/locations/{location}/workerPools/{workerPool}`.
     * @param array      $optionalArgs {
     *     Optional.
     *
     *     @type FieldMask $updateMask
     *           A mask specifying which fields in `worker_pool` to update.
     *     @type bool $validateOnly
     *           If set, validate the request and preview the response, but do not actually
     *           post it.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function updateWorkerPool($workerPool, array $optionalArgs = [])
    {
        $request = new UpdateWorkerPoolRequest();
        $requestParamHeaders = [];
        $request->setWorkerPool($workerPool);
        $requestParamHeaders['worker_pool.name'] = $workerPool->getName();
        if (isset($optionalArgs['updateMask'])) {
            $request->setUpdateMask($optionalArgs['updateMask']);
        }

        if (isset($optionalArgs['validateOnly'])) {
            $request->setValidateOnly($optionalArgs['validateOnly']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('UpdateWorkerPool', $optionalArgs, $request, $this->getOperationsClient())->wait();
    }
}
