<?php
/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/aiplatform/v1/job_service.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\AIPlatform\V1\Client\BaseClient;

use Google\ApiCore\ApiException;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\LongRunning\OperationsClient;
use Google\ApiCore\OperationResponse;
use Google\ApiCore\PagedListResponse;
use Google\ApiCore\ResourceHelperTrait;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\AIPlatform\V1\BatchPredictionJob;
use Google\Cloud\AIPlatform\V1\CancelBatchPredictionJobRequest;
use Google\Cloud\AIPlatform\V1\CancelCustomJobRequest;
use Google\Cloud\AIPlatform\V1\CancelDataLabelingJobRequest;
use Google\Cloud\AIPlatform\V1\CancelHyperparameterTuningJobRequest;
use Google\Cloud\AIPlatform\V1\CancelNasJobRequest;
use Google\Cloud\AIPlatform\V1\CreateBatchPredictionJobRequest;
use Google\Cloud\AIPlatform\V1\CreateCustomJobRequest;
use Google\Cloud\AIPlatform\V1\CreateDataLabelingJobRequest;
use Google\Cloud\AIPlatform\V1\CreateHyperparameterTuningJobRequest;
use Google\Cloud\AIPlatform\V1\CreateModelDeploymentMonitoringJobRequest;
use Google\Cloud\AIPlatform\V1\CreateNasJobRequest;
use Google\Cloud\AIPlatform\V1\CustomJob;
use Google\Cloud\AIPlatform\V1\DataLabelingJob;
use Google\Cloud\AIPlatform\V1\DeleteBatchPredictionJobRequest;
use Google\Cloud\AIPlatform\V1\DeleteCustomJobRequest;
use Google\Cloud\AIPlatform\V1\DeleteDataLabelingJobRequest;
use Google\Cloud\AIPlatform\V1\DeleteHyperparameterTuningJobRequest;
use Google\Cloud\AIPlatform\V1\DeleteModelDeploymentMonitoringJobRequest;
use Google\Cloud\AIPlatform\V1\DeleteNasJobRequest;
use Google\Cloud\AIPlatform\V1\GetBatchPredictionJobRequest;
use Google\Cloud\AIPlatform\V1\GetCustomJobRequest;
use Google\Cloud\AIPlatform\V1\GetDataLabelingJobRequest;
use Google\Cloud\AIPlatform\V1\GetHyperparameterTuningJobRequest;
use Google\Cloud\AIPlatform\V1\GetModelDeploymentMonitoringJobRequest;
use Google\Cloud\AIPlatform\V1\GetNasJobRequest;
use Google\Cloud\AIPlatform\V1\GetNasTrialDetailRequest;
use Google\Cloud\AIPlatform\V1\HyperparameterTuningJob;
use Google\Cloud\AIPlatform\V1\ListBatchPredictionJobsRequest;
use Google\Cloud\AIPlatform\V1\ListCustomJobsRequest;
use Google\Cloud\AIPlatform\V1\ListDataLabelingJobsRequest;
use Google\Cloud\AIPlatform\V1\ListHyperparameterTuningJobsRequest;
use Google\Cloud\AIPlatform\V1\ListModelDeploymentMonitoringJobsRequest;
use Google\Cloud\AIPlatform\V1\ListNasJobsRequest;
use Google\Cloud\AIPlatform\V1\ListNasTrialDetailsRequest;
use Google\Cloud\AIPlatform\V1\ModelDeploymentMonitoringJob;
use Google\Cloud\AIPlatform\V1\NasJob;
use Google\Cloud\AIPlatform\V1\NasTrialDetail;
use Google\Cloud\AIPlatform\V1\PauseModelDeploymentMonitoringJobRequest;
use Google\Cloud\AIPlatform\V1\ResumeModelDeploymentMonitoringJobRequest;
use Google\Cloud\AIPlatform\V1\SearchModelDeploymentMonitoringStatsAnomaliesRequest;
use Google\Cloud\AIPlatform\V1\UpdateModelDeploymentMonitoringJobRequest;
use Google\Cloud\Iam\V1\GetIamPolicyRequest;
use Google\Cloud\Iam\V1\Policy;
use Google\Cloud\Iam\V1\SetIamPolicyRequest;
use Google\Cloud\Iam\V1\TestIamPermissionsRequest;
use Google\Cloud\Iam\V1\TestIamPermissionsResponse;
use Google\Cloud\Location\GetLocationRequest;
use Google\Cloud\Location\ListLocationsRequest;
use Google\Cloud\Location\Location;
use Google\LongRunning\Operation;
use GuzzleHttp\Promise\PromiseInterface;

/**
 * Service Description: A service for creating and managing Vertex AI's jobs.
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods.
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 *
 * This class is currently experimental and may be subject to changes.
 *
 * @experimental
 *
 * @internal
 *
 * @method PromiseInterface cancelBatchPredictionJobAsync(CancelBatchPredictionJobRequest $request, array $optionalArgs = [])
 * @method PromiseInterface cancelCustomJobAsync(CancelCustomJobRequest $request, array $optionalArgs = [])
 * @method PromiseInterface cancelDataLabelingJobAsync(CancelDataLabelingJobRequest $request, array $optionalArgs = [])
 * @method PromiseInterface cancelHyperparameterTuningJobAsync(CancelHyperparameterTuningJobRequest $request, array $optionalArgs = [])
 * @method PromiseInterface cancelNasJobAsync(CancelNasJobRequest $request, array $optionalArgs = [])
 * @method PromiseInterface createBatchPredictionJobAsync(CreateBatchPredictionJobRequest $request, array $optionalArgs = [])
 * @method PromiseInterface createCustomJobAsync(CreateCustomJobRequest $request, array $optionalArgs = [])
 * @method PromiseInterface createDataLabelingJobAsync(CreateDataLabelingJobRequest $request, array $optionalArgs = [])
 * @method PromiseInterface createHyperparameterTuningJobAsync(CreateHyperparameterTuningJobRequest $request, array $optionalArgs = [])
 * @method PromiseInterface createModelDeploymentMonitoringJobAsync(CreateModelDeploymentMonitoringJobRequest $request, array $optionalArgs = [])
 * @method PromiseInterface createNasJobAsync(CreateNasJobRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deleteBatchPredictionJobAsync(DeleteBatchPredictionJobRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deleteCustomJobAsync(DeleteCustomJobRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deleteDataLabelingJobAsync(DeleteDataLabelingJobRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deleteHyperparameterTuningJobAsync(DeleteHyperparameterTuningJobRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deleteModelDeploymentMonitoringJobAsync(DeleteModelDeploymentMonitoringJobRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deleteNasJobAsync(DeleteNasJobRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getBatchPredictionJobAsync(GetBatchPredictionJobRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getCustomJobAsync(GetCustomJobRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getDataLabelingJobAsync(GetDataLabelingJobRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getHyperparameterTuningJobAsync(GetHyperparameterTuningJobRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getModelDeploymentMonitoringJobAsync(GetModelDeploymentMonitoringJobRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getNasJobAsync(GetNasJobRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getNasTrialDetailAsync(GetNasTrialDetailRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listBatchPredictionJobsAsync(ListBatchPredictionJobsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listCustomJobsAsync(ListCustomJobsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listDataLabelingJobsAsync(ListDataLabelingJobsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listHyperparameterTuningJobsAsync(ListHyperparameterTuningJobsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listModelDeploymentMonitoringJobsAsync(ListModelDeploymentMonitoringJobsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listNasJobsAsync(ListNasJobsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listNasTrialDetailsAsync(ListNasTrialDetailsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface pauseModelDeploymentMonitoringJobAsync(PauseModelDeploymentMonitoringJobRequest $request, array $optionalArgs = [])
 * @method PromiseInterface resumeModelDeploymentMonitoringJobAsync(ResumeModelDeploymentMonitoringJobRequest $request, array $optionalArgs = [])
 * @method PromiseInterface searchModelDeploymentMonitoringStatsAnomaliesAsync(SearchModelDeploymentMonitoringStatsAnomaliesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface updateModelDeploymentMonitoringJobAsync(UpdateModelDeploymentMonitoringJobRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getLocationAsync(GetLocationRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listLocationsAsync(ListLocationsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getIamPolicyAsync(GetIamPolicyRequest $request, array $optionalArgs = [])
 * @method PromiseInterface setIamPolicyAsync(SetIamPolicyRequest $request, array $optionalArgs = [])
 * @method PromiseInterface testIamPermissionsAsync(TestIamPermissionsRequest $request, array $optionalArgs = [])
 */
abstract class JobServiceBaseClient
{
    use GapicClientTrait;
    use ResourceHelperTrait;

    /** The name of the service. */
    private const SERVICE_NAME = 'google.cloud.aiplatform.v1.JobService';

    /** The default address of the service. */
    private const SERVICE_ADDRESS = 'aiplatform.googleapis.com';

    /** The default port of the service. */
    private const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    private const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = [
        'https://www.googleapis.com/auth/cloud-platform',
        'https://www.googleapis.com/auth/cloud-platform.read-only',
    ];

    private $operationsClient;

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' => self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' => __DIR__ . '/../../resources/job_service_client_config.json',
            'descriptorsConfigPath' => __DIR__ . '/../../resources/job_service_descriptor_config.php',
            'gcpApiConfigPath' => __DIR__ . '/../../resources/job_service_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' => __DIR__ . '/../../resources/job_service_rest_client_config.php',
                ],
            ],
        ];
    }

    /**
     * Return an OperationsClient object with the same endpoint as $this.
     *
     * @return OperationsClient
     */
    public function getOperationsClient()
    {
        return $this->operationsClient;
    }

    /**
     * Resume an existing long running operation that was previously started by a long
     * running API method. If $methodName is not provided, or does not match a long
     * running API method, then the operation can still be resumed, but the
     * OperationResponse object will not deserialize the final response.
     *
     * @param string $operationName The name of the long running operation
     * @param string $methodName    The name of the method used to start the operation
     *
     * @return OperationResponse
     */
    public function resumeOperation($operationName, $methodName = null)
    {
        $options = isset($this->descriptors[$methodName]['longRunning']) ? $this->descriptors[$methodName]['longRunning'] : [];
        $operation = new OperationResponse($operationName, $this->getOperationsClient(), $options);
        $operation->reload();
        return $operation;
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * batch_prediction_job resource.
     *
     * @param string $project
     * @param string $location
     * @param string $batchPredictionJob
     *
     * @return string The formatted batch_prediction_job resource.
     */
    public static function batchPredictionJobName(string $project, string $location, string $batchPredictionJob): string
    {
        return self::getPathTemplate('batchPredictionJob')->render([
            'project' => $project,
            'location' => $location,
            'batch_prediction_job' => $batchPredictionJob,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a context
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $metadataStore
     * @param string $context
     *
     * @return string The formatted context resource.
     */
    public static function contextName(string $project, string $location, string $metadataStore, string $context): string
    {
        return self::getPathTemplate('context')->render([
            'project' => $project,
            'location' => $location,
            'metadata_store' => $metadataStore,
            'context' => $context,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a custom_job
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $customJob
     *
     * @return string The formatted custom_job resource.
     */
    public static function customJobName(string $project, string $location, string $customJob): string
    {
        return self::getPathTemplate('customJob')->render([
            'project' => $project,
            'location' => $location,
            'custom_job' => $customJob,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * data_labeling_job resource.
     *
     * @param string $project
     * @param string $location
     * @param string $dataLabelingJob
     *
     * @return string The formatted data_labeling_job resource.
     */
    public static function dataLabelingJobName(string $project, string $location, string $dataLabelingJob): string
    {
        return self::getPathTemplate('dataLabelingJob')->render([
            'project' => $project,
            'location' => $location,
            'data_labeling_job' => $dataLabelingJob,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a dataset
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $dataset
     *
     * @return string The formatted dataset resource.
     */
    public static function datasetName(string $project, string $location, string $dataset): string
    {
        return self::getPathTemplate('dataset')->render([
            'project' => $project,
            'location' => $location,
            'dataset' => $dataset,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a endpoint
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $endpoint
     *
     * @return string The formatted endpoint resource.
     */
    public static function endpointName(string $project, string $location, string $endpoint): string
    {
        return self::getPathTemplate('endpoint')->render([
            'project' => $project,
            'location' => $location,
            'endpoint' => $endpoint,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * hyperparameter_tuning_job resource.
     *
     * @param string $project
     * @param string $location
     * @param string $hyperparameterTuningJob
     *
     * @return string The formatted hyperparameter_tuning_job resource.
     */
    public static function hyperparameterTuningJobName(string $project, string $location, string $hyperparameterTuningJob): string
    {
        return self::getPathTemplate('hyperparameterTuningJob')->render([
            'project' => $project,
            'location' => $location,
            'hyperparameter_tuning_job' => $hyperparameterTuningJob,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a location
     * resource.
     *
     * @param string $project
     * @param string $location
     *
     * @return string The formatted location resource.
     */
    public static function locationName(string $project, string $location): string
    {
        return self::getPathTemplate('location')->render([
            'project' => $project,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a model
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $model
     *
     * @return string The formatted model resource.
     */
    public static function modelName(string $project, string $location, string $model): string
    {
        return self::getPathTemplate('model')->render([
            'project' => $project,
            'location' => $location,
            'model' => $model,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * model_deployment_monitoring_job resource.
     *
     * @param string $project
     * @param string $location
     * @param string $modelDeploymentMonitoringJob
     *
     * @return string The formatted model_deployment_monitoring_job resource.
     */
    public static function modelDeploymentMonitoringJobName(string $project, string $location, string $modelDeploymentMonitoringJob): string
    {
        return self::getPathTemplate('modelDeploymentMonitoringJob')->render([
            'project' => $project,
            'location' => $location,
            'model_deployment_monitoring_job' => $modelDeploymentMonitoringJob,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a nas_job
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $nasJob
     *
     * @return string The formatted nas_job resource.
     */
    public static function nasJobName(string $project, string $location, string $nasJob): string
    {
        return self::getPathTemplate('nasJob')->render([
            'project' => $project,
            'location' => $location,
            'nas_job' => $nasJob,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * nas_trial_detail resource.
     *
     * @param string $project
     * @param string $location
     * @param string $nasJob
     * @param string $nasTrialDetail
     *
     * @return string The formatted nas_trial_detail resource.
     */
    public static function nasTrialDetailName(string $project, string $location, string $nasJob, string $nasTrialDetail): string
    {
        return self::getPathTemplate('nasTrialDetail')->render([
            'project' => $project,
            'location' => $location,
            'nas_job' => $nasJob,
            'nas_trial_detail' => $nasTrialDetail,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a network
     * resource.
     *
     * @param string $project
     * @param string $network
     *
     * @return string The formatted network resource.
     */
    public static function networkName(string $project, string $network): string
    {
        return self::getPathTemplate('network')->render([
            'project' => $project,
            'network' => $network,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_location_endpoint resource.
     *
     * @param string $project
     * @param string $location
     * @param string $endpoint
     *
     * @return string The formatted project_location_endpoint resource.
     */
    public static function projectLocationEndpointName(string $project, string $location, string $endpoint): string
    {
        return self::getPathTemplate('projectLocationEndpoint')->render([
            'project' => $project,
            'location' => $location,
            'endpoint' => $endpoint,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_location_publisher_model resource.
     *
     * @param string $project
     * @param string $location
     * @param string $publisher
     * @param string $model
     *
     * @return string The formatted project_location_publisher_model resource.
     */
    public static function projectLocationPublisherModelName(string $project, string $location, string $publisher, string $model): string
    {
        return self::getPathTemplate('projectLocationPublisherModel')->render([
            'project' => $project,
            'location' => $location,
            'publisher' => $publisher,
            'model' => $model,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a tensorboard
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $tensorboard
     *
     * @return string The formatted tensorboard resource.
     */
    public static function tensorboardName(string $project, string $location, string $tensorboard): string
    {
        return self::getPathTemplate('tensorboard')->render([
            'project' => $project,
            'location' => $location,
            'tensorboard' => $tensorboard,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - batchPredictionJob: projects/{project}/locations/{location}/batchPredictionJobs/{batch_prediction_job}
     * - context: projects/{project}/locations/{location}/metadataStores/{metadata_store}/contexts/{context}
     * - customJob: projects/{project}/locations/{location}/customJobs/{custom_job}
     * - dataLabelingJob: projects/{project}/locations/{location}/dataLabelingJobs/{data_labeling_job}
     * - dataset: projects/{project}/locations/{location}/datasets/{dataset}
     * - endpoint: projects/{project}/locations/{location}/endpoints/{endpoint}
     * - hyperparameterTuningJob: projects/{project}/locations/{location}/hyperparameterTuningJobs/{hyperparameter_tuning_job}
     * - location: projects/{project}/locations/{location}
     * - model: projects/{project}/locations/{location}/models/{model}
     * - modelDeploymentMonitoringJob: projects/{project}/locations/{location}/modelDeploymentMonitoringJobs/{model_deployment_monitoring_job}
     * - nasJob: projects/{project}/locations/{location}/nasJobs/{nas_job}
     * - nasTrialDetail: projects/{project}/locations/{location}/nasJobs/{nas_job}/nasTrialDetails/{nas_trial_detail}
     * - network: projects/{project}/global/networks/{network}
     * - projectLocationEndpoint: projects/{project}/locations/{location}/endpoints/{endpoint}
     * - projectLocationPublisherModel: projects/{project}/locations/{location}/publishers/{publisher}/models/{model}
     * - tensorboard: projects/{project}/locations/{location}/tensorboards/{tensorboard}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string $formattedName The formatted name string
     * @param string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName(string $formattedName, string $template = null): array
    {
        return self::parseFormattedName($formattedName, $template);
    }

    /**
     * Constructor.
     *
     * @param array $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'aiplatform.googleapis.com:443'.
     *     @type string|array|FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           The credentials to be used by the client to authorize API calls. This option
     *           accepts either a path to a credentials file, or a decoded credentials file as a
     *           PHP array.
     *           *Advanced usage*: In addition, this option can also accept a pre-constructed
     *           {@see \Google\Auth\FetchAuthTokenInterface} object or
     *           {@see \Google\ApiCore\CredentialsWrapper} object. Note that when one of these
     *           objects are provided, any settings in $credentialsConfig will be ignored.
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
        $this->operationsClient = $this->createOperationsClient($clientOptions);
    }

    /** Handles execution of the async variants for each documented method. */
    public function __call($method, $args)
    {
        if (substr($method, -5) !== 'Async') {
            trigger_error('Call to undefined method ' . __CLASS__ . "::$method()", E_USER_ERROR);
        }

        array_unshift($args, substr($method, 0, -5));
        return call_user_func_array([$this, 'startAsyncCall'], $args);
    }

    /**
     * Cancels a BatchPredictionJob.
     *
     * Starts asynchronous cancellation on the BatchPredictionJob. The server
     * makes the best effort to cancel the job, but success is not
     * guaranteed. Clients can use
     * [JobService.GetBatchPredictionJob][google.cloud.aiplatform.v1.JobService.GetBatchPredictionJob]
     * or other methods to check whether the cancellation succeeded or whether the
     * job completed despite cancellation. On a successful cancellation,
     * the BatchPredictionJob is not deleted;instead its
     * [BatchPredictionJob.state][google.cloud.aiplatform.v1.BatchPredictionJob.state]
     * is set to `CANCELLED`. Any files already outputted by the job are not
     * deleted.
     *
     * The async variant is {@see self::cancelBatchPredictionJobAsync()} .
     *
     * @param CancelBatchPredictionJobRequest $request     A request to house fields associated with the call.
     * @param array                           $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function cancelBatchPredictionJob(CancelBatchPredictionJobRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('CancelBatchPredictionJob', $request, $callOptions)->wait();
    }

    /**
     * Cancels a CustomJob.
     * Starts asynchronous cancellation on the CustomJob. The server
     * makes a best effort to cancel the job, but success is not
     * guaranteed. Clients can use
     * [JobService.GetCustomJob][google.cloud.aiplatform.v1.JobService.GetCustomJob]
     * or other methods to check whether the cancellation succeeded or whether the
     * job completed despite cancellation. On successful cancellation,
     * the CustomJob is not deleted; instead it becomes a job with
     * a [CustomJob.error][google.cloud.aiplatform.v1.CustomJob.error] value with
     * a [google.rpc.Status.code][google.rpc.Status.code] of 1, corresponding to
     * `Code.CANCELLED`, and
     * [CustomJob.state][google.cloud.aiplatform.v1.CustomJob.state] is set to
     * `CANCELLED`.
     *
     * The async variant is {@see self::cancelCustomJobAsync()} .
     *
     * @param CancelCustomJobRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function cancelCustomJob(CancelCustomJobRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('CancelCustomJob', $request, $callOptions)->wait();
    }

    /**
     * Cancels a DataLabelingJob. Success of cancellation is not guaranteed.
     *
     * The async variant is {@see self::cancelDataLabelingJobAsync()} .
     *
     * @param CancelDataLabelingJobRequest $request     A request to house fields associated with the call.
     * @param array                        $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function cancelDataLabelingJob(CancelDataLabelingJobRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('CancelDataLabelingJob', $request, $callOptions)->wait();
    }

    /**
     * Cancels a HyperparameterTuningJob.
     * Starts asynchronous cancellation on the HyperparameterTuningJob. The server
     * makes a best effort to cancel the job, but success is not
     * guaranteed. Clients can use
     * [JobService.GetHyperparameterTuningJob][google.cloud.aiplatform.v1.JobService.GetHyperparameterTuningJob]
     * or other methods to check whether the cancellation succeeded or whether the
     * job completed despite cancellation. On successful cancellation,
     * the HyperparameterTuningJob is not deleted; instead it becomes a job with
     * a
     * [HyperparameterTuningJob.error][google.cloud.aiplatform.v1.HyperparameterTuningJob.error]
     * value with a [google.rpc.Status.code][google.rpc.Status.code] of 1,
     * corresponding to `Code.CANCELLED`, and
     * [HyperparameterTuningJob.state][google.cloud.aiplatform.v1.HyperparameterTuningJob.state]
     * is set to `CANCELLED`.
     *
     * The async variant is {@see self::cancelHyperparameterTuningJobAsync()} .
     *
     * @param CancelHyperparameterTuningJobRequest $request     A request to house fields associated with the call.
     * @param array                                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function cancelHyperparameterTuningJob(CancelHyperparameterTuningJobRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('CancelHyperparameterTuningJob', $request, $callOptions)->wait();
    }

    /**
     * Cancels a NasJob.
     * Starts asynchronous cancellation on the NasJob. The server
     * makes a best effort to cancel the job, but success is not
     * guaranteed. Clients can use
     * [JobService.GetNasJob][google.cloud.aiplatform.v1.JobService.GetNasJob] or
     * other methods to check whether the cancellation succeeded or whether the
     * job completed despite cancellation. On successful cancellation,
     * the NasJob is not deleted; instead it becomes a job with
     * a [NasJob.error][google.cloud.aiplatform.v1.NasJob.error] value with a
     * [google.rpc.Status.code][google.rpc.Status.code] of 1, corresponding to
     * `Code.CANCELLED`, and
     * [NasJob.state][google.cloud.aiplatform.v1.NasJob.state] is set to
     * `CANCELLED`.
     *
     * The async variant is {@see self::cancelNasJobAsync()} .
     *
     * @param CancelNasJobRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function cancelNasJob(CancelNasJobRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('CancelNasJob', $request, $callOptions)->wait();
    }

    /**
     * Creates a BatchPredictionJob. A BatchPredictionJob once created will
     * right away be attempted to start.
     *
     * The async variant is {@see self::createBatchPredictionJobAsync()} .
     *
     * @param CreateBatchPredictionJobRequest $request     A request to house fields associated with the call.
     * @param array                           $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return BatchPredictionJob
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createBatchPredictionJob(CreateBatchPredictionJobRequest $request, array $callOptions = []): BatchPredictionJob
    {
        return $this->startApiCall('CreateBatchPredictionJob', $request, $callOptions)->wait();
    }

    /**
     * Creates a CustomJob. A created CustomJob right away
     * will be attempted to be run.
     *
     * The async variant is {@see self::createCustomJobAsync()} .
     *
     * @param CreateCustomJobRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return CustomJob
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createCustomJob(CreateCustomJobRequest $request, array $callOptions = []): CustomJob
    {
        return $this->startApiCall('CreateCustomJob', $request, $callOptions)->wait();
    }

    /**
     * Creates a DataLabelingJob.
     *
     * The async variant is {@see self::createDataLabelingJobAsync()} .
     *
     * @param CreateDataLabelingJobRequest $request     A request to house fields associated with the call.
     * @param array                        $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return DataLabelingJob
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createDataLabelingJob(CreateDataLabelingJobRequest $request, array $callOptions = []): DataLabelingJob
    {
        return $this->startApiCall('CreateDataLabelingJob', $request, $callOptions)->wait();
    }

    /**
     * Creates a HyperparameterTuningJob
     *
     * The async variant is {@see self::createHyperparameterTuningJobAsync()} .
     *
     * @param CreateHyperparameterTuningJobRequest $request     A request to house fields associated with the call.
     * @param array                                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return HyperparameterTuningJob
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createHyperparameterTuningJob(CreateHyperparameterTuningJobRequest $request, array $callOptions = []): HyperparameterTuningJob
    {
        return $this->startApiCall('CreateHyperparameterTuningJob', $request, $callOptions)->wait();
    }

    /**
     * Creates a ModelDeploymentMonitoringJob. It will run periodically on a
     * configured interval.
     *
     * The async variant is {@see self::createModelDeploymentMonitoringJobAsync()} .
     *
     * @param CreateModelDeploymentMonitoringJobRequest $request     A request to house fields associated with the call.
     * @param array                                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return ModelDeploymentMonitoringJob
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createModelDeploymentMonitoringJob(CreateModelDeploymentMonitoringJobRequest $request, array $callOptions = []): ModelDeploymentMonitoringJob
    {
        return $this->startApiCall('CreateModelDeploymentMonitoringJob', $request, $callOptions)->wait();
    }

    /**
     * Creates a NasJob
     *
     * The async variant is {@see self::createNasJobAsync()} .
     *
     * @param CreateNasJobRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return NasJob
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createNasJob(CreateNasJobRequest $request, array $callOptions = []): NasJob
    {
        return $this->startApiCall('CreateNasJob', $request, $callOptions)->wait();
    }

    /**
     * Deletes a BatchPredictionJob. Can only be called on jobs that already
     * finished.
     *
     * The async variant is {@see self::deleteBatchPredictionJobAsync()} .
     *
     * @param DeleteBatchPredictionJobRequest $request     A request to house fields associated with the call.
     * @param array                           $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteBatchPredictionJob(DeleteBatchPredictionJobRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeleteBatchPredictionJob', $request, $callOptions)->wait();
    }

    /**
     * Deletes a CustomJob.
     *
     * The async variant is {@see self::deleteCustomJobAsync()} .
     *
     * @param DeleteCustomJobRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteCustomJob(DeleteCustomJobRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeleteCustomJob', $request, $callOptions)->wait();
    }

    /**
     * Deletes a DataLabelingJob.
     *
     * The async variant is {@see self::deleteDataLabelingJobAsync()} .
     *
     * @param DeleteDataLabelingJobRequest $request     A request to house fields associated with the call.
     * @param array                        $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteDataLabelingJob(DeleteDataLabelingJobRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeleteDataLabelingJob', $request, $callOptions)->wait();
    }

    /**
     * Deletes a HyperparameterTuningJob.
     *
     * The async variant is {@see self::deleteHyperparameterTuningJobAsync()} .
     *
     * @param DeleteHyperparameterTuningJobRequest $request     A request to house fields associated with the call.
     * @param array                                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteHyperparameterTuningJob(DeleteHyperparameterTuningJobRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeleteHyperparameterTuningJob', $request, $callOptions)->wait();
    }

    /**
     * Deletes a ModelDeploymentMonitoringJob.
     *
     * The async variant is {@see self::deleteModelDeploymentMonitoringJobAsync()} .
     *
     * @param DeleteModelDeploymentMonitoringJobRequest $request     A request to house fields associated with the call.
     * @param array                                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteModelDeploymentMonitoringJob(DeleteModelDeploymentMonitoringJobRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeleteModelDeploymentMonitoringJob', $request, $callOptions)->wait();
    }

    /**
     * Deletes a NasJob.
     *
     * The async variant is {@see self::deleteNasJobAsync()} .
     *
     * @param DeleteNasJobRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteNasJob(DeleteNasJobRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeleteNasJob', $request, $callOptions)->wait();
    }

    /**
     * Gets a BatchPredictionJob
     *
     * The async variant is {@see self::getBatchPredictionJobAsync()} .
     *
     * @param GetBatchPredictionJobRequest $request     A request to house fields associated with the call.
     * @param array                        $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return BatchPredictionJob
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getBatchPredictionJob(GetBatchPredictionJobRequest $request, array $callOptions = []): BatchPredictionJob
    {
        return $this->startApiCall('GetBatchPredictionJob', $request, $callOptions)->wait();
    }

    /**
     * Gets a CustomJob.
     *
     * The async variant is {@see self::getCustomJobAsync()} .
     *
     * @param GetCustomJobRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return CustomJob
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getCustomJob(GetCustomJobRequest $request, array $callOptions = []): CustomJob
    {
        return $this->startApiCall('GetCustomJob', $request, $callOptions)->wait();
    }

    /**
     * Gets a DataLabelingJob.
     *
     * The async variant is {@see self::getDataLabelingJobAsync()} .
     *
     * @param GetDataLabelingJobRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return DataLabelingJob
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getDataLabelingJob(GetDataLabelingJobRequest $request, array $callOptions = []): DataLabelingJob
    {
        return $this->startApiCall('GetDataLabelingJob', $request, $callOptions)->wait();
    }

    /**
     * Gets a HyperparameterTuningJob
     *
     * The async variant is {@see self::getHyperparameterTuningJobAsync()} .
     *
     * @param GetHyperparameterTuningJobRequest $request     A request to house fields associated with the call.
     * @param array                             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return HyperparameterTuningJob
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getHyperparameterTuningJob(GetHyperparameterTuningJobRequest $request, array $callOptions = []): HyperparameterTuningJob
    {
        return $this->startApiCall('GetHyperparameterTuningJob', $request, $callOptions)->wait();
    }

    /**
     * Gets a ModelDeploymentMonitoringJob.
     *
     * The async variant is {@see self::getModelDeploymentMonitoringJobAsync()} .
     *
     * @param GetModelDeploymentMonitoringJobRequest $request     A request to house fields associated with the call.
     * @param array                                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return ModelDeploymentMonitoringJob
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getModelDeploymentMonitoringJob(GetModelDeploymentMonitoringJobRequest $request, array $callOptions = []): ModelDeploymentMonitoringJob
    {
        return $this->startApiCall('GetModelDeploymentMonitoringJob', $request, $callOptions)->wait();
    }

    /**
     * Gets a NasJob
     *
     * The async variant is {@see self::getNasJobAsync()} .
     *
     * @param GetNasJobRequest $request     A request to house fields associated with the call.
     * @param array            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return NasJob
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getNasJob(GetNasJobRequest $request, array $callOptions = []): NasJob
    {
        return $this->startApiCall('GetNasJob', $request, $callOptions)->wait();
    }

    /**
     * Gets a NasTrialDetail.
     *
     * The async variant is {@see self::getNasTrialDetailAsync()} .
     *
     * @param GetNasTrialDetailRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return NasTrialDetail
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getNasTrialDetail(GetNasTrialDetailRequest $request, array $callOptions = []): NasTrialDetail
    {
        return $this->startApiCall('GetNasTrialDetail', $request, $callOptions)->wait();
    }

    /**
     * Lists BatchPredictionJobs in a Location.
     *
     * The async variant is {@see self::listBatchPredictionJobsAsync()} .
     *
     * @param ListBatchPredictionJobsRequest $request     A request to house fields associated with the call.
     * @param array                          $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listBatchPredictionJobs(ListBatchPredictionJobsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListBatchPredictionJobs', $request, $callOptions);
    }

    /**
     * Lists CustomJobs in a Location.
     *
     * The async variant is {@see self::listCustomJobsAsync()} .
     *
     * @param ListCustomJobsRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listCustomJobs(ListCustomJobsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListCustomJobs', $request, $callOptions);
    }

    /**
     * Lists DataLabelingJobs in a Location.
     *
     * The async variant is {@see self::listDataLabelingJobsAsync()} .
     *
     * @param ListDataLabelingJobsRequest $request     A request to house fields associated with the call.
     * @param array                       $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listDataLabelingJobs(ListDataLabelingJobsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListDataLabelingJobs', $request, $callOptions);
    }

    /**
     * Lists HyperparameterTuningJobs in a Location.
     *
     * The async variant is {@see self::listHyperparameterTuningJobsAsync()} .
     *
     * @param ListHyperparameterTuningJobsRequest $request     A request to house fields associated with the call.
     * @param array                               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listHyperparameterTuningJobs(ListHyperparameterTuningJobsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListHyperparameterTuningJobs', $request, $callOptions);
    }

    /**
     * Lists ModelDeploymentMonitoringJobs in a Location.
     *
     * The async variant is {@see self::listModelDeploymentMonitoringJobsAsync()} .
     *
     * @param ListModelDeploymentMonitoringJobsRequest $request     A request to house fields associated with the call.
     * @param array                                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listModelDeploymentMonitoringJobs(ListModelDeploymentMonitoringJobsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListModelDeploymentMonitoringJobs', $request, $callOptions);
    }

    /**
     * Lists NasJobs in a Location.
     *
     * The async variant is {@see self::listNasJobsAsync()} .
     *
     * @param ListNasJobsRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listNasJobs(ListNasJobsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListNasJobs', $request, $callOptions);
    }

    /**
     * List top NasTrialDetails of a NasJob.
     *
     * The async variant is {@see self::listNasTrialDetailsAsync()} .
     *
     * @param ListNasTrialDetailsRequest $request     A request to house fields associated with the call.
     * @param array                      $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listNasTrialDetails(ListNasTrialDetailsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListNasTrialDetails', $request, $callOptions);
    }

    /**
     * Pauses a ModelDeploymentMonitoringJob. If the job is running, the server
     * makes a best effort to cancel the job. Will mark
     * [ModelDeploymentMonitoringJob.state][google.cloud.aiplatform.v1.ModelDeploymentMonitoringJob.state]
     * to 'PAUSED'.
     *
     * The async variant is {@see self::pauseModelDeploymentMonitoringJobAsync()} .
     *
     * @param PauseModelDeploymentMonitoringJobRequest $request     A request to house fields associated with the call.
     * @param array                                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function pauseModelDeploymentMonitoringJob(PauseModelDeploymentMonitoringJobRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('PauseModelDeploymentMonitoringJob', $request, $callOptions)->wait();
    }

    /**
     * Resumes a paused ModelDeploymentMonitoringJob. It will start to run from
     * next scheduled time. A deleted ModelDeploymentMonitoringJob can't be
     * resumed.
     *
     * The async variant is {@see self::resumeModelDeploymentMonitoringJobAsync()} .
     *
     * @param ResumeModelDeploymentMonitoringJobRequest $request     A request to house fields associated with the call.
     * @param array                                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function resumeModelDeploymentMonitoringJob(ResumeModelDeploymentMonitoringJobRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('ResumeModelDeploymentMonitoringJob', $request, $callOptions)->wait();
    }

    /**
     * Searches Model Monitoring Statistics generated within a given time window.
     *
     * The async variant is
     * {@see self::searchModelDeploymentMonitoringStatsAnomaliesAsync()} .
     *
     * @param SearchModelDeploymentMonitoringStatsAnomaliesRequest $request     A request to house fields associated with the call.
     * @param array                                                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function searchModelDeploymentMonitoringStatsAnomalies(SearchModelDeploymentMonitoringStatsAnomaliesRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('SearchModelDeploymentMonitoringStatsAnomalies', $request, $callOptions);
    }

    /**
     * Updates a ModelDeploymentMonitoringJob.
     *
     * The async variant is {@see self::updateModelDeploymentMonitoringJobAsync()} .
     *
     * @param UpdateModelDeploymentMonitoringJobRequest $request     A request to house fields associated with the call.
     * @param array                                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateModelDeploymentMonitoringJob(UpdateModelDeploymentMonitoringJobRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('UpdateModelDeploymentMonitoringJob', $request, $callOptions)->wait();
    }

    /**
     * Gets information about a location.
     *
     * The async variant is {@see self::getLocationAsync()} .
     *
     * @param GetLocationRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Location
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getLocation(GetLocationRequest $request, array $callOptions = []): Location
    {
        return $this->startApiCall('GetLocation', $request, $callOptions)->wait();
    }

    /**
     * Lists information about the supported locations for this service.
     *
     * The async variant is {@see self::listLocationsAsync()} .
     *
     * @param ListLocationsRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listLocations(ListLocationsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListLocations', $request, $callOptions);
    }

    /**
     * Gets the access control policy for a resource. Returns an empty policy
    if the resource exists and does not have a policy set.
     *
     * The async variant is {@see self::getIamPolicyAsync()} .
     *
     * @param GetIamPolicyRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Policy
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getIamPolicy(GetIamPolicyRequest $request, array $callOptions = []): Policy
    {
        return $this->startApiCall('GetIamPolicy', $request, $callOptions)->wait();
    }

    /**
     * Sets the access control policy on the specified resource. Replaces
    any existing policy.

    Can return `NOT_FOUND`, `INVALID_ARGUMENT`, and `PERMISSION_DENIED`
    errors.
     *
     * The async variant is {@see self::setIamPolicyAsync()} .
     *
     * @param SetIamPolicyRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Policy
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function setIamPolicy(SetIamPolicyRequest $request, array $callOptions = []): Policy
    {
        return $this->startApiCall('SetIamPolicy', $request, $callOptions)->wait();
    }

    /**
     * Returns permissions that a caller has on the specified resource. If the
    resource does not exist, this will return an empty set of
    permissions, not a `NOT_FOUND` error.

    Note: This operation is designed to be used for building
    permission-aware UIs and command-line tools, not for authorization
    checking. This operation may "fail open" without warning.
     *
     * The async variant is {@see self::testIamPermissionsAsync()} .
     *
     * @param TestIamPermissionsRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return TestIamPermissionsResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function testIamPermissions(TestIamPermissionsRequest $request, array $callOptions = []): TestIamPermissionsResponse
    {
        return $this->startApiCall('TestIamPermissions', $request, $callOptions)->wait();
    }
}
