<?php
/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/datacatalog/v1/datacatalog.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\DataCatalog\V1\Client;

use Google\ApiCore\ApiException;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\OperationResponse;
use Google\ApiCore\PagedListResponse;
use Google\ApiCore\ResourceHelperTrait;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\DataCatalog\V1\Contacts;
use Google\Cloud\DataCatalog\V1\CreateEntryGroupRequest;
use Google\Cloud\DataCatalog\V1\CreateEntryRequest;
use Google\Cloud\DataCatalog\V1\CreateTagRequest;
use Google\Cloud\DataCatalog\V1\CreateTagTemplateFieldRequest;
use Google\Cloud\DataCatalog\V1\CreateTagTemplateRequest;
use Google\Cloud\DataCatalog\V1\DeleteEntryGroupRequest;
use Google\Cloud\DataCatalog\V1\DeleteEntryRequest;
use Google\Cloud\DataCatalog\V1\DeleteTagRequest;
use Google\Cloud\DataCatalog\V1\DeleteTagTemplateFieldRequest;
use Google\Cloud\DataCatalog\V1\DeleteTagTemplateRequest;
use Google\Cloud\DataCatalog\V1\Entry;
use Google\Cloud\DataCatalog\V1\EntryGroup;
use Google\Cloud\DataCatalog\V1\EntryOverview;
use Google\Cloud\DataCatalog\V1\GetEntryGroupRequest;
use Google\Cloud\DataCatalog\V1\GetEntryRequest;
use Google\Cloud\DataCatalog\V1\GetTagTemplateRequest;
use Google\Cloud\DataCatalog\V1\ImportEntriesMetadata;
use Google\Cloud\DataCatalog\V1\ImportEntriesRequest;
use Google\Cloud\DataCatalog\V1\ImportEntriesResponse;
use Google\Cloud\DataCatalog\V1\ListEntriesRequest;
use Google\Cloud\DataCatalog\V1\ListEntryGroupsRequest;
use Google\Cloud\DataCatalog\V1\ListTagsRequest;
use Google\Cloud\DataCatalog\V1\LookupEntryRequest;
use Google\Cloud\DataCatalog\V1\MigrationConfig;
use Google\Cloud\DataCatalog\V1\ModifyEntryContactsRequest;
use Google\Cloud\DataCatalog\V1\ModifyEntryOverviewRequest;
use Google\Cloud\DataCatalog\V1\OrganizationConfig;
use Google\Cloud\DataCatalog\V1\ReconcileTagsMetadata;
use Google\Cloud\DataCatalog\V1\ReconcileTagsRequest;
use Google\Cloud\DataCatalog\V1\ReconcileTagsResponse;
use Google\Cloud\DataCatalog\V1\RenameTagTemplateFieldEnumValueRequest;
use Google\Cloud\DataCatalog\V1\RenameTagTemplateFieldRequest;
use Google\Cloud\DataCatalog\V1\RetrieveConfigRequest;
use Google\Cloud\DataCatalog\V1\RetrieveEffectiveConfigRequest;
use Google\Cloud\DataCatalog\V1\SearchCatalogRequest;
use Google\Cloud\DataCatalog\V1\SetConfigRequest;
use Google\Cloud\DataCatalog\V1\StarEntryRequest;
use Google\Cloud\DataCatalog\V1\StarEntryResponse;
use Google\Cloud\DataCatalog\V1\Tag;
use Google\Cloud\DataCatalog\V1\TagTemplate;
use Google\Cloud\DataCatalog\V1\TagTemplateField;
use Google\Cloud\DataCatalog\V1\UnstarEntryRequest;
use Google\Cloud\DataCatalog\V1\UnstarEntryResponse;
use Google\Cloud\DataCatalog\V1\UpdateEntryGroupRequest;
use Google\Cloud\DataCatalog\V1\UpdateEntryRequest;
use Google\Cloud\DataCatalog\V1\UpdateTagRequest;
use Google\Cloud\DataCatalog\V1\UpdateTagTemplateFieldRequest;
use Google\Cloud\DataCatalog\V1\UpdateTagTemplateRequest;
use Google\Cloud\Iam\V1\GetIamPolicyRequest;
use Google\Cloud\Iam\V1\Policy;
use Google\Cloud\Iam\V1\SetIamPolicyRequest;
use Google\Cloud\Iam\V1\TestIamPermissionsRequest;
use Google\Cloud\Iam\V1\TestIamPermissionsResponse;
use Google\LongRunning\Client\OperationsClient;
use Google\LongRunning\Operation;
use GuzzleHttp\Promise\PromiseInterface;
use Psr\Log\LoggerInterface;

/**
 * Service Description: Data Catalog API service allows you to discover, understand, and manage
 * your data.
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods.
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 *
 * @method PromiseInterface<Entry> createEntryAsync(CreateEntryRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<EntryGroup> createEntryGroupAsync(CreateEntryGroupRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Tag> createTagAsync(CreateTagRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<TagTemplate> createTagTemplateAsync(CreateTagTemplateRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<TagTemplateField> createTagTemplateFieldAsync(CreateTagTemplateFieldRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<void> deleteEntryAsync(DeleteEntryRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<void> deleteEntryGroupAsync(DeleteEntryGroupRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<void> deleteTagAsync(DeleteTagRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<void> deleteTagTemplateAsync(DeleteTagTemplateRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<void> deleteTagTemplateFieldAsync(DeleteTagTemplateFieldRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Entry> getEntryAsync(GetEntryRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<EntryGroup> getEntryGroupAsync(GetEntryGroupRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Policy> getIamPolicyAsync(GetIamPolicyRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<TagTemplate> getTagTemplateAsync(GetTagTemplateRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> importEntriesAsync(ImportEntriesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listEntriesAsync(ListEntriesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listEntryGroupsAsync(ListEntryGroupsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listTagsAsync(ListTagsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Entry> lookupEntryAsync(LookupEntryRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Contacts> modifyEntryContactsAsync(ModifyEntryContactsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<EntryOverview> modifyEntryOverviewAsync(ModifyEntryOverviewRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> reconcileTagsAsync(ReconcileTagsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<TagTemplateField> renameTagTemplateFieldAsync(RenameTagTemplateFieldRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<TagTemplateField> renameTagTemplateFieldEnumValueAsync(RenameTagTemplateFieldEnumValueRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OrganizationConfig> retrieveConfigAsync(RetrieveConfigRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<MigrationConfig> retrieveEffectiveConfigAsync(RetrieveEffectiveConfigRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> searchCatalogAsync(SearchCatalogRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<MigrationConfig> setConfigAsync(SetConfigRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Policy> setIamPolicyAsync(SetIamPolicyRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<StarEntryResponse> starEntryAsync(StarEntryRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<TestIamPermissionsResponse> testIamPermissionsAsync(TestIamPermissionsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<UnstarEntryResponse> unstarEntryAsync(UnstarEntryRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Entry> updateEntryAsync(UpdateEntryRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<EntryGroup> updateEntryGroupAsync(UpdateEntryGroupRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Tag> updateTagAsync(UpdateTagRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<TagTemplate> updateTagTemplateAsync(UpdateTagTemplateRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<TagTemplateField> updateTagTemplateFieldAsync(UpdateTagTemplateFieldRequest $request, array $optionalArgs = [])
 */
final class DataCatalogClient
{
    use GapicClientTrait;
    use ResourceHelperTrait;

    /** The name of the service. */
    private const SERVICE_NAME = 'google.cloud.datacatalog.v1.DataCatalog';

    /**
     * The default address of the service.
     *
     * @deprecated SERVICE_ADDRESS_TEMPLATE should be used instead.
     */
    private const SERVICE_ADDRESS = 'datacatalog.googleapis.com';

    /** The address template of the service. */
    private const SERVICE_ADDRESS_TEMPLATE = 'datacatalog.UNIVERSE_DOMAIN';

    /** The default port of the service. */
    private const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    private const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = ['https://www.googleapis.com/auth/cloud-platform'];

    private $operationsClient;

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' => self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' => __DIR__ . '/../resources/data_catalog_client_config.json',
            'descriptorsConfigPath' => __DIR__ . '/../resources/data_catalog_descriptor_config.php',
            'gcpApiConfigPath' => __DIR__ . '/../resources/data_catalog_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' => __DIR__ . '/../resources/data_catalog_rest_client_config.php',
                ],
            ],
        ];
    }

    /**
     * Return an OperationsClient object with the same endpoint as $this.
     *
     * @return OperationsClient
     */
    public function getOperationsClient()
    {
        return $this->operationsClient;
    }

    /**
     * Resume an existing long running operation that was previously started by a long
     * running API method. If $methodName is not provided, or does not match a long
     * running API method, then the operation can still be resumed, but the
     * OperationResponse object will not deserialize the final response.
     *
     * @param string $operationName The name of the long running operation
     * @param string $methodName    The name of the method used to start the operation
     *
     * @return OperationResponse
     */
    public function resumeOperation($operationName, $methodName = null)
    {
        $options = isset($this->descriptors[$methodName]['longRunning'])
            ? $this->descriptors[$methodName]['longRunning']
            : [];
        $operation = new OperationResponse($operationName, $this->getOperationsClient(), $options);
        $operation->reload();
        return $operation;
    }

    /**
     * Create the default operation client for the service.
     *
     * @param array $options ClientOptions for the client.
     *
     * @return OperationsClient
     */
    private function createOperationsClient(array $options)
    {
        // Unset client-specific configuration options
        unset($options['serviceName'], $options['clientConfig'], $options['descriptorsConfigPath']);

        if (isset($options['operationsClient'])) {
            return $options['operationsClient'];
        }

        return new OperationsClient($options);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a entry
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $entryGroup
     * @param string $entry
     *
     * @return string The formatted entry resource.
     */
    public static function entryName(string $project, string $location, string $entryGroup, string $entry): string
    {
        return self::getPathTemplate('entry')->render([
            'project' => $project,
            'location' => $location,
            'entry_group' => $entryGroup,
            'entry' => $entry,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a entry_group
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $entryGroup
     *
     * @return string The formatted entry_group resource.
     */
    public static function entryGroupName(string $project, string $location, string $entryGroup): string
    {
        return self::getPathTemplate('entryGroup')->render([
            'project' => $project,
            'location' => $location,
            'entry_group' => $entryGroup,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a location
     * resource.
     *
     * @param string $project
     * @param string $location
     *
     * @return string The formatted location resource.
     */
    public static function locationName(string $project, string $location): string
    {
        return self::getPathTemplate('location')->render([
            'project' => $project,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a tag
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $entryGroup
     * @param string $entry
     * @param string $tag
     *
     * @return string The formatted tag resource.
     */
    public static function tagName(
        string $project,
        string $location,
        string $entryGroup,
        string $entry,
        string $tag
    ): string {
        return self::getPathTemplate('tag')->render([
            'project' => $project,
            'location' => $location,
            'entry_group' => $entryGroup,
            'entry' => $entry,
            'tag' => $tag,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a tag_template
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $tagTemplate
     *
     * @return string The formatted tag_template resource.
     */
    public static function tagTemplateName(string $project, string $location, string $tagTemplate): string
    {
        return self::getPathTemplate('tagTemplate')->render([
            'project' => $project,
            'location' => $location,
            'tag_template' => $tagTemplate,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * tag_template_field resource.
     *
     * @param string $project
     * @param string $location
     * @param string $tagTemplate
     * @param string $field
     *
     * @return string The formatted tag_template_field resource.
     */
    public static function tagTemplateFieldName(
        string $project,
        string $location,
        string $tagTemplate,
        string $field
    ): string {
        return self::getPathTemplate('tagTemplateField')->render([
            'project' => $project,
            'location' => $location,
            'tag_template' => $tagTemplate,
            'field' => $field,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * tag_template_field_enum_value resource.
     *
     * @param string $project
     * @param string $location
     * @param string $tagTemplate
     * @param string $tagTemplateFieldId
     * @param string $enumValueDisplayName
     *
     * @return string The formatted tag_template_field_enum_value resource.
     */
    public static function tagTemplateFieldEnumValueName(
        string $project,
        string $location,
        string $tagTemplate,
        string $tagTemplateFieldId,
        string $enumValueDisplayName
    ): string {
        return self::getPathTemplate('tagTemplateFieldEnumValue')->render([
            'project' => $project,
            'location' => $location,
            'tag_template' => $tagTemplate,
            'tag_template_field_id' => $tagTemplateFieldId,
            'enum_value_display_name' => $enumValueDisplayName,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - entry: projects/{project}/locations/{location}/entryGroups/{entry_group}/entries/{entry}
     * - entryGroup: projects/{project}/locations/{location}/entryGroups/{entry_group}
     * - location: projects/{project}/locations/{location}
     * - tag: projects/{project}/locations/{location}/entryGroups/{entry_group}/entries/{entry}/tags/{tag}
     * - tagTemplate: projects/{project}/locations/{location}/tagTemplates/{tag_template}
     * - tagTemplateField: projects/{project}/locations/{location}/tagTemplates/{tag_template}/fields/{field}
     * - tagTemplateFieldEnumValue: projects/{project}/locations/{location}/tagTemplates/{tag_template}/fields/{tag_template_field_id}/enumValues/{enum_value_display_name}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string  $formattedName The formatted name string
     * @param ?string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName(string $formattedName, ?string $template = null): array
    {
        return self::parseFormattedName($formattedName, $template);
    }

    /**
     * Constructor.
     *
     * @param array $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'datacatalog.googleapis.com:443'.
     *     @type string|array|FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           The credentials to be used by the client to authorize API calls. This option
     *           accepts either a path to a credentials file, or a decoded credentials file as a
     *           PHP array.
     *           *Advanced usage*: In addition, this option can also accept a pre-constructed
     *           {@see \Google\Auth\FetchAuthTokenInterface} object or
     *           {@see \Google\ApiCore\CredentialsWrapper} object. Note that when one of these
     *           objects are provided, any settings in $credentialsConfig will be ignored.
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     *     @type false|LoggerInterface $logger
     *           A PSR-3 compliant logger. If set to false, logging is disabled, ignoring the
     *           'GOOGLE_SDK_PHP_LOGGING' environment flag
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
        $this->operationsClient = $this->createOperationsClient($clientOptions);
    }

    /** Handles execution of the async variants for each documented method. */
    public function __call($method, $args)
    {
        if (substr($method, -5) !== 'Async') {
            trigger_error('Call to undefined method ' . __CLASS__ . "::$method()", E_USER_ERROR);
        }

        array_unshift($args, substr($method, 0, -5));
        return call_user_func_array([$this, 'startAsyncCall'], $args);
    }

    /**
     * Creates an entry.
     *
     * You can create entries only with 'FILESET', 'CLUSTER', 'DATA_STREAM',
     * or custom types. Data Catalog automatically creates entries with other
     * types during metadata ingestion from integrated systems.
     *
     * You must enable the Data Catalog API in the project identified by
     * the `parent` parameter. For more information, see [Data Catalog resource
     * project](https://cloud.google.com/data-catalog/docs/concepts/resource-project).
     *
     * An entry group can have a maximum of 100,000 entries.
     *
     * The async variant is {@see DataCatalogClient::createEntryAsync()} .
     *
     * @example samples/V1/DataCatalogClient/create_entry.php
     *
     * @param CreateEntryRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Entry
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createEntry(CreateEntryRequest $request, array $callOptions = []): Entry
    {
        return $this->startApiCall('CreateEntry', $request, $callOptions)->wait();
    }

    /**
     * Creates an entry group.
     *
     * An entry group contains logically related entries together with [Cloud
     * Identity and Access Management](/data-catalog/docs/concepts/iam) policies.
     * These policies specify users who can create, edit, and view entries
     * within entry groups.
     *
     * Data Catalog automatically creates entry groups with names that start with
     * the `&#64;` symbol for the following resources:
     *
     * * BigQuery entries (`&#64;bigquery`)
     * * Pub/Sub topics (`&#64;pubsub`)
     * * Dataproc Metastore services (`&#64;dataproc_metastore_{SERVICE_NAME_HASH}`)
     *
     * You can create your own entry groups for Cloud Storage fileset entries
     * and custom entries together with the corresponding IAM policies.
     * User-created entry groups can't contain the `&#64;` symbol, it is reserved
     * for automatically created groups.
     *
     * Entry groups, like entries, can be searched.
     *
     * A maximum of 10,000 entry groups may be created per organization across all
     * locations.
     *
     * You must enable the Data Catalog API in the project identified by
     * the `parent` parameter. For more information, see [Data Catalog resource
     * project](https://cloud.google.com/data-catalog/docs/concepts/resource-project).
     *
     * The async variant is {@see DataCatalogClient::createEntryGroupAsync()} .
     *
     * @example samples/V1/DataCatalogClient/create_entry_group.php
     *
     * @param CreateEntryGroupRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return EntryGroup
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createEntryGroup(CreateEntryGroupRequest $request, array $callOptions = []): EntryGroup
    {
        return $this->startApiCall('CreateEntryGroup', $request, $callOptions)->wait();
    }

    /**
     * Creates a tag and assigns it to:
     *
     * * An [Entry][google.cloud.datacatalog.v1.Entry] if the method name is
     * `projects.locations.entryGroups.entries.tags.create`.
     * * Or [EntryGroup][google.cloud.datacatalog.v1.EntryGroup]if the method
     * name is `projects.locations.entryGroups.tags.create`.
     *
     * Note: The project identified by the `parent` parameter for the [tag]
     * (https://cloud.google.com/data-catalog/docs/reference/rest/v1/projects.locations.entryGroups.entries.tags/create#path-parameters)
     * and the [tag template]
     * (https://cloud.google.com/data-catalog/docs/reference/rest/v1/projects.locations.tagTemplates/create#path-parameters)
     * used to create the tag must be in the same organization.
     *
     * The async variant is {@see DataCatalogClient::createTagAsync()} .
     *
     * @example samples/V1/DataCatalogClient/create_tag.php
     *
     * @param CreateTagRequest $request     A request to house fields associated with the call.
     * @param array            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Tag
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createTag(CreateTagRequest $request, array $callOptions = []): Tag
    {
        return $this->startApiCall('CreateTag', $request, $callOptions)->wait();
    }

    /**
     * Creates a tag template.
     *
     * You must enable the Data Catalog API in the project identified by the
     * `parent` parameter.
     * For more information, see [Data Catalog resource project]
     * (https://cloud.google.com/data-catalog/docs/concepts/resource-project).
     *
     * The async variant is {@see DataCatalogClient::createTagTemplateAsync()} .
     *
     * @example samples/V1/DataCatalogClient/create_tag_template.php
     *
     * @param CreateTagTemplateRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return TagTemplate
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createTagTemplate(CreateTagTemplateRequest $request, array $callOptions = []): TagTemplate
    {
        return $this->startApiCall('CreateTagTemplate', $request, $callOptions)->wait();
    }

    /**
     * Creates a field in a tag template.
     *
     * You must enable the Data Catalog API in the project identified by
     * the `parent` parameter. For more information, see [Data Catalog resource
     * project](https://cloud.google.com/data-catalog/docs/concepts/resource-project).
     *
     * The async variant is {@see DataCatalogClient::createTagTemplateFieldAsync()} .
     *
     * @example samples/V1/DataCatalogClient/create_tag_template_field.php
     *
     * @param CreateTagTemplateFieldRequest $request     A request to house fields associated with the call.
     * @param array                         $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return TagTemplateField
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createTagTemplateField(
        CreateTagTemplateFieldRequest $request,
        array $callOptions = []
    ): TagTemplateField {
        return $this->startApiCall('CreateTagTemplateField', $request, $callOptions)->wait();
    }

    /**
     * Deletes an existing entry.
     *
     * You can delete only the entries created by the
     * [CreateEntry][google.cloud.datacatalog.v1.DataCatalog.CreateEntry]
     * method.
     *
     * You must enable the Data Catalog API in the project identified by
     * the `name` parameter. For more information, see [Data Catalog
     * resource
     * project](https://cloud.google.com/data-catalog/docs/concepts/resource-project).
     *
     * The async variant is {@see DataCatalogClient::deleteEntryAsync()} .
     *
     * @example samples/V1/DataCatalogClient/delete_entry.php
     *
     * @param DeleteEntryRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteEntry(DeleteEntryRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('DeleteEntry', $request, $callOptions)->wait();
    }

    /**
     * Deletes an entry group.
     *
     * You must enable the Data Catalog API in the project
     * identified by the `name` parameter. For more information, see [Data Catalog
     * resource
     * project](https://cloud.google.com/data-catalog/docs/concepts/resource-project).
     *
     * The async variant is {@see DataCatalogClient::deleteEntryGroupAsync()} .
     *
     * @example samples/V1/DataCatalogClient/delete_entry_group.php
     *
     * @param DeleteEntryGroupRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteEntryGroup(DeleteEntryGroupRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('DeleteEntryGroup', $request, $callOptions)->wait();
    }

    /**
     * Deletes a tag.
     *
     * The async variant is {@see DataCatalogClient::deleteTagAsync()} .
     *
     * @example samples/V1/DataCatalogClient/delete_tag.php
     *
     * @param DeleteTagRequest $request     A request to house fields associated with the call.
     * @param array            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteTag(DeleteTagRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('DeleteTag', $request, $callOptions)->wait();
    }

    /**
     * Deletes a tag template and all tags that use it.
     *
     * You must enable the Data Catalog API in the project identified by
     * the `name` parameter. For more information, see [Data Catalog resource
     * project](https://cloud.google.com/data-catalog/docs/concepts/resource-project).
     *
     * The async variant is {@see DataCatalogClient::deleteTagTemplateAsync()} .
     *
     * @example samples/V1/DataCatalogClient/delete_tag_template.php
     *
     * @param DeleteTagTemplateRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteTagTemplate(DeleteTagTemplateRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('DeleteTagTemplate', $request, $callOptions)->wait();
    }

    /**
     * Deletes a field in a tag template and all uses of this field from the tags
     * based on this template.
     *
     * You must enable the Data Catalog API in the project identified by
     * the `name` parameter. For more information, see [Data Catalog resource
     * project](https://cloud.google.com/data-catalog/docs/concepts/resource-project).
     *
     * The async variant is {@see DataCatalogClient::deleteTagTemplateFieldAsync()} .
     *
     * @example samples/V1/DataCatalogClient/delete_tag_template_field.php
     *
     * @param DeleteTagTemplateFieldRequest $request     A request to house fields associated with the call.
     * @param array                         $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteTagTemplateField(DeleteTagTemplateFieldRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('DeleteTagTemplateField', $request, $callOptions)->wait();
    }

    /**
     * Gets an entry.
     *
     * The async variant is {@see DataCatalogClient::getEntryAsync()} .
     *
     * @example samples/V1/DataCatalogClient/get_entry.php
     *
     * @param GetEntryRequest $request     A request to house fields associated with the call.
     * @param array           $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Entry
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getEntry(GetEntryRequest $request, array $callOptions = []): Entry
    {
        return $this->startApiCall('GetEntry', $request, $callOptions)->wait();
    }

    /**
     * Gets an entry group.
     *
     * The async variant is {@see DataCatalogClient::getEntryGroupAsync()} .
     *
     * @example samples/V1/DataCatalogClient/get_entry_group.php
     *
     * @param GetEntryGroupRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return EntryGroup
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getEntryGroup(GetEntryGroupRequest $request, array $callOptions = []): EntryGroup
    {
        return $this->startApiCall('GetEntryGroup', $request, $callOptions)->wait();
    }

    /**
     * Gets the access control policy for a resource.
     *
     * May return:
     *
     * * A`NOT_FOUND` error if the resource doesn't exist or you don't have the
     * permission to view it.
     * * An empty policy if the resource exists but doesn't have a set policy.
     *
     * Supported resources are:
     *
     * - Tag templates
     * - Entry groups
     *
     * Note: This method doesn't get policies from Google Cloud Platform
     * resources ingested into Data Catalog.
     *
     * To call this method, you must have the following Google IAM permissions:
     *
     * - `datacatalog.tagTemplates.getIamPolicy` to get policies on tag
     * templates.
     * - `datacatalog.entryGroups.getIamPolicy` to get policies on entry groups.
     *
     * The async variant is {@see DataCatalogClient::getIamPolicyAsync()} .
     *
     * @example samples/V1/DataCatalogClient/get_iam_policy.php
     *
     * @param GetIamPolicyRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Policy
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getIamPolicy(GetIamPolicyRequest $request, array $callOptions = []): Policy
    {
        return $this->startApiCall('GetIamPolicy', $request, $callOptions)->wait();
    }

    /**
     * Gets a tag template.
     *
     * The async variant is {@see DataCatalogClient::getTagTemplateAsync()} .
     *
     * @example samples/V1/DataCatalogClient/get_tag_template.php
     *
     * @param GetTagTemplateRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return TagTemplate
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getTagTemplate(GetTagTemplateRequest $request, array $callOptions = []): TagTemplate
    {
        return $this->startApiCall('GetTagTemplate', $request, $callOptions)->wait();
    }

    /**
     * Imports entries from a source, such as data previously dumped into a
     * Cloud Storage bucket, into Data Catalog. Import of entries
     * is a sync operation that reconciles the state of the third-party system
     * with the Data Catalog.
     *
     * `ImportEntries` accepts source data snapshots of a third-party system.
     * Snapshot should be delivered as a .wire or base65-encoded .txt file
     * containing a sequence of Protocol Buffer messages of
     * [DumpItem][google.cloud.datacatalog.v1.DumpItem] type.
     *
     * `ImportEntries` returns a [long-running operation]
     * [google.longrunning.Operation] resource that can be queried with
     * [Operations.GetOperation][google.longrunning.Operations.GetOperation]
     * to return
     * [ImportEntriesMetadata][google.cloud.datacatalog.v1.ImportEntriesMetadata]
     * and an
     * [ImportEntriesResponse][google.cloud.datacatalog.v1.ImportEntriesResponse]
     * message.
     *
     * The async variant is {@see DataCatalogClient::importEntriesAsync()} .
     *
     * @example samples/V1/DataCatalogClient/import_entries.php
     *
     * @param ImportEntriesRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function importEntries(ImportEntriesRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('ImportEntries', $request, $callOptions)->wait();
    }

    /**
     * Lists entries.
     *
     * Note: Currently, this method can list only custom entries.
     * To get a list of both custom and automatically created entries, use
     * [SearchCatalog][google.cloud.datacatalog.v1.DataCatalog.SearchCatalog].
     *
     * The async variant is {@see DataCatalogClient::listEntriesAsync()} .
     *
     * @example samples/V1/DataCatalogClient/list_entries.php
     *
     * @param ListEntriesRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listEntries(ListEntriesRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListEntries', $request, $callOptions);
    }

    /**
     * Lists entry groups.
     *
     * The async variant is {@see DataCatalogClient::listEntryGroupsAsync()} .
     *
     * @example samples/V1/DataCatalogClient/list_entry_groups.php
     *
     * @param ListEntryGroupsRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listEntryGroups(ListEntryGroupsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListEntryGroups', $request, $callOptions);
    }

    /**
     * Lists tags assigned to an [Entry][google.cloud.datacatalog.v1.Entry].
     * The [columns][google.cloud.datacatalog.v1.Tag.column] in the response are
     * lowercased.
     *
     * The async variant is {@see DataCatalogClient::listTagsAsync()} .
     *
     * @example samples/V1/DataCatalogClient/list_tags.php
     *
     * @param ListTagsRequest $request     A request to house fields associated with the call.
     * @param array           $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listTags(ListTagsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListTags', $request, $callOptions);
    }

    /**
     * Gets an entry by its target resource name.
     *
     * The resource name comes from the source Google Cloud Platform service.
     *
     * The async variant is {@see DataCatalogClient::lookupEntryAsync()} .
     *
     * @example samples/V1/DataCatalogClient/lookup_entry.php
     *
     * @param LookupEntryRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Entry
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function lookupEntry(LookupEntryRequest $request, array $callOptions = []): Entry
    {
        return $this->startApiCall('LookupEntry', $request, $callOptions)->wait();
    }

    /**
     * Modifies contacts, part of the business context of an
     * [Entry][google.cloud.datacatalog.v1.Entry].
     *
     * To call this method, you must have the `datacatalog.entries.updateContacts`
     * IAM permission on the corresponding project.
     *
     * The async variant is {@see DataCatalogClient::modifyEntryContactsAsync()} .
     *
     * @example samples/V1/DataCatalogClient/modify_entry_contacts.php
     *
     * @param ModifyEntryContactsRequest $request     A request to house fields associated with the call.
     * @param array                      $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Contacts
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function modifyEntryContacts(ModifyEntryContactsRequest $request, array $callOptions = []): Contacts
    {
        return $this->startApiCall('ModifyEntryContacts', $request, $callOptions)->wait();
    }

    /**
     * Modifies entry overview, part of the business context of an
     * [Entry][google.cloud.datacatalog.v1.Entry].
     *
     * To call this method, you must have the `datacatalog.entries.updateOverview`
     * IAM permission on the corresponding project.
     *
     * The async variant is {@see DataCatalogClient::modifyEntryOverviewAsync()} .
     *
     * @example samples/V1/DataCatalogClient/modify_entry_overview.php
     *
     * @param ModifyEntryOverviewRequest $request     A request to house fields associated with the call.
     * @param array                      $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return EntryOverview
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function modifyEntryOverview(ModifyEntryOverviewRequest $request, array $callOptions = []): EntryOverview
    {
        return $this->startApiCall('ModifyEntryOverview', $request, $callOptions)->wait();
    }

    /**
     * `ReconcileTags` creates or updates a list of tags on the entry.
     * If the
     * [ReconcileTagsRequest.force_delete_missing][google.cloud.datacatalog.v1.ReconcileTagsRequest.force_delete_missing]
     * parameter is set, the operation deletes tags not included in the input tag
     * list.
     *
     * `ReconcileTags` returns a [long-running operation]
     * [google.longrunning.Operation] resource that can be queried with
     * [Operations.GetOperation][google.longrunning.Operations.GetOperation]
     * to return [ReconcileTagsMetadata]
     * [google.cloud.datacatalog.v1.ReconcileTagsMetadata] and
     * a [ReconcileTagsResponse]
     * [google.cloud.datacatalog.v1.ReconcileTagsResponse] message.
     *
     * The async variant is {@see DataCatalogClient::reconcileTagsAsync()} .
     *
     * @example samples/V1/DataCatalogClient/reconcile_tags.php
     *
     * @param ReconcileTagsRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function reconcileTags(ReconcileTagsRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('ReconcileTags', $request, $callOptions)->wait();
    }

    /**
     * Renames a field in a tag template.
     *
     * You must enable the Data Catalog API in the project identified by the
     * `name` parameter. For more information, see [Data Catalog resource project]
     * (https://cloud.google.com/data-catalog/docs/concepts/resource-project).
     *
     * The async variant is {@see DataCatalogClient::renameTagTemplateFieldAsync()} .
     *
     * @example samples/V1/DataCatalogClient/rename_tag_template_field.php
     *
     * @param RenameTagTemplateFieldRequest $request     A request to house fields associated with the call.
     * @param array                         $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return TagTemplateField
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function renameTagTemplateField(
        RenameTagTemplateFieldRequest $request,
        array $callOptions = []
    ): TagTemplateField {
        return $this->startApiCall('RenameTagTemplateField', $request, $callOptions)->wait();
    }

    /**
     * Renames an enum value in a tag template.
     *
     * Within a single enum field, enum values must be unique.
     *
     * The async variant is
     * {@see DataCatalogClient::renameTagTemplateFieldEnumValueAsync()} .
     *
     * @example samples/V1/DataCatalogClient/rename_tag_template_field_enum_value.php
     *
     * @param RenameTagTemplateFieldEnumValueRequest $request     A request to house fields associated with the call.
     * @param array                                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return TagTemplateField
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function renameTagTemplateFieldEnumValue(
        RenameTagTemplateFieldEnumValueRequest $request,
        array $callOptions = []
    ): TagTemplateField {
        return $this->startApiCall('RenameTagTemplateFieldEnumValue', $request, $callOptions)->wait();
    }

    /**
     * Retrieves the configuration related to the migration from Data Catalog to
     * Dataplex for a specific organization, including all the projects under it
     * which have a separate configuration set.
     *
     * The async variant is {@see DataCatalogClient::retrieveConfigAsync()} .
     *
     * @example samples/V1/DataCatalogClient/retrieve_config.php
     *
     * @param RetrieveConfigRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OrganizationConfig
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function retrieveConfig(RetrieveConfigRequest $request, array $callOptions = []): OrganizationConfig
    {
        return $this->startApiCall('RetrieveConfig', $request, $callOptions)->wait();
    }

    /**
     * Retrieves the effective configuration related to the migration from Data
     * Catalog to Dataplex for a specific organization or project. If there is no
     * specific configuration set for the resource, the setting is checked
     * hierarchicahlly through the ancestors of the resource, starting from the
     * resource itself.
     *
     * The async variant is {@see DataCatalogClient::retrieveEffectiveConfigAsync()} .
     *
     * @example samples/V1/DataCatalogClient/retrieve_effective_config.php
     *
     * @param RetrieveEffectiveConfigRequest $request     A request to house fields associated with the call.
     * @param array                          $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return MigrationConfig
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function retrieveEffectiveConfig(
        RetrieveEffectiveConfigRequest $request,
        array $callOptions = []
    ): MigrationConfig {
        return $this->startApiCall('RetrieveEffectiveConfig', $request, $callOptions)->wait();
    }

    /**
     * Searches Data Catalog for multiple resources like entries and tags that
     * match a query.
     *
     * This is a [Custom Method]
     * (https://cloud.google.com/apis/design/custom_methods) that doesn't return
     * all information on a resource, only its ID and high level fields. To get
     * more information, you can subsequently call specific get methods.
     *
     * Note: Data Catalog search queries don't guarantee full recall. Results
     * that match your query might not be returned, even in subsequent
     * result pages. Additionally, returned (and not returned) results can vary
     * if you repeat search queries.
     *
     * For more information, see [Data Catalog search syntax]
     * (https://cloud.google.com/data-catalog/docs/how-to/search-reference).
     *
     * The async variant is {@see DataCatalogClient::searchCatalogAsync()} .
     *
     * @example samples/V1/DataCatalogClient/search_catalog.php
     *
     * @param SearchCatalogRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function searchCatalog(SearchCatalogRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('SearchCatalog', $request, $callOptions);
    }

    /**
     * Sets the configuration related to the migration to Dataplex for an
     * organization or project.
     *
     * The async variant is {@see DataCatalogClient::setConfigAsync()} .
     *
     * @example samples/V1/DataCatalogClient/set_config.php
     *
     * @param SetConfigRequest $request     A request to house fields associated with the call.
     * @param array            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return MigrationConfig
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function setConfig(SetConfigRequest $request, array $callOptions = []): MigrationConfig
    {
        return $this->startApiCall('SetConfig', $request, $callOptions)->wait();
    }

    /**
     * Sets an access control policy for a resource. Replaces any existing
     * policy.
     *
     * Supported resources are:
     *
     * - Tag templates
     * - Entry groups
     *
     * Note: This method sets policies only within Data Catalog and can't be
     * used to manage policies in BigQuery, Pub/Sub, Dataproc Metastore, and any
     * external Google Cloud Platform resources synced with the Data Catalog.
     *
     * To call this method, you must have the following Google IAM permissions:
     *
     * - `datacatalog.tagTemplates.setIamPolicy` to set policies on tag
     * templates.
     * - `datacatalog.entryGroups.setIamPolicy` to set policies on entry groups.
     *
     * The async variant is {@see DataCatalogClient::setIamPolicyAsync()} .
     *
     * @example samples/V1/DataCatalogClient/set_iam_policy.php
     *
     * @param SetIamPolicyRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Policy
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function setIamPolicy(SetIamPolicyRequest $request, array $callOptions = []): Policy
    {
        return $this->startApiCall('SetIamPolicy', $request, $callOptions)->wait();
    }

    /**
     * Marks an [Entry][google.cloud.datacatalog.v1.Entry] as starred by
     * the current user. Starring information is private to each user.
     *
     * The async variant is {@see DataCatalogClient::starEntryAsync()} .
     *
     * @example samples/V1/DataCatalogClient/star_entry.php
     *
     * @param StarEntryRequest $request     A request to house fields associated with the call.
     * @param array            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return StarEntryResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function starEntry(StarEntryRequest $request, array $callOptions = []): StarEntryResponse
    {
        return $this->startApiCall('StarEntry', $request, $callOptions)->wait();
    }

    /**
     * Gets your permissions on a resource.
     *
     * Returns an empty set of permissions if the resource doesn't exist.
     *
     * Supported resources are:
     *
     * - Tag templates
     * - Entry groups
     *
     * Note: This method gets policies only within Data Catalog and can't be
     * used to get policies from BigQuery, Pub/Sub, Dataproc Metastore, and any
     * external Google Cloud Platform resources ingested into Data Catalog.
     *
     * No Google IAM permissions are required to call this method.
     *
     * The async variant is {@see DataCatalogClient::testIamPermissionsAsync()} .
     *
     * @example samples/V1/DataCatalogClient/test_iam_permissions.php
     *
     * @param TestIamPermissionsRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return TestIamPermissionsResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function testIamPermissions(
        TestIamPermissionsRequest $request,
        array $callOptions = []
    ): TestIamPermissionsResponse {
        return $this->startApiCall('TestIamPermissions', $request, $callOptions)->wait();
    }

    /**
     * Marks an [Entry][google.cloud.datacatalog.v1.Entry] as NOT starred by
     * the current user. Starring information is private to each user.
     *
     * The async variant is {@see DataCatalogClient::unstarEntryAsync()} .
     *
     * @example samples/V1/DataCatalogClient/unstar_entry.php
     *
     * @param UnstarEntryRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return UnstarEntryResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function unstarEntry(UnstarEntryRequest $request, array $callOptions = []): UnstarEntryResponse
    {
        return $this->startApiCall('UnstarEntry', $request, $callOptions)->wait();
    }

    /**
     * Updates an existing entry.
     *
     * You must enable the Data Catalog API in the project identified by
     * the `entry.name` parameter. For more information, see [Data Catalog
     * resource
     * project](https://cloud.google.com/data-catalog/docs/concepts/resource-project).
     *
     * The async variant is {@see DataCatalogClient::updateEntryAsync()} .
     *
     * @example samples/V1/DataCatalogClient/update_entry.php
     *
     * @param UpdateEntryRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Entry
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateEntry(UpdateEntryRequest $request, array $callOptions = []): Entry
    {
        return $this->startApiCall('UpdateEntry', $request, $callOptions)->wait();
    }

    /**
     * Updates an entry group.
     *
     * You must enable the Data Catalog API in the project identified by
     * the `entry_group.name` parameter. For more information, see [Data Catalog
     * resource
     * project](https://cloud.google.com/data-catalog/docs/concepts/resource-project).
     *
     * The async variant is {@see DataCatalogClient::updateEntryGroupAsync()} .
     *
     * @example samples/V1/DataCatalogClient/update_entry_group.php
     *
     * @param UpdateEntryGroupRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return EntryGroup
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateEntryGroup(UpdateEntryGroupRequest $request, array $callOptions = []): EntryGroup
    {
        return $this->startApiCall('UpdateEntryGroup', $request, $callOptions)->wait();
    }

    /**
     * Updates an existing tag.
     *
     * The async variant is {@see DataCatalogClient::updateTagAsync()} .
     *
     * @example samples/V1/DataCatalogClient/update_tag.php
     *
     * @param UpdateTagRequest $request     A request to house fields associated with the call.
     * @param array            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Tag
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateTag(UpdateTagRequest $request, array $callOptions = []): Tag
    {
        return $this->startApiCall('UpdateTag', $request, $callOptions)->wait();
    }

    /**
     * Updates a tag template.
     *
     * You can't update template fields with this method. These fields are
     * separate resources with their own create, update, and delete methods.
     *
     * You must enable the Data Catalog API in the project identified by
     * the `tag_template.name` parameter. For more information, see [Data Catalog
     * resource
     * project](https://cloud.google.com/data-catalog/docs/concepts/resource-project).
     *
     * The async variant is {@see DataCatalogClient::updateTagTemplateAsync()} .
     *
     * @example samples/V1/DataCatalogClient/update_tag_template.php
     *
     * @param UpdateTagTemplateRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return TagTemplate
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateTagTemplate(UpdateTagTemplateRequest $request, array $callOptions = []): TagTemplate
    {
        return $this->startApiCall('UpdateTagTemplate', $request, $callOptions)->wait();
    }

    /**
     * Updates a field in a tag template.
     *
     * You can't update the field type with this method.
     *
     * You must enable the Data Catalog API in the project
     * identified by the `name` parameter. For more information, see [Data Catalog
     * resource
     * project](https://cloud.google.com/data-catalog/docs/concepts/resource-project).
     *
     * The async variant is {@see DataCatalogClient::updateTagTemplateFieldAsync()} .
     *
     * @example samples/V1/DataCatalogClient/update_tag_template_field.php
     *
     * @param UpdateTagTemplateFieldRequest $request     A request to house fields associated with the call.
     * @param array                         $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return TagTemplateField
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateTagTemplateField(
        UpdateTagTemplateFieldRequest $request,
        array $callOptions = []
    ): TagTemplateField {
        return $this->startApiCall('UpdateTagTemplateField', $request, $callOptions)->wait();
    }
}
