<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/apihub/v1/apihub_service.proto

namespace Google\Cloud\ApiHub\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * The [SearchResources][google.cloud.apihub.v1.ApiHub.SearchResources] method's
 * request.
 *
 * Generated from protobuf message <code>google.cloud.apihub.v1.SearchResourcesRequest</code>
 */
class SearchResourcesRequest extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. The resource name of the location which will be of the type
     * `projects/{project_id}/locations/{location_id}`. This field is used to
     * identify the instance of API-Hub in which resources should be searched.
     *
     * Generated from protobuf field <code>string location = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     */
    protected $location = '';
    /**
     * Required. The free text search query. This query can contain keywords which
     * could be related to any detail of the API-Hub resources such display names,
     * descriptions, attributes etc.
     *
     * Generated from protobuf field <code>string query = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $query = '';
    /**
     * Optional. An expression that filters the list of search results.
     * A filter expression consists of a field name, a comparison operator,
     * and a value for filtering. The value must be a string, a number, or a
     * boolean. The comparison operator must be `=`. Filters are not case
     * sensitive.
     * The following field names are eligible for filtering:
     *    * `resource_type` - The type of resource in the search results.
     *    Must be one of the following: `Api`, `ApiOperation`, `Deployment`,
     *    `Definition`, `Spec` or `Version`. This field can only be specified once
     *    in the filter.
     * Here are is an example:
     *   * `resource_type = Api` - The resource_type is _Api_.
     *
     * Generated from protobuf field <code>string filter = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $filter = '';
    /**
     * Optional. The maximum number of search results to return. The service may
     * return fewer than this value. If unspecified at most 10 search results will
     * be returned. If value is negative then `INVALID_ARGUMENT` error is
     * returned. The maximum value is 25; values above 25 will be coerced to 25.
     * While paginating, you can specify a new page size parameter for each page
     * of search results to be listed.
     *
     * Generated from protobuf field <code>int32 page_size = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $page_size = 0;
    /**
     * Optional. A page token, received from a previous
     * [SearchResources][SearchResources]
     * call. Specify this parameter to retrieve the next page of transactions.
     * When paginating, you must specify the `page_token` parameter and all the
     * other parameters except
     * [page_size][google.cloud.apihub.v1.SearchResourcesRequest.page_size]
     * should be specified with the same value which was used in the previous
     * call. If the other fields are set with a different value than the previous
     * call then `INVALID_ARGUMENT` error is returned.
     *
     * Generated from protobuf field <code>string page_token = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $page_token = '';

    /**
     * @param string $location Required. The resource name of the location which will be of the type
     *                         `projects/{project_id}/locations/{location_id}`. This field is used to
     *                         identify the instance of API-Hub in which resources should be searched. Please see
     *                         {@see ApiHubClient::locationName()} for help formatting this field.
     * @param string $query    Required. The free text search query. This query can contain keywords which
     *                         could be related to any detail of the API-Hub resources such display names,
     *                         descriptions, attributes etc.
     *
     * @return \Google\Cloud\ApiHub\V1\SearchResourcesRequest
     *
     * @experimental
     */
    public static function build(string $location, string $query): self
    {
        return (new self())
            ->setLocation($location)
            ->setQuery($query);
    }

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $location
     *           Required. The resource name of the location which will be of the type
     *           `projects/{project_id}/locations/{location_id}`. This field is used to
     *           identify the instance of API-Hub in which resources should be searched.
     *     @type string $query
     *           Required. The free text search query. This query can contain keywords which
     *           could be related to any detail of the API-Hub resources such display names,
     *           descriptions, attributes etc.
     *     @type string $filter
     *           Optional. An expression that filters the list of search results.
     *           A filter expression consists of a field name, a comparison operator,
     *           and a value for filtering. The value must be a string, a number, or a
     *           boolean. The comparison operator must be `=`. Filters are not case
     *           sensitive.
     *           The following field names are eligible for filtering:
     *              * `resource_type` - The type of resource in the search results.
     *              Must be one of the following: `Api`, `ApiOperation`, `Deployment`,
     *              `Definition`, `Spec` or `Version`. This field can only be specified once
     *              in the filter.
     *           Here are is an example:
     *             * `resource_type = Api` - The resource_type is _Api_.
     *     @type int $page_size
     *           Optional. The maximum number of search results to return. The service may
     *           return fewer than this value. If unspecified at most 10 search results will
     *           be returned. If value is negative then `INVALID_ARGUMENT` error is
     *           returned. The maximum value is 25; values above 25 will be coerced to 25.
     *           While paginating, you can specify a new page size parameter for each page
     *           of search results to be listed.
     *     @type string $page_token
     *           Optional. A page token, received from a previous
     *           [SearchResources][SearchResources]
     *           call. Specify this parameter to retrieve the next page of transactions.
     *           When paginating, you must specify the `page_token` parameter and all the
     *           other parameters except
     *           [page_size][google.cloud.apihub.v1.SearchResourcesRequest.page_size]
     *           should be specified with the same value which was used in the previous
     *           call. If the other fields are set with a different value than the previous
     *           call then `INVALID_ARGUMENT` error is returned.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Apihub\V1\ApihubService::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. The resource name of the location which will be of the type
     * `projects/{project_id}/locations/{location_id}`. This field is used to
     * identify the instance of API-Hub in which resources should be searched.
     *
     * Generated from protobuf field <code>string location = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getLocation()
    {
        return $this->location;
    }

    /**
     * Required. The resource name of the location which will be of the type
     * `projects/{project_id}/locations/{location_id}`. This field is used to
     * identify the instance of API-Hub in which resources should be searched.
     *
     * Generated from protobuf field <code>string location = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setLocation($var)
    {
        GPBUtil::checkString($var, True);
        $this->location = $var;

        return $this;
    }

    /**
     * Required. The free text search query. This query can contain keywords which
     * could be related to any detail of the API-Hub resources such display names,
     * descriptions, attributes etc.
     *
     * Generated from protobuf field <code>string query = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getQuery()
    {
        return $this->query;
    }

    /**
     * Required. The free text search query. This query can contain keywords which
     * could be related to any detail of the API-Hub resources such display names,
     * descriptions, attributes etc.
     *
     * Generated from protobuf field <code>string query = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setQuery($var)
    {
        GPBUtil::checkString($var, True);
        $this->query = $var;

        return $this;
    }

    /**
     * Optional. An expression that filters the list of search results.
     * A filter expression consists of a field name, a comparison operator,
     * and a value for filtering. The value must be a string, a number, or a
     * boolean. The comparison operator must be `=`. Filters are not case
     * sensitive.
     * The following field names are eligible for filtering:
     *    * `resource_type` - The type of resource in the search results.
     *    Must be one of the following: `Api`, `ApiOperation`, `Deployment`,
     *    `Definition`, `Spec` or `Version`. This field can only be specified once
     *    in the filter.
     * Here are is an example:
     *   * `resource_type = Api` - The resource_type is _Api_.
     *
     * Generated from protobuf field <code>string filter = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getFilter()
    {
        return $this->filter;
    }

    /**
     * Optional. An expression that filters the list of search results.
     * A filter expression consists of a field name, a comparison operator,
     * and a value for filtering. The value must be a string, a number, or a
     * boolean. The comparison operator must be `=`. Filters are not case
     * sensitive.
     * The following field names are eligible for filtering:
     *    * `resource_type` - The type of resource in the search results.
     *    Must be one of the following: `Api`, `ApiOperation`, `Deployment`,
     *    `Definition`, `Spec` or `Version`. This field can only be specified once
     *    in the filter.
     * Here are is an example:
     *   * `resource_type = Api` - The resource_type is _Api_.
     *
     * Generated from protobuf field <code>string filter = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setFilter($var)
    {
        GPBUtil::checkString($var, True);
        $this->filter = $var;

        return $this;
    }

    /**
     * Optional. The maximum number of search results to return. The service may
     * return fewer than this value. If unspecified at most 10 search results will
     * be returned. If value is negative then `INVALID_ARGUMENT` error is
     * returned. The maximum value is 25; values above 25 will be coerced to 25.
     * While paginating, you can specify a new page size parameter for each page
     * of search results to be listed.
     *
     * Generated from protobuf field <code>int32 page_size = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return int
     */
    public function getPageSize()
    {
        return $this->page_size;
    }

    /**
     * Optional. The maximum number of search results to return. The service may
     * return fewer than this value. If unspecified at most 10 search results will
     * be returned. If value is negative then `INVALID_ARGUMENT` error is
     * returned. The maximum value is 25; values above 25 will be coerced to 25.
     * While paginating, you can specify a new page size parameter for each page
     * of search results to be listed.
     *
     * Generated from protobuf field <code>int32 page_size = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param int $var
     * @return $this
     */
    public function setPageSize($var)
    {
        GPBUtil::checkInt32($var);
        $this->page_size = $var;

        return $this;
    }

    /**
     * Optional. A page token, received from a previous
     * [SearchResources][SearchResources]
     * call. Specify this parameter to retrieve the next page of transactions.
     * When paginating, you must specify the `page_token` parameter and all the
     * other parameters except
     * [page_size][google.cloud.apihub.v1.SearchResourcesRequest.page_size]
     * should be specified with the same value which was used in the previous
     * call. If the other fields are set with a different value than the previous
     * call then `INVALID_ARGUMENT` error is returned.
     *
     * Generated from protobuf field <code>string page_token = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getPageToken()
    {
        return $this->page_token;
    }

    /**
     * Optional. A page token, received from a previous
     * [SearchResources][SearchResources]
     * call. Specify this parameter to retrieve the next page of transactions.
     * When paginating, you must specify the `page_token` parameter and all the
     * other parameters except
     * [page_size][google.cloud.apihub.v1.SearchResourcesRequest.page_size]
     * should be specified with the same value which was used in the previous
     * call. If the other fields are set with a different value than the previous
     * call then `INVALID_ARGUMENT` error is returned.
     *
     * Generated from protobuf field <code>string page_token = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setPageToken($var)
    {
        GPBUtil::checkString($var, True);
        $this->page_token = $var;

        return $this;
    }

}

