<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/talent/v4beta1/job_service.proto

namespace Google\Cloud\Talent\V4beta1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * The Request body of the `SearchJobs` call.
 *
 * Generated from protobuf message <code>google.cloud.talent.v4beta1.SearchJobsRequest</code>
 */
class SearchJobsRequest extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. The resource name of the tenant to search within.
     * The format is "projects/{project_id}/tenants/{tenant_id}". For example,
     * "projects/foo/tenant/bar". If tenant id is unspecified, a default tenant
     * is created. For example, "projects/foo".
     *
     * Generated from protobuf field <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     */
    private $parent = '';
    /**
     * Mode of a search.
     * Defaults to [SearchMode.JOB_SEARCH][google.cloud.talent.v4beta1.SearchJobsRequest.SearchMode.JOB_SEARCH].
     *
     * Generated from protobuf field <code>.google.cloud.talent.v4beta1.SearchJobsRequest.SearchMode search_mode = 2;</code>
     */
    private $search_mode = 0;
    /**
     * Required. The meta information collected about the job searcher, used to improve the
     * search quality of the service. The identifiers (such as `user_id`) are
     * provided by users, and must be unique and consistent.
     *
     * Generated from protobuf field <code>.google.cloud.talent.v4beta1.RequestMetadata request_metadata = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    private $request_metadata = null;
    /**
     * Query used to search against jobs, such as keyword, location filters, etc.
     *
     * Generated from protobuf field <code>.google.cloud.talent.v4beta1.JobQuery job_query = 4;</code>
     */
    private $job_query = null;
    /**
     * Controls whether to broaden the search when it produces sparse results.
     * Broadened queries append results to the end of the matching results
     * list.
     * Defaults to false.
     *
     * Generated from protobuf field <code>bool enable_broadening = 5;</code>
     */
    private $enable_broadening = false;
    /**
     * This field is deprecated.
     *
     * Generated from protobuf field <code>bool require_precise_result_size = 6 [deprecated = true];</code>
     * @deprecated
     */
    protected $require_precise_result_size = false;
    /**
     * An expression specifies a histogram request against matching jobs.
     * Expression syntax is an aggregation function call with histogram facets and
     * other options.
     * Available aggregation function calls are:
     * * `count(string_histogram_facet)`: Count the number of matching entities,
     * for each distinct attribute value.
     * * `count(numeric_histogram_facet, list of buckets)`: Count the number of
     * matching entities within each bucket.
     * A maximum of 200 histogram buckets are supported.
     * Data types:
     * * Histogram facet: facet names with format `[a-zA-Z][a-zA-Z0-9_]+`.
     * * String: string like "any string with backslash escape for quote(\")."
     * * Number: whole number and floating point number like 10, -1 and -0.01.
     * * List: list of elements with comma(,) separator surrounded by square
     * brackets, for example, [1, 2, 3] and ["one", "two", "three"].
     * Built-in constants:
     * * MIN (minimum number similar to java Double.MIN_VALUE)
     * * MAX (maximum number similar to java Double.MAX_VALUE)
     * Built-in functions:
     * * bucket(start, end[, label]): bucket built-in function creates a bucket
     * with range of [start, end). Note that the end is exclusive, for example,
     * bucket(1, MAX, "positive number") or bucket(1, 10).
     * Job histogram facets:
     * * company_display_name: histogram by [Job.company_display_name][google.cloud.talent.v4beta1.Job.company_display_name].
     * * employment_type: histogram by [Job.employment_types][google.cloud.talent.v4beta1.Job.employment_types], for example,
     *   "FULL_TIME", "PART_TIME".
     * * company_size: histogram by [CompanySize][google.cloud.talent.v4beta1.CompanySize], for example, "SMALL",
     * "MEDIUM", "BIG".
     * * publish_time_in_day: histogram by the [Job.posting_publish_time][google.cloud.talent.v4beta1.Job.posting_publish_time]
     *   in days.
     *   Must specify list of numeric buckets in spec.
     * * publish_time_in_month: histogram by the [Job.posting_publish_time][google.cloud.talent.v4beta1.Job.posting_publish_time]
     *   in months.
     *   Must specify list of numeric buckets in spec.
     * * publish_time_in_year: histogram by the [Job.posting_publish_time][google.cloud.talent.v4beta1.Job.posting_publish_time]
     *   in years.
     *   Must specify list of numeric buckets in spec.
     * * degree_types: histogram by the [Job.degree_types][google.cloud.talent.v4beta1.Job.degree_types], for example,
     *   "Bachelors", "Masters".
     * * job_level: histogram by the [Job.job_level][google.cloud.talent.v4beta1.Job.job_level], for example, "Entry
     *   Level".
     * * country: histogram by the country code of jobs, for example, "US", "FR".
     * * admin1: histogram by the admin1 code of jobs, which is a global
     *   placeholder referring to the state, province, or the particular term a
     *   country uses to define the geographic structure below the country level,
     *   for example, "CA", "IL".
     * * city: histogram by a combination of the "city name, admin1 code". For
     *   example,  "Mountain View, CA", "New York, NY".
     * * admin1_country: histogram by a combination of the "admin1 code, country",
     *   for example, "CA, US", "IL, US".
     * * city_coordinate: histogram by the city center's GPS coordinates (latitude
     *   and longitude), for example, 37.4038522,-122.0987765. Since the
     *   coordinates of a city center can change, customers may need to refresh
     *   them periodically.
     * * locale: histogram by the [Job.language_code][google.cloud.talent.v4beta1.Job.language_code], for example, "en-US",
     *   "fr-FR".
     * * language: histogram by the language subtag of the [Job.language_code][google.cloud.talent.v4beta1.Job.language_code],
     *   for example, "en", "fr".
     * * category: histogram by the [JobCategory][google.cloud.talent.v4beta1.JobCategory], for example,
     *   "COMPUTER_AND_IT", "HEALTHCARE".
     * * base_compensation_unit: histogram by the
     *   [CompensationInfo.CompensationUnit][google.cloud.talent.v4beta1.CompensationInfo.CompensationUnit] of base
     *   salary, for example, "WEEKLY", "MONTHLY".
     * * base_compensation: histogram by the base salary. Must specify list of
     *   numeric buckets to group results by.
     * * annualized_base_compensation: histogram by the base annualized salary.
     *   Must specify list of numeric buckets to group results by.
     * * annualized_total_compensation: histogram by the total annualized salary.
     *   Must specify list of numeric buckets to group results by.
     * * string_custom_attribute: histogram by string [Job.custom_attributes][google.cloud.talent.v4beta1.Job.custom_attributes].
     *   Values can be accessed via square bracket notations like
     *   string_custom_attribute["key1"].
     * * numeric_custom_attribute: histogram by numeric [Job.custom_attributes][google.cloud.talent.v4beta1.Job.custom_attributes].
     *   Values can be accessed via square bracket notations like
     *   numeric_custom_attribute["key1"]. Must specify list of numeric buckets to
     *   group results by.
     * Example expressions:
     * * `count(admin1)`
     * * `count(base_compensation, [bucket(1000, 10000), bucket(10000, 100000),
     * bucket(100000, MAX)])`
     * * `count(string_custom_attribute["some-string-custom-attribute"])`
     * * `count(numeric_custom_attribute["some-numeric-custom-attribute"],
     *   [bucket(MIN, 0, "negative"), bucket(0, MAX, "non-negative")])`
     *
     * Generated from protobuf field <code>repeated .google.cloud.talent.v4beta1.HistogramQuery histogram_queries = 7;</code>
     */
    private $histogram_queries;
    /**
     * The desired job attributes returned for jobs in the search response.
     * Defaults to [JobView.JOB_VIEW_SMALL][google.cloud.talent.v4beta1.JobView.JOB_VIEW_SMALL] if no value is specified.
     *
     * Generated from protobuf field <code>.google.cloud.talent.v4beta1.JobView job_view = 8;</code>
     */
    private $job_view = 0;
    /**
     * An integer that specifies the current offset (that is, starting result
     * location, amongst the jobs deemed by the API as relevant) in search
     * results. This field is only considered if [page_token][google.cloud.talent.v4beta1.SearchJobsRequest.page_token] is unset.
     * The maximum allowed value is 5000. Otherwise an error is thrown.
     * For example, 0 means to  return results starting from the first matching
     * job, and 10 means to return from the 11th job. This can be used for
     * pagination, (for example, pageSize = 10 and offset = 10 means to return
     * from the second page).
     *
     * Generated from protobuf field <code>int32 offset = 9;</code>
     */
    private $offset = 0;
    /**
     * A limit on the number of jobs returned in the search results.
     * Increasing this value above the default value of 10 can increase search
     * response time. The value can be between 1 and 100.
     *
     * Generated from protobuf field <code>int32 page_size = 10;</code>
     */
    private $page_size = 0;
    /**
     * The token specifying the current offset within
     * search results. See [SearchJobsResponse.next_page_token][google.cloud.talent.v4beta1.SearchJobsResponse.next_page_token] for
     * an explanation of how to obtain the next set of query results.
     *
     * Generated from protobuf field <code>string page_token = 11;</code>
     */
    private $page_token = '';
    /**
     * The criteria determining how search results are sorted. Default is
     * `"relevance desc"`.
     * Supported options are:
     * * `"relevance desc"`: By relevance descending, as determined by the API
     *   algorithms. Relevance thresholding of query results is only available
     *   with this ordering.
     * * `"posting_publish_time desc"`: By [Job.posting_publish_time][google.cloud.talent.v4beta1.Job.posting_publish_time]
     *   descending.
     * * `"posting_update_time desc"`: By [Job.posting_update_time][google.cloud.talent.v4beta1.Job.posting_update_time]
     *   descending.
     * * `"title"`: By [Job.title][google.cloud.talent.v4beta1.Job.title] ascending.
     * * `"title desc"`: By [Job.title][google.cloud.talent.v4beta1.Job.title] descending.
     * * `"annualized_base_compensation"`: By job's
     *   [CompensationInfo.annualized_base_compensation_range][google.cloud.talent.v4beta1.CompensationInfo.annualized_base_compensation_range] ascending. Jobs
     *   whose annualized base compensation is unspecified are put at the end of
     *   search results.
     * * `"annualized_base_compensation desc"`: By job's
     *   [CompensationInfo.annualized_base_compensation_range][google.cloud.talent.v4beta1.CompensationInfo.annualized_base_compensation_range] descending. Jobs
     *   whose annualized base compensation is unspecified are put at the end of
     *   search results.
     * * `"annualized_total_compensation"`: By job's
     *   [CompensationInfo.annualized_total_compensation_range][google.cloud.talent.v4beta1.CompensationInfo.annualized_total_compensation_range] ascending. Jobs
     *   whose annualized base compensation is unspecified are put at the end of
     *   search results.
     * * `"annualized_total_compensation desc"`: By job's
     *   [CompensationInfo.annualized_total_compensation_range][google.cloud.talent.v4beta1.CompensationInfo.annualized_total_compensation_range] descending. Jobs
     *   whose annualized base compensation is unspecified are put at the end of
     *   search results.
     * * `"custom_ranking desc"`: By the relevance score adjusted to the
     *   [SearchJobsRequest.CustomRankingInfo.ranking_expression][google.cloud.talent.v4beta1.SearchJobsRequest.CustomRankingInfo.ranking_expression] with weight
     *   factor assigned by
     *   [SearchJobsRequest.CustomRankingInfo.importance_level][google.cloud.talent.v4beta1.SearchJobsRequest.CustomRankingInfo.importance_level] in descending
     *   order.
     * * Location sorting: Use the special syntax to order jobs by distance:<br>
     *   `"distance_from('Hawaii')"`: Order by distance from Hawaii.<br>
     *   `"distance_from(19.89, 155.5)"`: Order by distance from a coordinate.<br>
     *   `"distance_from('Hawaii'), distance_from('Puerto Rico')"`: Order by
     *   multiple locations. See details below.<br>
     *   `"distance_from('Hawaii'), distance_from(19.89, 155.5)"`: Order by
     *   multiple locations. See details below.<br>
     *   The string can have a maximum of 256 characters. When multiple distance
     *   centers are provided, a job that is close to any of the distance centers
     *   would have a high rank. When a job has multiple locations, the job
     *   location closest to one of the distance centers will be used. Jobs that
     *   don't have locations will be ranked at the bottom. Distance is calculated
     *   with a precision of 11.3 meters (37.4 feet). Diversification strategy is
     *   still applied unless explicitly disabled in
     *   [diversification_level][google.cloud.talent.v4beta1.SearchJobsRequest.diversification_level].
     *
     * Generated from protobuf field <code>string order_by = 12;</code>
     */
    private $order_by = '';
    /**
     * Controls whether highly similar jobs are returned next to each other in
     * the search results. Jobs are identified as highly similar based on
     * their titles, job categories, and locations. Highly similar results are
     * clustered so that only one representative job of the cluster is
     * displayed to the job seeker higher up in the results, with the other jobs
     * being displayed lower down in the results.
     * Defaults to [DiversificationLevel.SIMPLE][google.cloud.talent.v4beta1.SearchJobsRequest.DiversificationLevel.SIMPLE] if no value
     * is specified.
     *
     * Generated from protobuf field <code>.google.cloud.talent.v4beta1.SearchJobsRequest.DiversificationLevel diversification_level = 13;</code>
     */
    private $diversification_level = 0;
    /**
     * Controls over how job documents get ranked on top of existing relevance
     * score (determined by API algorithm).
     *
     * Generated from protobuf field <code>.google.cloud.talent.v4beta1.SearchJobsRequest.CustomRankingInfo custom_ranking_info = 14;</code>
     */
    private $custom_ranking_info = null;
    /**
     * This field is deprecated. Please use
     * [SearchJobsRequest.keyword_match_mode][google.cloud.talent.v4beta1.SearchJobsRequest.keyword_match_mode] going forward.
     * To migrate, disable_keyword_match set to false maps to
     * [KeywordMatchMode.KEYWORD_MATCH_ALL][google.cloud.talent.v4beta1.SearchJobsRequest.KeywordMatchMode.KEYWORD_MATCH_ALL], and disable_keyword_match set to
     * true maps to [KeywordMatchMode.KEYWORD_MATCH_DISABLED][google.cloud.talent.v4beta1.SearchJobsRequest.KeywordMatchMode.KEYWORD_MATCH_DISABLED]. If
     * [SearchJobsRequest.keyword_match_mode][google.cloud.talent.v4beta1.SearchJobsRequest.keyword_match_mode] is set, this field is ignored.
     * Controls whether to disable exact keyword match on [Job.title][google.cloud.talent.v4beta1.Job.title],
     * [Job.description][google.cloud.talent.v4beta1.Job.description], [Job.company_display_name][google.cloud.talent.v4beta1.Job.company_display_name], [Job.addresses][google.cloud.talent.v4beta1.Job.addresses],
     * [Job.qualifications][google.cloud.talent.v4beta1.Job.qualifications]. When disable keyword match is turned off, a
     * keyword match returns jobs that do not match given category filters when
     * there are matching keywords. For example, for the query "program manager,"
     * a result is returned even if the job posting has the title "software
     * developer," which doesn't fall into "program manager" ontology, but does
     * have "program manager" appearing in its description.
     * For queries like "cloud" that don't contain title or
     * location specific ontology, jobs with "cloud" keyword matches are returned
     * regardless of this flag's value.
     * Use [Company.keyword_searchable_job_custom_attributes][google.cloud.talent.v4beta1.Company.keyword_searchable_job_custom_attributes] if
     * company-specific globally matched custom field/attribute string values are
     * needed. Enabling keyword match improves recall of subsequent search
     * requests.
     * Defaults to false.
     *
     * Generated from protobuf field <code>bool disable_keyword_match = 16;</code>
     */
    private $disable_keyword_match = false;
    /**
     * Controls what keyword match options to use.
     * Defaults to [KeywordMatchMode.KEYWORD_MATCH_ALL][google.cloud.talent.v4beta1.SearchJobsRequest.KeywordMatchMode.KEYWORD_MATCH_ALL] if no value
     * is specified.
     *
     * Generated from protobuf field <code>.google.cloud.talent.v4beta1.SearchJobsRequest.KeywordMatchMode keyword_match_mode = 18;</code>
     */
    private $keyword_match_mode = 0;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $parent
     *           Required. The resource name of the tenant to search within.
     *           The format is "projects/{project_id}/tenants/{tenant_id}". For example,
     *           "projects/foo/tenant/bar". If tenant id is unspecified, a default tenant
     *           is created. For example, "projects/foo".
     *     @type int $search_mode
     *           Mode of a search.
     *           Defaults to [SearchMode.JOB_SEARCH][google.cloud.talent.v4beta1.SearchJobsRequest.SearchMode.JOB_SEARCH].
     *     @type \Google\Cloud\Talent\V4beta1\RequestMetadata $request_metadata
     *           Required. The meta information collected about the job searcher, used to improve the
     *           search quality of the service. The identifiers (such as `user_id`) are
     *           provided by users, and must be unique and consistent.
     *     @type \Google\Cloud\Talent\V4beta1\JobQuery $job_query
     *           Query used to search against jobs, such as keyword, location filters, etc.
     *     @type bool $enable_broadening
     *           Controls whether to broaden the search when it produces sparse results.
     *           Broadened queries append results to the end of the matching results
     *           list.
     *           Defaults to false.
     *     @type bool $require_precise_result_size
     *           This field is deprecated.
     *     @type array<\Google\Cloud\Talent\V4beta1\HistogramQuery>|\Google\Protobuf\Internal\RepeatedField $histogram_queries
     *           An expression specifies a histogram request against matching jobs.
     *           Expression syntax is an aggregation function call with histogram facets and
     *           other options.
     *           Available aggregation function calls are:
     *           * `count(string_histogram_facet)`: Count the number of matching entities,
     *           for each distinct attribute value.
     *           * `count(numeric_histogram_facet, list of buckets)`: Count the number of
     *           matching entities within each bucket.
     *           A maximum of 200 histogram buckets are supported.
     *           Data types:
     *           * Histogram facet: facet names with format `[a-zA-Z][a-zA-Z0-9_]+`.
     *           * String: string like "any string with backslash escape for quote(\")."
     *           * Number: whole number and floating point number like 10, -1 and -0.01.
     *           * List: list of elements with comma(,) separator surrounded by square
     *           brackets, for example, [1, 2, 3] and ["one", "two", "three"].
     *           Built-in constants:
     *           * MIN (minimum number similar to java Double.MIN_VALUE)
     *           * MAX (maximum number similar to java Double.MAX_VALUE)
     *           Built-in functions:
     *           * bucket(start, end[, label]): bucket built-in function creates a bucket
     *           with range of [start, end). Note that the end is exclusive, for example,
     *           bucket(1, MAX, "positive number") or bucket(1, 10).
     *           Job histogram facets:
     *           * company_display_name: histogram by [Job.company_display_name][google.cloud.talent.v4beta1.Job.company_display_name].
     *           * employment_type: histogram by [Job.employment_types][google.cloud.talent.v4beta1.Job.employment_types], for example,
     *             "FULL_TIME", "PART_TIME".
     *           * company_size: histogram by [CompanySize][google.cloud.talent.v4beta1.CompanySize], for example, "SMALL",
     *           "MEDIUM", "BIG".
     *           * publish_time_in_day: histogram by the [Job.posting_publish_time][google.cloud.talent.v4beta1.Job.posting_publish_time]
     *             in days.
     *             Must specify list of numeric buckets in spec.
     *           * publish_time_in_month: histogram by the [Job.posting_publish_time][google.cloud.talent.v4beta1.Job.posting_publish_time]
     *             in months.
     *             Must specify list of numeric buckets in spec.
     *           * publish_time_in_year: histogram by the [Job.posting_publish_time][google.cloud.talent.v4beta1.Job.posting_publish_time]
     *             in years.
     *             Must specify list of numeric buckets in spec.
     *           * degree_types: histogram by the [Job.degree_types][google.cloud.talent.v4beta1.Job.degree_types], for example,
     *             "Bachelors", "Masters".
     *           * job_level: histogram by the [Job.job_level][google.cloud.talent.v4beta1.Job.job_level], for example, "Entry
     *             Level".
     *           * country: histogram by the country code of jobs, for example, "US", "FR".
     *           * admin1: histogram by the admin1 code of jobs, which is a global
     *             placeholder referring to the state, province, or the particular term a
     *             country uses to define the geographic structure below the country level,
     *             for example, "CA", "IL".
     *           * city: histogram by a combination of the "city name, admin1 code". For
     *             example,  "Mountain View, CA", "New York, NY".
     *           * admin1_country: histogram by a combination of the "admin1 code, country",
     *             for example, "CA, US", "IL, US".
     *           * city_coordinate: histogram by the city center's GPS coordinates (latitude
     *             and longitude), for example, 37.4038522,-122.0987765. Since the
     *             coordinates of a city center can change, customers may need to refresh
     *             them periodically.
     *           * locale: histogram by the [Job.language_code][google.cloud.talent.v4beta1.Job.language_code], for example, "en-US",
     *             "fr-FR".
     *           * language: histogram by the language subtag of the [Job.language_code][google.cloud.talent.v4beta1.Job.language_code],
     *             for example, "en", "fr".
     *           * category: histogram by the [JobCategory][google.cloud.talent.v4beta1.JobCategory], for example,
     *             "COMPUTER_AND_IT", "HEALTHCARE".
     *           * base_compensation_unit: histogram by the
     *             [CompensationInfo.CompensationUnit][google.cloud.talent.v4beta1.CompensationInfo.CompensationUnit] of base
     *             salary, for example, "WEEKLY", "MONTHLY".
     *           * base_compensation: histogram by the base salary. Must specify list of
     *             numeric buckets to group results by.
     *           * annualized_base_compensation: histogram by the base annualized salary.
     *             Must specify list of numeric buckets to group results by.
     *           * annualized_total_compensation: histogram by the total annualized salary.
     *             Must specify list of numeric buckets to group results by.
     *           * string_custom_attribute: histogram by string [Job.custom_attributes][google.cloud.talent.v4beta1.Job.custom_attributes].
     *             Values can be accessed via square bracket notations like
     *             string_custom_attribute["key1"].
     *           * numeric_custom_attribute: histogram by numeric [Job.custom_attributes][google.cloud.talent.v4beta1.Job.custom_attributes].
     *             Values can be accessed via square bracket notations like
     *             numeric_custom_attribute["key1"]. Must specify list of numeric buckets to
     *             group results by.
     *           Example expressions:
     *           * `count(admin1)`
     *           * `count(base_compensation, [bucket(1000, 10000), bucket(10000, 100000),
     *           bucket(100000, MAX)])`
     *           * `count(string_custom_attribute["some-string-custom-attribute"])`
     *           * `count(numeric_custom_attribute["some-numeric-custom-attribute"],
     *             [bucket(MIN, 0, "negative"), bucket(0, MAX, "non-negative")])`
     *     @type int $job_view
     *           The desired job attributes returned for jobs in the search response.
     *           Defaults to [JobView.JOB_VIEW_SMALL][google.cloud.talent.v4beta1.JobView.JOB_VIEW_SMALL] if no value is specified.
     *     @type int $offset
     *           An integer that specifies the current offset (that is, starting result
     *           location, amongst the jobs deemed by the API as relevant) in search
     *           results. This field is only considered if [page_token][google.cloud.talent.v4beta1.SearchJobsRequest.page_token] is unset.
     *           The maximum allowed value is 5000. Otherwise an error is thrown.
     *           For example, 0 means to  return results starting from the first matching
     *           job, and 10 means to return from the 11th job. This can be used for
     *           pagination, (for example, pageSize = 10 and offset = 10 means to return
     *           from the second page).
     *     @type int $page_size
     *           A limit on the number of jobs returned in the search results.
     *           Increasing this value above the default value of 10 can increase search
     *           response time. The value can be between 1 and 100.
     *     @type string $page_token
     *           The token specifying the current offset within
     *           search results. See [SearchJobsResponse.next_page_token][google.cloud.talent.v4beta1.SearchJobsResponse.next_page_token] for
     *           an explanation of how to obtain the next set of query results.
     *     @type string $order_by
     *           The criteria determining how search results are sorted. Default is
     *           `"relevance desc"`.
     *           Supported options are:
     *           * `"relevance desc"`: By relevance descending, as determined by the API
     *             algorithms. Relevance thresholding of query results is only available
     *             with this ordering.
     *           * `"posting_publish_time desc"`: By [Job.posting_publish_time][google.cloud.talent.v4beta1.Job.posting_publish_time]
     *             descending.
     *           * `"posting_update_time desc"`: By [Job.posting_update_time][google.cloud.talent.v4beta1.Job.posting_update_time]
     *             descending.
     *           * `"title"`: By [Job.title][google.cloud.talent.v4beta1.Job.title] ascending.
     *           * `"title desc"`: By [Job.title][google.cloud.talent.v4beta1.Job.title] descending.
     *           * `"annualized_base_compensation"`: By job's
     *             [CompensationInfo.annualized_base_compensation_range][google.cloud.talent.v4beta1.CompensationInfo.annualized_base_compensation_range] ascending. Jobs
     *             whose annualized base compensation is unspecified are put at the end of
     *             search results.
     *           * `"annualized_base_compensation desc"`: By job's
     *             [CompensationInfo.annualized_base_compensation_range][google.cloud.talent.v4beta1.CompensationInfo.annualized_base_compensation_range] descending. Jobs
     *             whose annualized base compensation is unspecified are put at the end of
     *             search results.
     *           * `"annualized_total_compensation"`: By job's
     *             [CompensationInfo.annualized_total_compensation_range][google.cloud.talent.v4beta1.CompensationInfo.annualized_total_compensation_range] ascending. Jobs
     *             whose annualized base compensation is unspecified are put at the end of
     *             search results.
     *           * `"annualized_total_compensation desc"`: By job's
     *             [CompensationInfo.annualized_total_compensation_range][google.cloud.talent.v4beta1.CompensationInfo.annualized_total_compensation_range] descending. Jobs
     *             whose annualized base compensation is unspecified are put at the end of
     *             search results.
     *           * `"custom_ranking desc"`: By the relevance score adjusted to the
     *             [SearchJobsRequest.CustomRankingInfo.ranking_expression][google.cloud.talent.v4beta1.SearchJobsRequest.CustomRankingInfo.ranking_expression] with weight
     *             factor assigned by
     *             [SearchJobsRequest.CustomRankingInfo.importance_level][google.cloud.talent.v4beta1.SearchJobsRequest.CustomRankingInfo.importance_level] in descending
     *             order.
     *           * Location sorting: Use the special syntax to order jobs by distance:<br>
     *             `"distance_from('Hawaii')"`: Order by distance from Hawaii.<br>
     *             `"distance_from(19.89, 155.5)"`: Order by distance from a coordinate.<br>
     *             `"distance_from('Hawaii'), distance_from('Puerto Rico')"`: Order by
     *             multiple locations. See details below.<br>
     *             `"distance_from('Hawaii'), distance_from(19.89, 155.5)"`: Order by
     *             multiple locations. See details below.<br>
     *             The string can have a maximum of 256 characters. When multiple distance
     *             centers are provided, a job that is close to any of the distance centers
     *             would have a high rank. When a job has multiple locations, the job
     *             location closest to one of the distance centers will be used. Jobs that
     *             don't have locations will be ranked at the bottom. Distance is calculated
     *             with a precision of 11.3 meters (37.4 feet). Diversification strategy is
     *             still applied unless explicitly disabled in
     *             [diversification_level][google.cloud.talent.v4beta1.SearchJobsRequest.diversification_level].
     *     @type int $diversification_level
     *           Controls whether highly similar jobs are returned next to each other in
     *           the search results. Jobs are identified as highly similar based on
     *           their titles, job categories, and locations. Highly similar results are
     *           clustered so that only one representative job of the cluster is
     *           displayed to the job seeker higher up in the results, with the other jobs
     *           being displayed lower down in the results.
     *           Defaults to [DiversificationLevel.SIMPLE][google.cloud.talent.v4beta1.SearchJobsRequest.DiversificationLevel.SIMPLE] if no value
     *           is specified.
     *     @type \Google\Cloud\Talent\V4beta1\SearchJobsRequest\CustomRankingInfo $custom_ranking_info
     *           Controls over how job documents get ranked on top of existing relevance
     *           score (determined by API algorithm).
     *     @type bool $disable_keyword_match
     *           This field is deprecated. Please use
     *           [SearchJobsRequest.keyword_match_mode][google.cloud.talent.v4beta1.SearchJobsRequest.keyword_match_mode] going forward.
     *           To migrate, disable_keyword_match set to false maps to
     *           [KeywordMatchMode.KEYWORD_MATCH_ALL][google.cloud.talent.v4beta1.SearchJobsRequest.KeywordMatchMode.KEYWORD_MATCH_ALL], and disable_keyword_match set to
     *           true maps to [KeywordMatchMode.KEYWORD_MATCH_DISABLED][google.cloud.talent.v4beta1.SearchJobsRequest.KeywordMatchMode.KEYWORD_MATCH_DISABLED]. If
     *           [SearchJobsRequest.keyword_match_mode][google.cloud.talent.v4beta1.SearchJobsRequest.keyword_match_mode] is set, this field is ignored.
     *           Controls whether to disable exact keyword match on [Job.title][google.cloud.talent.v4beta1.Job.title],
     *           [Job.description][google.cloud.talent.v4beta1.Job.description], [Job.company_display_name][google.cloud.talent.v4beta1.Job.company_display_name], [Job.addresses][google.cloud.talent.v4beta1.Job.addresses],
     *           [Job.qualifications][google.cloud.talent.v4beta1.Job.qualifications]. When disable keyword match is turned off, a
     *           keyword match returns jobs that do not match given category filters when
     *           there are matching keywords. For example, for the query "program manager,"
     *           a result is returned even if the job posting has the title "software
     *           developer," which doesn't fall into "program manager" ontology, but does
     *           have "program manager" appearing in its description.
     *           For queries like "cloud" that don't contain title or
     *           location specific ontology, jobs with "cloud" keyword matches are returned
     *           regardless of this flag's value.
     *           Use [Company.keyword_searchable_job_custom_attributes][google.cloud.talent.v4beta1.Company.keyword_searchable_job_custom_attributes] if
     *           company-specific globally matched custom field/attribute string values are
     *           needed. Enabling keyword match improves recall of subsequent search
     *           requests.
     *           Defaults to false.
     *     @type int $keyword_match_mode
     *           Controls what keyword match options to use.
     *           Defaults to [KeywordMatchMode.KEYWORD_MATCH_ALL][google.cloud.talent.v4beta1.SearchJobsRequest.KeywordMatchMode.KEYWORD_MATCH_ALL] if no value
     *           is specified.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Talent\V4Beta1\JobService::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. The resource name of the tenant to search within.
     * The format is "projects/{project_id}/tenants/{tenant_id}". For example,
     * "projects/foo/tenant/bar". If tenant id is unspecified, a default tenant
     * is created. For example, "projects/foo".
     *
     * Generated from protobuf field <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getParent()
    {
        return $this->parent;
    }

    /**
     * Required. The resource name of the tenant to search within.
     * The format is "projects/{project_id}/tenants/{tenant_id}". For example,
     * "projects/foo/tenant/bar". If tenant id is unspecified, a default tenant
     * is created. For example, "projects/foo".
     *
     * Generated from protobuf field <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setParent($var)
    {
        GPBUtil::checkString($var, True);
        $this->parent = $var;

        return $this;
    }

    /**
     * Mode of a search.
     * Defaults to [SearchMode.JOB_SEARCH][google.cloud.talent.v4beta1.SearchJobsRequest.SearchMode.JOB_SEARCH].
     *
     * Generated from protobuf field <code>.google.cloud.talent.v4beta1.SearchJobsRequest.SearchMode search_mode = 2;</code>
     * @return int
     */
    public function getSearchMode()
    {
        return $this->search_mode;
    }

    /**
     * Mode of a search.
     * Defaults to [SearchMode.JOB_SEARCH][google.cloud.talent.v4beta1.SearchJobsRequest.SearchMode.JOB_SEARCH].
     *
     * Generated from protobuf field <code>.google.cloud.talent.v4beta1.SearchJobsRequest.SearchMode search_mode = 2;</code>
     * @param int $var
     * @return $this
     */
    public function setSearchMode($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Talent\V4beta1\SearchJobsRequest\SearchMode::class);
        $this->search_mode = $var;

        return $this;
    }

    /**
     * Required. The meta information collected about the job searcher, used to improve the
     * search quality of the service. The identifiers (such as `user_id`) are
     * provided by users, and must be unique and consistent.
     *
     * Generated from protobuf field <code>.google.cloud.talent.v4beta1.RequestMetadata request_metadata = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return \Google\Cloud\Talent\V4beta1\RequestMetadata|null
     */
    public function getRequestMetadata()
    {
        return $this->request_metadata;
    }

    public function hasRequestMetadata()
    {
        return isset($this->request_metadata);
    }

    public function clearRequestMetadata()
    {
        unset($this->request_metadata);
    }

    /**
     * Required. The meta information collected about the job searcher, used to improve the
     * search quality of the service. The identifiers (such as `user_id`) are
     * provided by users, and must be unique and consistent.
     *
     * Generated from protobuf field <code>.google.cloud.talent.v4beta1.RequestMetadata request_metadata = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param \Google\Cloud\Talent\V4beta1\RequestMetadata $var
     * @return $this
     */
    public function setRequestMetadata($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Talent\V4beta1\RequestMetadata::class);
        $this->request_metadata = $var;

        return $this;
    }

    /**
     * Query used to search against jobs, such as keyword, location filters, etc.
     *
     * Generated from protobuf field <code>.google.cloud.talent.v4beta1.JobQuery job_query = 4;</code>
     * @return \Google\Cloud\Talent\V4beta1\JobQuery|null
     */
    public function getJobQuery()
    {
        return $this->job_query;
    }

    public function hasJobQuery()
    {
        return isset($this->job_query);
    }

    public function clearJobQuery()
    {
        unset($this->job_query);
    }

    /**
     * Query used to search against jobs, such as keyword, location filters, etc.
     *
     * Generated from protobuf field <code>.google.cloud.talent.v4beta1.JobQuery job_query = 4;</code>
     * @param \Google\Cloud\Talent\V4beta1\JobQuery $var
     * @return $this
     */
    public function setJobQuery($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Talent\V4beta1\JobQuery::class);
        $this->job_query = $var;

        return $this;
    }

    /**
     * Controls whether to broaden the search when it produces sparse results.
     * Broadened queries append results to the end of the matching results
     * list.
     * Defaults to false.
     *
     * Generated from protobuf field <code>bool enable_broadening = 5;</code>
     * @return bool
     */
    public function getEnableBroadening()
    {
        return $this->enable_broadening;
    }

    /**
     * Controls whether to broaden the search when it produces sparse results.
     * Broadened queries append results to the end of the matching results
     * list.
     * Defaults to false.
     *
     * Generated from protobuf field <code>bool enable_broadening = 5;</code>
     * @param bool $var
     * @return $this
     */
    public function setEnableBroadening($var)
    {
        GPBUtil::checkBool($var);
        $this->enable_broadening = $var;

        return $this;
    }

    /**
     * This field is deprecated.
     *
     * Generated from protobuf field <code>bool require_precise_result_size = 6 [deprecated = true];</code>
     * @return bool
     * @deprecated
     */
    public function getRequirePreciseResultSize()
    {
        @trigger_error('require_precise_result_size is deprecated.', E_USER_DEPRECATED);
        return $this->require_precise_result_size;
    }

    /**
     * This field is deprecated.
     *
     * Generated from protobuf field <code>bool require_precise_result_size = 6 [deprecated = true];</code>
     * @param bool $var
     * @return $this
     * @deprecated
     */
    public function setRequirePreciseResultSize($var)
    {
        @trigger_error('require_precise_result_size is deprecated.', E_USER_DEPRECATED);
        GPBUtil::checkBool($var);
        $this->require_precise_result_size = $var;

        return $this;
    }

    /**
     * An expression specifies a histogram request against matching jobs.
     * Expression syntax is an aggregation function call with histogram facets and
     * other options.
     * Available aggregation function calls are:
     * * `count(string_histogram_facet)`: Count the number of matching entities,
     * for each distinct attribute value.
     * * `count(numeric_histogram_facet, list of buckets)`: Count the number of
     * matching entities within each bucket.
     * A maximum of 200 histogram buckets are supported.
     * Data types:
     * * Histogram facet: facet names with format `[a-zA-Z][a-zA-Z0-9_]+`.
     * * String: string like "any string with backslash escape for quote(\")."
     * * Number: whole number and floating point number like 10, -1 and -0.01.
     * * List: list of elements with comma(,) separator surrounded by square
     * brackets, for example, [1, 2, 3] and ["one", "two", "three"].
     * Built-in constants:
     * * MIN (minimum number similar to java Double.MIN_VALUE)
     * * MAX (maximum number similar to java Double.MAX_VALUE)
     * Built-in functions:
     * * bucket(start, end[, label]): bucket built-in function creates a bucket
     * with range of [start, end). Note that the end is exclusive, for example,
     * bucket(1, MAX, "positive number") or bucket(1, 10).
     * Job histogram facets:
     * * company_display_name: histogram by [Job.company_display_name][google.cloud.talent.v4beta1.Job.company_display_name].
     * * employment_type: histogram by [Job.employment_types][google.cloud.talent.v4beta1.Job.employment_types], for example,
     *   "FULL_TIME", "PART_TIME".
     * * company_size: histogram by [CompanySize][google.cloud.talent.v4beta1.CompanySize], for example, "SMALL",
     * "MEDIUM", "BIG".
     * * publish_time_in_day: histogram by the [Job.posting_publish_time][google.cloud.talent.v4beta1.Job.posting_publish_time]
     *   in days.
     *   Must specify list of numeric buckets in spec.
     * * publish_time_in_month: histogram by the [Job.posting_publish_time][google.cloud.talent.v4beta1.Job.posting_publish_time]
     *   in months.
     *   Must specify list of numeric buckets in spec.
     * * publish_time_in_year: histogram by the [Job.posting_publish_time][google.cloud.talent.v4beta1.Job.posting_publish_time]
     *   in years.
     *   Must specify list of numeric buckets in spec.
     * * degree_types: histogram by the [Job.degree_types][google.cloud.talent.v4beta1.Job.degree_types], for example,
     *   "Bachelors", "Masters".
     * * job_level: histogram by the [Job.job_level][google.cloud.talent.v4beta1.Job.job_level], for example, "Entry
     *   Level".
     * * country: histogram by the country code of jobs, for example, "US", "FR".
     * * admin1: histogram by the admin1 code of jobs, which is a global
     *   placeholder referring to the state, province, or the particular term a
     *   country uses to define the geographic structure below the country level,
     *   for example, "CA", "IL".
     * * city: histogram by a combination of the "city name, admin1 code". For
     *   example,  "Mountain View, CA", "New York, NY".
     * * admin1_country: histogram by a combination of the "admin1 code, country",
     *   for example, "CA, US", "IL, US".
     * * city_coordinate: histogram by the city center's GPS coordinates (latitude
     *   and longitude), for example, 37.4038522,-122.0987765. Since the
     *   coordinates of a city center can change, customers may need to refresh
     *   them periodically.
     * * locale: histogram by the [Job.language_code][google.cloud.talent.v4beta1.Job.language_code], for example, "en-US",
     *   "fr-FR".
     * * language: histogram by the language subtag of the [Job.language_code][google.cloud.talent.v4beta1.Job.language_code],
     *   for example, "en", "fr".
     * * category: histogram by the [JobCategory][google.cloud.talent.v4beta1.JobCategory], for example,
     *   "COMPUTER_AND_IT", "HEALTHCARE".
     * * base_compensation_unit: histogram by the
     *   [CompensationInfo.CompensationUnit][google.cloud.talent.v4beta1.CompensationInfo.CompensationUnit] of base
     *   salary, for example, "WEEKLY", "MONTHLY".
     * * base_compensation: histogram by the base salary. Must specify list of
     *   numeric buckets to group results by.
     * * annualized_base_compensation: histogram by the base annualized salary.
     *   Must specify list of numeric buckets to group results by.
     * * annualized_total_compensation: histogram by the total annualized salary.
     *   Must specify list of numeric buckets to group results by.
     * * string_custom_attribute: histogram by string [Job.custom_attributes][google.cloud.talent.v4beta1.Job.custom_attributes].
     *   Values can be accessed via square bracket notations like
     *   string_custom_attribute["key1"].
     * * numeric_custom_attribute: histogram by numeric [Job.custom_attributes][google.cloud.talent.v4beta1.Job.custom_attributes].
     *   Values can be accessed via square bracket notations like
     *   numeric_custom_attribute["key1"]. Must specify list of numeric buckets to
     *   group results by.
     * Example expressions:
     * * `count(admin1)`
     * * `count(base_compensation, [bucket(1000, 10000), bucket(10000, 100000),
     * bucket(100000, MAX)])`
     * * `count(string_custom_attribute["some-string-custom-attribute"])`
     * * `count(numeric_custom_attribute["some-numeric-custom-attribute"],
     *   [bucket(MIN, 0, "negative"), bucket(0, MAX, "non-negative")])`
     *
     * Generated from protobuf field <code>repeated .google.cloud.talent.v4beta1.HistogramQuery histogram_queries = 7;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getHistogramQueries()
    {
        return $this->histogram_queries;
    }

    /**
     * An expression specifies a histogram request against matching jobs.
     * Expression syntax is an aggregation function call with histogram facets and
     * other options.
     * Available aggregation function calls are:
     * * `count(string_histogram_facet)`: Count the number of matching entities,
     * for each distinct attribute value.
     * * `count(numeric_histogram_facet, list of buckets)`: Count the number of
     * matching entities within each bucket.
     * A maximum of 200 histogram buckets are supported.
     * Data types:
     * * Histogram facet: facet names with format `[a-zA-Z][a-zA-Z0-9_]+`.
     * * String: string like "any string with backslash escape for quote(\")."
     * * Number: whole number and floating point number like 10, -1 and -0.01.
     * * List: list of elements with comma(,) separator surrounded by square
     * brackets, for example, [1, 2, 3] and ["one", "two", "three"].
     * Built-in constants:
     * * MIN (minimum number similar to java Double.MIN_VALUE)
     * * MAX (maximum number similar to java Double.MAX_VALUE)
     * Built-in functions:
     * * bucket(start, end[, label]): bucket built-in function creates a bucket
     * with range of [start, end). Note that the end is exclusive, for example,
     * bucket(1, MAX, "positive number") or bucket(1, 10).
     * Job histogram facets:
     * * company_display_name: histogram by [Job.company_display_name][google.cloud.talent.v4beta1.Job.company_display_name].
     * * employment_type: histogram by [Job.employment_types][google.cloud.talent.v4beta1.Job.employment_types], for example,
     *   "FULL_TIME", "PART_TIME".
     * * company_size: histogram by [CompanySize][google.cloud.talent.v4beta1.CompanySize], for example, "SMALL",
     * "MEDIUM", "BIG".
     * * publish_time_in_day: histogram by the [Job.posting_publish_time][google.cloud.talent.v4beta1.Job.posting_publish_time]
     *   in days.
     *   Must specify list of numeric buckets in spec.
     * * publish_time_in_month: histogram by the [Job.posting_publish_time][google.cloud.talent.v4beta1.Job.posting_publish_time]
     *   in months.
     *   Must specify list of numeric buckets in spec.
     * * publish_time_in_year: histogram by the [Job.posting_publish_time][google.cloud.talent.v4beta1.Job.posting_publish_time]
     *   in years.
     *   Must specify list of numeric buckets in spec.
     * * degree_types: histogram by the [Job.degree_types][google.cloud.talent.v4beta1.Job.degree_types], for example,
     *   "Bachelors", "Masters".
     * * job_level: histogram by the [Job.job_level][google.cloud.talent.v4beta1.Job.job_level], for example, "Entry
     *   Level".
     * * country: histogram by the country code of jobs, for example, "US", "FR".
     * * admin1: histogram by the admin1 code of jobs, which is a global
     *   placeholder referring to the state, province, or the particular term a
     *   country uses to define the geographic structure below the country level,
     *   for example, "CA", "IL".
     * * city: histogram by a combination of the "city name, admin1 code". For
     *   example,  "Mountain View, CA", "New York, NY".
     * * admin1_country: histogram by a combination of the "admin1 code, country",
     *   for example, "CA, US", "IL, US".
     * * city_coordinate: histogram by the city center's GPS coordinates (latitude
     *   and longitude), for example, 37.4038522,-122.0987765. Since the
     *   coordinates of a city center can change, customers may need to refresh
     *   them periodically.
     * * locale: histogram by the [Job.language_code][google.cloud.talent.v4beta1.Job.language_code], for example, "en-US",
     *   "fr-FR".
     * * language: histogram by the language subtag of the [Job.language_code][google.cloud.talent.v4beta1.Job.language_code],
     *   for example, "en", "fr".
     * * category: histogram by the [JobCategory][google.cloud.talent.v4beta1.JobCategory], for example,
     *   "COMPUTER_AND_IT", "HEALTHCARE".
     * * base_compensation_unit: histogram by the
     *   [CompensationInfo.CompensationUnit][google.cloud.talent.v4beta1.CompensationInfo.CompensationUnit] of base
     *   salary, for example, "WEEKLY", "MONTHLY".
     * * base_compensation: histogram by the base salary. Must specify list of
     *   numeric buckets to group results by.
     * * annualized_base_compensation: histogram by the base annualized salary.
     *   Must specify list of numeric buckets to group results by.
     * * annualized_total_compensation: histogram by the total annualized salary.
     *   Must specify list of numeric buckets to group results by.
     * * string_custom_attribute: histogram by string [Job.custom_attributes][google.cloud.talent.v4beta1.Job.custom_attributes].
     *   Values can be accessed via square bracket notations like
     *   string_custom_attribute["key1"].
     * * numeric_custom_attribute: histogram by numeric [Job.custom_attributes][google.cloud.talent.v4beta1.Job.custom_attributes].
     *   Values can be accessed via square bracket notations like
     *   numeric_custom_attribute["key1"]. Must specify list of numeric buckets to
     *   group results by.
     * Example expressions:
     * * `count(admin1)`
     * * `count(base_compensation, [bucket(1000, 10000), bucket(10000, 100000),
     * bucket(100000, MAX)])`
     * * `count(string_custom_attribute["some-string-custom-attribute"])`
     * * `count(numeric_custom_attribute["some-numeric-custom-attribute"],
     *   [bucket(MIN, 0, "negative"), bucket(0, MAX, "non-negative")])`
     *
     * Generated from protobuf field <code>repeated .google.cloud.talent.v4beta1.HistogramQuery histogram_queries = 7;</code>
     * @param array<\Google\Cloud\Talent\V4beta1\HistogramQuery>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setHistogramQueries($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Talent\V4beta1\HistogramQuery::class);
        $this->histogram_queries = $arr;

        return $this;
    }

    /**
     * The desired job attributes returned for jobs in the search response.
     * Defaults to [JobView.JOB_VIEW_SMALL][google.cloud.talent.v4beta1.JobView.JOB_VIEW_SMALL] if no value is specified.
     *
     * Generated from protobuf field <code>.google.cloud.talent.v4beta1.JobView job_view = 8;</code>
     * @return int
     */
    public function getJobView()
    {
        return $this->job_view;
    }

    /**
     * The desired job attributes returned for jobs in the search response.
     * Defaults to [JobView.JOB_VIEW_SMALL][google.cloud.talent.v4beta1.JobView.JOB_VIEW_SMALL] if no value is specified.
     *
     * Generated from protobuf field <code>.google.cloud.talent.v4beta1.JobView job_view = 8;</code>
     * @param int $var
     * @return $this
     */
    public function setJobView($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Talent\V4beta1\JobView::class);
        $this->job_view = $var;

        return $this;
    }

    /**
     * An integer that specifies the current offset (that is, starting result
     * location, amongst the jobs deemed by the API as relevant) in search
     * results. This field is only considered if [page_token][google.cloud.talent.v4beta1.SearchJobsRequest.page_token] is unset.
     * The maximum allowed value is 5000. Otherwise an error is thrown.
     * For example, 0 means to  return results starting from the first matching
     * job, and 10 means to return from the 11th job. This can be used for
     * pagination, (for example, pageSize = 10 and offset = 10 means to return
     * from the second page).
     *
     * Generated from protobuf field <code>int32 offset = 9;</code>
     * @return int
     */
    public function getOffset()
    {
        return $this->offset;
    }

    /**
     * An integer that specifies the current offset (that is, starting result
     * location, amongst the jobs deemed by the API as relevant) in search
     * results. This field is only considered if [page_token][google.cloud.talent.v4beta1.SearchJobsRequest.page_token] is unset.
     * The maximum allowed value is 5000. Otherwise an error is thrown.
     * For example, 0 means to  return results starting from the first matching
     * job, and 10 means to return from the 11th job. This can be used for
     * pagination, (for example, pageSize = 10 and offset = 10 means to return
     * from the second page).
     *
     * Generated from protobuf field <code>int32 offset = 9;</code>
     * @param int $var
     * @return $this
     */
    public function setOffset($var)
    {
        GPBUtil::checkInt32($var);
        $this->offset = $var;

        return $this;
    }

    /**
     * A limit on the number of jobs returned in the search results.
     * Increasing this value above the default value of 10 can increase search
     * response time. The value can be between 1 and 100.
     *
     * Generated from protobuf field <code>int32 page_size = 10;</code>
     * @return int
     */
    public function getPageSize()
    {
        return $this->page_size;
    }

    /**
     * A limit on the number of jobs returned in the search results.
     * Increasing this value above the default value of 10 can increase search
     * response time. The value can be between 1 and 100.
     *
     * Generated from protobuf field <code>int32 page_size = 10;</code>
     * @param int $var
     * @return $this
     */
    public function setPageSize($var)
    {
        GPBUtil::checkInt32($var);
        $this->page_size = $var;

        return $this;
    }

    /**
     * The token specifying the current offset within
     * search results. See [SearchJobsResponse.next_page_token][google.cloud.talent.v4beta1.SearchJobsResponse.next_page_token] for
     * an explanation of how to obtain the next set of query results.
     *
     * Generated from protobuf field <code>string page_token = 11;</code>
     * @return string
     */
    public function getPageToken()
    {
        return $this->page_token;
    }

    /**
     * The token specifying the current offset within
     * search results. See [SearchJobsResponse.next_page_token][google.cloud.talent.v4beta1.SearchJobsResponse.next_page_token] for
     * an explanation of how to obtain the next set of query results.
     *
     * Generated from protobuf field <code>string page_token = 11;</code>
     * @param string $var
     * @return $this
     */
    public function setPageToken($var)
    {
        GPBUtil::checkString($var, True);
        $this->page_token = $var;

        return $this;
    }

    /**
     * The criteria determining how search results are sorted. Default is
     * `"relevance desc"`.
     * Supported options are:
     * * `"relevance desc"`: By relevance descending, as determined by the API
     *   algorithms. Relevance thresholding of query results is only available
     *   with this ordering.
     * * `"posting_publish_time desc"`: By [Job.posting_publish_time][google.cloud.talent.v4beta1.Job.posting_publish_time]
     *   descending.
     * * `"posting_update_time desc"`: By [Job.posting_update_time][google.cloud.talent.v4beta1.Job.posting_update_time]
     *   descending.
     * * `"title"`: By [Job.title][google.cloud.talent.v4beta1.Job.title] ascending.
     * * `"title desc"`: By [Job.title][google.cloud.talent.v4beta1.Job.title] descending.
     * * `"annualized_base_compensation"`: By job's
     *   [CompensationInfo.annualized_base_compensation_range][google.cloud.talent.v4beta1.CompensationInfo.annualized_base_compensation_range] ascending. Jobs
     *   whose annualized base compensation is unspecified are put at the end of
     *   search results.
     * * `"annualized_base_compensation desc"`: By job's
     *   [CompensationInfo.annualized_base_compensation_range][google.cloud.talent.v4beta1.CompensationInfo.annualized_base_compensation_range] descending. Jobs
     *   whose annualized base compensation is unspecified are put at the end of
     *   search results.
     * * `"annualized_total_compensation"`: By job's
     *   [CompensationInfo.annualized_total_compensation_range][google.cloud.talent.v4beta1.CompensationInfo.annualized_total_compensation_range] ascending. Jobs
     *   whose annualized base compensation is unspecified are put at the end of
     *   search results.
     * * `"annualized_total_compensation desc"`: By job's
     *   [CompensationInfo.annualized_total_compensation_range][google.cloud.talent.v4beta1.CompensationInfo.annualized_total_compensation_range] descending. Jobs
     *   whose annualized base compensation is unspecified are put at the end of
     *   search results.
     * * `"custom_ranking desc"`: By the relevance score adjusted to the
     *   [SearchJobsRequest.CustomRankingInfo.ranking_expression][google.cloud.talent.v4beta1.SearchJobsRequest.CustomRankingInfo.ranking_expression] with weight
     *   factor assigned by
     *   [SearchJobsRequest.CustomRankingInfo.importance_level][google.cloud.talent.v4beta1.SearchJobsRequest.CustomRankingInfo.importance_level] in descending
     *   order.
     * * Location sorting: Use the special syntax to order jobs by distance:<br>
     *   `"distance_from('Hawaii')"`: Order by distance from Hawaii.<br>
     *   `"distance_from(19.89, 155.5)"`: Order by distance from a coordinate.<br>
     *   `"distance_from('Hawaii'), distance_from('Puerto Rico')"`: Order by
     *   multiple locations. See details below.<br>
     *   `"distance_from('Hawaii'), distance_from(19.89, 155.5)"`: Order by
     *   multiple locations. See details below.<br>
     *   The string can have a maximum of 256 characters. When multiple distance
     *   centers are provided, a job that is close to any of the distance centers
     *   would have a high rank. When a job has multiple locations, the job
     *   location closest to one of the distance centers will be used. Jobs that
     *   don't have locations will be ranked at the bottom. Distance is calculated
     *   with a precision of 11.3 meters (37.4 feet). Diversification strategy is
     *   still applied unless explicitly disabled in
     *   [diversification_level][google.cloud.talent.v4beta1.SearchJobsRequest.diversification_level].
     *
     * Generated from protobuf field <code>string order_by = 12;</code>
     * @return string
     */
    public function getOrderBy()
    {
        return $this->order_by;
    }

    /**
     * The criteria determining how search results are sorted. Default is
     * `"relevance desc"`.
     * Supported options are:
     * * `"relevance desc"`: By relevance descending, as determined by the API
     *   algorithms. Relevance thresholding of query results is only available
     *   with this ordering.
     * * `"posting_publish_time desc"`: By [Job.posting_publish_time][google.cloud.talent.v4beta1.Job.posting_publish_time]
     *   descending.
     * * `"posting_update_time desc"`: By [Job.posting_update_time][google.cloud.talent.v4beta1.Job.posting_update_time]
     *   descending.
     * * `"title"`: By [Job.title][google.cloud.talent.v4beta1.Job.title] ascending.
     * * `"title desc"`: By [Job.title][google.cloud.talent.v4beta1.Job.title] descending.
     * * `"annualized_base_compensation"`: By job's
     *   [CompensationInfo.annualized_base_compensation_range][google.cloud.talent.v4beta1.CompensationInfo.annualized_base_compensation_range] ascending. Jobs
     *   whose annualized base compensation is unspecified are put at the end of
     *   search results.
     * * `"annualized_base_compensation desc"`: By job's
     *   [CompensationInfo.annualized_base_compensation_range][google.cloud.talent.v4beta1.CompensationInfo.annualized_base_compensation_range] descending. Jobs
     *   whose annualized base compensation is unspecified are put at the end of
     *   search results.
     * * `"annualized_total_compensation"`: By job's
     *   [CompensationInfo.annualized_total_compensation_range][google.cloud.talent.v4beta1.CompensationInfo.annualized_total_compensation_range] ascending. Jobs
     *   whose annualized base compensation is unspecified are put at the end of
     *   search results.
     * * `"annualized_total_compensation desc"`: By job's
     *   [CompensationInfo.annualized_total_compensation_range][google.cloud.talent.v4beta1.CompensationInfo.annualized_total_compensation_range] descending. Jobs
     *   whose annualized base compensation is unspecified are put at the end of
     *   search results.
     * * `"custom_ranking desc"`: By the relevance score adjusted to the
     *   [SearchJobsRequest.CustomRankingInfo.ranking_expression][google.cloud.talent.v4beta1.SearchJobsRequest.CustomRankingInfo.ranking_expression] with weight
     *   factor assigned by
     *   [SearchJobsRequest.CustomRankingInfo.importance_level][google.cloud.talent.v4beta1.SearchJobsRequest.CustomRankingInfo.importance_level] in descending
     *   order.
     * * Location sorting: Use the special syntax to order jobs by distance:<br>
     *   `"distance_from('Hawaii')"`: Order by distance from Hawaii.<br>
     *   `"distance_from(19.89, 155.5)"`: Order by distance from a coordinate.<br>
     *   `"distance_from('Hawaii'), distance_from('Puerto Rico')"`: Order by
     *   multiple locations. See details below.<br>
     *   `"distance_from('Hawaii'), distance_from(19.89, 155.5)"`: Order by
     *   multiple locations. See details below.<br>
     *   The string can have a maximum of 256 characters. When multiple distance
     *   centers are provided, a job that is close to any of the distance centers
     *   would have a high rank. When a job has multiple locations, the job
     *   location closest to one of the distance centers will be used. Jobs that
     *   don't have locations will be ranked at the bottom. Distance is calculated
     *   with a precision of 11.3 meters (37.4 feet). Diversification strategy is
     *   still applied unless explicitly disabled in
     *   [diversification_level][google.cloud.talent.v4beta1.SearchJobsRequest.diversification_level].
     *
     * Generated from protobuf field <code>string order_by = 12;</code>
     * @param string $var
     * @return $this
     */
    public function setOrderBy($var)
    {
        GPBUtil::checkString($var, True);
        $this->order_by = $var;

        return $this;
    }

    /**
     * Controls whether highly similar jobs are returned next to each other in
     * the search results. Jobs are identified as highly similar based on
     * their titles, job categories, and locations. Highly similar results are
     * clustered so that only one representative job of the cluster is
     * displayed to the job seeker higher up in the results, with the other jobs
     * being displayed lower down in the results.
     * Defaults to [DiversificationLevel.SIMPLE][google.cloud.talent.v4beta1.SearchJobsRequest.DiversificationLevel.SIMPLE] if no value
     * is specified.
     *
     * Generated from protobuf field <code>.google.cloud.talent.v4beta1.SearchJobsRequest.DiversificationLevel diversification_level = 13;</code>
     * @return int
     */
    public function getDiversificationLevel()
    {
        return $this->diversification_level;
    }

    /**
     * Controls whether highly similar jobs are returned next to each other in
     * the search results. Jobs are identified as highly similar based on
     * their titles, job categories, and locations. Highly similar results are
     * clustered so that only one representative job of the cluster is
     * displayed to the job seeker higher up in the results, with the other jobs
     * being displayed lower down in the results.
     * Defaults to [DiversificationLevel.SIMPLE][google.cloud.talent.v4beta1.SearchJobsRequest.DiversificationLevel.SIMPLE] if no value
     * is specified.
     *
     * Generated from protobuf field <code>.google.cloud.talent.v4beta1.SearchJobsRequest.DiversificationLevel diversification_level = 13;</code>
     * @param int $var
     * @return $this
     */
    public function setDiversificationLevel($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Talent\V4beta1\SearchJobsRequest\DiversificationLevel::class);
        $this->diversification_level = $var;

        return $this;
    }

    /**
     * Controls over how job documents get ranked on top of existing relevance
     * score (determined by API algorithm).
     *
     * Generated from protobuf field <code>.google.cloud.talent.v4beta1.SearchJobsRequest.CustomRankingInfo custom_ranking_info = 14;</code>
     * @return \Google\Cloud\Talent\V4beta1\SearchJobsRequest\CustomRankingInfo|null
     */
    public function getCustomRankingInfo()
    {
        return $this->custom_ranking_info;
    }

    public function hasCustomRankingInfo()
    {
        return isset($this->custom_ranking_info);
    }

    public function clearCustomRankingInfo()
    {
        unset($this->custom_ranking_info);
    }

    /**
     * Controls over how job documents get ranked on top of existing relevance
     * score (determined by API algorithm).
     *
     * Generated from protobuf field <code>.google.cloud.talent.v4beta1.SearchJobsRequest.CustomRankingInfo custom_ranking_info = 14;</code>
     * @param \Google\Cloud\Talent\V4beta1\SearchJobsRequest\CustomRankingInfo $var
     * @return $this
     */
    public function setCustomRankingInfo($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Talent\V4beta1\SearchJobsRequest\CustomRankingInfo::class);
        $this->custom_ranking_info = $var;

        return $this;
    }

    /**
     * This field is deprecated. Please use
     * [SearchJobsRequest.keyword_match_mode][google.cloud.talent.v4beta1.SearchJobsRequest.keyword_match_mode] going forward.
     * To migrate, disable_keyword_match set to false maps to
     * [KeywordMatchMode.KEYWORD_MATCH_ALL][google.cloud.talent.v4beta1.SearchJobsRequest.KeywordMatchMode.KEYWORD_MATCH_ALL], and disable_keyword_match set to
     * true maps to [KeywordMatchMode.KEYWORD_MATCH_DISABLED][google.cloud.talent.v4beta1.SearchJobsRequest.KeywordMatchMode.KEYWORD_MATCH_DISABLED]. If
     * [SearchJobsRequest.keyword_match_mode][google.cloud.talent.v4beta1.SearchJobsRequest.keyword_match_mode] is set, this field is ignored.
     * Controls whether to disable exact keyword match on [Job.title][google.cloud.talent.v4beta1.Job.title],
     * [Job.description][google.cloud.talent.v4beta1.Job.description], [Job.company_display_name][google.cloud.talent.v4beta1.Job.company_display_name], [Job.addresses][google.cloud.talent.v4beta1.Job.addresses],
     * [Job.qualifications][google.cloud.talent.v4beta1.Job.qualifications]. When disable keyword match is turned off, a
     * keyword match returns jobs that do not match given category filters when
     * there are matching keywords. For example, for the query "program manager,"
     * a result is returned even if the job posting has the title "software
     * developer," which doesn't fall into "program manager" ontology, but does
     * have "program manager" appearing in its description.
     * For queries like "cloud" that don't contain title or
     * location specific ontology, jobs with "cloud" keyword matches are returned
     * regardless of this flag's value.
     * Use [Company.keyword_searchable_job_custom_attributes][google.cloud.talent.v4beta1.Company.keyword_searchable_job_custom_attributes] if
     * company-specific globally matched custom field/attribute string values are
     * needed. Enabling keyword match improves recall of subsequent search
     * requests.
     * Defaults to false.
     *
     * Generated from protobuf field <code>bool disable_keyword_match = 16;</code>
     * @return bool
     */
    public function getDisableKeywordMatch()
    {
        return $this->disable_keyword_match;
    }

    /**
     * This field is deprecated. Please use
     * [SearchJobsRequest.keyword_match_mode][google.cloud.talent.v4beta1.SearchJobsRequest.keyword_match_mode] going forward.
     * To migrate, disable_keyword_match set to false maps to
     * [KeywordMatchMode.KEYWORD_MATCH_ALL][google.cloud.talent.v4beta1.SearchJobsRequest.KeywordMatchMode.KEYWORD_MATCH_ALL], and disable_keyword_match set to
     * true maps to [KeywordMatchMode.KEYWORD_MATCH_DISABLED][google.cloud.talent.v4beta1.SearchJobsRequest.KeywordMatchMode.KEYWORD_MATCH_DISABLED]. If
     * [SearchJobsRequest.keyword_match_mode][google.cloud.talent.v4beta1.SearchJobsRequest.keyword_match_mode] is set, this field is ignored.
     * Controls whether to disable exact keyword match on [Job.title][google.cloud.talent.v4beta1.Job.title],
     * [Job.description][google.cloud.talent.v4beta1.Job.description], [Job.company_display_name][google.cloud.talent.v4beta1.Job.company_display_name], [Job.addresses][google.cloud.talent.v4beta1.Job.addresses],
     * [Job.qualifications][google.cloud.talent.v4beta1.Job.qualifications]. When disable keyword match is turned off, a
     * keyword match returns jobs that do not match given category filters when
     * there are matching keywords. For example, for the query "program manager,"
     * a result is returned even if the job posting has the title "software
     * developer," which doesn't fall into "program manager" ontology, but does
     * have "program manager" appearing in its description.
     * For queries like "cloud" that don't contain title or
     * location specific ontology, jobs with "cloud" keyword matches are returned
     * regardless of this flag's value.
     * Use [Company.keyword_searchable_job_custom_attributes][google.cloud.talent.v4beta1.Company.keyword_searchable_job_custom_attributes] if
     * company-specific globally matched custom field/attribute string values are
     * needed. Enabling keyword match improves recall of subsequent search
     * requests.
     * Defaults to false.
     *
     * Generated from protobuf field <code>bool disable_keyword_match = 16;</code>
     * @param bool $var
     * @return $this
     */
    public function setDisableKeywordMatch($var)
    {
        GPBUtil::checkBool($var);
        $this->disable_keyword_match = $var;

        return $this;
    }

    /**
     * Controls what keyword match options to use.
     * Defaults to [KeywordMatchMode.KEYWORD_MATCH_ALL][google.cloud.talent.v4beta1.SearchJobsRequest.KeywordMatchMode.KEYWORD_MATCH_ALL] if no value
     * is specified.
     *
     * Generated from protobuf field <code>.google.cloud.talent.v4beta1.SearchJobsRequest.KeywordMatchMode keyword_match_mode = 18;</code>
     * @return int
     */
    public function getKeywordMatchMode()
    {
        return $this->keyword_match_mode;
    }

    /**
     * Controls what keyword match options to use.
     * Defaults to [KeywordMatchMode.KEYWORD_MATCH_ALL][google.cloud.talent.v4beta1.SearchJobsRequest.KeywordMatchMode.KEYWORD_MATCH_ALL] if no value
     * is specified.
     *
     * Generated from protobuf field <code>.google.cloud.talent.v4beta1.SearchJobsRequest.KeywordMatchMode keyword_match_mode = 18;</code>
     * @param int $var
     * @return $this
     */
    public function setKeywordMatchMode($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Talent\V4beta1\SearchJobsRequest\KeywordMatchMode::class);
        $this->keyword_match_mode = $var;

        return $this;
    }

}

