<?php
/*
 * Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/accessapproval/v1/accessapproval.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\AccessApproval\V1\Gapic;

use Google\ApiCore\ApiException;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;

use Google\ApiCore\PathTemplate;
use Google\ApiCore\RequestParamsHeaderDescriptor;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\AccessApproval\V1\AccessApprovalServiceAccount;
use Google\Cloud\AccessApproval\V1\AccessApprovalSettings;
use Google\Cloud\AccessApproval\V1\ApprovalRequest;
use Google\Cloud\AccessApproval\V1\ApproveApprovalRequestMessage;
use Google\Cloud\AccessApproval\V1\DeleteAccessApprovalSettingsMessage;
use Google\Cloud\AccessApproval\V1\DismissApprovalRequestMessage;
use Google\Cloud\AccessApproval\V1\GetAccessApprovalServiceAccountMessage;
use Google\Cloud\AccessApproval\V1\GetAccessApprovalSettingsMessage;
use Google\Cloud\AccessApproval\V1\GetApprovalRequestMessage;
use Google\Cloud\AccessApproval\V1\InvalidateApprovalRequestMessage;
use Google\Cloud\AccessApproval\V1\ListApprovalRequestsMessage;
use Google\Cloud\AccessApproval\V1\ListApprovalRequestsResponse;
use Google\Cloud\AccessApproval\V1\UpdateAccessApprovalSettingsMessage;
use Google\Protobuf\FieldMask;
use Google\Protobuf\GPBEmpty;
use Google\Protobuf\Timestamp;

/**
 * Service Description: This API allows a customer to manage accesses to cloud resources by
 * Google personnel. It defines the following resource model:
 *
 * - The API has a collection of
 * [ApprovalRequest][google.cloud.accessapproval.v1.ApprovalRequest]
 * resources, named `approvalRequests/{approval_request}`
 * - The API has top-level settings per Project/Folder/Organization, named
 * `accessApprovalSettings`
 *
 * The service also periodically emails a list of recipients, defined at the
 * Project/Folder/Organization level in the accessApprovalSettings, when there
 * is a pending ApprovalRequest for them to act on. The ApprovalRequests can
 * also optionally be published to a Pub/Sub topic owned by the customer
 * (contact support if you would like to enable Pub/Sub notifications).
 *
 * ApprovalRequests can be approved or dismissed. Google personnel can only
 * access the indicated resource or resources if the request is approved
 * (subject to some exclusions:
 * https://cloud.google.com/access-approval/docs/overview#exclusions).
 *
 * Note: Using Access Approval functionality will mean that Google may not be
 * able to meet the SLAs for your chosen products, as any support response times
 * may be dramatically increased. As such the SLAs do not apply to any service
 * disruption to the extent impacted by Customer's use of Access Approval. Do
 * not enable Access Approval for projects where you may require high service
 * availability and rapid response by Google Cloud Support.
 *
 * After a request is approved or dismissed, no further action may be taken on
 * it. Requests with the requested_expiration in the past or with no activity
 * for 14 days are considered dismissed. When an approval expires, the request
 * is considered dismissed.
 *
 * If a request is not approved or dismissed, we call it pending.
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods. Sample code to get started:
 *
 * ```
 * $accessApprovalClient = new AccessApprovalClient();
 * try {
 *     $response = $accessApprovalClient->approveApprovalRequest();
 * } finally {
 *     $accessApprovalClient->close();
 * }
 * ```
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 */
class AccessApprovalGapicClient
{
    use GapicClientTrait;

    /**
     * The name of the service.
     */
    const SERVICE_NAME = 'google.cloud.accessapproval.v1.AccessApproval';

    /**
     * The default address of the service.
     */
    const SERVICE_ADDRESS = 'accessapproval.googleapis.com';

    /**
     * The default port of the service.
     */
    const DEFAULT_SERVICE_PORT = 443;

    /**
     * The name of the code generator, to be included in the agent header.
     */
    const CODEGEN_NAME = 'gapic';

    /**
     * The default scopes required by the service.
     */
    public static $serviceScopes = [
        'https://www.googleapis.com/auth/cloud-platform',
    ];

    private static $accessApprovalSettingsNameTemplate;

    private static $approvalRequestNameTemplate;

    private static $folderNameTemplate;

    private static $folderAccessApprovalSettingsNameTemplate;

    private static $folderApprovalRequestNameTemplate;

    private static $organizationNameTemplate;

    private static $organizationAccessApprovalSettingsNameTemplate;

    private static $organizationApprovalRequestNameTemplate;

    private static $projectNameTemplate;

    private static $projectAccessApprovalSettingsNameTemplate;

    private static $projectApprovalRequestNameTemplate;

    private static $pathTemplateMap;

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' => self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' => __DIR__ . '/../resources/access_approval_client_config.json',
            'descriptorsConfigPath' => __DIR__ . '/../resources/access_approval_descriptor_config.php',
            'gcpApiConfigPath' => __DIR__ . '/../resources/access_approval_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' => __DIR__ . '/../resources/access_approval_rest_client_config.php',
                ],
            ],
        ];
    }

    private static function getAccessApprovalSettingsNameTemplate()
    {
        if (self::$accessApprovalSettingsNameTemplate == null) {
            self::$accessApprovalSettingsNameTemplate = new PathTemplate('projects/{project}/accessApprovalSettings');
        }

        return self::$accessApprovalSettingsNameTemplate;
    }

    private static function getApprovalRequestNameTemplate()
    {
        if (self::$approvalRequestNameTemplate == null) {
            self::$approvalRequestNameTemplate = new PathTemplate('projects/{project}/approvalRequests/{approval_request}');
        }

        return self::$approvalRequestNameTemplate;
    }

    private static function getFolderNameTemplate()
    {
        if (self::$folderNameTemplate == null) {
            self::$folderNameTemplate = new PathTemplate('folders/{folder}');
        }

        return self::$folderNameTemplate;
    }

    private static function getFolderAccessApprovalSettingsNameTemplate()
    {
        if (self::$folderAccessApprovalSettingsNameTemplate == null) {
            self::$folderAccessApprovalSettingsNameTemplate = new PathTemplate('folders/{folder}/accessApprovalSettings');
        }

        return self::$folderAccessApprovalSettingsNameTemplate;
    }

    private static function getFolderApprovalRequestNameTemplate()
    {
        if (self::$folderApprovalRequestNameTemplate == null) {
            self::$folderApprovalRequestNameTemplate = new PathTemplate('folders/{folder}/approvalRequests/{approval_request}');
        }

        return self::$folderApprovalRequestNameTemplate;
    }

    private static function getOrganizationNameTemplate()
    {
        if (self::$organizationNameTemplate == null) {
            self::$organizationNameTemplate = new PathTemplate('organizations/{organization}');
        }

        return self::$organizationNameTemplate;
    }

    private static function getOrganizationAccessApprovalSettingsNameTemplate()
    {
        if (self::$organizationAccessApprovalSettingsNameTemplate == null) {
            self::$organizationAccessApprovalSettingsNameTemplate = new PathTemplate('organizations/{organization}/accessApprovalSettings');
        }

        return self::$organizationAccessApprovalSettingsNameTemplate;
    }

    private static function getOrganizationApprovalRequestNameTemplate()
    {
        if (self::$organizationApprovalRequestNameTemplate == null) {
            self::$organizationApprovalRequestNameTemplate = new PathTemplate('organizations/{organization}/approvalRequests/{approval_request}');
        }

        return self::$organizationApprovalRequestNameTemplate;
    }

    private static function getProjectNameTemplate()
    {
        if (self::$projectNameTemplate == null) {
            self::$projectNameTemplate = new PathTemplate('projects/{project}');
        }

        return self::$projectNameTemplate;
    }

    private static function getProjectAccessApprovalSettingsNameTemplate()
    {
        if (self::$projectAccessApprovalSettingsNameTemplate == null) {
            self::$projectAccessApprovalSettingsNameTemplate = new PathTemplate('projects/{project}/accessApprovalSettings');
        }

        return self::$projectAccessApprovalSettingsNameTemplate;
    }

    private static function getProjectApprovalRequestNameTemplate()
    {
        if (self::$projectApprovalRequestNameTemplate == null) {
            self::$projectApprovalRequestNameTemplate = new PathTemplate('projects/{project}/approvalRequests/{approval_request}');
        }

        return self::$projectApprovalRequestNameTemplate;
    }

    private static function getPathTemplateMap()
    {
        if (self::$pathTemplateMap == null) {
            self::$pathTemplateMap = [
                'accessApprovalSettings' => self::getAccessApprovalSettingsNameTemplate(),
                'approvalRequest' => self::getApprovalRequestNameTemplate(),
                'folder' => self::getFolderNameTemplate(),
                'folderAccessApprovalSettings' => self::getFolderAccessApprovalSettingsNameTemplate(),
                'folderApprovalRequest' => self::getFolderApprovalRequestNameTemplate(),
                'organization' => self::getOrganizationNameTemplate(),
                'organizationAccessApprovalSettings' => self::getOrganizationAccessApprovalSettingsNameTemplate(),
                'organizationApprovalRequest' => self::getOrganizationApprovalRequestNameTemplate(),
                'project' => self::getProjectNameTemplate(),
                'projectAccessApprovalSettings' => self::getProjectAccessApprovalSettingsNameTemplate(),
                'projectApprovalRequest' => self::getProjectApprovalRequestNameTemplate(),
            ];
        }

        return self::$pathTemplateMap;
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * access_approval_settings resource.
     *
     * @param string $project
     *
     * @return string The formatted access_approval_settings resource.
     */
    public static function accessApprovalSettingsName($project)
    {
        return self::getAccessApprovalSettingsNameTemplate()->render([
            'project' => $project,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * approval_request resource.
     *
     * @param string $project
     * @param string $approvalRequest
     *
     * @return string The formatted approval_request resource.
     */
    public static function approvalRequestName($project, $approvalRequest)
    {
        return self::getApprovalRequestNameTemplate()->render([
            'project' => $project,
            'approval_request' => $approvalRequest,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a folder
     * resource.
     *
     * @param string $folder
     *
     * @return string The formatted folder resource.
     */
    public static function folderName($folder)
    {
        return self::getFolderNameTemplate()->render([
            'folder' => $folder,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * folder_accessApprovalSettings resource.
     *
     * @param string $folder
     *
     * @return string The formatted folder_accessApprovalSettings resource.
     */
    public static function folderAccessApprovalSettingsName($folder)
    {
        return self::getFolderAccessApprovalSettingsNameTemplate()->render([
            'folder' => $folder,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * folder_approval_request resource.
     *
     * @param string $folder
     * @param string $approvalRequest
     *
     * @return string The formatted folder_approval_request resource.
     */
    public static function folderApprovalRequestName($folder, $approvalRequest)
    {
        return self::getFolderApprovalRequestNameTemplate()->render([
            'folder' => $folder,
            'approval_request' => $approvalRequest,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a organization
     * resource.
     *
     * @param string $organization
     *
     * @return string The formatted organization resource.
     */
    public static function organizationName($organization)
    {
        return self::getOrganizationNameTemplate()->render([
            'organization' => $organization,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * organization_accessApprovalSettings resource.
     *
     * @param string $organization
     *
     * @return string The formatted organization_accessApprovalSettings resource.
     */
    public static function organizationAccessApprovalSettingsName($organization)
    {
        return self::getOrganizationAccessApprovalSettingsNameTemplate()->render([
            'organization' => $organization,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * organization_approval_request resource.
     *
     * @param string $organization
     * @param string $approvalRequest
     *
     * @return string The formatted organization_approval_request resource.
     */
    public static function organizationApprovalRequestName($organization, $approvalRequest)
    {
        return self::getOrganizationApprovalRequestNameTemplate()->render([
            'organization' => $organization,
            'approval_request' => $approvalRequest,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a project
     * resource.
     *
     * @param string $project
     *
     * @return string The formatted project resource.
     */
    public static function projectName($project)
    {
        return self::getProjectNameTemplate()->render([
            'project' => $project,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_accessApprovalSettings resource.
     *
     * @param string $project
     *
     * @return string The formatted project_accessApprovalSettings resource.
     */
    public static function projectAccessApprovalSettingsName($project)
    {
        return self::getProjectAccessApprovalSettingsNameTemplate()->render([
            'project' => $project,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_approval_request resource.
     *
     * @param string $project
     * @param string $approvalRequest
     *
     * @return string The formatted project_approval_request resource.
     */
    public static function projectApprovalRequestName($project, $approvalRequest)
    {
        return self::getProjectApprovalRequestNameTemplate()->render([
            'project' => $project,
            'approval_request' => $approvalRequest,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - accessApprovalSettings: projects/{project}/accessApprovalSettings
     * - approvalRequest: projects/{project}/approvalRequests/{approval_request}
     * - folder: folders/{folder}
     * - folderAccessApprovalSettings: folders/{folder}/accessApprovalSettings
     * - folderApprovalRequest: folders/{folder}/approvalRequests/{approval_request}
     * - organization: organizations/{organization}
     * - organizationAccessApprovalSettings: organizations/{organization}/accessApprovalSettings
     * - organizationApprovalRequest: organizations/{organization}/approvalRequests/{approval_request}
     * - project: projects/{project}
     * - projectAccessApprovalSettings: projects/{project}/accessApprovalSettings
     * - projectApprovalRequest: projects/{project}/approvalRequests/{approval_request}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string $formattedName The formatted name string
     * @param string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName($formattedName, $template = null)
    {
        $templateMap = self::getPathTemplateMap();
        if ($template) {
            if (!isset($templateMap[$template])) {
                throw new ValidationException("Template name $template does not exist");
            }

            return $templateMap[$template]->match($formattedName);
        }

        foreach ($templateMap as $templateName => $pathTemplate) {
            try {
                return $pathTemplate->match($formattedName);
            } catch (ValidationException $ex) {
                // Swallow the exception to continue trying other path templates
            }
        }

        throw new ValidationException("Input did not match any known format. Input: $formattedName");
    }

    /**
     * Constructor.
     *
     * @param array $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $serviceAddress
     *           **Deprecated**. This option will be removed in a future major release. Please
     *           utilize the `$apiEndpoint` option instead.
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'accessapproval.googleapis.com:443'.
     *     @type string|array|FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           The credentials to be used by the client to authorize API calls. This option
     *           accepts either a path to a credentials file, or a decoded credentials file as a
     *           PHP array.
     *           *Advanced usage*: In addition, this option can also accept a pre-constructed
     *           {@see \Google\Auth\FetchAuthTokenInterface} object or
     *           {@see \Google\ApiCore\CredentialsWrapper} object. Note that when one of these
     *           objects are provided, any settings in $credentialsConfig will be ignored.
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $serviceAddress setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
    }

    /**
     * Approves a request and returns the updated ApprovalRequest.
     *
     * Returns NOT_FOUND if the request does not exist. Returns
     * FAILED_PRECONDITION if the request exists but is not in a pending state.
     *
     * Sample code:
     * ```
     * $accessApprovalClient = new AccessApprovalClient();
     * try {
     *     $response = $accessApprovalClient->approveApprovalRequest();
     * } finally {
     *     $accessApprovalClient->close();
     * }
     * ```
     *
     * @param array $optionalArgs {
     *     Optional.
     *
     *     @type string $name
     *           Name of the approval request to approve.
     *     @type Timestamp $expireTime
     *           The expiration time of this approval.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\AccessApproval\V1\ApprovalRequest
     *
     * @throws ApiException if the remote call fails
     */
    public function approveApprovalRequest(array $optionalArgs = [])
    {
        $request = new ApproveApprovalRequestMessage();
        $requestParamHeaders = [];
        if (isset($optionalArgs['name'])) {
            $request->setName($optionalArgs['name']);
            $requestParamHeaders['name'] = $optionalArgs['name'];
        }

        if (isset($optionalArgs['expireTime'])) {
            $request->setExpireTime($optionalArgs['expireTime']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('ApproveApprovalRequest', ApprovalRequest::class, $optionalArgs, $request)->wait();
    }

    /**
     * Deletes the settings associated with a project, folder, or organization.
     * This will have the effect of disabling Access Approval for the project,
     * folder, or organization, but only if all ancestors also have Access
     * Approval disabled. If Access Approval is enabled at a higher level of the
     * hierarchy, then Access Approval will still be enabled at this level as
     * the settings are inherited.
     *
     * Sample code:
     * ```
     * $accessApprovalClient = new AccessApprovalClient();
     * try {
     *     $accessApprovalClient->deleteAccessApprovalSettings();
     * } finally {
     *     $accessApprovalClient->close();
     * }
     * ```
     *
     * @param array $optionalArgs {
     *     Optional.
     *
     *     @type string $name
     *           Name of the AccessApprovalSettings to delete.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteAccessApprovalSettings(array $optionalArgs = [])
    {
        $request = new DeleteAccessApprovalSettingsMessage();
        $requestParamHeaders = [];
        if (isset($optionalArgs['name'])) {
            $request->setName($optionalArgs['name']);
            $requestParamHeaders['name'] = $optionalArgs['name'];
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('DeleteAccessApprovalSettings', GPBEmpty::class, $optionalArgs, $request)->wait();
    }

    /**
     * Dismisses a request. Returns the updated ApprovalRequest.
     *
     * NOTE: This does not deny access to the resource if another request has been
     * made and approved. It is equivalent in effect to ignoring the request
     * altogether.
     *
     * Returns NOT_FOUND if the request does not exist.
     *
     * Returns FAILED_PRECONDITION if the request exists but is not in a pending
     * state.
     *
     * Sample code:
     * ```
     * $accessApprovalClient = new AccessApprovalClient();
     * try {
     *     $response = $accessApprovalClient->dismissApprovalRequest();
     * } finally {
     *     $accessApprovalClient->close();
     * }
     * ```
     *
     * @param array $optionalArgs {
     *     Optional.
     *
     *     @type string $name
     *           Name of the ApprovalRequest to dismiss.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\AccessApproval\V1\ApprovalRequest
     *
     * @throws ApiException if the remote call fails
     */
    public function dismissApprovalRequest(array $optionalArgs = [])
    {
        $request = new DismissApprovalRequestMessage();
        $requestParamHeaders = [];
        if (isset($optionalArgs['name'])) {
            $request->setName($optionalArgs['name']);
            $requestParamHeaders['name'] = $optionalArgs['name'];
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('DismissApprovalRequest', ApprovalRequest::class, $optionalArgs, $request)->wait();
    }

    /**
     * Retrieves the service account that is used by Access Approval to access KMS
     * keys for signing approved approval requests.
     *
     * Sample code:
     * ```
     * $accessApprovalClient = new AccessApprovalClient();
     * try {
     *     $response = $accessApprovalClient->getAccessApprovalServiceAccount();
     * } finally {
     *     $accessApprovalClient->close();
     * }
     * ```
     *
     * @param array $optionalArgs {
     *     Optional.
     *
     *     @type string $name
     *           Name of the AccessApprovalServiceAccount to retrieve.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\AccessApproval\V1\AccessApprovalServiceAccount
     *
     * @throws ApiException if the remote call fails
     */
    public function getAccessApprovalServiceAccount(array $optionalArgs = [])
    {
        $request = new GetAccessApprovalServiceAccountMessage();
        $requestParamHeaders = [];
        if (isset($optionalArgs['name'])) {
            $request->setName($optionalArgs['name']);
            $requestParamHeaders['name'] = $optionalArgs['name'];
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('GetAccessApprovalServiceAccount', AccessApprovalServiceAccount::class, $optionalArgs, $request)->wait();
    }

    /**
     * Gets the settings associated with a project, folder, or organization.
     *
     * Sample code:
     * ```
     * $accessApprovalClient = new AccessApprovalClient();
     * try {
     *     $response = $accessApprovalClient->getAccessApprovalSettings();
     * } finally {
     *     $accessApprovalClient->close();
     * }
     * ```
     *
     * @param array $optionalArgs {
     *     Optional.
     *
     *     @type string $name
     *           The name of the AccessApprovalSettings to retrieve.
     *           Format: "{projects|folders|organizations}/{id}/accessApprovalSettings"
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\AccessApproval\V1\AccessApprovalSettings
     *
     * @throws ApiException if the remote call fails
     */
    public function getAccessApprovalSettings(array $optionalArgs = [])
    {
        $request = new GetAccessApprovalSettingsMessage();
        $requestParamHeaders = [];
        if (isset($optionalArgs['name'])) {
            $request->setName($optionalArgs['name']);
            $requestParamHeaders['name'] = $optionalArgs['name'];
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('GetAccessApprovalSettings', AccessApprovalSettings::class, $optionalArgs, $request)->wait();
    }

    /**
     * Gets an approval request. Returns NOT_FOUND if the request does not exist.
     *
     * Sample code:
     * ```
     * $accessApprovalClient = new AccessApprovalClient();
     * try {
     *     $response = $accessApprovalClient->getApprovalRequest();
     * } finally {
     *     $accessApprovalClient->close();
     * }
     * ```
     *
     * @param array $optionalArgs {
     *     Optional.
     *
     *     @type string $name
     *           The name of the approval request to retrieve.
     *           Format:
     *           "{projects|folders|organizations}/{id}/approvalRequests/{approval_request}"
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\AccessApproval\V1\ApprovalRequest
     *
     * @throws ApiException if the remote call fails
     */
    public function getApprovalRequest(array $optionalArgs = [])
    {
        $request = new GetApprovalRequestMessage();
        $requestParamHeaders = [];
        if (isset($optionalArgs['name'])) {
            $request->setName($optionalArgs['name']);
            $requestParamHeaders['name'] = $optionalArgs['name'];
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('GetApprovalRequest', ApprovalRequest::class, $optionalArgs, $request)->wait();
    }

    /**
     * Invalidates an existing ApprovalRequest. Returns the updated
     * ApprovalRequest.
     *
     * NOTE: This does not deny access to the resource if another request has been
     * made and approved. It only invalidates a single approval.
     *
     * Returns FAILED_PRECONDITION if the request exists but is not in an approved
     * state.
     *
     * Sample code:
     * ```
     * $accessApprovalClient = new AccessApprovalClient();
     * try {
     *     $response = $accessApprovalClient->invalidateApprovalRequest();
     * } finally {
     *     $accessApprovalClient->close();
     * }
     * ```
     *
     * @param array $optionalArgs {
     *     Optional.
     *
     *     @type string $name
     *           Name of the ApprovalRequest to invalidate.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\AccessApproval\V1\ApprovalRequest
     *
     * @throws ApiException if the remote call fails
     */
    public function invalidateApprovalRequest(array $optionalArgs = [])
    {
        $request = new InvalidateApprovalRequestMessage();
        $requestParamHeaders = [];
        if (isset($optionalArgs['name'])) {
            $request->setName($optionalArgs['name']);
            $requestParamHeaders['name'] = $optionalArgs['name'];
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('InvalidateApprovalRequest', ApprovalRequest::class, $optionalArgs, $request)->wait();
    }

    /**
     * Lists approval requests associated with a project, folder, or organization.
     * Approval requests can be filtered by state (pending, active, dismissed).
     * The order is reverse chronological.
     *
     * Sample code:
     * ```
     * $accessApprovalClient = new AccessApprovalClient();
     * try {
     *     // Iterate over pages of elements
     *     $pagedResponse = $accessApprovalClient->listApprovalRequests();
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $accessApprovalClient->listApprovalRequests();
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $accessApprovalClient->close();
     * }
     * ```
     *
     * @param array $optionalArgs {
     *     Optional.
     *
     *     @type string $parent
     *           The parent resource. This may be "projects/{project}",
     *           "folders/{folder}", or "organizations/{organization}".
     *     @type string $filter
     *           A filter on the type of approval requests to retrieve. Must be one of the
     *           following values:
     *
     *           * [not set]: Requests that are pending or have active approvals.
     *           * ALL: All requests.
     *           * PENDING: Only pending requests.
     *           * ACTIVE: Only active (i.e. currently approved) requests.
     *           * DISMISSED: Only requests that have been dismissed, or requests that
     *           are not approved and past expiration.
     *           * EXPIRED: Only requests that have been approved, and the approval has
     *           expired.
     *           * HISTORY: Active, dismissed and expired requests.
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listApprovalRequests(array $optionalArgs = [])
    {
        $request = new ListApprovalRequestsMessage();
        $requestParamHeaders = [];
        if (isset($optionalArgs['parent'])) {
            $request->setParent($optionalArgs['parent']);
            $requestParamHeaders['parent'] = $optionalArgs['parent'];
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->getPagedListResponse('ListApprovalRequests', $optionalArgs, ListApprovalRequestsResponse::class, $request);
    }

    /**
     * Updates the settings associated with a project, folder, or organization.
     * Settings to update are determined by the value of field_mask.
     *
     * Sample code:
     * ```
     * $accessApprovalClient = new AccessApprovalClient();
     * try {
     *     $response = $accessApprovalClient->updateAccessApprovalSettings();
     * } finally {
     *     $accessApprovalClient->close();
     * }
     * ```
     *
     * @param array $optionalArgs {
     *     Optional.
     *
     *     @type AccessApprovalSettings $settings
     *           The new AccessApprovalSettings.
     *     @type FieldMask $updateMask
     *           The update mask applies to the settings. Only the top level fields of
     *           AccessApprovalSettings (notification_emails & enrolled_services) are
     *           supported. For each field, if it is included, the currently stored value
     *           will be entirely overwritten with the value of the field passed in this
     *           request.
     *
     *           For the `FieldMask` definition, see
     *           https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#fieldmask
     *           If this field is left unset, only the notification_emails field will be
     *           updated.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\AccessApproval\V1\AccessApprovalSettings
     *
     * @throws ApiException if the remote call fails
     */
    public function updateAccessApprovalSettings(array $optionalArgs = [])
    {
        $request = new UpdateAccessApprovalSettingsMessage();
        $requestParamHeaders = [];
        if (isset($optionalArgs['settings'])) {
            $request->setSettings($optionalArgs['settings']);
        }

        if (isset($optionalArgs['updateMask'])) {
            $request->setUpdateMask($optionalArgs['updateMask']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('UpdateAccessApprovalSettings', AccessApprovalSettings::class, $optionalArgs, $request)->wait();
    }
}
