<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/recaptchaenterprise/v1/recaptchaenterprise.proto

namespace Google\Cloud\RecaptchaEnterprise\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Settings specific to keys that can be used by websites.
 *
 * Generated from protobuf message <code>google.cloud.recaptchaenterprise.v1.WebKeySettings</code>
 */
class WebKeySettings extends \Google\Protobuf\Internal\Message
{
    /**
     * If set to true, it means allowed_domains will not be enforced.
     *
     * Generated from protobuf field <code>bool allow_all_domains = 3;</code>
     */
    private $allow_all_domains = false;
    /**
     * Domains or subdomains of websites allowed to use the key. All subdomains
     * of an allowed domain are automatically allowed. A valid domain requires a
     * host and must not include any path, port, query or fragment.
     * Examples: 'example.com' or 'subdomain.example.com'
     *
     * Generated from protobuf field <code>repeated string allowed_domains = 1;</code>
     */
    private $allowed_domains;
    /**
     * Required. Whether this key can be used on AMP (Accelerated Mobile Pages) websites.
     *
     * Generated from protobuf field <code>bool allow_amp_traffic = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    private $allow_amp_traffic = false;
    /**
     * Required. Describes how this key is integrated with the website.
     *
     * Generated from protobuf field <code>.google.cloud.recaptchaenterprise.v1.WebKeySettings.IntegrationType integration_type = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    private $integration_type = 0;
    /**
     * Settings for the frequency and difficulty at which this key triggers
     * captcha challenges. This should only be specified for IntegrationTypes
     * CHECKBOX and INVISIBLE.
     *
     * Generated from protobuf field <code>.google.cloud.recaptchaenterprise.v1.WebKeySettings.ChallengeSecurityPreference challenge_security_preference = 5;</code>
     */
    private $challenge_security_preference = 0;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type bool $allow_all_domains
     *           If set to true, it means allowed_domains will not be enforced.
     *     @type string[]|\Google\Protobuf\Internal\RepeatedField $allowed_domains
     *           Domains or subdomains of websites allowed to use the key. All subdomains
     *           of an allowed domain are automatically allowed. A valid domain requires a
     *           host and must not include any path, port, query or fragment.
     *           Examples: 'example.com' or 'subdomain.example.com'
     *     @type bool $allow_amp_traffic
     *           Required. Whether this key can be used on AMP (Accelerated Mobile Pages) websites.
     *     @type int $integration_type
     *           Required. Describes how this key is integrated with the website.
     *     @type int $challenge_security_preference
     *           Settings for the frequency and difficulty at which this key triggers
     *           captcha challenges. This should only be specified for IntegrationTypes
     *           CHECKBOX and INVISIBLE.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Recaptchaenterprise\V1\Recaptchaenterprise::initOnce();
        parent::__construct($data);
    }

    /**
     * If set to true, it means allowed_domains will not be enforced.
     *
     * Generated from protobuf field <code>bool allow_all_domains = 3;</code>
     * @return bool
     */
    public function getAllowAllDomains()
    {
        return $this->allow_all_domains;
    }

    /**
     * If set to true, it means allowed_domains will not be enforced.
     *
     * Generated from protobuf field <code>bool allow_all_domains = 3;</code>
     * @param bool $var
     * @return $this
     */
    public function setAllowAllDomains($var)
    {
        GPBUtil::checkBool($var);
        $this->allow_all_domains = $var;

        return $this;
    }

    /**
     * Domains or subdomains of websites allowed to use the key. All subdomains
     * of an allowed domain are automatically allowed. A valid domain requires a
     * host and must not include any path, port, query or fragment.
     * Examples: 'example.com' or 'subdomain.example.com'
     *
     * Generated from protobuf field <code>repeated string allowed_domains = 1;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getAllowedDomains()
    {
        return $this->allowed_domains;
    }

    /**
     * Domains or subdomains of websites allowed to use the key. All subdomains
     * of an allowed domain are automatically allowed. A valid domain requires a
     * host and must not include any path, port, query or fragment.
     * Examples: 'example.com' or 'subdomain.example.com'
     *
     * Generated from protobuf field <code>repeated string allowed_domains = 1;</code>
     * @param string[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setAllowedDomains($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->allowed_domains = $arr;

        return $this;
    }

    /**
     * Required. Whether this key can be used on AMP (Accelerated Mobile Pages) websites.
     *
     * Generated from protobuf field <code>bool allow_amp_traffic = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return bool
     */
    public function getAllowAmpTraffic()
    {
        return $this->allow_amp_traffic;
    }

    /**
     * Required. Whether this key can be used on AMP (Accelerated Mobile Pages) websites.
     *
     * Generated from protobuf field <code>bool allow_amp_traffic = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param bool $var
     * @return $this
     */
    public function setAllowAmpTraffic($var)
    {
        GPBUtil::checkBool($var);
        $this->allow_amp_traffic = $var;

        return $this;
    }

    /**
     * Required. Describes how this key is integrated with the website.
     *
     * Generated from protobuf field <code>.google.cloud.recaptchaenterprise.v1.WebKeySettings.IntegrationType integration_type = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return int
     */
    public function getIntegrationType()
    {
        return $this->integration_type;
    }

    /**
     * Required. Describes how this key is integrated with the website.
     *
     * Generated from protobuf field <code>.google.cloud.recaptchaenterprise.v1.WebKeySettings.IntegrationType integration_type = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param int $var
     * @return $this
     */
    public function setIntegrationType($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\RecaptchaEnterprise\V1\WebKeySettings_IntegrationType::class);
        $this->integration_type = $var;

        return $this;
    }

    /**
     * Settings for the frequency and difficulty at which this key triggers
     * captcha challenges. This should only be specified for IntegrationTypes
     * CHECKBOX and INVISIBLE.
     *
     * Generated from protobuf field <code>.google.cloud.recaptchaenterprise.v1.WebKeySettings.ChallengeSecurityPreference challenge_security_preference = 5;</code>
     * @return int
     */
    public function getChallengeSecurityPreference()
    {
        return $this->challenge_security_preference;
    }

    /**
     * Settings for the frequency and difficulty at which this key triggers
     * captcha challenges. This should only be specified for IntegrationTypes
     * CHECKBOX and INVISIBLE.
     *
     * Generated from protobuf field <code>.google.cloud.recaptchaenterprise.v1.WebKeySettings.ChallengeSecurityPreference challenge_security_preference = 5;</code>
     * @param int $var
     * @return $this
     */
    public function setChallengeSecurityPreference($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\RecaptchaEnterprise\V1\WebKeySettings_ChallengeSecurityPreference::class);
        $this->challenge_security_preference = $var;

        return $this;
    }

}

