<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/dialogflow/v2/audio_config.proto

namespace Google\Cloud\Dialogflow\V2;

use UnexpectedValueException;

/**
 * Variant of the specified [Speech model][google.cloud.dialogflow.v2.InputAudioConfig.model] to use.
 * See the [Cloud Speech
 * documentation](https://cloud.google.com/speech-to-text/docs/enhanced-models)
 * for which models have different variants. For example, the "phone_call" model
 * has both a standard and an enhanced variant. When you use an enhanced model,
 * you will generally receive higher quality results than for a standard model.
 *
 * Protobuf type <code>google.cloud.dialogflow.v2.SpeechModelVariant</code>
 */
class SpeechModelVariant
{
    /**
     * No model variant specified. In this case Dialogflow defaults to
     * USE_BEST_AVAILABLE.
     *
     * Generated from protobuf enum <code>SPEECH_MODEL_VARIANT_UNSPECIFIED = 0;</code>
     */
    const SPEECH_MODEL_VARIANT_UNSPECIFIED = 0;
    /**
     * Use the best available variant of the [Speech
     * model][InputAudioConfig.model] that the caller is eligible for.
     * Please see the [Dialogflow
     * docs](https://cloud.google.com/dialogflow/docs/data-logging) for
     * how to make your project eligible for enhanced models.
     *
     * Generated from protobuf enum <code>USE_BEST_AVAILABLE = 1;</code>
     */
    const USE_BEST_AVAILABLE = 1;
    /**
     * Use standard model variant even if an enhanced model is available.  See the
     * [Cloud Speech
     * documentation](https://cloud.google.com/speech-to-text/docs/enhanced-models)
     * for details about enhanced models.
     *
     * Generated from protobuf enum <code>USE_STANDARD = 2;</code>
     */
    const USE_STANDARD = 2;
    /**
     * Use an enhanced model variant:
     * * If an enhanced variant does not exist for the given
     *   [model][google.cloud.dialogflow.v2.InputAudioConfig.model] and request language, Dialogflow falls
     *   back to the standard variant.
     *   The [Cloud Speech
     *   documentation](https://cloud.google.com/speech-to-text/docs/enhanced-models)
     *   describes which models have enhanced variants.
     * * If the API caller isn't eligible for enhanced models, Dialogflow returns
     *   an error. Please see the [Dialogflow
     *   docs](https://cloud.google.com/dialogflow/docs/data-logging)
     *   for how to make your project eligible.
     *
     * Generated from protobuf enum <code>USE_ENHANCED = 3;</code>
     */
    const USE_ENHANCED = 3;

    private static $valueToName = [
        self::SPEECH_MODEL_VARIANT_UNSPECIFIED => 'SPEECH_MODEL_VARIANT_UNSPECIFIED',
        self::USE_BEST_AVAILABLE => 'USE_BEST_AVAILABLE',
        self::USE_STANDARD => 'USE_STANDARD',
        self::USE_ENHANCED => 'USE_ENHANCED',
    ];

    public static function name($value)
    {
        if (!isset(self::$valueToName[$value])) {
            throw new UnexpectedValueException(sprintf(
                    'Enum %s has no name defined for value %s', __CLASS__, $value));
        }
        return self::$valueToName[$value];
    }


    public static function value($name)
    {
        $const = __CLASS__ . '::' . strtoupper($name);
        if (!defined($const)) {
            throw new UnexpectedValueException(sprintf(
                    'Enum %s has no value defined for name %s', __CLASS__, $name));
        }
        return constant($const);
    }
}

