<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/domains/v1alpha2/domains.proto

namespace Google\Cloud\Domains\V1alpha2;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * The `Registration` resource facilitates managing and configuring domain name
 * registrations.
 * To create a new `Registration` resource, find a suitable domain name by
 * calling the `SearchDomains` method with a query to see available domain name
 * options. After choosing a name, call `RetrieveRegisterParameters` to
 * ensure availability and obtain information like pricing, which is needed to
 * build a call to `RegisterDomain`.
 *
 * Generated from protobuf message <code>google.cloud.domains.v1alpha2.Registration</code>
 */
class Registration extends \Google\Protobuf\Internal\Message
{
    /**
     * Output only. Name of the `Registration` resource, in the format
     * `projects/&#42;&#47;locations/&#42;&#47;registrations/<domain_name>`.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $name = '';
    /**
     * Required. Immutable. The domain name. Unicode domain names must be expressed in Punycode format.
     *
     * Generated from protobuf field <code>string domain_name = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];</code>
     */
    private $domain_name = '';
    /**
     * Output only. The creation timestamp of the `Registration` resource.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $create_time = null;
    /**
     * Output only. The expiration timestamp of the `Registration`.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp expire_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $expire_time = null;
    /**
     * Output only. The state of the `Registration`
     *
     * Generated from protobuf field <code>.google.cloud.domains.v1alpha2.Registration.State state = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $state = 0;
    /**
     * Output only. The set of issues with the `Registration` that require attention.
     *
     * Generated from protobuf field <code>repeated .google.cloud.domains.v1alpha2.Registration.Issue issues = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $issues;
    /**
     * Set of labels associated with the `Registration`.
     *
     * Generated from protobuf field <code>map<string, string> labels = 9;</code>
     */
    private $labels;
    /**
     * Settings for management of the `Registration`, including renewal, billing,
     * and transfer. You cannot update these with the `UpdateRegistration`
     * method. To update these settings, use the `ConfigureManagementSettings`
     * method.
     *
     * Generated from protobuf field <code>.google.cloud.domains.v1alpha2.ManagementSettings management_settings = 10;</code>
     */
    private $management_settings = null;
    /**
     * Settings controlling the DNS configuration of the `Registration`. You
     * cannot update these with the `UpdateRegistration` method. To update these
     * settings, use the `ConfigureDnsSettings` method.
     *
     * Generated from protobuf field <code>.google.cloud.domains.v1alpha2.DnsSettings dns_settings = 11;</code>
     */
    private $dns_settings = null;
    /**
     * Required. Settings for contact information linked to the `Registration`. You cannot
     * update these with the `UpdateRegistration` method. To update these
     * settings, use the `ConfigureContactSettings` method.
     *
     * Generated from protobuf field <code>.google.cloud.domains.v1alpha2.ContactSettings contact_settings = 12 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    private $contact_settings = null;
    /**
     * Output only. Pending contact settings for the `Registration`. Updates to the
     * `contact_settings` field that change its `registrant_contact` or `privacy`
     * fields require email confirmation by the `registrant_contact`
     * before taking effect. This field is set only if there are pending updates
     * to the `contact_settings` that have not yet been confirmed. To confirm the
     * changes, the `registrant_contact` must follow the instructions in the
     * email they receive.
     *
     * Generated from protobuf field <code>.google.cloud.domains.v1alpha2.ContactSettings pending_contact_settings = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $pending_contact_settings = null;
    /**
     * Output only. Set of options for the `contact_settings.privacy` field that this
     * `Registration` supports.
     *
     * Generated from protobuf field <code>repeated .google.cloud.domains.v1alpha2.ContactPrivacy supported_privacy = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $supported_privacy;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           Output only. Name of the `Registration` resource, in the format
     *           `projects/&#42;&#47;locations/&#42;&#47;registrations/<domain_name>`.
     *     @type string $domain_name
     *           Required. Immutable. The domain name. Unicode domain names must be expressed in Punycode format.
     *     @type \Google\Protobuf\Timestamp $create_time
     *           Output only. The creation timestamp of the `Registration` resource.
     *     @type \Google\Protobuf\Timestamp $expire_time
     *           Output only. The expiration timestamp of the `Registration`.
     *     @type int $state
     *           Output only. The state of the `Registration`
     *     @type int[]|\Google\Protobuf\Internal\RepeatedField $issues
     *           Output only. The set of issues with the `Registration` that require attention.
     *     @type array|\Google\Protobuf\Internal\MapField $labels
     *           Set of labels associated with the `Registration`.
     *     @type \Google\Cloud\Domains\V1alpha2\ManagementSettings $management_settings
     *           Settings for management of the `Registration`, including renewal, billing,
     *           and transfer. You cannot update these with the `UpdateRegistration`
     *           method. To update these settings, use the `ConfigureManagementSettings`
     *           method.
     *     @type \Google\Cloud\Domains\V1alpha2\DnsSettings $dns_settings
     *           Settings controlling the DNS configuration of the `Registration`. You
     *           cannot update these with the `UpdateRegistration` method. To update these
     *           settings, use the `ConfigureDnsSettings` method.
     *     @type \Google\Cloud\Domains\V1alpha2\ContactSettings $contact_settings
     *           Required. Settings for contact information linked to the `Registration`. You cannot
     *           update these with the `UpdateRegistration` method. To update these
     *           settings, use the `ConfigureContactSettings` method.
     *     @type \Google\Cloud\Domains\V1alpha2\ContactSettings $pending_contact_settings
     *           Output only. Pending contact settings for the `Registration`. Updates to the
     *           `contact_settings` field that change its `registrant_contact` or `privacy`
     *           fields require email confirmation by the `registrant_contact`
     *           before taking effect. This field is set only if there are pending updates
     *           to the `contact_settings` that have not yet been confirmed. To confirm the
     *           changes, the `registrant_contact` must follow the instructions in the
     *           email they receive.
     *     @type int[]|\Google\Protobuf\Internal\RepeatedField $supported_privacy
     *           Output only. Set of options for the `contact_settings.privacy` field that this
     *           `Registration` supports.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Domains\V1Alpha2\Domains::initOnce();
        parent::__construct($data);
    }

    /**
     * Output only. Name of the `Registration` resource, in the format
     * `projects/&#42;&#47;locations/&#42;&#47;registrations/<domain_name>`.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Output only. Name of the `Registration` resource, in the format
     * `projects/&#42;&#47;locations/&#42;&#47;registrations/<domain_name>`.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Required. Immutable. The domain name. Unicode domain names must be expressed in Punycode format.
     *
     * Generated from protobuf field <code>string domain_name = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];</code>
     * @return string
     */
    public function getDomainName()
    {
        return $this->domain_name;
    }

    /**
     * Required. Immutable. The domain name. Unicode domain names must be expressed in Punycode format.
     *
     * Generated from protobuf field <code>string domain_name = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];</code>
     * @param string $var
     * @return $this
     */
    public function setDomainName($var)
    {
        GPBUtil::checkString($var, True);
        $this->domain_name = $var;

        return $this;
    }

    /**
     * Output only. The creation timestamp of the `Registration` resource.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getCreateTime()
    {
        return isset($this->create_time) ? $this->create_time : null;
    }

    public function hasCreateTime()
    {
        return isset($this->create_time);
    }

    public function clearCreateTime()
    {
        unset($this->create_time);
    }

    /**
     * Output only. The creation timestamp of the `Registration` resource.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setCreateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->create_time = $var;

        return $this;
    }

    /**
     * Output only. The expiration timestamp of the `Registration`.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp expire_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getExpireTime()
    {
        return isset($this->expire_time) ? $this->expire_time : null;
    }

    public function hasExpireTime()
    {
        return isset($this->expire_time);
    }

    public function clearExpireTime()
    {
        unset($this->expire_time);
    }

    /**
     * Output only. The expiration timestamp of the `Registration`.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp expire_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setExpireTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->expire_time = $var;

        return $this;
    }

    /**
     * Output only. The state of the `Registration`
     *
     * Generated from protobuf field <code>.google.cloud.domains.v1alpha2.Registration.State state = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int
     */
    public function getState()
    {
        return $this->state;
    }

    /**
     * Output only. The state of the `Registration`
     *
     * Generated from protobuf field <code>.google.cloud.domains.v1alpha2.Registration.State state = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int $var
     * @return $this
     */
    public function setState($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Domains\V1alpha2\Registration\State::class);
        $this->state = $var;

        return $this;
    }

    /**
     * Output only. The set of issues with the `Registration` that require attention.
     *
     * Generated from protobuf field <code>repeated .google.cloud.domains.v1alpha2.Registration.Issue issues = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getIssues()
    {
        return $this->issues;
    }

    /**
     * Output only. The set of issues with the `Registration` that require attention.
     *
     * Generated from protobuf field <code>repeated .google.cloud.domains.v1alpha2.Registration.Issue issues = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setIssues($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::ENUM, \Google\Cloud\Domains\V1alpha2\Registration\Issue::class);
        $this->issues = $arr;

        return $this;
    }

    /**
     * Set of labels associated with the `Registration`.
     *
     * Generated from protobuf field <code>map<string, string> labels = 9;</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getLabels()
    {
        return $this->labels;
    }

    /**
     * Set of labels associated with the `Registration`.
     *
     * Generated from protobuf field <code>map<string, string> labels = 9;</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setLabels($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::STRING);
        $this->labels = $arr;

        return $this;
    }

    /**
     * Settings for management of the `Registration`, including renewal, billing,
     * and transfer. You cannot update these with the `UpdateRegistration`
     * method. To update these settings, use the `ConfigureManagementSettings`
     * method.
     *
     * Generated from protobuf field <code>.google.cloud.domains.v1alpha2.ManagementSettings management_settings = 10;</code>
     * @return \Google\Cloud\Domains\V1alpha2\ManagementSettings|null
     */
    public function getManagementSettings()
    {
        return isset($this->management_settings) ? $this->management_settings : null;
    }

    public function hasManagementSettings()
    {
        return isset($this->management_settings);
    }

    public function clearManagementSettings()
    {
        unset($this->management_settings);
    }

    /**
     * Settings for management of the `Registration`, including renewal, billing,
     * and transfer. You cannot update these with the `UpdateRegistration`
     * method. To update these settings, use the `ConfigureManagementSettings`
     * method.
     *
     * Generated from protobuf field <code>.google.cloud.domains.v1alpha2.ManagementSettings management_settings = 10;</code>
     * @param \Google\Cloud\Domains\V1alpha2\ManagementSettings $var
     * @return $this
     */
    public function setManagementSettings($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Domains\V1alpha2\ManagementSettings::class);
        $this->management_settings = $var;

        return $this;
    }

    /**
     * Settings controlling the DNS configuration of the `Registration`. You
     * cannot update these with the `UpdateRegistration` method. To update these
     * settings, use the `ConfigureDnsSettings` method.
     *
     * Generated from protobuf field <code>.google.cloud.domains.v1alpha2.DnsSettings dns_settings = 11;</code>
     * @return \Google\Cloud\Domains\V1alpha2\DnsSettings|null
     */
    public function getDnsSettings()
    {
        return isset($this->dns_settings) ? $this->dns_settings : null;
    }

    public function hasDnsSettings()
    {
        return isset($this->dns_settings);
    }

    public function clearDnsSettings()
    {
        unset($this->dns_settings);
    }

    /**
     * Settings controlling the DNS configuration of the `Registration`. You
     * cannot update these with the `UpdateRegistration` method. To update these
     * settings, use the `ConfigureDnsSettings` method.
     *
     * Generated from protobuf field <code>.google.cloud.domains.v1alpha2.DnsSettings dns_settings = 11;</code>
     * @param \Google\Cloud\Domains\V1alpha2\DnsSettings $var
     * @return $this
     */
    public function setDnsSettings($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Domains\V1alpha2\DnsSettings::class);
        $this->dns_settings = $var;

        return $this;
    }

    /**
     * Required. Settings for contact information linked to the `Registration`. You cannot
     * update these with the `UpdateRegistration` method. To update these
     * settings, use the `ConfigureContactSettings` method.
     *
     * Generated from protobuf field <code>.google.cloud.domains.v1alpha2.ContactSettings contact_settings = 12 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return \Google\Cloud\Domains\V1alpha2\ContactSettings|null
     */
    public function getContactSettings()
    {
        return isset($this->contact_settings) ? $this->contact_settings : null;
    }

    public function hasContactSettings()
    {
        return isset($this->contact_settings);
    }

    public function clearContactSettings()
    {
        unset($this->contact_settings);
    }

    /**
     * Required. Settings for contact information linked to the `Registration`. You cannot
     * update these with the `UpdateRegistration` method. To update these
     * settings, use the `ConfigureContactSettings` method.
     *
     * Generated from protobuf field <code>.google.cloud.domains.v1alpha2.ContactSettings contact_settings = 12 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param \Google\Cloud\Domains\V1alpha2\ContactSettings $var
     * @return $this
     */
    public function setContactSettings($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Domains\V1alpha2\ContactSettings::class);
        $this->contact_settings = $var;

        return $this;
    }

    /**
     * Output only. Pending contact settings for the `Registration`. Updates to the
     * `contact_settings` field that change its `registrant_contact` or `privacy`
     * fields require email confirmation by the `registrant_contact`
     * before taking effect. This field is set only if there are pending updates
     * to the `contact_settings` that have not yet been confirmed. To confirm the
     * changes, the `registrant_contact` must follow the instructions in the
     * email they receive.
     *
     * Generated from protobuf field <code>.google.cloud.domains.v1alpha2.ContactSettings pending_contact_settings = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Cloud\Domains\V1alpha2\ContactSettings|null
     */
    public function getPendingContactSettings()
    {
        return isset($this->pending_contact_settings) ? $this->pending_contact_settings : null;
    }

    public function hasPendingContactSettings()
    {
        return isset($this->pending_contact_settings);
    }

    public function clearPendingContactSettings()
    {
        unset($this->pending_contact_settings);
    }

    /**
     * Output only. Pending contact settings for the `Registration`. Updates to the
     * `contact_settings` field that change its `registrant_contact` or `privacy`
     * fields require email confirmation by the `registrant_contact`
     * before taking effect. This field is set only if there are pending updates
     * to the `contact_settings` that have not yet been confirmed. To confirm the
     * changes, the `registrant_contact` must follow the instructions in the
     * email they receive.
     *
     * Generated from protobuf field <code>.google.cloud.domains.v1alpha2.ContactSettings pending_contact_settings = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Cloud\Domains\V1alpha2\ContactSettings $var
     * @return $this
     */
    public function setPendingContactSettings($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Domains\V1alpha2\ContactSettings::class);
        $this->pending_contact_settings = $var;

        return $this;
    }

    /**
     * Output only. Set of options for the `contact_settings.privacy` field that this
     * `Registration` supports.
     *
     * Generated from protobuf field <code>repeated .google.cloud.domains.v1alpha2.ContactPrivacy supported_privacy = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getSupportedPrivacy()
    {
        return $this->supported_privacy;
    }

    /**
     * Output only. Set of options for the `contact_settings.privacy` field that this
     * `Registration` supports.
     *
     * Generated from protobuf field <code>repeated .google.cloud.domains.v1alpha2.ContactPrivacy supported_privacy = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setSupportedPrivacy($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::ENUM, \Google\Cloud\Domains\V1alpha2\ContactPrivacy::class);
        $this->supported_privacy = $arr;

        return $this;
    }

}

