<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/video/livestream/v1/resources.proto

namespace Google\Cloud\Video\LiveStream\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Event is a sub-resource of a channel, which can be scheduled by the user to
 * execute operations on a channel resource without having to stop the channel.
 *
 * Generated from protobuf message <code>google.cloud.video.livestream.v1.Event</code>
 */
class Event extends \Google\Protobuf\Internal\Message
{
    /**
     * The resource name of the event, in the form of:
     * `projects/{project}/locations/{location}/channels/{channelId}/events/{eventId}`.
     *
     * Generated from protobuf field <code>string name = 1;</code>
     */
    protected $name = '';
    /**
     * Output only. The creation time.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $create_time = null;
    /**
     * Output only. The update time.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $update_time = null;
    /**
     * User-defined key/value metadata.
     *
     * Generated from protobuf field <code>map<string, string> labels = 4;</code>
     */
    private $labels;
    /**
     * When this field is set to true, the event will be executed at the earliest
     * time that the server can schedule the event and
     * [execution_time][google.cloud.video.livestream.v1.Event.execution_time]
     * will be populated with the time that the server actually schedules the
     * event.
     *
     * Generated from protobuf field <code>bool execute_now = 9;</code>
     */
    protected $execute_now = false;
    /**
     * The time to execute the event. If you set
     * [execute_now][google.cloud.video.livestream.v1.Event.execute_now] to
     * `true`, then do not set this field in the `CreateEvent` request. In
     * this case, the server schedules the event and populates this field. If you
     * set [execute_now][google.cloud.video.livestream.v1.Event.execute_now] to
     * `false`, then you must set this field to at least 10 seconds in the future
     * or else the event can't be created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp execution_time = 10;</code>
     */
    protected $execution_time = null;
    /**
     * Output only. The state of the event.
     *
     * Generated from protobuf field <code>.google.cloud.video.livestream.v1.Event.State state = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $state = 0;
    /**
     * Output only. An error object that describes the reason for the failure.
     * This property is always present when `state` is `FAILED`.
     *
     * Generated from protobuf field <code>.google.rpc.Status error = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $error = null;
    protected $task;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           The resource name of the event, in the form of:
     *           `projects/{project}/locations/{location}/channels/{channelId}/events/{eventId}`.
     *     @type \Google\Protobuf\Timestamp $create_time
     *           Output only. The creation time.
     *     @type \Google\Protobuf\Timestamp $update_time
     *           Output only. The update time.
     *     @type array|\Google\Protobuf\Internal\MapField $labels
     *           User-defined key/value metadata.
     *     @type \Google\Cloud\Video\LiveStream\V1\Event\InputSwitchTask $input_switch
     *           Switches to another input stream.
     *     @type \Google\Cloud\Video\LiveStream\V1\Event\AdBreakTask $ad_break
     *           Inserts a new ad opportunity.
     *     @type \Google\Cloud\Video\LiveStream\V1\Event\ReturnToProgramTask $return_to_program
     *           Stops any running ad break.
     *     @type \Google\Cloud\Video\LiveStream\V1\Event\SlateTask $slate
     *           Inserts a slate.
     *     @type \Google\Cloud\Video\LiveStream\V1\Event\MuteTask $mute
     *           Mutes the stream.
     *     @type \Google\Cloud\Video\LiveStream\V1\Event\UnmuteTask $unmute
     *           Unmutes the stream.
     *     @type bool $execute_now
     *           When this field is set to true, the event will be executed at the earliest
     *           time that the server can schedule the event and
     *           [execution_time][google.cloud.video.livestream.v1.Event.execution_time]
     *           will be populated with the time that the server actually schedules the
     *           event.
     *     @type \Google\Protobuf\Timestamp $execution_time
     *           The time to execute the event. If you set
     *           [execute_now][google.cloud.video.livestream.v1.Event.execute_now] to
     *           `true`, then do not set this field in the `CreateEvent` request. In
     *           this case, the server schedules the event and populates this field. If you
     *           set [execute_now][google.cloud.video.livestream.v1.Event.execute_now] to
     *           `false`, then you must set this field to at least 10 seconds in the future
     *           or else the event can't be created.
     *     @type int $state
     *           Output only. The state of the event.
     *     @type \Google\Rpc\Status $error
     *           Output only. An error object that describes the reason for the failure.
     *           This property is always present when `state` is `FAILED`.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Video\Livestream\V1\Resources::initOnce();
        parent::__construct($data);
    }

    /**
     * The resource name of the event, in the form of:
     * `projects/{project}/locations/{location}/channels/{channelId}/events/{eventId}`.
     *
     * Generated from protobuf field <code>string name = 1;</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * The resource name of the event, in the form of:
     * `projects/{project}/locations/{location}/channels/{channelId}/events/{eventId}`.
     *
     * Generated from protobuf field <code>string name = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Output only. The creation time.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getCreateTime()
    {
        return $this->create_time;
    }

    public function hasCreateTime()
    {
        return isset($this->create_time);
    }

    public function clearCreateTime()
    {
        unset($this->create_time);
    }

    /**
     * Output only. The creation time.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setCreateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->create_time = $var;

        return $this;
    }

    /**
     * Output only. The update time.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getUpdateTime()
    {
        return $this->update_time;
    }

    public function hasUpdateTime()
    {
        return isset($this->update_time);
    }

    public function clearUpdateTime()
    {
        unset($this->update_time);
    }

    /**
     * Output only. The update time.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setUpdateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->update_time = $var;

        return $this;
    }

    /**
     * User-defined key/value metadata.
     *
     * Generated from protobuf field <code>map<string, string> labels = 4;</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getLabels()
    {
        return $this->labels;
    }

    /**
     * User-defined key/value metadata.
     *
     * Generated from protobuf field <code>map<string, string> labels = 4;</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setLabels($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::STRING);
        $this->labels = $arr;

        return $this;
    }

    /**
     * Switches to another input stream.
     *
     * Generated from protobuf field <code>.google.cloud.video.livestream.v1.Event.InputSwitchTask input_switch = 5;</code>
     * @return \Google\Cloud\Video\LiveStream\V1\Event\InputSwitchTask|null
     */
    public function getInputSwitch()
    {
        return $this->readOneof(5);
    }

    public function hasInputSwitch()
    {
        return $this->hasOneof(5);
    }

    /**
     * Switches to another input stream.
     *
     * Generated from protobuf field <code>.google.cloud.video.livestream.v1.Event.InputSwitchTask input_switch = 5;</code>
     * @param \Google\Cloud\Video\LiveStream\V1\Event\InputSwitchTask $var
     * @return $this
     */
    public function setInputSwitch($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Video\LiveStream\V1\Event\InputSwitchTask::class);
        $this->writeOneof(5, $var);

        return $this;
    }

    /**
     * Inserts a new ad opportunity.
     *
     * Generated from protobuf field <code>.google.cloud.video.livestream.v1.Event.AdBreakTask ad_break = 6;</code>
     * @return \Google\Cloud\Video\LiveStream\V1\Event\AdBreakTask|null
     */
    public function getAdBreak()
    {
        return $this->readOneof(6);
    }

    public function hasAdBreak()
    {
        return $this->hasOneof(6);
    }

    /**
     * Inserts a new ad opportunity.
     *
     * Generated from protobuf field <code>.google.cloud.video.livestream.v1.Event.AdBreakTask ad_break = 6;</code>
     * @param \Google\Cloud\Video\LiveStream\V1\Event\AdBreakTask $var
     * @return $this
     */
    public function setAdBreak($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Video\LiveStream\V1\Event\AdBreakTask::class);
        $this->writeOneof(6, $var);

        return $this;
    }

    /**
     * Stops any running ad break.
     *
     * Generated from protobuf field <code>.google.cloud.video.livestream.v1.Event.ReturnToProgramTask return_to_program = 13;</code>
     * @return \Google\Cloud\Video\LiveStream\V1\Event\ReturnToProgramTask|null
     */
    public function getReturnToProgram()
    {
        return $this->readOneof(13);
    }

    public function hasReturnToProgram()
    {
        return $this->hasOneof(13);
    }

    /**
     * Stops any running ad break.
     *
     * Generated from protobuf field <code>.google.cloud.video.livestream.v1.Event.ReturnToProgramTask return_to_program = 13;</code>
     * @param \Google\Cloud\Video\LiveStream\V1\Event\ReturnToProgramTask $var
     * @return $this
     */
    public function setReturnToProgram($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Video\LiveStream\V1\Event\ReturnToProgramTask::class);
        $this->writeOneof(13, $var);

        return $this;
    }

    /**
     * Inserts a slate.
     *
     * Generated from protobuf field <code>.google.cloud.video.livestream.v1.Event.SlateTask slate = 14;</code>
     * @return \Google\Cloud\Video\LiveStream\V1\Event\SlateTask|null
     */
    public function getSlate()
    {
        return $this->readOneof(14);
    }

    public function hasSlate()
    {
        return $this->hasOneof(14);
    }

    /**
     * Inserts a slate.
     *
     * Generated from protobuf field <code>.google.cloud.video.livestream.v1.Event.SlateTask slate = 14;</code>
     * @param \Google\Cloud\Video\LiveStream\V1\Event\SlateTask $var
     * @return $this
     */
    public function setSlate($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Video\LiveStream\V1\Event\SlateTask::class);
        $this->writeOneof(14, $var);

        return $this;
    }

    /**
     * Mutes the stream.
     *
     * Generated from protobuf field <code>.google.cloud.video.livestream.v1.Event.MuteTask mute = 15;</code>
     * @return \Google\Cloud\Video\LiveStream\V1\Event\MuteTask|null
     */
    public function getMute()
    {
        return $this->readOneof(15);
    }

    public function hasMute()
    {
        return $this->hasOneof(15);
    }

    /**
     * Mutes the stream.
     *
     * Generated from protobuf field <code>.google.cloud.video.livestream.v1.Event.MuteTask mute = 15;</code>
     * @param \Google\Cloud\Video\LiveStream\V1\Event\MuteTask $var
     * @return $this
     */
    public function setMute($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Video\LiveStream\V1\Event\MuteTask::class);
        $this->writeOneof(15, $var);

        return $this;
    }

    /**
     * Unmutes the stream.
     *
     * Generated from protobuf field <code>.google.cloud.video.livestream.v1.Event.UnmuteTask unmute = 16;</code>
     * @return \Google\Cloud\Video\LiveStream\V1\Event\UnmuteTask|null
     */
    public function getUnmute()
    {
        return $this->readOneof(16);
    }

    public function hasUnmute()
    {
        return $this->hasOneof(16);
    }

    /**
     * Unmutes the stream.
     *
     * Generated from protobuf field <code>.google.cloud.video.livestream.v1.Event.UnmuteTask unmute = 16;</code>
     * @param \Google\Cloud\Video\LiveStream\V1\Event\UnmuteTask $var
     * @return $this
     */
    public function setUnmute($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Video\LiveStream\V1\Event\UnmuteTask::class);
        $this->writeOneof(16, $var);

        return $this;
    }

    /**
     * When this field is set to true, the event will be executed at the earliest
     * time that the server can schedule the event and
     * [execution_time][google.cloud.video.livestream.v1.Event.execution_time]
     * will be populated with the time that the server actually schedules the
     * event.
     *
     * Generated from protobuf field <code>bool execute_now = 9;</code>
     * @return bool
     */
    public function getExecuteNow()
    {
        return $this->execute_now;
    }

    /**
     * When this field is set to true, the event will be executed at the earliest
     * time that the server can schedule the event and
     * [execution_time][google.cloud.video.livestream.v1.Event.execution_time]
     * will be populated with the time that the server actually schedules the
     * event.
     *
     * Generated from protobuf field <code>bool execute_now = 9;</code>
     * @param bool $var
     * @return $this
     */
    public function setExecuteNow($var)
    {
        GPBUtil::checkBool($var);
        $this->execute_now = $var;

        return $this;
    }

    /**
     * The time to execute the event. If you set
     * [execute_now][google.cloud.video.livestream.v1.Event.execute_now] to
     * `true`, then do not set this field in the `CreateEvent` request. In
     * this case, the server schedules the event and populates this field. If you
     * set [execute_now][google.cloud.video.livestream.v1.Event.execute_now] to
     * `false`, then you must set this field to at least 10 seconds in the future
     * or else the event can't be created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp execution_time = 10;</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getExecutionTime()
    {
        return $this->execution_time;
    }

    public function hasExecutionTime()
    {
        return isset($this->execution_time);
    }

    public function clearExecutionTime()
    {
        unset($this->execution_time);
    }

    /**
     * The time to execute the event. If you set
     * [execute_now][google.cloud.video.livestream.v1.Event.execute_now] to
     * `true`, then do not set this field in the `CreateEvent` request. In
     * this case, the server schedules the event and populates this field. If you
     * set [execute_now][google.cloud.video.livestream.v1.Event.execute_now] to
     * `false`, then you must set this field to at least 10 seconds in the future
     * or else the event can't be created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp execution_time = 10;</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setExecutionTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->execution_time = $var;

        return $this;
    }

    /**
     * Output only. The state of the event.
     *
     * Generated from protobuf field <code>.google.cloud.video.livestream.v1.Event.State state = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int
     */
    public function getState()
    {
        return $this->state;
    }

    /**
     * Output only. The state of the event.
     *
     * Generated from protobuf field <code>.google.cloud.video.livestream.v1.Event.State state = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int $var
     * @return $this
     */
    public function setState($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Video\LiveStream\V1\Event\State::class);
        $this->state = $var;

        return $this;
    }

    /**
     * Output only. An error object that describes the reason for the failure.
     * This property is always present when `state` is `FAILED`.
     *
     * Generated from protobuf field <code>.google.rpc.Status error = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Rpc\Status|null
     */
    public function getError()
    {
        return $this->error;
    }

    public function hasError()
    {
        return isset($this->error);
    }

    public function clearError()
    {
        unset($this->error);
    }

    /**
     * Output only. An error object that describes the reason for the failure.
     * This property is always present when `state` is `FAILED`.
     *
     * Generated from protobuf field <code>.google.rpc.Status error = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Rpc\Status $var
     * @return $this
     */
    public function setError($var)
    {
        GPBUtil::checkMessage($var, \Google\Rpc\Status::class);
        $this->error = $var;

        return $this;
    }

    /**
     * @return string
     */
    public function getTask()
    {
        return $this->whichOneof("task");
    }

}

