<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/aiplatform/v1/index_endpoint.proto

namespace Google\Cloud\AIPlatform\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Indexes are deployed into it. An IndexEndpoint can have multiple
 * DeployedIndexes.
 *
 * Generated from protobuf message <code>google.cloud.aiplatform.v1.IndexEndpoint</code>
 */
class IndexEndpoint extends \Google\Protobuf\Internal\Message
{
    /**
     * Output only. The resource name of the IndexEndpoint.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $name = '';
    /**
     * Required. The display name of the IndexEndpoint.
     * The name can be up to 128 characters long and can consist of any UTF-8
     * characters.
     *
     * Generated from protobuf field <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    private $display_name = '';
    /**
     * The description of the IndexEndpoint.
     *
     * Generated from protobuf field <code>string description = 3;</code>
     */
    private $description = '';
    /**
     * Output only. The indexes deployed in this endpoint.
     *
     * Generated from protobuf field <code>repeated .google.cloud.aiplatform.v1.DeployedIndex deployed_indexes = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $deployed_indexes;
    /**
     * Used to perform consistent read-modify-write updates. If not set, a blind
     * "overwrite" update happens.
     *
     * Generated from protobuf field <code>string etag = 5;</code>
     */
    private $etag = '';
    /**
     * The labels with user-defined metadata to organize your IndexEndpoints.
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     * See https://goo.gl/xmQnxf for more information and examples of labels.
     *
     * Generated from protobuf field <code>map<string, string> labels = 6;</code>
     */
    private $labels;
    /**
     * Output only. Timestamp when this IndexEndpoint was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $create_time = null;
    /**
     * Output only. Timestamp when this IndexEndpoint was last updated.
     * This timestamp is not updated when the endpoint's DeployedIndexes are
     * updated, e.g. due to updates of the original Indexes they are the
     * deployments of.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $update_time = null;
    /**
     * Optional. The full name of the Google Compute Engine
     * [network](https://cloud.google.com/compute/docs/networks-and-firewalls#networks)
     * to which the IndexEndpoint should be peered.
     * Private services access must already be configured for the network. If left
     * unspecified, the Endpoint is not peered with any network.
     * [network][google.cloud.aiplatform.v1.IndexEndpoint.network] and
     * [private_service_connect_config][google.cloud.aiplatform.v1.IndexEndpoint.private_service_connect_config]
     * are mutually exclusive.
     * [Format](https://cloud.google.com/compute/docs/reference/rest/v1/networks/insert):
     * `projects/{project}/global/networks/{network}`.
     * Where {project} is a project number, as in '12345', and {network} is
     * network name.
     *
     * Generated from protobuf field <code>string network = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $network = '';
    /**
     * Optional. Deprecated: If true, expose the IndexEndpoint via private service
     * connect.
     * Only one of the fields,
     * [network][google.cloud.aiplatform.v1.IndexEndpoint.network] or
     * [enable_private_service_connect][google.cloud.aiplatform.v1.IndexEndpoint.enable_private_service_connect],
     * can be set.
     *
     * Generated from protobuf field <code>bool enable_private_service_connect = 10 [deprecated = true, (.google.api.field_behavior) = OPTIONAL];</code>
     * @deprecated
     */
    protected $enable_private_service_connect = false;
    /**
     * Optional. Configuration for private service connect.
     * [network][google.cloud.aiplatform.v1.IndexEndpoint.network] and
     * [private_service_connect_config][google.cloud.aiplatform.v1.IndexEndpoint.private_service_connect_config]
     * are mutually exclusive.
     *
     * Generated from protobuf field <code>.google.cloud.aiplatform.v1.PrivateServiceConnectConfig private_service_connect_config = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $private_service_connect_config = null;
    /**
     * Optional. If true, the deployed index will be accessible through public
     * endpoint.
     *
     * Generated from protobuf field <code>bool public_endpoint_enabled = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $public_endpoint_enabled = false;
    /**
     * Output only. If
     * [public_endpoint_enabled][google.cloud.aiplatform.v1.IndexEndpoint.public_endpoint_enabled]
     * is true, this field will be populated with the domain name to use for this
     * index endpoint.
     *
     * Generated from protobuf field <code>string public_endpoint_domain_name = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $public_endpoint_domain_name = '';

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           Output only. The resource name of the IndexEndpoint.
     *     @type string $display_name
     *           Required. The display name of the IndexEndpoint.
     *           The name can be up to 128 characters long and can consist of any UTF-8
     *           characters.
     *     @type string $description
     *           The description of the IndexEndpoint.
     *     @type array<\Google\Cloud\AIPlatform\V1\DeployedIndex>|\Google\Protobuf\Internal\RepeatedField $deployed_indexes
     *           Output only. The indexes deployed in this endpoint.
     *     @type string $etag
     *           Used to perform consistent read-modify-write updates. If not set, a blind
     *           "overwrite" update happens.
     *     @type array|\Google\Protobuf\Internal\MapField $labels
     *           The labels with user-defined metadata to organize your IndexEndpoints.
     *           Label keys and values can be no longer than 64 characters
     *           (Unicode codepoints), can only contain lowercase letters, numeric
     *           characters, underscores and dashes. International characters are allowed.
     *           See https://goo.gl/xmQnxf for more information and examples of labels.
     *     @type \Google\Protobuf\Timestamp $create_time
     *           Output only. Timestamp when this IndexEndpoint was created.
     *     @type \Google\Protobuf\Timestamp $update_time
     *           Output only. Timestamp when this IndexEndpoint was last updated.
     *           This timestamp is not updated when the endpoint's DeployedIndexes are
     *           updated, e.g. due to updates of the original Indexes they are the
     *           deployments of.
     *     @type string $network
     *           Optional. The full name of the Google Compute Engine
     *           [network](https://cloud.google.com/compute/docs/networks-and-firewalls#networks)
     *           to which the IndexEndpoint should be peered.
     *           Private services access must already be configured for the network. If left
     *           unspecified, the Endpoint is not peered with any network.
     *           [network][google.cloud.aiplatform.v1.IndexEndpoint.network] and
     *           [private_service_connect_config][google.cloud.aiplatform.v1.IndexEndpoint.private_service_connect_config]
     *           are mutually exclusive.
     *           [Format](https://cloud.google.com/compute/docs/reference/rest/v1/networks/insert):
     *           `projects/{project}/global/networks/{network}`.
     *           Where {project} is a project number, as in '12345', and {network} is
     *           network name.
     *     @type bool $enable_private_service_connect
     *           Optional. Deprecated: If true, expose the IndexEndpoint via private service
     *           connect.
     *           Only one of the fields,
     *           [network][google.cloud.aiplatform.v1.IndexEndpoint.network] or
     *           [enable_private_service_connect][google.cloud.aiplatform.v1.IndexEndpoint.enable_private_service_connect],
     *           can be set.
     *     @type \Google\Cloud\AIPlatform\V1\PrivateServiceConnectConfig $private_service_connect_config
     *           Optional. Configuration for private service connect.
     *           [network][google.cloud.aiplatform.v1.IndexEndpoint.network] and
     *           [private_service_connect_config][google.cloud.aiplatform.v1.IndexEndpoint.private_service_connect_config]
     *           are mutually exclusive.
     *     @type bool $public_endpoint_enabled
     *           Optional. If true, the deployed index will be accessible through public
     *           endpoint.
     *     @type string $public_endpoint_domain_name
     *           Output only. If
     *           [public_endpoint_enabled][google.cloud.aiplatform.v1.IndexEndpoint.public_endpoint_enabled]
     *           is true, this field will be populated with the domain name to use for this
     *           index endpoint.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Aiplatform\V1\IndexEndpoint::initOnce();
        parent::__construct($data);
    }

    /**
     * Output only. The resource name of the IndexEndpoint.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Output only. The resource name of the IndexEndpoint.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Required. The display name of the IndexEndpoint.
     * The name can be up to 128 characters long and can consist of any UTF-8
     * characters.
     *
     * Generated from protobuf field <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getDisplayName()
    {
        return $this->display_name;
    }

    /**
     * Required. The display name of the IndexEndpoint.
     * The name can be up to 128 characters long and can consist of any UTF-8
     * characters.
     *
     * Generated from protobuf field <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setDisplayName($var)
    {
        GPBUtil::checkString($var, True);
        $this->display_name = $var;

        return $this;
    }

    /**
     * The description of the IndexEndpoint.
     *
     * Generated from protobuf field <code>string description = 3;</code>
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * The description of the IndexEndpoint.
     *
     * Generated from protobuf field <code>string description = 3;</code>
     * @param string $var
     * @return $this
     */
    public function setDescription($var)
    {
        GPBUtil::checkString($var, True);
        $this->description = $var;

        return $this;
    }

    /**
     * Output only. The indexes deployed in this endpoint.
     *
     * Generated from protobuf field <code>repeated .google.cloud.aiplatform.v1.DeployedIndex deployed_indexes = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getDeployedIndexes()
    {
        return $this->deployed_indexes;
    }

    /**
     * Output only. The indexes deployed in this endpoint.
     *
     * Generated from protobuf field <code>repeated .google.cloud.aiplatform.v1.DeployedIndex deployed_indexes = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param array<\Google\Cloud\AIPlatform\V1\DeployedIndex>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setDeployedIndexes($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\AIPlatform\V1\DeployedIndex::class);
        $this->deployed_indexes = $arr;

        return $this;
    }

    /**
     * Used to perform consistent read-modify-write updates. If not set, a blind
     * "overwrite" update happens.
     *
     * Generated from protobuf field <code>string etag = 5;</code>
     * @return string
     */
    public function getEtag()
    {
        return $this->etag;
    }

    /**
     * Used to perform consistent read-modify-write updates. If not set, a blind
     * "overwrite" update happens.
     *
     * Generated from protobuf field <code>string etag = 5;</code>
     * @param string $var
     * @return $this
     */
    public function setEtag($var)
    {
        GPBUtil::checkString($var, True);
        $this->etag = $var;

        return $this;
    }

    /**
     * The labels with user-defined metadata to organize your IndexEndpoints.
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     * See https://goo.gl/xmQnxf for more information and examples of labels.
     *
     * Generated from protobuf field <code>map<string, string> labels = 6;</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getLabels()
    {
        return $this->labels;
    }

    /**
     * The labels with user-defined metadata to organize your IndexEndpoints.
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     * See https://goo.gl/xmQnxf for more information and examples of labels.
     *
     * Generated from protobuf field <code>map<string, string> labels = 6;</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setLabels($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::STRING);
        $this->labels = $arr;

        return $this;
    }

    /**
     * Output only. Timestamp when this IndexEndpoint was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getCreateTime()
    {
        return $this->create_time;
    }

    public function hasCreateTime()
    {
        return isset($this->create_time);
    }

    public function clearCreateTime()
    {
        unset($this->create_time);
    }

    /**
     * Output only. Timestamp when this IndexEndpoint was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setCreateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->create_time = $var;

        return $this;
    }

    /**
     * Output only. Timestamp when this IndexEndpoint was last updated.
     * This timestamp is not updated when the endpoint's DeployedIndexes are
     * updated, e.g. due to updates of the original Indexes they are the
     * deployments of.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getUpdateTime()
    {
        return $this->update_time;
    }

    public function hasUpdateTime()
    {
        return isset($this->update_time);
    }

    public function clearUpdateTime()
    {
        unset($this->update_time);
    }

    /**
     * Output only. Timestamp when this IndexEndpoint was last updated.
     * This timestamp is not updated when the endpoint's DeployedIndexes are
     * updated, e.g. due to updates of the original Indexes they are the
     * deployments of.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setUpdateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->update_time = $var;

        return $this;
    }

    /**
     * Optional. The full name of the Google Compute Engine
     * [network](https://cloud.google.com/compute/docs/networks-and-firewalls#networks)
     * to which the IndexEndpoint should be peered.
     * Private services access must already be configured for the network. If left
     * unspecified, the Endpoint is not peered with any network.
     * [network][google.cloud.aiplatform.v1.IndexEndpoint.network] and
     * [private_service_connect_config][google.cloud.aiplatform.v1.IndexEndpoint.private_service_connect_config]
     * are mutually exclusive.
     * [Format](https://cloud.google.com/compute/docs/reference/rest/v1/networks/insert):
     * `projects/{project}/global/networks/{network}`.
     * Where {project} is a project number, as in '12345', and {network} is
     * network name.
     *
     * Generated from protobuf field <code>string network = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getNetwork()
    {
        return $this->network;
    }

    /**
     * Optional. The full name of the Google Compute Engine
     * [network](https://cloud.google.com/compute/docs/networks-and-firewalls#networks)
     * to which the IndexEndpoint should be peered.
     * Private services access must already be configured for the network. If left
     * unspecified, the Endpoint is not peered with any network.
     * [network][google.cloud.aiplatform.v1.IndexEndpoint.network] and
     * [private_service_connect_config][google.cloud.aiplatform.v1.IndexEndpoint.private_service_connect_config]
     * are mutually exclusive.
     * [Format](https://cloud.google.com/compute/docs/reference/rest/v1/networks/insert):
     * `projects/{project}/global/networks/{network}`.
     * Where {project} is a project number, as in '12345', and {network} is
     * network name.
     *
     * Generated from protobuf field <code>string network = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setNetwork($var)
    {
        GPBUtil::checkString($var, True);
        $this->network = $var;

        return $this;
    }

    /**
     * Optional. Deprecated: If true, expose the IndexEndpoint via private service
     * connect.
     * Only one of the fields,
     * [network][google.cloud.aiplatform.v1.IndexEndpoint.network] or
     * [enable_private_service_connect][google.cloud.aiplatform.v1.IndexEndpoint.enable_private_service_connect],
     * can be set.
     *
     * Generated from protobuf field <code>bool enable_private_service_connect = 10 [deprecated = true, (.google.api.field_behavior) = OPTIONAL];</code>
     * @return bool
     * @deprecated
     */
    public function getEnablePrivateServiceConnect()
    {
        @trigger_error('enable_private_service_connect is deprecated.', E_USER_DEPRECATED);
        return $this->enable_private_service_connect;
    }

    /**
     * Optional. Deprecated: If true, expose the IndexEndpoint via private service
     * connect.
     * Only one of the fields,
     * [network][google.cloud.aiplatform.v1.IndexEndpoint.network] or
     * [enable_private_service_connect][google.cloud.aiplatform.v1.IndexEndpoint.enable_private_service_connect],
     * can be set.
     *
     * Generated from protobuf field <code>bool enable_private_service_connect = 10 [deprecated = true, (.google.api.field_behavior) = OPTIONAL];</code>
     * @param bool $var
     * @return $this
     * @deprecated
     */
    public function setEnablePrivateServiceConnect($var)
    {
        @trigger_error('enable_private_service_connect is deprecated.', E_USER_DEPRECATED);
        GPBUtil::checkBool($var);
        $this->enable_private_service_connect = $var;

        return $this;
    }

    /**
     * Optional. Configuration for private service connect.
     * [network][google.cloud.aiplatform.v1.IndexEndpoint.network] and
     * [private_service_connect_config][google.cloud.aiplatform.v1.IndexEndpoint.private_service_connect_config]
     * are mutually exclusive.
     *
     * Generated from protobuf field <code>.google.cloud.aiplatform.v1.PrivateServiceConnectConfig private_service_connect_config = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\AIPlatform\V1\PrivateServiceConnectConfig|null
     */
    public function getPrivateServiceConnectConfig()
    {
        return $this->private_service_connect_config;
    }

    public function hasPrivateServiceConnectConfig()
    {
        return isset($this->private_service_connect_config);
    }

    public function clearPrivateServiceConnectConfig()
    {
        unset($this->private_service_connect_config);
    }

    /**
     * Optional. Configuration for private service connect.
     * [network][google.cloud.aiplatform.v1.IndexEndpoint.network] and
     * [private_service_connect_config][google.cloud.aiplatform.v1.IndexEndpoint.private_service_connect_config]
     * are mutually exclusive.
     *
     * Generated from protobuf field <code>.google.cloud.aiplatform.v1.PrivateServiceConnectConfig private_service_connect_config = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\AIPlatform\V1\PrivateServiceConnectConfig $var
     * @return $this
     */
    public function setPrivateServiceConnectConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\AIPlatform\V1\PrivateServiceConnectConfig::class);
        $this->private_service_connect_config = $var;

        return $this;
    }

    /**
     * Optional. If true, the deployed index will be accessible through public
     * endpoint.
     *
     * Generated from protobuf field <code>bool public_endpoint_enabled = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return bool
     */
    public function getPublicEndpointEnabled()
    {
        return $this->public_endpoint_enabled;
    }

    /**
     * Optional. If true, the deployed index will be accessible through public
     * endpoint.
     *
     * Generated from protobuf field <code>bool public_endpoint_enabled = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param bool $var
     * @return $this
     */
    public function setPublicEndpointEnabled($var)
    {
        GPBUtil::checkBool($var);
        $this->public_endpoint_enabled = $var;

        return $this;
    }

    /**
     * Output only. If
     * [public_endpoint_enabled][google.cloud.aiplatform.v1.IndexEndpoint.public_endpoint_enabled]
     * is true, this field will be populated with the domain name to use for this
     * index endpoint.
     *
     * Generated from protobuf field <code>string public_endpoint_domain_name = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getPublicEndpointDomainName()
    {
        return $this->public_endpoint_domain_name;
    }

    /**
     * Output only. If
     * [public_endpoint_enabled][google.cloud.aiplatform.v1.IndexEndpoint.public_endpoint_enabled]
     * is true, this field will be populated with the domain name to use for this
     * index endpoint.
     *
     * Generated from protobuf field <code>string public_endpoint_domain_name = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setPublicEndpointDomainName($var)
    {
        GPBUtil::checkString($var, True);
        $this->public_endpoint_domain_name = $var;

        return $this;
    }

}

