<?php
/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/vmmigration/v1/vmmigration.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\VMMigration\V1\Client;

use Google\ApiCore\ApiException;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\OperationResponse;
use Google\ApiCore\PagedListResponse;
use Google\ApiCore\ResourceHelperTrait;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\Location\GetLocationRequest;
use Google\Cloud\Location\ListLocationsRequest;
use Google\Cloud\Location\Location;
use Google\Cloud\VMMigration\V1\AddGroupMigrationRequest;
use Google\Cloud\VMMigration\V1\CancelCloneJobRequest;
use Google\Cloud\VMMigration\V1\CancelCutoverJobRequest;
use Google\Cloud\VMMigration\V1\CloneJob;
use Google\Cloud\VMMigration\V1\CreateCloneJobRequest;
use Google\Cloud\VMMigration\V1\CreateCutoverJobRequest;
use Google\Cloud\VMMigration\V1\CreateDatacenterConnectorRequest;
use Google\Cloud\VMMigration\V1\CreateGroupRequest;
use Google\Cloud\VMMigration\V1\CreateMigratingVmRequest;
use Google\Cloud\VMMigration\V1\CreateSourceRequest;
use Google\Cloud\VMMigration\V1\CreateTargetProjectRequest;
use Google\Cloud\VMMigration\V1\CreateUtilizationReportRequest;
use Google\Cloud\VMMigration\V1\CutoverJob;
use Google\Cloud\VMMigration\V1\DatacenterConnector;
use Google\Cloud\VMMigration\V1\DeleteDatacenterConnectorRequest;
use Google\Cloud\VMMigration\V1\DeleteGroupRequest;
use Google\Cloud\VMMigration\V1\DeleteMigratingVmRequest;
use Google\Cloud\VMMigration\V1\DeleteSourceRequest;
use Google\Cloud\VMMigration\V1\DeleteTargetProjectRequest;
use Google\Cloud\VMMigration\V1\DeleteUtilizationReportRequest;
use Google\Cloud\VMMigration\V1\FetchInventoryRequest;
use Google\Cloud\VMMigration\V1\FetchInventoryResponse;
use Google\Cloud\VMMigration\V1\FinalizeMigrationRequest;
use Google\Cloud\VMMigration\V1\GetCloneJobRequest;
use Google\Cloud\VMMigration\V1\GetCutoverJobRequest;
use Google\Cloud\VMMigration\V1\GetDatacenterConnectorRequest;
use Google\Cloud\VMMigration\V1\GetGroupRequest;
use Google\Cloud\VMMigration\V1\GetMigratingVmRequest;
use Google\Cloud\VMMigration\V1\GetReplicationCycleRequest;
use Google\Cloud\VMMigration\V1\GetSourceRequest;
use Google\Cloud\VMMigration\V1\GetTargetProjectRequest;
use Google\Cloud\VMMigration\V1\GetUtilizationReportRequest;
use Google\Cloud\VMMigration\V1\Group;
use Google\Cloud\VMMigration\V1\ListCloneJobsRequest;
use Google\Cloud\VMMigration\V1\ListCutoverJobsRequest;
use Google\Cloud\VMMigration\V1\ListDatacenterConnectorsRequest;
use Google\Cloud\VMMigration\V1\ListGroupsRequest;
use Google\Cloud\VMMigration\V1\ListMigratingVmsRequest;
use Google\Cloud\VMMigration\V1\ListReplicationCyclesRequest;
use Google\Cloud\VMMigration\V1\ListSourcesRequest;
use Google\Cloud\VMMigration\V1\ListTargetProjectsRequest;
use Google\Cloud\VMMigration\V1\ListUtilizationReportsRequest;
use Google\Cloud\VMMigration\V1\MigratingVm;
use Google\Cloud\VMMigration\V1\PauseMigrationRequest;
use Google\Cloud\VMMigration\V1\RemoveGroupMigrationRequest;
use Google\Cloud\VMMigration\V1\ReplicationCycle;
use Google\Cloud\VMMigration\V1\ResumeMigrationRequest;
use Google\Cloud\VMMigration\V1\Source;
use Google\Cloud\VMMigration\V1\StartMigrationRequest;
use Google\Cloud\VMMigration\V1\TargetProject;
use Google\Cloud\VMMigration\V1\UpdateGroupRequest;
use Google\Cloud\VMMigration\V1\UpdateMigratingVmRequest;
use Google\Cloud\VMMigration\V1\UpdateSourceRequest;
use Google\Cloud\VMMigration\V1\UpdateTargetProjectRequest;
use Google\Cloud\VMMigration\V1\UpgradeApplianceRequest;
use Google\Cloud\VMMigration\V1\UtilizationReport;
use Google\LongRunning\Client\OperationsClient;
use Google\LongRunning\Operation;
use GuzzleHttp\Promise\PromiseInterface;
use Psr\Log\LoggerInterface;

/**
 * Service Description: VM Migration Service
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods.
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 *
 * @method PromiseInterface<OperationResponse> addGroupMigrationAsync(AddGroupMigrationRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> cancelCloneJobAsync(CancelCloneJobRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> cancelCutoverJobAsync(CancelCutoverJobRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> createCloneJobAsync(CreateCloneJobRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> createCutoverJobAsync(CreateCutoverJobRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> createDatacenterConnectorAsync(CreateDatacenterConnectorRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> createGroupAsync(CreateGroupRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> createMigratingVmAsync(CreateMigratingVmRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> createSourceAsync(CreateSourceRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> createTargetProjectAsync(CreateTargetProjectRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> createUtilizationReportAsync(CreateUtilizationReportRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> deleteDatacenterConnectorAsync(DeleteDatacenterConnectorRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> deleteGroupAsync(DeleteGroupRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> deleteMigratingVmAsync(DeleteMigratingVmRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> deleteSourceAsync(DeleteSourceRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> deleteTargetProjectAsync(DeleteTargetProjectRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> deleteUtilizationReportAsync(DeleteUtilizationReportRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<FetchInventoryResponse> fetchInventoryAsync(FetchInventoryRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> finalizeMigrationAsync(FinalizeMigrationRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<CloneJob> getCloneJobAsync(GetCloneJobRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<CutoverJob> getCutoverJobAsync(GetCutoverJobRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<DatacenterConnector> getDatacenterConnectorAsync(GetDatacenterConnectorRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Group> getGroupAsync(GetGroupRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<MigratingVm> getMigratingVmAsync(GetMigratingVmRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<ReplicationCycle> getReplicationCycleAsync(GetReplicationCycleRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Source> getSourceAsync(GetSourceRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<TargetProject> getTargetProjectAsync(GetTargetProjectRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<UtilizationReport> getUtilizationReportAsync(GetUtilizationReportRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listCloneJobsAsync(ListCloneJobsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listCutoverJobsAsync(ListCutoverJobsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listDatacenterConnectorsAsync(ListDatacenterConnectorsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listGroupsAsync(ListGroupsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listMigratingVmsAsync(ListMigratingVmsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listReplicationCyclesAsync(ListReplicationCyclesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listSourcesAsync(ListSourcesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listTargetProjectsAsync(ListTargetProjectsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listUtilizationReportsAsync(ListUtilizationReportsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> pauseMigrationAsync(PauseMigrationRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> removeGroupMigrationAsync(RemoveGroupMigrationRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> resumeMigrationAsync(ResumeMigrationRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> startMigrationAsync(StartMigrationRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> updateGroupAsync(UpdateGroupRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> updateMigratingVmAsync(UpdateMigratingVmRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> updateSourceAsync(UpdateSourceRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> updateTargetProjectAsync(UpdateTargetProjectRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> upgradeApplianceAsync(UpgradeApplianceRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Location> getLocationAsync(GetLocationRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listLocationsAsync(ListLocationsRequest $request, array $optionalArgs = [])
 */
final class VmMigrationClient
{
    use GapicClientTrait;
    use ResourceHelperTrait;

    /** The name of the service. */
    private const SERVICE_NAME = 'google.cloud.vmmigration.v1.VmMigration';

    /**
     * The default address of the service.
     *
     * @deprecated SERVICE_ADDRESS_TEMPLATE should be used instead.
     */
    private const SERVICE_ADDRESS = 'vmmigration.googleapis.com';

    /** The address template of the service. */
    private const SERVICE_ADDRESS_TEMPLATE = 'vmmigration.UNIVERSE_DOMAIN';

    /** The default port of the service. */
    private const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    private const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = ['https://www.googleapis.com/auth/cloud-platform'];

    private $operationsClient;

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' => self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' => __DIR__ . '/../resources/vm_migration_client_config.json',
            'descriptorsConfigPath' => __DIR__ . '/../resources/vm_migration_descriptor_config.php',
            'gcpApiConfigPath' => __DIR__ . '/../resources/vm_migration_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' => __DIR__ . '/../resources/vm_migration_rest_client_config.php',
                ],
            ],
        ];
    }

    /**
     * Return an OperationsClient object with the same endpoint as $this.
     *
     * @return OperationsClient
     */
    public function getOperationsClient()
    {
        return $this->operationsClient;
    }

    /**
     * Resume an existing long running operation that was previously started by a long
     * running API method. If $methodName is not provided, or does not match a long
     * running API method, then the operation can still be resumed, but the
     * OperationResponse object will not deserialize the final response.
     *
     * @param string $operationName The name of the long running operation
     * @param string $methodName    The name of the method used to start the operation
     *
     * @return OperationResponse
     */
    public function resumeOperation($operationName, $methodName = null)
    {
        $options = isset($this->descriptors[$methodName]['longRunning'])
            ? $this->descriptors[$methodName]['longRunning']
            : [];
        $operation = new OperationResponse($operationName, $this->getOperationsClient(), $options);
        $operation->reload();
        return $operation;
    }

    /**
     * Create the default operation client for the service.
     *
     * @param array $options ClientOptions for the client.
     *
     * @return OperationsClient
     */
    private function createOperationsClient(array $options)
    {
        // Unset client-specific configuration options
        unset($options['serviceName'], $options['clientConfig'], $options['descriptorsConfigPath']);

        if (isset($options['operationsClient'])) {
            return $options['operationsClient'];
        }

        return new OperationsClient($options);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a clone_job
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $source
     * @param string $migratingVm
     * @param string $cloneJob
     *
     * @return string The formatted clone_job resource.
     */
    public static function cloneJobName(
        string $project,
        string $location,
        string $source,
        string $migratingVm,
        string $cloneJob
    ): string {
        return self::getPathTemplate('cloneJob')->render([
            'project' => $project,
            'location' => $location,
            'source' => $source,
            'migrating_vm' => $migratingVm,
            'clone_job' => $cloneJob,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a cutover_job
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $source
     * @param string $migratingVm
     * @param string $cutoverJob
     *
     * @return string The formatted cutover_job resource.
     */
    public static function cutoverJobName(
        string $project,
        string $location,
        string $source,
        string $migratingVm,
        string $cutoverJob
    ): string {
        return self::getPathTemplate('cutoverJob')->render([
            'project' => $project,
            'location' => $location,
            'source' => $source,
            'migrating_vm' => $migratingVm,
            'cutover_job' => $cutoverJob,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * datacenter_connector resource.
     *
     * @param string $project
     * @param string $location
     * @param string $source
     * @param string $datacenterConnector
     *
     * @return string The formatted datacenter_connector resource.
     */
    public static function datacenterConnectorName(
        string $project,
        string $location,
        string $source,
        string $datacenterConnector
    ): string {
        return self::getPathTemplate('datacenterConnector')->render([
            'project' => $project,
            'location' => $location,
            'source' => $source,
            'datacenter_connector' => $datacenterConnector,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a group
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $group
     *
     * @return string The formatted group resource.
     */
    public static function groupName(string $project, string $location, string $group): string
    {
        return self::getPathTemplate('group')->render([
            'project' => $project,
            'location' => $location,
            'group' => $group,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a location
     * resource.
     *
     * @param string $project
     * @param string $location
     *
     * @return string The formatted location resource.
     */
    public static function locationName(string $project, string $location): string
    {
        return self::getPathTemplate('location')->render([
            'project' => $project,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a migrating_vm
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $source
     * @param string $migratingVm
     *
     * @return string The formatted migrating_vm resource.
     */
    public static function migratingVmName(
        string $project,
        string $location,
        string $source,
        string $migratingVm
    ): string {
        return self::getPathTemplate('migratingVm')->render([
            'project' => $project,
            'location' => $location,
            'source' => $source,
            'migrating_vm' => $migratingVm,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * replication_cycle resource.
     *
     * @param string $project
     * @param string $location
     * @param string $source
     * @param string $migratingVm
     * @param string $replicationCycle
     *
     * @return string The formatted replication_cycle resource.
     */
    public static function replicationCycleName(
        string $project,
        string $location,
        string $source,
        string $migratingVm,
        string $replicationCycle
    ): string {
        return self::getPathTemplate('replicationCycle')->render([
            'project' => $project,
            'location' => $location,
            'source' => $source,
            'migrating_vm' => $migratingVm,
            'replication_cycle' => $replicationCycle,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a source
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $source
     *
     * @return string The formatted source resource.
     */
    public static function sourceName(string $project, string $location, string $source): string
    {
        return self::getPathTemplate('source')->render([
            'project' => $project,
            'location' => $location,
            'source' => $source,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * target_project resource.
     *
     * @param string $project
     * @param string $location
     * @param string $targetProject
     *
     * @return string The formatted target_project resource.
     */
    public static function targetProjectName(string $project, string $location, string $targetProject): string
    {
        return self::getPathTemplate('targetProject')->render([
            'project' => $project,
            'location' => $location,
            'target_project' => $targetProject,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * utilization_report resource.
     *
     * @param string $project
     * @param string $location
     * @param string $source
     * @param string $utilizationReport
     *
     * @return string The formatted utilization_report resource.
     */
    public static function utilizationReportName(
        string $project,
        string $location,
        string $source,
        string $utilizationReport
    ): string {
        return self::getPathTemplate('utilizationReport')->render([
            'project' => $project,
            'location' => $location,
            'source' => $source,
            'utilization_report' => $utilizationReport,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - cloneJob: projects/{project}/locations/{location}/sources/{source}/migratingVms/{migrating_vm}/cloneJobs/{clone_job}
     * - cutoverJob: projects/{project}/locations/{location}/sources/{source}/migratingVms/{migrating_vm}/cutoverJobs/{cutover_job}
     * - datacenterConnector: projects/{project}/locations/{location}/sources/{source}/datacenterConnectors/{datacenter_connector}
     * - group: projects/{project}/locations/{location}/groups/{group}
     * - location: projects/{project}/locations/{location}
     * - migratingVm: projects/{project}/locations/{location}/sources/{source}/migratingVms/{migrating_vm}
     * - replicationCycle: projects/{project}/locations/{location}/sources/{source}/migratingVms/{migrating_vm}/replicationCycles/{replication_cycle}
     * - source: projects/{project}/locations/{location}/sources/{source}
     * - targetProject: projects/{project}/locations/{location}/targetProjects/{target_project}
     * - utilizationReport: projects/{project}/locations/{location}/sources/{source}/utilizationReports/{utilization_report}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string  $formattedName The formatted name string
     * @param ?string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName(string $formattedName, ?string $template = null): array
    {
        return self::parseFormattedName($formattedName, $template);
    }

    /**
     * Constructor.
     *
     * @param array $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'vmmigration.googleapis.com:443'.
     *     @type string|array|FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           The credentials to be used by the client to authorize API calls. This option
     *           accepts either a path to a credentials file, or a decoded credentials file as a
     *           PHP array.
     *           *Advanced usage*: In addition, this option can also accept a pre-constructed
     *           {@see \Google\Auth\FetchAuthTokenInterface} object or
     *           {@see \Google\ApiCore\CredentialsWrapper} object. Note that when one of these
     *           objects are provided, any settings in $credentialsConfig will be ignored.
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     *     @type false|LoggerInterface $logger
     *           A PSR-3 compliant logger. If set to false, logging is disabled, ignoring the
     *           'GOOGLE_SDK_PHP_LOGGING' environment flag
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
        $this->operationsClient = $this->createOperationsClient($clientOptions);
    }

    /** Handles execution of the async variants for each documented method. */
    public function __call($method, $args)
    {
        if (substr($method, -5) !== 'Async') {
            trigger_error('Call to undefined method ' . __CLASS__ . "::$method()", E_USER_ERROR);
        }

        array_unshift($args, substr($method, 0, -5));
        return call_user_func_array([$this, 'startAsyncCall'], $args);
    }

    /**
     * Adds a MigratingVm to a Group.
     *
     * The async variant is {@see VmMigrationClient::addGroupMigrationAsync()} .
     *
     * @example samples/V1/VmMigrationClient/add_group_migration.php
     *
     * @param AddGroupMigrationRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function addGroupMigration(AddGroupMigrationRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('AddGroupMigration', $request, $callOptions)->wait();
    }

    /**
     * Initiates the cancellation of a running clone job.
     *
     * The async variant is {@see VmMigrationClient::cancelCloneJobAsync()} .
     *
     * @example samples/V1/VmMigrationClient/cancel_clone_job.php
     *
     * @param CancelCloneJobRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function cancelCloneJob(CancelCloneJobRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CancelCloneJob', $request, $callOptions)->wait();
    }

    /**
     * Initiates the cancellation of a running cutover job.
     *
     * The async variant is {@see VmMigrationClient::cancelCutoverJobAsync()} .
     *
     * @example samples/V1/VmMigrationClient/cancel_cutover_job.php
     *
     * @param CancelCutoverJobRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function cancelCutoverJob(CancelCutoverJobRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CancelCutoverJob', $request, $callOptions)->wait();
    }

    /**
     * Initiates a Clone of a specific migrating VM.
     *
     * The async variant is {@see VmMigrationClient::createCloneJobAsync()} .
     *
     * @example samples/V1/VmMigrationClient/create_clone_job.php
     *
     * @param CreateCloneJobRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createCloneJob(CreateCloneJobRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreateCloneJob', $request, $callOptions)->wait();
    }

    /**
     * Initiates a Cutover of a specific migrating VM.
     * The returned LRO is completed when the cutover job resource is created
     * and the job is initiated.
     *
     * The async variant is {@see VmMigrationClient::createCutoverJobAsync()} .
     *
     * @example samples/V1/VmMigrationClient/create_cutover_job.php
     *
     * @param CreateCutoverJobRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createCutoverJob(CreateCutoverJobRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreateCutoverJob', $request, $callOptions)->wait();
    }

    /**
     * Creates a new DatacenterConnector in a given Source.
     *
     * The async variant is {@see VmMigrationClient::createDatacenterConnectorAsync()}
     * .
     *
     * @example samples/V1/VmMigrationClient/create_datacenter_connector.php
     *
     * @param CreateDatacenterConnectorRequest $request     A request to house fields associated with the call.
     * @param array                            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createDatacenterConnector(
        CreateDatacenterConnectorRequest $request,
        array $callOptions = []
    ): OperationResponse {
        return $this->startApiCall('CreateDatacenterConnector', $request, $callOptions)->wait();
    }

    /**
     * Creates a new Group in a given project and location.
     *
     * The async variant is {@see VmMigrationClient::createGroupAsync()} .
     *
     * @example samples/V1/VmMigrationClient/create_group.php
     *
     * @param CreateGroupRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createGroup(CreateGroupRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreateGroup', $request, $callOptions)->wait();
    }

    /**
     * Creates a new MigratingVm in a given Source.
     *
     * The async variant is {@see VmMigrationClient::createMigratingVmAsync()} .
     *
     * @example samples/V1/VmMigrationClient/create_migrating_vm.php
     *
     * @param CreateMigratingVmRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createMigratingVm(CreateMigratingVmRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreateMigratingVm', $request, $callOptions)->wait();
    }

    /**
     * Creates a new Source in a given project and location.
     *
     * The async variant is {@see VmMigrationClient::createSourceAsync()} .
     *
     * @example samples/V1/VmMigrationClient/create_source.php
     *
     * @param CreateSourceRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createSource(CreateSourceRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreateSource', $request, $callOptions)->wait();
    }

    /**
     * Creates a new TargetProject in a given project.
     *
     * NOTE: TargetProject is a global resource; hence the only supported value
     * for location is `global`.
     *
     * The async variant is {@see VmMigrationClient::createTargetProjectAsync()} .
     *
     * @example samples/V1/VmMigrationClient/create_target_project.php
     *
     * @param CreateTargetProjectRequest $request     A request to house fields associated with the call.
     * @param array                      $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createTargetProject(CreateTargetProjectRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreateTargetProject', $request, $callOptions)->wait();
    }

    /**
     * Creates a new UtilizationReport.
     *
     * The async variant is {@see VmMigrationClient::createUtilizationReportAsync()} .
     *
     * @example samples/V1/VmMigrationClient/create_utilization_report.php
     *
     * @param CreateUtilizationReportRequest $request     A request to house fields associated with the call.
     * @param array                          $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createUtilizationReport(
        CreateUtilizationReportRequest $request,
        array $callOptions = []
    ): OperationResponse {
        return $this->startApiCall('CreateUtilizationReport', $request, $callOptions)->wait();
    }

    /**
     * Deletes a single DatacenterConnector.
     *
     * The async variant is {@see VmMigrationClient::deleteDatacenterConnectorAsync()}
     * .
     *
     * @example samples/V1/VmMigrationClient/delete_datacenter_connector.php
     *
     * @param DeleteDatacenterConnectorRequest $request     A request to house fields associated with the call.
     * @param array                            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteDatacenterConnector(
        DeleteDatacenterConnectorRequest $request,
        array $callOptions = []
    ): OperationResponse {
        return $this->startApiCall('DeleteDatacenterConnector', $request, $callOptions)->wait();
    }

    /**
     * Deletes a single Group.
     *
     * The async variant is {@see VmMigrationClient::deleteGroupAsync()} .
     *
     * @example samples/V1/VmMigrationClient/delete_group.php
     *
     * @param DeleteGroupRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteGroup(DeleteGroupRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeleteGroup', $request, $callOptions)->wait();
    }

    /**
     * Deletes a single MigratingVm.
     *
     * The async variant is {@see VmMigrationClient::deleteMigratingVmAsync()} .
     *
     * @example samples/V1/VmMigrationClient/delete_migrating_vm.php
     *
     * @param DeleteMigratingVmRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteMigratingVm(DeleteMigratingVmRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeleteMigratingVm', $request, $callOptions)->wait();
    }

    /**
     * Deletes a single Source.
     *
     * The async variant is {@see VmMigrationClient::deleteSourceAsync()} .
     *
     * @example samples/V1/VmMigrationClient/delete_source.php
     *
     * @param DeleteSourceRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteSource(DeleteSourceRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeleteSource', $request, $callOptions)->wait();
    }

    /**
     * Deletes a single TargetProject.
     *
     * NOTE: TargetProject is a global resource; hence the only supported value
     * for location is `global`.
     *
     * The async variant is {@see VmMigrationClient::deleteTargetProjectAsync()} .
     *
     * @example samples/V1/VmMigrationClient/delete_target_project.php
     *
     * @param DeleteTargetProjectRequest $request     A request to house fields associated with the call.
     * @param array                      $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteTargetProject(DeleteTargetProjectRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeleteTargetProject', $request, $callOptions)->wait();
    }

    /**
     * Deletes a single Utilization Report.
     *
     * The async variant is {@see VmMigrationClient::deleteUtilizationReportAsync()} .
     *
     * @example samples/V1/VmMigrationClient/delete_utilization_report.php
     *
     * @param DeleteUtilizationReportRequest $request     A request to house fields associated with the call.
     * @param array                          $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteUtilizationReport(
        DeleteUtilizationReportRequest $request,
        array $callOptions = []
    ): OperationResponse {
        return $this->startApiCall('DeleteUtilizationReport', $request, $callOptions)->wait();
    }

    /**
     * List remote source's inventory of VMs.
     * The remote source is the onprem vCenter (remote in the sense it's not in
     * Compute Engine). The inventory describes the list of existing VMs in that
     * source. Note that this operation lists the VMs on the remote source, as
     * opposed to listing the MigratingVms resources in the vmmigration service.
     *
     * The async variant is {@see VmMigrationClient::fetchInventoryAsync()} .
     *
     * @example samples/V1/VmMigrationClient/fetch_inventory.php
     *
     * @param FetchInventoryRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return FetchInventoryResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function fetchInventory(FetchInventoryRequest $request, array $callOptions = []): FetchInventoryResponse
    {
        return $this->startApiCall('FetchInventory', $request, $callOptions)->wait();
    }

    /**
     * Marks a migration as completed, deleting migration resources that are no
     * longer being used. Only applicable after cutover is done.
     *
     * The async variant is {@see VmMigrationClient::finalizeMigrationAsync()} .
     *
     * @example samples/V1/VmMigrationClient/finalize_migration.php
     *
     * @param FinalizeMigrationRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function finalizeMigration(FinalizeMigrationRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('FinalizeMigration', $request, $callOptions)->wait();
    }

    /**
     * Gets details of a single CloneJob.
     *
     * The async variant is {@see VmMigrationClient::getCloneJobAsync()} .
     *
     * @example samples/V1/VmMigrationClient/get_clone_job.php
     *
     * @param GetCloneJobRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return CloneJob
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getCloneJob(GetCloneJobRequest $request, array $callOptions = []): CloneJob
    {
        return $this->startApiCall('GetCloneJob', $request, $callOptions)->wait();
    }

    /**
     * Gets details of a single CutoverJob.
     *
     * The async variant is {@see VmMigrationClient::getCutoverJobAsync()} .
     *
     * @example samples/V1/VmMigrationClient/get_cutover_job.php
     *
     * @param GetCutoverJobRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return CutoverJob
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getCutoverJob(GetCutoverJobRequest $request, array $callOptions = []): CutoverJob
    {
        return $this->startApiCall('GetCutoverJob', $request, $callOptions)->wait();
    }

    /**
     * Gets details of a single DatacenterConnector.
     *
     * The async variant is {@see VmMigrationClient::getDatacenterConnectorAsync()} .
     *
     * @example samples/V1/VmMigrationClient/get_datacenter_connector.php
     *
     * @param GetDatacenterConnectorRequest $request     A request to house fields associated with the call.
     * @param array                         $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return DatacenterConnector
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getDatacenterConnector(
        GetDatacenterConnectorRequest $request,
        array $callOptions = []
    ): DatacenterConnector {
        return $this->startApiCall('GetDatacenterConnector', $request, $callOptions)->wait();
    }

    /**
     * Gets details of a single Group.
     *
     * The async variant is {@see VmMigrationClient::getGroupAsync()} .
     *
     * @example samples/V1/VmMigrationClient/get_group.php
     *
     * @param GetGroupRequest $request     A request to house fields associated with the call.
     * @param array           $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Group
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getGroup(GetGroupRequest $request, array $callOptions = []): Group
    {
        return $this->startApiCall('GetGroup', $request, $callOptions)->wait();
    }

    /**
     * Gets details of a single MigratingVm.
     *
     * The async variant is {@see VmMigrationClient::getMigratingVmAsync()} .
     *
     * @example samples/V1/VmMigrationClient/get_migrating_vm.php
     *
     * @param GetMigratingVmRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return MigratingVm
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getMigratingVm(GetMigratingVmRequest $request, array $callOptions = []): MigratingVm
    {
        return $this->startApiCall('GetMigratingVm', $request, $callOptions)->wait();
    }

    /**
     * Gets details of a single ReplicationCycle.
     *
     * The async variant is {@see VmMigrationClient::getReplicationCycleAsync()} .
     *
     * @example samples/V1/VmMigrationClient/get_replication_cycle.php
     *
     * @param GetReplicationCycleRequest $request     A request to house fields associated with the call.
     * @param array                      $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return ReplicationCycle
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getReplicationCycle(GetReplicationCycleRequest $request, array $callOptions = []): ReplicationCycle
    {
        return $this->startApiCall('GetReplicationCycle', $request, $callOptions)->wait();
    }

    /**
     * Gets details of a single Source.
     *
     * The async variant is {@see VmMigrationClient::getSourceAsync()} .
     *
     * @example samples/V1/VmMigrationClient/get_source.php
     *
     * @param GetSourceRequest $request     A request to house fields associated with the call.
     * @param array            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Source
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getSource(GetSourceRequest $request, array $callOptions = []): Source
    {
        return $this->startApiCall('GetSource', $request, $callOptions)->wait();
    }

    /**
     * Gets details of a single TargetProject.
     *
     * NOTE: TargetProject is a global resource; hence the only supported value
     * for location is `global`.
     *
     * The async variant is {@see VmMigrationClient::getTargetProjectAsync()} .
     *
     * @example samples/V1/VmMigrationClient/get_target_project.php
     *
     * @param GetTargetProjectRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return TargetProject
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getTargetProject(GetTargetProjectRequest $request, array $callOptions = []): TargetProject
    {
        return $this->startApiCall('GetTargetProject', $request, $callOptions)->wait();
    }

    /**
     * Gets a single Utilization Report.
     *
     * The async variant is {@see VmMigrationClient::getUtilizationReportAsync()} .
     *
     * @example samples/V1/VmMigrationClient/get_utilization_report.php
     *
     * @param GetUtilizationReportRequest $request     A request to house fields associated with the call.
     * @param array                       $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return UtilizationReport
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getUtilizationReport(
        GetUtilizationReportRequest $request,
        array $callOptions = []
    ): UtilizationReport {
        return $this->startApiCall('GetUtilizationReport', $request, $callOptions)->wait();
    }

    /**
     * Lists CloneJobs of a given migrating VM.
     *
     * The async variant is {@see VmMigrationClient::listCloneJobsAsync()} .
     *
     * @example samples/V1/VmMigrationClient/list_clone_jobs.php
     *
     * @param ListCloneJobsRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listCloneJobs(ListCloneJobsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListCloneJobs', $request, $callOptions);
    }

    /**
     * Lists CutoverJobs of a given migrating VM.
     *
     * The async variant is {@see VmMigrationClient::listCutoverJobsAsync()} .
     *
     * @example samples/V1/VmMigrationClient/list_cutover_jobs.php
     *
     * @param ListCutoverJobsRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listCutoverJobs(ListCutoverJobsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListCutoverJobs', $request, $callOptions);
    }

    /**
     * Lists DatacenterConnectors in a given Source.
     *
     * The async variant is {@see VmMigrationClient::listDatacenterConnectorsAsync()} .
     *
     * @example samples/V1/VmMigrationClient/list_datacenter_connectors.php
     *
     * @param ListDatacenterConnectorsRequest $request     A request to house fields associated with the call.
     * @param array                           $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listDatacenterConnectors(
        ListDatacenterConnectorsRequest $request,
        array $callOptions = []
    ): PagedListResponse {
        return $this->startApiCall('ListDatacenterConnectors', $request, $callOptions);
    }

    /**
     * Lists Groups in a given project and location.
     *
     * The async variant is {@see VmMigrationClient::listGroupsAsync()} .
     *
     * @example samples/V1/VmMigrationClient/list_groups.php
     *
     * @param ListGroupsRequest $request     A request to house fields associated with the call.
     * @param array             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listGroups(ListGroupsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListGroups', $request, $callOptions);
    }

    /**
     * Lists MigratingVms in a given Source.
     *
     * The async variant is {@see VmMigrationClient::listMigratingVmsAsync()} .
     *
     * @example samples/V1/VmMigrationClient/list_migrating_vms.php
     *
     * @param ListMigratingVmsRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listMigratingVms(ListMigratingVmsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListMigratingVms', $request, $callOptions);
    }

    /**
     * Lists ReplicationCycles in a given MigratingVM.
     *
     * The async variant is {@see VmMigrationClient::listReplicationCyclesAsync()} .
     *
     * @example samples/V1/VmMigrationClient/list_replication_cycles.php
     *
     * @param ListReplicationCyclesRequest $request     A request to house fields associated with the call.
     * @param array                        $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listReplicationCycles(
        ListReplicationCyclesRequest $request,
        array $callOptions = []
    ): PagedListResponse {
        return $this->startApiCall('ListReplicationCycles', $request, $callOptions);
    }

    /**
     * Lists Sources in a given project and location.
     *
     * The async variant is {@see VmMigrationClient::listSourcesAsync()} .
     *
     * @example samples/V1/VmMigrationClient/list_sources.php
     *
     * @param ListSourcesRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listSources(ListSourcesRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListSources', $request, $callOptions);
    }

    /**
     * Lists TargetProjects in a given project.
     *
     * NOTE: TargetProject is a global resource; hence the only supported value
     * for location is `global`.
     *
     * The async variant is {@see VmMigrationClient::listTargetProjectsAsync()} .
     *
     * @example samples/V1/VmMigrationClient/list_target_projects.php
     *
     * @param ListTargetProjectsRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listTargetProjects(ListTargetProjectsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListTargetProjects', $request, $callOptions);
    }

    /**
     * Lists Utilization Reports of the given Source.
     *
     * The async variant is {@see VmMigrationClient::listUtilizationReportsAsync()} .
     *
     * @example samples/V1/VmMigrationClient/list_utilization_reports.php
     *
     * @param ListUtilizationReportsRequest $request     A request to house fields associated with the call.
     * @param array                         $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listUtilizationReports(
        ListUtilizationReportsRequest $request,
        array $callOptions = []
    ): PagedListResponse {
        return $this->startApiCall('ListUtilizationReports', $request, $callOptions);
    }

    /**
     * Pauses a migration for a VM. If cycle tasks are running they will be
     * cancelled, preserving source task data. Further replication cycles will not
     * be triggered while the VM is paused.
     *
     * The async variant is {@see VmMigrationClient::pauseMigrationAsync()} .
     *
     * @example samples/V1/VmMigrationClient/pause_migration.php
     *
     * @param PauseMigrationRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function pauseMigration(PauseMigrationRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('PauseMigration', $request, $callOptions)->wait();
    }

    /**
     * Removes a MigratingVm from a Group.
     *
     * The async variant is {@see VmMigrationClient::removeGroupMigrationAsync()} .
     *
     * @example samples/V1/VmMigrationClient/remove_group_migration.php
     *
     * @param RemoveGroupMigrationRequest $request     A request to house fields associated with the call.
     * @param array                       $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function removeGroupMigration(
        RemoveGroupMigrationRequest $request,
        array $callOptions = []
    ): OperationResponse {
        return $this->startApiCall('RemoveGroupMigration', $request, $callOptions)->wait();
    }

    /**
     * Resumes a migration for a VM. When called on a paused migration, will start
     * the process of uploading data and creating snapshots; when called on a
     * completed cut-over migration, will update the migration to active state and
     * start the process of uploading data and creating snapshots.
     *
     * The async variant is {@see VmMigrationClient::resumeMigrationAsync()} .
     *
     * @example samples/V1/VmMigrationClient/resume_migration.php
     *
     * @param ResumeMigrationRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function resumeMigration(ResumeMigrationRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('ResumeMigration', $request, $callOptions)->wait();
    }

    /**
     * Starts migration for a VM. Starts the process of uploading
     * data and creating snapshots, in replication cycles scheduled by the policy.
     *
     * The async variant is {@see VmMigrationClient::startMigrationAsync()} .
     *
     * @example samples/V1/VmMigrationClient/start_migration.php
     *
     * @param StartMigrationRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function startMigration(StartMigrationRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('StartMigration', $request, $callOptions)->wait();
    }

    /**
     * Updates the parameters of a single Group.
     *
     * The async variant is {@see VmMigrationClient::updateGroupAsync()} .
     *
     * @example samples/V1/VmMigrationClient/update_group.php
     *
     * @param UpdateGroupRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateGroup(UpdateGroupRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('UpdateGroup', $request, $callOptions)->wait();
    }

    /**
     * Updates the parameters of a single MigratingVm.
     *
     * The async variant is {@see VmMigrationClient::updateMigratingVmAsync()} .
     *
     * @example samples/V1/VmMigrationClient/update_migrating_vm.php
     *
     * @param UpdateMigratingVmRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateMigratingVm(UpdateMigratingVmRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('UpdateMigratingVm', $request, $callOptions)->wait();
    }

    /**
     * Updates the parameters of a single Source.
     *
     * The async variant is {@see VmMigrationClient::updateSourceAsync()} .
     *
     * @example samples/V1/VmMigrationClient/update_source.php
     *
     * @param UpdateSourceRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateSource(UpdateSourceRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('UpdateSource', $request, $callOptions)->wait();
    }

    /**
     * Updates the parameters of a single TargetProject.
     *
     * NOTE: TargetProject is a global resource; hence the only supported value
     * for location is `global`.
     *
     * The async variant is {@see VmMigrationClient::updateTargetProjectAsync()} .
     *
     * @example samples/V1/VmMigrationClient/update_target_project.php
     *
     * @param UpdateTargetProjectRequest $request     A request to house fields associated with the call.
     * @param array                      $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateTargetProject(UpdateTargetProjectRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('UpdateTargetProject', $request, $callOptions)->wait();
    }

    /**
     * Upgrades the appliance relate to this DatacenterConnector to the in-place
     * updateable version.
     *
     * The async variant is {@see VmMigrationClient::upgradeApplianceAsync()} .
     *
     * @example samples/V1/VmMigrationClient/upgrade_appliance.php
     *
     * @param UpgradeApplianceRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function upgradeAppliance(UpgradeApplianceRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('UpgradeAppliance', $request, $callOptions)->wait();
    }

    /**
     * Gets information about a location.
     *
     * The async variant is {@see VmMigrationClient::getLocationAsync()} .
     *
     * @example samples/V1/VmMigrationClient/get_location.php
     *
     * @param GetLocationRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Location
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getLocation(GetLocationRequest $request, array $callOptions = []): Location
    {
        return $this->startApiCall('GetLocation', $request, $callOptions)->wait();
    }

    /**
     * Lists information about the supported locations for this service.
     *
     * The async variant is {@see VmMigrationClient::listLocationsAsync()} .
     *
     * @example samples/V1/VmMigrationClient/list_locations.php
     *
     * @param ListLocationsRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listLocations(ListLocationsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListLocations', $request, $callOptions);
    }
}
