<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/shopping/merchant/reviews/v1beta/merchantreviews.proto

namespace Google\Shopping\Merchant\Reviews\V1beta;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * A review for a merchant. For more information, see
 * [Introduction to Merchant Review
 * Feeds](https://developers.google.com/merchant-review-feeds)
 *
 * Generated from protobuf message <code>google.shopping.merchant.reviews.v1beta.MerchantReview</code>
 */
class MerchantReview extends \Google\Protobuf\Internal\Message
{
    /**
     * Identifier. The name of the merchant review.
     * Format:
     * `"{merchantreview.name=accounts/{account}/merchantReviews/{merchantReview}}"`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     */
    protected $name = '';
    /**
     * Required. The user provided merchant review ID to uniquely identify the
     * merchant review.
     *
     * Generated from protobuf field <code>string merchant_review_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $merchant_review_id = '';
    /**
     * Optional. A list of merchant review attributes.
     *
     * Generated from protobuf field <code>.google.shopping.merchant.reviews.v1beta.MerchantReviewAttributes attributes = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $attributes = null;
    /**
     * Required. A list of custom (merchant-provided) attributes. It can also be
     * used for submitting any attribute of the data specification in its generic
     * form (for example,
     * `{ "name": "size type", "value": "regular" }`).
     * This is useful for submitting attributes not explicitly exposed by the
     * API, such as experimental attributes.
     * Maximum allowed number of characters for each
     * custom attribute is 10240 (represents sum of characters for name and
     * value). Maximum 2500 custom attributes can be set per product, with total
     * size of 102.4kB. Underscores in custom attribute names are replaced by
     * spaces upon insertion.
     *
     * Generated from protobuf field <code>repeated .google.shopping.type.CustomAttribute custom_attributes = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    private $custom_attributes;
    /**
     * Output only. The primary data source of the merchant review.
     *
     * Generated from protobuf field <code>string data_source = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $data_source = '';
    /**
     * Output only. The status of a merchant review, data validation issues, that
     * is, information about a merchant review computed asynchronously.
     *
     * Generated from protobuf field <code>.google.shopping.merchant.reviews.v1beta.MerchantReviewStatus merchant_review_status = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $merchant_review_status = null;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           Identifier. The name of the merchant review.
     *           Format:
     *           `"{merchantreview.name=accounts/{account}/merchantReviews/{merchantReview}}"`
     *     @type string $merchant_review_id
     *           Required. The user provided merchant review ID to uniquely identify the
     *           merchant review.
     *     @type \Google\Shopping\Merchant\Reviews\V1beta\MerchantReviewAttributes $attributes
     *           Optional. A list of merchant review attributes.
     *     @type array<\Google\Shopping\Type\CustomAttribute>|\Google\Protobuf\Internal\RepeatedField $custom_attributes
     *           Required. A list of custom (merchant-provided) attributes. It can also be
     *           used for submitting any attribute of the data specification in its generic
     *           form (for example,
     *           `{ "name": "size type", "value": "regular" }`).
     *           This is useful for submitting attributes not explicitly exposed by the
     *           API, such as experimental attributes.
     *           Maximum allowed number of characters for each
     *           custom attribute is 10240 (represents sum of characters for name and
     *           value). Maximum 2500 custom attributes can be set per product, with total
     *           size of 102.4kB. Underscores in custom attribute names are replaced by
     *           spaces upon insertion.
     *     @type string $data_source
     *           Output only. The primary data source of the merchant review.
     *     @type \Google\Shopping\Merchant\Reviews\V1beta\MerchantReviewStatus $merchant_review_status
     *           Output only. The status of a merchant review, data validation issues, that
     *           is, information about a merchant review computed asynchronously.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Shopping\Merchant\Reviews\V1Beta\Merchantreviews::initOnce();
        parent::__construct($data);
    }

    /**
     * Identifier. The name of the merchant review.
     * Format:
     * `"{merchantreview.name=accounts/{account}/merchantReviews/{merchantReview}}"`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Identifier. The name of the merchant review.
     * Format:
     * `"{merchantreview.name=accounts/{account}/merchantReviews/{merchantReview}}"`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Required. The user provided merchant review ID to uniquely identify the
     * merchant review.
     *
     * Generated from protobuf field <code>string merchant_review_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getMerchantReviewId()
    {
        return $this->merchant_review_id;
    }

    /**
     * Required. The user provided merchant review ID to uniquely identify the
     * merchant review.
     *
     * Generated from protobuf field <code>string merchant_review_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setMerchantReviewId($var)
    {
        GPBUtil::checkString($var, True);
        $this->merchant_review_id = $var;

        return $this;
    }

    /**
     * Optional. A list of merchant review attributes.
     *
     * Generated from protobuf field <code>.google.shopping.merchant.reviews.v1beta.MerchantReviewAttributes attributes = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Shopping\Merchant\Reviews\V1beta\MerchantReviewAttributes|null
     */
    public function getAttributes()
    {
        return $this->attributes;
    }

    public function hasAttributes()
    {
        return isset($this->attributes);
    }

    public function clearAttributes()
    {
        unset($this->attributes);
    }

    /**
     * Optional. A list of merchant review attributes.
     *
     * Generated from protobuf field <code>.google.shopping.merchant.reviews.v1beta.MerchantReviewAttributes attributes = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Shopping\Merchant\Reviews\V1beta\MerchantReviewAttributes $var
     * @return $this
     */
    public function setAttributes($var)
    {
        GPBUtil::checkMessage($var, \Google\Shopping\Merchant\Reviews\V1beta\MerchantReviewAttributes::class);
        $this->attributes = $var;

        return $this;
    }

    /**
     * Required. A list of custom (merchant-provided) attributes. It can also be
     * used for submitting any attribute of the data specification in its generic
     * form (for example,
     * `{ "name": "size type", "value": "regular" }`).
     * This is useful for submitting attributes not explicitly exposed by the
     * API, such as experimental attributes.
     * Maximum allowed number of characters for each
     * custom attribute is 10240 (represents sum of characters for name and
     * value). Maximum 2500 custom attributes can be set per product, with total
     * size of 102.4kB. Underscores in custom attribute names are replaced by
     * spaces upon insertion.
     *
     * Generated from protobuf field <code>repeated .google.shopping.type.CustomAttribute custom_attributes = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getCustomAttributes()
    {
        return $this->custom_attributes;
    }

    /**
     * Required. A list of custom (merchant-provided) attributes. It can also be
     * used for submitting any attribute of the data specification in its generic
     * form (for example,
     * `{ "name": "size type", "value": "regular" }`).
     * This is useful for submitting attributes not explicitly exposed by the
     * API, such as experimental attributes.
     * Maximum allowed number of characters for each
     * custom attribute is 10240 (represents sum of characters for name and
     * value). Maximum 2500 custom attributes can be set per product, with total
     * size of 102.4kB. Underscores in custom attribute names are replaced by
     * spaces upon insertion.
     *
     * Generated from protobuf field <code>repeated .google.shopping.type.CustomAttribute custom_attributes = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param array<\Google\Shopping\Type\CustomAttribute>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setCustomAttributes($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Shopping\Type\CustomAttribute::class);
        $this->custom_attributes = $arr;

        return $this;
    }

    /**
     * Output only. The primary data source of the merchant review.
     *
     * Generated from protobuf field <code>string data_source = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getDataSource()
    {
        return $this->data_source;
    }

    /**
     * Output only. The primary data source of the merchant review.
     *
     * Generated from protobuf field <code>string data_source = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setDataSource($var)
    {
        GPBUtil::checkString($var, True);
        $this->data_source = $var;

        return $this;
    }

    /**
     * Output only. The status of a merchant review, data validation issues, that
     * is, information about a merchant review computed asynchronously.
     *
     * Generated from protobuf field <code>.google.shopping.merchant.reviews.v1beta.MerchantReviewStatus merchant_review_status = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Shopping\Merchant\Reviews\V1beta\MerchantReviewStatus|null
     */
    public function getMerchantReviewStatus()
    {
        return $this->merchant_review_status;
    }

    public function hasMerchantReviewStatus()
    {
        return isset($this->merchant_review_status);
    }

    public function clearMerchantReviewStatus()
    {
        unset($this->merchant_review_status);
    }

    /**
     * Output only. The status of a merchant review, data validation issues, that
     * is, information about a merchant review computed asynchronously.
     *
     * Generated from protobuf field <code>.google.shopping.merchant.reviews.v1beta.MerchantReviewStatus merchant_review_status = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Shopping\Merchant\Reviews\V1beta\MerchantReviewStatus $var
     * @return $this
     */
    public function setMerchantReviewStatus($var)
    {
        GPBUtil::checkMessage($var, \Google\Shopping\Merchant\Reviews\V1beta\MerchantReviewStatus::class);
        $this->merchant_review_status = $var;

        return $this;
    }

}

