<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/networkservices/v1/mesh.proto

namespace Google\Cloud\NetworkServices\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Mesh represents a logical configuration grouping for workload to workload
 * communication within a service mesh. Routes that point to mesh dictate how
 * requests are routed within this logical mesh boundary.
 *
 * Generated from protobuf message <code>google.cloud.networkservices.v1.Mesh</code>
 */
class Mesh extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. Name of the Mesh resource. It matches pattern
     * `projects/&#42;&#47;locations/global/meshes/<mesh_name>`.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $name = '';
    /**
     * Output only. Server-defined URL of this resource
     *
     * Generated from protobuf field <code>string self_link = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $self_link = '';
    /**
     * Output only. The timestamp when the resource was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $create_time = null;
    /**
     * Output only. The timestamp when the resource was updated.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $update_time = null;
    /**
     * Optional. Set of label tags associated with the Mesh resource.
     *
     * Generated from protobuf field <code>map<string, string> labels = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $labels;
    /**
     * Optional. A free-text description of the resource. Max length 1024
     * characters.
     *
     * Generated from protobuf field <code>string description = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $description = '';
    /**
     * Optional. If set to a valid TCP port (1-65535), instructs the SIDECAR proxy
     * to listen on the specified port of localhost (127.0.0.1) address. The
     * SIDECAR proxy will expect all traffic to be redirected to this port
     * regardless of its actual ip:port destination. If unset, a port '15001' is
     * used as the interception port. This is applicable only for sidecar proxy
     * deployments.
     *
     * Generated from protobuf field <code>int32 interception_port = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $interception_port = 0;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           Required. Name of the Mesh resource. It matches pattern
     *           `projects/&#42;&#47;locations/global/meshes/<mesh_name>`.
     *     @type string $self_link
     *           Output only. Server-defined URL of this resource
     *     @type \Google\Protobuf\Timestamp $create_time
     *           Output only. The timestamp when the resource was created.
     *     @type \Google\Protobuf\Timestamp $update_time
     *           Output only. The timestamp when the resource was updated.
     *     @type array|\Google\Protobuf\Internal\MapField $labels
     *           Optional. Set of label tags associated with the Mesh resource.
     *     @type string $description
     *           Optional. A free-text description of the resource. Max length 1024
     *           characters.
     *     @type int $interception_port
     *           Optional. If set to a valid TCP port (1-65535), instructs the SIDECAR proxy
     *           to listen on the specified port of localhost (127.0.0.1) address. The
     *           SIDECAR proxy will expect all traffic to be redirected to this port
     *           regardless of its actual ip:port destination. If unset, a port '15001' is
     *           used as the interception port. This is applicable only for sidecar proxy
     *           deployments.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Networkservices\V1\Mesh::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. Name of the Mesh resource. It matches pattern
     * `projects/&#42;&#47;locations/global/meshes/<mesh_name>`.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Required. Name of the Mesh resource. It matches pattern
     * `projects/&#42;&#47;locations/global/meshes/<mesh_name>`.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Output only. Server-defined URL of this resource
     *
     * Generated from protobuf field <code>string self_link = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getSelfLink()
    {
        return $this->self_link;
    }

    /**
     * Output only. Server-defined URL of this resource
     *
     * Generated from protobuf field <code>string self_link = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setSelfLink($var)
    {
        GPBUtil::checkString($var, True);
        $this->self_link = $var;

        return $this;
    }

    /**
     * Output only. The timestamp when the resource was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getCreateTime()
    {
        return $this->create_time;
    }

    public function hasCreateTime()
    {
        return isset($this->create_time);
    }

    public function clearCreateTime()
    {
        unset($this->create_time);
    }

    /**
     * Output only. The timestamp when the resource was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setCreateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->create_time = $var;

        return $this;
    }

    /**
     * Output only. The timestamp when the resource was updated.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getUpdateTime()
    {
        return $this->update_time;
    }

    public function hasUpdateTime()
    {
        return isset($this->update_time);
    }

    public function clearUpdateTime()
    {
        unset($this->update_time);
    }

    /**
     * Output only. The timestamp when the resource was updated.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setUpdateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->update_time = $var;

        return $this;
    }

    /**
     * Optional. Set of label tags associated with the Mesh resource.
     *
     * Generated from protobuf field <code>map<string, string> labels = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getLabels()
    {
        return $this->labels;
    }

    /**
     * Optional. Set of label tags associated with the Mesh resource.
     *
     * Generated from protobuf field <code>map<string, string> labels = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setLabels($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::STRING);
        $this->labels = $arr;

        return $this;
    }

    /**
     * Optional. A free-text description of the resource. Max length 1024
     * characters.
     *
     * Generated from protobuf field <code>string description = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * Optional. A free-text description of the resource. Max length 1024
     * characters.
     *
     * Generated from protobuf field <code>string description = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setDescription($var)
    {
        GPBUtil::checkString($var, True);
        $this->description = $var;

        return $this;
    }

    /**
     * Optional. If set to a valid TCP port (1-65535), instructs the SIDECAR proxy
     * to listen on the specified port of localhost (127.0.0.1) address. The
     * SIDECAR proxy will expect all traffic to be redirected to this port
     * regardless of its actual ip:port destination. If unset, a port '15001' is
     * used as the interception port. This is applicable only for sidecar proxy
     * deployments.
     *
     * Generated from protobuf field <code>int32 interception_port = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return int
     */
    public function getInterceptionPort()
    {
        return $this->interception_port;
    }

    /**
     * Optional. If set to a valid TCP port (1-65535), instructs the SIDECAR proxy
     * to listen on the specified port of localhost (127.0.0.1) address. The
     * SIDECAR proxy will expect all traffic to be redirected to this port
     * regardless of its actual ip:port destination. If unset, a port '15001' is
     * used as the interception port. This is applicable only for sidecar proxy
     * deployments.
     *
     * Generated from protobuf field <code>int32 interception_port = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param int $var
     * @return $this
     */
    public function setInterceptionPort($var)
    {
        GPBUtil::checkInt32($var);
        $this->interception_port = $var;

        return $this;
    }

}

