<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/networkservices/v1/endpoint_policy.proto

namespace Google\Cloud\NetworkServices\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * EndpointPolicy is a resource that helps apply desired configuration
 * on the endpoints that match specific criteria.
 * For example, this resource can be used to apply "authentication config"
 * an all endpoints that serve on port 8080.
 *
 * Generated from protobuf message <code>google.cloud.networkservices.v1.EndpointPolicy</code>
 */
class EndpointPolicy extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. Name of the EndpointPolicy resource. It matches pattern
     * `projects/{project}/locations/global/endpointPolicies/{endpoint_policy}`.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $name = '';
    /**
     * Output only. The timestamp when the resource was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $create_time = null;
    /**
     * Output only. The timestamp when the resource was updated.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $update_time = null;
    /**
     * Optional. Set of label tags associated with the EndpointPolicy resource.
     *
     * Generated from protobuf field <code>map<string, string> labels = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $labels;
    /**
     * Required. The type of endpoint policy. This is primarily used to validate
     * the configuration.
     *
     * Generated from protobuf field <code>.google.cloud.networkservices.v1.EndpointPolicy.EndpointPolicyType type = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $type = 0;
    /**
     * Optional. This field specifies the URL of AuthorizationPolicy resource that
     * applies authorization policies to the inbound traffic at the
     * matched endpoints. Refer to Authorization. If this field is not
     * specified, authorization is disabled(no authz checks) for this
     * endpoint.
     *
     * Generated from protobuf field <code>string authorization_policy = 7 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = {</code>
     */
    protected $authorization_policy = '';
    /**
     * Required. A matcher that selects endpoints to which the policies should be
     * applied.
     *
     * Generated from protobuf field <code>.google.cloud.networkservices.v1.EndpointMatcher endpoint_matcher = 9 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $endpoint_matcher = null;
    /**
     * Optional. Port selector for the (matched) endpoints. If no port selector is
     * provided, the matched config is applied to all ports.
     *
     * Generated from protobuf field <code>.google.cloud.networkservices.v1.TrafficPortSelector traffic_port_selector = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $traffic_port_selector = null;
    /**
     * Optional. A free-text description of the resource. Max length 1024
     * characters.
     *
     * Generated from protobuf field <code>string description = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $description = '';
    /**
     * Optional. A URL referring to ServerTlsPolicy resource. ServerTlsPolicy is
     * used to determine the authentication policy to be applied to terminate the
     * inbound traffic at the identified backends. If this field is not set,
     * authentication is disabled(open) for this endpoint.
     *
     * Generated from protobuf field <code>string server_tls_policy = 12 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = {</code>
     */
    protected $server_tls_policy = '';
    /**
     * Optional. A URL referring to a ClientTlsPolicy resource. ClientTlsPolicy
     * can be set to specify the authentication for traffic from the proxy to the
     * actual endpoints. More specifically, it is applied to the outgoing traffic
     * from the proxy to the endpoint. This is typically used for sidecar model
     * where the proxy identifies itself as endpoint to the control plane, with
     * the connection between sidecar and endpoint requiring authentication. If
     * this field is not set, authentication is disabled(open). Applicable only
     * when EndpointPolicyType is SIDECAR_PROXY.
     *
     * Generated from protobuf field <code>string client_tls_policy = 13 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = {</code>
     */
    protected $client_tls_policy = '';

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           Required. Name of the EndpointPolicy resource. It matches pattern
     *           `projects/{project}/locations/global/endpointPolicies/{endpoint_policy}`.
     *     @type \Google\Protobuf\Timestamp $create_time
     *           Output only. The timestamp when the resource was created.
     *     @type \Google\Protobuf\Timestamp $update_time
     *           Output only. The timestamp when the resource was updated.
     *     @type array|\Google\Protobuf\Internal\MapField $labels
     *           Optional. Set of label tags associated with the EndpointPolicy resource.
     *     @type int $type
     *           Required. The type of endpoint policy. This is primarily used to validate
     *           the configuration.
     *     @type string $authorization_policy
     *           Optional. This field specifies the URL of AuthorizationPolicy resource that
     *           applies authorization policies to the inbound traffic at the
     *           matched endpoints. Refer to Authorization. If this field is not
     *           specified, authorization is disabled(no authz checks) for this
     *           endpoint.
     *     @type \Google\Cloud\NetworkServices\V1\EndpointMatcher $endpoint_matcher
     *           Required. A matcher that selects endpoints to which the policies should be
     *           applied.
     *     @type \Google\Cloud\NetworkServices\V1\TrafficPortSelector $traffic_port_selector
     *           Optional. Port selector for the (matched) endpoints. If no port selector is
     *           provided, the matched config is applied to all ports.
     *     @type string $description
     *           Optional. A free-text description of the resource. Max length 1024
     *           characters.
     *     @type string $server_tls_policy
     *           Optional. A URL referring to ServerTlsPolicy resource. ServerTlsPolicy is
     *           used to determine the authentication policy to be applied to terminate the
     *           inbound traffic at the identified backends. If this field is not set,
     *           authentication is disabled(open) for this endpoint.
     *     @type string $client_tls_policy
     *           Optional. A URL referring to a ClientTlsPolicy resource. ClientTlsPolicy
     *           can be set to specify the authentication for traffic from the proxy to the
     *           actual endpoints. More specifically, it is applied to the outgoing traffic
     *           from the proxy to the endpoint. This is typically used for sidecar model
     *           where the proxy identifies itself as endpoint to the control plane, with
     *           the connection between sidecar and endpoint requiring authentication. If
     *           this field is not set, authentication is disabled(open). Applicable only
     *           when EndpointPolicyType is SIDECAR_PROXY.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Networkservices\V1\EndpointPolicy::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. Name of the EndpointPolicy resource. It matches pattern
     * `projects/{project}/locations/global/endpointPolicies/{endpoint_policy}`.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Required. Name of the EndpointPolicy resource. It matches pattern
     * `projects/{project}/locations/global/endpointPolicies/{endpoint_policy}`.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Output only. The timestamp when the resource was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getCreateTime()
    {
        return $this->create_time;
    }

    public function hasCreateTime()
    {
        return isset($this->create_time);
    }

    public function clearCreateTime()
    {
        unset($this->create_time);
    }

    /**
     * Output only. The timestamp when the resource was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setCreateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->create_time = $var;

        return $this;
    }

    /**
     * Output only. The timestamp when the resource was updated.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getUpdateTime()
    {
        return $this->update_time;
    }

    public function hasUpdateTime()
    {
        return isset($this->update_time);
    }

    public function clearUpdateTime()
    {
        unset($this->update_time);
    }

    /**
     * Output only. The timestamp when the resource was updated.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setUpdateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->update_time = $var;

        return $this;
    }

    /**
     * Optional. Set of label tags associated with the EndpointPolicy resource.
     *
     * Generated from protobuf field <code>map<string, string> labels = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getLabels()
    {
        return $this->labels;
    }

    /**
     * Optional. Set of label tags associated with the EndpointPolicy resource.
     *
     * Generated from protobuf field <code>map<string, string> labels = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setLabels($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::STRING);
        $this->labels = $arr;

        return $this;
    }

    /**
     * Required. The type of endpoint policy. This is primarily used to validate
     * the configuration.
     *
     * Generated from protobuf field <code>.google.cloud.networkservices.v1.EndpointPolicy.EndpointPolicyType type = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return int
     */
    public function getType()
    {
        return $this->type;
    }

    /**
     * Required. The type of endpoint policy. This is primarily used to validate
     * the configuration.
     *
     * Generated from protobuf field <code>.google.cloud.networkservices.v1.EndpointPolicy.EndpointPolicyType type = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param int $var
     * @return $this
     */
    public function setType($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\NetworkServices\V1\EndpointPolicy\EndpointPolicyType::class);
        $this->type = $var;

        return $this;
    }

    /**
     * Optional. This field specifies the URL of AuthorizationPolicy resource that
     * applies authorization policies to the inbound traffic at the
     * matched endpoints. Refer to Authorization. If this field is not
     * specified, authorization is disabled(no authz checks) for this
     * endpoint.
     *
     * Generated from protobuf field <code>string authorization_policy = 7 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getAuthorizationPolicy()
    {
        return $this->authorization_policy;
    }

    /**
     * Optional. This field specifies the URL of AuthorizationPolicy resource that
     * applies authorization policies to the inbound traffic at the
     * matched endpoints. Refer to Authorization. If this field is not
     * specified, authorization is disabled(no authz checks) for this
     * endpoint.
     *
     * Generated from protobuf field <code>string authorization_policy = 7 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setAuthorizationPolicy($var)
    {
        GPBUtil::checkString($var, True);
        $this->authorization_policy = $var;

        return $this;
    }

    /**
     * Required. A matcher that selects endpoints to which the policies should be
     * applied.
     *
     * Generated from protobuf field <code>.google.cloud.networkservices.v1.EndpointMatcher endpoint_matcher = 9 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return \Google\Cloud\NetworkServices\V1\EndpointMatcher|null
     */
    public function getEndpointMatcher()
    {
        return $this->endpoint_matcher;
    }

    public function hasEndpointMatcher()
    {
        return isset($this->endpoint_matcher);
    }

    public function clearEndpointMatcher()
    {
        unset($this->endpoint_matcher);
    }

    /**
     * Required. A matcher that selects endpoints to which the policies should be
     * applied.
     *
     * Generated from protobuf field <code>.google.cloud.networkservices.v1.EndpointMatcher endpoint_matcher = 9 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param \Google\Cloud\NetworkServices\V1\EndpointMatcher $var
     * @return $this
     */
    public function setEndpointMatcher($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\NetworkServices\V1\EndpointMatcher::class);
        $this->endpoint_matcher = $var;

        return $this;
    }

    /**
     * Optional. Port selector for the (matched) endpoints. If no port selector is
     * provided, the matched config is applied to all ports.
     *
     * Generated from protobuf field <code>.google.cloud.networkservices.v1.TrafficPortSelector traffic_port_selector = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\NetworkServices\V1\TrafficPortSelector|null
     */
    public function getTrafficPortSelector()
    {
        return $this->traffic_port_selector;
    }

    public function hasTrafficPortSelector()
    {
        return isset($this->traffic_port_selector);
    }

    public function clearTrafficPortSelector()
    {
        unset($this->traffic_port_selector);
    }

    /**
     * Optional. Port selector for the (matched) endpoints. If no port selector is
     * provided, the matched config is applied to all ports.
     *
     * Generated from protobuf field <code>.google.cloud.networkservices.v1.TrafficPortSelector traffic_port_selector = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\NetworkServices\V1\TrafficPortSelector $var
     * @return $this
     */
    public function setTrafficPortSelector($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\NetworkServices\V1\TrafficPortSelector::class);
        $this->traffic_port_selector = $var;

        return $this;
    }

    /**
     * Optional. A free-text description of the resource. Max length 1024
     * characters.
     *
     * Generated from protobuf field <code>string description = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * Optional. A free-text description of the resource. Max length 1024
     * characters.
     *
     * Generated from protobuf field <code>string description = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setDescription($var)
    {
        GPBUtil::checkString($var, True);
        $this->description = $var;

        return $this;
    }

    /**
     * Optional. A URL referring to ServerTlsPolicy resource. ServerTlsPolicy is
     * used to determine the authentication policy to be applied to terminate the
     * inbound traffic at the identified backends. If this field is not set,
     * authentication is disabled(open) for this endpoint.
     *
     * Generated from protobuf field <code>string server_tls_policy = 12 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getServerTlsPolicy()
    {
        return $this->server_tls_policy;
    }

    /**
     * Optional. A URL referring to ServerTlsPolicy resource. ServerTlsPolicy is
     * used to determine the authentication policy to be applied to terminate the
     * inbound traffic at the identified backends. If this field is not set,
     * authentication is disabled(open) for this endpoint.
     *
     * Generated from protobuf field <code>string server_tls_policy = 12 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setServerTlsPolicy($var)
    {
        GPBUtil::checkString($var, True);
        $this->server_tls_policy = $var;

        return $this;
    }

    /**
     * Optional. A URL referring to a ClientTlsPolicy resource. ClientTlsPolicy
     * can be set to specify the authentication for traffic from the proxy to the
     * actual endpoints. More specifically, it is applied to the outgoing traffic
     * from the proxy to the endpoint. This is typically used for sidecar model
     * where the proxy identifies itself as endpoint to the control plane, with
     * the connection between sidecar and endpoint requiring authentication. If
     * this field is not set, authentication is disabled(open). Applicable only
     * when EndpointPolicyType is SIDECAR_PROXY.
     *
     * Generated from protobuf field <code>string client_tls_policy = 13 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getClientTlsPolicy()
    {
        return $this->client_tls_policy;
    }

    /**
     * Optional. A URL referring to a ClientTlsPolicy resource. ClientTlsPolicy
     * can be set to specify the authentication for traffic from the proxy to the
     * actual endpoints. More specifically, it is applied to the outgoing traffic
     * from the proxy to the endpoint. This is typically used for sidecar model
     * where the proxy identifies itself as endpoint to the control plane, with
     * the connection between sidecar and endpoint requiring authentication. If
     * this field is not set, authentication is disabled(open). Applicable only
     * when EndpointPolicyType is SIDECAR_PROXY.
     *
     * Generated from protobuf field <code>string client_tls_policy = 13 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setClientTlsPolicy($var)
    {
        GPBUtil::checkString($var, True);
        $this->client_tls_policy = $var;

        return $this;
    }

}

