<?php
/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/networksecurity/v1/network_security.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\NetworkSecurity\V1\Client;

use Google\ApiCore\ApiException;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\OperationResponse;
use Google\ApiCore\PagedListResponse;
use Google\ApiCore\ResourceHelperTrait;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\Iam\V1\GetIamPolicyRequest;
use Google\Cloud\Iam\V1\Policy;
use Google\Cloud\Iam\V1\SetIamPolicyRequest;
use Google\Cloud\Iam\V1\TestIamPermissionsRequest;
use Google\Cloud\Iam\V1\TestIamPermissionsResponse;
use Google\Cloud\Location\GetLocationRequest;
use Google\Cloud\Location\ListLocationsRequest;
use Google\Cloud\Location\Location;
use Google\Cloud\NetworkSecurity\V1\AuthorizationPolicy;
use Google\Cloud\NetworkSecurity\V1\ClientTlsPolicy;
use Google\Cloud\NetworkSecurity\V1\CreateAuthorizationPolicyRequest;
use Google\Cloud\NetworkSecurity\V1\CreateClientTlsPolicyRequest;
use Google\Cloud\NetworkSecurity\V1\CreateServerTlsPolicyRequest;
use Google\Cloud\NetworkSecurity\V1\DeleteAuthorizationPolicyRequest;
use Google\Cloud\NetworkSecurity\V1\DeleteClientTlsPolicyRequest;
use Google\Cloud\NetworkSecurity\V1\DeleteServerTlsPolicyRequest;
use Google\Cloud\NetworkSecurity\V1\GetAuthorizationPolicyRequest;
use Google\Cloud\NetworkSecurity\V1\GetClientTlsPolicyRequest;
use Google\Cloud\NetworkSecurity\V1\GetServerTlsPolicyRequest;
use Google\Cloud\NetworkSecurity\V1\ListAuthorizationPoliciesRequest;
use Google\Cloud\NetworkSecurity\V1\ListClientTlsPoliciesRequest;
use Google\Cloud\NetworkSecurity\V1\ListServerTlsPoliciesRequest;
use Google\Cloud\NetworkSecurity\V1\ServerTlsPolicy;
use Google\Cloud\NetworkSecurity\V1\UpdateAuthorizationPolicyRequest;
use Google\Cloud\NetworkSecurity\V1\UpdateClientTlsPolicyRequest;
use Google\Cloud\NetworkSecurity\V1\UpdateServerTlsPolicyRequest;
use Google\LongRunning\Client\OperationsClient;
use Google\LongRunning\Operation;
use GuzzleHttp\Promise\PromiseInterface;
use Psr\Log\LoggerInterface;

/**
 * Service Description: Network Security API provides resources to configure authentication and
 * authorization policies. Refer to per API resource documentation for more
 * information.
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods.
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 *
 * @method PromiseInterface<OperationResponse> createAuthorizationPolicyAsync(CreateAuthorizationPolicyRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> createClientTlsPolicyAsync(CreateClientTlsPolicyRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> createServerTlsPolicyAsync(CreateServerTlsPolicyRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> deleteAuthorizationPolicyAsync(DeleteAuthorizationPolicyRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> deleteClientTlsPolicyAsync(DeleteClientTlsPolicyRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> deleteServerTlsPolicyAsync(DeleteServerTlsPolicyRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<AuthorizationPolicy> getAuthorizationPolicyAsync(GetAuthorizationPolicyRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<ClientTlsPolicy> getClientTlsPolicyAsync(GetClientTlsPolicyRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<ServerTlsPolicy> getServerTlsPolicyAsync(GetServerTlsPolicyRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listAuthorizationPoliciesAsync(ListAuthorizationPoliciesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listClientTlsPoliciesAsync(ListClientTlsPoliciesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listServerTlsPoliciesAsync(ListServerTlsPoliciesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> updateAuthorizationPolicyAsync(UpdateAuthorizationPolicyRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> updateClientTlsPolicyAsync(UpdateClientTlsPolicyRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> updateServerTlsPolicyAsync(UpdateServerTlsPolicyRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Location> getLocationAsync(GetLocationRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listLocationsAsync(ListLocationsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Policy> getIamPolicyAsync(GetIamPolicyRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Policy> setIamPolicyAsync(SetIamPolicyRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<TestIamPermissionsResponse> testIamPermissionsAsync(TestIamPermissionsRequest $request, array $optionalArgs = [])
 */
final class NetworkSecurityClient
{
    use GapicClientTrait;
    use ResourceHelperTrait;

    /** The name of the service. */
    private const SERVICE_NAME = 'google.cloud.networksecurity.v1.NetworkSecurity';

    /**
     * The default address of the service.
     *
     * @deprecated SERVICE_ADDRESS_TEMPLATE should be used instead.
     */
    private const SERVICE_ADDRESS = 'networksecurity.googleapis.com';

    /** The address template of the service. */
    private const SERVICE_ADDRESS_TEMPLATE = 'networksecurity.UNIVERSE_DOMAIN';

    /** The default port of the service. */
    private const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    private const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = ['https://www.googleapis.com/auth/cloud-platform'];

    private $operationsClient;

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' => self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' => __DIR__ . '/../resources/network_security_client_config.json',
            'descriptorsConfigPath' => __DIR__ . '/../resources/network_security_descriptor_config.php',
            'gcpApiConfigPath' => __DIR__ . '/../resources/network_security_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' => __DIR__ . '/../resources/network_security_rest_client_config.php',
                ],
            ],
        ];
    }

    /**
     * Return an OperationsClient object with the same endpoint as $this.
     *
     * @return OperationsClient
     */
    public function getOperationsClient()
    {
        return $this->operationsClient;
    }

    /**
     * Resume an existing long running operation that was previously started by a long
     * running API method. If $methodName is not provided, or does not match a long
     * running API method, then the operation can still be resumed, but the
     * OperationResponse object will not deserialize the final response.
     *
     * @param string $operationName The name of the long running operation
     * @param string $methodName    The name of the method used to start the operation
     *
     * @return OperationResponse
     */
    public function resumeOperation($operationName, $methodName = null)
    {
        $options = isset($this->descriptors[$methodName]['longRunning'])
            ? $this->descriptors[$methodName]['longRunning']
            : [];
        $operation = new OperationResponse($operationName, $this->getOperationsClient(), $options);
        $operation->reload();
        return $operation;
    }

    /**
     * Create the default operation client for the service.
     *
     * @param array $options ClientOptions for the client.
     *
     * @return OperationsClient
     */
    private function createOperationsClient(array $options)
    {
        // Unset client-specific configuration options
        unset($options['serviceName'], $options['clientConfig'], $options['descriptorsConfigPath']);

        if (isset($options['operationsClient'])) {
            return $options['operationsClient'];
        }

        return new OperationsClient($options);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * authorization_policy resource.
     *
     * @param string $project
     * @param string $location
     * @param string $authorizationPolicy
     *
     * @return string The formatted authorization_policy resource.
     */
    public static function authorizationPolicyName(
        string $project,
        string $location,
        string $authorizationPolicy
    ): string {
        return self::getPathTemplate('authorizationPolicy')->render([
            'project' => $project,
            'location' => $location,
            'authorization_policy' => $authorizationPolicy,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * client_tls_policy resource.
     *
     * @param string $project
     * @param string $location
     * @param string $clientTlsPolicy
     *
     * @return string The formatted client_tls_policy resource.
     */
    public static function clientTlsPolicyName(string $project, string $location, string $clientTlsPolicy): string
    {
        return self::getPathTemplate('clientTlsPolicy')->render([
            'project' => $project,
            'location' => $location,
            'client_tls_policy' => $clientTlsPolicy,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a location
     * resource.
     *
     * @param string $project
     * @param string $location
     *
     * @return string The formatted location resource.
     */
    public static function locationName(string $project, string $location): string
    {
        return self::getPathTemplate('location')->render([
            'project' => $project,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * server_tls_policy resource.
     *
     * @param string $project
     * @param string $location
     * @param string $serverTlsPolicy
     *
     * @return string The formatted server_tls_policy resource.
     */
    public static function serverTlsPolicyName(string $project, string $location, string $serverTlsPolicy): string
    {
        return self::getPathTemplate('serverTlsPolicy')->render([
            'project' => $project,
            'location' => $location,
            'server_tls_policy' => $serverTlsPolicy,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - authorizationPolicy: projects/{project}/locations/{location}/authorizationPolicies/{authorization_policy}
     * - clientTlsPolicy: projects/{project}/locations/{location}/clientTlsPolicies/{client_tls_policy}
     * - location: projects/{project}/locations/{location}
     * - serverTlsPolicy: projects/{project}/locations/{location}/serverTlsPolicies/{server_tls_policy}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string  $formattedName The formatted name string
     * @param ?string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName(string $formattedName, ?string $template = null): array
    {
        return self::parseFormattedName($formattedName, $template);
    }

    /**
     * Constructor.
     *
     * @param array $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'networksecurity.googleapis.com:443'.
     *     @type string|array|FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           The credentials to be used by the client to authorize API calls. This option
     *           accepts either a path to a credentials file, or a decoded credentials file as a
     *           PHP array.
     *           *Advanced usage*: In addition, this option can also accept a pre-constructed
     *           {@see \Google\Auth\FetchAuthTokenInterface} object or
     *           {@see \Google\ApiCore\CredentialsWrapper} object. Note that when one of these
     *           objects are provided, any settings in $credentialsConfig will be ignored.
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     *     @type false|LoggerInterface $logger
     *           A PSR-3 compliant logger. If set to false, logging is disabled, ignoring the
     *           'GOOGLE_SDK_PHP_LOGGING' environment flag
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
        $this->operationsClient = $this->createOperationsClient($clientOptions);
    }

    /** Handles execution of the async variants for each documented method. */
    public function __call($method, $args)
    {
        if (substr($method, -5) !== 'Async') {
            trigger_error('Call to undefined method ' . __CLASS__ . "::$method()", E_USER_ERROR);
        }

        array_unshift($args, substr($method, 0, -5));
        return call_user_func_array([$this, 'startAsyncCall'], $args);
    }

    /**
     * Creates a new AuthorizationPolicy in a given project and location.
     *
     * The async variant is
     * {@see NetworkSecurityClient::createAuthorizationPolicyAsync()} .
     *
     * @example samples/V1/NetworkSecurityClient/create_authorization_policy.php
     *
     * @param CreateAuthorizationPolicyRequest $request     A request to house fields associated with the call.
     * @param array                            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createAuthorizationPolicy(
        CreateAuthorizationPolicyRequest $request,
        array $callOptions = []
    ): OperationResponse {
        return $this->startApiCall('CreateAuthorizationPolicy', $request, $callOptions)->wait();
    }

    /**
     * Creates a new ClientTlsPolicy in a given project and location.
     *
     * The async variant is {@see NetworkSecurityClient::createClientTlsPolicyAsync()}
     * .
     *
     * @example samples/V1/NetworkSecurityClient/create_client_tls_policy.php
     *
     * @param CreateClientTlsPolicyRequest $request     A request to house fields associated with the call.
     * @param array                        $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createClientTlsPolicy(
        CreateClientTlsPolicyRequest $request,
        array $callOptions = []
    ): OperationResponse {
        return $this->startApiCall('CreateClientTlsPolicy', $request, $callOptions)->wait();
    }

    /**
     * Creates a new ServerTlsPolicy in a given project and location.
     *
     * The async variant is {@see NetworkSecurityClient::createServerTlsPolicyAsync()}
     * .
     *
     * @example samples/V1/NetworkSecurityClient/create_server_tls_policy.php
     *
     * @param CreateServerTlsPolicyRequest $request     A request to house fields associated with the call.
     * @param array                        $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createServerTlsPolicy(
        CreateServerTlsPolicyRequest $request,
        array $callOptions = []
    ): OperationResponse {
        return $this->startApiCall('CreateServerTlsPolicy', $request, $callOptions)->wait();
    }

    /**
     * Deletes a single AuthorizationPolicy.
     *
     * The async variant is
     * {@see NetworkSecurityClient::deleteAuthorizationPolicyAsync()} .
     *
     * @example samples/V1/NetworkSecurityClient/delete_authorization_policy.php
     *
     * @param DeleteAuthorizationPolicyRequest $request     A request to house fields associated with the call.
     * @param array                            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteAuthorizationPolicy(
        DeleteAuthorizationPolicyRequest $request,
        array $callOptions = []
    ): OperationResponse {
        return $this->startApiCall('DeleteAuthorizationPolicy', $request, $callOptions)->wait();
    }

    /**
     * Deletes a single ClientTlsPolicy.
     *
     * The async variant is {@see NetworkSecurityClient::deleteClientTlsPolicyAsync()}
     * .
     *
     * @example samples/V1/NetworkSecurityClient/delete_client_tls_policy.php
     *
     * @param DeleteClientTlsPolicyRequest $request     A request to house fields associated with the call.
     * @param array                        $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteClientTlsPolicy(
        DeleteClientTlsPolicyRequest $request,
        array $callOptions = []
    ): OperationResponse {
        return $this->startApiCall('DeleteClientTlsPolicy', $request, $callOptions)->wait();
    }

    /**
     * Deletes a single ServerTlsPolicy.
     *
     * The async variant is {@see NetworkSecurityClient::deleteServerTlsPolicyAsync()}
     * .
     *
     * @example samples/V1/NetworkSecurityClient/delete_server_tls_policy.php
     *
     * @param DeleteServerTlsPolicyRequest $request     A request to house fields associated with the call.
     * @param array                        $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteServerTlsPolicy(
        DeleteServerTlsPolicyRequest $request,
        array $callOptions = []
    ): OperationResponse {
        return $this->startApiCall('DeleteServerTlsPolicy', $request, $callOptions)->wait();
    }

    /**
     * Gets details of a single AuthorizationPolicy.
     *
     * The async variant is {@see NetworkSecurityClient::getAuthorizationPolicyAsync()}
     * .
     *
     * @example samples/V1/NetworkSecurityClient/get_authorization_policy.php
     *
     * @param GetAuthorizationPolicyRequest $request     A request to house fields associated with the call.
     * @param array                         $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return AuthorizationPolicy
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getAuthorizationPolicy(
        GetAuthorizationPolicyRequest $request,
        array $callOptions = []
    ): AuthorizationPolicy {
        return $this->startApiCall('GetAuthorizationPolicy', $request, $callOptions)->wait();
    }

    /**
     * Gets details of a single ClientTlsPolicy.
     *
     * The async variant is {@see NetworkSecurityClient::getClientTlsPolicyAsync()} .
     *
     * @example samples/V1/NetworkSecurityClient/get_client_tls_policy.php
     *
     * @param GetClientTlsPolicyRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return ClientTlsPolicy
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getClientTlsPolicy(GetClientTlsPolicyRequest $request, array $callOptions = []): ClientTlsPolicy
    {
        return $this->startApiCall('GetClientTlsPolicy', $request, $callOptions)->wait();
    }

    /**
     * Gets details of a single ServerTlsPolicy.
     *
     * The async variant is {@see NetworkSecurityClient::getServerTlsPolicyAsync()} .
     *
     * @example samples/V1/NetworkSecurityClient/get_server_tls_policy.php
     *
     * @param GetServerTlsPolicyRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return ServerTlsPolicy
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getServerTlsPolicy(GetServerTlsPolicyRequest $request, array $callOptions = []): ServerTlsPolicy
    {
        return $this->startApiCall('GetServerTlsPolicy', $request, $callOptions)->wait();
    }

    /**
     * Lists AuthorizationPolicies in a given project and location.
     *
     * The async variant is
     * {@see NetworkSecurityClient::listAuthorizationPoliciesAsync()} .
     *
     * @example samples/V1/NetworkSecurityClient/list_authorization_policies.php
     *
     * @param ListAuthorizationPoliciesRequest $request     A request to house fields associated with the call.
     * @param array                            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listAuthorizationPolicies(
        ListAuthorizationPoliciesRequest $request,
        array $callOptions = []
    ): PagedListResponse {
        return $this->startApiCall('ListAuthorizationPolicies', $request, $callOptions);
    }

    /**
     * Lists ClientTlsPolicies in a given project and location.
     *
     * The async variant is {@see NetworkSecurityClient::listClientTlsPoliciesAsync()}
     * .
     *
     * @example samples/V1/NetworkSecurityClient/list_client_tls_policies.php
     *
     * @param ListClientTlsPoliciesRequest $request     A request to house fields associated with the call.
     * @param array                        $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listClientTlsPolicies(
        ListClientTlsPoliciesRequest $request,
        array $callOptions = []
    ): PagedListResponse {
        return $this->startApiCall('ListClientTlsPolicies', $request, $callOptions);
    }

    /**
     * Lists ServerTlsPolicies in a given project and location.
     *
     * The async variant is {@see NetworkSecurityClient::listServerTlsPoliciesAsync()}
     * .
     *
     * @example samples/V1/NetworkSecurityClient/list_server_tls_policies.php
     *
     * @param ListServerTlsPoliciesRequest $request     A request to house fields associated with the call.
     * @param array                        $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listServerTlsPolicies(
        ListServerTlsPoliciesRequest $request,
        array $callOptions = []
    ): PagedListResponse {
        return $this->startApiCall('ListServerTlsPolicies', $request, $callOptions);
    }

    /**
     * Updates the parameters of a single AuthorizationPolicy.
     *
     * The async variant is
     * {@see NetworkSecurityClient::updateAuthorizationPolicyAsync()} .
     *
     * @example samples/V1/NetworkSecurityClient/update_authorization_policy.php
     *
     * @param UpdateAuthorizationPolicyRequest $request     A request to house fields associated with the call.
     * @param array                            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateAuthorizationPolicy(
        UpdateAuthorizationPolicyRequest $request,
        array $callOptions = []
    ): OperationResponse {
        return $this->startApiCall('UpdateAuthorizationPolicy', $request, $callOptions)->wait();
    }

    /**
     * Updates the parameters of a single ClientTlsPolicy.
     *
     * The async variant is {@see NetworkSecurityClient::updateClientTlsPolicyAsync()}
     * .
     *
     * @example samples/V1/NetworkSecurityClient/update_client_tls_policy.php
     *
     * @param UpdateClientTlsPolicyRequest $request     A request to house fields associated with the call.
     * @param array                        $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateClientTlsPolicy(
        UpdateClientTlsPolicyRequest $request,
        array $callOptions = []
    ): OperationResponse {
        return $this->startApiCall('UpdateClientTlsPolicy', $request, $callOptions)->wait();
    }

    /**
     * Updates the parameters of a single ServerTlsPolicy.
     *
     * The async variant is {@see NetworkSecurityClient::updateServerTlsPolicyAsync()}
     * .
     *
     * @example samples/V1/NetworkSecurityClient/update_server_tls_policy.php
     *
     * @param UpdateServerTlsPolicyRequest $request     A request to house fields associated with the call.
     * @param array                        $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateServerTlsPolicy(
        UpdateServerTlsPolicyRequest $request,
        array $callOptions = []
    ): OperationResponse {
        return $this->startApiCall('UpdateServerTlsPolicy', $request, $callOptions)->wait();
    }

    /**
     * Gets information about a location.
     *
     * The async variant is {@see NetworkSecurityClient::getLocationAsync()} .
     *
     * @example samples/V1/NetworkSecurityClient/get_location.php
     *
     * @param GetLocationRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Location
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getLocation(GetLocationRequest $request, array $callOptions = []): Location
    {
        return $this->startApiCall('GetLocation', $request, $callOptions)->wait();
    }

    /**
     * Lists information about the supported locations for this service.
     *
     * The async variant is {@see NetworkSecurityClient::listLocationsAsync()} .
     *
     * @example samples/V1/NetworkSecurityClient/list_locations.php
     *
     * @param ListLocationsRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listLocations(ListLocationsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListLocations', $request, $callOptions);
    }

    /**
     * Gets the access control policy for a resource. Returns an empty policy
    if the resource exists and does not have a policy set.
     *
     * The async variant is {@see NetworkSecurityClient::getIamPolicyAsync()} .
     *
     * @example samples/V1/NetworkSecurityClient/get_iam_policy.php
     *
     * @param GetIamPolicyRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Policy
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getIamPolicy(GetIamPolicyRequest $request, array $callOptions = []): Policy
    {
        return $this->startApiCall('GetIamPolicy', $request, $callOptions)->wait();
    }

    /**
     * Sets the access control policy on the specified resource. Replaces
    any existing policy.

    Can return `NOT_FOUND`, `INVALID_ARGUMENT`, and `PERMISSION_DENIED`
    errors.
     *
     * The async variant is {@see NetworkSecurityClient::setIamPolicyAsync()} .
     *
     * @example samples/V1/NetworkSecurityClient/set_iam_policy.php
     *
     * @param SetIamPolicyRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Policy
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function setIamPolicy(SetIamPolicyRequest $request, array $callOptions = []): Policy
    {
        return $this->startApiCall('SetIamPolicy', $request, $callOptions)->wait();
    }

    /**
     * Returns permissions that a caller has on the specified resource. If the
    resource does not exist, this will return an empty set of
    permissions, not a `NOT_FOUND` error.

    Note: This operation is designed to be used for building
    permission-aware UIs and command-line tools, not for authorization
    checking. This operation may "fail open" without warning.
     *
     * The async variant is {@see NetworkSecurityClient::testIamPermissionsAsync()} .
     *
     * @example samples/V1/NetworkSecurityClient/test_iam_permissions.php
     *
     * @param TestIamPermissionsRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return TestIamPermissionsResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function testIamPermissions(
        TestIamPermissionsRequest $request,
        array $callOptions = []
    ): TestIamPermissionsResponse {
        return $this->startApiCall('TestIamPermissions', $request, $callOptions)->wait();
    }
}
