<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/networkmanagement/v1/connectivity_test.proto

namespace Google\Cloud\NetworkManagement\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Source or destination of the Connectivity Test.
 *
 * Generated from protobuf message <code>google.cloud.networkmanagement.v1.Endpoint</code>
 */
class Endpoint extends \Google\Protobuf\Internal\Message
{
    /**
     * The IP address of the endpoint, which can be an external or internal IP.
     *
     * Generated from protobuf field <code>string ip_address = 1;</code>
     */
    protected $ip_address = '';
    /**
     * The IP protocol port of the endpoint.
     * Only applicable when protocol is TCP or UDP.
     *
     * Generated from protobuf field <code>int32 port = 2;</code>
     */
    protected $port = 0;
    /**
     * A Compute Engine instance URI.
     *
     * Generated from protobuf field <code>string instance = 3;</code>
     */
    protected $instance = '';
    /**
     * A forwarding rule and its corresponding IP address represent the frontend
     * configuration of a Google Cloud load balancer. Forwarding rules are also
     * used for protocol forwarding, Private Service Connect and other network
     * services to provide forwarding information in the control plane. Format:
     *  projects/{project}/global/forwardingRules/{id} or
     *  projects/{project}/regions/{region}/forwardingRules/{id}
     *
     * Generated from protobuf field <code>string forwarding_rule = 13;</code>
     */
    protected $forwarding_rule = '';
    /**
     * Output only. Specifies the type of the target of the forwarding rule.
     *
     * Generated from protobuf field <code>optional .google.cloud.networkmanagement.v1.Endpoint.ForwardingRuleTarget forwarding_rule_target = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $forwarding_rule_target = null;
    /**
     * Output only. ID of the load balancer the forwarding rule points to. Empty
     * for forwarding rules not related to load balancers.
     *
     * Generated from protobuf field <code>optional string load_balancer_id = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $load_balancer_id = null;
    /**
     * Output only. Type of the load balancer the forwarding rule points to.
     *
     * Generated from protobuf field <code>optional .google.cloud.networkmanagement.v1.LoadBalancerType load_balancer_type = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $load_balancer_type = null;
    /**
     * A cluster URI for [Google Kubernetes Engine cluster control
     * plane](https://cloud.google.com/kubernetes-engine/docs/concepts/cluster-architecture).
     *
     * Generated from protobuf field <code>string gke_master_cluster = 7;</code>
     */
    protected $gke_master_cluster = '';
    /**
     * DNS endpoint of [Google Kubernetes Engine cluster control
     * plane](https://cloud.google.com/kubernetes-engine/docs/concepts/cluster-architecture).
     * Requires gke_master_cluster to be set, can't be used simultaneoulsly with
     * ip_address or network. Applicable only to destination endpoint.
     *
     * Generated from protobuf field <code>string fqdn = 19;</code>
     */
    protected $fqdn = '';
    /**
     * A [Cloud SQL](https://cloud.google.com/sql) instance URI.
     *
     * Generated from protobuf field <code>string cloud_sql_instance = 8;</code>
     */
    protected $cloud_sql_instance = '';
    /**
     * A [Redis Instance](https://cloud.google.com/memorystore/docs/redis)
     * URI.
     *
     * Generated from protobuf field <code>string redis_instance = 17;</code>
     */
    protected $redis_instance = '';
    /**
     * A [Redis Cluster](https://cloud.google.com/memorystore/docs/cluster)
     * URI.
     *
     * Generated from protobuf field <code>string redis_cluster = 18;</code>
     */
    protected $redis_cluster = '';
    /**
     * A [Cloud Function](https://cloud.google.com/functions).
     *
     * Generated from protobuf field <code>.google.cloud.networkmanagement.v1.Endpoint.CloudFunctionEndpoint cloud_function = 10;</code>
     */
    protected $cloud_function = null;
    /**
     * An [App Engine](https://cloud.google.com/appengine) [service
     * version](https://cloud.google.com/appengine/docs/admin-api/reference/rest/v1/apps.services.versions).
     *
     * Generated from protobuf field <code>.google.cloud.networkmanagement.v1.Endpoint.AppEngineVersionEndpoint app_engine_version = 11;</code>
     */
    protected $app_engine_version = null;
    /**
     * A [Cloud Run](https://cloud.google.com/run)
     * [revision](https://cloud.google.com/run/docs/reference/rest/v1/namespaces.revisions/get)
     *
     * Generated from protobuf field <code>.google.cloud.networkmanagement.v1.Endpoint.CloudRunRevisionEndpoint cloud_run_revision = 12;</code>
     */
    protected $cloud_run_revision = null;
    /**
     * A Compute Engine network URI.
     *
     * Generated from protobuf field <code>string network = 4;</code>
     */
    protected $network = '';
    /**
     * Type of the network where the endpoint is located.
     * Applicable only to source endpoint, as destination network type can be
     * inferred from the source.
     *
     * Generated from protobuf field <code>.google.cloud.networkmanagement.v1.Endpoint.NetworkType network_type = 5;</code>
     */
    protected $network_type = 0;
    /**
     * Project ID where the endpoint is located.
     * The Project ID can be derived from the URI if you provide a VM instance or
     * network URI.
     * The following are two cases where you must provide the project ID:
     * 1. Only the IP address is specified, and the IP address is within a Google
     * Cloud project.
     * 2. When you are using Shared VPC and the IP address that you provide is
     * from the service project. In this case, the network that the IP address
     * resides in is defined in the host project.
     *
     * Generated from protobuf field <code>string project_id = 6;</code>
     */
    protected $project_id = '';

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $ip_address
     *           The IP address of the endpoint, which can be an external or internal IP.
     *     @type int $port
     *           The IP protocol port of the endpoint.
     *           Only applicable when protocol is TCP or UDP.
     *     @type string $instance
     *           A Compute Engine instance URI.
     *     @type string $forwarding_rule
     *           A forwarding rule and its corresponding IP address represent the frontend
     *           configuration of a Google Cloud load balancer. Forwarding rules are also
     *           used for protocol forwarding, Private Service Connect and other network
     *           services to provide forwarding information in the control plane. Format:
     *            projects/{project}/global/forwardingRules/{id} or
     *            projects/{project}/regions/{region}/forwardingRules/{id}
     *     @type int $forwarding_rule_target
     *           Output only. Specifies the type of the target of the forwarding rule.
     *     @type string $load_balancer_id
     *           Output only. ID of the load balancer the forwarding rule points to. Empty
     *           for forwarding rules not related to load balancers.
     *     @type int $load_balancer_type
     *           Output only. Type of the load balancer the forwarding rule points to.
     *     @type string $gke_master_cluster
     *           A cluster URI for [Google Kubernetes Engine cluster control
     *           plane](https://cloud.google.com/kubernetes-engine/docs/concepts/cluster-architecture).
     *     @type string $fqdn
     *           DNS endpoint of [Google Kubernetes Engine cluster control
     *           plane](https://cloud.google.com/kubernetes-engine/docs/concepts/cluster-architecture).
     *           Requires gke_master_cluster to be set, can't be used simultaneoulsly with
     *           ip_address or network. Applicable only to destination endpoint.
     *     @type string $cloud_sql_instance
     *           A [Cloud SQL](https://cloud.google.com/sql) instance URI.
     *     @type string $redis_instance
     *           A [Redis Instance](https://cloud.google.com/memorystore/docs/redis)
     *           URI.
     *     @type string $redis_cluster
     *           A [Redis Cluster](https://cloud.google.com/memorystore/docs/cluster)
     *           URI.
     *     @type \Google\Cloud\NetworkManagement\V1\Endpoint\CloudFunctionEndpoint $cloud_function
     *           A [Cloud Function](https://cloud.google.com/functions).
     *     @type \Google\Cloud\NetworkManagement\V1\Endpoint\AppEngineVersionEndpoint $app_engine_version
     *           An [App Engine](https://cloud.google.com/appengine) [service
     *           version](https://cloud.google.com/appengine/docs/admin-api/reference/rest/v1/apps.services.versions).
     *     @type \Google\Cloud\NetworkManagement\V1\Endpoint\CloudRunRevisionEndpoint $cloud_run_revision
     *           A [Cloud Run](https://cloud.google.com/run)
     *           [revision](https://cloud.google.com/run/docs/reference/rest/v1/namespaces.revisions/get)
     *     @type string $network
     *           A Compute Engine network URI.
     *     @type int $network_type
     *           Type of the network where the endpoint is located.
     *           Applicable only to source endpoint, as destination network type can be
     *           inferred from the source.
     *     @type string $project_id
     *           Project ID where the endpoint is located.
     *           The Project ID can be derived from the URI if you provide a VM instance or
     *           network URI.
     *           The following are two cases where you must provide the project ID:
     *           1. Only the IP address is specified, and the IP address is within a Google
     *           Cloud project.
     *           2. When you are using Shared VPC and the IP address that you provide is
     *           from the service project. In this case, the network that the IP address
     *           resides in is defined in the host project.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Networkmanagement\V1\ConnectivityTest::initOnce();
        parent::__construct($data);
    }

    /**
     * The IP address of the endpoint, which can be an external or internal IP.
     *
     * Generated from protobuf field <code>string ip_address = 1;</code>
     * @return string
     */
    public function getIpAddress()
    {
        return $this->ip_address;
    }

    /**
     * The IP address of the endpoint, which can be an external or internal IP.
     *
     * Generated from protobuf field <code>string ip_address = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setIpAddress($var)
    {
        GPBUtil::checkString($var, True);
        $this->ip_address = $var;

        return $this;
    }

    /**
     * The IP protocol port of the endpoint.
     * Only applicable when protocol is TCP or UDP.
     *
     * Generated from protobuf field <code>int32 port = 2;</code>
     * @return int
     */
    public function getPort()
    {
        return $this->port;
    }

    /**
     * The IP protocol port of the endpoint.
     * Only applicable when protocol is TCP or UDP.
     *
     * Generated from protobuf field <code>int32 port = 2;</code>
     * @param int $var
     * @return $this
     */
    public function setPort($var)
    {
        GPBUtil::checkInt32($var);
        $this->port = $var;

        return $this;
    }

    /**
     * A Compute Engine instance URI.
     *
     * Generated from protobuf field <code>string instance = 3;</code>
     * @return string
     */
    public function getInstance()
    {
        return $this->instance;
    }

    /**
     * A Compute Engine instance URI.
     *
     * Generated from protobuf field <code>string instance = 3;</code>
     * @param string $var
     * @return $this
     */
    public function setInstance($var)
    {
        GPBUtil::checkString($var, True);
        $this->instance = $var;

        return $this;
    }

    /**
     * A forwarding rule and its corresponding IP address represent the frontend
     * configuration of a Google Cloud load balancer. Forwarding rules are also
     * used for protocol forwarding, Private Service Connect and other network
     * services to provide forwarding information in the control plane. Format:
     *  projects/{project}/global/forwardingRules/{id} or
     *  projects/{project}/regions/{region}/forwardingRules/{id}
     *
     * Generated from protobuf field <code>string forwarding_rule = 13;</code>
     * @return string
     */
    public function getForwardingRule()
    {
        return $this->forwarding_rule;
    }

    /**
     * A forwarding rule and its corresponding IP address represent the frontend
     * configuration of a Google Cloud load balancer. Forwarding rules are also
     * used for protocol forwarding, Private Service Connect and other network
     * services to provide forwarding information in the control plane. Format:
     *  projects/{project}/global/forwardingRules/{id} or
     *  projects/{project}/regions/{region}/forwardingRules/{id}
     *
     * Generated from protobuf field <code>string forwarding_rule = 13;</code>
     * @param string $var
     * @return $this
     */
    public function setForwardingRule($var)
    {
        GPBUtil::checkString($var, True);
        $this->forwarding_rule = $var;

        return $this;
    }

    /**
     * Output only. Specifies the type of the target of the forwarding rule.
     *
     * Generated from protobuf field <code>optional .google.cloud.networkmanagement.v1.Endpoint.ForwardingRuleTarget forwarding_rule_target = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int
     */
    public function getForwardingRuleTarget()
    {
        return isset($this->forwarding_rule_target) ? $this->forwarding_rule_target : 0;
    }

    public function hasForwardingRuleTarget()
    {
        return isset($this->forwarding_rule_target);
    }

    public function clearForwardingRuleTarget()
    {
        unset($this->forwarding_rule_target);
    }

    /**
     * Output only. Specifies the type of the target of the forwarding rule.
     *
     * Generated from protobuf field <code>optional .google.cloud.networkmanagement.v1.Endpoint.ForwardingRuleTarget forwarding_rule_target = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int $var
     * @return $this
     */
    public function setForwardingRuleTarget($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\NetworkManagement\V1\Endpoint\ForwardingRuleTarget::class);
        $this->forwarding_rule_target = $var;

        return $this;
    }

    /**
     * Output only. ID of the load balancer the forwarding rule points to. Empty
     * for forwarding rules not related to load balancers.
     *
     * Generated from protobuf field <code>optional string load_balancer_id = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getLoadBalancerId()
    {
        return isset($this->load_balancer_id) ? $this->load_balancer_id : '';
    }

    public function hasLoadBalancerId()
    {
        return isset($this->load_balancer_id);
    }

    public function clearLoadBalancerId()
    {
        unset($this->load_balancer_id);
    }

    /**
     * Output only. ID of the load balancer the forwarding rule points to. Empty
     * for forwarding rules not related to load balancers.
     *
     * Generated from protobuf field <code>optional string load_balancer_id = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setLoadBalancerId($var)
    {
        GPBUtil::checkString($var, True);
        $this->load_balancer_id = $var;

        return $this;
    }

    /**
     * Output only. Type of the load balancer the forwarding rule points to.
     *
     * Generated from protobuf field <code>optional .google.cloud.networkmanagement.v1.LoadBalancerType load_balancer_type = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int
     */
    public function getLoadBalancerType()
    {
        return isset($this->load_balancer_type) ? $this->load_balancer_type : 0;
    }

    public function hasLoadBalancerType()
    {
        return isset($this->load_balancer_type);
    }

    public function clearLoadBalancerType()
    {
        unset($this->load_balancer_type);
    }

    /**
     * Output only. Type of the load balancer the forwarding rule points to.
     *
     * Generated from protobuf field <code>optional .google.cloud.networkmanagement.v1.LoadBalancerType load_balancer_type = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int $var
     * @return $this
     */
    public function setLoadBalancerType($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\NetworkManagement\V1\LoadBalancerType::class);
        $this->load_balancer_type = $var;

        return $this;
    }

    /**
     * A cluster URI for [Google Kubernetes Engine cluster control
     * plane](https://cloud.google.com/kubernetes-engine/docs/concepts/cluster-architecture).
     *
     * Generated from protobuf field <code>string gke_master_cluster = 7;</code>
     * @return string
     */
    public function getGkeMasterCluster()
    {
        return $this->gke_master_cluster;
    }

    /**
     * A cluster URI for [Google Kubernetes Engine cluster control
     * plane](https://cloud.google.com/kubernetes-engine/docs/concepts/cluster-architecture).
     *
     * Generated from protobuf field <code>string gke_master_cluster = 7;</code>
     * @param string $var
     * @return $this
     */
    public function setGkeMasterCluster($var)
    {
        GPBUtil::checkString($var, True);
        $this->gke_master_cluster = $var;

        return $this;
    }

    /**
     * DNS endpoint of [Google Kubernetes Engine cluster control
     * plane](https://cloud.google.com/kubernetes-engine/docs/concepts/cluster-architecture).
     * Requires gke_master_cluster to be set, can't be used simultaneoulsly with
     * ip_address or network. Applicable only to destination endpoint.
     *
     * Generated from protobuf field <code>string fqdn = 19;</code>
     * @return string
     */
    public function getFqdn()
    {
        return $this->fqdn;
    }

    /**
     * DNS endpoint of [Google Kubernetes Engine cluster control
     * plane](https://cloud.google.com/kubernetes-engine/docs/concepts/cluster-architecture).
     * Requires gke_master_cluster to be set, can't be used simultaneoulsly with
     * ip_address or network. Applicable only to destination endpoint.
     *
     * Generated from protobuf field <code>string fqdn = 19;</code>
     * @param string $var
     * @return $this
     */
    public function setFqdn($var)
    {
        GPBUtil::checkString($var, True);
        $this->fqdn = $var;

        return $this;
    }

    /**
     * A [Cloud SQL](https://cloud.google.com/sql) instance URI.
     *
     * Generated from protobuf field <code>string cloud_sql_instance = 8;</code>
     * @return string
     */
    public function getCloudSqlInstance()
    {
        return $this->cloud_sql_instance;
    }

    /**
     * A [Cloud SQL](https://cloud.google.com/sql) instance URI.
     *
     * Generated from protobuf field <code>string cloud_sql_instance = 8;</code>
     * @param string $var
     * @return $this
     */
    public function setCloudSqlInstance($var)
    {
        GPBUtil::checkString($var, True);
        $this->cloud_sql_instance = $var;

        return $this;
    }

    /**
     * A [Redis Instance](https://cloud.google.com/memorystore/docs/redis)
     * URI.
     *
     * Generated from protobuf field <code>string redis_instance = 17;</code>
     * @return string
     */
    public function getRedisInstance()
    {
        return $this->redis_instance;
    }

    /**
     * A [Redis Instance](https://cloud.google.com/memorystore/docs/redis)
     * URI.
     *
     * Generated from protobuf field <code>string redis_instance = 17;</code>
     * @param string $var
     * @return $this
     */
    public function setRedisInstance($var)
    {
        GPBUtil::checkString($var, True);
        $this->redis_instance = $var;

        return $this;
    }

    /**
     * A [Redis Cluster](https://cloud.google.com/memorystore/docs/cluster)
     * URI.
     *
     * Generated from protobuf field <code>string redis_cluster = 18;</code>
     * @return string
     */
    public function getRedisCluster()
    {
        return $this->redis_cluster;
    }

    /**
     * A [Redis Cluster](https://cloud.google.com/memorystore/docs/cluster)
     * URI.
     *
     * Generated from protobuf field <code>string redis_cluster = 18;</code>
     * @param string $var
     * @return $this
     */
    public function setRedisCluster($var)
    {
        GPBUtil::checkString($var, True);
        $this->redis_cluster = $var;

        return $this;
    }

    /**
     * A [Cloud Function](https://cloud.google.com/functions).
     *
     * Generated from protobuf field <code>.google.cloud.networkmanagement.v1.Endpoint.CloudFunctionEndpoint cloud_function = 10;</code>
     * @return \Google\Cloud\NetworkManagement\V1\Endpoint\CloudFunctionEndpoint|null
     */
    public function getCloudFunction()
    {
        return $this->cloud_function;
    }

    public function hasCloudFunction()
    {
        return isset($this->cloud_function);
    }

    public function clearCloudFunction()
    {
        unset($this->cloud_function);
    }

    /**
     * A [Cloud Function](https://cloud.google.com/functions).
     *
     * Generated from protobuf field <code>.google.cloud.networkmanagement.v1.Endpoint.CloudFunctionEndpoint cloud_function = 10;</code>
     * @param \Google\Cloud\NetworkManagement\V1\Endpoint\CloudFunctionEndpoint $var
     * @return $this
     */
    public function setCloudFunction($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\NetworkManagement\V1\Endpoint\CloudFunctionEndpoint::class);
        $this->cloud_function = $var;

        return $this;
    }

    /**
     * An [App Engine](https://cloud.google.com/appengine) [service
     * version](https://cloud.google.com/appengine/docs/admin-api/reference/rest/v1/apps.services.versions).
     *
     * Generated from protobuf field <code>.google.cloud.networkmanagement.v1.Endpoint.AppEngineVersionEndpoint app_engine_version = 11;</code>
     * @return \Google\Cloud\NetworkManagement\V1\Endpoint\AppEngineVersionEndpoint|null
     */
    public function getAppEngineVersion()
    {
        return $this->app_engine_version;
    }

    public function hasAppEngineVersion()
    {
        return isset($this->app_engine_version);
    }

    public function clearAppEngineVersion()
    {
        unset($this->app_engine_version);
    }

    /**
     * An [App Engine](https://cloud.google.com/appengine) [service
     * version](https://cloud.google.com/appengine/docs/admin-api/reference/rest/v1/apps.services.versions).
     *
     * Generated from protobuf field <code>.google.cloud.networkmanagement.v1.Endpoint.AppEngineVersionEndpoint app_engine_version = 11;</code>
     * @param \Google\Cloud\NetworkManagement\V1\Endpoint\AppEngineVersionEndpoint $var
     * @return $this
     */
    public function setAppEngineVersion($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\NetworkManagement\V1\Endpoint\AppEngineVersionEndpoint::class);
        $this->app_engine_version = $var;

        return $this;
    }

    /**
     * A [Cloud Run](https://cloud.google.com/run)
     * [revision](https://cloud.google.com/run/docs/reference/rest/v1/namespaces.revisions/get)
     *
     * Generated from protobuf field <code>.google.cloud.networkmanagement.v1.Endpoint.CloudRunRevisionEndpoint cloud_run_revision = 12;</code>
     * @return \Google\Cloud\NetworkManagement\V1\Endpoint\CloudRunRevisionEndpoint|null
     */
    public function getCloudRunRevision()
    {
        return $this->cloud_run_revision;
    }

    public function hasCloudRunRevision()
    {
        return isset($this->cloud_run_revision);
    }

    public function clearCloudRunRevision()
    {
        unset($this->cloud_run_revision);
    }

    /**
     * A [Cloud Run](https://cloud.google.com/run)
     * [revision](https://cloud.google.com/run/docs/reference/rest/v1/namespaces.revisions/get)
     *
     * Generated from protobuf field <code>.google.cloud.networkmanagement.v1.Endpoint.CloudRunRevisionEndpoint cloud_run_revision = 12;</code>
     * @param \Google\Cloud\NetworkManagement\V1\Endpoint\CloudRunRevisionEndpoint $var
     * @return $this
     */
    public function setCloudRunRevision($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\NetworkManagement\V1\Endpoint\CloudRunRevisionEndpoint::class);
        $this->cloud_run_revision = $var;

        return $this;
    }

    /**
     * A Compute Engine network URI.
     *
     * Generated from protobuf field <code>string network = 4;</code>
     * @return string
     */
    public function getNetwork()
    {
        return $this->network;
    }

    /**
     * A Compute Engine network URI.
     *
     * Generated from protobuf field <code>string network = 4;</code>
     * @param string $var
     * @return $this
     */
    public function setNetwork($var)
    {
        GPBUtil::checkString($var, True);
        $this->network = $var;

        return $this;
    }

    /**
     * Type of the network where the endpoint is located.
     * Applicable only to source endpoint, as destination network type can be
     * inferred from the source.
     *
     * Generated from protobuf field <code>.google.cloud.networkmanagement.v1.Endpoint.NetworkType network_type = 5;</code>
     * @return int
     */
    public function getNetworkType()
    {
        return $this->network_type;
    }

    /**
     * Type of the network where the endpoint is located.
     * Applicable only to source endpoint, as destination network type can be
     * inferred from the source.
     *
     * Generated from protobuf field <code>.google.cloud.networkmanagement.v1.Endpoint.NetworkType network_type = 5;</code>
     * @param int $var
     * @return $this
     */
    public function setNetworkType($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\NetworkManagement\V1\Endpoint\NetworkType::class);
        $this->network_type = $var;

        return $this;
    }

    /**
     * Project ID where the endpoint is located.
     * The Project ID can be derived from the URI if you provide a VM instance or
     * network URI.
     * The following are two cases where you must provide the project ID:
     * 1. Only the IP address is specified, and the IP address is within a Google
     * Cloud project.
     * 2. When you are using Shared VPC and the IP address that you provide is
     * from the service project. In this case, the network that the IP address
     * resides in is defined in the host project.
     *
     * Generated from protobuf field <code>string project_id = 6;</code>
     * @return string
     */
    public function getProjectId()
    {
        return $this->project_id;
    }

    /**
     * Project ID where the endpoint is located.
     * The Project ID can be derived from the URI if you provide a VM instance or
     * network URI.
     * The following are two cases where you must provide the project ID:
     * 1. Only the IP address is specified, and the IP address is within a Google
     * Cloud project.
     * 2. When you are using Shared VPC and the IP address that you provide is
     * from the service project. In this case, the network that the IP address
     * resides in is defined in the host project.
     *
     * Generated from protobuf field <code>string project_id = 6;</code>
     * @param string $var
     * @return $this
     */
    public function setProjectId($var)
    {
        GPBUtil::checkString($var, True);
        $this->project_id = $var;

        return $this;
    }

}

