<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/monitoring/v3/uptime.proto

namespace Google\Cloud\Monitoring\V3;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * This message configures which resources and services to monitor for
 * availability.
 *
 * Generated from protobuf message <code>google.monitoring.v3.UptimeCheckConfig</code>
 */
class UptimeCheckConfig extends \Google\Protobuf\Internal\Message
{
    /**
     * Identifier. A unique resource name for this Uptime check configuration. The
     * format is:
     *      projects/[PROJECT_ID_OR_NUMBER]/uptimeCheckConfigs/[UPTIME_CHECK_ID]
     * `[PROJECT_ID_OR_NUMBER]` is the Workspace host project associated with the
     * Uptime check.
     * This field should be omitted when creating the Uptime check configuration;
     * on create, the resource name is assigned by the server and included in the
     * response.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     */
    protected $name = '';
    /**
     * A human-friendly name for the Uptime check configuration. The display name
     * should be unique within a Cloud Monitoring Workspace in order to make it
     * easier to identify; however, uniqueness is not enforced. Required.
     *
     * Generated from protobuf field <code>string display_name = 2;</code>
     */
    protected $display_name = '';
    /**
     * How often, in seconds, the Uptime check is performed.
     * Currently, the only supported values are `60s` (1 minute), `300s`
     * (5 minutes), `600s` (10 minutes), and `900s` (15 minutes). Optional,
     * defaults to `60s`.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration period = 7;</code>
     */
    protected $period = null;
    /**
     * The maximum amount of time to wait for the request to complete (must be
     * between 1 and 60 seconds). Required.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration timeout = 8;</code>
     */
    protected $timeout = null;
    /**
     * The content that is expected to appear in the data returned by the target
     * server against which the check is run.  Currently, only the first entry
     * in the `content_matchers` list is supported, and additional entries will
     * be ignored. This field is optional and should only be specified if a
     * content match is required as part of the/ Uptime check.
     *
     * Generated from protobuf field <code>repeated .google.monitoring.v3.UptimeCheckConfig.ContentMatcher content_matchers = 9;</code>
     */
    private $content_matchers;
    /**
     * The type of checkers to use to execute the Uptime check.
     *
     * Generated from protobuf field <code>.google.monitoring.v3.UptimeCheckConfig.CheckerType checker_type = 17;</code>
     */
    protected $checker_type = 0;
    /**
     * The list of regions from which the check will be run.
     * Some regions contain one location, and others contain more than one.
     * If this field is specified, enough regions must be provided to include a
     * minimum of 3 locations.  Not specifying this field will result in Uptime
     * checks running from all available regions.
     *
     * Generated from protobuf field <code>repeated .google.monitoring.v3.UptimeCheckRegion selected_regions = 10;</code>
     */
    private $selected_regions;
    /**
     * If this is `true`, then checks are made only from the 'internal_checkers'.
     * If it is `false`, then checks are made only from the 'selected_regions'.
     * It is an error to provide 'selected_regions' when is_internal is `true`,
     * or to provide 'internal_checkers' when is_internal is `false`.
     *
     * Generated from protobuf field <code>bool is_internal = 15 [deprecated = true];</code>
     * @deprecated
     */
    protected $is_internal = false;
    /**
     * The internal checkers that this check will egress from. If `is_internal` is
     * `true` and this list is empty, the check will egress from all the
     * InternalCheckers configured for the project that owns this
     * `UptimeCheckConfig`.
     *
     * Generated from protobuf field <code>repeated .google.monitoring.v3.InternalChecker internal_checkers = 14 [deprecated = true];</code>
     * @deprecated
     */
    private $internal_checkers;
    /**
     * User-supplied key/value data to be used for organizing and
     * identifying the `UptimeCheckConfig` objects.
     * The field can contain up to 64 entries. Each key and value is limited to
     * 63 Unicode characters or 128 bytes, whichever is smaller. Labels and
     * values can contain only lowercase letters, numerals, underscores, and
     * dashes. Keys must begin with a letter.
     *
     * Generated from protobuf field <code>map<string, string> user_labels = 20;</code>
     */
    private $user_labels;
    protected $resource;
    protected $check_request_type;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           Identifier. A unique resource name for this Uptime check configuration. The
     *           format is:
     *                projects/[PROJECT_ID_OR_NUMBER]/uptimeCheckConfigs/[UPTIME_CHECK_ID]
     *           `[PROJECT_ID_OR_NUMBER]` is the Workspace host project associated with the
     *           Uptime check.
     *           This field should be omitted when creating the Uptime check configuration;
     *           on create, the resource name is assigned by the server and included in the
     *           response.
     *     @type string $display_name
     *           A human-friendly name for the Uptime check configuration. The display name
     *           should be unique within a Cloud Monitoring Workspace in order to make it
     *           easier to identify; however, uniqueness is not enforced. Required.
     *     @type \Google\Api\MonitoredResource $monitored_resource
     *           The [monitored
     *           resource](https://cloud.google.com/monitoring/api/resources) associated
     *           with the configuration.
     *           The following monitored resource types are valid for this field:
     *             `uptime_url`,
     *             `gce_instance`,
     *             `gae_app`,
     *             `aws_ec2_instance`,
     *             `aws_elb_load_balancer`
     *             `k8s_service`
     *             `servicedirectory_service`
     *             `cloud_run_revision`
     *     @type \Google\Cloud\Monitoring\V3\UptimeCheckConfig\ResourceGroup $resource_group
     *           The group resource associated with the configuration.
     *     @type \Google\Cloud\Monitoring\V3\SyntheticMonitorTarget $synthetic_monitor
     *           Specifies a Synthetic Monitor to invoke.
     *     @type \Google\Cloud\Monitoring\V3\UptimeCheckConfig\HttpCheck $http_check
     *           Contains information needed to make an HTTP or HTTPS check.
     *     @type \Google\Cloud\Monitoring\V3\UptimeCheckConfig\TcpCheck $tcp_check
     *           Contains information needed to make a TCP check.
     *     @type \Google\Protobuf\Duration $period
     *           How often, in seconds, the Uptime check is performed.
     *           Currently, the only supported values are `60s` (1 minute), `300s`
     *           (5 minutes), `600s` (10 minutes), and `900s` (15 minutes). Optional,
     *           defaults to `60s`.
     *     @type \Google\Protobuf\Duration $timeout
     *           The maximum amount of time to wait for the request to complete (must be
     *           between 1 and 60 seconds). Required.
     *     @type array<\Google\Cloud\Monitoring\V3\UptimeCheckConfig\ContentMatcher>|\Google\Protobuf\Internal\RepeatedField $content_matchers
     *           The content that is expected to appear in the data returned by the target
     *           server against which the check is run.  Currently, only the first entry
     *           in the `content_matchers` list is supported, and additional entries will
     *           be ignored. This field is optional and should only be specified if a
     *           content match is required as part of the/ Uptime check.
     *     @type int $checker_type
     *           The type of checkers to use to execute the Uptime check.
     *     @type array<int>|\Google\Protobuf\Internal\RepeatedField $selected_regions
     *           The list of regions from which the check will be run.
     *           Some regions contain one location, and others contain more than one.
     *           If this field is specified, enough regions must be provided to include a
     *           minimum of 3 locations.  Not specifying this field will result in Uptime
     *           checks running from all available regions.
     *     @type bool $is_internal
     *           If this is `true`, then checks are made only from the 'internal_checkers'.
     *           If it is `false`, then checks are made only from the 'selected_regions'.
     *           It is an error to provide 'selected_regions' when is_internal is `true`,
     *           or to provide 'internal_checkers' when is_internal is `false`.
     *     @type array<\Google\Cloud\Monitoring\V3\InternalChecker>|\Google\Protobuf\Internal\RepeatedField $internal_checkers
     *           The internal checkers that this check will egress from. If `is_internal` is
     *           `true` and this list is empty, the check will egress from all the
     *           InternalCheckers configured for the project that owns this
     *           `UptimeCheckConfig`.
     *     @type array|\Google\Protobuf\Internal\MapField $user_labels
     *           User-supplied key/value data to be used for organizing and
     *           identifying the `UptimeCheckConfig` objects.
     *           The field can contain up to 64 entries. Each key and value is limited to
     *           63 Unicode characters or 128 bytes, whichever is smaller. Labels and
     *           values can contain only lowercase letters, numerals, underscores, and
     *           dashes. Keys must begin with a letter.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Monitoring\V3\Uptime::initOnce();
        parent::__construct($data);
    }

    /**
     * Identifier. A unique resource name for this Uptime check configuration. The
     * format is:
     *      projects/[PROJECT_ID_OR_NUMBER]/uptimeCheckConfigs/[UPTIME_CHECK_ID]
     * `[PROJECT_ID_OR_NUMBER]` is the Workspace host project associated with the
     * Uptime check.
     * This field should be omitted when creating the Uptime check configuration;
     * on create, the resource name is assigned by the server and included in the
     * response.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Identifier. A unique resource name for this Uptime check configuration. The
     * format is:
     *      projects/[PROJECT_ID_OR_NUMBER]/uptimeCheckConfigs/[UPTIME_CHECK_ID]
     * `[PROJECT_ID_OR_NUMBER]` is the Workspace host project associated with the
     * Uptime check.
     * This field should be omitted when creating the Uptime check configuration;
     * on create, the resource name is assigned by the server and included in the
     * response.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * A human-friendly name for the Uptime check configuration. The display name
     * should be unique within a Cloud Monitoring Workspace in order to make it
     * easier to identify; however, uniqueness is not enforced. Required.
     *
     * Generated from protobuf field <code>string display_name = 2;</code>
     * @return string
     */
    public function getDisplayName()
    {
        return $this->display_name;
    }

    /**
     * A human-friendly name for the Uptime check configuration. The display name
     * should be unique within a Cloud Monitoring Workspace in order to make it
     * easier to identify; however, uniqueness is not enforced. Required.
     *
     * Generated from protobuf field <code>string display_name = 2;</code>
     * @param string $var
     * @return $this
     */
    public function setDisplayName($var)
    {
        GPBUtil::checkString($var, True);
        $this->display_name = $var;

        return $this;
    }

    /**
     * The [monitored
     * resource](https://cloud.google.com/monitoring/api/resources) associated
     * with the configuration.
     * The following monitored resource types are valid for this field:
     *   `uptime_url`,
     *   `gce_instance`,
     *   `gae_app`,
     *   `aws_ec2_instance`,
     *   `aws_elb_load_balancer`
     *   `k8s_service`
     *   `servicedirectory_service`
     *   `cloud_run_revision`
     *
     * Generated from protobuf field <code>.google.api.MonitoredResource monitored_resource = 3;</code>
     * @return \Google\Api\MonitoredResource|null
     */
    public function getMonitoredResource()
    {
        return $this->readOneof(3);
    }

    public function hasMonitoredResource()
    {
        return $this->hasOneof(3);
    }

    /**
     * The [monitored
     * resource](https://cloud.google.com/monitoring/api/resources) associated
     * with the configuration.
     * The following monitored resource types are valid for this field:
     *   `uptime_url`,
     *   `gce_instance`,
     *   `gae_app`,
     *   `aws_ec2_instance`,
     *   `aws_elb_load_balancer`
     *   `k8s_service`
     *   `servicedirectory_service`
     *   `cloud_run_revision`
     *
     * Generated from protobuf field <code>.google.api.MonitoredResource monitored_resource = 3;</code>
     * @param \Google\Api\MonitoredResource $var
     * @return $this
     */
    public function setMonitoredResource($var)
    {
        GPBUtil::checkMessage($var, \Google\Api\MonitoredResource::class);
        $this->writeOneof(3, $var);

        return $this;
    }

    /**
     * The group resource associated with the configuration.
     *
     * Generated from protobuf field <code>.google.monitoring.v3.UptimeCheckConfig.ResourceGroup resource_group = 4;</code>
     * @return \Google\Cloud\Monitoring\V3\UptimeCheckConfig\ResourceGroup|null
     */
    public function getResourceGroup()
    {
        return $this->readOneof(4);
    }

    public function hasResourceGroup()
    {
        return $this->hasOneof(4);
    }

    /**
     * The group resource associated with the configuration.
     *
     * Generated from protobuf field <code>.google.monitoring.v3.UptimeCheckConfig.ResourceGroup resource_group = 4;</code>
     * @param \Google\Cloud\Monitoring\V3\UptimeCheckConfig\ResourceGroup $var
     * @return $this
     */
    public function setResourceGroup($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Monitoring\V3\UptimeCheckConfig\ResourceGroup::class);
        $this->writeOneof(4, $var);

        return $this;
    }

    /**
     * Specifies a Synthetic Monitor to invoke.
     *
     * Generated from protobuf field <code>.google.monitoring.v3.SyntheticMonitorTarget synthetic_monitor = 21;</code>
     * @return \Google\Cloud\Monitoring\V3\SyntheticMonitorTarget|null
     */
    public function getSyntheticMonitor()
    {
        return $this->readOneof(21);
    }

    public function hasSyntheticMonitor()
    {
        return $this->hasOneof(21);
    }

    /**
     * Specifies a Synthetic Monitor to invoke.
     *
     * Generated from protobuf field <code>.google.monitoring.v3.SyntheticMonitorTarget synthetic_monitor = 21;</code>
     * @param \Google\Cloud\Monitoring\V3\SyntheticMonitorTarget $var
     * @return $this
     */
    public function setSyntheticMonitor($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Monitoring\V3\SyntheticMonitorTarget::class);
        $this->writeOneof(21, $var);

        return $this;
    }

    /**
     * Contains information needed to make an HTTP or HTTPS check.
     *
     * Generated from protobuf field <code>.google.monitoring.v3.UptimeCheckConfig.HttpCheck http_check = 5;</code>
     * @return \Google\Cloud\Monitoring\V3\UptimeCheckConfig\HttpCheck|null
     */
    public function getHttpCheck()
    {
        return $this->readOneof(5);
    }

    public function hasHttpCheck()
    {
        return $this->hasOneof(5);
    }

    /**
     * Contains information needed to make an HTTP or HTTPS check.
     *
     * Generated from protobuf field <code>.google.monitoring.v3.UptimeCheckConfig.HttpCheck http_check = 5;</code>
     * @param \Google\Cloud\Monitoring\V3\UptimeCheckConfig\HttpCheck $var
     * @return $this
     */
    public function setHttpCheck($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Monitoring\V3\UptimeCheckConfig\HttpCheck::class);
        $this->writeOneof(5, $var);

        return $this;
    }

    /**
     * Contains information needed to make a TCP check.
     *
     * Generated from protobuf field <code>.google.monitoring.v3.UptimeCheckConfig.TcpCheck tcp_check = 6;</code>
     * @return \Google\Cloud\Monitoring\V3\UptimeCheckConfig\TcpCheck|null
     */
    public function getTcpCheck()
    {
        return $this->readOneof(6);
    }

    public function hasTcpCheck()
    {
        return $this->hasOneof(6);
    }

    /**
     * Contains information needed to make a TCP check.
     *
     * Generated from protobuf field <code>.google.monitoring.v3.UptimeCheckConfig.TcpCheck tcp_check = 6;</code>
     * @param \Google\Cloud\Monitoring\V3\UptimeCheckConfig\TcpCheck $var
     * @return $this
     */
    public function setTcpCheck($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Monitoring\V3\UptimeCheckConfig\TcpCheck::class);
        $this->writeOneof(6, $var);

        return $this;
    }

    /**
     * How often, in seconds, the Uptime check is performed.
     * Currently, the only supported values are `60s` (1 minute), `300s`
     * (5 minutes), `600s` (10 minutes), and `900s` (15 minutes). Optional,
     * defaults to `60s`.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration period = 7;</code>
     * @return \Google\Protobuf\Duration|null
     */
    public function getPeriod()
    {
        return $this->period;
    }

    public function hasPeriod()
    {
        return isset($this->period);
    }

    public function clearPeriod()
    {
        unset($this->period);
    }

    /**
     * How often, in seconds, the Uptime check is performed.
     * Currently, the only supported values are `60s` (1 minute), `300s`
     * (5 minutes), `600s` (10 minutes), and `900s` (15 minutes). Optional,
     * defaults to `60s`.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration period = 7;</code>
     * @param \Google\Protobuf\Duration $var
     * @return $this
     */
    public function setPeriod($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Duration::class);
        $this->period = $var;

        return $this;
    }

    /**
     * The maximum amount of time to wait for the request to complete (must be
     * between 1 and 60 seconds). Required.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration timeout = 8;</code>
     * @return \Google\Protobuf\Duration|null
     */
    public function getTimeout()
    {
        return $this->timeout;
    }

    public function hasTimeout()
    {
        return isset($this->timeout);
    }

    public function clearTimeout()
    {
        unset($this->timeout);
    }

    /**
     * The maximum amount of time to wait for the request to complete (must be
     * between 1 and 60 seconds). Required.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration timeout = 8;</code>
     * @param \Google\Protobuf\Duration $var
     * @return $this
     */
    public function setTimeout($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Duration::class);
        $this->timeout = $var;

        return $this;
    }

    /**
     * The content that is expected to appear in the data returned by the target
     * server against which the check is run.  Currently, only the first entry
     * in the `content_matchers` list is supported, and additional entries will
     * be ignored. This field is optional and should only be specified if a
     * content match is required as part of the/ Uptime check.
     *
     * Generated from protobuf field <code>repeated .google.monitoring.v3.UptimeCheckConfig.ContentMatcher content_matchers = 9;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getContentMatchers()
    {
        return $this->content_matchers;
    }

    /**
     * The content that is expected to appear in the data returned by the target
     * server against which the check is run.  Currently, only the first entry
     * in the `content_matchers` list is supported, and additional entries will
     * be ignored. This field is optional and should only be specified if a
     * content match is required as part of the/ Uptime check.
     *
     * Generated from protobuf field <code>repeated .google.monitoring.v3.UptimeCheckConfig.ContentMatcher content_matchers = 9;</code>
     * @param array<\Google\Cloud\Monitoring\V3\UptimeCheckConfig\ContentMatcher>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setContentMatchers($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Monitoring\V3\UptimeCheckConfig\ContentMatcher::class);
        $this->content_matchers = $arr;

        return $this;
    }

    /**
     * The type of checkers to use to execute the Uptime check.
     *
     * Generated from protobuf field <code>.google.monitoring.v3.UptimeCheckConfig.CheckerType checker_type = 17;</code>
     * @return int
     */
    public function getCheckerType()
    {
        return $this->checker_type;
    }

    /**
     * The type of checkers to use to execute the Uptime check.
     *
     * Generated from protobuf field <code>.google.monitoring.v3.UptimeCheckConfig.CheckerType checker_type = 17;</code>
     * @param int $var
     * @return $this
     */
    public function setCheckerType($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Monitoring\V3\UptimeCheckConfig\CheckerType::class);
        $this->checker_type = $var;

        return $this;
    }

    /**
     * The list of regions from which the check will be run.
     * Some regions contain one location, and others contain more than one.
     * If this field is specified, enough regions must be provided to include a
     * minimum of 3 locations.  Not specifying this field will result in Uptime
     * checks running from all available regions.
     *
     * Generated from protobuf field <code>repeated .google.monitoring.v3.UptimeCheckRegion selected_regions = 10;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getSelectedRegions()
    {
        return $this->selected_regions;
    }

    /**
     * The list of regions from which the check will be run.
     * Some regions contain one location, and others contain more than one.
     * If this field is specified, enough regions must be provided to include a
     * minimum of 3 locations.  Not specifying this field will result in Uptime
     * checks running from all available regions.
     *
     * Generated from protobuf field <code>repeated .google.monitoring.v3.UptimeCheckRegion selected_regions = 10;</code>
     * @param array<int>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setSelectedRegions($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::ENUM, \Google\Cloud\Monitoring\V3\UptimeCheckRegion::class);
        $this->selected_regions = $arr;

        return $this;
    }

    /**
     * If this is `true`, then checks are made only from the 'internal_checkers'.
     * If it is `false`, then checks are made only from the 'selected_regions'.
     * It is an error to provide 'selected_regions' when is_internal is `true`,
     * or to provide 'internal_checkers' when is_internal is `false`.
     *
     * Generated from protobuf field <code>bool is_internal = 15 [deprecated = true];</code>
     * @return bool
     * @deprecated
     */
    public function getIsInternal()
    {
        @trigger_error('is_internal is deprecated.', E_USER_DEPRECATED);
        return $this->is_internal;
    }

    /**
     * If this is `true`, then checks are made only from the 'internal_checkers'.
     * If it is `false`, then checks are made only from the 'selected_regions'.
     * It is an error to provide 'selected_regions' when is_internal is `true`,
     * or to provide 'internal_checkers' when is_internal is `false`.
     *
     * Generated from protobuf field <code>bool is_internal = 15 [deprecated = true];</code>
     * @param bool $var
     * @return $this
     * @deprecated
     */
    public function setIsInternal($var)
    {
        @trigger_error('is_internal is deprecated.', E_USER_DEPRECATED);
        GPBUtil::checkBool($var);
        $this->is_internal = $var;

        return $this;
    }

    /**
     * The internal checkers that this check will egress from. If `is_internal` is
     * `true` and this list is empty, the check will egress from all the
     * InternalCheckers configured for the project that owns this
     * `UptimeCheckConfig`.
     *
     * Generated from protobuf field <code>repeated .google.monitoring.v3.InternalChecker internal_checkers = 14 [deprecated = true];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     * @deprecated
     */
    public function getInternalCheckers()
    {
        @trigger_error('internal_checkers is deprecated.', E_USER_DEPRECATED);
        return $this->internal_checkers;
    }

    /**
     * The internal checkers that this check will egress from. If `is_internal` is
     * `true` and this list is empty, the check will egress from all the
     * InternalCheckers configured for the project that owns this
     * `UptimeCheckConfig`.
     *
     * Generated from protobuf field <code>repeated .google.monitoring.v3.InternalChecker internal_checkers = 14 [deprecated = true];</code>
     * @param array<\Google\Cloud\Monitoring\V3\InternalChecker>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     * @deprecated
     */
    public function setInternalCheckers($var)
    {
        @trigger_error('internal_checkers is deprecated.', E_USER_DEPRECATED);
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Monitoring\V3\InternalChecker::class);
        $this->internal_checkers = $arr;

        return $this;
    }

    /**
     * User-supplied key/value data to be used for organizing and
     * identifying the `UptimeCheckConfig` objects.
     * The field can contain up to 64 entries. Each key and value is limited to
     * 63 Unicode characters or 128 bytes, whichever is smaller. Labels and
     * values can contain only lowercase letters, numerals, underscores, and
     * dashes. Keys must begin with a letter.
     *
     * Generated from protobuf field <code>map<string, string> user_labels = 20;</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getUserLabels()
    {
        return $this->user_labels;
    }

    /**
     * User-supplied key/value data to be used for organizing and
     * identifying the `UptimeCheckConfig` objects.
     * The field can contain up to 64 entries. Each key and value is limited to
     * 63 Unicode characters or 128 bytes, whichever is smaller. Labels and
     * values can contain only lowercase letters, numerals, underscores, and
     * dashes. Keys must begin with a letter.
     *
     * Generated from protobuf field <code>map<string, string> user_labels = 20;</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setUserLabels($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::STRING);
        $this->user_labels = $arr;

        return $this;
    }

    /**
     * @return string
     */
    public function getResource()
    {
        return $this->whichOneof("resource");
    }

    /**
     * @return string
     */
    public function getCheckRequestType()
    {
        return $this->whichOneof("check_request_type");
    }

}

