<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/maps/fleetengine/delivery/v1/tasks.proto

namespace Google\Maps\FleetEngine\Delivery\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * A Task in the Delivery API represents a single action to track. In general,
 * there is a distinction between shipment-related Tasks and break Tasks. A
 * shipment can have multiple Tasks associated with it. For example, there could
 * be one Task for the pickup, and one for the drop-off or transfer. Also,
 * different Tasks for a given shipment can be handled by different vehicles.
 * For example, one vehicle could handle the pickup, driving the shipment to the
 * hub, while another vehicle drives the same shipment from the hub to the
 * drop-off location.
 * Note: gRPC and REST APIs use different field naming conventions. For example,
 * the `Task.journey_sharing_info` field in the gRPC API and the
 * `Task.journeySharingInfo` field in the REST API refer to the same
 * field.
 *
 * Generated from protobuf message <code>maps.fleetengine.delivery.v1.Task</code>
 */
class Task extends \Google\Protobuf\Internal\Message
{
    /**
     * Must be in the format `providers/{provider}/tasks/{task}`.
     *
     * Generated from protobuf field <code>string name = 1;</code>
     */
    protected $name = '';
    /**
     * Required. Immutable. Defines the type of the Task. For example, a break or
     * shipment.
     *
     * Generated from protobuf field <code>.maps.fleetengine.delivery.v1.Task.Type type = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];</code>
     */
    protected $type = 0;
    /**
     * Required. The current execution state of the Task.
     *
     * Generated from protobuf field <code>.maps.fleetengine.delivery.v1.Task.State state = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $state = 0;
    /**
     * The outcome of the Task.
     *
     * Generated from protobuf field <code>.maps.fleetengine.delivery.v1.Task.TaskOutcome task_outcome = 9;</code>
     */
    protected $task_outcome = 0;
    /**
     * The timestamp that indicates when the `Task`'s outcome was set by the
     * provider.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp task_outcome_time = 10;</code>
     */
    protected $task_outcome_time = null;
    /**
     * The location where the `Task`'s outcome was set. This value is updated as
     * part of `UpdateTask`. If this value isn't explicitly updated by the
     * provider, then Fleet Engine populates it by default with the last known
     * vehicle location (the *raw* location).
     *
     * Generated from protobuf field <code>.maps.fleetengine.delivery.v1.LocationInfo task_outcome_location = 11;</code>
     */
    protected $task_outcome_location = null;
    /**
     * Indicates where the value of the `task_outcome_location` came from.
     *
     * Generated from protobuf field <code>.maps.fleetengine.delivery.v1.Task.TaskOutcomeLocationSource task_outcome_location_source = 12;</code>
     */
    protected $task_outcome_location_source = 0;
    /**
     * Immutable. This field facilitates the storing of an ID so you can avoid
     * using a complicated mapping. You cannot set `tracking_id` for Tasks of type
     * `UNAVAILABLE` and `SCHEDULED_STOP`. These IDs are subject to the
     * following restrictions:
     * * Must be a valid Unicode string.
     * * Limited to a maximum length of 64 characters.
     * * Normalized according to [Unicode Normalization Form C]
     * (http://www.unicode.org/reports/tr15/).
     * * May not contain any of the following ASCII characters: '/', ':', '?',
     * ',', or '#'.
     *
     * Generated from protobuf field <code>string tracking_id = 4 [(.google.api.field_behavior) = IMMUTABLE];</code>
     */
    protected $tracking_id = '';
    /**
     * Output only. The ID of the vehicle that is executing this Task. Delivery
     * Vehicle IDs are subject to the following restrictions:
     * * Must be a valid Unicode string.
     * * Limited to a maximum length of 64 characters.
     * * Normalized according to [Unicode Normalization Form C]
     * (http://www.unicode.org/reports/tr15/).
     * * May not contain any of the following ASCII characters: '/', ':', '?',
     * ',', or '#'.
     *
     * Generated from protobuf field <code>string delivery_vehicle_id = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $delivery_vehicle_id = '';
    /**
     * Immutable. The location where the Task will be completed.
     * Optional for `UNAVAILABLE` Tasks, but required for all other Tasks.
     *
     * Generated from protobuf field <code>.maps.fleetengine.delivery.v1.LocationInfo planned_location = 6 [(.google.api.field_behavior) = IMMUTABLE];</code>
     */
    protected $planned_location = null;
    /**
     * Required. Immutable. The time needed to execute a Task at this location.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration task_duration = 7 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];</code>
     */
    protected $task_duration = null;
    /**
     * The time window during which the task should be completed.
     *
     * Generated from protobuf field <code>.maps.fleetengine.delivery.v1.TimeWindow target_time_window = 14;</code>
     */
    protected $target_time_window = null;
    /**
     * Output only. Journey sharing-specific fields. Not populated when state is
     * `CLOSED`.
     *
     * Generated from protobuf field <code>.maps.fleetengine.delivery.v1.Task.JourneySharingInfo journey_sharing_info = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $journey_sharing_info = null;
    /**
     * The configuration for task tracking that specifies which data elements are
     * visible to the end users under what circumstances.
     *
     * Generated from protobuf field <code>.maps.fleetengine.delivery.v1.TaskTrackingViewConfig task_tracking_view_config = 13;</code>
     */
    protected $task_tracking_view_config = null;
    /**
     * A list of custom Task attributes. Each attribute must have a unique key.
     *
     * Generated from protobuf field <code>repeated .maps.fleetengine.delivery.v1.TaskAttribute attributes = 15;</code>
     */
    private $attributes;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           Must be in the format `providers/{provider}/tasks/{task}`.
     *     @type int $type
     *           Required. Immutable. Defines the type of the Task. For example, a break or
     *           shipment.
     *     @type int $state
     *           Required. The current execution state of the Task.
     *     @type int $task_outcome
     *           The outcome of the Task.
     *     @type \Google\Protobuf\Timestamp $task_outcome_time
     *           The timestamp that indicates when the `Task`'s outcome was set by the
     *           provider.
     *     @type \Google\Maps\FleetEngine\Delivery\V1\LocationInfo $task_outcome_location
     *           The location where the `Task`'s outcome was set. This value is updated as
     *           part of `UpdateTask`. If this value isn't explicitly updated by the
     *           provider, then Fleet Engine populates it by default with the last known
     *           vehicle location (the *raw* location).
     *     @type int $task_outcome_location_source
     *           Indicates where the value of the `task_outcome_location` came from.
     *     @type string $tracking_id
     *           Immutable. This field facilitates the storing of an ID so you can avoid
     *           using a complicated mapping. You cannot set `tracking_id` for Tasks of type
     *           `UNAVAILABLE` and `SCHEDULED_STOP`. These IDs are subject to the
     *           following restrictions:
     *           * Must be a valid Unicode string.
     *           * Limited to a maximum length of 64 characters.
     *           * Normalized according to [Unicode Normalization Form C]
     *           (http://www.unicode.org/reports/tr15/).
     *           * May not contain any of the following ASCII characters: '/', ':', '?',
     *           ',', or '#'.
     *     @type string $delivery_vehicle_id
     *           Output only. The ID of the vehicle that is executing this Task. Delivery
     *           Vehicle IDs are subject to the following restrictions:
     *           * Must be a valid Unicode string.
     *           * Limited to a maximum length of 64 characters.
     *           * Normalized according to [Unicode Normalization Form C]
     *           (http://www.unicode.org/reports/tr15/).
     *           * May not contain any of the following ASCII characters: '/', ':', '?',
     *           ',', or '#'.
     *     @type \Google\Maps\FleetEngine\Delivery\V1\LocationInfo $planned_location
     *           Immutable. The location where the Task will be completed.
     *           Optional for `UNAVAILABLE` Tasks, but required for all other Tasks.
     *     @type \Google\Protobuf\Duration $task_duration
     *           Required. Immutable. The time needed to execute a Task at this location.
     *     @type \Google\Maps\FleetEngine\Delivery\V1\TimeWindow $target_time_window
     *           The time window during which the task should be completed.
     *     @type \Google\Maps\FleetEngine\Delivery\V1\Task\JourneySharingInfo $journey_sharing_info
     *           Output only. Journey sharing-specific fields. Not populated when state is
     *           `CLOSED`.
     *     @type \Google\Maps\FleetEngine\Delivery\V1\TaskTrackingViewConfig $task_tracking_view_config
     *           The configuration for task tracking that specifies which data elements are
     *           visible to the end users under what circumstances.
     *     @type array<\Google\Maps\FleetEngine\Delivery\V1\TaskAttribute>|\Google\Protobuf\Internal\RepeatedField $attributes
     *           A list of custom Task attributes. Each attribute must have a unique key.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Maps\Fleetengine\Delivery\V1\Tasks::initOnce();
        parent::__construct($data);
    }

    /**
     * Must be in the format `providers/{provider}/tasks/{task}`.
     *
     * Generated from protobuf field <code>string name = 1;</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Must be in the format `providers/{provider}/tasks/{task}`.
     *
     * Generated from protobuf field <code>string name = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Required. Immutable. Defines the type of the Task. For example, a break or
     * shipment.
     *
     * Generated from protobuf field <code>.maps.fleetengine.delivery.v1.Task.Type type = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];</code>
     * @return int
     */
    public function getType()
    {
        return $this->type;
    }

    /**
     * Required. Immutable. Defines the type of the Task. For example, a break or
     * shipment.
     *
     * Generated from protobuf field <code>.maps.fleetengine.delivery.v1.Task.Type type = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];</code>
     * @param int $var
     * @return $this
     */
    public function setType($var)
    {
        GPBUtil::checkEnum($var, \Google\Maps\FleetEngine\Delivery\V1\Task\Type::class);
        $this->type = $var;

        return $this;
    }

    /**
     * Required. The current execution state of the Task.
     *
     * Generated from protobuf field <code>.maps.fleetengine.delivery.v1.Task.State state = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return int
     */
    public function getState()
    {
        return $this->state;
    }

    /**
     * Required. The current execution state of the Task.
     *
     * Generated from protobuf field <code>.maps.fleetengine.delivery.v1.Task.State state = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param int $var
     * @return $this
     */
    public function setState($var)
    {
        GPBUtil::checkEnum($var, \Google\Maps\FleetEngine\Delivery\V1\Task\State::class);
        $this->state = $var;

        return $this;
    }

    /**
     * The outcome of the Task.
     *
     * Generated from protobuf field <code>.maps.fleetengine.delivery.v1.Task.TaskOutcome task_outcome = 9;</code>
     * @return int
     */
    public function getTaskOutcome()
    {
        return $this->task_outcome;
    }

    /**
     * The outcome of the Task.
     *
     * Generated from protobuf field <code>.maps.fleetengine.delivery.v1.Task.TaskOutcome task_outcome = 9;</code>
     * @param int $var
     * @return $this
     */
    public function setTaskOutcome($var)
    {
        GPBUtil::checkEnum($var, \Google\Maps\FleetEngine\Delivery\V1\Task\TaskOutcome::class);
        $this->task_outcome = $var;

        return $this;
    }

    /**
     * The timestamp that indicates when the `Task`'s outcome was set by the
     * provider.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp task_outcome_time = 10;</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getTaskOutcomeTime()
    {
        return $this->task_outcome_time;
    }

    public function hasTaskOutcomeTime()
    {
        return isset($this->task_outcome_time);
    }

    public function clearTaskOutcomeTime()
    {
        unset($this->task_outcome_time);
    }

    /**
     * The timestamp that indicates when the `Task`'s outcome was set by the
     * provider.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp task_outcome_time = 10;</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setTaskOutcomeTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->task_outcome_time = $var;

        return $this;
    }

    /**
     * The location where the `Task`'s outcome was set. This value is updated as
     * part of `UpdateTask`. If this value isn't explicitly updated by the
     * provider, then Fleet Engine populates it by default with the last known
     * vehicle location (the *raw* location).
     *
     * Generated from protobuf field <code>.maps.fleetengine.delivery.v1.LocationInfo task_outcome_location = 11;</code>
     * @return \Google\Maps\FleetEngine\Delivery\V1\LocationInfo|null
     */
    public function getTaskOutcomeLocation()
    {
        return $this->task_outcome_location;
    }

    public function hasTaskOutcomeLocation()
    {
        return isset($this->task_outcome_location);
    }

    public function clearTaskOutcomeLocation()
    {
        unset($this->task_outcome_location);
    }

    /**
     * The location where the `Task`'s outcome was set. This value is updated as
     * part of `UpdateTask`. If this value isn't explicitly updated by the
     * provider, then Fleet Engine populates it by default with the last known
     * vehicle location (the *raw* location).
     *
     * Generated from protobuf field <code>.maps.fleetengine.delivery.v1.LocationInfo task_outcome_location = 11;</code>
     * @param \Google\Maps\FleetEngine\Delivery\V1\LocationInfo $var
     * @return $this
     */
    public function setTaskOutcomeLocation($var)
    {
        GPBUtil::checkMessage($var, \Google\Maps\FleetEngine\Delivery\V1\LocationInfo::class);
        $this->task_outcome_location = $var;

        return $this;
    }

    /**
     * Indicates where the value of the `task_outcome_location` came from.
     *
     * Generated from protobuf field <code>.maps.fleetengine.delivery.v1.Task.TaskOutcomeLocationSource task_outcome_location_source = 12;</code>
     * @return int
     */
    public function getTaskOutcomeLocationSource()
    {
        return $this->task_outcome_location_source;
    }

    /**
     * Indicates where the value of the `task_outcome_location` came from.
     *
     * Generated from protobuf field <code>.maps.fleetengine.delivery.v1.Task.TaskOutcomeLocationSource task_outcome_location_source = 12;</code>
     * @param int $var
     * @return $this
     */
    public function setTaskOutcomeLocationSource($var)
    {
        GPBUtil::checkEnum($var, \Google\Maps\FleetEngine\Delivery\V1\Task\TaskOutcomeLocationSource::class);
        $this->task_outcome_location_source = $var;

        return $this;
    }

    /**
     * Immutable. This field facilitates the storing of an ID so you can avoid
     * using a complicated mapping. You cannot set `tracking_id` for Tasks of type
     * `UNAVAILABLE` and `SCHEDULED_STOP`. These IDs are subject to the
     * following restrictions:
     * * Must be a valid Unicode string.
     * * Limited to a maximum length of 64 characters.
     * * Normalized according to [Unicode Normalization Form C]
     * (http://www.unicode.org/reports/tr15/).
     * * May not contain any of the following ASCII characters: '/', ':', '?',
     * ',', or '#'.
     *
     * Generated from protobuf field <code>string tracking_id = 4 [(.google.api.field_behavior) = IMMUTABLE];</code>
     * @return string
     */
    public function getTrackingId()
    {
        return $this->tracking_id;
    }

    /**
     * Immutable. This field facilitates the storing of an ID so you can avoid
     * using a complicated mapping. You cannot set `tracking_id` for Tasks of type
     * `UNAVAILABLE` and `SCHEDULED_STOP`. These IDs are subject to the
     * following restrictions:
     * * Must be a valid Unicode string.
     * * Limited to a maximum length of 64 characters.
     * * Normalized according to [Unicode Normalization Form C]
     * (http://www.unicode.org/reports/tr15/).
     * * May not contain any of the following ASCII characters: '/', ':', '?',
     * ',', or '#'.
     *
     * Generated from protobuf field <code>string tracking_id = 4 [(.google.api.field_behavior) = IMMUTABLE];</code>
     * @param string $var
     * @return $this
     */
    public function setTrackingId($var)
    {
        GPBUtil::checkString($var, True);
        $this->tracking_id = $var;

        return $this;
    }

    /**
     * Output only. The ID of the vehicle that is executing this Task. Delivery
     * Vehicle IDs are subject to the following restrictions:
     * * Must be a valid Unicode string.
     * * Limited to a maximum length of 64 characters.
     * * Normalized according to [Unicode Normalization Form C]
     * (http://www.unicode.org/reports/tr15/).
     * * May not contain any of the following ASCII characters: '/', ':', '?',
     * ',', or '#'.
     *
     * Generated from protobuf field <code>string delivery_vehicle_id = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getDeliveryVehicleId()
    {
        return $this->delivery_vehicle_id;
    }

    /**
     * Output only. The ID of the vehicle that is executing this Task. Delivery
     * Vehicle IDs are subject to the following restrictions:
     * * Must be a valid Unicode string.
     * * Limited to a maximum length of 64 characters.
     * * Normalized according to [Unicode Normalization Form C]
     * (http://www.unicode.org/reports/tr15/).
     * * May not contain any of the following ASCII characters: '/', ':', '?',
     * ',', or '#'.
     *
     * Generated from protobuf field <code>string delivery_vehicle_id = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setDeliveryVehicleId($var)
    {
        GPBUtil::checkString($var, True);
        $this->delivery_vehicle_id = $var;

        return $this;
    }

    /**
     * Immutable. The location where the Task will be completed.
     * Optional for `UNAVAILABLE` Tasks, but required for all other Tasks.
     *
     * Generated from protobuf field <code>.maps.fleetengine.delivery.v1.LocationInfo planned_location = 6 [(.google.api.field_behavior) = IMMUTABLE];</code>
     * @return \Google\Maps\FleetEngine\Delivery\V1\LocationInfo|null
     */
    public function getPlannedLocation()
    {
        return $this->planned_location;
    }

    public function hasPlannedLocation()
    {
        return isset($this->planned_location);
    }

    public function clearPlannedLocation()
    {
        unset($this->planned_location);
    }

    /**
     * Immutable. The location where the Task will be completed.
     * Optional for `UNAVAILABLE` Tasks, but required for all other Tasks.
     *
     * Generated from protobuf field <code>.maps.fleetengine.delivery.v1.LocationInfo planned_location = 6 [(.google.api.field_behavior) = IMMUTABLE];</code>
     * @param \Google\Maps\FleetEngine\Delivery\V1\LocationInfo $var
     * @return $this
     */
    public function setPlannedLocation($var)
    {
        GPBUtil::checkMessage($var, \Google\Maps\FleetEngine\Delivery\V1\LocationInfo::class);
        $this->planned_location = $var;

        return $this;
    }

    /**
     * Required. Immutable. The time needed to execute a Task at this location.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration task_duration = 7 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];</code>
     * @return \Google\Protobuf\Duration|null
     */
    public function getTaskDuration()
    {
        return $this->task_duration;
    }

    public function hasTaskDuration()
    {
        return isset($this->task_duration);
    }

    public function clearTaskDuration()
    {
        unset($this->task_duration);
    }

    /**
     * Required. Immutable. The time needed to execute a Task at this location.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration task_duration = 7 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];</code>
     * @param \Google\Protobuf\Duration $var
     * @return $this
     */
    public function setTaskDuration($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Duration::class);
        $this->task_duration = $var;

        return $this;
    }

    /**
     * The time window during which the task should be completed.
     *
     * Generated from protobuf field <code>.maps.fleetengine.delivery.v1.TimeWindow target_time_window = 14;</code>
     * @return \Google\Maps\FleetEngine\Delivery\V1\TimeWindow|null
     */
    public function getTargetTimeWindow()
    {
        return $this->target_time_window;
    }

    public function hasTargetTimeWindow()
    {
        return isset($this->target_time_window);
    }

    public function clearTargetTimeWindow()
    {
        unset($this->target_time_window);
    }

    /**
     * The time window during which the task should be completed.
     *
     * Generated from protobuf field <code>.maps.fleetengine.delivery.v1.TimeWindow target_time_window = 14;</code>
     * @param \Google\Maps\FleetEngine\Delivery\V1\TimeWindow $var
     * @return $this
     */
    public function setTargetTimeWindow($var)
    {
        GPBUtil::checkMessage($var, \Google\Maps\FleetEngine\Delivery\V1\TimeWindow::class);
        $this->target_time_window = $var;

        return $this;
    }

    /**
     * Output only. Journey sharing-specific fields. Not populated when state is
     * `CLOSED`.
     *
     * Generated from protobuf field <code>.maps.fleetengine.delivery.v1.Task.JourneySharingInfo journey_sharing_info = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Maps\FleetEngine\Delivery\V1\Task\JourneySharingInfo|null
     */
    public function getJourneySharingInfo()
    {
        return $this->journey_sharing_info;
    }

    public function hasJourneySharingInfo()
    {
        return isset($this->journey_sharing_info);
    }

    public function clearJourneySharingInfo()
    {
        unset($this->journey_sharing_info);
    }

    /**
     * Output only. Journey sharing-specific fields. Not populated when state is
     * `CLOSED`.
     *
     * Generated from protobuf field <code>.maps.fleetengine.delivery.v1.Task.JourneySharingInfo journey_sharing_info = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Maps\FleetEngine\Delivery\V1\Task\JourneySharingInfo $var
     * @return $this
     */
    public function setJourneySharingInfo($var)
    {
        GPBUtil::checkMessage($var, \Google\Maps\FleetEngine\Delivery\V1\Task\JourneySharingInfo::class);
        $this->journey_sharing_info = $var;

        return $this;
    }

    /**
     * The configuration for task tracking that specifies which data elements are
     * visible to the end users under what circumstances.
     *
     * Generated from protobuf field <code>.maps.fleetengine.delivery.v1.TaskTrackingViewConfig task_tracking_view_config = 13;</code>
     * @return \Google\Maps\FleetEngine\Delivery\V1\TaskTrackingViewConfig|null
     */
    public function getTaskTrackingViewConfig()
    {
        return $this->task_tracking_view_config;
    }

    public function hasTaskTrackingViewConfig()
    {
        return isset($this->task_tracking_view_config);
    }

    public function clearTaskTrackingViewConfig()
    {
        unset($this->task_tracking_view_config);
    }

    /**
     * The configuration for task tracking that specifies which data elements are
     * visible to the end users under what circumstances.
     *
     * Generated from protobuf field <code>.maps.fleetengine.delivery.v1.TaskTrackingViewConfig task_tracking_view_config = 13;</code>
     * @param \Google\Maps\FleetEngine\Delivery\V1\TaskTrackingViewConfig $var
     * @return $this
     */
    public function setTaskTrackingViewConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Maps\FleetEngine\Delivery\V1\TaskTrackingViewConfig::class);
        $this->task_tracking_view_config = $var;

        return $this;
    }

    /**
     * A list of custom Task attributes. Each attribute must have a unique key.
     *
     * Generated from protobuf field <code>repeated .maps.fleetengine.delivery.v1.TaskAttribute attributes = 15;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getAttributes()
    {
        return $this->attributes;
    }

    /**
     * A list of custom Task attributes. Each attribute must have a unique key.
     *
     * Generated from protobuf field <code>repeated .maps.fleetengine.delivery.v1.TaskAttribute attributes = 15;</code>
     * @param array<\Google\Maps\FleetEngine\Delivery\V1\TaskAttribute>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setAttributes($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Maps\FleetEngine\Delivery\V1\TaskAttribute::class);
        $this->attributes = $arr;

        return $this;
    }

}

