<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/language/v1/language_service.proto

namespace Google\Cloud\Language\V1\Entity;

use UnexpectedValueException;

/**
 * The type of the entity. For most entity types, the associated metadata is a
 * Wikipedia URL (`wikipedia_url`) and Knowledge Graph MID (`mid`). The table
 * below lists the associated fields for entities that have different
 * metadata.
 *
 * Protobuf type <code>google.cloud.language.v1.Entity.Type</code>
 */
class Type
{
    /**
     * Unknown
     *
     * Generated from protobuf enum <code>UNKNOWN = 0;</code>
     */
    const UNKNOWN = 0;
    /**
     * Person
     *
     * Generated from protobuf enum <code>PERSON = 1;</code>
     */
    const PERSON = 1;
    /**
     * Location
     *
     * Generated from protobuf enum <code>LOCATION = 2;</code>
     */
    const LOCATION = 2;
    /**
     * Organization
     *
     * Generated from protobuf enum <code>ORGANIZATION = 3;</code>
     */
    const ORGANIZATION = 3;
    /**
     * Event
     *
     * Generated from protobuf enum <code>EVENT = 4;</code>
     */
    const EVENT = 4;
    /**
     * Artwork
     *
     * Generated from protobuf enum <code>WORK_OF_ART = 5;</code>
     */
    const WORK_OF_ART = 5;
    /**
     * Consumer product
     *
     * Generated from protobuf enum <code>CONSUMER_GOOD = 6;</code>
     */
    const CONSUMER_GOOD = 6;
    /**
     * Other types of entities
     *
     * Generated from protobuf enum <code>OTHER = 7;</code>
     */
    const OTHER = 7;
    /**
     * Phone number
     * The metadata lists the phone number, formatted according to local
     * convention, plus whichever additional elements appear in the text:
     * * `number` - the actual number, broken down into sections as per local
     * convention
     * * `national_prefix` - country code, if detected
     * * `area_code` - region or area code, if detected
     * * `extension` - phone extension (to be dialed after connection), if
     * detected
     *
     * Generated from protobuf enum <code>PHONE_NUMBER = 9;</code>
     */
    const PHONE_NUMBER = 9;
    /**
     * Address
     * The metadata identifies the street number and locality plus whichever
     * additional elements appear in the text:
     * * `street_number` - street number
     * * `locality` - city or town
     * * `street_name` - street/route name, if detected
     * * `postal_code` - postal code, if detected
     * * `country` - country, if detected<
     * * `broad_region` - administrative area, such as the state, if detected
     * * `narrow_region` - smaller administrative area, such as county, if
     * detected
     * * `sublocality` - used in Asian addresses to demark a district within a
     * city, if detected
     *
     * Generated from protobuf enum <code>ADDRESS = 10;</code>
     */
    const ADDRESS = 10;
    /**
     * Date
     * The metadata identifies the components of the date:
     * * `year` - four digit year, if detected
     * * `month` - two digit month number, if detected
     * * `day` - two digit day number, if detected
     *
     * Generated from protobuf enum <code>DATE = 11;</code>
     */
    const DATE = 11;
    /**
     * Number
     * The metadata is the number itself.
     *
     * Generated from protobuf enum <code>NUMBER = 12;</code>
     */
    const NUMBER = 12;
    /**
     * Price
     * The metadata identifies the `value` and `currency`.
     *
     * Generated from protobuf enum <code>PRICE = 13;</code>
     */
    const PRICE = 13;

    private static $valueToName = [
        self::UNKNOWN => 'UNKNOWN',
        self::PERSON => 'PERSON',
        self::LOCATION => 'LOCATION',
        self::ORGANIZATION => 'ORGANIZATION',
        self::EVENT => 'EVENT',
        self::WORK_OF_ART => 'WORK_OF_ART',
        self::CONSUMER_GOOD => 'CONSUMER_GOOD',
        self::OTHER => 'OTHER',
        self::PHONE_NUMBER => 'PHONE_NUMBER',
        self::ADDRESS => 'ADDRESS',
        self::DATE => 'DATE',
        self::NUMBER => 'NUMBER',
        self::PRICE => 'PRICE',
    ];

    public static function name($value)
    {
        if (!isset(self::$valueToName[$value])) {
            throw new UnexpectedValueException(sprintf(
                    'Enum %s has no name defined for value %s', __CLASS__, $value));
        }
        return self::$valueToName[$value];
    }


    public static function value($name)
    {
        $const = __CLASS__ . '::' . strtoupper($name);
        if (!defined($const)) {
            throw new UnexpectedValueException(sprintf(
                    'Enum %s has no value defined for name %s', __CLASS__, $name));
        }
        return constant($const);
    }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(Type::class, \Google\Cloud\Language\V1\Entity_Type::class);

