<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/eventarc/v1/pipeline.proto

namespace Google\Cloud\Eventarc\V1\Pipeline;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Represents a target of an invocation over HTTP.
 *
 * Generated from protobuf message <code>google.cloud.eventarc.v1.Pipeline.Destination</code>
 */
class Destination extends \Google\Protobuf\Internal\Message
{
    /**
     * Optional. Network config is used to configure how Pipeline resolves and
     * connects to a destination.
     *
     * Generated from protobuf field <code>.google.cloud.eventarc.v1.Pipeline.Destination.NetworkConfig network_config = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $network_config = null;
    /**
     * Optional. An authentication config used to authenticate message requests,
     * such that destinations can verify the source. For example, this can be
     * used with private GCP destinations that require GCP credentials to access
     * like Cloud Run. This field is optional and should be set only by users
     * interested in authenticated push
     *
     * Generated from protobuf field <code>.google.cloud.eventarc.v1.Pipeline.Destination.AuthenticationConfig authentication_config = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $authentication_config = null;
    /**
     * Optional. The message format before it is delivered to the destination.
     * If not set, the message will be delivered in the format it was originally
     * delivered to the Pipeline. This field can only be set if
     * Pipeline.input_payload_format is also set.
     *
     * Generated from protobuf field <code>.google.cloud.eventarc.v1.Pipeline.MessagePayloadFormat output_payload_format = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $output_payload_format = null;
    protected $destination_descriptor;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type \Google\Cloud\Eventarc\V1\Pipeline\Destination\NetworkConfig $network_config
     *           Optional. Network config is used to configure how Pipeline resolves and
     *           connects to a destination.
     *     @type \Google\Cloud\Eventarc\V1\Pipeline\Destination\HttpEndpoint $http_endpoint
     *           Optional. An HTTP endpoint destination described by an URI.
     *           If a DNS FQDN is provided as the endpoint, Pipeline will create a
     *           peering zone to the consumer VPC and forward DNS requests to the VPC
     *           specified by network config to resolve the service endpoint. See:
     *           https://cloud.google.com/dns/docs/zones/zones-overview#peering_zones
     *     @type string $workflow
     *           Optional. The resource name of the Workflow whose Executions are
     *           triggered by the events. The Workflow resource should be deployed in
     *           the same project as the Pipeline. Format:
     *           `projects/{project}/locations/{location}/workflows/{workflow}`
     *     @type string $message_bus
     *           Optional. The resource name of the Message Bus to which events should
     *           be published. The Message Bus resource should exist in the same project
     *           as the Pipeline. Format:
     *           `projects/{project}/locations/{location}/messageBuses/{message_bus}`
     *     @type string $topic
     *           Optional. The resource name of the Pub/Sub topic to which events should
     *           be published. Format:
     *           `projects/{project}/locations/{location}/topics/{topic}`
     *     @type \Google\Cloud\Eventarc\V1\Pipeline\Destination\AuthenticationConfig $authentication_config
     *           Optional. An authentication config used to authenticate message requests,
     *           such that destinations can verify the source. For example, this can be
     *           used with private GCP destinations that require GCP credentials to access
     *           like Cloud Run. This field is optional and should be set only by users
     *           interested in authenticated push
     *     @type \Google\Cloud\Eventarc\V1\Pipeline\MessagePayloadFormat $output_payload_format
     *           Optional. The message format before it is delivered to the destination.
     *           If not set, the message will be delivered in the format it was originally
     *           delivered to the Pipeline. This field can only be set if
     *           Pipeline.input_payload_format is also set.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Eventarc\V1\Pipeline::initOnce();
        parent::__construct($data);
    }

    /**
     * Optional. Network config is used to configure how Pipeline resolves and
     * connects to a destination.
     *
     * Generated from protobuf field <code>.google.cloud.eventarc.v1.Pipeline.Destination.NetworkConfig network_config = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\Eventarc\V1\Pipeline\Destination\NetworkConfig|null
     */
    public function getNetworkConfig()
    {
        return $this->network_config;
    }

    public function hasNetworkConfig()
    {
        return isset($this->network_config);
    }

    public function clearNetworkConfig()
    {
        unset($this->network_config);
    }

    /**
     * Optional. Network config is used to configure how Pipeline resolves and
     * connects to a destination.
     *
     * Generated from protobuf field <code>.google.cloud.eventarc.v1.Pipeline.Destination.NetworkConfig network_config = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\Eventarc\V1\Pipeline\Destination\NetworkConfig $var
     * @return $this
     */
    public function setNetworkConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Eventarc\V1\Pipeline\Destination\NetworkConfig::class);
        $this->network_config = $var;

        return $this;
    }

    /**
     * Optional. An HTTP endpoint destination described by an URI.
     * If a DNS FQDN is provided as the endpoint, Pipeline will create a
     * peering zone to the consumer VPC and forward DNS requests to the VPC
     * specified by network config to resolve the service endpoint. See:
     * https://cloud.google.com/dns/docs/zones/zones-overview#peering_zones
     *
     * Generated from protobuf field <code>.google.cloud.eventarc.v1.Pipeline.Destination.HttpEndpoint http_endpoint = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\Eventarc\V1\Pipeline\Destination\HttpEndpoint|null
     */
    public function getHttpEndpoint()
    {
        return $this->readOneof(2);
    }

    public function hasHttpEndpoint()
    {
        return $this->hasOneof(2);
    }

    /**
     * Optional. An HTTP endpoint destination described by an URI.
     * If a DNS FQDN is provided as the endpoint, Pipeline will create a
     * peering zone to the consumer VPC and forward DNS requests to the VPC
     * specified by network config to resolve the service endpoint. See:
     * https://cloud.google.com/dns/docs/zones/zones-overview#peering_zones
     *
     * Generated from protobuf field <code>.google.cloud.eventarc.v1.Pipeline.Destination.HttpEndpoint http_endpoint = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\Eventarc\V1\Pipeline\Destination\HttpEndpoint $var
     * @return $this
     */
    public function setHttpEndpoint($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Eventarc\V1\Pipeline\Destination\HttpEndpoint::class);
        $this->writeOneof(2, $var);

        return $this;
    }

    /**
     * Optional. The resource name of the Workflow whose Executions are
     * triggered by the events. The Workflow resource should be deployed in
     * the same project as the Pipeline. Format:
     * `projects/{project}/locations/{location}/workflows/{workflow}`
     *
     * Generated from protobuf field <code>string workflow = 3 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getWorkflow()
    {
        return $this->readOneof(3);
    }

    public function hasWorkflow()
    {
        return $this->hasOneof(3);
    }

    /**
     * Optional. The resource name of the Workflow whose Executions are
     * triggered by the events. The Workflow resource should be deployed in
     * the same project as the Pipeline. Format:
     * `projects/{project}/locations/{location}/workflows/{workflow}`
     *
     * Generated from protobuf field <code>string workflow = 3 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setWorkflow($var)
    {
        GPBUtil::checkString($var, True);
        $this->writeOneof(3, $var);

        return $this;
    }

    /**
     * Optional. The resource name of the Message Bus to which events should
     * be published. The Message Bus resource should exist in the same project
     * as the Pipeline. Format:
     * `projects/{project}/locations/{location}/messageBuses/{message_bus}`
     *
     * Generated from protobuf field <code>string message_bus = 4 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getMessageBus()
    {
        return $this->readOneof(4);
    }

    public function hasMessageBus()
    {
        return $this->hasOneof(4);
    }

    /**
     * Optional. The resource name of the Message Bus to which events should
     * be published. The Message Bus resource should exist in the same project
     * as the Pipeline. Format:
     * `projects/{project}/locations/{location}/messageBuses/{message_bus}`
     *
     * Generated from protobuf field <code>string message_bus = 4 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setMessageBus($var)
    {
        GPBUtil::checkString($var, True);
        $this->writeOneof(4, $var);

        return $this;
    }

    /**
     * Optional. The resource name of the Pub/Sub topic to which events should
     * be published. Format:
     * `projects/{project}/locations/{location}/topics/{topic}`
     *
     * Generated from protobuf field <code>string topic = 8 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getTopic()
    {
        return $this->readOneof(8);
    }

    public function hasTopic()
    {
        return $this->hasOneof(8);
    }

    /**
     * Optional. The resource name of the Pub/Sub topic to which events should
     * be published. Format:
     * `projects/{project}/locations/{location}/topics/{topic}`
     *
     * Generated from protobuf field <code>string topic = 8 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setTopic($var)
    {
        GPBUtil::checkString($var, True);
        $this->writeOneof(8, $var);

        return $this;
    }

    /**
     * Optional. An authentication config used to authenticate message requests,
     * such that destinations can verify the source. For example, this can be
     * used with private GCP destinations that require GCP credentials to access
     * like Cloud Run. This field is optional and should be set only by users
     * interested in authenticated push
     *
     * Generated from protobuf field <code>.google.cloud.eventarc.v1.Pipeline.Destination.AuthenticationConfig authentication_config = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\Eventarc\V1\Pipeline\Destination\AuthenticationConfig|null
     */
    public function getAuthenticationConfig()
    {
        return $this->authentication_config;
    }

    public function hasAuthenticationConfig()
    {
        return isset($this->authentication_config);
    }

    public function clearAuthenticationConfig()
    {
        unset($this->authentication_config);
    }

    /**
     * Optional. An authentication config used to authenticate message requests,
     * such that destinations can verify the source. For example, this can be
     * used with private GCP destinations that require GCP credentials to access
     * like Cloud Run. This field is optional and should be set only by users
     * interested in authenticated push
     *
     * Generated from protobuf field <code>.google.cloud.eventarc.v1.Pipeline.Destination.AuthenticationConfig authentication_config = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\Eventarc\V1\Pipeline\Destination\AuthenticationConfig $var
     * @return $this
     */
    public function setAuthenticationConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Eventarc\V1\Pipeline\Destination\AuthenticationConfig::class);
        $this->authentication_config = $var;

        return $this;
    }

    /**
     * Optional. The message format before it is delivered to the destination.
     * If not set, the message will be delivered in the format it was originally
     * delivered to the Pipeline. This field can only be set if
     * Pipeline.input_payload_format is also set.
     *
     * Generated from protobuf field <code>.google.cloud.eventarc.v1.Pipeline.MessagePayloadFormat output_payload_format = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\Eventarc\V1\Pipeline\MessagePayloadFormat|null
     */
    public function getOutputPayloadFormat()
    {
        return $this->output_payload_format;
    }

    public function hasOutputPayloadFormat()
    {
        return isset($this->output_payload_format);
    }

    public function clearOutputPayloadFormat()
    {
        unset($this->output_payload_format);
    }

    /**
     * Optional. The message format before it is delivered to the destination.
     * If not set, the message will be delivered in the format it was originally
     * delivered to the Pipeline. This field can only be set if
     * Pipeline.input_payload_format is also set.
     *
     * Generated from protobuf field <code>.google.cloud.eventarc.v1.Pipeline.MessagePayloadFormat output_payload_format = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\Eventarc\V1\Pipeline\MessagePayloadFormat $var
     * @return $this
     */
    public function setOutputPayloadFormat($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Eventarc\V1\Pipeline\MessagePayloadFormat::class);
        $this->output_payload_format = $var;

        return $this;
    }

    /**
     * @return string
     */
    public function getDestinationDescriptor()
    {
        return $this->whichOneof("destination_descriptor");
    }

}


