<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/dialogflow/cx/v3/fulfillment.proto

namespace Google\Cloud\Dialogflow\Cx\V3;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * A fulfillment can do one or more of the following actions at the same time:
 *   * Generate rich message responses.
 *   * Set parameter values.
 *   * Call the webhook.
 * Fulfillments can be called at various stages in the
 * [Page][google.cloud.dialogflow.cx.v3.Page] or
 * [Form][google.cloud.dialogflow.cx.v3.Form] lifecycle. For example, when a
 * [DetectIntentRequest][google.cloud.dialogflow.cx.v3.DetectIntentRequest]
 * drives a session to enter a new page, the page's entry fulfillment can add a
 * static response to the
 * [QueryResult][google.cloud.dialogflow.cx.v3.QueryResult] in the returning
 * [DetectIntentResponse][google.cloud.dialogflow.cx.v3.DetectIntentResponse],
 * call the webhook (for example, to load user data from a database), or both.
 *
 * Generated from protobuf message <code>google.cloud.dialogflow.cx.v3.Fulfillment</code>
 */
class Fulfillment extends \Google\Protobuf\Internal\Message
{
    /**
     * The list of rich message responses to present to the user.
     *
     * Generated from protobuf field <code>repeated .google.cloud.dialogflow.cx.v3.ResponseMessage messages = 1;</code>
     */
    private $messages;
    /**
     * The webhook to call.
     * Format:
     * `projects/<ProjectID>/locations/<LocationID>/agents/<AgentID>/webhooks/<WebhookID>`.
     *
     * Generated from protobuf field <code>string webhook = 2 [(.google.api.resource_reference) = {</code>
     */
    protected $webhook = '';
    /**
     * Whether Dialogflow should return currently queued fulfillment response
     * messages in streaming APIs. If a webhook is specified, it happens before
     * Dialogflow invokes webhook.
     * Warning:
     * 1) This flag only affects streaming API. Responses are still queued
     * and returned once in non-streaming API.
     * 2) The flag can be enabled in any fulfillment but only the first 3 partial
     * responses will be returned. You may only want to apply it to fulfillments
     * that have slow webhooks.
     *
     * Generated from protobuf field <code>bool return_partial_responses = 8;</code>
     */
    protected $return_partial_responses = false;
    /**
     * The value of this field will be populated in the
     * [WebhookRequest][google.cloud.dialogflow.cx.v3.WebhookRequest]
     * `fulfillmentInfo.tag` field by Dialogflow when the associated webhook is
     * called.
     * The tag is typically used by the webhook service to identify which
     * fulfillment is being called, but it could be used for other purposes.
     * This field is required if `webhook` is specified.
     *
     * Generated from protobuf field <code>string tag = 3;</code>
     */
    protected $tag = '';
    /**
     * Set parameter values before executing the webhook.
     *
     * Generated from protobuf field <code>repeated .google.cloud.dialogflow.cx.v3.Fulfillment.SetParameterAction set_parameter_actions = 4;</code>
     */
    private $set_parameter_actions;
    /**
     * Conditional cases for this fulfillment.
     *
     * Generated from protobuf field <code>repeated .google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases conditional_cases = 5;</code>
     */
    private $conditional_cases;
    /**
     * Hierarchical advanced settings for this fulfillment. The settings exposed
     * at the lower level overrides the settings exposed at the higher level.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.cx.v3.AdvancedSettings advanced_settings = 7;</code>
     */
    protected $advanced_settings = null;
    /**
     * If the flag is true, the agent will utilize LLM to generate a text
     * response. If LLM generation fails, the defined
     * [responses][google.cloud.dialogflow.cx.v3.Fulfillment.messages] in the
     * fulfillment will be respected. This flag is only useful for fulfillments
     * associated with no-match event handlers.
     *
     * Generated from protobuf field <code>bool enable_generative_fallback = 12;</code>
     */
    protected $enable_generative_fallback = false;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type array<\Google\Cloud\Dialogflow\Cx\V3\ResponseMessage>|\Google\Protobuf\Internal\RepeatedField $messages
     *           The list of rich message responses to present to the user.
     *     @type string $webhook
     *           The webhook to call.
     *           Format:
     *           `projects/<ProjectID>/locations/<LocationID>/agents/<AgentID>/webhooks/<WebhookID>`.
     *     @type bool $return_partial_responses
     *           Whether Dialogflow should return currently queued fulfillment response
     *           messages in streaming APIs. If a webhook is specified, it happens before
     *           Dialogflow invokes webhook.
     *           Warning:
     *           1) This flag only affects streaming API. Responses are still queued
     *           and returned once in non-streaming API.
     *           2) The flag can be enabled in any fulfillment but only the first 3 partial
     *           responses will be returned. You may only want to apply it to fulfillments
     *           that have slow webhooks.
     *     @type string $tag
     *           The value of this field will be populated in the
     *           [WebhookRequest][google.cloud.dialogflow.cx.v3.WebhookRequest]
     *           `fulfillmentInfo.tag` field by Dialogflow when the associated webhook is
     *           called.
     *           The tag is typically used by the webhook service to identify which
     *           fulfillment is being called, but it could be used for other purposes.
     *           This field is required if `webhook` is specified.
     *     @type array<\Google\Cloud\Dialogflow\Cx\V3\Fulfillment\SetParameterAction>|\Google\Protobuf\Internal\RepeatedField $set_parameter_actions
     *           Set parameter values before executing the webhook.
     *     @type array<\Google\Cloud\Dialogflow\Cx\V3\Fulfillment\ConditionalCases>|\Google\Protobuf\Internal\RepeatedField $conditional_cases
     *           Conditional cases for this fulfillment.
     *     @type \Google\Cloud\Dialogflow\Cx\V3\AdvancedSettings $advanced_settings
     *           Hierarchical advanced settings for this fulfillment. The settings exposed
     *           at the lower level overrides the settings exposed at the higher level.
     *     @type bool $enable_generative_fallback
     *           If the flag is true, the agent will utilize LLM to generate a text
     *           response. If LLM generation fails, the defined
     *           [responses][google.cloud.dialogflow.cx.v3.Fulfillment.messages] in the
     *           fulfillment will be respected. This flag is only useful for fulfillments
     *           associated with no-match event handlers.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Dialogflow\Cx\V3\Fulfillment::initOnce();
        parent::__construct($data);
    }

    /**
     * The list of rich message responses to present to the user.
     *
     * Generated from protobuf field <code>repeated .google.cloud.dialogflow.cx.v3.ResponseMessage messages = 1;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getMessages()
    {
        return $this->messages;
    }

    /**
     * The list of rich message responses to present to the user.
     *
     * Generated from protobuf field <code>repeated .google.cloud.dialogflow.cx.v3.ResponseMessage messages = 1;</code>
     * @param array<\Google\Cloud\Dialogflow\Cx\V3\ResponseMessage>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setMessages($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Dialogflow\Cx\V3\ResponseMessage::class);
        $this->messages = $arr;

        return $this;
    }

    /**
     * The webhook to call.
     * Format:
     * `projects/<ProjectID>/locations/<LocationID>/agents/<AgentID>/webhooks/<WebhookID>`.
     *
     * Generated from protobuf field <code>string webhook = 2 [(.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getWebhook()
    {
        return $this->webhook;
    }

    /**
     * The webhook to call.
     * Format:
     * `projects/<ProjectID>/locations/<LocationID>/agents/<AgentID>/webhooks/<WebhookID>`.
     *
     * Generated from protobuf field <code>string webhook = 2 [(.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setWebhook($var)
    {
        GPBUtil::checkString($var, True);
        $this->webhook = $var;

        return $this;
    }

    /**
     * Whether Dialogflow should return currently queued fulfillment response
     * messages in streaming APIs. If a webhook is specified, it happens before
     * Dialogflow invokes webhook.
     * Warning:
     * 1) This flag only affects streaming API. Responses are still queued
     * and returned once in non-streaming API.
     * 2) The flag can be enabled in any fulfillment but only the first 3 partial
     * responses will be returned. You may only want to apply it to fulfillments
     * that have slow webhooks.
     *
     * Generated from protobuf field <code>bool return_partial_responses = 8;</code>
     * @return bool
     */
    public function getReturnPartialResponses()
    {
        return $this->return_partial_responses;
    }

    /**
     * Whether Dialogflow should return currently queued fulfillment response
     * messages in streaming APIs. If a webhook is specified, it happens before
     * Dialogflow invokes webhook.
     * Warning:
     * 1) This flag only affects streaming API. Responses are still queued
     * and returned once in non-streaming API.
     * 2) The flag can be enabled in any fulfillment but only the first 3 partial
     * responses will be returned. You may only want to apply it to fulfillments
     * that have slow webhooks.
     *
     * Generated from protobuf field <code>bool return_partial_responses = 8;</code>
     * @param bool $var
     * @return $this
     */
    public function setReturnPartialResponses($var)
    {
        GPBUtil::checkBool($var);
        $this->return_partial_responses = $var;

        return $this;
    }

    /**
     * The value of this field will be populated in the
     * [WebhookRequest][google.cloud.dialogflow.cx.v3.WebhookRequest]
     * `fulfillmentInfo.tag` field by Dialogflow when the associated webhook is
     * called.
     * The tag is typically used by the webhook service to identify which
     * fulfillment is being called, but it could be used for other purposes.
     * This field is required if `webhook` is specified.
     *
     * Generated from protobuf field <code>string tag = 3;</code>
     * @return string
     */
    public function getTag()
    {
        return $this->tag;
    }

    /**
     * The value of this field will be populated in the
     * [WebhookRequest][google.cloud.dialogflow.cx.v3.WebhookRequest]
     * `fulfillmentInfo.tag` field by Dialogflow when the associated webhook is
     * called.
     * The tag is typically used by the webhook service to identify which
     * fulfillment is being called, but it could be used for other purposes.
     * This field is required if `webhook` is specified.
     *
     * Generated from protobuf field <code>string tag = 3;</code>
     * @param string $var
     * @return $this
     */
    public function setTag($var)
    {
        GPBUtil::checkString($var, True);
        $this->tag = $var;

        return $this;
    }

    /**
     * Set parameter values before executing the webhook.
     *
     * Generated from protobuf field <code>repeated .google.cloud.dialogflow.cx.v3.Fulfillment.SetParameterAction set_parameter_actions = 4;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getSetParameterActions()
    {
        return $this->set_parameter_actions;
    }

    /**
     * Set parameter values before executing the webhook.
     *
     * Generated from protobuf field <code>repeated .google.cloud.dialogflow.cx.v3.Fulfillment.SetParameterAction set_parameter_actions = 4;</code>
     * @param array<\Google\Cloud\Dialogflow\Cx\V3\Fulfillment\SetParameterAction>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setSetParameterActions($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Dialogflow\Cx\V3\Fulfillment\SetParameterAction::class);
        $this->set_parameter_actions = $arr;

        return $this;
    }

    /**
     * Conditional cases for this fulfillment.
     *
     * Generated from protobuf field <code>repeated .google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases conditional_cases = 5;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getConditionalCases()
    {
        return $this->conditional_cases;
    }

    /**
     * Conditional cases for this fulfillment.
     *
     * Generated from protobuf field <code>repeated .google.cloud.dialogflow.cx.v3.Fulfillment.ConditionalCases conditional_cases = 5;</code>
     * @param array<\Google\Cloud\Dialogflow\Cx\V3\Fulfillment\ConditionalCases>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setConditionalCases($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Dialogflow\Cx\V3\Fulfillment\ConditionalCases::class);
        $this->conditional_cases = $arr;

        return $this;
    }

    /**
     * Hierarchical advanced settings for this fulfillment. The settings exposed
     * at the lower level overrides the settings exposed at the higher level.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.cx.v3.AdvancedSettings advanced_settings = 7;</code>
     * @return \Google\Cloud\Dialogflow\Cx\V3\AdvancedSettings|null
     */
    public function getAdvancedSettings()
    {
        return $this->advanced_settings;
    }

    public function hasAdvancedSettings()
    {
        return isset($this->advanced_settings);
    }

    public function clearAdvancedSettings()
    {
        unset($this->advanced_settings);
    }

    /**
     * Hierarchical advanced settings for this fulfillment. The settings exposed
     * at the lower level overrides the settings exposed at the higher level.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.cx.v3.AdvancedSettings advanced_settings = 7;</code>
     * @param \Google\Cloud\Dialogflow\Cx\V3\AdvancedSettings $var
     * @return $this
     */
    public function setAdvancedSettings($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Dialogflow\Cx\V3\AdvancedSettings::class);
        $this->advanced_settings = $var;

        return $this;
    }

    /**
     * If the flag is true, the agent will utilize LLM to generate a text
     * response. If LLM generation fails, the defined
     * [responses][google.cloud.dialogflow.cx.v3.Fulfillment.messages] in the
     * fulfillment will be respected. This flag is only useful for fulfillments
     * associated with no-match event handlers.
     *
     * Generated from protobuf field <code>bool enable_generative_fallback = 12;</code>
     * @return bool
     */
    public function getEnableGenerativeFallback()
    {
        return $this->enable_generative_fallback;
    }

    /**
     * If the flag is true, the agent will utilize LLM to generate a text
     * response. If LLM generation fails, the defined
     * [responses][google.cloud.dialogflow.cx.v3.Fulfillment.messages] in the
     * fulfillment will be respected. This flag is only useful for fulfillments
     * associated with no-match event handlers.
     *
     * Generated from protobuf field <code>bool enable_generative_fallback = 12;</code>
     * @param bool $var
     * @return $this
     */
    public function setEnableGenerativeFallback($var)
    {
        GPBUtil::checkBool($var);
        $this->enable_generative_fallback = $var;

        return $this;
    }

}

