<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/dialogflow/cx/v3/advanced_settings.proto

namespace Google\Cloud\Dialogflow\Cx\V3;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Hierarchical advanced settings for agent/flow/page/fulfillment/parameter.
 * Settings exposed at lower level overrides the settings exposed at higher
 * level. Overriding occurs at the sub-setting level. For example, the
 * playback_interruption_settings at fulfillment level only overrides the
 * playback_interruption_settings at the agent level, leaving other settings
 * at the agent level unchanged.
 * DTMF settings does not override each other. DTMF settings set at different
 * levels define DTMF detections running in parallel.
 * Hierarchy: Agent->Flow->Page->Fulfillment/Parameter.
 *
 * Generated from protobuf message <code>google.cloud.dialogflow.cx.v3.AdvancedSettings</code>
 */
class AdvancedSettings extends \Google\Protobuf\Internal\Message
{
    /**
     * If present, incoming audio is exported by Dialogflow to the configured
     * Google Cloud Storage destination.
     * Exposed at the following levels:
     * - Agent level
     * - Flow level
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.cx.v3.GcsDestination audio_export_gcs_destination = 2;</code>
     */
    protected $audio_export_gcs_destination = null;
    /**
     * Settings for speech to text detection.
     * Exposed at the following levels:
     * - Agent level
     * - Flow level
     * - Page level
     * - Parameter level
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.cx.v3.AdvancedSettings.SpeechSettings speech_settings = 3;</code>
     */
    protected $speech_settings = null;
    /**
     * Settings for DTMF.
     * Exposed at the following levels:
     * - Agent level
     * - Flow level
     * - Page level
     * - Parameter level.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.cx.v3.AdvancedSettings.DtmfSettings dtmf_settings = 5;</code>
     */
    protected $dtmf_settings = null;
    /**
     * Settings for logging.
     * Settings for Dialogflow History, Contact Center messages, StackDriver logs,
     * and speech logging.
     * Exposed at the following levels:
     * - Agent level.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.cx.v3.AdvancedSettings.LoggingSettings logging_settings = 6;</code>
     */
    protected $logging_settings = null;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type \Google\Cloud\Dialogflow\Cx\V3\GcsDestination $audio_export_gcs_destination
     *           If present, incoming audio is exported by Dialogflow to the configured
     *           Google Cloud Storage destination.
     *           Exposed at the following levels:
     *           - Agent level
     *           - Flow level
     *     @type \Google\Cloud\Dialogflow\Cx\V3\AdvancedSettings\SpeechSettings $speech_settings
     *           Settings for speech to text detection.
     *           Exposed at the following levels:
     *           - Agent level
     *           - Flow level
     *           - Page level
     *           - Parameter level
     *     @type \Google\Cloud\Dialogflow\Cx\V3\AdvancedSettings\DtmfSettings $dtmf_settings
     *           Settings for DTMF.
     *           Exposed at the following levels:
     *           - Agent level
     *           - Flow level
     *           - Page level
     *           - Parameter level.
     *     @type \Google\Cloud\Dialogflow\Cx\V3\AdvancedSettings\LoggingSettings $logging_settings
     *           Settings for logging.
     *           Settings for Dialogflow History, Contact Center messages, StackDriver logs,
     *           and speech logging.
     *           Exposed at the following levels:
     *           - Agent level.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Dialogflow\Cx\V3\AdvancedSettings::initOnce();
        parent::__construct($data);
    }

    /**
     * If present, incoming audio is exported by Dialogflow to the configured
     * Google Cloud Storage destination.
     * Exposed at the following levels:
     * - Agent level
     * - Flow level
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.cx.v3.GcsDestination audio_export_gcs_destination = 2;</code>
     * @return \Google\Cloud\Dialogflow\Cx\V3\GcsDestination|null
     */
    public function getAudioExportGcsDestination()
    {
        return $this->audio_export_gcs_destination;
    }

    public function hasAudioExportGcsDestination()
    {
        return isset($this->audio_export_gcs_destination);
    }

    public function clearAudioExportGcsDestination()
    {
        unset($this->audio_export_gcs_destination);
    }

    /**
     * If present, incoming audio is exported by Dialogflow to the configured
     * Google Cloud Storage destination.
     * Exposed at the following levels:
     * - Agent level
     * - Flow level
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.cx.v3.GcsDestination audio_export_gcs_destination = 2;</code>
     * @param \Google\Cloud\Dialogflow\Cx\V3\GcsDestination $var
     * @return $this
     */
    public function setAudioExportGcsDestination($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Dialogflow\Cx\V3\GcsDestination::class);
        $this->audio_export_gcs_destination = $var;

        return $this;
    }

    /**
     * Settings for speech to text detection.
     * Exposed at the following levels:
     * - Agent level
     * - Flow level
     * - Page level
     * - Parameter level
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.cx.v3.AdvancedSettings.SpeechSettings speech_settings = 3;</code>
     * @return \Google\Cloud\Dialogflow\Cx\V3\AdvancedSettings\SpeechSettings|null
     */
    public function getSpeechSettings()
    {
        return $this->speech_settings;
    }

    public function hasSpeechSettings()
    {
        return isset($this->speech_settings);
    }

    public function clearSpeechSettings()
    {
        unset($this->speech_settings);
    }

    /**
     * Settings for speech to text detection.
     * Exposed at the following levels:
     * - Agent level
     * - Flow level
     * - Page level
     * - Parameter level
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.cx.v3.AdvancedSettings.SpeechSettings speech_settings = 3;</code>
     * @param \Google\Cloud\Dialogflow\Cx\V3\AdvancedSettings\SpeechSettings $var
     * @return $this
     */
    public function setSpeechSettings($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Dialogflow\Cx\V3\AdvancedSettings\SpeechSettings::class);
        $this->speech_settings = $var;

        return $this;
    }

    /**
     * Settings for DTMF.
     * Exposed at the following levels:
     * - Agent level
     * - Flow level
     * - Page level
     * - Parameter level.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.cx.v3.AdvancedSettings.DtmfSettings dtmf_settings = 5;</code>
     * @return \Google\Cloud\Dialogflow\Cx\V3\AdvancedSettings\DtmfSettings|null
     */
    public function getDtmfSettings()
    {
        return $this->dtmf_settings;
    }

    public function hasDtmfSettings()
    {
        return isset($this->dtmf_settings);
    }

    public function clearDtmfSettings()
    {
        unset($this->dtmf_settings);
    }

    /**
     * Settings for DTMF.
     * Exposed at the following levels:
     * - Agent level
     * - Flow level
     * - Page level
     * - Parameter level.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.cx.v3.AdvancedSettings.DtmfSettings dtmf_settings = 5;</code>
     * @param \Google\Cloud\Dialogflow\Cx\V3\AdvancedSettings\DtmfSettings $var
     * @return $this
     */
    public function setDtmfSettings($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Dialogflow\Cx\V3\AdvancedSettings\DtmfSettings::class);
        $this->dtmf_settings = $var;

        return $this;
    }

    /**
     * Settings for logging.
     * Settings for Dialogflow History, Contact Center messages, StackDriver logs,
     * and speech logging.
     * Exposed at the following levels:
     * - Agent level.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.cx.v3.AdvancedSettings.LoggingSettings logging_settings = 6;</code>
     * @return \Google\Cloud\Dialogflow\Cx\V3\AdvancedSettings\LoggingSettings|null
     */
    public function getLoggingSettings()
    {
        return $this->logging_settings;
    }

    public function hasLoggingSettings()
    {
        return isset($this->logging_settings);
    }

    public function clearLoggingSettings()
    {
        unset($this->logging_settings);
    }

    /**
     * Settings for logging.
     * Settings for Dialogflow History, Contact Center messages, StackDriver logs,
     * and speech logging.
     * Exposed at the following levels:
     * - Agent level.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.cx.v3.AdvancedSettings.LoggingSettings logging_settings = 6;</code>
     * @param \Google\Cloud\Dialogflow\Cx\V3\AdvancedSettings\LoggingSettings $var
     * @return $this
     */
    public function setLoggingSettings($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Dialogflow\Cx\V3\AdvancedSettings\LoggingSettings::class);
        $this->logging_settings = $var;

        return $this;
    }

}

