<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/dialogflow/v2/agent.proto

namespace Google\Cloud\Dialogflow\V2;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * The request message for
 * [Agents.RestoreAgent][google.cloud.dialogflow.v2.Agents.RestoreAgent].
 *
 * Generated from protobuf message <code>google.cloud.dialogflow.v2.RestoreAgentRequest</code>
 */
class RestoreAgentRequest extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. The project that the agent to restore is associated with.
     * Format: `projects/<Project ID>`.
     *
     * Generated from protobuf field <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     */
    protected $parent = '';
    protected $agent;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $parent
     *           Required. The project that the agent to restore is associated with.
     *           Format: `projects/<Project ID>`.
     *     @type string $agent_uri
     *           The URI to a Google Cloud Storage file containing the agent to restore.
     *           Note: The URI must start with "gs://".
     *           Dialogflow performs a read operation for the Cloud Storage object
     *           on the caller's behalf, so your request authentication must
     *           have read permissions for the object. For more information, see
     *           [Dialogflow access
     *           control](https://cloud.google.com/dialogflow/cx/docs/concept/access-control#storage).
     *     @type string $agent_content
     *           Zip compressed raw byte content for agent.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Dialogflow\V2\Agent::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. The project that the agent to restore is associated with.
     * Format: `projects/<Project ID>`.
     *
     * Generated from protobuf field <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getParent()
    {
        return $this->parent;
    }

    /**
     * Required. The project that the agent to restore is associated with.
     * Format: `projects/<Project ID>`.
     *
     * Generated from protobuf field <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setParent($var)
    {
        GPBUtil::checkString($var, True);
        $this->parent = $var;

        return $this;
    }

    /**
     * The URI to a Google Cloud Storage file containing the agent to restore.
     * Note: The URI must start with "gs://".
     * Dialogflow performs a read operation for the Cloud Storage object
     * on the caller's behalf, so your request authentication must
     * have read permissions for the object. For more information, see
     * [Dialogflow access
     * control](https://cloud.google.com/dialogflow/cx/docs/concept/access-control#storage).
     *
     * Generated from protobuf field <code>string agent_uri = 2;</code>
     * @return string
     */
    public function getAgentUri()
    {
        return $this->readOneof(2);
    }

    public function hasAgentUri()
    {
        return $this->hasOneof(2);
    }

    /**
     * The URI to a Google Cloud Storage file containing the agent to restore.
     * Note: The URI must start with "gs://".
     * Dialogflow performs a read operation for the Cloud Storage object
     * on the caller's behalf, so your request authentication must
     * have read permissions for the object. For more information, see
     * [Dialogflow access
     * control](https://cloud.google.com/dialogflow/cx/docs/concept/access-control#storage).
     *
     * Generated from protobuf field <code>string agent_uri = 2;</code>
     * @param string $var
     * @return $this
     */
    public function setAgentUri($var)
    {
        GPBUtil::checkString($var, True);
        $this->writeOneof(2, $var);

        return $this;
    }

    /**
     * Zip compressed raw byte content for agent.
     *
     * Generated from protobuf field <code>bytes agent_content = 3;</code>
     * @return string
     */
    public function getAgentContent()
    {
        return $this->readOneof(3);
    }

    public function hasAgentContent()
    {
        return $this->hasOneof(3);
    }

    /**
     * Zip compressed raw byte content for agent.
     *
     * Generated from protobuf field <code>bytes agent_content = 3;</code>
     * @param string $var
     * @return $this
     */
    public function setAgentContent($var)
    {
        GPBUtil::checkString($var, False);
        $this->writeOneof(3, $var);

        return $this;
    }

    /**
     * @return string
     */
    public function getAgent()
    {
        return $this->whichOneof("agent");
    }

}

