<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/devtools/clouddebugger/v2/data.proto

namespace Google\Cloud\Debugger\V2;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Represents the debugged application. The application may include one or more
 * replicated processes executing the same code. Each of these processes is
 * attached with a debugger agent, carrying out the debugging commands.
 * Agents attached to the same debuggee identify themselves as such by using
 * exactly the same Debuggee message value when registering.
 *
 * Generated from protobuf message <code>google.devtools.clouddebugger.v2.Debuggee</code>
 */
class Debuggee extends \Google\Protobuf\Internal\Message
{
    /**
     * Unique identifier for the debuggee generated by the controller service.
     *
     * Generated from protobuf field <code>string id = 1;</code>
     */
    private $id = '';
    /**
     * Project the debuggee is associated with.
     * Use project number or id when registering a Google Cloud Platform project.
     *
     * Generated from protobuf field <code>string project = 2;</code>
     */
    private $project = '';
    /**
     * Uniquifier to further distinguish the application.
     * It is possible that different applications might have identical values in
     * the debuggee message, thus, incorrectly identified as a single application
     * by the Controller service. This field adds salt to further distinguish the
     * application. Agents should consider seeding this field with value that
     * identifies the code, binary, configuration and environment.
     *
     * Generated from protobuf field <code>string uniquifier = 3;</code>
     */
    private $uniquifier = '';
    /**
     * Human readable description of the debuggee.
     * Including a human-readable project name, environment name and version
     * information is recommended.
     *
     * Generated from protobuf field <code>string description = 4;</code>
     */
    private $description = '';
    /**
     * If set to `true`, indicates that Controller service does not detect any
     * activity from the debuggee agents and the application is possibly stopped.
     *
     * Generated from protobuf field <code>bool is_inactive = 5;</code>
     */
    private $is_inactive = false;
    /**
     * Version ID of the agent.
     * Schema: `domain/language-platform/vmajor.minor` (for example
     * `google.com/java-gcp/v1.1`).
     *
     * Generated from protobuf field <code>string agent_version = 6;</code>
     */
    private $agent_version = '';
    /**
     * If set to `true`, indicates that the agent should disable itself and
     * detach from the debuggee.
     *
     * Generated from protobuf field <code>bool is_disabled = 7;</code>
     */
    private $is_disabled = false;
    /**
     * Human readable message to be displayed to the user about this debuggee.
     * Absence of this field indicates no status. The message can be either
     * informational or an error status.
     *
     * Generated from protobuf field <code>.google.devtools.clouddebugger.v2.StatusMessage status = 8;</code>
     */
    private $status = null;
    /**
     * References to the locations and revisions of the source code used in the
     * deployed application.
     *
     * Generated from protobuf field <code>repeated .google.devtools.source.v1.SourceContext source_contexts = 9;</code>
     */
    private $source_contexts;
    /**
     * References to the locations and revisions of the source code used in the
     * deployed application.
     *
     * Generated from protobuf field <code>repeated .google.devtools.source.v1.ExtendedSourceContext ext_source_contexts = 13 [deprecated = true];</code>
     * @deprecated
     */
    private $ext_source_contexts;
    /**
     * A set of custom debuggee properties, populated by the agent, to be
     * displayed to the user.
     *
     * Generated from protobuf field <code>map<string, string> labels = 11;</code>
     */
    private $labels;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $id
     *           Unique identifier for the debuggee generated by the controller service.
     *     @type string $project
     *           Project the debuggee is associated with.
     *           Use project number or id when registering a Google Cloud Platform project.
     *     @type string $uniquifier
     *           Uniquifier to further distinguish the application.
     *           It is possible that different applications might have identical values in
     *           the debuggee message, thus, incorrectly identified as a single application
     *           by the Controller service. This field adds salt to further distinguish the
     *           application. Agents should consider seeding this field with value that
     *           identifies the code, binary, configuration and environment.
     *     @type string $description
     *           Human readable description of the debuggee.
     *           Including a human-readable project name, environment name and version
     *           information is recommended.
     *     @type bool $is_inactive
     *           If set to `true`, indicates that Controller service does not detect any
     *           activity from the debuggee agents and the application is possibly stopped.
     *     @type string $agent_version
     *           Version ID of the agent.
     *           Schema: `domain/language-platform/vmajor.minor` (for example
     *           `google.com/java-gcp/v1.1`).
     *     @type bool $is_disabled
     *           If set to `true`, indicates that the agent should disable itself and
     *           detach from the debuggee.
     *     @type \Google\Cloud\Debugger\V2\StatusMessage $status
     *           Human readable message to be displayed to the user about this debuggee.
     *           Absence of this field indicates no status. The message can be either
     *           informational or an error status.
     *     @type array<\Google\Cloud\DevTools\Source\V1\SourceContext>|\Google\Protobuf\Internal\RepeatedField $source_contexts
     *           References to the locations and revisions of the source code used in the
     *           deployed application.
     *     @type array<\Google\Cloud\DevTools\Source\V1\ExtendedSourceContext>|\Google\Protobuf\Internal\RepeatedField $ext_source_contexts
     *           References to the locations and revisions of the source code used in the
     *           deployed application.
     *     @type array|\Google\Protobuf\Internal\MapField $labels
     *           A set of custom debuggee properties, populated by the agent, to be
     *           displayed to the user.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Devtools\Clouddebugger\V2\Data::initOnce();
        parent::__construct($data);
    }

    /**
     * Unique identifier for the debuggee generated by the controller service.
     *
     * Generated from protobuf field <code>string id = 1;</code>
     * @return string
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Unique identifier for the debuggee generated by the controller service.
     *
     * Generated from protobuf field <code>string id = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setId($var)
    {
        GPBUtil::checkString($var, True);
        $this->id = $var;

        return $this;
    }

    /**
     * Project the debuggee is associated with.
     * Use project number or id when registering a Google Cloud Platform project.
     *
     * Generated from protobuf field <code>string project = 2;</code>
     * @return string
     */
    public function getProject()
    {
        return $this->project;
    }

    /**
     * Project the debuggee is associated with.
     * Use project number or id when registering a Google Cloud Platform project.
     *
     * Generated from protobuf field <code>string project = 2;</code>
     * @param string $var
     * @return $this
     */
    public function setProject($var)
    {
        GPBUtil::checkString($var, True);
        $this->project = $var;

        return $this;
    }

    /**
     * Uniquifier to further distinguish the application.
     * It is possible that different applications might have identical values in
     * the debuggee message, thus, incorrectly identified as a single application
     * by the Controller service. This field adds salt to further distinguish the
     * application. Agents should consider seeding this field with value that
     * identifies the code, binary, configuration and environment.
     *
     * Generated from protobuf field <code>string uniquifier = 3;</code>
     * @return string
     */
    public function getUniquifier()
    {
        return $this->uniquifier;
    }

    /**
     * Uniquifier to further distinguish the application.
     * It is possible that different applications might have identical values in
     * the debuggee message, thus, incorrectly identified as a single application
     * by the Controller service. This field adds salt to further distinguish the
     * application. Agents should consider seeding this field with value that
     * identifies the code, binary, configuration and environment.
     *
     * Generated from protobuf field <code>string uniquifier = 3;</code>
     * @param string $var
     * @return $this
     */
    public function setUniquifier($var)
    {
        GPBUtil::checkString($var, True);
        $this->uniquifier = $var;

        return $this;
    }

    /**
     * Human readable description of the debuggee.
     * Including a human-readable project name, environment name and version
     * information is recommended.
     *
     * Generated from protobuf field <code>string description = 4;</code>
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * Human readable description of the debuggee.
     * Including a human-readable project name, environment name and version
     * information is recommended.
     *
     * Generated from protobuf field <code>string description = 4;</code>
     * @param string $var
     * @return $this
     */
    public function setDescription($var)
    {
        GPBUtil::checkString($var, True);
        $this->description = $var;

        return $this;
    }

    /**
     * If set to `true`, indicates that Controller service does not detect any
     * activity from the debuggee agents and the application is possibly stopped.
     *
     * Generated from protobuf field <code>bool is_inactive = 5;</code>
     * @return bool
     */
    public function getIsInactive()
    {
        return $this->is_inactive;
    }

    /**
     * If set to `true`, indicates that Controller service does not detect any
     * activity from the debuggee agents and the application is possibly stopped.
     *
     * Generated from protobuf field <code>bool is_inactive = 5;</code>
     * @param bool $var
     * @return $this
     */
    public function setIsInactive($var)
    {
        GPBUtil::checkBool($var);
        $this->is_inactive = $var;

        return $this;
    }

    /**
     * Version ID of the agent.
     * Schema: `domain/language-platform/vmajor.minor` (for example
     * `google.com/java-gcp/v1.1`).
     *
     * Generated from protobuf field <code>string agent_version = 6;</code>
     * @return string
     */
    public function getAgentVersion()
    {
        return $this->agent_version;
    }

    /**
     * Version ID of the agent.
     * Schema: `domain/language-platform/vmajor.minor` (for example
     * `google.com/java-gcp/v1.1`).
     *
     * Generated from protobuf field <code>string agent_version = 6;</code>
     * @param string $var
     * @return $this
     */
    public function setAgentVersion($var)
    {
        GPBUtil::checkString($var, True);
        $this->agent_version = $var;

        return $this;
    }

    /**
     * If set to `true`, indicates that the agent should disable itself and
     * detach from the debuggee.
     *
     * Generated from protobuf field <code>bool is_disabled = 7;</code>
     * @return bool
     */
    public function getIsDisabled()
    {
        return $this->is_disabled;
    }

    /**
     * If set to `true`, indicates that the agent should disable itself and
     * detach from the debuggee.
     *
     * Generated from protobuf field <code>bool is_disabled = 7;</code>
     * @param bool $var
     * @return $this
     */
    public function setIsDisabled($var)
    {
        GPBUtil::checkBool($var);
        $this->is_disabled = $var;

        return $this;
    }

    /**
     * Human readable message to be displayed to the user about this debuggee.
     * Absence of this field indicates no status. The message can be either
     * informational or an error status.
     *
     * Generated from protobuf field <code>.google.devtools.clouddebugger.v2.StatusMessage status = 8;</code>
     * @return \Google\Cloud\Debugger\V2\StatusMessage|null
     */
    public function getStatus()
    {
        return $this->status;
    }

    public function hasStatus()
    {
        return isset($this->status);
    }

    public function clearStatus()
    {
        unset($this->status);
    }

    /**
     * Human readable message to be displayed to the user about this debuggee.
     * Absence of this field indicates no status. The message can be either
     * informational or an error status.
     *
     * Generated from protobuf field <code>.google.devtools.clouddebugger.v2.StatusMessage status = 8;</code>
     * @param \Google\Cloud\Debugger\V2\StatusMessage $var
     * @return $this
     */
    public function setStatus($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Debugger\V2\StatusMessage::class);
        $this->status = $var;

        return $this;
    }

    /**
     * References to the locations and revisions of the source code used in the
     * deployed application.
     *
     * Generated from protobuf field <code>repeated .google.devtools.source.v1.SourceContext source_contexts = 9;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getSourceContexts()
    {
        return $this->source_contexts;
    }

    /**
     * References to the locations and revisions of the source code used in the
     * deployed application.
     *
     * Generated from protobuf field <code>repeated .google.devtools.source.v1.SourceContext source_contexts = 9;</code>
     * @param array<\Google\Cloud\DevTools\Source\V1\SourceContext>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setSourceContexts($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\DevTools\Source\V1\SourceContext::class);
        $this->source_contexts = $arr;

        return $this;
    }

    /**
     * References to the locations and revisions of the source code used in the
     * deployed application.
     *
     * Generated from protobuf field <code>repeated .google.devtools.source.v1.ExtendedSourceContext ext_source_contexts = 13 [deprecated = true];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     * @deprecated
     */
    public function getExtSourceContexts()
    {
        @trigger_error('ext_source_contexts is deprecated.', E_USER_DEPRECATED);
        return $this->ext_source_contexts;
    }

    /**
     * References to the locations and revisions of the source code used in the
     * deployed application.
     *
     * Generated from protobuf field <code>repeated .google.devtools.source.v1.ExtendedSourceContext ext_source_contexts = 13 [deprecated = true];</code>
     * @param array<\Google\Cloud\DevTools\Source\V1\ExtendedSourceContext>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     * @deprecated
     */
    public function setExtSourceContexts($var)
    {
        @trigger_error('ext_source_contexts is deprecated.', E_USER_DEPRECATED);
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\DevTools\Source\V1\ExtendedSourceContext::class);
        $this->ext_source_contexts = $arr;

        return $this;
    }

    /**
     * A set of custom debuggee properties, populated by the agent, to be
     * displayed to the user.
     *
     * Generated from protobuf field <code>map<string, string> labels = 11;</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getLabels()
    {
        return $this->labels;
    }

    /**
     * A set of custom debuggee properties, populated by the agent, to be
     * displayed to the user.
     *
     * Generated from protobuf field <code>map<string, string> labels = 11;</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setLabels($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::STRING);
        $this->labels = $arr;

        return $this;
    }

}

