<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/datastore/v1/datastore.proto

namespace Google\Cloud\Datastore\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * A mutation to apply to an entity.
 *
 * Generated from protobuf message <code>google.datastore.v1.Mutation</code>
 */
class Mutation extends \Google\Protobuf\Internal\Message
{
    /**
     * The strategy to use when a conflict is detected. Defaults to
     * `SERVER_VALUE`.
     * If this is set, then `conflict_detection_strategy` must also be set.
     *
     * Generated from protobuf field <code>.google.datastore.v1.Mutation.ConflictResolutionStrategy conflict_resolution_strategy = 10;</code>
     */
    private $conflict_resolution_strategy = 0;
    /**
     * The properties to write in this mutation.
     * None of the properties in the mask may have a reserved name, except for
     * `__key__`.
     * This field is ignored for `delete`.
     * If the entity already exists, only properties referenced in the mask are
     * updated, others are left untouched.
     * Properties referenced in the mask but not in the entity are deleted.
     *
     * Generated from protobuf field <code>.google.datastore.v1.PropertyMask property_mask = 9;</code>
     */
    private $property_mask = null;
    /**
     * Optional. The transforms to perform on the entity.
     * This field can be set only when the operation is `insert`, `update`,
     * or `upsert`. If present, the transforms are be applied to the entity
     * regardless of the property mask, in order, after the operation.
     *
     * Generated from protobuf field <code>repeated .google.datastore.v1.PropertyTransform property_transforms = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $property_transforms;
    protected $operation;
    protected $conflict_detection_strategy;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type \Google\Cloud\Datastore\V1\Entity $insert
     *           The entity to insert. The entity must not already exist.
     *           The entity key's final path element may be incomplete.
     *     @type \Google\Cloud\Datastore\V1\Entity $update
     *           The entity to update. The entity must already exist.
     *           Must have a complete key path.
     *     @type \Google\Cloud\Datastore\V1\Entity $upsert
     *           The entity to upsert. The entity may or may not already exist.
     *           The entity key's final path element may be incomplete.
     *     @type \Google\Cloud\Datastore\V1\Key $delete
     *           The key of the entity to delete. The entity may or may not already exist.
     *           Must have a complete key path and must not be reserved/read-only.
     *     @type int|string $base_version
     *           The version of the entity that this mutation is being applied
     *           to. If this does not match the current version on the server, the
     *           mutation conflicts.
     *     @type \Google\Protobuf\Timestamp $update_time
     *           The update time of the entity that this mutation is being applied
     *           to. If this does not match the current update time on the server, the
     *           mutation conflicts.
     *     @type int $conflict_resolution_strategy
     *           The strategy to use when a conflict is detected. Defaults to
     *           `SERVER_VALUE`.
     *           If this is set, then `conflict_detection_strategy` must also be set.
     *     @type \Google\Cloud\Datastore\V1\PropertyMask $property_mask
     *           The properties to write in this mutation.
     *           None of the properties in the mask may have a reserved name, except for
     *           `__key__`.
     *           This field is ignored for `delete`.
     *           If the entity already exists, only properties referenced in the mask are
     *           updated, others are left untouched.
     *           Properties referenced in the mask but not in the entity are deleted.
     *     @type array<\Google\Cloud\Datastore\V1\PropertyTransform>|\Google\Protobuf\Internal\RepeatedField $property_transforms
     *           Optional. The transforms to perform on the entity.
     *           This field can be set only when the operation is `insert`, `update`,
     *           or `upsert`. If present, the transforms are be applied to the entity
     *           regardless of the property mask, in order, after the operation.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Datastore\V1\Datastore::initOnce();
        parent::__construct($data);
    }

    /**
     * The entity to insert. The entity must not already exist.
     * The entity key's final path element may be incomplete.
     *
     * Generated from protobuf field <code>.google.datastore.v1.Entity insert = 4;</code>
     * @return \Google\Cloud\Datastore\V1\Entity|null
     */
    public function getInsert()
    {
        return $this->readOneof(4);
    }

    public function hasInsert()
    {
        return $this->hasOneof(4);
    }

    /**
     * The entity to insert. The entity must not already exist.
     * The entity key's final path element may be incomplete.
     *
     * Generated from protobuf field <code>.google.datastore.v1.Entity insert = 4;</code>
     * @param \Google\Cloud\Datastore\V1\Entity $var
     * @return $this
     */
    public function setInsert($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Datastore\V1\Entity::class);
        $this->writeOneof(4, $var);

        return $this;
    }

    /**
     * The entity to update. The entity must already exist.
     * Must have a complete key path.
     *
     * Generated from protobuf field <code>.google.datastore.v1.Entity update = 5;</code>
     * @return \Google\Cloud\Datastore\V1\Entity|null
     */
    public function getUpdate()
    {
        return $this->readOneof(5);
    }

    public function hasUpdate()
    {
        return $this->hasOneof(5);
    }

    /**
     * The entity to update. The entity must already exist.
     * Must have a complete key path.
     *
     * Generated from protobuf field <code>.google.datastore.v1.Entity update = 5;</code>
     * @param \Google\Cloud\Datastore\V1\Entity $var
     * @return $this
     */
    public function setUpdate($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Datastore\V1\Entity::class);
        $this->writeOneof(5, $var);

        return $this;
    }

    /**
     * The entity to upsert. The entity may or may not already exist.
     * The entity key's final path element may be incomplete.
     *
     * Generated from protobuf field <code>.google.datastore.v1.Entity upsert = 6;</code>
     * @return \Google\Cloud\Datastore\V1\Entity|null
     */
    public function getUpsert()
    {
        return $this->readOneof(6);
    }

    public function hasUpsert()
    {
        return $this->hasOneof(6);
    }

    /**
     * The entity to upsert. The entity may or may not already exist.
     * The entity key's final path element may be incomplete.
     *
     * Generated from protobuf field <code>.google.datastore.v1.Entity upsert = 6;</code>
     * @param \Google\Cloud\Datastore\V1\Entity $var
     * @return $this
     */
    public function setUpsert($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Datastore\V1\Entity::class);
        $this->writeOneof(6, $var);

        return $this;
    }

    /**
     * The key of the entity to delete. The entity may or may not already exist.
     * Must have a complete key path and must not be reserved/read-only.
     *
     * Generated from protobuf field <code>.google.datastore.v1.Key delete = 7;</code>
     * @return \Google\Cloud\Datastore\V1\Key|null
     */
    public function getDelete()
    {
        return $this->readOneof(7);
    }

    public function hasDelete()
    {
        return $this->hasOneof(7);
    }

    /**
     * The key of the entity to delete. The entity may or may not already exist.
     * Must have a complete key path and must not be reserved/read-only.
     *
     * Generated from protobuf field <code>.google.datastore.v1.Key delete = 7;</code>
     * @param \Google\Cloud\Datastore\V1\Key $var
     * @return $this
     */
    public function setDelete($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Datastore\V1\Key::class);
        $this->writeOneof(7, $var);

        return $this;
    }

    /**
     * The version of the entity that this mutation is being applied
     * to. If this does not match the current version on the server, the
     * mutation conflicts.
     *
     * Generated from protobuf field <code>int64 base_version = 8;</code>
     * @return int|string
     */
    public function getBaseVersion()
    {
        return $this->readOneof(8);
    }

    public function hasBaseVersion()
    {
        return $this->hasOneof(8);
    }

    /**
     * The version of the entity that this mutation is being applied
     * to. If this does not match the current version on the server, the
     * mutation conflicts.
     *
     * Generated from protobuf field <code>int64 base_version = 8;</code>
     * @param int|string $var
     * @return $this
     */
    public function setBaseVersion($var)
    {
        GPBUtil::checkInt64($var);
        $this->writeOneof(8, $var);

        return $this;
    }

    /**
     * The update time of the entity that this mutation is being applied
     * to. If this does not match the current update time on the server, the
     * mutation conflicts.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 11;</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getUpdateTime()
    {
        return $this->readOneof(11);
    }

    public function hasUpdateTime()
    {
        return $this->hasOneof(11);
    }

    /**
     * The update time of the entity that this mutation is being applied
     * to. If this does not match the current update time on the server, the
     * mutation conflicts.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 11;</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setUpdateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->writeOneof(11, $var);

        return $this;
    }

    /**
     * The strategy to use when a conflict is detected. Defaults to
     * `SERVER_VALUE`.
     * If this is set, then `conflict_detection_strategy` must also be set.
     *
     * Generated from protobuf field <code>.google.datastore.v1.Mutation.ConflictResolutionStrategy conflict_resolution_strategy = 10;</code>
     * @return int
     */
    public function getConflictResolutionStrategy()
    {
        return $this->conflict_resolution_strategy;
    }

    /**
     * The strategy to use when a conflict is detected. Defaults to
     * `SERVER_VALUE`.
     * If this is set, then `conflict_detection_strategy` must also be set.
     *
     * Generated from protobuf field <code>.google.datastore.v1.Mutation.ConflictResolutionStrategy conflict_resolution_strategy = 10;</code>
     * @param int $var
     * @return $this
     */
    public function setConflictResolutionStrategy($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Datastore\V1\Mutation\ConflictResolutionStrategy::class);
        $this->conflict_resolution_strategy = $var;

        return $this;
    }

    /**
     * The properties to write in this mutation.
     * None of the properties in the mask may have a reserved name, except for
     * `__key__`.
     * This field is ignored for `delete`.
     * If the entity already exists, only properties referenced in the mask are
     * updated, others are left untouched.
     * Properties referenced in the mask but not in the entity are deleted.
     *
     * Generated from protobuf field <code>.google.datastore.v1.PropertyMask property_mask = 9;</code>
     * @return \Google\Cloud\Datastore\V1\PropertyMask|null
     */
    public function getPropertyMask()
    {
        return $this->property_mask;
    }

    public function hasPropertyMask()
    {
        return isset($this->property_mask);
    }

    public function clearPropertyMask()
    {
        unset($this->property_mask);
    }

    /**
     * The properties to write in this mutation.
     * None of the properties in the mask may have a reserved name, except for
     * `__key__`.
     * This field is ignored for `delete`.
     * If the entity already exists, only properties referenced in the mask are
     * updated, others are left untouched.
     * Properties referenced in the mask but not in the entity are deleted.
     *
     * Generated from protobuf field <code>.google.datastore.v1.PropertyMask property_mask = 9;</code>
     * @param \Google\Cloud\Datastore\V1\PropertyMask $var
     * @return $this
     */
    public function setPropertyMask($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Datastore\V1\PropertyMask::class);
        $this->property_mask = $var;

        return $this;
    }

    /**
     * Optional. The transforms to perform on the entity.
     * This field can be set only when the operation is `insert`, `update`,
     * or `upsert`. If present, the transforms are be applied to the entity
     * regardless of the property mask, in order, after the operation.
     *
     * Generated from protobuf field <code>repeated .google.datastore.v1.PropertyTransform property_transforms = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getPropertyTransforms()
    {
        return $this->property_transforms;
    }

    /**
     * Optional. The transforms to perform on the entity.
     * This field can be set only when the operation is `insert`, `update`,
     * or `upsert`. If present, the transforms are be applied to the entity
     * regardless of the property mask, in order, after the operation.
     *
     * Generated from protobuf field <code>repeated .google.datastore.v1.PropertyTransform property_transforms = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array<\Google\Cloud\Datastore\V1\PropertyTransform>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setPropertyTransforms($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Datastore\V1\PropertyTransform::class);
        $this->property_transforms = $arr;

        return $this;
    }

    /**
     * @return string
     */
    public function getOperation()
    {
        return $this->whichOneof("operation");
    }

    /**
     * @return string
     */
    public function getConflictDetectionStrategy()
    {
        return $this->whichOneof("conflict_detection_strategy");
    }

}

