<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/dataproc/v1/clusters.proto

namespace Google\Cloud\Dataproc\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Specifies the config of disk options for a group of VM instances.
 *
 * Generated from protobuf message <code>google.cloud.dataproc.v1.DiskConfig</code>
 */
class DiskConfig extends \Google\Protobuf\Internal\Message
{
    /**
     * Optional. Type of the boot disk (default is "pd-standard").
     * Valid values: "pd-balanced" (Persistent Disk Balanced Solid State Drive),
     * "pd-ssd" (Persistent Disk Solid State Drive),
     * or "pd-standard" (Persistent Disk Hard Disk Drive).
     * See [Disk types](https://cloud.google.com/compute/docs/disks#disk-types).
     *
     * Generated from protobuf field <code>string boot_disk_type = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $boot_disk_type = '';
    /**
     * Optional. Size in GB of the boot disk (default is 500GB).
     *
     * Generated from protobuf field <code>int32 boot_disk_size_gb = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $boot_disk_size_gb = 0;
    /**
     * Optional. Number of attached SSDs, from 0 to 8 (default is 0).
     * If SSDs are not attached, the boot disk is used to store runtime logs and
     * [HDFS](https://hadoop.apache.org/docs/r1.2.1/hdfs_user_guide.html) data.
     * If one or more SSDs are attached, this runtime bulk
     * data is spread across them, and the boot disk contains only basic
     * config and installed binaries.
     * Note: Local SSD options may vary by machine type and number of vCPUs
     * selected.
     *
     * Generated from protobuf field <code>int32 num_local_ssds = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $num_local_ssds = 0;
    /**
     * Optional. Interface type of local SSDs (default is "scsi").
     * Valid values: "scsi" (Small Computer System Interface),
     * "nvme" (Non-Volatile Memory Express).
     * See [local SSD
     * performance](https://cloud.google.com/compute/docs/disks/local-ssd#performance).
     *
     * Generated from protobuf field <code>string local_ssd_interface = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $local_ssd_interface = '';
    /**
     * Optional. Indicates how many IOPS to provision for the disk. This sets the
     * number of I/O operations per second that the disk can handle. Note: This
     * field is only supported if boot_disk_type is hyperdisk-balanced.
     *
     * Generated from protobuf field <code>optional int64 boot_disk_provisioned_iops = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $boot_disk_provisioned_iops = null;
    /**
     * Optional. Indicates how much throughput to provision for the disk. This
     * sets the number of throughput mb per second that the disk can handle.
     * Values must be greater than or equal to 1. Note: This field is only
     * supported if boot_disk_type is hyperdisk-balanced.
     *
     * Generated from protobuf field <code>optional int64 boot_disk_provisioned_throughput = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $boot_disk_provisioned_throughput = null;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $boot_disk_type
     *           Optional. Type of the boot disk (default is "pd-standard").
     *           Valid values: "pd-balanced" (Persistent Disk Balanced Solid State Drive),
     *           "pd-ssd" (Persistent Disk Solid State Drive),
     *           or "pd-standard" (Persistent Disk Hard Disk Drive).
     *           See [Disk types](https://cloud.google.com/compute/docs/disks#disk-types).
     *     @type int $boot_disk_size_gb
     *           Optional. Size in GB of the boot disk (default is 500GB).
     *     @type int $num_local_ssds
     *           Optional. Number of attached SSDs, from 0 to 8 (default is 0).
     *           If SSDs are not attached, the boot disk is used to store runtime logs and
     *           [HDFS](https://hadoop.apache.org/docs/r1.2.1/hdfs_user_guide.html) data.
     *           If one or more SSDs are attached, this runtime bulk
     *           data is spread across them, and the boot disk contains only basic
     *           config and installed binaries.
     *           Note: Local SSD options may vary by machine type and number of vCPUs
     *           selected.
     *     @type string $local_ssd_interface
     *           Optional. Interface type of local SSDs (default is "scsi").
     *           Valid values: "scsi" (Small Computer System Interface),
     *           "nvme" (Non-Volatile Memory Express).
     *           See [local SSD
     *           performance](https://cloud.google.com/compute/docs/disks/local-ssd#performance).
     *     @type int|string $boot_disk_provisioned_iops
     *           Optional. Indicates how many IOPS to provision for the disk. This sets the
     *           number of I/O operations per second that the disk can handle. Note: This
     *           field is only supported if boot_disk_type is hyperdisk-balanced.
     *     @type int|string $boot_disk_provisioned_throughput
     *           Optional. Indicates how much throughput to provision for the disk. This
     *           sets the number of throughput mb per second that the disk can handle.
     *           Values must be greater than or equal to 1. Note: This field is only
     *           supported if boot_disk_type is hyperdisk-balanced.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Dataproc\V1\Clusters::initOnce();
        parent::__construct($data);
    }

    /**
     * Optional. Type of the boot disk (default is "pd-standard").
     * Valid values: "pd-balanced" (Persistent Disk Balanced Solid State Drive),
     * "pd-ssd" (Persistent Disk Solid State Drive),
     * or "pd-standard" (Persistent Disk Hard Disk Drive).
     * See [Disk types](https://cloud.google.com/compute/docs/disks#disk-types).
     *
     * Generated from protobuf field <code>string boot_disk_type = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getBootDiskType()
    {
        return $this->boot_disk_type;
    }

    /**
     * Optional. Type of the boot disk (default is "pd-standard").
     * Valid values: "pd-balanced" (Persistent Disk Balanced Solid State Drive),
     * "pd-ssd" (Persistent Disk Solid State Drive),
     * or "pd-standard" (Persistent Disk Hard Disk Drive).
     * See [Disk types](https://cloud.google.com/compute/docs/disks#disk-types).
     *
     * Generated from protobuf field <code>string boot_disk_type = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setBootDiskType($var)
    {
        GPBUtil::checkString($var, True);
        $this->boot_disk_type = $var;

        return $this;
    }

    /**
     * Optional. Size in GB of the boot disk (default is 500GB).
     *
     * Generated from protobuf field <code>int32 boot_disk_size_gb = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return int
     */
    public function getBootDiskSizeGb()
    {
        return $this->boot_disk_size_gb;
    }

    /**
     * Optional. Size in GB of the boot disk (default is 500GB).
     *
     * Generated from protobuf field <code>int32 boot_disk_size_gb = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param int $var
     * @return $this
     */
    public function setBootDiskSizeGb($var)
    {
        GPBUtil::checkInt32($var);
        $this->boot_disk_size_gb = $var;

        return $this;
    }

    /**
     * Optional. Number of attached SSDs, from 0 to 8 (default is 0).
     * If SSDs are not attached, the boot disk is used to store runtime logs and
     * [HDFS](https://hadoop.apache.org/docs/r1.2.1/hdfs_user_guide.html) data.
     * If one or more SSDs are attached, this runtime bulk
     * data is spread across them, and the boot disk contains only basic
     * config and installed binaries.
     * Note: Local SSD options may vary by machine type and number of vCPUs
     * selected.
     *
     * Generated from protobuf field <code>int32 num_local_ssds = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return int
     */
    public function getNumLocalSsds()
    {
        return $this->num_local_ssds;
    }

    /**
     * Optional. Number of attached SSDs, from 0 to 8 (default is 0).
     * If SSDs are not attached, the boot disk is used to store runtime logs and
     * [HDFS](https://hadoop.apache.org/docs/r1.2.1/hdfs_user_guide.html) data.
     * If one or more SSDs are attached, this runtime bulk
     * data is spread across them, and the boot disk contains only basic
     * config and installed binaries.
     * Note: Local SSD options may vary by machine type and number of vCPUs
     * selected.
     *
     * Generated from protobuf field <code>int32 num_local_ssds = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param int $var
     * @return $this
     */
    public function setNumLocalSsds($var)
    {
        GPBUtil::checkInt32($var);
        $this->num_local_ssds = $var;

        return $this;
    }

    /**
     * Optional. Interface type of local SSDs (default is "scsi").
     * Valid values: "scsi" (Small Computer System Interface),
     * "nvme" (Non-Volatile Memory Express).
     * See [local SSD
     * performance](https://cloud.google.com/compute/docs/disks/local-ssd#performance).
     *
     * Generated from protobuf field <code>string local_ssd_interface = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getLocalSsdInterface()
    {
        return $this->local_ssd_interface;
    }

    /**
     * Optional. Interface type of local SSDs (default is "scsi").
     * Valid values: "scsi" (Small Computer System Interface),
     * "nvme" (Non-Volatile Memory Express).
     * See [local SSD
     * performance](https://cloud.google.com/compute/docs/disks/local-ssd#performance).
     *
     * Generated from protobuf field <code>string local_ssd_interface = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setLocalSsdInterface($var)
    {
        GPBUtil::checkString($var, True);
        $this->local_ssd_interface = $var;

        return $this;
    }

    /**
     * Optional. Indicates how many IOPS to provision for the disk. This sets the
     * number of I/O operations per second that the disk can handle. Note: This
     * field is only supported if boot_disk_type is hyperdisk-balanced.
     *
     * Generated from protobuf field <code>optional int64 boot_disk_provisioned_iops = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return int|string
     */
    public function getBootDiskProvisionedIops()
    {
        return isset($this->boot_disk_provisioned_iops) ? $this->boot_disk_provisioned_iops : 0;
    }

    public function hasBootDiskProvisionedIops()
    {
        return isset($this->boot_disk_provisioned_iops);
    }

    public function clearBootDiskProvisionedIops()
    {
        unset($this->boot_disk_provisioned_iops);
    }

    /**
     * Optional. Indicates how many IOPS to provision for the disk. This sets the
     * number of I/O operations per second that the disk can handle. Note: This
     * field is only supported if boot_disk_type is hyperdisk-balanced.
     *
     * Generated from protobuf field <code>optional int64 boot_disk_provisioned_iops = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param int|string $var
     * @return $this
     */
    public function setBootDiskProvisionedIops($var)
    {
        GPBUtil::checkInt64($var);
        $this->boot_disk_provisioned_iops = $var;

        return $this;
    }

    /**
     * Optional. Indicates how much throughput to provision for the disk. This
     * sets the number of throughput mb per second that the disk can handle.
     * Values must be greater than or equal to 1. Note: This field is only
     * supported if boot_disk_type is hyperdisk-balanced.
     *
     * Generated from protobuf field <code>optional int64 boot_disk_provisioned_throughput = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return int|string
     */
    public function getBootDiskProvisionedThroughput()
    {
        return isset($this->boot_disk_provisioned_throughput) ? $this->boot_disk_provisioned_throughput : 0;
    }

    public function hasBootDiskProvisionedThroughput()
    {
        return isset($this->boot_disk_provisioned_throughput);
    }

    public function clearBootDiskProvisionedThroughput()
    {
        unset($this->boot_disk_provisioned_throughput);
    }

    /**
     * Optional. Indicates how much throughput to provision for the disk. This
     * sets the number of throughput mb per second that the disk can handle.
     * Values must be greater than or equal to 1. Note: This field is only
     * supported if boot_disk_type is hyperdisk-balanced.
     *
     * Generated from protobuf field <code>optional int64 boot_disk_provisioned_throughput = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param int|string $var
     * @return $this
     */
    public function setBootDiskProvisionedThroughput($var)
    {
        GPBUtil::checkInt64($var);
        $this->boot_disk_provisioned_throughput = $var;

        return $this;
    }

}

