<?php
/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/dataplex/v1/service.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\Dataplex\V1\Client;

use Google\ApiCore\ApiException;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\OperationResponse;
use Google\ApiCore\PagedListResponse;
use Google\ApiCore\ResourceHelperTrait;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\Dataplex\V1\Asset;
use Google\Cloud\Dataplex\V1\CancelJobRequest;
use Google\Cloud\Dataplex\V1\CreateAssetRequest;
use Google\Cloud\Dataplex\V1\CreateEnvironmentRequest;
use Google\Cloud\Dataplex\V1\CreateLakeRequest;
use Google\Cloud\Dataplex\V1\CreateTaskRequest;
use Google\Cloud\Dataplex\V1\CreateZoneRequest;
use Google\Cloud\Dataplex\V1\DeleteAssetRequest;
use Google\Cloud\Dataplex\V1\DeleteEnvironmentRequest;
use Google\Cloud\Dataplex\V1\DeleteLakeRequest;
use Google\Cloud\Dataplex\V1\DeleteTaskRequest;
use Google\Cloud\Dataplex\V1\DeleteZoneRequest;
use Google\Cloud\Dataplex\V1\Environment;
use Google\Cloud\Dataplex\V1\GetAssetRequest;
use Google\Cloud\Dataplex\V1\GetEnvironmentRequest;
use Google\Cloud\Dataplex\V1\GetJobRequest;
use Google\Cloud\Dataplex\V1\GetLakeRequest;
use Google\Cloud\Dataplex\V1\GetTaskRequest;
use Google\Cloud\Dataplex\V1\GetZoneRequest;
use Google\Cloud\Dataplex\V1\Job;
use Google\Cloud\Dataplex\V1\Lake;
use Google\Cloud\Dataplex\V1\ListAssetActionsRequest;
use Google\Cloud\Dataplex\V1\ListAssetsRequest;
use Google\Cloud\Dataplex\V1\ListEnvironmentsRequest;
use Google\Cloud\Dataplex\V1\ListJobsRequest;
use Google\Cloud\Dataplex\V1\ListLakeActionsRequest;
use Google\Cloud\Dataplex\V1\ListLakesRequest;
use Google\Cloud\Dataplex\V1\ListSessionsRequest;
use Google\Cloud\Dataplex\V1\ListTasksRequest;
use Google\Cloud\Dataplex\V1\ListZoneActionsRequest;
use Google\Cloud\Dataplex\V1\ListZonesRequest;
use Google\Cloud\Dataplex\V1\RunTaskRequest;
use Google\Cloud\Dataplex\V1\RunTaskResponse;
use Google\Cloud\Dataplex\V1\Task;
use Google\Cloud\Dataplex\V1\UpdateAssetRequest;
use Google\Cloud\Dataplex\V1\UpdateEnvironmentRequest;
use Google\Cloud\Dataplex\V1\UpdateLakeRequest;
use Google\Cloud\Dataplex\V1\UpdateTaskRequest;
use Google\Cloud\Dataplex\V1\UpdateZoneRequest;
use Google\Cloud\Dataplex\V1\Zone;
use Google\Cloud\Iam\V1\GetIamPolicyRequest;
use Google\Cloud\Iam\V1\Policy;
use Google\Cloud\Iam\V1\SetIamPolicyRequest;
use Google\Cloud\Iam\V1\TestIamPermissionsRequest;
use Google\Cloud\Iam\V1\TestIamPermissionsResponse;
use Google\Cloud\Location\GetLocationRequest;
use Google\Cloud\Location\ListLocationsRequest;
use Google\Cloud\Location\Location;
use Google\LongRunning\Client\OperationsClient;
use Google\LongRunning\Operation;
use GuzzleHttp\Promise\PromiseInterface;
use Psr\Log\LoggerInterface;

/**
 * Service Description: Dataplex service provides data lakes as a service. The primary resources
 * offered by this service are Lakes, Zones and Assets which collectively allow
 * a data administrator to organize, manage, secure and catalog data across
 * their organization located across cloud projects in a variety of storage
 * systems including Cloud Storage and BigQuery.
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods.
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 *
 * @method PromiseInterface<void> cancelJobAsync(CancelJobRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> createAssetAsync(CreateAssetRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> createEnvironmentAsync(CreateEnvironmentRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> createLakeAsync(CreateLakeRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> createTaskAsync(CreateTaskRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> createZoneAsync(CreateZoneRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> deleteAssetAsync(DeleteAssetRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> deleteEnvironmentAsync(DeleteEnvironmentRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> deleteLakeAsync(DeleteLakeRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> deleteTaskAsync(DeleteTaskRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> deleteZoneAsync(DeleteZoneRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Asset> getAssetAsync(GetAssetRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Environment> getEnvironmentAsync(GetEnvironmentRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Job> getJobAsync(GetJobRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Lake> getLakeAsync(GetLakeRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Task> getTaskAsync(GetTaskRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Zone> getZoneAsync(GetZoneRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listAssetActionsAsync(ListAssetActionsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listAssetsAsync(ListAssetsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listEnvironmentsAsync(ListEnvironmentsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listJobsAsync(ListJobsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listLakeActionsAsync(ListLakeActionsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listLakesAsync(ListLakesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listSessionsAsync(ListSessionsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listTasksAsync(ListTasksRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listZoneActionsAsync(ListZoneActionsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listZonesAsync(ListZonesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<RunTaskResponse> runTaskAsync(RunTaskRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> updateAssetAsync(UpdateAssetRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> updateEnvironmentAsync(UpdateEnvironmentRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> updateLakeAsync(UpdateLakeRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> updateTaskAsync(UpdateTaskRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> updateZoneAsync(UpdateZoneRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Policy> getIamPolicyAsync(GetIamPolicyRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Policy> setIamPolicyAsync(SetIamPolicyRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<TestIamPermissionsResponse> testIamPermissionsAsync(TestIamPermissionsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Location> getLocationAsync(GetLocationRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listLocationsAsync(ListLocationsRequest $request, array $optionalArgs = [])
 */
final class DataplexServiceClient
{
    use GapicClientTrait;
    use ResourceHelperTrait;

    /** The name of the service. */
    private const SERVICE_NAME = 'google.cloud.dataplex.v1.DataplexService';

    /**
     * The default address of the service.
     *
     * @deprecated SERVICE_ADDRESS_TEMPLATE should be used instead.
     */
    private const SERVICE_ADDRESS = 'dataplex.googleapis.com';

    /** The address template of the service. */
    private const SERVICE_ADDRESS_TEMPLATE = 'dataplex.UNIVERSE_DOMAIN';

    /** The default port of the service. */
    private const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    private const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = ['https://www.googleapis.com/auth/cloud-platform'];

    private $operationsClient;

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' => self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' => __DIR__ . '/../resources/dataplex_service_client_config.json',
            'descriptorsConfigPath' => __DIR__ . '/../resources/dataplex_service_descriptor_config.php',
            'gcpApiConfigPath' => __DIR__ . '/../resources/dataplex_service_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' => __DIR__ . '/../resources/dataplex_service_rest_client_config.php',
                ],
            ],
        ];
    }

    /**
     * Return an OperationsClient object with the same endpoint as $this.
     *
     * @return OperationsClient
     */
    public function getOperationsClient()
    {
        return $this->operationsClient;
    }

    /**
     * Resume an existing long running operation that was previously started by a long
     * running API method. If $methodName is not provided, or does not match a long
     * running API method, then the operation can still be resumed, but the
     * OperationResponse object will not deserialize the final response.
     *
     * @param string $operationName The name of the long running operation
     * @param string $methodName    The name of the method used to start the operation
     *
     * @return OperationResponse
     */
    public function resumeOperation($operationName, $methodName = null)
    {
        $options = isset($this->descriptors[$methodName]['longRunning'])
            ? $this->descriptors[$methodName]['longRunning']
            : [];
        $operation = new OperationResponse($operationName, $this->getOperationsClient(), $options);
        $operation->reload();
        return $operation;
    }

    /**
     * Create the default operation client for the service.
     *
     * @param array $options ClientOptions for the client.
     *
     * @return OperationsClient
     */
    private function createOperationsClient(array $options)
    {
        // Unset client-specific configuration options
        unset($options['serviceName'], $options['clientConfig'], $options['descriptorsConfigPath']);

        if (isset($options['operationsClient'])) {
            return $options['operationsClient'];
        }

        return new OperationsClient($options);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a asset
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $lake
     * @param string $zone
     * @param string $asset
     *
     * @return string The formatted asset resource.
     */
    public static function assetName(
        string $project,
        string $location,
        string $lake,
        string $zone,
        string $asset
    ): string {
        return self::getPathTemplate('asset')->render([
            'project' => $project,
            'location' => $location,
            'lake' => $lake,
            'zone' => $zone,
            'asset' => $asset,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a environment
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $lake
     * @param string $environment
     *
     * @return string The formatted environment resource.
     */
    public static function environmentName(string $project, string $location, string $lake, string $environment): string
    {
        return self::getPathTemplate('environment')->render([
            'project' => $project,
            'location' => $location,
            'lake' => $lake,
            'environment' => $environment,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a job
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $lake
     * @param string $task
     * @param string $job
     *
     * @return string The formatted job resource.
     */
    public static function jobName(string $project, string $location, string $lake, string $task, string $job): string
    {
        return self::getPathTemplate('job')->render([
            'project' => $project,
            'location' => $location,
            'lake' => $lake,
            'task' => $task,
            'job' => $job,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a lake
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $lake
     *
     * @return string The formatted lake resource.
     */
    public static function lakeName(string $project, string $location, string $lake): string
    {
        return self::getPathTemplate('lake')->render([
            'project' => $project,
            'location' => $location,
            'lake' => $lake,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a location
     * resource.
     *
     * @param string $project
     * @param string $location
     *
     * @return string The formatted location resource.
     */
    public static function locationName(string $project, string $location): string
    {
        return self::getPathTemplate('location')->render([
            'project' => $project,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a task
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $lake
     * @param string $task
     *
     * @return string The formatted task resource.
     */
    public static function taskName(string $project, string $location, string $lake, string $task): string
    {
        return self::getPathTemplate('task')->render([
            'project' => $project,
            'location' => $location,
            'lake' => $lake,
            'task' => $task,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a zone
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $lake
     * @param string $zone
     *
     * @return string The formatted zone resource.
     */
    public static function zoneName(string $project, string $location, string $lake, string $zone): string
    {
        return self::getPathTemplate('zone')->render([
            'project' => $project,
            'location' => $location,
            'lake' => $lake,
            'zone' => $zone,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - asset: projects/{project}/locations/{location}/lakes/{lake}/zones/{zone}/assets/{asset}
     * - environment: projects/{project}/locations/{location}/lakes/{lake}/environments/{environment}
     * - job: projects/{project}/locations/{location}/lakes/{lake}/tasks/{task}/jobs/{job}
     * - lake: projects/{project}/locations/{location}/lakes/{lake}
     * - location: projects/{project}/locations/{location}
     * - task: projects/{project}/locations/{location}/lakes/{lake}/tasks/{task}
     * - zone: projects/{project}/locations/{location}/lakes/{lake}/zones/{zone}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string  $formattedName The formatted name string
     * @param ?string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName(string $formattedName, ?string $template = null): array
    {
        return self::parseFormattedName($formattedName, $template);
    }

    /**
     * Constructor.
     *
     * @param array $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'dataplex.googleapis.com:443'.
     *     @type string|array|FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           The credentials to be used by the client to authorize API calls. This option
     *           accepts either a path to a credentials file, or a decoded credentials file as a
     *           PHP array.
     *           *Advanced usage*: In addition, this option can also accept a pre-constructed
     *           {@see \Google\Auth\FetchAuthTokenInterface} object or
     *           {@see \Google\ApiCore\CredentialsWrapper} object. Note that when one of these
     *           objects are provided, any settings in $credentialsConfig will be ignored.
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     *     @type false|LoggerInterface $logger
     *           A PSR-3 compliant logger. If set to false, logging is disabled, ignoring the
     *           'GOOGLE_SDK_PHP_LOGGING' environment flag
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
        $this->operationsClient = $this->createOperationsClient($clientOptions);
    }

    /** Handles execution of the async variants for each documented method. */
    public function __call($method, $args)
    {
        if (substr($method, -5) !== 'Async') {
            trigger_error('Call to undefined method ' . __CLASS__ . "::$method()", E_USER_ERROR);
        }

        array_unshift($args, substr($method, 0, -5));
        return call_user_func_array([$this, 'startAsyncCall'], $args);
    }

    /**
     * Cancel jobs running for the task resource.
     *
     * The async variant is {@see DataplexServiceClient::cancelJobAsync()} .
     *
     * @example samples/V1/DataplexServiceClient/cancel_job.php
     *
     * @param CancelJobRequest $request     A request to house fields associated with the call.
     * @param array            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function cancelJob(CancelJobRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('CancelJob', $request, $callOptions)->wait();
    }

    /**
     * Creates an asset resource.
     *
     * The async variant is {@see DataplexServiceClient::createAssetAsync()} .
     *
     * @example samples/V1/DataplexServiceClient/create_asset.php
     *
     * @param CreateAssetRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createAsset(CreateAssetRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreateAsset', $request, $callOptions)->wait();
    }

    /**
     * Create an environment resource.
     *
     * The async variant is {@see DataplexServiceClient::createEnvironmentAsync()} .
     *
     * @example samples/V1/DataplexServiceClient/create_environment.php
     *
     * @param CreateEnvironmentRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createEnvironment(CreateEnvironmentRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreateEnvironment', $request, $callOptions)->wait();
    }

    /**
     * Creates a lake resource.
     *
     * The async variant is {@see DataplexServiceClient::createLakeAsync()} .
     *
     * @example samples/V1/DataplexServiceClient/create_lake.php
     *
     * @param CreateLakeRequest $request     A request to house fields associated with the call.
     * @param array             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createLake(CreateLakeRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreateLake', $request, $callOptions)->wait();
    }

    /**
     * Creates a task resource within a lake.
     *
     * The async variant is {@see DataplexServiceClient::createTaskAsync()} .
     *
     * @example samples/V1/DataplexServiceClient/create_task.php
     *
     * @param CreateTaskRequest $request     A request to house fields associated with the call.
     * @param array             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createTask(CreateTaskRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreateTask', $request, $callOptions)->wait();
    }

    /**
     * Creates a zone resource within a lake.
     *
     * The async variant is {@see DataplexServiceClient::createZoneAsync()} .
     *
     * @example samples/V1/DataplexServiceClient/create_zone.php
     *
     * @param CreateZoneRequest $request     A request to house fields associated with the call.
     * @param array             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createZone(CreateZoneRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreateZone', $request, $callOptions)->wait();
    }

    /**
     * Deletes an asset resource. The referenced storage resource is detached
     * (default) or deleted based on the associated Lifecycle policy.
     *
     * The async variant is {@see DataplexServiceClient::deleteAssetAsync()} .
     *
     * @example samples/V1/DataplexServiceClient/delete_asset.php
     *
     * @param DeleteAssetRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteAsset(DeleteAssetRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeleteAsset', $request, $callOptions)->wait();
    }

    /**
     * Delete the environment resource. All the child resources must have been
     * deleted before environment deletion can be initiated.
     *
     * The async variant is {@see DataplexServiceClient::deleteEnvironmentAsync()} .
     *
     * @example samples/V1/DataplexServiceClient/delete_environment.php
     *
     * @param DeleteEnvironmentRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteEnvironment(DeleteEnvironmentRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeleteEnvironment', $request, $callOptions)->wait();
    }

    /**
     * Deletes a lake resource. All zones within the lake must be deleted before
     * the lake can be deleted.
     *
     * The async variant is {@see DataplexServiceClient::deleteLakeAsync()} .
     *
     * @example samples/V1/DataplexServiceClient/delete_lake.php
     *
     * @param DeleteLakeRequest $request     A request to house fields associated with the call.
     * @param array             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteLake(DeleteLakeRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeleteLake', $request, $callOptions)->wait();
    }

    /**
     * Delete the task resource.
     *
     * The async variant is {@see DataplexServiceClient::deleteTaskAsync()} .
     *
     * @example samples/V1/DataplexServiceClient/delete_task.php
     *
     * @param DeleteTaskRequest $request     A request to house fields associated with the call.
     * @param array             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteTask(DeleteTaskRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeleteTask', $request, $callOptions)->wait();
    }

    /**
     * Deletes a zone resource. All assets within a zone must be deleted before
     * the zone can be deleted.
     *
     * The async variant is {@see DataplexServiceClient::deleteZoneAsync()} .
     *
     * @example samples/V1/DataplexServiceClient/delete_zone.php
     *
     * @param DeleteZoneRequest $request     A request to house fields associated with the call.
     * @param array             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteZone(DeleteZoneRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeleteZone', $request, $callOptions)->wait();
    }

    /**
     * Retrieves an asset resource.
     *
     * The async variant is {@see DataplexServiceClient::getAssetAsync()} .
     *
     * @example samples/V1/DataplexServiceClient/get_asset.php
     *
     * @param GetAssetRequest $request     A request to house fields associated with the call.
     * @param array           $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Asset
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getAsset(GetAssetRequest $request, array $callOptions = []): Asset
    {
        return $this->startApiCall('GetAsset', $request, $callOptions)->wait();
    }

    /**
     * Get environment resource.
     *
     * The async variant is {@see DataplexServiceClient::getEnvironmentAsync()} .
     *
     * @example samples/V1/DataplexServiceClient/get_environment.php
     *
     * @param GetEnvironmentRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Environment
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getEnvironment(GetEnvironmentRequest $request, array $callOptions = []): Environment
    {
        return $this->startApiCall('GetEnvironment', $request, $callOptions)->wait();
    }

    /**
     * Get job resource.
     *
     * The async variant is {@see DataplexServiceClient::getJobAsync()} .
     *
     * @example samples/V1/DataplexServiceClient/get_job.php
     *
     * @param GetJobRequest $request     A request to house fields associated with the call.
     * @param array         $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Job
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getJob(GetJobRequest $request, array $callOptions = []): Job
    {
        return $this->startApiCall('GetJob', $request, $callOptions)->wait();
    }

    /**
     * Retrieves a lake resource.
     *
     * The async variant is {@see DataplexServiceClient::getLakeAsync()} .
     *
     * @example samples/V1/DataplexServiceClient/get_lake.php
     *
     * @param GetLakeRequest $request     A request to house fields associated with the call.
     * @param array          $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Lake
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getLake(GetLakeRequest $request, array $callOptions = []): Lake
    {
        return $this->startApiCall('GetLake', $request, $callOptions)->wait();
    }

    /**
     * Get task resource.
     *
     * The async variant is {@see DataplexServiceClient::getTaskAsync()} .
     *
     * @example samples/V1/DataplexServiceClient/get_task.php
     *
     * @param GetTaskRequest $request     A request to house fields associated with the call.
     * @param array          $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Task
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getTask(GetTaskRequest $request, array $callOptions = []): Task
    {
        return $this->startApiCall('GetTask', $request, $callOptions)->wait();
    }

    /**
     * Retrieves a zone resource.
     *
     * The async variant is {@see DataplexServiceClient::getZoneAsync()} .
     *
     * @example samples/V1/DataplexServiceClient/get_zone.php
     *
     * @param GetZoneRequest $request     A request to house fields associated with the call.
     * @param array          $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Zone
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getZone(GetZoneRequest $request, array $callOptions = []): Zone
    {
        return $this->startApiCall('GetZone', $request, $callOptions)->wait();
    }

    /**
     * Lists action resources in an asset.
     *
     * The async variant is {@see DataplexServiceClient::listAssetActionsAsync()} .
     *
     * @example samples/V1/DataplexServiceClient/list_asset_actions.php
     *
     * @param ListAssetActionsRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listAssetActions(ListAssetActionsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListAssetActions', $request, $callOptions);
    }

    /**
     * Lists asset resources in a zone.
     *
     * The async variant is {@see DataplexServiceClient::listAssetsAsync()} .
     *
     * @example samples/V1/DataplexServiceClient/list_assets.php
     *
     * @param ListAssetsRequest $request     A request to house fields associated with the call.
     * @param array             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listAssets(ListAssetsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListAssets', $request, $callOptions);
    }

    /**
     * Lists environments under the given lake.
     *
     * The async variant is {@see DataplexServiceClient::listEnvironmentsAsync()} .
     *
     * @example samples/V1/DataplexServiceClient/list_environments.php
     *
     * @param ListEnvironmentsRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listEnvironments(ListEnvironmentsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListEnvironments', $request, $callOptions);
    }

    /**
     * Lists Jobs under the given task.
     *
     * The async variant is {@see DataplexServiceClient::listJobsAsync()} .
     *
     * @example samples/V1/DataplexServiceClient/list_jobs.php
     *
     * @param ListJobsRequest $request     A request to house fields associated with the call.
     * @param array           $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listJobs(ListJobsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListJobs', $request, $callOptions);
    }

    /**
     * Lists action resources in a lake.
     *
     * The async variant is {@see DataplexServiceClient::listLakeActionsAsync()} .
     *
     * @example samples/V1/DataplexServiceClient/list_lake_actions.php
     *
     * @param ListLakeActionsRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listLakeActions(ListLakeActionsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListLakeActions', $request, $callOptions);
    }

    /**
     * Lists lake resources in a project and location.
     *
     * The async variant is {@see DataplexServiceClient::listLakesAsync()} .
     *
     * @example samples/V1/DataplexServiceClient/list_lakes.php
     *
     * @param ListLakesRequest $request     A request to house fields associated with the call.
     * @param array            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listLakes(ListLakesRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListLakes', $request, $callOptions);
    }

    /**
     * Lists session resources in an environment.
     *
     * The async variant is {@see DataplexServiceClient::listSessionsAsync()} .
     *
     * @example samples/V1/DataplexServiceClient/list_sessions.php
     *
     * @param ListSessionsRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listSessions(ListSessionsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListSessions', $request, $callOptions);
    }

    /**
     * Lists tasks under the given lake.
     *
     * The async variant is {@see DataplexServiceClient::listTasksAsync()} .
     *
     * @example samples/V1/DataplexServiceClient/list_tasks.php
     *
     * @param ListTasksRequest $request     A request to house fields associated with the call.
     * @param array            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listTasks(ListTasksRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListTasks', $request, $callOptions);
    }

    /**
     * Lists action resources in a zone.
     *
     * The async variant is {@see DataplexServiceClient::listZoneActionsAsync()} .
     *
     * @example samples/V1/DataplexServiceClient/list_zone_actions.php
     *
     * @param ListZoneActionsRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listZoneActions(ListZoneActionsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListZoneActions', $request, $callOptions);
    }

    /**
     * Lists zone resources in a lake.
     *
     * The async variant is {@see DataplexServiceClient::listZonesAsync()} .
     *
     * @example samples/V1/DataplexServiceClient/list_zones.php
     *
     * @param ListZonesRequest $request     A request to house fields associated with the call.
     * @param array            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listZones(ListZonesRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListZones', $request, $callOptions);
    }

    /**
     * Run an on demand execution of a Task.
     *
     * The async variant is {@see DataplexServiceClient::runTaskAsync()} .
     *
     * @example samples/V1/DataplexServiceClient/run_task.php
     *
     * @param RunTaskRequest $request     A request to house fields associated with the call.
     * @param array          $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return RunTaskResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function runTask(RunTaskRequest $request, array $callOptions = []): RunTaskResponse
    {
        return $this->startApiCall('RunTask', $request, $callOptions)->wait();
    }

    /**
     * Updates an asset resource.
     *
     * The async variant is {@see DataplexServiceClient::updateAssetAsync()} .
     *
     * @example samples/V1/DataplexServiceClient/update_asset.php
     *
     * @param UpdateAssetRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateAsset(UpdateAssetRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('UpdateAsset', $request, $callOptions)->wait();
    }

    /**
     * Update the environment resource.
     *
     * The async variant is {@see DataplexServiceClient::updateEnvironmentAsync()} .
     *
     * @example samples/V1/DataplexServiceClient/update_environment.php
     *
     * @param UpdateEnvironmentRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateEnvironment(UpdateEnvironmentRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('UpdateEnvironment', $request, $callOptions)->wait();
    }

    /**
     * Updates a lake resource.
     *
     * The async variant is {@see DataplexServiceClient::updateLakeAsync()} .
     *
     * @example samples/V1/DataplexServiceClient/update_lake.php
     *
     * @param UpdateLakeRequest $request     A request to house fields associated with the call.
     * @param array             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateLake(UpdateLakeRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('UpdateLake', $request, $callOptions)->wait();
    }

    /**
     * Update the task resource.
     *
     * The async variant is {@see DataplexServiceClient::updateTaskAsync()} .
     *
     * @example samples/V1/DataplexServiceClient/update_task.php
     *
     * @param UpdateTaskRequest $request     A request to house fields associated with the call.
     * @param array             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateTask(UpdateTaskRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('UpdateTask', $request, $callOptions)->wait();
    }

    /**
     * Updates a zone resource.
     *
     * The async variant is {@see DataplexServiceClient::updateZoneAsync()} .
     *
     * @example samples/V1/DataplexServiceClient/update_zone.php
     *
     * @param UpdateZoneRequest $request     A request to house fields associated with the call.
     * @param array             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateZone(UpdateZoneRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('UpdateZone', $request, $callOptions)->wait();
    }

    /**
     * Gets the access control policy for a resource. Returns an empty policy
    if the resource exists and does not have a policy set.
     *
     * The async variant is {@see DataplexServiceClient::getIamPolicyAsync()} .
     *
     * @example samples/V1/DataplexServiceClient/get_iam_policy.php
     *
     * @param GetIamPolicyRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Policy
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getIamPolicy(GetIamPolicyRequest $request, array $callOptions = []): Policy
    {
        return $this->startApiCall('GetIamPolicy', $request, $callOptions)->wait();
    }

    /**
     * Sets the access control policy on the specified resource. Replaces
    any existing policy.

    Can return `NOT_FOUND`, `INVALID_ARGUMENT`, and `PERMISSION_DENIED`
    errors.
     *
     * The async variant is {@see DataplexServiceClient::setIamPolicyAsync()} .
     *
     * @example samples/V1/DataplexServiceClient/set_iam_policy.php
     *
     * @param SetIamPolicyRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Policy
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function setIamPolicy(SetIamPolicyRequest $request, array $callOptions = []): Policy
    {
        return $this->startApiCall('SetIamPolicy', $request, $callOptions)->wait();
    }

    /**
     * Returns permissions that a caller has on the specified resource. If the
    resource does not exist, this will return an empty set of
    permissions, not a `NOT_FOUND` error.

    Note: This operation is designed to be used for building
    permission-aware UIs and command-line tools, not for authorization
    checking. This operation may "fail open" without warning.
     *
     * The async variant is {@see DataplexServiceClient::testIamPermissionsAsync()} .
     *
     * @example samples/V1/DataplexServiceClient/test_iam_permissions.php
     *
     * @param TestIamPermissionsRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return TestIamPermissionsResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function testIamPermissions(
        TestIamPermissionsRequest $request,
        array $callOptions = []
    ): TestIamPermissionsResponse {
        return $this->startApiCall('TestIamPermissions', $request, $callOptions)->wait();
    }

    /**
     * Gets information about a location.
     *
     * The async variant is {@see DataplexServiceClient::getLocationAsync()} .
     *
     * @example samples/V1/DataplexServiceClient/get_location.php
     *
     * @param GetLocationRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Location
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getLocation(GetLocationRequest $request, array $callOptions = []): Location
    {
        return $this->startApiCall('GetLocation', $request, $callOptions)->wait();
    }

    /**
     * Lists information about the supported locations for this service.
     *
     * The async variant is {@see DataplexServiceClient::listLocationsAsync()} .
     *
     * @example samples/V1/DataplexServiceClient/list_locations.php
     *
     * @param ListLocationsRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listLocations(ListLocationsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListLocations', $request, $callOptions);
    }
}
