<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/dataflow/v1beta3/environment.proto

namespace Google\Cloud\Dataflow\V1beta3;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Provides data to pass through to the worker harness.
 *
 * Generated from protobuf message <code>google.dataflow.v1beta3.WorkerSettings</code>
 */
class WorkerSettings extends \Google\Protobuf\Internal\Message
{
    /**
     * The base URL for accessing Google Cloud APIs.
     * When workers access Google Cloud APIs, they logically do so via
     * relative URLs.  If this field is specified, it supplies the base
     * URL to use for resolving these relative URLs.  The normative
     * algorithm used is defined by RFC 1808, "Relative Uniform Resource
     * Locators".
     * If not specified, the default value is "http://www.googleapis.com/"
     *
     * Generated from protobuf field <code>string base_url = 1;</code>
     */
    protected $base_url = '';
    /**
     * Whether to send work progress updates to the service.
     *
     * Generated from protobuf field <code>bool reporting_enabled = 2;</code>
     */
    protected $reporting_enabled = false;
    /**
     * The Cloud Dataflow service path relative to the root URL, for example,
     * "dataflow/v1b3/projects".
     *
     * Generated from protobuf field <code>string service_path = 3;</code>
     */
    protected $service_path = '';
    /**
     * The Shuffle service path relative to the root URL, for example,
     * "shuffle/v1beta1".
     *
     * Generated from protobuf field <code>string shuffle_service_path = 4;</code>
     */
    protected $shuffle_service_path = '';
    /**
     * The ID of the worker running this pipeline.
     *
     * Generated from protobuf field <code>string worker_id = 5;</code>
     */
    protected $worker_id = '';
    /**
     * The prefix of the resources the system should use for temporary
     * storage.
     * The supported resource type is:
     * Google Cloud Storage:
     *   storage.googleapis.com/{bucket}/{object}
     *   bucket.storage.googleapis.com/{object}
     *
     * Generated from protobuf field <code>string temp_storage_prefix = 6;</code>
     */
    protected $temp_storage_prefix = '';

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $base_url
     *           The base URL for accessing Google Cloud APIs.
     *           When workers access Google Cloud APIs, they logically do so via
     *           relative URLs.  If this field is specified, it supplies the base
     *           URL to use for resolving these relative URLs.  The normative
     *           algorithm used is defined by RFC 1808, "Relative Uniform Resource
     *           Locators".
     *           If not specified, the default value is "http://www.googleapis.com/"
     *     @type bool $reporting_enabled
     *           Whether to send work progress updates to the service.
     *     @type string $service_path
     *           The Cloud Dataflow service path relative to the root URL, for example,
     *           "dataflow/v1b3/projects".
     *     @type string $shuffle_service_path
     *           The Shuffle service path relative to the root URL, for example,
     *           "shuffle/v1beta1".
     *     @type string $worker_id
     *           The ID of the worker running this pipeline.
     *     @type string $temp_storage_prefix
     *           The prefix of the resources the system should use for temporary
     *           storage.
     *           The supported resource type is:
     *           Google Cloud Storage:
     *             storage.googleapis.com/{bucket}/{object}
     *             bucket.storage.googleapis.com/{object}
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Dataflow\V1Beta3\Environment::initOnce();
        parent::__construct($data);
    }

    /**
     * The base URL for accessing Google Cloud APIs.
     * When workers access Google Cloud APIs, they logically do so via
     * relative URLs.  If this field is specified, it supplies the base
     * URL to use for resolving these relative URLs.  The normative
     * algorithm used is defined by RFC 1808, "Relative Uniform Resource
     * Locators".
     * If not specified, the default value is "http://www.googleapis.com/"
     *
     * Generated from protobuf field <code>string base_url = 1;</code>
     * @return string
     */
    public function getBaseUrl()
    {
        return $this->base_url;
    }

    /**
     * The base URL for accessing Google Cloud APIs.
     * When workers access Google Cloud APIs, they logically do so via
     * relative URLs.  If this field is specified, it supplies the base
     * URL to use for resolving these relative URLs.  The normative
     * algorithm used is defined by RFC 1808, "Relative Uniform Resource
     * Locators".
     * If not specified, the default value is "http://www.googleapis.com/"
     *
     * Generated from protobuf field <code>string base_url = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setBaseUrl($var)
    {
        GPBUtil::checkString($var, True);
        $this->base_url = $var;

        return $this;
    }

    /**
     * Whether to send work progress updates to the service.
     *
     * Generated from protobuf field <code>bool reporting_enabled = 2;</code>
     * @return bool
     */
    public function getReportingEnabled()
    {
        return $this->reporting_enabled;
    }

    /**
     * Whether to send work progress updates to the service.
     *
     * Generated from protobuf field <code>bool reporting_enabled = 2;</code>
     * @param bool $var
     * @return $this
     */
    public function setReportingEnabled($var)
    {
        GPBUtil::checkBool($var);
        $this->reporting_enabled = $var;

        return $this;
    }

    /**
     * The Cloud Dataflow service path relative to the root URL, for example,
     * "dataflow/v1b3/projects".
     *
     * Generated from protobuf field <code>string service_path = 3;</code>
     * @return string
     */
    public function getServicePath()
    {
        return $this->service_path;
    }

    /**
     * The Cloud Dataflow service path relative to the root URL, for example,
     * "dataflow/v1b3/projects".
     *
     * Generated from protobuf field <code>string service_path = 3;</code>
     * @param string $var
     * @return $this
     */
    public function setServicePath($var)
    {
        GPBUtil::checkString($var, True);
        $this->service_path = $var;

        return $this;
    }

    /**
     * The Shuffle service path relative to the root URL, for example,
     * "shuffle/v1beta1".
     *
     * Generated from protobuf field <code>string shuffle_service_path = 4;</code>
     * @return string
     */
    public function getShuffleServicePath()
    {
        return $this->shuffle_service_path;
    }

    /**
     * The Shuffle service path relative to the root URL, for example,
     * "shuffle/v1beta1".
     *
     * Generated from protobuf field <code>string shuffle_service_path = 4;</code>
     * @param string $var
     * @return $this
     */
    public function setShuffleServicePath($var)
    {
        GPBUtil::checkString($var, True);
        $this->shuffle_service_path = $var;

        return $this;
    }

    /**
     * The ID of the worker running this pipeline.
     *
     * Generated from protobuf field <code>string worker_id = 5;</code>
     * @return string
     */
    public function getWorkerId()
    {
        return $this->worker_id;
    }

    /**
     * The ID of the worker running this pipeline.
     *
     * Generated from protobuf field <code>string worker_id = 5;</code>
     * @param string $var
     * @return $this
     */
    public function setWorkerId($var)
    {
        GPBUtil::checkString($var, True);
        $this->worker_id = $var;

        return $this;
    }

    /**
     * The prefix of the resources the system should use for temporary
     * storage.
     * The supported resource type is:
     * Google Cloud Storage:
     *   storage.googleapis.com/{bucket}/{object}
     *   bucket.storage.googleapis.com/{object}
     *
     * Generated from protobuf field <code>string temp_storage_prefix = 6;</code>
     * @return string
     */
    public function getTempStoragePrefix()
    {
        return $this->temp_storage_prefix;
    }

    /**
     * The prefix of the resources the system should use for temporary
     * storage.
     * The supported resource type is:
     * Google Cloud Storage:
     *   storage.googleapis.com/{bucket}/{object}
     *   bucket.storage.googleapis.com/{object}
     *
     * Generated from protobuf field <code>string temp_storage_prefix = 6;</code>
     * @param string $var
     * @return $this
     */
    public function setTempStoragePrefix($var)
    {
        GPBUtil::checkString($var, True);
        $this->temp_storage_prefix = $var;

        return $this;
    }

}

