<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/bigtable/v2/bigtable.proto

namespace Google\Cloud\Bigtable\V2\ReadChangeStreamResponse;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * A message corresponding to one or more mutations to the partition
 * being streamed. A single logical `DataChange` message may also be split
 * across a sequence of multiple individual messages. Messages other than
 * the first in a sequence will only have the `type` and `chunks` fields
 * populated, with the final message in the sequence also containing `done`
 * set to true.
 *
 * Generated from protobuf message <code>google.bigtable.v2.ReadChangeStreamResponse.DataChange</code>
 */
class DataChange extends \Google\Protobuf\Internal\Message
{
    /**
     * The type of the mutation.
     *
     * Generated from protobuf field <code>.google.bigtable.v2.ReadChangeStreamResponse.DataChange.Type type = 1;</code>
     */
    protected $type = 0;
    /**
     * The cluster where the mutation was applied.
     * Not set when `type` is `GARBAGE_COLLECTION`.
     *
     * Generated from protobuf field <code>string source_cluster_id = 2;</code>
     */
    protected $source_cluster_id = '';
    /**
     * The row key for all mutations that are part of this `DataChange`.
     * If the `DataChange` is chunked across multiple messages, then this field
     * will only be set for the first message.
     *
     * Generated from protobuf field <code>bytes row_key = 3;</code>
     */
    protected $row_key = '';
    /**
     * The timestamp at which the mutation was applied on the Bigtable server.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp commit_timestamp = 4;</code>
     */
    protected $commit_timestamp = null;
    /**
     * A value that lets stream consumers reconstruct Bigtable's
     * conflict resolution semantics.
     * https://cloud.google.com/bigtable/docs/writes#conflict-resolution
     * In the event that the same row key, column family, column qualifier,
     * timestamp are modified on different clusters at the same
     * `commit_timestamp`, the mutation with the larger `tiebreaker` will be the
     * one chosen for the eventually consistent state of the system.
     *
     * Generated from protobuf field <code>int32 tiebreaker = 5;</code>
     */
    protected $tiebreaker = 0;
    /**
     * The mutations associated with this change to the partition.
     * May contain complete mutations or chunks of a multi-message chunked
     * `DataChange` record.
     *
     * Generated from protobuf field <code>repeated .google.bigtable.v2.ReadChangeStreamResponse.MutationChunk chunks = 6;</code>
     */
    private $chunks;
    /**
     * When true, indicates that the entire `DataChange` has been read
     * and the client can safely process the message.
     *
     * Generated from protobuf field <code>bool done = 8;</code>
     */
    protected $done = false;
    /**
     * An encoded position for this stream's partition to restart reading from.
     * This token is for the StreamPartition from the request.
     *
     * Generated from protobuf field <code>string token = 9;</code>
     */
    protected $token = '';
    /**
     * An estimate of the commit timestamp that is usually lower than or equal
     * to any timestamp for a record that will be delivered in the future on the
     * stream. It is possible that, under particular circumstances that a future
     * record has a timestamp is is lower than a previously seen timestamp. For
     * an example usage see
     * https://beam.apache.org/documentation/basics/#watermarks
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp estimated_low_watermark = 10;</code>
     */
    protected $estimated_low_watermark = null;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type int $type
     *           The type of the mutation.
     *     @type string $source_cluster_id
     *           The cluster where the mutation was applied.
     *           Not set when `type` is `GARBAGE_COLLECTION`.
     *     @type string $row_key
     *           The row key for all mutations that are part of this `DataChange`.
     *           If the `DataChange` is chunked across multiple messages, then this field
     *           will only be set for the first message.
     *     @type \Google\Protobuf\Timestamp $commit_timestamp
     *           The timestamp at which the mutation was applied on the Bigtable server.
     *     @type int $tiebreaker
     *           A value that lets stream consumers reconstruct Bigtable's
     *           conflict resolution semantics.
     *           https://cloud.google.com/bigtable/docs/writes#conflict-resolution
     *           In the event that the same row key, column family, column qualifier,
     *           timestamp are modified on different clusters at the same
     *           `commit_timestamp`, the mutation with the larger `tiebreaker` will be the
     *           one chosen for the eventually consistent state of the system.
     *     @type array<\Google\Cloud\Bigtable\V2\ReadChangeStreamResponse\MutationChunk>|\Google\Protobuf\Internal\RepeatedField $chunks
     *           The mutations associated with this change to the partition.
     *           May contain complete mutations or chunks of a multi-message chunked
     *           `DataChange` record.
     *     @type bool $done
     *           When true, indicates that the entire `DataChange` has been read
     *           and the client can safely process the message.
     *     @type string $token
     *           An encoded position for this stream's partition to restart reading from.
     *           This token is for the StreamPartition from the request.
     *     @type \Google\Protobuf\Timestamp $estimated_low_watermark
     *           An estimate of the commit timestamp that is usually lower than or equal
     *           to any timestamp for a record that will be delivered in the future on the
     *           stream. It is possible that, under particular circumstances that a future
     *           record has a timestamp is is lower than a previously seen timestamp. For
     *           an example usage see
     *           https://beam.apache.org/documentation/basics/#watermarks
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Bigtable\V2\Bigtable::initOnce();
        parent::__construct($data);
    }

    /**
     * The type of the mutation.
     *
     * Generated from protobuf field <code>.google.bigtable.v2.ReadChangeStreamResponse.DataChange.Type type = 1;</code>
     * @return int
     */
    public function getType()
    {
        return $this->type;
    }

    /**
     * The type of the mutation.
     *
     * Generated from protobuf field <code>.google.bigtable.v2.ReadChangeStreamResponse.DataChange.Type type = 1;</code>
     * @param int $var
     * @return $this
     */
    public function setType($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Bigtable\V2\ReadChangeStreamResponse\DataChange\Type::class);
        $this->type = $var;

        return $this;
    }

    /**
     * The cluster where the mutation was applied.
     * Not set when `type` is `GARBAGE_COLLECTION`.
     *
     * Generated from protobuf field <code>string source_cluster_id = 2;</code>
     * @return string
     */
    public function getSourceClusterId()
    {
        return $this->source_cluster_id;
    }

    /**
     * The cluster where the mutation was applied.
     * Not set when `type` is `GARBAGE_COLLECTION`.
     *
     * Generated from protobuf field <code>string source_cluster_id = 2;</code>
     * @param string $var
     * @return $this
     */
    public function setSourceClusterId($var)
    {
        GPBUtil::checkString($var, True);
        $this->source_cluster_id = $var;

        return $this;
    }

    /**
     * The row key for all mutations that are part of this `DataChange`.
     * If the `DataChange` is chunked across multiple messages, then this field
     * will only be set for the first message.
     *
     * Generated from protobuf field <code>bytes row_key = 3;</code>
     * @return string
     */
    public function getRowKey()
    {
        return $this->row_key;
    }

    /**
     * The row key for all mutations that are part of this `DataChange`.
     * If the `DataChange` is chunked across multiple messages, then this field
     * will only be set for the first message.
     *
     * Generated from protobuf field <code>bytes row_key = 3;</code>
     * @param string $var
     * @return $this
     */
    public function setRowKey($var)
    {
        GPBUtil::checkString($var, False);
        $this->row_key = $var;

        return $this;
    }

    /**
     * The timestamp at which the mutation was applied on the Bigtable server.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp commit_timestamp = 4;</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getCommitTimestamp()
    {
        return $this->commit_timestamp;
    }

    public function hasCommitTimestamp()
    {
        return isset($this->commit_timestamp);
    }

    public function clearCommitTimestamp()
    {
        unset($this->commit_timestamp);
    }

    /**
     * The timestamp at which the mutation was applied on the Bigtable server.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp commit_timestamp = 4;</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setCommitTimestamp($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->commit_timestamp = $var;

        return $this;
    }

    /**
     * A value that lets stream consumers reconstruct Bigtable's
     * conflict resolution semantics.
     * https://cloud.google.com/bigtable/docs/writes#conflict-resolution
     * In the event that the same row key, column family, column qualifier,
     * timestamp are modified on different clusters at the same
     * `commit_timestamp`, the mutation with the larger `tiebreaker` will be the
     * one chosen for the eventually consistent state of the system.
     *
     * Generated from protobuf field <code>int32 tiebreaker = 5;</code>
     * @return int
     */
    public function getTiebreaker()
    {
        return $this->tiebreaker;
    }

    /**
     * A value that lets stream consumers reconstruct Bigtable's
     * conflict resolution semantics.
     * https://cloud.google.com/bigtable/docs/writes#conflict-resolution
     * In the event that the same row key, column family, column qualifier,
     * timestamp are modified on different clusters at the same
     * `commit_timestamp`, the mutation with the larger `tiebreaker` will be the
     * one chosen for the eventually consistent state of the system.
     *
     * Generated from protobuf field <code>int32 tiebreaker = 5;</code>
     * @param int $var
     * @return $this
     */
    public function setTiebreaker($var)
    {
        GPBUtil::checkInt32($var);
        $this->tiebreaker = $var;

        return $this;
    }

    /**
     * The mutations associated with this change to the partition.
     * May contain complete mutations or chunks of a multi-message chunked
     * `DataChange` record.
     *
     * Generated from protobuf field <code>repeated .google.bigtable.v2.ReadChangeStreamResponse.MutationChunk chunks = 6;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getChunks()
    {
        return $this->chunks;
    }

    /**
     * The mutations associated with this change to the partition.
     * May contain complete mutations or chunks of a multi-message chunked
     * `DataChange` record.
     *
     * Generated from protobuf field <code>repeated .google.bigtable.v2.ReadChangeStreamResponse.MutationChunk chunks = 6;</code>
     * @param array<\Google\Cloud\Bigtable\V2\ReadChangeStreamResponse\MutationChunk>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setChunks($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Bigtable\V2\ReadChangeStreamResponse\MutationChunk::class);
        $this->chunks = $arr;

        return $this;
    }

    /**
     * When true, indicates that the entire `DataChange` has been read
     * and the client can safely process the message.
     *
     * Generated from protobuf field <code>bool done = 8;</code>
     * @return bool
     */
    public function getDone()
    {
        return $this->done;
    }

    /**
     * When true, indicates that the entire `DataChange` has been read
     * and the client can safely process the message.
     *
     * Generated from protobuf field <code>bool done = 8;</code>
     * @param bool $var
     * @return $this
     */
    public function setDone($var)
    {
        GPBUtil::checkBool($var);
        $this->done = $var;

        return $this;
    }

    /**
     * An encoded position for this stream's partition to restart reading from.
     * This token is for the StreamPartition from the request.
     *
     * Generated from protobuf field <code>string token = 9;</code>
     * @return string
     */
    public function getToken()
    {
        return $this->token;
    }

    /**
     * An encoded position for this stream's partition to restart reading from.
     * This token is for the StreamPartition from the request.
     *
     * Generated from protobuf field <code>string token = 9;</code>
     * @param string $var
     * @return $this
     */
    public function setToken($var)
    {
        GPBUtil::checkString($var, True);
        $this->token = $var;

        return $this;
    }

    /**
     * An estimate of the commit timestamp that is usually lower than or equal
     * to any timestamp for a record that will be delivered in the future on the
     * stream. It is possible that, under particular circumstances that a future
     * record has a timestamp is is lower than a previously seen timestamp. For
     * an example usage see
     * https://beam.apache.org/documentation/basics/#watermarks
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp estimated_low_watermark = 10;</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getEstimatedLowWatermark()
    {
        return $this->estimated_low_watermark;
    }

    public function hasEstimatedLowWatermark()
    {
        return isset($this->estimated_low_watermark);
    }

    public function clearEstimatedLowWatermark()
    {
        unset($this->estimated_low_watermark);
    }

    /**
     * An estimate of the commit timestamp that is usually lower than or equal
     * to any timestamp for a record that will be delivered in the future on the
     * stream. It is possible that, under particular circumstances that a future
     * record has a timestamp is is lower than a previously seen timestamp. For
     * an example usage see
     * https://beam.apache.org/documentation/basics/#watermarks
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp estimated_low_watermark = 10;</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setEstimatedLowWatermark($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->estimated_low_watermark = $var;

        return $this;
    }

}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(DataChange::class, \Google\Cloud\Bigtable\V2\ReadChangeStreamResponse_DataChange::class);

