<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/bigtable/v2/bigtable.proto

namespace Google\Cloud\Bigtable\V2;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Request message for Bigtable.ExecuteQuery
 *
 * Generated from protobuf message <code>google.bigtable.v2.ExecuteQueryRequest</code>
 */
class ExecuteQueryRequest extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. The unique name of the instance against which the query should be
     * executed.
     * Values are of the form `projects/<project>/instances/<instance>`
     *
     * Generated from protobuf field <code>string instance_name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     */
    protected $instance_name = '';
    /**
     * Optional. This value specifies routing for replication. If not specified,
     * the `default` application profile will be used.
     *
     * Generated from protobuf field <code>string app_profile_id = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $app_profile_id = '';
    /**
     * Required. The query string.
     *
     * Generated from protobuf field <code>string query = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $query = '';
    /**
     * Optional. If this request is resuming a previously interrupted query
     * execution, `resume_token` should be copied from the last
     * PartialResultSet yielded before the interruption. Doing this
     * enables the query execution to resume where the last one left
     * off.
     * The rest of the request parameters must exactly match the
     * request that yielded this token. Otherwise the request will fail.
     *
     * Generated from protobuf field <code>bytes resume_token = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $resume_token = '';
    /**
     * Required. params contains string type keys and Bigtable type values that
     * bind to placeholders in the query string. In query string, a parameter
     * placeholder consists of the
     * `&#64;` character followed by the parameter name (for example, `&#64;firstName`) in
     * the query string.
     * For example, if
     * `params["firstName"] = bytes_value: "foo" type {bytes_type {}}`
     *  then `&#64;firstName` will be replaced with googlesql bytes value "foo" in the
     *  query string during query evaluation.
     * In case of Value.kind is not set, it will be set to corresponding null
     * value in googlesql.
     *  `params["firstName"] =  type {string_type {}}`
     *  then `&#64;firstName` will be replaced with googlesql null string.
     * Value.type should always be set and no inference of type will be made from
     * Value.kind. If Value.type is not set, we will return INVALID_ARGUMENT
     * error.
     *
     * Generated from protobuf field <code>map<string, .google.bigtable.v2.Value> params = 7 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    private $params;
    protected $data_format;

    /**
     * @param string $instanceName Required. The unique name of the instance against which the query should be
     *                             executed.
     *                             Values are of the form `projects/<project>/instances/<instance>`
     *                             Please see {@see BigtableClient::instanceName()} for help formatting this field.
     * @param string $query        Required. The query string.
     *
     * @return \Google\Cloud\Bigtable\V2\ExecuteQueryRequest
     *
     * @experimental
     */
    public static function build(string $instanceName, string $query): self
    {
        return (new self())
            ->setInstanceName($instanceName)
            ->setQuery($query);
    }

    /**
     * @param string $instanceName Required. The unique name of the instance against which the query should be
     *                             executed.
     *                             Values are of the form `projects/<project>/instances/<instance>`
     *                             Please see {@see BigtableClient::instanceName()} for help formatting this field.
     * @param string $query        Required. The query string.
     * @param string $appProfileId Optional. This value specifies routing for replication. If not specified,
     *                             the `default` application profile will be used.
     *
     * @return \Google\Cloud\Bigtable\V2\ExecuteQueryRequest
     *
     * @experimental
     */
    public static function buildFromInstanceNameQueryAppProfileId(string $instanceName, string $query, string $appProfileId): self
    {
        return (new self())
            ->setInstanceName($instanceName)
            ->setQuery($query)
            ->setAppProfileId($appProfileId);
    }

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $instance_name
     *           Required. The unique name of the instance against which the query should be
     *           executed.
     *           Values are of the form `projects/<project>/instances/<instance>`
     *     @type string $app_profile_id
     *           Optional. This value specifies routing for replication. If not specified,
     *           the `default` application profile will be used.
     *     @type string $query
     *           Required. The query string.
     *     @type \Google\Cloud\Bigtable\V2\ProtoFormat $proto_format
     *           Protocol buffer format as described by ProtoSchema and ProtoRows
     *           messages.
     *     @type string $resume_token
     *           Optional. If this request is resuming a previously interrupted query
     *           execution, `resume_token` should be copied from the last
     *           PartialResultSet yielded before the interruption. Doing this
     *           enables the query execution to resume where the last one left
     *           off.
     *           The rest of the request parameters must exactly match the
     *           request that yielded this token. Otherwise the request will fail.
     *     @type array|\Google\Protobuf\Internal\MapField $params
     *           Required. params contains string type keys and Bigtable type values that
     *           bind to placeholders in the query string. In query string, a parameter
     *           placeholder consists of the
     *           `&#64;` character followed by the parameter name (for example, `&#64;firstName`) in
     *           the query string.
     *           For example, if
     *           `params["firstName"] = bytes_value: "foo" type {bytes_type {}}`
     *            then `&#64;firstName` will be replaced with googlesql bytes value "foo" in the
     *            query string during query evaluation.
     *           In case of Value.kind is not set, it will be set to corresponding null
     *           value in googlesql.
     *            `params["firstName"] =  type {string_type {}}`
     *            then `&#64;firstName` will be replaced with googlesql null string.
     *           Value.type should always be set and no inference of type will be made from
     *           Value.kind. If Value.type is not set, we will return INVALID_ARGUMENT
     *           error.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Bigtable\V2\Bigtable::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. The unique name of the instance against which the query should be
     * executed.
     * Values are of the form `projects/<project>/instances/<instance>`
     *
     * Generated from protobuf field <code>string instance_name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getInstanceName()
    {
        return $this->instance_name;
    }

    /**
     * Required. The unique name of the instance against which the query should be
     * executed.
     * Values are of the form `projects/<project>/instances/<instance>`
     *
     * Generated from protobuf field <code>string instance_name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setInstanceName($var)
    {
        GPBUtil::checkString($var, True);
        $this->instance_name = $var;

        return $this;
    }

    /**
     * Optional. This value specifies routing for replication. If not specified,
     * the `default` application profile will be used.
     *
     * Generated from protobuf field <code>string app_profile_id = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getAppProfileId()
    {
        return $this->app_profile_id;
    }

    /**
     * Optional. This value specifies routing for replication. If not specified,
     * the `default` application profile will be used.
     *
     * Generated from protobuf field <code>string app_profile_id = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setAppProfileId($var)
    {
        GPBUtil::checkString($var, True);
        $this->app_profile_id = $var;

        return $this;
    }

    /**
     * Required. The query string.
     *
     * Generated from protobuf field <code>string query = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getQuery()
    {
        return $this->query;
    }

    /**
     * Required. The query string.
     *
     * Generated from protobuf field <code>string query = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setQuery($var)
    {
        GPBUtil::checkString($var, True);
        $this->query = $var;

        return $this;
    }

    /**
     * Protocol buffer format as described by ProtoSchema and ProtoRows
     * messages.
     *
     * Generated from protobuf field <code>.google.bigtable.v2.ProtoFormat proto_format = 4;</code>
     * @return \Google\Cloud\Bigtable\V2\ProtoFormat|null
     */
    public function getProtoFormat()
    {
        return $this->readOneof(4);
    }

    public function hasProtoFormat()
    {
        return $this->hasOneof(4);
    }

    /**
     * Protocol buffer format as described by ProtoSchema and ProtoRows
     * messages.
     *
     * Generated from protobuf field <code>.google.bigtable.v2.ProtoFormat proto_format = 4;</code>
     * @param \Google\Cloud\Bigtable\V2\ProtoFormat $var
     * @return $this
     */
    public function setProtoFormat($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Bigtable\V2\ProtoFormat::class);
        $this->writeOneof(4, $var);

        return $this;
    }

    /**
     * Optional. If this request is resuming a previously interrupted query
     * execution, `resume_token` should be copied from the last
     * PartialResultSet yielded before the interruption. Doing this
     * enables the query execution to resume where the last one left
     * off.
     * The rest of the request parameters must exactly match the
     * request that yielded this token. Otherwise the request will fail.
     *
     * Generated from protobuf field <code>bytes resume_token = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getResumeToken()
    {
        return $this->resume_token;
    }

    /**
     * Optional. If this request is resuming a previously interrupted query
     * execution, `resume_token` should be copied from the last
     * PartialResultSet yielded before the interruption. Doing this
     * enables the query execution to resume where the last one left
     * off.
     * The rest of the request parameters must exactly match the
     * request that yielded this token. Otherwise the request will fail.
     *
     * Generated from protobuf field <code>bytes resume_token = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setResumeToken($var)
    {
        GPBUtil::checkString($var, False);
        $this->resume_token = $var;

        return $this;
    }

    /**
     * Required. params contains string type keys and Bigtable type values that
     * bind to placeholders in the query string. In query string, a parameter
     * placeholder consists of the
     * `&#64;` character followed by the parameter name (for example, `&#64;firstName`) in
     * the query string.
     * For example, if
     * `params["firstName"] = bytes_value: "foo" type {bytes_type {}}`
     *  then `&#64;firstName` will be replaced with googlesql bytes value "foo" in the
     *  query string during query evaluation.
     * In case of Value.kind is not set, it will be set to corresponding null
     * value in googlesql.
     *  `params["firstName"] =  type {string_type {}}`
     *  then `&#64;firstName` will be replaced with googlesql null string.
     * Value.type should always be set and no inference of type will be made from
     * Value.kind. If Value.type is not set, we will return INVALID_ARGUMENT
     * error.
     *
     * Generated from protobuf field <code>map<string, .google.bigtable.v2.Value> params = 7 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getParams()
    {
        return $this->params;
    }

    /**
     * Required. params contains string type keys and Bigtable type values that
     * bind to placeholders in the query string. In query string, a parameter
     * placeholder consists of the
     * `&#64;` character followed by the parameter name (for example, `&#64;firstName`) in
     * the query string.
     * For example, if
     * `params["firstName"] = bytes_value: "foo" type {bytes_type {}}`
     *  then `&#64;firstName` will be replaced with googlesql bytes value "foo" in the
     *  query string during query evaluation.
     * In case of Value.kind is not set, it will be set to corresponding null
     * value in googlesql.
     *  `params["firstName"] =  type {string_type {}}`
     *  then `&#64;firstName` will be replaced with googlesql null string.
     * Value.type should always be set and no inference of type will be made from
     * Value.kind. If Value.type is not set, we will return INVALID_ARGUMENT
     * error.
     *
     * Generated from protobuf field <code>map<string, .google.bigtable.v2.Value> params = 7 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setParams($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Bigtable\V2\Value::class);
        $this->params = $arr;

        return $this;
    }

    /**
     * @return string
     */
    public function getDataFormat()
    {
        return $this->whichOneof("data_format");
    }

}

