<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/baremetalsolution/v2/provisioning.proto

namespace Google\Cloud\BareMetalSolution\V2;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Configuration parameters for a new instance.
 *
 * Generated from protobuf message <code>google.cloud.baremetalsolution.v2.InstanceConfig</code>
 */
class InstanceConfig extends \Google\Protobuf\Internal\Message
{
    /**
     * Output only. The name of the instance config.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $name = '';
    /**
     * A transient unique identifier to idenfity an instance within an
     * ProvisioningConfig request.
     *
     * Generated from protobuf field <code>string id = 2;</code>
     */
    protected $id = '';
    /**
     * Instance type.
     * [Available
     * types](https://cloud.google.com/bare-metal/docs/bms-planning#server_configurations)
     *
     * Generated from protobuf field <code>string instance_type = 3;</code>
     */
    protected $instance_type = '';
    /**
     * Whether the instance should be provisioned with Hyperthreading enabled.
     *
     * Generated from protobuf field <code>bool hyperthreading = 4;</code>
     */
    protected $hyperthreading = false;
    /**
     * OS image to initialize the instance.
     * [Available
     * images](https://cloud.google.com/bare-metal/docs/bms-planning#server_configurations)
     *
     * Generated from protobuf field <code>string os_image = 5;</code>
     */
    protected $os_image = '';
    /**
     * Client network address. Filled if InstanceConfig.multivlan_config is false.
     *
     * Generated from protobuf field <code>.google.cloud.baremetalsolution.v2.InstanceConfig.NetworkAddress client_network = 6 [deprecated = true];</code>
     * @deprecated
     */
    protected $client_network = null;
    /**
     * Private network address, if any. Filled if InstanceConfig.multivlan_config
     * is false.
     *
     * Generated from protobuf field <code>.google.cloud.baremetalsolution.v2.InstanceConfig.NetworkAddress private_network = 7 [deprecated = true];</code>
     * @deprecated
     */
    protected $private_network = null;
    /**
     * User note field, it can be used by customers to add additional information
     * for the BMS Ops team .
     *
     * Generated from protobuf field <code>string user_note = 8;</code>
     */
    protected $user_note = '';
    /**
     * If true networks can be from different projects of the same vendor account.
     *
     * Generated from protobuf field <code>bool account_networks_enabled = 9;</code>
     */
    protected $account_networks_enabled = false;
    /**
     * The type of network configuration on the instance.
     *
     * Generated from protobuf field <code>.google.cloud.baremetalsolution.v2.InstanceConfig.NetworkConfig network_config = 10;</code>
     */
    protected $network_config = 0;
    /**
     * Server network template name. Filled if InstanceConfig.multivlan_config is
     * true.
     *
     * Generated from protobuf field <code>string network_template = 11;</code>
     */
    protected $network_template = '';
    /**
     * List of logical interfaces for the instance. The number of logical
     * interfaces will be the same as number of hardware bond/nic on the chosen
     * network template. Filled if InstanceConfig.multivlan_config is true.
     *
     * Generated from protobuf field <code>repeated .google.cloud.baremetalsolution.v2.LogicalInterface logical_interfaces = 12;</code>
     */
    private $logical_interfaces;
    /**
     * List of names of ssh keys used to provision the instance.
     *
     * Generated from protobuf field <code>repeated string ssh_key_names = 13;</code>
     */
    private $ssh_key_names;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           Output only. The name of the instance config.
     *     @type string $id
     *           A transient unique identifier to idenfity an instance within an
     *           ProvisioningConfig request.
     *     @type string $instance_type
     *           Instance type.
     *           [Available
     *           types](https://cloud.google.com/bare-metal/docs/bms-planning#server_configurations)
     *     @type bool $hyperthreading
     *           Whether the instance should be provisioned with Hyperthreading enabled.
     *     @type string $os_image
     *           OS image to initialize the instance.
     *           [Available
     *           images](https://cloud.google.com/bare-metal/docs/bms-planning#server_configurations)
     *     @type \Google\Cloud\BareMetalSolution\V2\InstanceConfig\NetworkAddress $client_network
     *           Client network address. Filled if InstanceConfig.multivlan_config is false.
     *     @type \Google\Cloud\BareMetalSolution\V2\InstanceConfig\NetworkAddress $private_network
     *           Private network address, if any. Filled if InstanceConfig.multivlan_config
     *           is false.
     *     @type string $user_note
     *           User note field, it can be used by customers to add additional information
     *           for the BMS Ops team .
     *     @type bool $account_networks_enabled
     *           If true networks can be from different projects of the same vendor account.
     *     @type int $network_config
     *           The type of network configuration on the instance.
     *     @type string $network_template
     *           Server network template name. Filled if InstanceConfig.multivlan_config is
     *           true.
     *     @type array<\Google\Cloud\BareMetalSolution\V2\LogicalInterface>|\Google\Protobuf\Internal\RepeatedField $logical_interfaces
     *           List of logical interfaces for the instance. The number of logical
     *           interfaces will be the same as number of hardware bond/nic on the chosen
     *           network template. Filled if InstanceConfig.multivlan_config is true.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $ssh_key_names
     *           List of names of ssh keys used to provision the instance.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Baremetalsolution\V2\Provisioning::initOnce();
        parent::__construct($data);
    }

    /**
     * Output only. The name of the instance config.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Output only. The name of the instance config.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * A transient unique identifier to idenfity an instance within an
     * ProvisioningConfig request.
     *
     * Generated from protobuf field <code>string id = 2;</code>
     * @return string
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * A transient unique identifier to idenfity an instance within an
     * ProvisioningConfig request.
     *
     * Generated from protobuf field <code>string id = 2;</code>
     * @param string $var
     * @return $this
     */
    public function setId($var)
    {
        GPBUtil::checkString($var, True);
        $this->id = $var;

        return $this;
    }

    /**
     * Instance type.
     * [Available
     * types](https://cloud.google.com/bare-metal/docs/bms-planning#server_configurations)
     *
     * Generated from protobuf field <code>string instance_type = 3;</code>
     * @return string
     */
    public function getInstanceType()
    {
        return $this->instance_type;
    }

    /**
     * Instance type.
     * [Available
     * types](https://cloud.google.com/bare-metal/docs/bms-planning#server_configurations)
     *
     * Generated from protobuf field <code>string instance_type = 3;</code>
     * @param string $var
     * @return $this
     */
    public function setInstanceType($var)
    {
        GPBUtil::checkString($var, True);
        $this->instance_type = $var;

        return $this;
    }

    /**
     * Whether the instance should be provisioned with Hyperthreading enabled.
     *
     * Generated from protobuf field <code>bool hyperthreading = 4;</code>
     * @return bool
     */
    public function getHyperthreading()
    {
        return $this->hyperthreading;
    }

    /**
     * Whether the instance should be provisioned with Hyperthreading enabled.
     *
     * Generated from protobuf field <code>bool hyperthreading = 4;</code>
     * @param bool $var
     * @return $this
     */
    public function setHyperthreading($var)
    {
        GPBUtil::checkBool($var);
        $this->hyperthreading = $var;

        return $this;
    }

    /**
     * OS image to initialize the instance.
     * [Available
     * images](https://cloud.google.com/bare-metal/docs/bms-planning#server_configurations)
     *
     * Generated from protobuf field <code>string os_image = 5;</code>
     * @return string
     */
    public function getOsImage()
    {
        return $this->os_image;
    }

    /**
     * OS image to initialize the instance.
     * [Available
     * images](https://cloud.google.com/bare-metal/docs/bms-planning#server_configurations)
     *
     * Generated from protobuf field <code>string os_image = 5;</code>
     * @param string $var
     * @return $this
     */
    public function setOsImage($var)
    {
        GPBUtil::checkString($var, True);
        $this->os_image = $var;

        return $this;
    }

    /**
     * Client network address. Filled if InstanceConfig.multivlan_config is false.
     *
     * Generated from protobuf field <code>.google.cloud.baremetalsolution.v2.InstanceConfig.NetworkAddress client_network = 6 [deprecated = true];</code>
     * @return \Google\Cloud\BareMetalSolution\V2\InstanceConfig\NetworkAddress|null
     * @deprecated
     */
    public function getClientNetwork()
    {
        @trigger_error('client_network is deprecated.', E_USER_DEPRECATED);
        return $this->client_network;
    }

    public function hasClientNetwork()
    {
        @trigger_error('client_network is deprecated.', E_USER_DEPRECATED);
        return isset($this->client_network);
    }

    public function clearClientNetwork()
    {
        @trigger_error('client_network is deprecated.', E_USER_DEPRECATED);
        unset($this->client_network);
    }

    /**
     * Client network address. Filled if InstanceConfig.multivlan_config is false.
     *
     * Generated from protobuf field <code>.google.cloud.baremetalsolution.v2.InstanceConfig.NetworkAddress client_network = 6 [deprecated = true];</code>
     * @param \Google\Cloud\BareMetalSolution\V2\InstanceConfig\NetworkAddress $var
     * @return $this
     * @deprecated
     */
    public function setClientNetwork($var)
    {
        @trigger_error('client_network is deprecated.', E_USER_DEPRECATED);
        GPBUtil::checkMessage($var, \Google\Cloud\BareMetalSolution\V2\InstanceConfig\NetworkAddress::class);
        $this->client_network = $var;

        return $this;
    }

    /**
     * Private network address, if any. Filled if InstanceConfig.multivlan_config
     * is false.
     *
     * Generated from protobuf field <code>.google.cloud.baremetalsolution.v2.InstanceConfig.NetworkAddress private_network = 7 [deprecated = true];</code>
     * @return \Google\Cloud\BareMetalSolution\V2\InstanceConfig\NetworkAddress|null
     * @deprecated
     */
    public function getPrivateNetwork()
    {
        @trigger_error('private_network is deprecated.', E_USER_DEPRECATED);
        return $this->private_network;
    }

    public function hasPrivateNetwork()
    {
        @trigger_error('private_network is deprecated.', E_USER_DEPRECATED);
        return isset($this->private_network);
    }

    public function clearPrivateNetwork()
    {
        @trigger_error('private_network is deprecated.', E_USER_DEPRECATED);
        unset($this->private_network);
    }

    /**
     * Private network address, if any. Filled if InstanceConfig.multivlan_config
     * is false.
     *
     * Generated from protobuf field <code>.google.cloud.baremetalsolution.v2.InstanceConfig.NetworkAddress private_network = 7 [deprecated = true];</code>
     * @param \Google\Cloud\BareMetalSolution\V2\InstanceConfig\NetworkAddress $var
     * @return $this
     * @deprecated
     */
    public function setPrivateNetwork($var)
    {
        @trigger_error('private_network is deprecated.', E_USER_DEPRECATED);
        GPBUtil::checkMessage($var, \Google\Cloud\BareMetalSolution\V2\InstanceConfig\NetworkAddress::class);
        $this->private_network = $var;

        return $this;
    }

    /**
     * User note field, it can be used by customers to add additional information
     * for the BMS Ops team .
     *
     * Generated from protobuf field <code>string user_note = 8;</code>
     * @return string
     */
    public function getUserNote()
    {
        return $this->user_note;
    }

    /**
     * User note field, it can be used by customers to add additional information
     * for the BMS Ops team .
     *
     * Generated from protobuf field <code>string user_note = 8;</code>
     * @param string $var
     * @return $this
     */
    public function setUserNote($var)
    {
        GPBUtil::checkString($var, True);
        $this->user_note = $var;

        return $this;
    }

    /**
     * If true networks can be from different projects of the same vendor account.
     *
     * Generated from protobuf field <code>bool account_networks_enabled = 9;</code>
     * @return bool
     */
    public function getAccountNetworksEnabled()
    {
        return $this->account_networks_enabled;
    }

    /**
     * If true networks can be from different projects of the same vendor account.
     *
     * Generated from protobuf field <code>bool account_networks_enabled = 9;</code>
     * @param bool $var
     * @return $this
     */
    public function setAccountNetworksEnabled($var)
    {
        GPBUtil::checkBool($var);
        $this->account_networks_enabled = $var;

        return $this;
    }

    /**
     * The type of network configuration on the instance.
     *
     * Generated from protobuf field <code>.google.cloud.baremetalsolution.v2.InstanceConfig.NetworkConfig network_config = 10;</code>
     * @return int
     */
    public function getNetworkConfig()
    {
        return $this->network_config;
    }

    /**
     * The type of network configuration on the instance.
     *
     * Generated from protobuf field <code>.google.cloud.baremetalsolution.v2.InstanceConfig.NetworkConfig network_config = 10;</code>
     * @param int $var
     * @return $this
     */
    public function setNetworkConfig($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\BareMetalSolution\V2\InstanceConfig\NetworkConfig::class);
        $this->network_config = $var;

        return $this;
    }

    /**
     * Server network template name. Filled if InstanceConfig.multivlan_config is
     * true.
     *
     * Generated from protobuf field <code>string network_template = 11;</code>
     * @return string
     */
    public function getNetworkTemplate()
    {
        return $this->network_template;
    }

    /**
     * Server network template name. Filled if InstanceConfig.multivlan_config is
     * true.
     *
     * Generated from protobuf field <code>string network_template = 11;</code>
     * @param string $var
     * @return $this
     */
    public function setNetworkTemplate($var)
    {
        GPBUtil::checkString($var, True);
        $this->network_template = $var;

        return $this;
    }

    /**
     * List of logical interfaces for the instance. The number of logical
     * interfaces will be the same as number of hardware bond/nic on the chosen
     * network template. Filled if InstanceConfig.multivlan_config is true.
     *
     * Generated from protobuf field <code>repeated .google.cloud.baremetalsolution.v2.LogicalInterface logical_interfaces = 12;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getLogicalInterfaces()
    {
        return $this->logical_interfaces;
    }

    /**
     * List of logical interfaces for the instance. The number of logical
     * interfaces will be the same as number of hardware bond/nic on the chosen
     * network template. Filled if InstanceConfig.multivlan_config is true.
     *
     * Generated from protobuf field <code>repeated .google.cloud.baremetalsolution.v2.LogicalInterface logical_interfaces = 12;</code>
     * @param array<\Google\Cloud\BareMetalSolution\V2\LogicalInterface>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setLogicalInterfaces($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\BareMetalSolution\V2\LogicalInterface::class);
        $this->logical_interfaces = $arr;

        return $this;
    }

    /**
     * List of names of ssh keys used to provision the instance.
     *
     * Generated from protobuf field <code>repeated string ssh_key_names = 13;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getSshKeyNames()
    {
        return $this->ssh_key_names;
    }

    /**
     * List of names of ssh keys used to provision the instance.
     *
     * Generated from protobuf field <code>repeated string ssh_key_names = 13;</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setSshKeyNames($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->ssh_key_names = $arr;

        return $this;
    }

}

