<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/backupdr/v1/backupplan.proto

namespace Google\Cloud\BackupDR\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * `StandardSchedule` defines a schedule that run within the confines of a
 * defined window of days. We can define recurrence type for schedule as
 * HOURLY, DAILY, WEEKLY, MONTHLY or YEARLY.
 *
 * Generated from protobuf message <code>google.cloud.backupdr.v1.StandardSchedule</code>
 */
class StandardSchedule extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. Specifies the `RecurrenceType` for the schedule.
     *
     * Generated from protobuf field <code>.google.cloud.backupdr.v1.StandardSchedule.RecurrenceType recurrence_type = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $recurrence_type = 0;
    /**
     * Optional. Specifies frequency for hourly backups. A hourly frequency of 2
     * means jobs will run every 2 hours from start time till end time defined.
     * This is required for `recurrence_type`, `HOURLY` and is not applicable
     * otherwise. A validation error will occur if a value is supplied and
     * `recurrence_type` is not `HOURLY`.
     * Value of hourly frequency should be between 6 and 23.
     * Reason for limit : We found that there is bandwidth limitation of 3GB/S for
     * GMI while taking a backup and 5GB/S while doing a restore. Given the amount
     * of parallel backups and restore we are targeting, this will potentially
     * take the backup time to mins and hours (in worst case scenario).
     *
     * Generated from protobuf field <code>int32 hourly_frequency = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $hourly_frequency = 0;
    /**
     * Optional. Specifies days of week like, MONDAY or TUESDAY, on which jobs
     * will run.
     * This is required for `recurrence_type`, `WEEKLY` and is not applicable
     * otherwise. A validation error will occur if a value is supplied and
     * `recurrence_type` is not `WEEKLY`.
     *
     * Generated from protobuf field <code>repeated .google.type.DayOfWeek days_of_week = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $days_of_week;
    /**
     * Optional. Specifies days of months like 1, 5, or 14 on which jobs will run.
     * Values for `days_of_month` are only applicable for `recurrence_type`,
     * `MONTHLY` and `YEARLY`. A validation error will occur if other values are
     * supplied.
     *
     * Generated from protobuf field <code>repeated int32 days_of_month = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $days_of_month;
    /**
     * Optional. Specifies a week day of the month like, FIRST SUNDAY or LAST
     * MONDAY, on which jobs will run. This will be specified by two fields in
     * `WeekDayOfMonth`, one for the day, e.g. `MONDAY`, and one for the week,
     * e.g. `LAST`.
     * This field is only applicable for `recurrence_type`, `MONTHLY` and
     * `YEARLY`. A validation error will occur if other values are supplied.
     *
     * Generated from protobuf field <code>.google.cloud.backupdr.v1.WeekDayOfMonth week_day_of_month = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $week_day_of_month = null;
    /**
     * Optional. Specifies the months of year, like `FEBRUARY` and/or `MAY`, on
     * which jobs will run.
     * This field is only applicable when `recurrence_type` is `YEARLY`. A
     * validation error will occur if other values are supplied.
     *
     * Generated from protobuf field <code>repeated .google.type.Month months = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $months;
    /**
     * Required. A BackupWindow defines the window of day during which backup jobs
     * will run. Jobs are queued at the beginning of the window and will be marked
     * as `NOT_RUN` if they do not start by the end of the window.
     * Note: running jobs will not be cancelled at the end of the window.
     *
     * Generated from protobuf field <code>.google.cloud.backupdr.v1.BackupWindow backup_window = 7 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $backup_window = null;
    /**
     * Required. The time zone to be used when interpreting the schedule.
     * The value of this field must be a time zone name from the IANA tz database.
     * See https://en.wikipedia.org/wiki/List_of_tz_database_time_zones for the
     * list of valid timezone names. For e.g., Europe/Paris.
     *
     * Generated from protobuf field <code>string time_zone = 8 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $time_zone = '';

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type int $recurrence_type
     *           Required. Specifies the `RecurrenceType` for the schedule.
     *     @type int $hourly_frequency
     *           Optional. Specifies frequency for hourly backups. A hourly frequency of 2
     *           means jobs will run every 2 hours from start time till end time defined.
     *           This is required for `recurrence_type`, `HOURLY` and is not applicable
     *           otherwise. A validation error will occur if a value is supplied and
     *           `recurrence_type` is not `HOURLY`.
     *           Value of hourly frequency should be between 6 and 23.
     *           Reason for limit : We found that there is bandwidth limitation of 3GB/S for
     *           GMI while taking a backup and 5GB/S while doing a restore. Given the amount
     *           of parallel backups and restore we are targeting, this will potentially
     *           take the backup time to mins and hours (in worst case scenario).
     *     @type array<int>|\Google\Protobuf\Internal\RepeatedField $days_of_week
     *           Optional. Specifies days of week like, MONDAY or TUESDAY, on which jobs
     *           will run.
     *           This is required for `recurrence_type`, `WEEKLY` and is not applicable
     *           otherwise. A validation error will occur if a value is supplied and
     *           `recurrence_type` is not `WEEKLY`.
     *     @type array<int>|\Google\Protobuf\Internal\RepeatedField $days_of_month
     *           Optional. Specifies days of months like 1, 5, or 14 on which jobs will run.
     *           Values for `days_of_month` are only applicable for `recurrence_type`,
     *           `MONTHLY` and `YEARLY`. A validation error will occur if other values are
     *           supplied.
     *     @type \Google\Cloud\BackupDR\V1\WeekDayOfMonth $week_day_of_month
     *           Optional. Specifies a week day of the month like, FIRST SUNDAY or LAST
     *           MONDAY, on which jobs will run. This will be specified by two fields in
     *           `WeekDayOfMonth`, one for the day, e.g. `MONDAY`, and one for the week,
     *           e.g. `LAST`.
     *           This field is only applicable for `recurrence_type`, `MONTHLY` and
     *           `YEARLY`. A validation error will occur if other values are supplied.
     *     @type array<int>|\Google\Protobuf\Internal\RepeatedField $months
     *           Optional. Specifies the months of year, like `FEBRUARY` and/or `MAY`, on
     *           which jobs will run.
     *           This field is only applicable when `recurrence_type` is `YEARLY`. A
     *           validation error will occur if other values are supplied.
     *     @type \Google\Cloud\BackupDR\V1\BackupWindow $backup_window
     *           Required. A BackupWindow defines the window of day during which backup jobs
     *           will run. Jobs are queued at the beginning of the window and will be marked
     *           as `NOT_RUN` if they do not start by the end of the window.
     *           Note: running jobs will not be cancelled at the end of the window.
     *     @type string $time_zone
     *           Required. The time zone to be used when interpreting the schedule.
     *           The value of this field must be a time zone name from the IANA tz database.
     *           See https://en.wikipedia.org/wiki/List_of_tz_database_time_zones for the
     *           list of valid timezone names. For e.g., Europe/Paris.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Backupdr\V1\Backupplan::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. Specifies the `RecurrenceType` for the schedule.
     *
     * Generated from protobuf field <code>.google.cloud.backupdr.v1.StandardSchedule.RecurrenceType recurrence_type = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return int
     */
    public function getRecurrenceType()
    {
        return $this->recurrence_type;
    }

    /**
     * Required. Specifies the `RecurrenceType` for the schedule.
     *
     * Generated from protobuf field <code>.google.cloud.backupdr.v1.StandardSchedule.RecurrenceType recurrence_type = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param int $var
     * @return $this
     */
    public function setRecurrenceType($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\BackupDR\V1\StandardSchedule\RecurrenceType::class);
        $this->recurrence_type = $var;

        return $this;
    }

    /**
     * Optional. Specifies frequency for hourly backups. A hourly frequency of 2
     * means jobs will run every 2 hours from start time till end time defined.
     * This is required for `recurrence_type`, `HOURLY` and is not applicable
     * otherwise. A validation error will occur if a value is supplied and
     * `recurrence_type` is not `HOURLY`.
     * Value of hourly frequency should be between 6 and 23.
     * Reason for limit : We found that there is bandwidth limitation of 3GB/S for
     * GMI while taking a backup and 5GB/S while doing a restore. Given the amount
     * of parallel backups and restore we are targeting, this will potentially
     * take the backup time to mins and hours (in worst case scenario).
     *
     * Generated from protobuf field <code>int32 hourly_frequency = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return int
     */
    public function getHourlyFrequency()
    {
        return $this->hourly_frequency;
    }

    /**
     * Optional. Specifies frequency for hourly backups. A hourly frequency of 2
     * means jobs will run every 2 hours from start time till end time defined.
     * This is required for `recurrence_type`, `HOURLY` and is not applicable
     * otherwise. A validation error will occur if a value is supplied and
     * `recurrence_type` is not `HOURLY`.
     * Value of hourly frequency should be between 6 and 23.
     * Reason for limit : We found that there is bandwidth limitation of 3GB/S for
     * GMI while taking a backup and 5GB/S while doing a restore. Given the amount
     * of parallel backups and restore we are targeting, this will potentially
     * take the backup time to mins and hours (in worst case scenario).
     *
     * Generated from protobuf field <code>int32 hourly_frequency = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param int $var
     * @return $this
     */
    public function setHourlyFrequency($var)
    {
        GPBUtil::checkInt32($var);
        $this->hourly_frequency = $var;

        return $this;
    }

    /**
     * Optional. Specifies days of week like, MONDAY or TUESDAY, on which jobs
     * will run.
     * This is required for `recurrence_type`, `WEEKLY` and is not applicable
     * otherwise. A validation error will occur if a value is supplied and
     * `recurrence_type` is not `WEEKLY`.
     *
     * Generated from protobuf field <code>repeated .google.type.DayOfWeek days_of_week = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getDaysOfWeek()
    {
        return $this->days_of_week;
    }

    /**
     * Optional. Specifies days of week like, MONDAY or TUESDAY, on which jobs
     * will run.
     * This is required for `recurrence_type`, `WEEKLY` and is not applicable
     * otherwise. A validation error will occur if a value is supplied and
     * `recurrence_type` is not `WEEKLY`.
     *
     * Generated from protobuf field <code>repeated .google.type.DayOfWeek days_of_week = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array<int>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setDaysOfWeek($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::ENUM, \Google\Type\DayOfWeek::class);
        $this->days_of_week = $arr;

        return $this;
    }

    /**
     * Optional. Specifies days of months like 1, 5, or 14 on which jobs will run.
     * Values for `days_of_month` are only applicable for `recurrence_type`,
     * `MONTHLY` and `YEARLY`. A validation error will occur if other values are
     * supplied.
     *
     * Generated from protobuf field <code>repeated int32 days_of_month = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getDaysOfMonth()
    {
        return $this->days_of_month;
    }

    /**
     * Optional. Specifies days of months like 1, 5, or 14 on which jobs will run.
     * Values for `days_of_month` are only applicable for `recurrence_type`,
     * `MONTHLY` and `YEARLY`. A validation error will occur if other values are
     * supplied.
     *
     * Generated from protobuf field <code>repeated int32 days_of_month = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array<int>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setDaysOfMonth($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::INT32);
        $this->days_of_month = $arr;

        return $this;
    }

    /**
     * Optional. Specifies a week day of the month like, FIRST SUNDAY or LAST
     * MONDAY, on which jobs will run. This will be specified by two fields in
     * `WeekDayOfMonth`, one for the day, e.g. `MONDAY`, and one for the week,
     * e.g. `LAST`.
     * This field is only applicable for `recurrence_type`, `MONTHLY` and
     * `YEARLY`. A validation error will occur if other values are supplied.
     *
     * Generated from protobuf field <code>.google.cloud.backupdr.v1.WeekDayOfMonth week_day_of_month = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\BackupDR\V1\WeekDayOfMonth|null
     */
    public function getWeekDayOfMonth()
    {
        return $this->week_day_of_month;
    }

    public function hasWeekDayOfMonth()
    {
        return isset($this->week_day_of_month);
    }

    public function clearWeekDayOfMonth()
    {
        unset($this->week_day_of_month);
    }

    /**
     * Optional. Specifies a week day of the month like, FIRST SUNDAY or LAST
     * MONDAY, on which jobs will run. This will be specified by two fields in
     * `WeekDayOfMonth`, one for the day, e.g. `MONDAY`, and one for the week,
     * e.g. `LAST`.
     * This field is only applicable for `recurrence_type`, `MONTHLY` and
     * `YEARLY`. A validation error will occur if other values are supplied.
     *
     * Generated from protobuf field <code>.google.cloud.backupdr.v1.WeekDayOfMonth week_day_of_month = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\BackupDR\V1\WeekDayOfMonth $var
     * @return $this
     */
    public function setWeekDayOfMonth($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\BackupDR\V1\WeekDayOfMonth::class);
        $this->week_day_of_month = $var;

        return $this;
    }

    /**
     * Optional. Specifies the months of year, like `FEBRUARY` and/or `MAY`, on
     * which jobs will run.
     * This field is only applicable when `recurrence_type` is `YEARLY`. A
     * validation error will occur if other values are supplied.
     *
     * Generated from protobuf field <code>repeated .google.type.Month months = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getMonths()
    {
        return $this->months;
    }

    /**
     * Optional. Specifies the months of year, like `FEBRUARY` and/or `MAY`, on
     * which jobs will run.
     * This field is only applicable when `recurrence_type` is `YEARLY`. A
     * validation error will occur if other values are supplied.
     *
     * Generated from protobuf field <code>repeated .google.type.Month months = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array<int>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setMonths($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::ENUM, \Google\Type\Month::class);
        $this->months = $arr;

        return $this;
    }

    /**
     * Required. A BackupWindow defines the window of day during which backup jobs
     * will run. Jobs are queued at the beginning of the window and will be marked
     * as `NOT_RUN` if they do not start by the end of the window.
     * Note: running jobs will not be cancelled at the end of the window.
     *
     * Generated from protobuf field <code>.google.cloud.backupdr.v1.BackupWindow backup_window = 7 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return \Google\Cloud\BackupDR\V1\BackupWindow|null
     */
    public function getBackupWindow()
    {
        return $this->backup_window;
    }

    public function hasBackupWindow()
    {
        return isset($this->backup_window);
    }

    public function clearBackupWindow()
    {
        unset($this->backup_window);
    }

    /**
     * Required. A BackupWindow defines the window of day during which backup jobs
     * will run. Jobs are queued at the beginning of the window and will be marked
     * as `NOT_RUN` if they do not start by the end of the window.
     * Note: running jobs will not be cancelled at the end of the window.
     *
     * Generated from protobuf field <code>.google.cloud.backupdr.v1.BackupWindow backup_window = 7 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param \Google\Cloud\BackupDR\V1\BackupWindow $var
     * @return $this
     */
    public function setBackupWindow($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\BackupDR\V1\BackupWindow::class);
        $this->backup_window = $var;

        return $this;
    }

    /**
     * Required. The time zone to be used when interpreting the schedule.
     * The value of this field must be a time zone name from the IANA tz database.
     * See https://en.wikipedia.org/wiki/List_of_tz_database_time_zones for the
     * list of valid timezone names. For e.g., Europe/Paris.
     *
     * Generated from protobuf field <code>string time_zone = 8 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getTimeZone()
    {
        return $this->time_zone;
    }

    /**
     * Required. The time zone to be used when interpreting the schedule.
     * The value of this field must be a time zone name from the IANA tz database.
     * See https://en.wikipedia.org/wiki/List_of_tz_database_time_zones for the
     * list of valid timezone names. For e.g., Europe/Paris.
     *
     * Generated from protobuf field <code>string time_zone = 8 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setTimeZone($var)
    {
        GPBUtil::checkString($var, True);
        $this->time_zone = $var;

        return $this;
    }

}

