<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/devtools/artifactregistry/v1/repository.proto

namespace Google\Cloud\ArtifactRegistry\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * A Repository for storing artifacts with a specific format.
 *
 * Generated from protobuf message <code>google.devtools.artifactregistry.v1.Repository</code>
 */
class Repository extends \Google\Protobuf\Internal\Message
{
    /**
     * The name of the repository, for example:
     * `projects/p1/locations/us-central1/repositories/repo1`. For each location
     * in a project, repository names must be unique.
     *
     * Generated from protobuf field <code>string name = 1;</code>
     */
    protected $name = '';
    /**
     * Optional. The format of packages that are stored in the repository.
     *
     * Generated from protobuf field <code>.google.devtools.artifactregistry.v1.Repository.Format format = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $format = 0;
    /**
     * The user-provided description of the repository.
     *
     * Generated from protobuf field <code>string description = 3;</code>
     */
    protected $description = '';
    /**
     * Labels with user-defined metadata.
     * This field may contain up to 64 entries. Label keys and values may be no
     * longer than 63 characters. Label keys must begin with a lowercase letter
     * and may only contain lowercase letters, numeric characters, underscores,
     * and dashes.
     *
     * Generated from protobuf field <code>map<string, string> labels = 4;</code>
     */
    private $labels;
    /**
     * Output only. The time when the repository was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $create_time = null;
    /**
     * Output only. The time when the repository was last updated.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $update_time = null;
    /**
     * The Cloud KMS resource name of the customer managed encryption key that's
     * used to encrypt the contents of the Repository. Has the form:
     * `projects/my-project/locations/my-region/keyRings/my-kr/cryptoKeys/my-key`.
     * This value may not be changed after the Repository has been created.
     *
     * Generated from protobuf field <code>string kms_key_name = 8;</code>
     */
    protected $kms_key_name = '';
    /**
     * Optional. The mode of the repository.
     *
     * Generated from protobuf field <code>.google.devtools.artifactregistry.v1.Repository.Mode mode = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $mode = 0;
    /**
     * Optional. Cleanup policies for this repository. Cleanup policies indicate
     * when certain package versions can be automatically deleted. Map keys are
     * policy IDs supplied by users during policy creation. They must unique
     * within a repository and be under 128 characters in length.
     *
     * Generated from protobuf field <code>map<string, .google.devtools.artifactregistry.v1.CleanupPolicy> cleanup_policies = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $cleanup_policies;
    /**
     * Output only. The size, in bytes, of all artifact storage in this
     * repository. Repositories that are generally available or in public preview
     *  use this to calculate storage costs.
     *
     * Generated from protobuf field <code>int64 size_bytes = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $size_bytes = 0;
    /**
     * Output only. If set, the repository satisfies physical zone separation.
     *
     * Generated from protobuf field <code>bool satisfies_pzs = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $satisfies_pzs = false;
    /**
     * Optional. If true, the cleanup pipeline is prevented from deleting versions
     * in this repository.
     *
     * Generated from protobuf field <code>bool cleanup_policy_dry_run = 18 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $cleanup_policy_dry_run = false;
    /**
     * Optional. Config and state for vulnerability scanning of resources within
     * this Repository.
     *
     * Generated from protobuf field <code>.google.devtools.artifactregistry.v1.Repository.VulnerabilityScanningConfig vulnerability_scanning_config = 19 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $vulnerability_scanning_config = null;
    /**
     * Optional. If this is true, an unspecified repo type will be treated as
     * error rather than defaulting to standard.
     *
     * Generated from protobuf field <code>bool disallow_unspecified_mode = 21 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $disallow_unspecified_mode = false;
    /**
     * Output only. If set, the repository satisfies physical zone isolation.
     *
     * Generated from protobuf field <code>bool satisfies_pzi = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $satisfies_pzi = false;
    protected $format_config;
    protected $mode_config;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type \Google\Cloud\ArtifactRegistry\V1\Repository\MavenRepositoryConfig $maven_config
     *           Maven repository config contains repository level configuration
     *           for the repositories of maven type.
     *     @type \Google\Cloud\ArtifactRegistry\V1\Repository\DockerRepositoryConfig $docker_config
     *           Docker repository config contains repository level configuration
     *           for the repositories of docker type.
     *     @type \Google\Cloud\ArtifactRegistry\V1\VirtualRepositoryConfig $virtual_repository_config
     *           Configuration specific for a Virtual Repository.
     *     @type \Google\Cloud\ArtifactRegistry\V1\RemoteRepositoryConfig $remote_repository_config
     *           Configuration specific for a Remote Repository.
     *     @type string $name
     *           The name of the repository, for example:
     *           `projects/p1/locations/us-central1/repositories/repo1`. For each location
     *           in a project, repository names must be unique.
     *     @type int $format
     *           Optional. The format of packages that are stored in the repository.
     *     @type string $description
     *           The user-provided description of the repository.
     *     @type array|\Google\Protobuf\Internal\MapField $labels
     *           Labels with user-defined metadata.
     *           This field may contain up to 64 entries. Label keys and values may be no
     *           longer than 63 characters. Label keys must begin with a lowercase letter
     *           and may only contain lowercase letters, numeric characters, underscores,
     *           and dashes.
     *     @type \Google\Protobuf\Timestamp $create_time
     *           Output only. The time when the repository was created.
     *     @type \Google\Protobuf\Timestamp $update_time
     *           Output only. The time when the repository was last updated.
     *     @type string $kms_key_name
     *           The Cloud KMS resource name of the customer managed encryption key that's
     *           used to encrypt the contents of the Repository. Has the form:
     *           `projects/my-project/locations/my-region/keyRings/my-kr/cryptoKeys/my-key`.
     *           This value may not be changed after the Repository has been created.
     *     @type int $mode
     *           Optional. The mode of the repository.
     *     @type array|\Google\Protobuf\Internal\MapField $cleanup_policies
     *           Optional. Cleanup policies for this repository. Cleanup policies indicate
     *           when certain package versions can be automatically deleted. Map keys are
     *           policy IDs supplied by users during policy creation. They must unique
     *           within a repository and be under 128 characters in length.
     *     @type int|string $size_bytes
     *           Output only. The size, in bytes, of all artifact storage in this
     *           repository. Repositories that are generally available or in public preview
     *            use this to calculate storage costs.
     *     @type bool $satisfies_pzs
     *           Output only. If set, the repository satisfies physical zone separation.
     *     @type bool $cleanup_policy_dry_run
     *           Optional. If true, the cleanup pipeline is prevented from deleting versions
     *           in this repository.
     *     @type \Google\Cloud\ArtifactRegistry\V1\Repository\VulnerabilityScanningConfig $vulnerability_scanning_config
     *           Optional. Config and state for vulnerability scanning of resources within
     *           this Repository.
     *     @type bool $disallow_unspecified_mode
     *           Optional. If this is true, an unspecified repo type will be treated as
     *           error rather than defaulting to standard.
     *     @type bool $satisfies_pzi
     *           Output only. If set, the repository satisfies physical zone isolation.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Devtools\Artifactregistry\V1\Repository::initOnce();
        parent::__construct($data);
    }

    /**
     * Maven repository config contains repository level configuration
     * for the repositories of maven type.
     *
     * Generated from protobuf field <code>.google.devtools.artifactregistry.v1.Repository.MavenRepositoryConfig maven_config = 9;</code>
     * @return \Google\Cloud\ArtifactRegistry\V1\Repository\MavenRepositoryConfig|null
     */
    public function getMavenConfig()
    {
        return $this->readOneof(9);
    }

    public function hasMavenConfig()
    {
        return $this->hasOneof(9);
    }

    /**
     * Maven repository config contains repository level configuration
     * for the repositories of maven type.
     *
     * Generated from protobuf field <code>.google.devtools.artifactregistry.v1.Repository.MavenRepositoryConfig maven_config = 9;</code>
     * @param \Google\Cloud\ArtifactRegistry\V1\Repository\MavenRepositoryConfig $var
     * @return $this
     */
    public function setMavenConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\ArtifactRegistry\V1\Repository\MavenRepositoryConfig::class);
        $this->writeOneof(9, $var);

        return $this;
    }

    /**
     * Docker repository config contains repository level configuration
     * for the repositories of docker type.
     *
     * Generated from protobuf field <code>.google.devtools.artifactregistry.v1.Repository.DockerRepositoryConfig docker_config = 17;</code>
     * @return \Google\Cloud\ArtifactRegistry\V1\Repository\DockerRepositoryConfig|null
     */
    public function getDockerConfig()
    {
        return $this->readOneof(17);
    }

    public function hasDockerConfig()
    {
        return $this->hasOneof(17);
    }

    /**
     * Docker repository config contains repository level configuration
     * for the repositories of docker type.
     *
     * Generated from protobuf field <code>.google.devtools.artifactregistry.v1.Repository.DockerRepositoryConfig docker_config = 17;</code>
     * @param \Google\Cloud\ArtifactRegistry\V1\Repository\DockerRepositoryConfig $var
     * @return $this
     */
    public function setDockerConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\ArtifactRegistry\V1\Repository\DockerRepositoryConfig::class);
        $this->writeOneof(17, $var);

        return $this;
    }

    /**
     * Configuration specific for a Virtual Repository.
     *
     * Generated from protobuf field <code>.google.devtools.artifactregistry.v1.VirtualRepositoryConfig virtual_repository_config = 14;</code>
     * @return \Google\Cloud\ArtifactRegistry\V1\VirtualRepositoryConfig|null
     */
    public function getVirtualRepositoryConfig()
    {
        return $this->readOneof(14);
    }

    public function hasVirtualRepositoryConfig()
    {
        return $this->hasOneof(14);
    }

    /**
     * Configuration specific for a Virtual Repository.
     *
     * Generated from protobuf field <code>.google.devtools.artifactregistry.v1.VirtualRepositoryConfig virtual_repository_config = 14;</code>
     * @param \Google\Cloud\ArtifactRegistry\V1\VirtualRepositoryConfig $var
     * @return $this
     */
    public function setVirtualRepositoryConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\ArtifactRegistry\V1\VirtualRepositoryConfig::class);
        $this->writeOneof(14, $var);

        return $this;
    }

    /**
     * Configuration specific for a Remote Repository.
     *
     * Generated from protobuf field <code>.google.devtools.artifactregistry.v1.RemoteRepositoryConfig remote_repository_config = 15;</code>
     * @return \Google\Cloud\ArtifactRegistry\V1\RemoteRepositoryConfig|null
     */
    public function getRemoteRepositoryConfig()
    {
        return $this->readOneof(15);
    }

    public function hasRemoteRepositoryConfig()
    {
        return $this->hasOneof(15);
    }

    /**
     * Configuration specific for a Remote Repository.
     *
     * Generated from protobuf field <code>.google.devtools.artifactregistry.v1.RemoteRepositoryConfig remote_repository_config = 15;</code>
     * @param \Google\Cloud\ArtifactRegistry\V1\RemoteRepositoryConfig $var
     * @return $this
     */
    public function setRemoteRepositoryConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\ArtifactRegistry\V1\RemoteRepositoryConfig::class);
        $this->writeOneof(15, $var);

        return $this;
    }

    /**
     * The name of the repository, for example:
     * `projects/p1/locations/us-central1/repositories/repo1`. For each location
     * in a project, repository names must be unique.
     *
     * Generated from protobuf field <code>string name = 1;</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * The name of the repository, for example:
     * `projects/p1/locations/us-central1/repositories/repo1`. For each location
     * in a project, repository names must be unique.
     *
     * Generated from protobuf field <code>string name = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Optional. The format of packages that are stored in the repository.
     *
     * Generated from protobuf field <code>.google.devtools.artifactregistry.v1.Repository.Format format = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return int
     */
    public function getFormat()
    {
        return $this->format;
    }

    /**
     * Optional. The format of packages that are stored in the repository.
     *
     * Generated from protobuf field <code>.google.devtools.artifactregistry.v1.Repository.Format format = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param int $var
     * @return $this
     */
    public function setFormat($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\ArtifactRegistry\V1\Repository\Format::class);
        $this->format = $var;

        return $this;
    }

    /**
     * The user-provided description of the repository.
     *
     * Generated from protobuf field <code>string description = 3;</code>
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * The user-provided description of the repository.
     *
     * Generated from protobuf field <code>string description = 3;</code>
     * @param string $var
     * @return $this
     */
    public function setDescription($var)
    {
        GPBUtil::checkString($var, True);
        $this->description = $var;

        return $this;
    }

    /**
     * Labels with user-defined metadata.
     * This field may contain up to 64 entries. Label keys and values may be no
     * longer than 63 characters. Label keys must begin with a lowercase letter
     * and may only contain lowercase letters, numeric characters, underscores,
     * and dashes.
     *
     * Generated from protobuf field <code>map<string, string> labels = 4;</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getLabels()
    {
        return $this->labels;
    }

    /**
     * Labels with user-defined metadata.
     * This field may contain up to 64 entries. Label keys and values may be no
     * longer than 63 characters. Label keys must begin with a lowercase letter
     * and may only contain lowercase letters, numeric characters, underscores,
     * and dashes.
     *
     * Generated from protobuf field <code>map<string, string> labels = 4;</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setLabels($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::STRING);
        $this->labels = $arr;

        return $this;
    }

    /**
     * Output only. The time when the repository was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getCreateTime()
    {
        return $this->create_time;
    }

    public function hasCreateTime()
    {
        return isset($this->create_time);
    }

    public function clearCreateTime()
    {
        unset($this->create_time);
    }

    /**
     * Output only. The time when the repository was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setCreateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->create_time = $var;

        return $this;
    }

    /**
     * Output only. The time when the repository was last updated.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getUpdateTime()
    {
        return $this->update_time;
    }

    public function hasUpdateTime()
    {
        return isset($this->update_time);
    }

    public function clearUpdateTime()
    {
        unset($this->update_time);
    }

    /**
     * Output only. The time when the repository was last updated.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setUpdateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->update_time = $var;

        return $this;
    }

    /**
     * The Cloud KMS resource name of the customer managed encryption key that's
     * used to encrypt the contents of the Repository. Has the form:
     * `projects/my-project/locations/my-region/keyRings/my-kr/cryptoKeys/my-key`.
     * This value may not be changed after the Repository has been created.
     *
     * Generated from protobuf field <code>string kms_key_name = 8;</code>
     * @return string
     */
    public function getKmsKeyName()
    {
        return $this->kms_key_name;
    }

    /**
     * The Cloud KMS resource name of the customer managed encryption key that's
     * used to encrypt the contents of the Repository. Has the form:
     * `projects/my-project/locations/my-region/keyRings/my-kr/cryptoKeys/my-key`.
     * This value may not be changed after the Repository has been created.
     *
     * Generated from protobuf field <code>string kms_key_name = 8;</code>
     * @param string $var
     * @return $this
     */
    public function setKmsKeyName($var)
    {
        GPBUtil::checkString($var, True);
        $this->kms_key_name = $var;

        return $this;
    }

    /**
     * Optional. The mode of the repository.
     *
     * Generated from protobuf field <code>.google.devtools.artifactregistry.v1.Repository.Mode mode = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return int
     */
    public function getMode()
    {
        return $this->mode;
    }

    /**
     * Optional. The mode of the repository.
     *
     * Generated from protobuf field <code>.google.devtools.artifactregistry.v1.Repository.Mode mode = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param int $var
     * @return $this
     */
    public function setMode($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\ArtifactRegistry\V1\Repository\Mode::class);
        $this->mode = $var;

        return $this;
    }

    /**
     * Optional. Cleanup policies for this repository. Cleanup policies indicate
     * when certain package versions can be automatically deleted. Map keys are
     * policy IDs supplied by users during policy creation. They must unique
     * within a repository and be under 128 characters in length.
     *
     * Generated from protobuf field <code>map<string, .google.devtools.artifactregistry.v1.CleanupPolicy> cleanup_policies = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getCleanupPolicies()
    {
        return $this->cleanup_policies;
    }

    /**
     * Optional. Cleanup policies for this repository. Cleanup policies indicate
     * when certain package versions can be automatically deleted. Map keys are
     * policy IDs supplied by users during policy creation. They must unique
     * within a repository and be under 128 characters in length.
     *
     * Generated from protobuf field <code>map<string, .google.devtools.artifactregistry.v1.CleanupPolicy> cleanup_policies = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setCleanupPolicies($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\ArtifactRegistry\V1\CleanupPolicy::class);
        $this->cleanup_policies = $arr;

        return $this;
    }

    /**
     * Output only. The size, in bytes, of all artifact storage in this
     * repository. Repositories that are generally available or in public preview
     *  use this to calculate storage costs.
     *
     * Generated from protobuf field <code>int64 size_bytes = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int|string
     */
    public function getSizeBytes()
    {
        return $this->size_bytes;
    }

    /**
     * Output only. The size, in bytes, of all artifact storage in this
     * repository. Repositories that are generally available or in public preview
     *  use this to calculate storage costs.
     *
     * Generated from protobuf field <code>int64 size_bytes = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int|string $var
     * @return $this
     */
    public function setSizeBytes($var)
    {
        GPBUtil::checkInt64($var);
        $this->size_bytes = $var;

        return $this;
    }

    /**
     * Output only. If set, the repository satisfies physical zone separation.
     *
     * Generated from protobuf field <code>bool satisfies_pzs = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return bool
     */
    public function getSatisfiesPzs()
    {
        return $this->satisfies_pzs;
    }

    /**
     * Output only. If set, the repository satisfies physical zone separation.
     *
     * Generated from protobuf field <code>bool satisfies_pzs = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param bool $var
     * @return $this
     */
    public function setSatisfiesPzs($var)
    {
        GPBUtil::checkBool($var);
        $this->satisfies_pzs = $var;

        return $this;
    }

    /**
     * Optional. If true, the cleanup pipeline is prevented from deleting versions
     * in this repository.
     *
     * Generated from protobuf field <code>bool cleanup_policy_dry_run = 18 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return bool
     */
    public function getCleanupPolicyDryRun()
    {
        return $this->cleanup_policy_dry_run;
    }

    /**
     * Optional. If true, the cleanup pipeline is prevented from deleting versions
     * in this repository.
     *
     * Generated from protobuf field <code>bool cleanup_policy_dry_run = 18 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param bool $var
     * @return $this
     */
    public function setCleanupPolicyDryRun($var)
    {
        GPBUtil::checkBool($var);
        $this->cleanup_policy_dry_run = $var;

        return $this;
    }

    /**
     * Optional. Config and state for vulnerability scanning of resources within
     * this Repository.
     *
     * Generated from protobuf field <code>.google.devtools.artifactregistry.v1.Repository.VulnerabilityScanningConfig vulnerability_scanning_config = 19 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\ArtifactRegistry\V1\Repository\VulnerabilityScanningConfig|null
     */
    public function getVulnerabilityScanningConfig()
    {
        return $this->vulnerability_scanning_config;
    }

    public function hasVulnerabilityScanningConfig()
    {
        return isset($this->vulnerability_scanning_config);
    }

    public function clearVulnerabilityScanningConfig()
    {
        unset($this->vulnerability_scanning_config);
    }

    /**
     * Optional. Config and state for vulnerability scanning of resources within
     * this Repository.
     *
     * Generated from protobuf field <code>.google.devtools.artifactregistry.v1.Repository.VulnerabilityScanningConfig vulnerability_scanning_config = 19 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\ArtifactRegistry\V1\Repository\VulnerabilityScanningConfig $var
     * @return $this
     */
    public function setVulnerabilityScanningConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\ArtifactRegistry\V1\Repository\VulnerabilityScanningConfig::class);
        $this->vulnerability_scanning_config = $var;

        return $this;
    }

    /**
     * Optional. If this is true, an unspecified repo type will be treated as
     * error rather than defaulting to standard.
     *
     * Generated from protobuf field <code>bool disallow_unspecified_mode = 21 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return bool
     */
    public function getDisallowUnspecifiedMode()
    {
        return $this->disallow_unspecified_mode;
    }

    /**
     * Optional. If this is true, an unspecified repo type will be treated as
     * error rather than defaulting to standard.
     *
     * Generated from protobuf field <code>bool disallow_unspecified_mode = 21 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param bool $var
     * @return $this
     */
    public function setDisallowUnspecifiedMode($var)
    {
        GPBUtil::checkBool($var);
        $this->disallow_unspecified_mode = $var;

        return $this;
    }

    /**
     * Output only. If set, the repository satisfies physical zone isolation.
     *
     * Generated from protobuf field <code>bool satisfies_pzi = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return bool
     */
    public function getSatisfiesPzi()
    {
        return $this->satisfies_pzi;
    }

    /**
     * Output only. If set, the repository satisfies physical zone isolation.
     *
     * Generated from protobuf field <code>bool satisfies_pzi = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param bool $var
     * @return $this
     */
    public function setSatisfiesPzi($var)
    {
        GPBUtil::checkBool($var);
        $this->satisfies_pzi = $var;

        return $this;
    }

    /**
     * @return string
     */
    public function getFormatConfig()
    {
        return $this->whichOneof("format_config");
    }

    /**
     * @return string
     */
    public function getModeConfig()
    {
        return $this->whichOneof("mode_config");
    }

}

