<?php
/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/apphub/v1/apphub_service.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\AppHub\V1\Client;

use Google\ApiCore\ApiException;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\OperationResponse;
use Google\ApiCore\PagedListResponse;
use Google\ApiCore\ResourceHelperTrait;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\AppHub\V1\Application;
use Google\Cloud\AppHub\V1\CreateApplicationRequest;
use Google\Cloud\AppHub\V1\CreateServiceProjectAttachmentRequest;
use Google\Cloud\AppHub\V1\CreateServiceRequest;
use Google\Cloud\AppHub\V1\CreateWorkloadRequest;
use Google\Cloud\AppHub\V1\DeleteApplicationRequest;
use Google\Cloud\AppHub\V1\DeleteServiceProjectAttachmentRequest;
use Google\Cloud\AppHub\V1\DeleteServiceRequest;
use Google\Cloud\AppHub\V1\DeleteWorkloadRequest;
use Google\Cloud\AppHub\V1\DetachServiceProjectAttachmentRequest;
use Google\Cloud\AppHub\V1\DetachServiceProjectAttachmentResponse;
use Google\Cloud\AppHub\V1\DiscoveredService;
use Google\Cloud\AppHub\V1\DiscoveredWorkload;
use Google\Cloud\AppHub\V1\GetApplicationRequest;
use Google\Cloud\AppHub\V1\GetDiscoveredServiceRequest;
use Google\Cloud\AppHub\V1\GetDiscoveredWorkloadRequest;
use Google\Cloud\AppHub\V1\GetServiceProjectAttachmentRequest;
use Google\Cloud\AppHub\V1\GetServiceRequest;
use Google\Cloud\AppHub\V1\GetWorkloadRequest;
use Google\Cloud\AppHub\V1\ListApplicationsRequest;
use Google\Cloud\AppHub\V1\ListDiscoveredServicesRequest;
use Google\Cloud\AppHub\V1\ListDiscoveredWorkloadsRequest;
use Google\Cloud\AppHub\V1\ListServiceProjectAttachmentsRequest;
use Google\Cloud\AppHub\V1\ListServicesRequest;
use Google\Cloud\AppHub\V1\ListWorkloadsRequest;
use Google\Cloud\AppHub\V1\LookupDiscoveredServiceRequest;
use Google\Cloud\AppHub\V1\LookupDiscoveredServiceResponse;
use Google\Cloud\AppHub\V1\LookupDiscoveredWorkloadRequest;
use Google\Cloud\AppHub\V1\LookupDiscoveredWorkloadResponse;
use Google\Cloud\AppHub\V1\LookupServiceProjectAttachmentRequest;
use Google\Cloud\AppHub\V1\LookupServiceProjectAttachmentResponse;
use Google\Cloud\AppHub\V1\Service;
use Google\Cloud\AppHub\V1\ServiceProjectAttachment;
use Google\Cloud\AppHub\V1\UpdateApplicationRequest;
use Google\Cloud\AppHub\V1\UpdateServiceRequest;
use Google\Cloud\AppHub\V1\UpdateWorkloadRequest;
use Google\Cloud\AppHub\V1\Workload;
use Google\Cloud\Iam\V1\GetIamPolicyRequest;
use Google\Cloud\Iam\V1\Policy;
use Google\Cloud\Iam\V1\SetIamPolicyRequest;
use Google\Cloud\Iam\V1\TestIamPermissionsRequest;
use Google\Cloud\Iam\V1\TestIamPermissionsResponse;
use Google\Cloud\Location\GetLocationRequest;
use Google\Cloud\Location\ListLocationsRequest;
use Google\Cloud\Location\Location;
use Google\LongRunning\Client\OperationsClient;
use Google\LongRunning\Operation;
use GuzzleHttp\Promise\PromiseInterface;
use Psr\Log\LoggerInterface;

/**
 * Service Description: The App Hub API allows you to manage App Hub resources.
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods.
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 *
 * @method PromiseInterface<OperationResponse> createApplicationAsync(CreateApplicationRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> createServiceAsync(CreateServiceRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> createServiceProjectAttachmentAsync(CreateServiceProjectAttachmentRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> createWorkloadAsync(CreateWorkloadRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> deleteApplicationAsync(DeleteApplicationRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> deleteServiceAsync(DeleteServiceRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> deleteServiceProjectAttachmentAsync(DeleteServiceProjectAttachmentRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> deleteWorkloadAsync(DeleteWorkloadRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<DetachServiceProjectAttachmentResponse> detachServiceProjectAttachmentAsync(DetachServiceProjectAttachmentRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Application> getApplicationAsync(GetApplicationRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<DiscoveredService> getDiscoveredServiceAsync(GetDiscoveredServiceRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<DiscoveredWorkload> getDiscoveredWorkloadAsync(GetDiscoveredWorkloadRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Service> getServiceAsync(GetServiceRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<ServiceProjectAttachment> getServiceProjectAttachmentAsync(GetServiceProjectAttachmentRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Workload> getWorkloadAsync(GetWorkloadRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listApplicationsAsync(ListApplicationsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listDiscoveredServicesAsync(ListDiscoveredServicesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listDiscoveredWorkloadsAsync(ListDiscoveredWorkloadsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listServiceProjectAttachmentsAsync(ListServiceProjectAttachmentsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listServicesAsync(ListServicesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listWorkloadsAsync(ListWorkloadsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<LookupDiscoveredServiceResponse> lookupDiscoveredServiceAsync(LookupDiscoveredServiceRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<LookupDiscoveredWorkloadResponse> lookupDiscoveredWorkloadAsync(LookupDiscoveredWorkloadRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<LookupServiceProjectAttachmentResponse> lookupServiceProjectAttachmentAsync(LookupServiceProjectAttachmentRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> updateApplicationAsync(UpdateApplicationRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> updateServiceAsync(UpdateServiceRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> updateWorkloadAsync(UpdateWorkloadRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Location> getLocationAsync(GetLocationRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listLocationsAsync(ListLocationsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Policy> getIamPolicyAsync(GetIamPolicyRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Policy> setIamPolicyAsync(SetIamPolicyRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<TestIamPermissionsResponse> testIamPermissionsAsync(TestIamPermissionsRequest $request, array $optionalArgs = [])
 */
final class AppHubClient
{
    use GapicClientTrait;
    use ResourceHelperTrait;

    /** The name of the service. */
    private const SERVICE_NAME = 'google.cloud.apphub.v1.AppHub';

    /**
     * The default address of the service.
     *
     * @deprecated SERVICE_ADDRESS_TEMPLATE should be used instead.
     */
    private const SERVICE_ADDRESS = 'apphub.googleapis.com';

    /** The address template of the service. */
    private const SERVICE_ADDRESS_TEMPLATE = 'apphub.UNIVERSE_DOMAIN';

    /** The default port of the service. */
    private const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    private const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = ['https://www.googleapis.com/auth/cloud-platform'];

    private $operationsClient;

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' => self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' => __DIR__ . '/../resources/app_hub_client_config.json',
            'descriptorsConfigPath' => __DIR__ . '/../resources/app_hub_descriptor_config.php',
            'gcpApiConfigPath' => __DIR__ . '/../resources/app_hub_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' => __DIR__ . '/../resources/app_hub_rest_client_config.php',
                ],
            ],
        ];
    }

    /**
     * Return an OperationsClient object with the same endpoint as $this.
     *
     * @return OperationsClient
     */
    public function getOperationsClient()
    {
        return $this->operationsClient;
    }

    /**
     * Resume an existing long running operation that was previously started by a long
     * running API method. If $methodName is not provided, or does not match a long
     * running API method, then the operation can still be resumed, but the
     * OperationResponse object will not deserialize the final response.
     *
     * @param string $operationName The name of the long running operation
     * @param string $methodName    The name of the method used to start the operation
     *
     * @return OperationResponse
     */
    public function resumeOperation($operationName, $methodName = null)
    {
        $options = isset($this->descriptors[$methodName]['longRunning'])
            ? $this->descriptors[$methodName]['longRunning']
            : [];
        $operation = new OperationResponse($operationName, $this->getOperationsClient(), $options);
        $operation->reload();
        return $operation;
    }

    /**
     * Create the default operation client for the service.
     *
     * @param array $options ClientOptions for the client.
     *
     * @return OperationsClient
     */
    private function createOperationsClient(array $options)
    {
        // Unset client-specific configuration options
        unset($options['serviceName'], $options['clientConfig'], $options['descriptorsConfigPath']);

        if (isset($options['operationsClient'])) {
            return $options['operationsClient'];
        }

        return new OperationsClient($options);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a application
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $application
     *
     * @return string The formatted application resource.
     */
    public static function applicationName(string $project, string $location, string $application): string
    {
        return self::getPathTemplate('application')->render([
            'project' => $project,
            'location' => $location,
            'application' => $application,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * discovered_service resource.
     *
     * @param string $project
     * @param string $location
     * @param string $discoveredService
     *
     * @return string The formatted discovered_service resource.
     */
    public static function discoveredServiceName(string $project, string $location, string $discoveredService): string
    {
        return self::getPathTemplate('discoveredService')->render([
            'project' => $project,
            'location' => $location,
            'discovered_service' => $discoveredService,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * discovered_workload resource.
     *
     * @param string $project
     * @param string $location
     * @param string $discoveredWorkload
     *
     * @return string The formatted discovered_workload resource.
     */
    public static function discoveredWorkloadName(string $project, string $location, string $discoveredWorkload): string
    {
        return self::getPathTemplate('discoveredWorkload')->render([
            'project' => $project,
            'location' => $location,
            'discovered_workload' => $discoveredWorkload,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a location
     * resource.
     *
     * @param string $project
     * @param string $location
     *
     * @return string The formatted location resource.
     */
    public static function locationName(string $project, string $location): string
    {
        return self::getPathTemplate('location')->render([
            'project' => $project,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a project
     * resource.
     *
     * @param string $project
     *
     * @return string The formatted project resource.
     */
    public static function projectName(string $project): string
    {
        return self::getPathTemplate('project')->render([
            'project' => $project,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a service
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $application
     * @param string $service
     *
     * @return string The formatted service resource.
     */
    public static function serviceName(string $project, string $location, string $application, string $service): string
    {
        return self::getPathTemplate('service')->render([
            'project' => $project,
            'location' => $location,
            'application' => $application,
            'service' => $service,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * service_project_attachment resource.
     *
     * @param string $project
     * @param string $location
     * @param string $serviceProjectAttachment
     *
     * @return string The formatted service_project_attachment resource.
     */
    public static function serviceProjectAttachmentName(
        string $project,
        string $location,
        string $serviceProjectAttachment
    ): string {
        return self::getPathTemplate('serviceProjectAttachment')->render([
            'project' => $project,
            'location' => $location,
            'service_project_attachment' => $serviceProjectAttachment,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a workload
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $application
     * @param string $workload
     *
     * @return string The formatted workload resource.
     */
    public static function workloadName(
        string $project,
        string $location,
        string $application,
        string $workload
    ): string {
        return self::getPathTemplate('workload')->render([
            'project' => $project,
            'location' => $location,
            'application' => $application,
            'workload' => $workload,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - application: projects/{project}/locations/{location}/applications/{application}
     * - discoveredService: projects/{project}/locations/{location}/discoveredServices/{discovered_service}
     * - discoveredWorkload: projects/{project}/locations/{location}/discoveredWorkloads/{discovered_workload}
     * - location: projects/{project}/locations/{location}
     * - project: projects/{project}
     * - service: projects/{project}/locations/{location}/applications/{application}/services/{service}
     * - serviceProjectAttachment: projects/{project}/locations/{location}/serviceProjectAttachments/{service_project_attachment}
     * - workload: projects/{project}/locations/{location}/applications/{application}/workloads/{workload}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string  $formattedName The formatted name string
     * @param ?string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName(string $formattedName, ?string $template = null): array
    {
        return self::parseFormattedName($formattedName, $template);
    }

    /**
     * Constructor.
     *
     * @param array $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'apphub.googleapis.com:443'.
     *     @type string|array|FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           The credentials to be used by the client to authorize API calls. This option
     *           accepts either a path to a credentials file, or a decoded credentials file as a
     *           PHP array.
     *           *Advanced usage*: In addition, this option can also accept a pre-constructed
     *           {@see \Google\Auth\FetchAuthTokenInterface} object or
     *           {@see \Google\ApiCore\CredentialsWrapper} object. Note that when one of these
     *           objects are provided, any settings in $credentialsConfig will be ignored.
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     *     @type false|LoggerInterface $logger
     *           A PSR-3 compliant logger. If set to false, logging is disabled, ignoring the
     *           'GOOGLE_SDK_PHP_LOGGING' environment flag
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
        $this->operationsClient = $this->createOperationsClient($clientOptions);
    }

    /** Handles execution of the async variants for each documented method. */
    public function __call($method, $args)
    {
        if (substr($method, -5) !== 'Async') {
            trigger_error('Call to undefined method ' . __CLASS__ . "::$method()", E_USER_ERROR);
        }

        array_unshift($args, substr($method, 0, -5));
        return call_user_func_array([$this, 'startAsyncCall'], $args);
    }

    /**
     * Creates an Application in a host project and location.
     *
     * The async variant is {@see AppHubClient::createApplicationAsync()} .
     *
     * @example samples/V1/AppHubClient/create_application.php
     *
     * @param CreateApplicationRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createApplication(CreateApplicationRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreateApplication', $request, $callOptions)->wait();
    }

    /**
     * Creates a Service in an Application.
     *
     * The async variant is {@see AppHubClient::createServiceAsync()} .
     *
     * @example samples/V1/AppHubClient/create_service.php
     *
     * @param CreateServiceRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createService(CreateServiceRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreateService', $request, $callOptions)->wait();
    }

    /**
     * Attaches a service project to the host project.
     *
     * The async variant is {@see AppHubClient::createServiceProjectAttachmentAsync()}
     * .
     *
     * @example samples/V1/AppHubClient/create_service_project_attachment.php
     *
     * @param CreateServiceProjectAttachmentRequest $request     A request to house fields associated with the call.
     * @param array                                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createServiceProjectAttachment(
        CreateServiceProjectAttachmentRequest $request,
        array $callOptions = []
    ): OperationResponse {
        return $this->startApiCall('CreateServiceProjectAttachment', $request, $callOptions)->wait();
    }

    /**
     * Creates a Workload in an Application.
     *
     * The async variant is {@see AppHubClient::createWorkloadAsync()} .
     *
     * @example samples/V1/AppHubClient/create_workload.php
     *
     * @param CreateWorkloadRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createWorkload(CreateWorkloadRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreateWorkload', $request, $callOptions)->wait();
    }

    /**
     * Deletes an Application in a host project and location.
     *
     * The async variant is {@see AppHubClient::deleteApplicationAsync()} .
     *
     * @example samples/V1/AppHubClient/delete_application.php
     *
     * @param DeleteApplicationRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteApplication(DeleteApplicationRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeleteApplication', $request, $callOptions)->wait();
    }

    /**
     * Deletes a Service from an Application.
     *
     * The async variant is {@see AppHubClient::deleteServiceAsync()} .
     *
     * @example samples/V1/AppHubClient/delete_service.php
     *
     * @param DeleteServiceRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteService(DeleteServiceRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeleteService', $request, $callOptions)->wait();
    }

    /**
     * Deletes a service project attachment.
     *
     * The async variant is {@see AppHubClient::deleteServiceProjectAttachmentAsync()}
     * .
     *
     * @example samples/V1/AppHubClient/delete_service_project_attachment.php
     *
     * @param DeleteServiceProjectAttachmentRequest $request     A request to house fields associated with the call.
     * @param array                                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteServiceProjectAttachment(
        DeleteServiceProjectAttachmentRequest $request,
        array $callOptions = []
    ): OperationResponse {
        return $this->startApiCall('DeleteServiceProjectAttachment', $request, $callOptions)->wait();
    }

    /**
     * Deletes a Workload from an Application.
     *
     * The async variant is {@see AppHubClient::deleteWorkloadAsync()} .
     *
     * @example samples/V1/AppHubClient/delete_workload.php
     *
     * @param DeleteWorkloadRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteWorkload(DeleteWorkloadRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeleteWorkload', $request, $callOptions)->wait();
    }

    /**
     * Detaches a service project from a host project.
     * You can call this API from any service project without needing access to
     * the host project that it is attached to.
     *
     * The async variant is {@see AppHubClient::detachServiceProjectAttachmentAsync()}
     * .
     *
     * @example samples/V1/AppHubClient/detach_service_project_attachment.php
     *
     * @param DetachServiceProjectAttachmentRequest $request     A request to house fields associated with the call.
     * @param array                                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return DetachServiceProjectAttachmentResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function detachServiceProjectAttachment(
        DetachServiceProjectAttachmentRequest $request,
        array $callOptions = []
    ): DetachServiceProjectAttachmentResponse {
        return $this->startApiCall('DetachServiceProjectAttachment', $request, $callOptions)->wait();
    }

    /**
     * Gets an Application in a host project and location.
     *
     * The async variant is {@see AppHubClient::getApplicationAsync()} .
     *
     * @example samples/V1/AppHubClient/get_application.php
     *
     * @param GetApplicationRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Application
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getApplication(GetApplicationRequest $request, array $callOptions = []): Application
    {
        return $this->startApiCall('GetApplication', $request, $callOptions)->wait();
    }

    /**
     * Gets a Discovered Service in a host project and location.
     *
     * The async variant is {@see AppHubClient::getDiscoveredServiceAsync()} .
     *
     * @example samples/V1/AppHubClient/get_discovered_service.php
     *
     * @param GetDiscoveredServiceRequest $request     A request to house fields associated with the call.
     * @param array                       $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return DiscoveredService
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getDiscoveredService(
        GetDiscoveredServiceRequest $request,
        array $callOptions = []
    ): DiscoveredService {
        return $this->startApiCall('GetDiscoveredService', $request, $callOptions)->wait();
    }

    /**
     * Gets a Discovered Workload in a host project and location.
     *
     * The async variant is {@see AppHubClient::getDiscoveredWorkloadAsync()} .
     *
     * @example samples/V1/AppHubClient/get_discovered_workload.php
     *
     * @param GetDiscoveredWorkloadRequest $request     A request to house fields associated with the call.
     * @param array                        $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return DiscoveredWorkload
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getDiscoveredWorkload(
        GetDiscoveredWorkloadRequest $request,
        array $callOptions = []
    ): DiscoveredWorkload {
        return $this->startApiCall('GetDiscoveredWorkload', $request, $callOptions)->wait();
    }

    /**
     * Gets a Service in an Application.
     *
     * The async variant is {@see AppHubClient::getServiceAsync()} .
     *
     * @example samples/V1/AppHubClient/get_service.php
     *
     * @param GetServiceRequest $request     A request to house fields associated with the call.
     * @param array             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Service
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getService(GetServiceRequest $request, array $callOptions = []): Service
    {
        return $this->startApiCall('GetService', $request, $callOptions)->wait();
    }

    /**
     * Gets a service project attachment.
     *
     * The async variant is {@see AppHubClient::getServiceProjectAttachmentAsync()} .
     *
     * @example samples/V1/AppHubClient/get_service_project_attachment.php
     *
     * @param GetServiceProjectAttachmentRequest $request     A request to house fields associated with the call.
     * @param array                              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return ServiceProjectAttachment
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getServiceProjectAttachment(
        GetServiceProjectAttachmentRequest $request,
        array $callOptions = []
    ): ServiceProjectAttachment {
        return $this->startApiCall('GetServiceProjectAttachment', $request, $callOptions)->wait();
    }

    /**
     * Gets a Workload in an Application.
     *
     * The async variant is {@see AppHubClient::getWorkloadAsync()} .
     *
     * @example samples/V1/AppHubClient/get_workload.php
     *
     * @param GetWorkloadRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Workload
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getWorkload(GetWorkloadRequest $request, array $callOptions = []): Workload
    {
        return $this->startApiCall('GetWorkload', $request, $callOptions)->wait();
    }

    /**
     * Lists Applications in a host project and location.
     *
     * The async variant is {@see AppHubClient::listApplicationsAsync()} .
     *
     * @example samples/V1/AppHubClient/list_applications.php
     *
     * @param ListApplicationsRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listApplications(ListApplicationsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListApplications', $request, $callOptions);
    }

    /**
     * Lists Discovered Services that can be added to an Application in a host
     * project and location.
     *
     * The async variant is {@see AppHubClient::listDiscoveredServicesAsync()} .
     *
     * @example samples/V1/AppHubClient/list_discovered_services.php
     *
     * @param ListDiscoveredServicesRequest $request     A request to house fields associated with the call.
     * @param array                         $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listDiscoveredServices(
        ListDiscoveredServicesRequest $request,
        array $callOptions = []
    ): PagedListResponse {
        return $this->startApiCall('ListDiscoveredServices', $request, $callOptions);
    }

    /**
     * Lists Discovered Workloads that can be added to an Application in a host
     * project and location.
     *
     * The async variant is {@see AppHubClient::listDiscoveredWorkloadsAsync()} .
     *
     * @example samples/V1/AppHubClient/list_discovered_workloads.php
     *
     * @param ListDiscoveredWorkloadsRequest $request     A request to house fields associated with the call.
     * @param array                          $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listDiscoveredWorkloads(
        ListDiscoveredWorkloadsRequest $request,
        array $callOptions = []
    ): PagedListResponse {
        return $this->startApiCall('ListDiscoveredWorkloads', $request, $callOptions);
    }

    /**
     * Lists service projects attached to the host project.
     *
     * The async variant is {@see AppHubClient::listServiceProjectAttachmentsAsync()} .
     *
     * @example samples/V1/AppHubClient/list_service_project_attachments.php
     *
     * @param ListServiceProjectAttachmentsRequest $request     A request to house fields associated with the call.
     * @param array                                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listServiceProjectAttachments(
        ListServiceProjectAttachmentsRequest $request,
        array $callOptions = []
    ): PagedListResponse {
        return $this->startApiCall('ListServiceProjectAttachments', $request, $callOptions);
    }

    /**
     * Lists Services in an Application.
     *
     * The async variant is {@see AppHubClient::listServicesAsync()} .
     *
     * @example samples/V1/AppHubClient/list_services.php
     *
     * @param ListServicesRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listServices(ListServicesRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListServices', $request, $callOptions);
    }

    /**
     * Lists Workloads in an Application.
     *
     * The async variant is {@see AppHubClient::listWorkloadsAsync()} .
     *
     * @example samples/V1/AppHubClient/list_workloads.php
     *
     * @param ListWorkloadsRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listWorkloads(ListWorkloadsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListWorkloads', $request, $callOptions);
    }

    /**
     * Lists a Discovered Service in a host project and location, with a
     * given resource URI.
     *
     * The async variant is {@see AppHubClient::lookupDiscoveredServiceAsync()} .
     *
     * @example samples/V1/AppHubClient/lookup_discovered_service.php
     *
     * @param LookupDiscoveredServiceRequest $request     A request to house fields associated with the call.
     * @param array                          $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return LookupDiscoveredServiceResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function lookupDiscoveredService(
        LookupDiscoveredServiceRequest $request,
        array $callOptions = []
    ): LookupDiscoveredServiceResponse {
        return $this->startApiCall('LookupDiscoveredService', $request, $callOptions)->wait();
    }

    /**
     * Lists a Discovered Workload in a host project and location, with a
     * given resource URI.
     *
     * The async variant is {@see AppHubClient::lookupDiscoveredWorkloadAsync()} .
     *
     * @example samples/V1/AppHubClient/lookup_discovered_workload.php
     *
     * @param LookupDiscoveredWorkloadRequest $request     A request to house fields associated with the call.
     * @param array                           $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return LookupDiscoveredWorkloadResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function lookupDiscoveredWorkload(
        LookupDiscoveredWorkloadRequest $request,
        array $callOptions = []
    ): LookupDiscoveredWorkloadResponse {
        return $this->startApiCall('LookupDiscoveredWorkload', $request, $callOptions)->wait();
    }

    /**
     * Lists a service project attachment for a given service project. You can
     * call this API from any project to find if it is attached to a host project.
     *
     * The async variant is {@see AppHubClient::lookupServiceProjectAttachmentAsync()}
     * .
     *
     * @example samples/V1/AppHubClient/lookup_service_project_attachment.php
     *
     * @param LookupServiceProjectAttachmentRequest $request     A request to house fields associated with the call.
     * @param array                                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return LookupServiceProjectAttachmentResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function lookupServiceProjectAttachment(
        LookupServiceProjectAttachmentRequest $request,
        array $callOptions = []
    ): LookupServiceProjectAttachmentResponse {
        return $this->startApiCall('LookupServiceProjectAttachment', $request, $callOptions)->wait();
    }

    /**
     * Updates an Application in a host project and location.
     *
     * The async variant is {@see AppHubClient::updateApplicationAsync()} .
     *
     * @example samples/V1/AppHubClient/update_application.php
     *
     * @param UpdateApplicationRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateApplication(UpdateApplicationRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('UpdateApplication', $request, $callOptions)->wait();
    }

    /**
     * Updates a Service in an Application.
     *
     * The async variant is {@see AppHubClient::updateServiceAsync()} .
     *
     * @example samples/V1/AppHubClient/update_service.php
     *
     * @param UpdateServiceRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateService(UpdateServiceRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('UpdateService', $request, $callOptions)->wait();
    }

    /**
     * Updates a Workload in an Application.
     *
     * The async variant is {@see AppHubClient::updateWorkloadAsync()} .
     *
     * @example samples/V1/AppHubClient/update_workload.php
     *
     * @param UpdateWorkloadRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateWorkload(UpdateWorkloadRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('UpdateWorkload', $request, $callOptions)->wait();
    }

    /**
     * Gets information about a location.
     *
     * The async variant is {@see AppHubClient::getLocationAsync()} .
     *
     * @example samples/V1/AppHubClient/get_location.php
     *
     * @param GetLocationRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Location
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getLocation(GetLocationRequest $request, array $callOptions = []): Location
    {
        return $this->startApiCall('GetLocation', $request, $callOptions)->wait();
    }

    /**
     * Lists information about the supported locations for this service.
     *
     * The async variant is {@see AppHubClient::listLocationsAsync()} .
     *
     * @example samples/V1/AppHubClient/list_locations.php
     *
     * @param ListLocationsRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listLocations(ListLocationsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListLocations', $request, $callOptions);
    }

    /**
     * Gets the access control policy for a resource. Returns an empty policy
    if the resource exists and does not have a policy set.
     *
     * The async variant is {@see AppHubClient::getIamPolicyAsync()} .
     *
     * @example samples/V1/AppHubClient/get_iam_policy.php
     *
     * @param GetIamPolicyRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Policy
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getIamPolicy(GetIamPolicyRequest $request, array $callOptions = []): Policy
    {
        return $this->startApiCall('GetIamPolicy', $request, $callOptions)->wait();
    }

    /**
     * Sets the access control policy on the specified resource. Replaces
    any existing policy.

    Can return `NOT_FOUND`, `INVALID_ARGUMENT`, and `PERMISSION_DENIED`
    errors.
     *
     * The async variant is {@see AppHubClient::setIamPolicyAsync()} .
     *
     * @example samples/V1/AppHubClient/set_iam_policy.php
     *
     * @param SetIamPolicyRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Policy
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function setIamPolicy(SetIamPolicyRequest $request, array $callOptions = []): Policy
    {
        return $this->startApiCall('SetIamPolicy', $request, $callOptions)->wait();
    }

    /**
     * Returns permissions that a caller has on the specified resource. If the
    resource does not exist, this will return an empty set of
    permissions, not a `NOT_FOUND` error.

    Note: This operation is designed to be used for building
    permission-aware UIs and command-line tools, not for authorization
    checking. This operation may "fail open" without warning.
     *
     * The async variant is {@see AppHubClient::testIamPermissionsAsync()} .
     *
     * @example samples/V1/AppHubClient/test_iam_permissions.php
     *
     * @param TestIamPermissionsRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return TestIamPermissionsResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function testIamPermissions(
        TestIamPermissionsRequest $request,
        array $callOptions = []
    ): TestIamPermissionsResponse {
        return $this->startApiCall('TestIamPermissions', $request, $callOptions)->wait();
    }
}
