<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/appengine/v1/version.proto

namespace Google\Cloud\AppEngine\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * A Version resource is a specific set of source code and configuration files
 * that are deployed into a service.
 *
 * Generated from protobuf message <code>google.appengine.v1.Version</code>
 */
class Version extends \Google\Protobuf\Internal\Message
{
    /**
     * Full path to the Version resource in the API.  Example:
     * `apps/myapp/services/default/versions/v1`.
     * &#64;OutputOnly
     *
     * Generated from protobuf field <code>string name = 1;</code>
     */
    protected $name = '';
    /**
     * Relative name of the version within the service.  Example: `v1`.
     * Version names can contain only lowercase letters, numbers, or hyphens.
     * Reserved names: "default", "latest", and any name with the prefix "ah-".
     *
     * Generated from protobuf field <code>string id = 2;</code>
     */
    protected $id = '';
    /**
     * Before an application can receive email or XMPP messages, the application
     * must be configured to enable the service.
     *
     * Generated from protobuf field <code>repeated .google.appengine.v1.InboundServiceType inbound_services = 6;</code>
     */
    private $inbound_services;
    /**
     * Instance class that is used to run this version. Valid values are:
     * * AutomaticScaling: `F1`, `F2`, `F4`, `F4_1G`
     * * ManualScaling or BasicScaling: `B1`, `B2`, `B4`, `B8`, `B4_1G`
     * Defaults to `F1` for AutomaticScaling and `B1` for ManualScaling or
     * BasicScaling.
     *
     * Generated from protobuf field <code>string instance_class = 7;</code>
     */
    protected $instance_class = '';
    /**
     * Extra network settings.
     * Only applicable in the App Engine flexible environment.
     *
     * Generated from protobuf field <code>.google.appengine.v1.Network network = 8;</code>
     */
    protected $network = null;
    /**
     * The Google Compute Engine zones that are supported by this version in the
     * App Engine flexible environment. Deprecated.
     *
     * Generated from protobuf field <code>repeated string zones = 118;</code>
     */
    private $zones;
    /**
     * Machine resources for this version.
     * Only applicable in the App Engine flexible environment.
     *
     * Generated from protobuf field <code>.google.appengine.v1.Resources resources = 9;</code>
     */
    protected $resources = null;
    /**
     * Desired runtime. Example: `python27`.
     *
     * Generated from protobuf field <code>string runtime = 10;</code>
     */
    protected $runtime = '';
    /**
     * The channel of the runtime to use. Only available for some
     * runtimes. Defaults to the `default` channel.
     *
     * Generated from protobuf field <code>string runtime_channel = 117;</code>
     */
    protected $runtime_channel = '';
    /**
     * Whether multiple requests can be dispatched to this version at once.
     *
     * Generated from protobuf field <code>bool threadsafe = 11;</code>
     */
    protected $threadsafe = false;
    /**
     * Whether to deploy this version in a container on a virtual machine.
     *
     * Generated from protobuf field <code>bool vm = 12;</code>
     */
    protected $vm = false;
    /**
     * Allows App Engine second generation runtimes to access the legacy bundled
     * services.
     *
     * Generated from protobuf field <code>bool app_engine_apis = 128;</code>
     */
    protected $app_engine_apis = false;
    /**
     * Metadata settings that are supplied to this version to enable
     * beta runtime features.
     *
     * Generated from protobuf field <code>map<string, string> beta_settings = 13;</code>
     */
    private $beta_settings;
    /**
     * App Engine execution environment for this version.
     * Defaults to `standard`.
     *
     * Generated from protobuf field <code>string env = 14;</code>
     */
    protected $env = '';
    /**
     * Current serving status of this version. Only the versions with a
     * `SERVING` status create instances and can be billed.
     * `SERVING_STATUS_UNSPECIFIED` is an invalid value. Defaults to `SERVING`.
     *
     * Generated from protobuf field <code>.google.appengine.v1.ServingStatus serving_status = 15;</code>
     */
    protected $serving_status = 0;
    /**
     * Email address of the user who created this version.
     * &#64;OutputOnly
     *
     * Generated from protobuf field <code>string created_by = 16;</code>
     */
    protected $created_by = '';
    /**
     * Time that this version was created.
     * &#64;OutputOnly
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 17;</code>
     */
    protected $create_time = null;
    /**
     * Total size in bytes of all the files that are included in this version
     * and currently hosted on the App Engine disk.
     * &#64;OutputOnly
     *
     * Generated from protobuf field <code>int64 disk_usage_bytes = 18;</code>
     */
    protected $disk_usage_bytes = 0;
    /**
     * The version of the API in the given runtime environment. Please see the
     * app.yaml reference for valid values at
     * https://cloud.google.com/appengine/docs/standard/<language>/config/appref
     *
     * Generated from protobuf field <code>string runtime_api_version = 21;</code>
     */
    protected $runtime_api_version = '';
    /**
     * The path or name of the app's main executable.
     *
     * Generated from protobuf field <code>string runtime_main_executable_path = 22;</code>
     */
    protected $runtime_main_executable_path = '';
    /**
     * The identity that the deployed version will run as.
     * Admin API will use the App Engine Appspot service account as default if
     * this field is neither provided in app.yaml file nor through CLI flag.
     *
     * Generated from protobuf field <code>string service_account = 127;</code>
     */
    protected $service_account = '';
    /**
     * An ordered list of URL-matching patterns that should be applied to incoming
     * requests. The first matching URL handles the request and other request
     * handlers are not attempted.
     * Only returned in `GET` requests if `view=FULL` is set.
     *
     * Generated from protobuf field <code>repeated .google.appengine.v1.UrlMap handlers = 100;</code>
     */
    private $handlers;
    /**
     * Custom static error pages. Limited to 10KB per page.
     * Only returned in `GET` requests if `view=FULL` is set.
     *
     * Generated from protobuf field <code>repeated .google.appengine.v1.ErrorHandler error_handlers = 101;</code>
     */
    private $error_handlers;
    /**
     * Configuration for third-party Python runtime libraries that are required
     * by the application.
     * Only returned in `GET` requests if `view=FULL` is set.
     *
     * Generated from protobuf field <code>repeated .google.appengine.v1.Library libraries = 102;</code>
     */
    private $libraries;
    /**
     * Serving configuration for
     * [Google Cloud Endpoints](https://cloud.google.com/appengine/docs/python/endpoints/).
     * Only returned in `GET` requests if `view=FULL` is set.
     *
     * Generated from protobuf field <code>.google.appengine.v1.ApiConfigHandler api_config = 103;</code>
     */
    protected $api_config = null;
    /**
     * Environment variables available to the application.
     * Only returned in `GET` requests if `view=FULL` is set.
     *
     * Generated from protobuf field <code>map<string, string> env_variables = 104;</code>
     */
    private $env_variables;
    /**
     * Environment variables available to the build environment.
     * Only returned in `GET` requests if `view=FULL` is set.
     *
     * Generated from protobuf field <code>map<string, string> build_env_variables = 125;</code>
     */
    private $build_env_variables;
    /**
     * Duration that static files should be cached by web proxies and browsers.
     * Only applicable if the corresponding
     * [StaticFilesHandler](https://cloud.google.com/appengine/docs/admin-api/reference/rest/v1/apps.services.versions#StaticFilesHandler)
     * does not specify its own expiration time.
     * Only returned in `GET` requests if `view=FULL` is set.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration default_expiration = 105;</code>
     */
    protected $default_expiration = null;
    /**
     * Configures health checking for instances. Unhealthy instances are
     * stopped and replaced with new instances.
     * Only applicable in the App Engine flexible environment.
     * Only returned in `GET` requests if `view=FULL` is set.
     *
     * Generated from protobuf field <code>.google.appengine.v1.HealthCheck health_check = 106;</code>
     */
    protected $health_check = null;
    /**
     * Configures readiness health checking for instances.
     * Unhealthy instances are not put into the backend traffic rotation.
     * Only returned in `GET` requests if `view=FULL` is set.
     *
     * Generated from protobuf field <code>.google.appengine.v1.ReadinessCheck readiness_check = 112;</code>
     */
    protected $readiness_check = null;
    /**
     * Configures liveness health checking for instances.
     * Unhealthy instances are stopped and replaced with new instances
     * Only returned in `GET` requests if `view=FULL` is set.
     *
     * Generated from protobuf field <code>.google.appengine.v1.LivenessCheck liveness_check = 113;</code>
     */
    protected $liveness_check = null;
    /**
     * Files that match this pattern will not be built into this version.
     * Only applicable for Go runtimes.
     * Only returned in `GET` requests if `view=FULL` is set.
     *
     * Generated from protobuf field <code>string nobuild_files_regex = 107;</code>
     */
    protected $nobuild_files_regex = '';
    /**
     * Code and application artifacts that make up this version.
     * Only returned in `GET` requests if `view=FULL` is set.
     *
     * Generated from protobuf field <code>.google.appengine.v1.Deployment deployment = 108;</code>
     */
    protected $deployment = null;
    /**
     * Serving URL for this version. Example:
     * "https://myversion-dot-myservice-dot-myapp.appspot.com"
     * &#64;OutputOnly
     *
     * Generated from protobuf field <code>string version_url = 109;</code>
     */
    protected $version_url = '';
    /**
     * Cloud Endpoints configuration.
     * If endpoints_api_service is set, the Cloud Endpoints Extensible Service
     * Proxy will be provided to serve the API implemented by the app.
     *
     * Generated from protobuf field <code>.google.appengine.v1.EndpointsApiService endpoints_api_service = 110;</code>
     */
    protected $endpoints_api_service = null;
    /**
     * The entrypoint for the application.
     *
     * Generated from protobuf field <code>.google.appengine.v1.Entrypoint entrypoint = 122;</code>
     */
    protected $entrypoint = null;
    /**
     * Enables VPC connectivity for standard apps.
     *
     * Generated from protobuf field <code>.google.appengine.v1.VpcAccessConnector vpc_access_connector = 121;</code>
     */
    protected $vpc_access_connector = null;
    protected $scaling;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           Full path to the Version resource in the API.  Example:
     *           `apps/myapp/services/default/versions/v1`.
     *           &#64;OutputOnly
     *     @type string $id
     *           Relative name of the version within the service.  Example: `v1`.
     *           Version names can contain only lowercase letters, numbers, or hyphens.
     *           Reserved names: "default", "latest", and any name with the prefix "ah-".
     *     @type \Google\Cloud\AppEngine\V1\AutomaticScaling $automatic_scaling
     *           Automatic scaling is based on request rate, response latencies, and other
     *           application metrics. Instances are dynamically created and destroyed as
     *           needed in order to handle traffic.
     *     @type \Google\Cloud\AppEngine\V1\BasicScaling $basic_scaling
     *           A service with basic scaling will create an instance when the application
     *           receives a request. The instance will be turned down when the app becomes
     *           idle. Basic scaling is ideal for work that is intermittent or driven by
     *           user activity.
     *     @type \Google\Cloud\AppEngine\V1\ManualScaling $manual_scaling
     *           A service with manual scaling runs continuously, allowing you to perform
     *           complex initialization and rely on the state of its memory over time.
     *           Manually scaled versions are sometimes referred to as "backends".
     *     @type array<int>|\Google\Protobuf\Internal\RepeatedField $inbound_services
     *           Before an application can receive email or XMPP messages, the application
     *           must be configured to enable the service.
     *     @type string $instance_class
     *           Instance class that is used to run this version. Valid values are:
     *           * AutomaticScaling: `F1`, `F2`, `F4`, `F4_1G`
     *           * ManualScaling or BasicScaling: `B1`, `B2`, `B4`, `B8`, `B4_1G`
     *           Defaults to `F1` for AutomaticScaling and `B1` for ManualScaling or
     *           BasicScaling.
     *     @type \Google\Cloud\AppEngine\V1\Network $network
     *           Extra network settings.
     *           Only applicable in the App Engine flexible environment.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $zones
     *           The Google Compute Engine zones that are supported by this version in the
     *           App Engine flexible environment. Deprecated.
     *     @type \Google\Cloud\AppEngine\V1\Resources $resources
     *           Machine resources for this version.
     *           Only applicable in the App Engine flexible environment.
     *     @type string $runtime
     *           Desired runtime. Example: `python27`.
     *     @type string $runtime_channel
     *           The channel of the runtime to use. Only available for some
     *           runtimes. Defaults to the `default` channel.
     *     @type bool $threadsafe
     *           Whether multiple requests can be dispatched to this version at once.
     *     @type bool $vm
     *           Whether to deploy this version in a container on a virtual machine.
     *     @type bool $app_engine_apis
     *           Allows App Engine second generation runtimes to access the legacy bundled
     *           services.
     *     @type array|\Google\Protobuf\Internal\MapField $beta_settings
     *           Metadata settings that are supplied to this version to enable
     *           beta runtime features.
     *     @type string $env
     *           App Engine execution environment for this version.
     *           Defaults to `standard`.
     *     @type int $serving_status
     *           Current serving status of this version. Only the versions with a
     *           `SERVING` status create instances and can be billed.
     *           `SERVING_STATUS_UNSPECIFIED` is an invalid value. Defaults to `SERVING`.
     *     @type string $created_by
     *           Email address of the user who created this version.
     *           &#64;OutputOnly
     *     @type \Google\Protobuf\Timestamp $create_time
     *           Time that this version was created.
     *           &#64;OutputOnly
     *     @type int|string $disk_usage_bytes
     *           Total size in bytes of all the files that are included in this version
     *           and currently hosted on the App Engine disk.
     *           &#64;OutputOnly
     *     @type string $runtime_api_version
     *           The version of the API in the given runtime environment. Please see the
     *           app.yaml reference for valid values at
     *           https://cloud.google.com/appengine/docs/standard/<language>/config/appref
     *     @type string $runtime_main_executable_path
     *           The path or name of the app's main executable.
     *     @type string $service_account
     *           The identity that the deployed version will run as.
     *           Admin API will use the App Engine Appspot service account as default if
     *           this field is neither provided in app.yaml file nor through CLI flag.
     *     @type array<\Google\Cloud\AppEngine\V1\UrlMap>|\Google\Protobuf\Internal\RepeatedField $handlers
     *           An ordered list of URL-matching patterns that should be applied to incoming
     *           requests. The first matching URL handles the request and other request
     *           handlers are not attempted.
     *           Only returned in `GET` requests if `view=FULL` is set.
     *     @type array<\Google\Cloud\AppEngine\V1\ErrorHandler>|\Google\Protobuf\Internal\RepeatedField $error_handlers
     *           Custom static error pages. Limited to 10KB per page.
     *           Only returned in `GET` requests if `view=FULL` is set.
     *     @type array<\Google\Cloud\AppEngine\V1\Library>|\Google\Protobuf\Internal\RepeatedField $libraries
     *           Configuration for third-party Python runtime libraries that are required
     *           by the application.
     *           Only returned in `GET` requests if `view=FULL` is set.
     *     @type \Google\Cloud\AppEngine\V1\ApiConfigHandler $api_config
     *           Serving configuration for
     *           [Google Cloud Endpoints](https://cloud.google.com/appengine/docs/python/endpoints/).
     *           Only returned in `GET` requests if `view=FULL` is set.
     *     @type array|\Google\Protobuf\Internal\MapField $env_variables
     *           Environment variables available to the application.
     *           Only returned in `GET` requests if `view=FULL` is set.
     *     @type array|\Google\Protobuf\Internal\MapField $build_env_variables
     *           Environment variables available to the build environment.
     *           Only returned in `GET` requests if `view=FULL` is set.
     *     @type \Google\Protobuf\Duration $default_expiration
     *           Duration that static files should be cached by web proxies and browsers.
     *           Only applicable if the corresponding
     *           [StaticFilesHandler](https://cloud.google.com/appengine/docs/admin-api/reference/rest/v1/apps.services.versions#StaticFilesHandler)
     *           does not specify its own expiration time.
     *           Only returned in `GET` requests if `view=FULL` is set.
     *     @type \Google\Cloud\AppEngine\V1\HealthCheck $health_check
     *           Configures health checking for instances. Unhealthy instances are
     *           stopped and replaced with new instances.
     *           Only applicable in the App Engine flexible environment.
     *           Only returned in `GET` requests if `view=FULL` is set.
     *     @type \Google\Cloud\AppEngine\V1\ReadinessCheck $readiness_check
     *           Configures readiness health checking for instances.
     *           Unhealthy instances are not put into the backend traffic rotation.
     *           Only returned in `GET` requests if `view=FULL` is set.
     *     @type \Google\Cloud\AppEngine\V1\LivenessCheck $liveness_check
     *           Configures liveness health checking for instances.
     *           Unhealthy instances are stopped and replaced with new instances
     *           Only returned in `GET` requests if `view=FULL` is set.
     *     @type string $nobuild_files_regex
     *           Files that match this pattern will not be built into this version.
     *           Only applicable for Go runtimes.
     *           Only returned in `GET` requests if `view=FULL` is set.
     *     @type \Google\Cloud\AppEngine\V1\Deployment $deployment
     *           Code and application artifacts that make up this version.
     *           Only returned in `GET` requests if `view=FULL` is set.
     *     @type string $version_url
     *           Serving URL for this version. Example:
     *           "https://myversion-dot-myservice-dot-myapp.appspot.com"
     *           &#64;OutputOnly
     *     @type \Google\Cloud\AppEngine\V1\EndpointsApiService $endpoints_api_service
     *           Cloud Endpoints configuration.
     *           If endpoints_api_service is set, the Cloud Endpoints Extensible Service
     *           Proxy will be provided to serve the API implemented by the app.
     *     @type \Google\Cloud\AppEngine\V1\Entrypoint $entrypoint
     *           The entrypoint for the application.
     *     @type \Google\Cloud\AppEngine\V1\VpcAccessConnector $vpc_access_connector
     *           Enables VPC connectivity for standard apps.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Appengine\V1\Version::initOnce();
        parent::__construct($data);
    }

    /**
     * Full path to the Version resource in the API.  Example:
     * `apps/myapp/services/default/versions/v1`.
     * &#64;OutputOnly
     *
     * Generated from protobuf field <code>string name = 1;</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Full path to the Version resource in the API.  Example:
     * `apps/myapp/services/default/versions/v1`.
     * &#64;OutputOnly
     *
     * Generated from protobuf field <code>string name = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Relative name of the version within the service.  Example: `v1`.
     * Version names can contain only lowercase letters, numbers, or hyphens.
     * Reserved names: "default", "latest", and any name with the prefix "ah-".
     *
     * Generated from protobuf field <code>string id = 2;</code>
     * @return string
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Relative name of the version within the service.  Example: `v1`.
     * Version names can contain only lowercase letters, numbers, or hyphens.
     * Reserved names: "default", "latest", and any name with the prefix "ah-".
     *
     * Generated from protobuf field <code>string id = 2;</code>
     * @param string $var
     * @return $this
     */
    public function setId($var)
    {
        GPBUtil::checkString($var, True);
        $this->id = $var;

        return $this;
    }

    /**
     * Automatic scaling is based on request rate, response latencies, and other
     * application metrics. Instances are dynamically created and destroyed as
     * needed in order to handle traffic.
     *
     * Generated from protobuf field <code>.google.appengine.v1.AutomaticScaling automatic_scaling = 3;</code>
     * @return \Google\Cloud\AppEngine\V1\AutomaticScaling|null
     */
    public function getAutomaticScaling()
    {
        return $this->readOneof(3);
    }

    public function hasAutomaticScaling()
    {
        return $this->hasOneof(3);
    }

    /**
     * Automatic scaling is based on request rate, response latencies, and other
     * application metrics. Instances are dynamically created and destroyed as
     * needed in order to handle traffic.
     *
     * Generated from protobuf field <code>.google.appengine.v1.AutomaticScaling automatic_scaling = 3;</code>
     * @param \Google\Cloud\AppEngine\V1\AutomaticScaling $var
     * @return $this
     */
    public function setAutomaticScaling($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\AppEngine\V1\AutomaticScaling::class);
        $this->writeOneof(3, $var);

        return $this;
    }

    /**
     * A service with basic scaling will create an instance when the application
     * receives a request. The instance will be turned down when the app becomes
     * idle. Basic scaling is ideal for work that is intermittent or driven by
     * user activity.
     *
     * Generated from protobuf field <code>.google.appengine.v1.BasicScaling basic_scaling = 4;</code>
     * @return \Google\Cloud\AppEngine\V1\BasicScaling|null
     */
    public function getBasicScaling()
    {
        return $this->readOneof(4);
    }

    public function hasBasicScaling()
    {
        return $this->hasOneof(4);
    }

    /**
     * A service with basic scaling will create an instance when the application
     * receives a request. The instance will be turned down when the app becomes
     * idle. Basic scaling is ideal for work that is intermittent or driven by
     * user activity.
     *
     * Generated from protobuf field <code>.google.appengine.v1.BasicScaling basic_scaling = 4;</code>
     * @param \Google\Cloud\AppEngine\V1\BasicScaling $var
     * @return $this
     */
    public function setBasicScaling($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\AppEngine\V1\BasicScaling::class);
        $this->writeOneof(4, $var);

        return $this;
    }

    /**
     * A service with manual scaling runs continuously, allowing you to perform
     * complex initialization and rely on the state of its memory over time.
     * Manually scaled versions are sometimes referred to as "backends".
     *
     * Generated from protobuf field <code>.google.appengine.v1.ManualScaling manual_scaling = 5;</code>
     * @return \Google\Cloud\AppEngine\V1\ManualScaling|null
     */
    public function getManualScaling()
    {
        return $this->readOneof(5);
    }

    public function hasManualScaling()
    {
        return $this->hasOneof(5);
    }

    /**
     * A service with manual scaling runs continuously, allowing you to perform
     * complex initialization and rely on the state of its memory over time.
     * Manually scaled versions are sometimes referred to as "backends".
     *
     * Generated from protobuf field <code>.google.appengine.v1.ManualScaling manual_scaling = 5;</code>
     * @param \Google\Cloud\AppEngine\V1\ManualScaling $var
     * @return $this
     */
    public function setManualScaling($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\AppEngine\V1\ManualScaling::class);
        $this->writeOneof(5, $var);

        return $this;
    }

    /**
     * Before an application can receive email or XMPP messages, the application
     * must be configured to enable the service.
     *
     * Generated from protobuf field <code>repeated .google.appengine.v1.InboundServiceType inbound_services = 6;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getInboundServices()
    {
        return $this->inbound_services;
    }

    /**
     * Before an application can receive email or XMPP messages, the application
     * must be configured to enable the service.
     *
     * Generated from protobuf field <code>repeated .google.appengine.v1.InboundServiceType inbound_services = 6;</code>
     * @param array<int>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setInboundServices($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::ENUM, \Google\Cloud\AppEngine\V1\InboundServiceType::class);
        $this->inbound_services = $arr;

        return $this;
    }

    /**
     * Instance class that is used to run this version. Valid values are:
     * * AutomaticScaling: `F1`, `F2`, `F4`, `F4_1G`
     * * ManualScaling or BasicScaling: `B1`, `B2`, `B4`, `B8`, `B4_1G`
     * Defaults to `F1` for AutomaticScaling and `B1` for ManualScaling or
     * BasicScaling.
     *
     * Generated from protobuf field <code>string instance_class = 7;</code>
     * @return string
     */
    public function getInstanceClass()
    {
        return $this->instance_class;
    }

    /**
     * Instance class that is used to run this version. Valid values are:
     * * AutomaticScaling: `F1`, `F2`, `F4`, `F4_1G`
     * * ManualScaling or BasicScaling: `B1`, `B2`, `B4`, `B8`, `B4_1G`
     * Defaults to `F1` for AutomaticScaling and `B1` for ManualScaling or
     * BasicScaling.
     *
     * Generated from protobuf field <code>string instance_class = 7;</code>
     * @param string $var
     * @return $this
     */
    public function setInstanceClass($var)
    {
        GPBUtil::checkString($var, True);
        $this->instance_class = $var;

        return $this;
    }

    /**
     * Extra network settings.
     * Only applicable in the App Engine flexible environment.
     *
     * Generated from protobuf field <code>.google.appengine.v1.Network network = 8;</code>
     * @return \Google\Cloud\AppEngine\V1\Network|null
     */
    public function getNetwork()
    {
        return $this->network;
    }

    public function hasNetwork()
    {
        return isset($this->network);
    }

    public function clearNetwork()
    {
        unset($this->network);
    }

    /**
     * Extra network settings.
     * Only applicable in the App Engine flexible environment.
     *
     * Generated from protobuf field <code>.google.appengine.v1.Network network = 8;</code>
     * @param \Google\Cloud\AppEngine\V1\Network $var
     * @return $this
     */
    public function setNetwork($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\AppEngine\V1\Network::class);
        $this->network = $var;

        return $this;
    }

    /**
     * The Google Compute Engine zones that are supported by this version in the
     * App Engine flexible environment. Deprecated.
     *
     * Generated from protobuf field <code>repeated string zones = 118;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getZones()
    {
        return $this->zones;
    }

    /**
     * The Google Compute Engine zones that are supported by this version in the
     * App Engine flexible environment. Deprecated.
     *
     * Generated from protobuf field <code>repeated string zones = 118;</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setZones($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->zones = $arr;

        return $this;
    }

    /**
     * Machine resources for this version.
     * Only applicable in the App Engine flexible environment.
     *
     * Generated from protobuf field <code>.google.appengine.v1.Resources resources = 9;</code>
     * @return \Google\Cloud\AppEngine\V1\Resources|null
     */
    public function getResources()
    {
        return $this->resources;
    }

    public function hasResources()
    {
        return isset($this->resources);
    }

    public function clearResources()
    {
        unset($this->resources);
    }

    /**
     * Machine resources for this version.
     * Only applicable in the App Engine flexible environment.
     *
     * Generated from protobuf field <code>.google.appengine.v1.Resources resources = 9;</code>
     * @param \Google\Cloud\AppEngine\V1\Resources $var
     * @return $this
     */
    public function setResources($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\AppEngine\V1\Resources::class);
        $this->resources = $var;

        return $this;
    }

    /**
     * Desired runtime. Example: `python27`.
     *
     * Generated from protobuf field <code>string runtime = 10;</code>
     * @return string
     */
    public function getRuntime()
    {
        return $this->runtime;
    }

    /**
     * Desired runtime. Example: `python27`.
     *
     * Generated from protobuf field <code>string runtime = 10;</code>
     * @param string $var
     * @return $this
     */
    public function setRuntime($var)
    {
        GPBUtil::checkString($var, True);
        $this->runtime = $var;

        return $this;
    }

    /**
     * The channel of the runtime to use. Only available for some
     * runtimes. Defaults to the `default` channel.
     *
     * Generated from protobuf field <code>string runtime_channel = 117;</code>
     * @return string
     */
    public function getRuntimeChannel()
    {
        return $this->runtime_channel;
    }

    /**
     * The channel of the runtime to use. Only available for some
     * runtimes. Defaults to the `default` channel.
     *
     * Generated from protobuf field <code>string runtime_channel = 117;</code>
     * @param string $var
     * @return $this
     */
    public function setRuntimeChannel($var)
    {
        GPBUtil::checkString($var, True);
        $this->runtime_channel = $var;

        return $this;
    }

    /**
     * Whether multiple requests can be dispatched to this version at once.
     *
     * Generated from protobuf field <code>bool threadsafe = 11;</code>
     * @return bool
     */
    public function getThreadsafe()
    {
        return $this->threadsafe;
    }

    /**
     * Whether multiple requests can be dispatched to this version at once.
     *
     * Generated from protobuf field <code>bool threadsafe = 11;</code>
     * @param bool $var
     * @return $this
     */
    public function setThreadsafe($var)
    {
        GPBUtil::checkBool($var);
        $this->threadsafe = $var;

        return $this;
    }

    /**
     * Whether to deploy this version in a container on a virtual machine.
     *
     * Generated from protobuf field <code>bool vm = 12;</code>
     * @return bool
     */
    public function getVm()
    {
        return $this->vm;
    }

    /**
     * Whether to deploy this version in a container on a virtual machine.
     *
     * Generated from protobuf field <code>bool vm = 12;</code>
     * @param bool $var
     * @return $this
     */
    public function setVm($var)
    {
        GPBUtil::checkBool($var);
        $this->vm = $var;

        return $this;
    }

    /**
     * Allows App Engine second generation runtimes to access the legacy bundled
     * services.
     *
     * Generated from protobuf field <code>bool app_engine_apis = 128;</code>
     * @return bool
     */
    public function getAppEngineApis()
    {
        return $this->app_engine_apis;
    }

    /**
     * Allows App Engine second generation runtimes to access the legacy bundled
     * services.
     *
     * Generated from protobuf field <code>bool app_engine_apis = 128;</code>
     * @param bool $var
     * @return $this
     */
    public function setAppEngineApis($var)
    {
        GPBUtil::checkBool($var);
        $this->app_engine_apis = $var;

        return $this;
    }

    /**
     * Metadata settings that are supplied to this version to enable
     * beta runtime features.
     *
     * Generated from protobuf field <code>map<string, string> beta_settings = 13;</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getBetaSettings()
    {
        return $this->beta_settings;
    }

    /**
     * Metadata settings that are supplied to this version to enable
     * beta runtime features.
     *
     * Generated from protobuf field <code>map<string, string> beta_settings = 13;</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setBetaSettings($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::STRING);
        $this->beta_settings = $arr;

        return $this;
    }

    /**
     * App Engine execution environment for this version.
     * Defaults to `standard`.
     *
     * Generated from protobuf field <code>string env = 14;</code>
     * @return string
     */
    public function getEnv()
    {
        return $this->env;
    }

    /**
     * App Engine execution environment for this version.
     * Defaults to `standard`.
     *
     * Generated from protobuf field <code>string env = 14;</code>
     * @param string $var
     * @return $this
     */
    public function setEnv($var)
    {
        GPBUtil::checkString($var, True);
        $this->env = $var;

        return $this;
    }

    /**
     * Current serving status of this version. Only the versions with a
     * `SERVING` status create instances and can be billed.
     * `SERVING_STATUS_UNSPECIFIED` is an invalid value. Defaults to `SERVING`.
     *
     * Generated from protobuf field <code>.google.appengine.v1.ServingStatus serving_status = 15;</code>
     * @return int
     */
    public function getServingStatus()
    {
        return $this->serving_status;
    }

    /**
     * Current serving status of this version. Only the versions with a
     * `SERVING` status create instances and can be billed.
     * `SERVING_STATUS_UNSPECIFIED` is an invalid value. Defaults to `SERVING`.
     *
     * Generated from protobuf field <code>.google.appengine.v1.ServingStatus serving_status = 15;</code>
     * @param int $var
     * @return $this
     */
    public function setServingStatus($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\AppEngine\V1\ServingStatus::class);
        $this->serving_status = $var;

        return $this;
    }

    /**
     * Email address of the user who created this version.
     * &#64;OutputOnly
     *
     * Generated from protobuf field <code>string created_by = 16;</code>
     * @return string
     */
    public function getCreatedBy()
    {
        return $this->created_by;
    }

    /**
     * Email address of the user who created this version.
     * &#64;OutputOnly
     *
     * Generated from protobuf field <code>string created_by = 16;</code>
     * @param string $var
     * @return $this
     */
    public function setCreatedBy($var)
    {
        GPBUtil::checkString($var, True);
        $this->created_by = $var;

        return $this;
    }

    /**
     * Time that this version was created.
     * &#64;OutputOnly
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 17;</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getCreateTime()
    {
        return $this->create_time;
    }

    public function hasCreateTime()
    {
        return isset($this->create_time);
    }

    public function clearCreateTime()
    {
        unset($this->create_time);
    }

    /**
     * Time that this version was created.
     * &#64;OutputOnly
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 17;</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setCreateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->create_time = $var;

        return $this;
    }

    /**
     * Total size in bytes of all the files that are included in this version
     * and currently hosted on the App Engine disk.
     * &#64;OutputOnly
     *
     * Generated from protobuf field <code>int64 disk_usage_bytes = 18;</code>
     * @return int|string
     */
    public function getDiskUsageBytes()
    {
        return $this->disk_usage_bytes;
    }

    /**
     * Total size in bytes of all the files that are included in this version
     * and currently hosted on the App Engine disk.
     * &#64;OutputOnly
     *
     * Generated from protobuf field <code>int64 disk_usage_bytes = 18;</code>
     * @param int|string $var
     * @return $this
     */
    public function setDiskUsageBytes($var)
    {
        GPBUtil::checkInt64($var);
        $this->disk_usage_bytes = $var;

        return $this;
    }

    /**
     * The version of the API in the given runtime environment. Please see the
     * app.yaml reference for valid values at
     * https://cloud.google.com/appengine/docs/standard/<language>/config/appref
     *
     * Generated from protobuf field <code>string runtime_api_version = 21;</code>
     * @return string
     */
    public function getRuntimeApiVersion()
    {
        return $this->runtime_api_version;
    }

    /**
     * The version of the API in the given runtime environment. Please see the
     * app.yaml reference for valid values at
     * https://cloud.google.com/appengine/docs/standard/<language>/config/appref
     *
     * Generated from protobuf field <code>string runtime_api_version = 21;</code>
     * @param string $var
     * @return $this
     */
    public function setRuntimeApiVersion($var)
    {
        GPBUtil::checkString($var, True);
        $this->runtime_api_version = $var;

        return $this;
    }

    /**
     * The path or name of the app's main executable.
     *
     * Generated from protobuf field <code>string runtime_main_executable_path = 22;</code>
     * @return string
     */
    public function getRuntimeMainExecutablePath()
    {
        return $this->runtime_main_executable_path;
    }

    /**
     * The path or name of the app's main executable.
     *
     * Generated from protobuf field <code>string runtime_main_executable_path = 22;</code>
     * @param string $var
     * @return $this
     */
    public function setRuntimeMainExecutablePath($var)
    {
        GPBUtil::checkString($var, True);
        $this->runtime_main_executable_path = $var;

        return $this;
    }

    /**
     * The identity that the deployed version will run as.
     * Admin API will use the App Engine Appspot service account as default if
     * this field is neither provided in app.yaml file nor through CLI flag.
     *
     * Generated from protobuf field <code>string service_account = 127;</code>
     * @return string
     */
    public function getServiceAccount()
    {
        return $this->service_account;
    }

    /**
     * The identity that the deployed version will run as.
     * Admin API will use the App Engine Appspot service account as default if
     * this field is neither provided in app.yaml file nor through CLI flag.
     *
     * Generated from protobuf field <code>string service_account = 127;</code>
     * @param string $var
     * @return $this
     */
    public function setServiceAccount($var)
    {
        GPBUtil::checkString($var, True);
        $this->service_account = $var;

        return $this;
    }

    /**
     * An ordered list of URL-matching patterns that should be applied to incoming
     * requests. The first matching URL handles the request and other request
     * handlers are not attempted.
     * Only returned in `GET` requests if `view=FULL` is set.
     *
     * Generated from protobuf field <code>repeated .google.appengine.v1.UrlMap handlers = 100;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getHandlers()
    {
        return $this->handlers;
    }

    /**
     * An ordered list of URL-matching patterns that should be applied to incoming
     * requests. The first matching URL handles the request and other request
     * handlers are not attempted.
     * Only returned in `GET` requests if `view=FULL` is set.
     *
     * Generated from protobuf field <code>repeated .google.appengine.v1.UrlMap handlers = 100;</code>
     * @param array<\Google\Cloud\AppEngine\V1\UrlMap>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setHandlers($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\AppEngine\V1\UrlMap::class);
        $this->handlers = $arr;

        return $this;
    }

    /**
     * Custom static error pages. Limited to 10KB per page.
     * Only returned in `GET` requests if `view=FULL` is set.
     *
     * Generated from protobuf field <code>repeated .google.appengine.v1.ErrorHandler error_handlers = 101;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getErrorHandlers()
    {
        return $this->error_handlers;
    }

    /**
     * Custom static error pages. Limited to 10KB per page.
     * Only returned in `GET` requests if `view=FULL` is set.
     *
     * Generated from protobuf field <code>repeated .google.appengine.v1.ErrorHandler error_handlers = 101;</code>
     * @param array<\Google\Cloud\AppEngine\V1\ErrorHandler>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setErrorHandlers($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\AppEngine\V1\ErrorHandler::class);
        $this->error_handlers = $arr;

        return $this;
    }

    /**
     * Configuration for third-party Python runtime libraries that are required
     * by the application.
     * Only returned in `GET` requests if `view=FULL` is set.
     *
     * Generated from protobuf field <code>repeated .google.appengine.v1.Library libraries = 102;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getLibraries()
    {
        return $this->libraries;
    }

    /**
     * Configuration for third-party Python runtime libraries that are required
     * by the application.
     * Only returned in `GET` requests if `view=FULL` is set.
     *
     * Generated from protobuf field <code>repeated .google.appengine.v1.Library libraries = 102;</code>
     * @param array<\Google\Cloud\AppEngine\V1\Library>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setLibraries($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\AppEngine\V1\Library::class);
        $this->libraries = $arr;

        return $this;
    }

    /**
     * Serving configuration for
     * [Google Cloud Endpoints](https://cloud.google.com/appengine/docs/python/endpoints/).
     * Only returned in `GET` requests if `view=FULL` is set.
     *
     * Generated from protobuf field <code>.google.appengine.v1.ApiConfigHandler api_config = 103;</code>
     * @return \Google\Cloud\AppEngine\V1\ApiConfigHandler|null
     */
    public function getApiConfig()
    {
        return $this->api_config;
    }

    public function hasApiConfig()
    {
        return isset($this->api_config);
    }

    public function clearApiConfig()
    {
        unset($this->api_config);
    }

    /**
     * Serving configuration for
     * [Google Cloud Endpoints](https://cloud.google.com/appengine/docs/python/endpoints/).
     * Only returned in `GET` requests if `view=FULL` is set.
     *
     * Generated from protobuf field <code>.google.appengine.v1.ApiConfigHandler api_config = 103;</code>
     * @param \Google\Cloud\AppEngine\V1\ApiConfigHandler $var
     * @return $this
     */
    public function setApiConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\AppEngine\V1\ApiConfigHandler::class);
        $this->api_config = $var;

        return $this;
    }

    /**
     * Environment variables available to the application.
     * Only returned in `GET` requests if `view=FULL` is set.
     *
     * Generated from protobuf field <code>map<string, string> env_variables = 104;</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getEnvVariables()
    {
        return $this->env_variables;
    }

    /**
     * Environment variables available to the application.
     * Only returned in `GET` requests if `view=FULL` is set.
     *
     * Generated from protobuf field <code>map<string, string> env_variables = 104;</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setEnvVariables($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::STRING);
        $this->env_variables = $arr;

        return $this;
    }

    /**
     * Environment variables available to the build environment.
     * Only returned in `GET` requests if `view=FULL` is set.
     *
     * Generated from protobuf field <code>map<string, string> build_env_variables = 125;</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getBuildEnvVariables()
    {
        return $this->build_env_variables;
    }

    /**
     * Environment variables available to the build environment.
     * Only returned in `GET` requests if `view=FULL` is set.
     *
     * Generated from protobuf field <code>map<string, string> build_env_variables = 125;</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setBuildEnvVariables($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::STRING);
        $this->build_env_variables = $arr;

        return $this;
    }

    /**
     * Duration that static files should be cached by web proxies and browsers.
     * Only applicable if the corresponding
     * [StaticFilesHandler](https://cloud.google.com/appengine/docs/admin-api/reference/rest/v1/apps.services.versions#StaticFilesHandler)
     * does not specify its own expiration time.
     * Only returned in `GET` requests if `view=FULL` is set.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration default_expiration = 105;</code>
     * @return \Google\Protobuf\Duration|null
     */
    public function getDefaultExpiration()
    {
        return $this->default_expiration;
    }

    public function hasDefaultExpiration()
    {
        return isset($this->default_expiration);
    }

    public function clearDefaultExpiration()
    {
        unset($this->default_expiration);
    }

    /**
     * Duration that static files should be cached by web proxies and browsers.
     * Only applicable if the corresponding
     * [StaticFilesHandler](https://cloud.google.com/appengine/docs/admin-api/reference/rest/v1/apps.services.versions#StaticFilesHandler)
     * does not specify its own expiration time.
     * Only returned in `GET` requests if `view=FULL` is set.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration default_expiration = 105;</code>
     * @param \Google\Protobuf\Duration $var
     * @return $this
     */
    public function setDefaultExpiration($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Duration::class);
        $this->default_expiration = $var;

        return $this;
    }

    /**
     * Configures health checking for instances. Unhealthy instances are
     * stopped and replaced with new instances.
     * Only applicable in the App Engine flexible environment.
     * Only returned in `GET` requests if `view=FULL` is set.
     *
     * Generated from protobuf field <code>.google.appengine.v1.HealthCheck health_check = 106;</code>
     * @return \Google\Cloud\AppEngine\V1\HealthCheck|null
     */
    public function getHealthCheck()
    {
        return $this->health_check;
    }

    public function hasHealthCheck()
    {
        return isset($this->health_check);
    }

    public function clearHealthCheck()
    {
        unset($this->health_check);
    }

    /**
     * Configures health checking for instances. Unhealthy instances are
     * stopped and replaced with new instances.
     * Only applicable in the App Engine flexible environment.
     * Only returned in `GET` requests if `view=FULL` is set.
     *
     * Generated from protobuf field <code>.google.appengine.v1.HealthCheck health_check = 106;</code>
     * @param \Google\Cloud\AppEngine\V1\HealthCheck $var
     * @return $this
     */
    public function setHealthCheck($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\AppEngine\V1\HealthCheck::class);
        $this->health_check = $var;

        return $this;
    }

    /**
     * Configures readiness health checking for instances.
     * Unhealthy instances are not put into the backend traffic rotation.
     * Only returned in `GET` requests if `view=FULL` is set.
     *
     * Generated from protobuf field <code>.google.appengine.v1.ReadinessCheck readiness_check = 112;</code>
     * @return \Google\Cloud\AppEngine\V1\ReadinessCheck|null
     */
    public function getReadinessCheck()
    {
        return $this->readiness_check;
    }

    public function hasReadinessCheck()
    {
        return isset($this->readiness_check);
    }

    public function clearReadinessCheck()
    {
        unset($this->readiness_check);
    }

    /**
     * Configures readiness health checking for instances.
     * Unhealthy instances are not put into the backend traffic rotation.
     * Only returned in `GET` requests if `view=FULL` is set.
     *
     * Generated from protobuf field <code>.google.appengine.v1.ReadinessCheck readiness_check = 112;</code>
     * @param \Google\Cloud\AppEngine\V1\ReadinessCheck $var
     * @return $this
     */
    public function setReadinessCheck($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\AppEngine\V1\ReadinessCheck::class);
        $this->readiness_check = $var;

        return $this;
    }

    /**
     * Configures liveness health checking for instances.
     * Unhealthy instances are stopped and replaced with new instances
     * Only returned in `GET` requests if `view=FULL` is set.
     *
     * Generated from protobuf field <code>.google.appengine.v1.LivenessCheck liveness_check = 113;</code>
     * @return \Google\Cloud\AppEngine\V1\LivenessCheck|null
     */
    public function getLivenessCheck()
    {
        return $this->liveness_check;
    }

    public function hasLivenessCheck()
    {
        return isset($this->liveness_check);
    }

    public function clearLivenessCheck()
    {
        unset($this->liveness_check);
    }

    /**
     * Configures liveness health checking for instances.
     * Unhealthy instances are stopped and replaced with new instances
     * Only returned in `GET` requests if `view=FULL` is set.
     *
     * Generated from protobuf field <code>.google.appengine.v1.LivenessCheck liveness_check = 113;</code>
     * @param \Google\Cloud\AppEngine\V1\LivenessCheck $var
     * @return $this
     */
    public function setLivenessCheck($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\AppEngine\V1\LivenessCheck::class);
        $this->liveness_check = $var;

        return $this;
    }

    /**
     * Files that match this pattern will not be built into this version.
     * Only applicable for Go runtimes.
     * Only returned in `GET` requests if `view=FULL` is set.
     *
     * Generated from protobuf field <code>string nobuild_files_regex = 107;</code>
     * @return string
     */
    public function getNobuildFilesRegex()
    {
        return $this->nobuild_files_regex;
    }

    /**
     * Files that match this pattern will not be built into this version.
     * Only applicable for Go runtimes.
     * Only returned in `GET` requests if `view=FULL` is set.
     *
     * Generated from protobuf field <code>string nobuild_files_regex = 107;</code>
     * @param string $var
     * @return $this
     */
    public function setNobuildFilesRegex($var)
    {
        GPBUtil::checkString($var, True);
        $this->nobuild_files_regex = $var;

        return $this;
    }

    /**
     * Code and application artifacts that make up this version.
     * Only returned in `GET` requests if `view=FULL` is set.
     *
     * Generated from protobuf field <code>.google.appengine.v1.Deployment deployment = 108;</code>
     * @return \Google\Cloud\AppEngine\V1\Deployment|null
     */
    public function getDeployment()
    {
        return $this->deployment;
    }

    public function hasDeployment()
    {
        return isset($this->deployment);
    }

    public function clearDeployment()
    {
        unset($this->deployment);
    }

    /**
     * Code and application artifacts that make up this version.
     * Only returned in `GET` requests if `view=FULL` is set.
     *
     * Generated from protobuf field <code>.google.appengine.v1.Deployment deployment = 108;</code>
     * @param \Google\Cloud\AppEngine\V1\Deployment $var
     * @return $this
     */
    public function setDeployment($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\AppEngine\V1\Deployment::class);
        $this->deployment = $var;

        return $this;
    }

    /**
     * Serving URL for this version. Example:
     * "https://myversion-dot-myservice-dot-myapp.appspot.com"
     * &#64;OutputOnly
     *
     * Generated from protobuf field <code>string version_url = 109;</code>
     * @return string
     */
    public function getVersionUrl()
    {
        return $this->version_url;
    }

    /**
     * Serving URL for this version. Example:
     * "https://myversion-dot-myservice-dot-myapp.appspot.com"
     * &#64;OutputOnly
     *
     * Generated from protobuf field <code>string version_url = 109;</code>
     * @param string $var
     * @return $this
     */
    public function setVersionUrl($var)
    {
        GPBUtil::checkString($var, True);
        $this->version_url = $var;

        return $this;
    }

    /**
     * Cloud Endpoints configuration.
     * If endpoints_api_service is set, the Cloud Endpoints Extensible Service
     * Proxy will be provided to serve the API implemented by the app.
     *
     * Generated from protobuf field <code>.google.appengine.v1.EndpointsApiService endpoints_api_service = 110;</code>
     * @return \Google\Cloud\AppEngine\V1\EndpointsApiService|null
     */
    public function getEndpointsApiService()
    {
        return $this->endpoints_api_service;
    }

    public function hasEndpointsApiService()
    {
        return isset($this->endpoints_api_service);
    }

    public function clearEndpointsApiService()
    {
        unset($this->endpoints_api_service);
    }

    /**
     * Cloud Endpoints configuration.
     * If endpoints_api_service is set, the Cloud Endpoints Extensible Service
     * Proxy will be provided to serve the API implemented by the app.
     *
     * Generated from protobuf field <code>.google.appengine.v1.EndpointsApiService endpoints_api_service = 110;</code>
     * @param \Google\Cloud\AppEngine\V1\EndpointsApiService $var
     * @return $this
     */
    public function setEndpointsApiService($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\AppEngine\V1\EndpointsApiService::class);
        $this->endpoints_api_service = $var;

        return $this;
    }

    /**
     * The entrypoint for the application.
     *
     * Generated from protobuf field <code>.google.appengine.v1.Entrypoint entrypoint = 122;</code>
     * @return \Google\Cloud\AppEngine\V1\Entrypoint|null
     */
    public function getEntrypoint()
    {
        return $this->entrypoint;
    }

    public function hasEntrypoint()
    {
        return isset($this->entrypoint);
    }

    public function clearEntrypoint()
    {
        unset($this->entrypoint);
    }

    /**
     * The entrypoint for the application.
     *
     * Generated from protobuf field <code>.google.appengine.v1.Entrypoint entrypoint = 122;</code>
     * @param \Google\Cloud\AppEngine\V1\Entrypoint $var
     * @return $this
     */
    public function setEntrypoint($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\AppEngine\V1\Entrypoint::class);
        $this->entrypoint = $var;

        return $this;
    }

    /**
     * Enables VPC connectivity for standard apps.
     *
     * Generated from protobuf field <code>.google.appengine.v1.VpcAccessConnector vpc_access_connector = 121;</code>
     * @return \Google\Cloud\AppEngine\V1\VpcAccessConnector|null
     */
    public function getVpcAccessConnector()
    {
        return $this->vpc_access_connector;
    }

    public function hasVpcAccessConnector()
    {
        return isset($this->vpc_access_connector);
    }

    public function clearVpcAccessConnector()
    {
        unset($this->vpc_access_connector);
    }

    /**
     * Enables VPC connectivity for standard apps.
     *
     * Generated from protobuf field <code>.google.appengine.v1.VpcAccessConnector vpc_access_connector = 121;</code>
     * @param \Google\Cloud\AppEngine\V1\VpcAccessConnector $var
     * @return $this
     */
    public function setVpcAccessConnector($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\AppEngine\V1\VpcAccessConnector::class);
        $this->vpc_access_connector = $var;

        return $this;
    }

    /**
     * @return string
     */
    public function getScaling()
    {
        return $this->whichOneof("scaling");
    }

}

