<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/ads/admanager/v1/company_credit_status_enum.proto

namespace Google\Ads\AdManager\V1\CompanyCreditStatusEnum;

use UnexpectedValueException;

/**
 * The credit status of a company.
 * Credit statuses specify the credit-worthiness of a company and affect the
 * ad serving of campaigns belonging to the company.
 * In basic settings, only the
 * [ACTIVE][google.ads.admanager.v1.CompanyCreditStatusEnum.CompanyCreditStatus.ACTIVE]
 * and
 * [INACTIVE][google.ads.admanager.v1.CompanyCreditStatusEnum.CompanyCreditStatus.INACTIVE]
 * credit statuses are applicable. In advance settings, all credit statuses
 * are applicable.
 *
 * Protobuf type <code>google.ads.admanager.v1.CompanyCreditStatusEnum.CompanyCreditStatus</code>
 */
class CompanyCreditStatus
{
    /**
     * No value specified
     *
     * Generated from protobuf enum <code>COMPANY_CREDIT_STATUS_UNSPECIFIED = 0;</code>
     */
    const COMPANY_CREDIT_STATUS_UNSPECIFIED = 0;
    /**
     * The company's credit status is active.
     * Line items belonging to the company can serve.
     * This credit status is the default for basic settings and is available in
     * both basic and advance settings.
     *
     * Generated from protobuf enum <code>ACTIVE = 1;</code>
     */
    const ACTIVE = 1;
    /**
     * The company's credit status is inactive.
     * Line items belonging to the company cannot be activated. However, line
     * items that were activated before the credit status changed will remain
     * active. New orders or line items belonging to the company cannot be
     * created.
     * Companies with this credit status will be hidden by default in company
     * search results.
     * This credit status is available in both basic and advance settings.
     *
     * Generated from protobuf enum <code>INACTIVE = 2;</code>
     */
    const INACTIVE = 2;
    /**
     * The company's credit status is on hold.
     * Line items belonging to the company cannot be activated. However, line
     * items that were activated before the credit status changed will remain
     * active. New orders or line items belonging to the company can be
     * created.
     * This credit status is the default in advance settings and is only
     * available in advance settings.
     *
     * Generated from protobuf enum <code>ON_HOLD = 3;</code>
     */
    const ON_HOLD = 3;
    /**
     * The company's credit status is stopped.
     * Line items belonging to the company cannot be activated. However, line
     * items that were activated before the credit status changed will remain
     * active. New orders or line items belonging to the company cannot be
     * created.
     * This credit status is only available in advance settings.
     *
     * Generated from protobuf enum <code>STOP = 4;</code>
     */
    const STOP = 4;
    /**
     * The company's credit status is blocked.
     * All active line items belonging to the company will stop serving with
     * immediate effect. Line items belonging to the company cannot be
     * activated, and new orders or line items belonging to the company cannot
     * be created.
     * This credit status is only available in advance settings.
     *
     * Generated from protobuf enum <code>BLOCKED = 5;</code>
     */
    const BLOCKED = 5;

    private static $valueToName = [
        self::COMPANY_CREDIT_STATUS_UNSPECIFIED => 'COMPANY_CREDIT_STATUS_UNSPECIFIED',
        self::ACTIVE => 'ACTIVE',
        self::INACTIVE => 'INACTIVE',
        self::ON_HOLD => 'ON_HOLD',
        self::STOP => 'STOP',
        self::BLOCKED => 'BLOCKED',
    ];

    public static function name($value)
    {
        if (!isset(self::$valueToName[$value])) {
            throw new UnexpectedValueException(sprintf(
                    'Enum %s has no name defined for value %s', __CLASS__, $value));
        }
        return self::$valueToName[$value];
    }


    public static function value($name)
    {
        $const = __CLASS__ . '::' . strtoupper($name);
        if (!defined($const)) {
            throw new UnexpectedValueException(sprintf(
                    'Enum %s has no value defined for name %s', __CLASS__, $name));
        }
        return constant($const);
    }
}


