<?php
/*
 * Copyright 2022 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/dataproc/v1/node_groups.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\Dataproc\V1\Gapic;

use Google\ApiCore\ApiException;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\LongRunning\OperationsClient;
use Google\ApiCore\OperationResponse;
use Google\ApiCore\PathTemplate;
use Google\ApiCore\RequestParamsHeaderDescriptor;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\Dataproc\V1\CreateNodeGroupRequest;
use Google\Cloud\Dataproc\V1\GetNodeGroupRequest;
use Google\Cloud\Dataproc\V1\NodeGroup;
use Google\Cloud\Dataproc\V1\NodeGroupOperationMetadata;
use Google\Cloud\Dataproc\V1\ResizeNodeGroupRequest;
use Google\LongRunning\Operation;
use Google\Protobuf\Duration;

/**
 * Service Description: The `NodeGroupControllerService` provides methods to manage node groups
 * of Compute Engine managed instances.
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods. Sample code to get started:
 *
 * ```
 * $nodeGroupControllerClient = new NodeGroupControllerClient();
 * try {
 *     $formattedParent = $nodeGroupControllerClient->clusterRegionName('[PROJECT]', '[REGION]', '[CLUSTER]');
 *     $nodeGroup = new NodeGroup();
 *     $operationResponse = $nodeGroupControllerClient->createNodeGroup($formattedParent, $nodeGroup);
 *     $operationResponse->pollUntilComplete();
 *     if ($operationResponse->operationSucceeded()) {
 *         $result = $operationResponse->getResult();
 *     // doSomethingWith($result)
 *     } else {
 *         $error = $operationResponse->getError();
 *         // handleError($error)
 *     }
 *     // Alternatively:
 *     // start the operation, keep the operation name, and resume later
 *     $operationResponse = $nodeGroupControllerClient->createNodeGroup($formattedParent, $nodeGroup);
 *     $operationName = $operationResponse->getName();
 *     // ... do other work
 *     $newOperationResponse = $nodeGroupControllerClient->resumeOperation($operationName, 'createNodeGroup');
 *     while (!$newOperationResponse->isDone()) {
 *         // ... do other work
 *         $newOperationResponse->reload();
 *     }
 *     if ($newOperationResponse->operationSucceeded()) {
 *         $result = $newOperationResponse->getResult();
 *     // doSomethingWith($result)
 *     } else {
 *         $error = $newOperationResponse->getError();
 *         // handleError($error)
 *     }
 * } finally {
 *     $nodeGroupControllerClient->close();
 * }
 * ```
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 */
class NodeGroupControllerGapicClient
{
    use GapicClientTrait;

    /** The name of the service. */
    const SERVICE_NAME = 'google.cloud.dataproc.v1.NodeGroupController';

    /** The default address of the service. */
    const SERVICE_ADDRESS = 'dataproc.googleapis.com';

    /** The default port of the service. */
    const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = [
        'https://www.googleapis.com/auth/cloud-platform',
    ];

    private static $clusterRegionNameTemplate;

    private static $nodeGroupNameTemplate;

    private static $pathTemplateMap;

    private $operationsClient;

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' => self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' => __DIR__ . '/../resources/node_group_controller_client_config.json',
            'descriptorsConfigPath' => __DIR__ . '/../resources/node_group_controller_descriptor_config.php',
            'gcpApiConfigPath' => __DIR__ . '/../resources/node_group_controller_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' => __DIR__ . '/../resources/node_group_controller_rest_client_config.php',
                ],
            ],
        ];
    }

    private static function getClusterRegionNameTemplate()
    {
        if (self::$clusterRegionNameTemplate == null) {
            self::$clusterRegionNameTemplate = new PathTemplate('projects/{project}/regions/{region}/clusters/{cluster}');
        }

        return self::$clusterRegionNameTemplate;
    }

    private static function getNodeGroupNameTemplate()
    {
        if (self::$nodeGroupNameTemplate == null) {
            self::$nodeGroupNameTemplate = new PathTemplate('projects/{project}/regions/{region}/clusters/{cluster}/nodeGroups/{node_group}');
        }

        return self::$nodeGroupNameTemplate;
    }

    private static function getPathTemplateMap()
    {
        if (self::$pathTemplateMap == null) {
            self::$pathTemplateMap = [
                'clusterRegion' => self::getClusterRegionNameTemplate(),
                'nodeGroup' => self::getNodeGroupNameTemplate(),
            ];
        }

        return self::$pathTemplateMap;
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * cluster_region resource.
     *
     * @param string $project
     * @param string $region
     * @param string $cluster
     *
     * @return string The formatted cluster_region resource.
     */
    public static function clusterRegionName($project, $region, $cluster)
    {
        return self::getClusterRegionNameTemplate()->render([
            'project' => $project,
            'region' => $region,
            'cluster' => $cluster,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a node_group
     * resource.
     *
     * @param string $project
     * @param string $region
     * @param string $cluster
     * @param string $nodeGroup
     *
     * @return string The formatted node_group resource.
     */
    public static function nodeGroupName($project, $region, $cluster, $nodeGroup)
    {
        return self::getNodeGroupNameTemplate()->render([
            'project' => $project,
            'region' => $region,
            'cluster' => $cluster,
            'node_group' => $nodeGroup,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - clusterRegion: projects/{project}/regions/{region}/clusters/{cluster}
     * - nodeGroup: projects/{project}/regions/{region}/clusters/{cluster}/nodeGroups/{node_group}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string $formattedName The formatted name string
     * @param string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName($formattedName, $template = null)
    {
        $templateMap = self::getPathTemplateMap();
        if ($template) {
            if (!isset($templateMap[$template])) {
                throw new ValidationException("Template name $template does not exist");
            }

            return $templateMap[$template]->match($formattedName);
        }

        foreach ($templateMap as $templateName => $pathTemplate) {
            try {
                return $pathTemplate->match($formattedName);
            } catch (ValidationException $ex) {
                // Swallow the exception to continue trying other path templates
            }
        }

        throw new ValidationException("Input did not match any known format. Input: $formattedName");
    }

    /**
     * Return an OperationsClient object with the same endpoint as $this.
     *
     * @return OperationsClient
     */
    public function getOperationsClient()
    {
        return $this->operationsClient;
    }

    /**
     * Resume an existing long running operation that was previously started by a long
     * running API method. If $methodName is not provided, or does not match a long
     * running API method, then the operation can still be resumed, but the
     * OperationResponse object will not deserialize the final response.
     *
     * @param string $operationName The name of the long running operation
     * @param string $methodName    The name of the method used to start the operation
     *
     * @return OperationResponse
     */
    public function resumeOperation($operationName, $methodName = null)
    {
        $options = isset($this->descriptors[$methodName]['longRunning']) ? $this->descriptors[$methodName]['longRunning'] : [];
        $operation = new OperationResponse($operationName, $this->getOperationsClient(), $options);
        $operation->reload();
        return $operation;
    }

    /**
     * Constructor.
     *
     * @param array $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'dataproc.googleapis.com:443'.
     *     @type string|array|FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           The credentials to be used by the client to authorize API calls. This option
     *           accepts either a path to a credentials file, or a decoded credentials file as a
     *           PHP array.
     *           *Advanced usage*: In addition, this option can also accept a pre-constructed
     *           {@see \Google\Auth\FetchAuthTokenInterface} object or
     *           {@see \Google\ApiCore\CredentialsWrapper} object. Note that when one of these
     *           objects are provided, any settings in $credentialsConfig will be ignored.
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
        $this->operationsClient = $this->createOperationsClient($clientOptions);
    }

    /**
     * Creates a node group in a cluster. The returned
     * [Operation.metadata][google.longrunning.Operation.metadata] is
     * [NodeGroupOperationMetadata](https://cloud.google.com/dataproc/docs/reference/rpc/google.cloud.dataproc.v1#nodegroupoperationmetadata).
     *
     * Sample code:
     * ```
     * $nodeGroupControllerClient = new NodeGroupControllerClient();
     * try {
     *     $formattedParent = $nodeGroupControllerClient->clusterRegionName('[PROJECT]', '[REGION]', '[CLUSTER]');
     *     $nodeGroup = new NodeGroup();
     *     $operationResponse = $nodeGroupControllerClient->createNodeGroup($formattedParent, $nodeGroup);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $nodeGroupControllerClient->createNodeGroup($formattedParent, $nodeGroup);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $nodeGroupControllerClient->resumeOperation($operationName, 'createNodeGroup');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $nodeGroupControllerClient->close();
     * }
     * ```
     *
     * @param string    $parent       Required. The parent resource where this node group will be created.
     *                                Format: `projects/{project}/regions/{region}/clusters/{cluster}`
     * @param NodeGroup $nodeGroup    Required. The node group to create.
     * @param array     $optionalArgs {
     *     Optional.
     *
     *     @type string $nodeGroupId
     *           Optional. An optional node group ID. Generated if not specified.
     *
     *           The ID must contain only letters (a-z, A-Z), numbers (0-9),
     *           underscores (_), and hyphens (-). Cannot begin or end with underscore
     *           or hyphen. Must consist of from 3 to 33 characters.
     *     @type string $requestId
     *           Optional. A unique ID used to identify the request. If the server receives
     *           two
     *           [CreateNodeGroupRequest](https://cloud.google.com/dataproc/docs/reference/rpc/google.cloud.dataproc.v1#google.cloud.dataproc.v1.CreateNodeGroupRequests)
     *           with the same ID, the second request is ignored and the
     *           first [google.longrunning.Operation][google.longrunning.Operation] created
     *           and stored in the backend is returned.
     *
     *           Recommendation: Set this value to a
     *           [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier).
     *
     *           The ID must contain only letters (a-z, A-Z), numbers (0-9),
     *           underscores (_), and hyphens (-). The maximum length is 40 characters.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function createNodeGroup($parent, $nodeGroup, array $optionalArgs = [])
    {
        $request = new CreateNodeGroupRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setNodeGroup($nodeGroup);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['nodeGroupId'])) {
            $request->setNodeGroupId($optionalArgs['nodeGroupId']);
        }

        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('CreateNodeGroup', $optionalArgs, $request, $this->getOperationsClient())->wait();
    }

    /**
     * Gets the resource representation for a node group in a
     * cluster.
     *
     * Sample code:
     * ```
     * $nodeGroupControllerClient = new NodeGroupControllerClient();
     * try {
     *     $formattedName = $nodeGroupControllerClient->nodeGroupName('[PROJECT]', '[REGION]', '[CLUSTER]', '[NODE_GROUP]');
     *     $response = $nodeGroupControllerClient->getNodeGroup($formattedName);
     * } finally {
     *     $nodeGroupControllerClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the node group to retrieve.
     *                             Format:
     *                             `projects/{project}/regions/{region}/clusters/{cluster}/nodeGroups/{nodeGroup}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Dataproc\V1\NodeGroup
     *
     * @throws ApiException if the remote call fails
     */
    public function getNodeGroup($name, array $optionalArgs = [])
    {
        $request = new GetNodeGroupRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('GetNodeGroup', NodeGroup::class, $optionalArgs, $request)->wait();
    }

    /**
     * Resizes a node group in a cluster. The returned
     * [Operation.metadata][google.longrunning.Operation.metadata] is
     * [NodeGroupOperationMetadata](https://cloud.google.com/dataproc/docs/reference/rpc/google.cloud.dataproc.v1#nodegroupoperationmetadata).
     *
     * Sample code:
     * ```
     * $nodeGroupControllerClient = new NodeGroupControllerClient();
     * try {
     *     $name = 'name';
     *     $size = 0;
     *     $operationResponse = $nodeGroupControllerClient->resizeNodeGroup($name, $size);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $nodeGroupControllerClient->resizeNodeGroup($name, $size);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $nodeGroupControllerClient->resumeOperation($operationName, 'resizeNodeGroup');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $nodeGroupControllerClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the node group to resize.
     *                             Format:
     *                             `projects/{project}/regions/{region}/clusters/{cluster}/nodeGroups/{nodeGroup}`
     * @param int    $size         Required. The number of running instances for the node group to maintain.
     *                             The group adds or removes instances to maintain the number of instances
     *                             specified by this parameter.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $requestId
     *           Optional. A unique ID used to identify the request. If the server receives
     *           two
     *           [ResizeNodeGroupRequest](https://cloud.google.com/dataproc/docs/reference/rpc/google.cloud.dataproc.v1#google.cloud.dataproc.v1.ResizeNodeGroupRequests)
     *           with the same ID, the second request is ignored and the
     *           first [google.longrunning.Operation][google.longrunning.Operation] created
     *           and stored in the backend is returned.
     *
     *           Recommendation: Set this value to a
     *           [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier).
     *
     *           The ID must contain only letters (a-z, A-Z), numbers (0-9),
     *           underscores (_), and hyphens (-). The maximum length is 40 characters.
     *     @type Duration $gracefulDecommissionTimeout
     *           Optional. Timeout for graceful YARN decomissioning. [Graceful
     *           decommissioning]
     *           (https://cloud.google.com/dataproc/docs/concepts/configuring-clusters/scaling-clusters#graceful_decommissioning)
     *           allows the removal of nodes from the Compute Engine node group
     *           without interrupting jobs in progress. This timeout specifies how long to
     *           wait for jobs in progress to finish before forcefully removing nodes (and
     *           potentially interrupting jobs). Default timeout is 0 (for forceful
     *           decommission), and the maximum allowed timeout is 1 day. (see JSON
     *           representation of
     *           [Duration](https://developers.google.com/protocol-buffers/docs/proto3#json)).
     *
     *           Only supported on Dataproc image versions 1.2 and higher.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function resizeNodeGroup($name, $size, array $optionalArgs = [])
    {
        $request = new ResizeNodeGroupRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $request->setSize($size);
        $requestParamHeaders['name'] = $name;
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        if (isset($optionalArgs['gracefulDecommissionTimeout'])) {
            $request->setGracefulDecommissionTimeout($optionalArgs['gracefulDecommissionTimeout']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('ResizeNodeGroup', $optionalArgs, $request, $this->getOperationsClient())->wait();
    }
}
