<?php
/*
 * Copyright 2022 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/gkemulticloud/v1/attached_service.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\GkeMultiCloud\V1\Gapic;

use Google\ApiCore\ApiException;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\LongRunning\OperationsClient;
use Google\ApiCore\OperationResponse;
use Google\ApiCore\PathTemplate;
use Google\ApiCore\RequestParamsHeaderDescriptor;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\GkeMultiCloud\V1\AttachedCluster;
use Google\Cloud\GkeMultiCloud\V1\AttachedServerConfig;
use Google\Cloud\GkeMultiCloud\V1\CreateAttachedClusterRequest;
use Google\Cloud\GkeMultiCloud\V1\DeleteAttachedClusterRequest;
use Google\Cloud\GkeMultiCloud\V1\GenerateAttachedClusterInstallManifestRequest;
use Google\Cloud\GkeMultiCloud\V1\GenerateAttachedClusterInstallManifestResponse;
use Google\Cloud\GkeMultiCloud\V1\GetAttachedClusterRequest;
use Google\Cloud\GkeMultiCloud\V1\GetAttachedServerConfigRequest;
use Google\Cloud\GkeMultiCloud\V1\ImportAttachedClusterRequest;
use Google\Cloud\GkeMultiCloud\V1\ListAttachedClustersRequest;
use Google\Cloud\GkeMultiCloud\V1\ListAttachedClustersResponse;
use Google\Cloud\GkeMultiCloud\V1\UpdateAttachedClusterRequest;
use Google\LongRunning\Operation;
use Google\Protobuf\FieldMask;

/**
 * Service Description: The AttachedClusters API provides a single centrally managed service
 * to register and manage Anthos attached clusters that run on customer's owned
 * infrastructure.
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods. Sample code to get started:
 *
 * ```
 * $attachedClustersClient = new AttachedClustersClient();
 * try {
 *     $formattedParent = $attachedClustersClient->locationName('[PROJECT]', '[LOCATION]');
 *     $attachedCluster = new AttachedCluster();
 *     $attachedClusterId = 'attached_cluster_id';
 *     $operationResponse = $attachedClustersClient->createAttachedCluster($formattedParent, $attachedCluster, $attachedClusterId);
 *     $operationResponse->pollUntilComplete();
 *     if ($operationResponse->operationSucceeded()) {
 *         $result = $operationResponse->getResult();
 *     // doSomethingWith($result)
 *     } else {
 *         $error = $operationResponse->getError();
 *         // handleError($error)
 *     }
 *     // Alternatively:
 *     // start the operation, keep the operation name, and resume later
 *     $operationResponse = $attachedClustersClient->createAttachedCluster($formattedParent, $attachedCluster, $attachedClusterId);
 *     $operationName = $operationResponse->getName();
 *     // ... do other work
 *     $newOperationResponse = $attachedClustersClient->resumeOperation($operationName, 'createAttachedCluster');
 *     while (!$newOperationResponse->isDone()) {
 *         // ... do other work
 *         $newOperationResponse->reload();
 *     }
 *     if ($newOperationResponse->operationSucceeded()) {
 *         $result = $newOperationResponse->getResult();
 *     // doSomethingWith($result)
 *     } else {
 *         $error = $newOperationResponse->getError();
 *         // handleError($error)
 *     }
 * } finally {
 *     $attachedClustersClient->close();
 * }
 * ```
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 */
class AttachedClustersGapicClient
{
    use GapicClientTrait;

    /** The name of the service. */
    const SERVICE_NAME = 'google.cloud.gkemulticloud.v1.AttachedClusters';

    /** The default address of the service. */
    const SERVICE_ADDRESS = 'gkemulticloud.googleapis.com';

    /** The default port of the service. */
    const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = [
        'https://www.googleapis.com/auth/cloud-platform',
    ];

    private static $attachedClusterNameTemplate;

    private static $attachedServerConfigNameTemplate;

    private static $locationNameTemplate;

    private static $pathTemplateMap;

    private $operationsClient;

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' =>
                self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' =>
                __DIR__ . '/../resources/attached_clusters_client_config.json',
            'descriptorsConfigPath' =>
                __DIR__ .
                '/../resources/attached_clusters_descriptor_config.php',
            'gcpApiConfigPath' =>
                __DIR__ . '/../resources/attached_clusters_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' =>
                        __DIR__ .
                        '/../resources/attached_clusters_rest_client_config.php',
                ],
            ],
        ];
    }

    private static function getAttachedClusterNameTemplate()
    {
        if (self::$attachedClusterNameTemplate == null) {
            self::$attachedClusterNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/attachedClusters/{attached_cluster}'
            );
        }

        return self::$attachedClusterNameTemplate;
    }

    private static function getAttachedServerConfigNameTemplate()
    {
        if (self::$attachedServerConfigNameTemplate == null) {
            self::$attachedServerConfigNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/attachedServerConfig'
            );
        }

        return self::$attachedServerConfigNameTemplate;
    }

    private static function getLocationNameTemplate()
    {
        if (self::$locationNameTemplate == null) {
            self::$locationNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}'
            );
        }

        return self::$locationNameTemplate;
    }

    private static function getPathTemplateMap()
    {
        if (self::$pathTemplateMap == null) {
            self::$pathTemplateMap = [
                'attachedCluster' => self::getAttachedClusterNameTemplate(),
                'attachedServerConfig' => self::getAttachedServerConfigNameTemplate(),
                'location' => self::getLocationNameTemplate(),
            ];
        }

        return self::$pathTemplateMap;
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * attached_cluster resource.
     *
     * @param string $project
     * @param string $location
     * @param string $attachedCluster
     *
     * @return string The formatted attached_cluster resource.
     */
    public static function attachedClusterName(
        $project,
        $location,
        $attachedCluster
    ) {
        return self::getAttachedClusterNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'attached_cluster' => $attachedCluster,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * attached_server_config resource.
     *
     * @param string $project
     * @param string $location
     *
     * @return string The formatted attached_server_config resource.
     */
    public static function attachedServerConfigName($project, $location)
    {
        return self::getAttachedServerConfigNameTemplate()->render([
            'project' => $project,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a location
     * resource.
     *
     * @param string $project
     * @param string $location
     *
     * @return string The formatted location resource.
     */
    public static function locationName($project, $location)
    {
        return self::getLocationNameTemplate()->render([
            'project' => $project,
            'location' => $location,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - attachedCluster: projects/{project}/locations/{location}/attachedClusters/{attached_cluster}
     * - attachedServerConfig: projects/{project}/locations/{location}/attachedServerConfig
     * - location: projects/{project}/locations/{location}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string $formattedName The formatted name string
     * @param string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName($formattedName, $template = null)
    {
        $templateMap = self::getPathTemplateMap();
        if ($template) {
            if (!isset($templateMap[$template])) {
                throw new ValidationException(
                    "Template name $template does not exist"
                );
            }

            return $templateMap[$template]->match($formattedName);
        }

        foreach ($templateMap as $templateName => $pathTemplate) {
            try {
                return $pathTemplate->match($formattedName);
            } catch (ValidationException $ex) {
                // Swallow the exception to continue trying other path templates
            }
        }

        throw new ValidationException(
            "Input did not match any known format. Input: $formattedName"
        );
    }

    /**
     * Return an OperationsClient object with the same endpoint as $this.
     *
     * @return OperationsClient
     */
    public function getOperationsClient()
    {
        return $this->operationsClient;
    }

    /**
     * Resume an existing long running operation that was previously started by a long
     * running API method. If $methodName is not provided, or does not match a long
     * running API method, then the operation can still be resumed, but the
     * OperationResponse object will not deserialize the final response.
     *
     * @param string $operationName The name of the long running operation
     * @param string $methodName    The name of the method used to start the operation
     *
     * @return OperationResponse
     */
    public function resumeOperation($operationName, $methodName = null)
    {
        $options = isset($this->descriptors[$methodName]['longRunning'])
            ? $this->descriptors[$methodName]['longRunning']
            : [];
        $operation = new OperationResponse(
            $operationName,
            $this->getOperationsClient(),
            $options
        );
        $operation->reload();
        return $operation;
    }

    /**
     * Constructor.
     *
     * @param array $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'gkemulticloud.googleapis.com:443'.
     *     @type string|array|FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           The credentials to be used by the client to authorize API calls. This option
     *           accepts either a path to a credentials file, or a decoded credentials file as a
     *           PHP array.
     *           *Advanced usage*: In addition, this option can also accept a pre-constructed
     *           {@see \Google\Auth\FetchAuthTokenInterface} object or
     *           {@see \Google\ApiCore\CredentialsWrapper} object. Note that when one of these
     *           objects are provided, any settings in $credentialsConfig will be ignored.
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
        $this->operationsClient = $this->createOperationsClient($clientOptions);
    }

    /**
     * Creates a new
     * [AttachedCluster][google.cloud.gkemulticloud.v1.AttachedCluster] resource
     * on a given GCP project and region.
     *
     * If successful, the response contains a newly created
     * [Operation][google.longrunning.Operation] resource that can be
     * described to track the status of the operation.
     *
     * Sample code:
     * ```
     * $attachedClustersClient = new AttachedClustersClient();
     * try {
     *     $formattedParent = $attachedClustersClient->locationName('[PROJECT]', '[LOCATION]');
     *     $attachedCluster = new AttachedCluster();
     *     $attachedClusterId = 'attached_cluster_id';
     *     $operationResponse = $attachedClustersClient->createAttachedCluster($formattedParent, $attachedCluster, $attachedClusterId);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $attachedClustersClient->createAttachedCluster($formattedParent, $attachedCluster, $attachedClusterId);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $attachedClustersClient->resumeOperation($operationName, 'createAttachedCluster');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $attachedClustersClient->close();
     * }
     * ```
     *
     * @param string          $parent            Required. The parent location where this
     *                                           [AttachedCluster][google.cloud.gkemulticloud.v1.AttachedCluster] resource
     *                                           will be created.
     *
     *                                           Location names are formatted as `projects/<project-id>/locations/<region>`.
     *
     *                                           See [Resource Names](https://cloud.google.com/apis/design/resource_names)
     *                                           for more details on Google Cloud resource names.
     * @param AttachedCluster $attachedCluster   Required. The specification of the
     *                                           [AttachedCluster][google.cloud.gkemulticloud.v1.AttachedCluster] to create.
     * @param string          $attachedClusterId Required. A client provided ID the resource. Must be unique within the
     *                                           parent resource.
     *
     *                                           The provided ID will be part of the
     *                                           [AttachedCluster][google.cloud.gkemulticloud.v1.AttachedCluster] resource
     *                                           name formatted as
     *                                           `projects/<project-id>/locations/<region>/attachedClusters/<cluster-id>`.
     *
     *                                           Valid characters are `/[a-z][0-9]-/`. Cannot be longer than 63 characters.
     * @param array           $optionalArgs      {
     *     Optional.
     *
     *     @type bool $validateOnly
     *           If set, only validate the request, but do not actually create the cluster.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function createAttachedCluster(
        $parent,
        $attachedCluster,
        $attachedClusterId,
        array $optionalArgs = []
    ) {
        $request = new CreateAttachedClusterRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setAttachedCluster($attachedCluster);
        $request->setAttachedClusterId($attachedClusterId);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['validateOnly'])) {
            $request->setValidateOnly($optionalArgs['validateOnly']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'CreateAttachedCluster',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Deletes a specific
     * [AttachedCluster][google.cloud.gkemulticloud.v1.AttachedCluster] resource.
     *
     * If successful, the response contains a newly created
     * [Operation][google.longrunning.Operation] resource that can be
     * described to track the status of the operation.
     *
     * Sample code:
     * ```
     * $attachedClustersClient = new AttachedClustersClient();
     * try {
     *     $formattedName = $attachedClustersClient->attachedClusterName('[PROJECT]', '[LOCATION]', '[ATTACHED_CLUSTER]');
     *     $operationResponse = $attachedClustersClient->deleteAttachedCluster($formattedName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $attachedClustersClient->deleteAttachedCluster($formattedName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $attachedClustersClient->resumeOperation($operationName, 'deleteAttachedCluster');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $attachedClustersClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The resource name the
     *                             [AttachedCluster][google.cloud.gkemulticloud.v1.AttachedCluster] to delete.
     *
     *                             `AttachedCluster` names are formatted as
     *                             `projects/<project-id>/locations/<region>/attachedClusters/<cluster-id>`.
     *
     *                             See [Resource Names](https://cloud.google.com/apis/design/resource_names)
     *                             for more details on GCP resource names.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type bool $validateOnly
     *           If set, only validate the request, but do not actually delete the resource.
     *     @type bool $allowMissing
     *           If set to true, and the
     *           [AttachedCluster][google.cloud.gkemulticloud.v1.AttachedCluster] resource
     *           is not found, the request will succeed but no action will be taken on the
     *           server and a completed [Operation][google.longrunning.Operation] will be
     *           returned.
     *
     *           Useful for idempotent deletion.
     *     @type bool $ignoreErrors
     *           If set to true, the deletion of
     *           [AttachedCluster][google.cloud.gkemulticloud.v1.AttachedCluster] resource
     *           will succeed even if errors occur during deleting in cluster resources.
     *           Using this parameter may result in orphaned resources in the cluster.
     *     @type string $etag
     *           The current etag of the
     *           [AttachedCluster][google.cloud.gkemulticloud.v1.AttachedCluster].
     *
     *           Allows clients to perform deletions through optimistic concurrency control.
     *
     *           If the provided etag does not match the current etag of the cluster,
     *           the request will fail and an ABORTED error will be returned.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteAttachedCluster($name, array $optionalArgs = [])
    {
        $request = new DeleteAttachedClusterRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        if (isset($optionalArgs['validateOnly'])) {
            $request->setValidateOnly($optionalArgs['validateOnly']);
        }

        if (isset($optionalArgs['allowMissing'])) {
            $request->setAllowMissing($optionalArgs['allowMissing']);
        }

        if (isset($optionalArgs['ignoreErrors'])) {
            $request->setIgnoreErrors($optionalArgs['ignoreErrors']);
        }

        if (isset($optionalArgs['etag'])) {
            $request->setEtag($optionalArgs['etag']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'DeleteAttachedCluster',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Generates the install manifest to be installed on the target cluster.
     *
     * Sample code:
     * ```
     * $attachedClustersClient = new AttachedClustersClient();
     * try {
     *     $formattedParent = $attachedClustersClient->locationName('[PROJECT]', '[LOCATION]');
     *     $attachedClusterId = 'attached_cluster_id';
     *     $platformVersion = 'platform_version';
     *     $response = $attachedClustersClient->generateAttachedClusterInstallManifest($formattedParent, $attachedClusterId, $platformVersion);
     * } finally {
     *     $attachedClustersClient->close();
     * }
     * ```
     *
     * @param string $parent            Required. The parent location where this
     *                                  [AttachedCluster][google.cloud.gkemulticloud.v1.AttachedCluster] resource
     *                                  will be created.
     *
     *                                  Location names are formatted as `projects/<project-id>/locations/<region>`.
     *
     *                                  See [Resource Names](https://cloud.google.com/apis/design/resource_names)
     *                                  for more details on Google Cloud resource names.
     * @param string $attachedClusterId Required. A client provided ID the resource. Must be unique within the
     *                                  parent resource.
     *
     *                                  The provided ID will be part of the
     *                                  [AttachedCluster][google.cloud.gkemulticloud.v1.AttachedCluster] resource
     *                                  name formatted as
     *                                  `projects/<project-id>/locations/<region>/attachedClusters/<cluster-id>`.
     *
     *                                  Valid characters are `/[a-z][0-9]-/`. Cannot be longer than 63 characters.
     *
     *                                  When generating an install manifest for importing an existing Membership
     *                                  resource, the attached_cluster_id field must be the Membership id.
     *
     *                                  Membership names are formatted as `resource name formatted as
     *                                  `projects/<project-id>/locations/<region>/memberships/<membership-id>`.
     * @param string $platformVersion   Required. The platform version for the cluster (e.g. `1.19.0-gke.1000`).
     *
     *                                  You can list all supported versions on a given Google Cloud region by
     *                                  calling
     *                                  [GetAttachedServerConfig][google.cloud.gkemulticloud.v1.AttachedClusters.GetAttachedServerConfig].
     * @param array  $optionalArgs      {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\GkeMultiCloud\V1\GenerateAttachedClusterInstallManifestResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function generateAttachedClusterInstallManifest(
        $parent,
        $attachedClusterId,
        $platformVersion,
        array $optionalArgs = []
    ) {
        $request = new GenerateAttachedClusterInstallManifestRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setAttachedClusterId($attachedClusterId);
        $request->setPlatformVersion($platformVersion);
        $requestParamHeaders['parent'] = $parent;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GenerateAttachedClusterInstallManifest',
            GenerateAttachedClusterInstallManifestResponse::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Describes a specific
     * [AttachedCluster][google.cloud.gkemulticloud.v1.AttachedCluster] resource.
     *
     * Sample code:
     * ```
     * $attachedClustersClient = new AttachedClustersClient();
     * try {
     *     $formattedName = $attachedClustersClient->attachedClusterName('[PROJECT]', '[LOCATION]', '[ATTACHED_CLUSTER]');
     *     $response = $attachedClustersClient->getAttachedCluster($formattedName);
     * } finally {
     *     $attachedClustersClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the
     *                             [AttachedCluster][google.cloud.gkemulticloud.v1.AttachedCluster] resource
     *                             to describe.
     *
     *                             `AttachedCluster` names are formatted as
     *                             `projects/<project-id>/locations/<region>/attachedClusters/<cluster-id>`.
     *
     *                             See [Resource Names](https://cloud.google.com/apis/design/resource_names)
     *                             for more details on GCP resource names.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\GkeMultiCloud\V1\AttachedCluster
     *
     * @throws ApiException if the remote call fails
     */
    public function getAttachedCluster($name, array $optionalArgs = [])
    {
        $request = new GetAttachedClusterRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetAttachedCluster',
            AttachedCluster::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Returns information, such as supported Kubernetes versions, on a given
     * Google Cloud location.
     *
     * Sample code:
     * ```
     * $attachedClustersClient = new AttachedClustersClient();
     * try {
     *     $formattedName = $attachedClustersClient->attachedServerConfigName('[PROJECT]', '[LOCATION]');
     *     $response = $attachedClustersClient->getAttachedServerConfig($formattedName);
     * } finally {
     *     $attachedClustersClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the
     *                             [AttachedServerConfig][google.cloud.gkemulticloud.v1.AttachedServerConfig]
     *                             resource to describe.
     *
     *                             `AttachedServerConfig` names are formatted as
     *                             `projects/<project-id>/locations/<region>/attachedServerConfig`.
     *
     *                             See [Resource Names](https://cloud.google.com/apis/design/resource_names)
     *                             for more details on Google Cloud resource names.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\GkeMultiCloud\V1\AttachedServerConfig
     *
     * @throws ApiException if the remote call fails
     */
    public function getAttachedServerConfig($name, array $optionalArgs = [])
    {
        $request = new GetAttachedServerConfigRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetAttachedServerConfig',
            AttachedServerConfig::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Imports creates a new
     * [AttachedCluster][google.cloud.gkemulticloud.v1.AttachedCluster] resource
     * by importing an existing Fleet Membership resource.
     *
     * Attached Clusters created before the introduction of the Anthos Multi-Cloud
     * API can be imported through this method.
     *
     * If successful, the response contains a newly created
     * [Operation][google.longrunning.Operation] resource that can be
     * described to track the status of the operation.
     *
     * Sample code:
     * ```
     * $attachedClustersClient = new AttachedClustersClient();
     * try {
     *     $formattedParent = $attachedClustersClient->locationName('[PROJECT]', '[LOCATION]');
     *     $fleetMembership = 'fleet_membership';
     *     $platformVersion = 'platform_version';
     *     $distribution = 'distribution';
     *     $operationResponse = $attachedClustersClient->importAttachedCluster($formattedParent, $fleetMembership, $platformVersion, $distribution);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $attachedClustersClient->importAttachedCluster($formattedParent, $fleetMembership, $platformVersion, $distribution);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $attachedClustersClient->resumeOperation($operationName, 'importAttachedCluster');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $attachedClustersClient->close();
     * }
     * ```
     *
     * @param string $parent          Required. The parent location where this
     *                                [AttachedCluster][google.cloud.gkemulticloud.v1.AttachedCluster] resource
     *                                will be created.
     *
     *                                Location names are formatted as `projects/<project-id>/locations/<region>`.
     *
     *                                See [Resource Names](https://cloud.google.com/apis/design/resource_names)
     *                                for more details on Google Cloud resource names.
     * @param string $fleetMembership Required. The name of the fleet membership resource to import.
     * @param string $platformVersion Required. The platform version for the cluster (e.g. `1.19.0-gke.1000`).
     *
     *                                You can list all supported versions on a given Google Cloud region by
     *                                calling
     *                                [GetAttachedServerConfig][google.cloud.gkemulticloud.v1.AttachedClusters.GetAttachedServerConfig].
     * @param string $distribution    Required. The Kubernetes distribution of the underlying attached cluster.
     *
     *                                Supported values: ["eks", "aks"].
     * @param array  $optionalArgs    {
     *     Optional.
     *
     *     @type bool $validateOnly
     *           If set, only validate the request, but do not actually import the cluster.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function importAttachedCluster(
        $parent,
        $fleetMembership,
        $platformVersion,
        $distribution,
        array $optionalArgs = []
    ) {
        $request = new ImportAttachedClusterRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setFleetMembership($fleetMembership);
        $request->setPlatformVersion($platformVersion);
        $request->setDistribution($distribution);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['validateOnly'])) {
            $request->setValidateOnly($optionalArgs['validateOnly']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'ImportAttachedCluster',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Lists all [AttachedCluster][google.cloud.gkemulticloud.v1.AttachedCluster]
     * resources on a given Google Cloud project and region.
     *
     * Sample code:
     * ```
     * $attachedClustersClient = new AttachedClustersClient();
     * try {
     *     $formattedParent = $attachedClustersClient->locationName('[PROJECT]', '[LOCATION]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $attachedClustersClient->listAttachedClusters($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $attachedClustersClient->listAttachedClusters($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $attachedClustersClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The parent location which owns this collection of
     *                             [AttachedCluster][google.cloud.gkemulticloud.v1.AttachedCluster] resources.
     *
     *                             Location names are formatted as `projects/<project-id>/locations/<region>`.
     *
     *                             See [Resource Names](https://cloud.google.com/apis/design/resource_names)
     *                             for more details on GCP resource names.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listAttachedClusters($parent, array $optionalArgs = [])
    {
        $request = new ListAttachedClustersRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListAttachedClusters',
            $optionalArgs,
            ListAttachedClustersResponse::class,
            $request
        );
    }

    /**
     * Updates an
     * [AttachedCluster][google.cloud.gkemulticloud.v1.AttachedCluster].
     *
     * Sample code:
     * ```
     * $attachedClustersClient = new AttachedClustersClient();
     * try {
     *     $attachedCluster = new AttachedCluster();
     *     $updateMask = new FieldMask();
     *     $operationResponse = $attachedClustersClient->updateAttachedCluster($attachedCluster, $updateMask);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $attachedClustersClient->updateAttachedCluster($attachedCluster, $updateMask);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $attachedClustersClient->resumeOperation($operationName, 'updateAttachedCluster');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $attachedClustersClient->close();
     * }
     * ```
     *
     * @param AttachedCluster $attachedCluster Required. The
     *                                         [AttachedCluster][google.cloud.gkemulticloud.v1.AttachedCluster] resource
     *                                         to update.
     * @param FieldMask       $updateMask      Required. Mask of fields to update. At least one path must be supplied in
     *                                         this field. The elements of the repeated paths field can only include these
     *                                         fields from
     *                                         [AttachedCluster][google.cloud.gkemulticloud.v1.AttachedCluster]:
     *
     *                                         *   `description`.
     *                                         *   `annotations`.
     *                                         *   `platform_version`.
     *                                         *   `authorization.admin_users`.
     *                                         *   `logging_config.component_config.enable_components`.
     *                                         *   `monitoring_config.managed_prometheus_config.enabled`.
     * @param array           $optionalArgs    {
     *     Optional.
     *
     *     @type bool $validateOnly
     *           If set, only validate the request, but do not actually update the cluster.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function updateAttachedCluster(
        $attachedCluster,
        $updateMask,
        array $optionalArgs = []
    ) {
        $request = new UpdateAttachedClusterRequest();
        $requestParamHeaders = [];
        $request->setAttachedCluster($attachedCluster);
        $request->setUpdateMask($updateMask);
        $requestParamHeaders[
            'attached_cluster.name'
        ] = $attachedCluster->getName();
        if (isset($optionalArgs['validateOnly'])) {
            $request->setValidateOnly($optionalArgs['validateOnly']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'UpdateAttachedCluster',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }
}
