<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/certificatemanager/v1/certificate_manager.proto

namespace Google\Cloud\CertificateManager\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Defines a certificate map entry.
 *
 * Generated from protobuf message <code>google.cloud.certificatemanager.v1.CertificateMapEntry</code>
 */
class CertificateMapEntry extends \Google\Protobuf\Internal\Message
{
    /**
     * A user-defined name of the Certificate Map Entry. Certificate Map Entry
     * names must be unique globally and match pattern
     * `projects/&#42;&#47;locations/&#42;&#47;certificateMaps/&#42;&#47;certificateMapEntries/&#42;`.
     *
     * Generated from protobuf field <code>string name = 1;</code>
     */
    private $name = '';
    /**
     * One or more paragraphs of text description of a certificate map entry.
     *
     * Generated from protobuf field <code>string description = 9;</code>
     */
    private $description = '';
    /**
     * Output only. The creation timestamp of a Certificate Map Entry.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $create_time = null;
    /**
     * Output only. The update timestamp of a Certificate Map Entry.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $update_time = null;
    /**
     * Set of labels associated with a Certificate Map Entry.
     *
     * Generated from protobuf field <code>map<string, string> labels = 4;</code>
     */
    private $labels;
    /**
     * A set of Certificates defines for the given `hostname`. There can be
     * defined up to fifteen certificates in each Certificate Map Entry. Each
     * certificate must match pattern `projects/&#42;&#47;locations/&#42;&#47;certificates/&#42;`.
     *
     * Generated from protobuf field <code>repeated string certificates = 7 [(.google.api.resource_reference) = {</code>
     */
    private $certificates;
    /**
     * Output only. A serving state of this Certificate Map Entry.
     *
     * Generated from protobuf field <code>.google.cloud.certificatemanager.v1.ServingState state = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $state = 0;
    protected $match;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           A user-defined name of the Certificate Map Entry. Certificate Map Entry
     *           names must be unique globally and match pattern
     *           `projects/&#42;&#47;locations/&#42;&#47;certificateMaps/&#42;&#47;certificateMapEntries/&#42;`.
     *     @type string $description
     *           One or more paragraphs of text description of a certificate map entry.
     *     @type \Google\Protobuf\Timestamp $create_time
     *           Output only. The creation timestamp of a Certificate Map Entry.
     *     @type \Google\Protobuf\Timestamp $update_time
     *           Output only. The update timestamp of a Certificate Map Entry.
     *     @type array|\Google\Protobuf\Internal\MapField $labels
     *           Set of labels associated with a Certificate Map Entry.
     *     @type string $hostname
     *           A Hostname (FQDN, e.g. `example.com`) or a wildcard hostname expression
     *           (`*.example.com`) for a set of hostnames with common suffix. Used as
     *           Server Name Indication (SNI) for selecting a proper certificate.
     *     @type int $matcher
     *           A predefined matcher for particular cases, other than SNI selection.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $certificates
     *           A set of Certificates defines for the given `hostname`. There can be
     *           defined up to fifteen certificates in each Certificate Map Entry. Each
     *           certificate must match pattern `projects/&#42;&#47;locations/&#42;&#47;certificates/&#42;`.
     *     @type int $state
     *           Output only. A serving state of this Certificate Map Entry.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Certificatemanager\V1\CertificateManager::initOnce();
        parent::__construct($data);
    }

    /**
     * A user-defined name of the Certificate Map Entry. Certificate Map Entry
     * names must be unique globally and match pattern
     * `projects/&#42;&#47;locations/&#42;&#47;certificateMaps/&#42;&#47;certificateMapEntries/&#42;`.
     *
     * Generated from protobuf field <code>string name = 1;</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * A user-defined name of the Certificate Map Entry. Certificate Map Entry
     * names must be unique globally and match pattern
     * `projects/&#42;&#47;locations/&#42;&#47;certificateMaps/&#42;&#47;certificateMapEntries/&#42;`.
     *
     * Generated from protobuf field <code>string name = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * One or more paragraphs of text description of a certificate map entry.
     *
     * Generated from protobuf field <code>string description = 9;</code>
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * One or more paragraphs of text description of a certificate map entry.
     *
     * Generated from protobuf field <code>string description = 9;</code>
     * @param string $var
     * @return $this
     */
    public function setDescription($var)
    {
        GPBUtil::checkString($var, True);
        $this->description = $var;

        return $this;
    }

    /**
     * Output only. The creation timestamp of a Certificate Map Entry.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getCreateTime()
    {
        return $this->create_time;
    }

    public function hasCreateTime()
    {
        return isset($this->create_time);
    }

    public function clearCreateTime()
    {
        unset($this->create_time);
    }

    /**
     * Output only. The creation timestamp of a Certificate Map Entry.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setCreateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->create_time = $var;

        return $this;
    }

    /**
     * Output only. The update timestamp of a Certificate Map Entry.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getUpdateTime()
    {
        return $this->update_time;
    }

    public function hasUpdateTime()
    {
        return isset($this->update_time);
    }

    public function clearUpdateTime()
    {
        unset($this->update_time);
    }

    /**
     * Output only. The update timestamp of a Certificate Map Entry.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setUpdateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->update_time = $var;

        return $this;
    }

    /**
     * Set of labels associated with a Certificate Map Entry.
     *
     * Generated from protobuf field <code>map<string, string> labels = 4;</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getLabels()
    {
        return $this->labels;
    }

    /**
     * Set of labels associated with a Certificate Map Entry.
     *
     * Generated from protobuf field <code>map<string, string> labels = 4;</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setLabels($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::STRING);
        $this->labels = $arr;

        return $this;
    }

    /**
     * A Hostname (FQDN, e.g. `example.com`) or a wildcard hostname expression
     * (`*.example.com`) for a set of hostnames with common suffix. Used as
     * Server Name Indication (SNI) for selecting a proper certificate.
     *
     * Generated from protobuf field <code>string hostname = 5;</code>
     * @return string
     */
    public function getHostname()
    {
        return $this->readOneof(5);
    }

    public function hasHostname()
    {
        return $this->hasOneof(5);
    }

    /**
     * A Hostname (FQDN, e.g. `example.com`) or a wildcard hostname expression
     * (`*.example.com`) for a set of hostnames with common suffix. Used as
     * Server Name Indication (SNI) for selecting a proper certificate.
     *
     * Generated from protobuf field <code>string hostname = 5;</code>
     * @param string $var
     * @return $this
     */
    public function setHostname($var)
    {
        GPBUtil::checkString($var, True);
        $this->writeOneof(5, $var);

        return $this;
    }

    /**
     * A predefined matcher for particular cases, other than SNI selection.
     *
     * Generated from protobuf field <code>.google.cloud.certificatemanager.v1.CertificateMapEntry.Matcher matcher = 10;</code>
     * @return int
     */
    public function getMatcher()
    {
        return $this->readOneof(10);
    }

    public function hasMatcher()
    {
        return $this->hasOneof(10);
    }

    /**
     * A predefined matcher for particular cases, other than SNI selection.
     *
     * Generated from protobuf field <code>.google.cloud.certificatemanager.v1.CertificateMapEntry.Matcher matcher = 10;</code>
     * @param int $var
     * @return $this
     */
    public function setMatcher($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\CertificateManager\V1\CertificateMapEntry\Matcher::class);
        $this->writeOneof(10, $var);

        return $this;
    }

    /**
     * A set of Certificates defines for the given `hostname`. There can be
     * defined up to fifteen certificates in each Certificate Map Entry. Each
     * certificate must match pattern `projects/&#42;&#47;locations/&#42;&#47;certificates/&#42;`.
     *
     * Generated from protobuf field <code>repeated string certificates = 7 [(.google.api.resource_reference) = {</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getCertificates()
    {
        return $this->certificates;
    }

    /**
     * A set of Certificates defines for the given `hostname`. There can be
     * defined up to fifteen certificates in each Certificate Map Entry. Each
     * certificate must match pattern `projects/&#42;&#47;locations/&#42;&#47;certificates/&#42;`.
     *
     * Generated from protobuf field <code>repeated string certificates = 7 [(.google.api.resource_reference) = {</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setCertificates($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->certificates = $arr;

        return $this;
    }

    /**
     * Output only. A serving state of this Certificate Map Entry.
     *
     * Generated from protobuf field <code>.google.cloud.certificatemanager.v1.ServingState state = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int
     */
    public function getState()
    {
        return $this->state;
    }

    /**
     * Output only. A serving state of this Certificate Map Entry.
     *
     * Generated from protobuf field <code>.google.cloud.certificatemanager.v1.ServingState state = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int $var
     * @return $this
     */
    public function setState($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\CertificateManager\V1\ServingState::class);
        $this->state = $var;

        return $this;
    }

    /**
     * @return string
     */
    public function getMatch()
    {
        return $this->whichOneof("match");
    }

}

